# The PEP 484 type hints stub file for the _render module.
#
# Generated by SIP 4.19.3.dev1705052245


import typing
import sip

from axioma_dynload import _core_plugin
from axioma_dynload import _core_geometry
from axioma_dynload import _core_sql
from axioma_dynload import _core_dp
from axioma_dynload import _core
from PyQt5 import QtPrintSupport
from PyQt5 import QtWidgets
from PyQt5 import QtGui
from PyQt5 import QtCore

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], sip.Buffer, int, None]


class LabelSection(int): ...
SectionArea = ... # type: LabelSection
SectionCurve = ... # type: LabelSection
SectionPoint = ... # type: LabelSection


class ThemeApplyStyleType(int): ...
Color = ... # type: ThemeApplyStyleType
Size = ... # type: ThemeApplyStyleType
All = ... # type: ThemeApplyStyleType


class Render(_core.Core):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def initialize(self) -> None: ...
    def geometryStyleManager(self) -> 'GeometryStyleManager': ...
    def styleService(self) -> 'StyleService': ...
    def renderSettingsManager(self) -> 'RenderSettingsManager': ...
    def createLayerForTableEditing(self, table: _core_dp.EditableTable) -> 'TableLayer': ...
    def createLayerForDataObject(self, dataObject: typing.Any) -> 'Layer': ...


class ViewportInterface(sip.wrapper):

    def isEmpty(self) -> bool: ...
    def isEqual(self, vp: 'ViewportInterface') -> bool: ...
    @typing.overload
    def mapToDevice(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @typing.overload
    def mapToDevice(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    @typing.overload
    def mapToScene(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QPointF: ...
    @typing.overload
    def mapToScene(self, rect: QtCore.QRectF) -> QtCore.QRectF: ...
    def setSceneRect(self, rect: QtCore.QRectF) -> None: ...
    def setDeviceRect(self, rect: QtCore.QRectF) -> None: ...
    def deviceUnitSize(self) -> QtCore.QSizeF: ...
    def setCenter(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def zoomOut(self, coef: float) -> None: ...
    def zoomIn(self, coef: float) -> None: ...
    def zoom(self) -> float: ...
    def deviceToSceneTransform(self) -> QtGui.QTransform: ...
    def sceneToDeviceTransform(self) -> QtGui.QTransform: ...
    def sceneRect(self) -> QtCore.QRectF: ...
    def deviceRect(self) -> QtCore.QRectF: ...


class Viewport(ViewportInterface):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, vp: 'Viewport') -> None: ...
    @typing.overload
    def __init__(self, deviceRect: QtCore.QRectF, sceneRect: QtCore.QRectF) -> None: ...

    def isEqual(self, vp: ViewportInterface) -> bool: ...
    def zoom(self) -> float: ...
    def deviceToSceneTransform(self) -> QtGui.QTransform: ...
    def sceneToDeviceTransform(self) -> QtGui.QTransform: ...
    def sceneRect(self) -> QtCore.QRectF: ...
    def deviceRect(self) -> QtCore.QRectF: ...


class MapViewport(ViewportInterface):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, deviceRect: QtCore.QRectF, sceneRect: QtCore.QRectF, cs: _cs.CoordSystem) -> None: ...
    @typing.overload
    def __init__(self, deviceRect: QtCore.QRectF, rect: _core_dp.GeoRect) -> None: ...
    @typing.overload
    def __init__(self, a0: 'MapViewport') -> None: ...

    def setUsingPseudoZoom(self, val: bool) -> None: ...
    def isUsingPseudoZoom(self) -> bool: ...
    def isLatLong(self) -> bool: ...
    def coeffYTransform(self, y: float) -> float: ...
    def isEqual(self, vp: ViewportInterface) -> bool: ...
    def deviceToSceneTransform(self) -> QtGui.QTransform: ...
    def sceneToDeviceTransform(self) -> QtGui.QTransform: ...
    def sceneRect(self) -> QtCore.QRectF: ...
    def deviceRect(self) -> QtCore.QRectF: ...
    def geoRect(self) -> _core_dp.GeoRect: ...
    def setCoordSystem(self, cs: _cs.CoordSystem) -> None: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def pseudoScale(self, dpi: int) -> float: ...
    def pseudoZoom(self) -> float: ...
    def scale(self, dpi: int) -> float: ...
    @typing.overload
    def setZoom(self, zoom: float) -> None: ...
    @typing.overload
    def setZoom(self, zoom: float, unit: _cs.LinearUnit) -> None: ...
    @typing.overload
    def zoom(self) -> float: ...
    @typing.overload
    def zoom(self, unit: _cs.LinearUnit) -> float: ...


class ContextInterface(sip.wrapper):

    @staticmethod
    def deviceDpi(dev: QtGui.QPaintDevice) -> float: ...
    def setDpi(self, dpi: float) -> None: ...
    def setPainter(self, painter: QtGui.QPainter) -> None: ...
    def deviceToSceneTransform(self) -> QtGui.QTransform: ...
    def sceneToDeviceTransform(self) -> QtGui.QTransform: ...
    def dpi(self) -> float: ...
    def viewport(self) -> ViewportInterface: ...
    def painter(self) -> QtGui.QPainter: ...


class Context(ContextInterface):

    @typing.overload
    def __init__(self, painter: QtGui.QPainter) -> None: ...
    @typing.overload
    def __init__(self, painter: QtGui.QPainter, viewport: Viewport, dpi: float) -> None: ...
    @typing.overload
    def __init__(self, painter: QtGui.QPainter, viewport: Viewport) -> None: ...
    @typing.overload
    def __init__(self, context: 'Context') -> None: ...

    def setDpi(self, dpi: float) -> None: ...
    def setPainter(self, painter: QtGui.QPainter) -> None: ...
    def dpi(self) -> float: ...
    def painter(self) -> QtGui.QPainter: ...
    def setViewport(self, viewport: Viewport) -> None: ...
    def viewportImpl(self) -> Viewport: ...
    def viewport(self) -> ViewportInterface: ...


class MapContext(ContextInterface):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, painter: QtGui.QPainter, viewport: MapViewport, dpi: float) -> None: ...
    @typing.overload
    def __init__(self, painter: QtGui.QPainter, viewport: MapViewport) -> None: ...
    @typing.overload
    def __init__(self, other: 'MapContext') -> None: ...

    def setLabelContainer(self, a0: typing.Any) -> None: ...
    def deviceRect(self) -> QtCore.QRectF: ...
    def sceneRect(self) -> QtCore.QRectF: ...
    def mapCoordSystem(self) -> _cs.CoordSystem: ...
    def scale(self) -> float: ...
    def setDpi(self, dpi: float) -> None: ...
    def setPainter(self, painter: QtGui.QPainter) -> None: ...
    def dpi(self) -> float: ...
    def painter(self) -> QtGui.QPainter: ...
    def setMapViewport(self, viewport: MapViewport) -> None: ...
    def mapViewport(self) -> MapViewport: ...
    def viewport(self) -> ViewportInterface: ...


class Style(_core_serializable.axioma.serialization.Serializable):

    @typing.overload
    def isEqual(self, style: 'Style') -> bool: ...
    @typing.overload
    def isEqual(self, style: 'Style') -> bool: ...
    def draw(self, geom: _core_geometry.Geometry, context: ContextInterface) -> None: ...


class GeometryWithStyle(sip.wrapper):

    geom = ... # type: typing.Any
    style = ... # type: typing.Any

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'GeometryWithStyle') -> None: ...

    def isValid(self) -> bool: ...


class StyleWithData(sip.wrapper):

    @typing.overload
    def __init__(self, style: typing.Any, data: typing.Any = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'StyleWithData') -> None: ...

    def data(self) -> typing.Any: ...
    def style(self) -> typing.Any: ...


class HasStyles(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'HasStyles') -> None: ...

    def usedStyles_impl(self) -> typing.List[StyleWithData]: ...
    def usedStyles(self) -> typing.Any: ...


class TableLayerHasStyles(HasStyles):

    @typing.overload
    def __init__(self, layer: 'TableLayer') -> None: ...
    @typing.overload
    def __init__(self, a0: 'TableLayerHasStyles') -> None: ...

    def usedStyles(self) -> typing.List[StyleWithData]: ...


class Unit(sip.wrapper):

    @staticmethod
    def inch() -> 'Unit': ...
    @staticmethod
    def point() -> 'Unit': ...
    @staticmethod
    def cm() -> 'Unit': ...
    @staticmethod
    def mm() -> 'Unit': ...
    @staticmethod
    def pixel() -> 'Unit': ...
    @staticmethod
    def unitById(id: str) -> 'Unit': ...
    @staticmethod
    def units() -> typing.Any: ...
    def canConvertTo(self, unit: 'Unit') -> bool: ...
    def conversion(self, unit: 'Unit') -> float: ...
    def toDeviceUnits(self, value: float, dpi: int) -> float: ...
    def fromDeviceUnits(self, value: float, dpi: int) -> float: ...
    def name(self) -> str: ...
    def id(self) -> str: ...


class UnitSize(sip.wrapper):

    @typing.overload
    def __init__(self, unit: Unit, value: QtCore.QSizeF) -> None: ...
    @typing.overload
    def __init__(self, unit: Unit, value: float) -> None: ...

    @typing.overload
    def convertedTo(self, unit: Unit) -> 'UnitSize': ...
    @typing.overload
    def convertedTo(self, unit: Unit, dpi: int) -> 'UnitSize': ...
    def setWidth(self, w: float) -> None: ...
    def width(self) -> float: ...
    def setHeight(self, h: float) -> None: ...
    def height(self) -> float: ...
    def toDeviceUnits(self, dpi: int) -> QtCore.QSizeF: ...
    def value(self) -> QtCore.QSizeF: ...
    def unit(self) -> Unit: ...


class PointStyle(Style):

    def unitSize(self) -> UnitSize: ...
    def setUnitSize(self, unitSize: UnitSize) -> None: ...


class ColoredStyle(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ColoredStyle') -> None: ...

    def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def color(self) -> QtGui.QColor: ...


class OgrStyle(sip.wrapper):

    def toOgrString(self) -> str: ...


class PointStyleSimple(PointStyle, ColoredStyle, OgrStyle):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'PointStyleSimple') -> None: ...

    def toOgrString(self) -> str: ...
    def unitSize(self) -> UnitSize: ...
    def setUnitSize(self, unitSize: UnitSize) -> None: ...
    def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def color(self) -> QtGui.QColor: ...


class HasStylesMapcatalog(HasStyles):

    def __init__(self, table: _core_dp.Table) -> None: ...

    def usedStyles(self) -> typing.List[StyleWithData]: ...


class UnitValue(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, unit: Unit, value: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'UnitValue') -> None: ...

    @typing.overload
    def convertedTo(self, unit: Unit) -> 'UnitValue': ...
    @typing.overload
    def convertedTo(self, unit: Unit, dpi: int) -> 'UnitValue': ...
    def toDeviceUnits(self, dpi: int) -> float: ...
    def setValue(self, v: float) -> None: ...
    def value(self) -> float: ...
    def unit(self) -> Unit: ...


class LineStringStyle(Style):

    def width(self) -> UnitValue: ...


class LineStringStyleSimple(LineStringStyle, ColoredStyle, OgrStyle):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'LineStringStyleSimple') -> None: ...

    def toOgrString(self) -> str: ...
    def setWidth(self, width: UnitValue) -> None: ...
    def width(self) -> UnitValue: ...
    def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def color(self) -> QtGui.QColor: ...


class PolygonFillStyle(Style, ColoredStyle): ...


class PolygonStyle(Style):

    def areaStyle(self) -> typing.Any: ...
    def setAreaStyle(self, area: typing.Any) -> None: ...
    def peripheryStyle(self) -> typing.Any: ...
    def setPeripheryStyle(self, periphery: typing.Any) -> None: ...


class PolygonFillStyleSimple(PolygonStyle, OgrStyle):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, fillColor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], outlineColor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'PolygonFillStyleSimple') -> None: ...

    def toOgrString(self) -> str: ...
    def setPenWidth(self, width: UnitValue) -> None: ...
    def penWidth(self) -> UnitValue: ...
    def setPenColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def penColor(self) -> QtGui.QColor: ...
    def setBgColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def bgColor(self) -> QtGui.QColor: ...
    def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def color(self) -> QtGui.QColor: ...


class GeometryStyleClass(sip.wrapper):

    def name(self) -> str: ...
    def defaultModifiedObjectStyle(self) -> Style: ...
    def defaultOverrideStyle(self) -> Style: ...
    def defaultSelectionStyle(self) -> Style: ...
    def sampleGeometry(self, rect: QtCore.QRectF) -> _core_geometry.Geometry: ...
    def hasGeometry(self, geom: _core_geometry.Geometry) -> bool: ...
    def class_id(self) -> str: ...


class GeometryStyleClassExtension(_core_plugin.Extension):

    def geometryStyleClass(self) -> GeometryStyleClass: ...


class PolygonalGeometryClass(GeometryStyleClass):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'PolygonalGeometryClass') -> None: ...

    def name(self) -> str: ...
    def defaultModifiedObjectStyle(self) -> Style: ...
    def defaultOverrideStyle(self) -> Style: ...
    def defaultSelectionStyle(self) -> Style: ...
    def sampleGeometry(self, rect: QtCore.QRectF) -> _core_geometry.Geometry: ...
    def hasGeometry(self, geom: _core_geometry.Geometry) -> bool: ...
    def class_id(self) -> str: ...


class LinearGeometryClass(GeometryStyleClass):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'LinearGeometryClass') -> None: ...

    def name(self) -> str: ...
    def defaultModifiedObjectStyle(self) -> Style: ...
    def defaultOverrideStyle(self) -> Style: ...
    def defaultSelectionStyle(self) -> Style: ...
    def sampleGeometry(self, rect: QtCore.QRectF) -> _core_geometry.Geometry: ...
    def hasGeometry(self, geom: _core_geometry.Geometry) -> bool: ...
    def class_id(self) -> str: ...


class PointGeometryClass(GeometryStyleClass):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'PointGeometryClass') -> None: ...

    def name(self) -> str: ...
    def defaultModifiedObjectStyle(self) -> Style: ...
    def defaultOverrideStyle(self) -> Style: ...
    def defaultSelectionStyle(self) -> Style: ...
    def sampleGeometry(self, rect: QtCore.QRectF) -> _core_geometry.Geometry: ...
    def hasGeometry(self, geom: _core_geometry.Geometry) -> bool: ...
    def class_id(self) -> str: ...


class MultiGeometryClass(GeometryStyleClass):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'MultiGeometryClass') -> None: ...

    def name(self) -> str: ...
    def defaultModifiedObjectStyle(self) -> Style: ...
    def defaultOverrideStyle(self) -> Style: ...
    def defaultSelectionStyle(self) -> Style: ...
    def sampleGeometry(self, rect: QtCore.QRectF) -> _core_geometry.Geometry: ...
    def hasGeometry(self, geom: _core_geometry.Geometry) -> bool: ...
    def class_id(self) -> str: ...


class ClassStylePair(sip.wrapper):

    geomStyle = ... # type: GeometryStyleClass
    style = ... # type: Style

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ClassStylePair') -> None: ...


class CollectionStyle(Style):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, classStyleList: typing.Any) -> None: ...

    @typing.overload
    def setStyle(self, geometryStyleClass: GeometryStyleClass, style: Style) -> None: ...
    @typing.overload
    def setStyle(self, geomClassId: str, style: Style) -> None: ...
    @typing.overload
    def setStyle(self, style: Style) -> None: ...
    @typing.overload
    def style(self, geometry: _core_geometry.Geometry) -> Style: ...
    @typing.overload
    def style(self, geometryClassId: str) -> Style: ...
    @typing.overload
    def style(self, geometryClass: GeometryStyleClass) -> Style: ...
    def classStylePairs(self) -> typing.List[ClassStylePair]: ...


class StyleExtension(_core_plugin.Extension):

    def showInGui(self) -> bool: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...
    def geometryStyleClassId(self) -> str: ...
    def styleId(self) -> str: ...
    def createStyle(self) -> Style: ...


class FeatureStyleProvider(sip.wrapper):

    def requiredAttributes(self) -> typing.List[str]: ...
    def style(self, feature: _core_dp.Feature, context: MapContext) -> typing.Any: ...


class StyleCollectionProvider(FeatureStyleProvider):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, collectionStyle: CollectionStyle) -> None: ...
    @typing.overload
    def __init__(self, a0: 'StyleCollectionProvider') -> None: ...

    def setCollectionStyle(self, collectionStyle: CollectionStyle) -> None: ...
    def collectionStyle(self) -> CollectionStyle: ...
    def requiredAttributes(self) -> typing.List[str]: ...


class StyleService(QtCore.QObject):

    def __init__(self) -> None: ...

    def newObjectStyle(self) -> CollectionStyle: ...
    def defaultSelectionTransparency(self) -> float: ...
    def setSelectionTransparency(self, transparency: float) -> None: ...
    def selectionTransparency(self) -> float: ...
    def defaultOverrideStyle(self) -> CollectionStyle: ...
    def defaultModifiedObjectStyle(self) -> CollectionStyle: ...
    def defaultSelectionStyle(self) -> CollectionStyle: ...
    def overrideStyleProvider(self) -> StyleCollectionProvider: ...
    def modifiedObjectStyleProvider(self) -> StyleCollectionProvider: ...
    def selectionStyleProvider(self) -> StyleCollectionProvider: ...
    def saveSettings(self, settings: QtCore.QSettings) -> None: ...
    def loadSettings(self, settings: QtCore.QSettings) -> None: ...


class GeometryStyleManager(QtCore.QObject):

    def styleExtensionByStyle(self, style: Style) -> StyleExtension: ...


class TextRenderer(sip.wrapper):

    class ResizeOption(int): ...
    KeepHeight = ... # type: 'TextRenderer.ResizeOption'
    KeepWidth = ... # type: 'TextRenderer.ResizeOption'

    class BackgroundType(int): ...
    None = ... # type: 'TextRenderer.BackgroundType'
    Outline = ... # type: 'TextRenderer.BackgroundType'
    Frame = ... # type: 'TextRenderer.BackgroundType'

    class LineSpace(int): ...
    Single = ... # type: 'TextRenderer.LineSpace'
    OneAndHalf = ... # type: 'TextRenderer.LineSpace'
    Double = ... # type: 'TextRenderer.LineSpace'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, tr: 'TextRenderer') -> None: ...

    def setHaloWidthPercent(self, widthPercent: float) -> None: ...
    def setPointHaloWidth(self, width: float) -> None: ...
    @typing.overload
    def pointHaloWidth(self, pointHeight: float) -> float: ...
    @typing.overload
    def pointHaloWidth(self) -> float: ...
    def pointHaloWidthDevice(self, dpi: float) -> float: ...
    @typing.overload
    def pixelHaloWidth(self, pixelHeight: float) -> float: ...
    @typing.overload
    def pixelHaloWidth(self) -> float: ...
    @typing.overload
    def pixelHaloWidthDevice(self, pixelHeight: float, dpi: float) -> float: ...
    @typing.overload
    def pixelHaloWidthDevice(self, dpi: float) -> float: ...
    def textSize(self, text: str) -> QtCore.QSizeF: ...
    def textBackground(self) -> 'TextRenderer.BackgroundType': ...
    def enableShadow(self, value: bool = ...) -> None: ...
    def setLetterSpacing(self, letterSpacing: bool) -> None: ...
    def setCapital(self, capital: bool) -> None: ...
    def setBackgroundType(self, type: 'TextRenderer.BackgroundType') -> None: ...
    def setAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def setLineSpace(self, linespace: 'TextRenderer.LineSpace') -> None: ...
    def setShadowColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def setBackgroundColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def setColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def shadowOffset(self) -> QtCore.QSizeF: ...
    def hasShadow(self) -> bool: ...
    def letterSpacing(self) -> bool: ...
    def capital(self) -> bool: ...
    def shadowColor(self) -> QtGui.QColor: ...
    def color(self) -> QtGui.QColor: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def alignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def lineSpace(self) -> 'TextRenderer.LineSpace': ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def font(self) -> QtGui.QFont: ...
    @typing.overload
    def draw(self, text: str, context: ContextInterface, rect: QtCore.QRectF, angle: float = ...) -> None: ...
    @typing.overload
    def draw(self, text: str, context: ContextInterface, point: typing.Union[QtCore.QPointF, QtCore.QPoint], angle: float = ...) -> None: ...


class SymbolStyleData(sip.wrapper):

    color = ... # type: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    pointSize = ... # type: int
    symbol = ... # type: int

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'SymbolStyleData') -> None: ...


class FontStyleData(sip.wrapper):

    color = ... # type: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    font = ... # type: QtGui.QFont
    rotation = ... # type: float
    shadow = ... # type: bool
    symbol = ... # type: str

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'FontStyleData') -> None: ...


class PictureStyleData(sip.wrapper):

    applyColor = ... # type: bool
    color = ... # type: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    filename = ... # type: str
    showActualSize = ... # type: bool
    showBackground = ... # type: bool
    unitSize = ... # type: UnitSize

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'PictureStyleData') -> None: ...


class LineStyleData(sip.wrapper):

    color = ... # type: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    pattern = ... # type: int
    width = ... # type: UnitValue

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'LineStyleData') -> None: ...


class FillStyleData(sip.wrapper):

    bgColor = ... # type: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    color = ... # type: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    pattern = ... # type: int

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'FillStyleData') -> None: ...


class PolygonStyleData(sip.wrapper):

    areaStyleData = ... # type: FillStyleData
    peripheryStyleData = ... # type: LineStyleData

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'PolygonStyleData') -> None: ...


class TextStyleData(sip.wrapper):

    alignment = ... # type: QtCore.Qt.AlignmentFlag
    backgroundColor = ... # type: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    backgroundType = ... # type: TextRenderer.BackgroundType
    capitals = ... # type: bool
    color = ... # type: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    font = ... # type: QtGui.QFont
    letterSpacing = ... # type: bool
    lineSpace = ... # type: TextRenderer.LineSpace
    lineStyle = ... # type: LineStyleData
    shadow = ... # type: bool
    underline = ... # type: bool

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'TextStyleData') -> None: ...


class MapInfoStyleService(sip.wrapper):

    def defaultPolygonStyleData(self, fill: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], outline: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> PolygonStyleData: ...
    def defaultFillStyleData(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> FillStyleData: ...
    def defaultLineStyleData(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> LineStyleData: ...
    def defaultFontStyleData(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> FontStyleData: ...
    def createTextStyleData(self, textStyle: Style) -> TextStyleData: ...
    def createPolygonStyleData(self, polygonStyle: Style) -> PolygonStyleData: ...
    def createFillStyleData(self, fillStyle: PolygonFillStyle) -> FillStyleData: ...
    def createLineStyleData(self, lineStyle: LineStringStyle) -> LineStyleData: ...
    def createSymbolData(self, symbolStyle: PointStyle) -> SymbolStyleData: ...
    def createPictureData(self, picturelStyle: PointStyle) -> PictureStyleData: ...
    def createFontData(self, fontStyle: PointStyle) -> FontStyleData: ...
    def stringFromStyle(self, style: typing.Any) -> str: ...
    def styleFromString(self, rendstr: str) -> Style: ...
    @typing.overload
    def createMapInfoTextStyle(self, textData: TextStyleData) -> Style: ...
    @typing.overload
    def createMapInfoTextStyle(self, font: QtGui.QFont, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], backgroundColor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], backgroundType: TextRenderer.BackgroundType, lineSpace: TextRenderer.LineSpace, lineStyle: typing.Any, alignment: QtCore.Qt.AlignmentFlag, letterSpacing: bool, capitals: bool, shadow: bool, underline: bool) -> Style: ...
    @typing.overload
    def createMapInfoPolygonStyle(self, polygonData: PolygonStyleData) -> Style: ...
    @typing.overload
    def createMapInfoPolygonStyle(self, linePattern: int, lineColor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], lineWidth: UnitValue, areaPattern: int, areaColor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], areaBgColor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> Style: ...
    @typing.overload
    def createLineStringStyle(self, lineData: LineStyleData) -> LineStringStyle: ...
    @typing.overload
    def createLineStringStyle(self, pattern: int, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], width: UnitValue) -> LineStringStyle: ...
    @typing.overload
    def createPointStyle(self, fontData: FontStyleData) -> PointStyle: ...
    @typing.overload
    def createPointStyle(self, font: QtGui.QFont, symbol: str, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], rotation: float, shadow: bool) -> PointStyle: ...
    @typing.overload
    def createPointStyle(self, symbol: int, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], pointSize: int) -> PointStyle: ...
    @typing.overload
    def createPointStyle(self, pictureData: PictureStyleData) -> PointStyle: ...
    @typing.overload
    def createPointStyle(self, unitSize: UnitSize, filename: str, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], showBackground: bool, applyColor: bool, showActualSize: bool) -> PointStyle: ...


class ArrayStyle(Style):

    def __init__(self, key: str, style: Style) -> None: ...

    def style(self, key: str) -> Style: ...
    def keys(self) -> typing.List[str]: ...
    def setActiveStyle(self, key: str) -> bool: ...
    def activeStyle(self) -> Style: ...
    def activeKey(self) -> str: ...
    def count(self) -> int: ...
    def exist(self, key: str) -> bool: ...
    def remove(self, key: str) -> bool: ...
    def setStyle(self, key: str, style: Style) -> None: ...


class StyleCatalogService(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def changed(self) -> None: ...
    def defaultSymbolDir(self) -> str: ...
    def defaultBrushDir(self) -> str: ...
    def defaultPenDir(self) -> str: ...
    def symbolCatalog(self, baseDir: str = ...) -> str: ...
    def brushCatalog(self, baseDir: str = ...) -> str: ...
    def penCatalog(self, baseDir: str = ...) -> str: ...
    def setSymbolCatalog(self, dirName: str = ...) -> bool: ...
    def setBrushCatalog(self, dirName: str = ...) -> bool: ...
    def setPenCatalog(self, dirName: str = ...) -> bool: ...
    def resetToDefault(self) -> None: ...
    def setBaseCatalog(self, dir: QtCore.QDir) -> bool: ...


class CompositeStyle(Style):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'CompositeStyle') -> None: ...

    def isEmpty(self) -> bool: ...
    def count(self) -> int: ...
    def styles(self) -> list[Style]: ...
    def swap(self, index1: int, index2: int) -> bool: ...
    def remove(self, index: int) -> bool: ...
    def replace(self, index: int, style: Style) -> bool: ...
    def append(self, style: Style) -> None: ...


class MapProperties(_core_serializable.axioma.serialization.Serializable):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'MapProperties') -> None: ...

    def setMapUnits(self, mapUnits: _cs.MapUnits) -> None: ...
    def mapUnits(self) -> _cs.MapUnits: ...
    def setFollowSelection(self, val: bool) -> None: ...
    def followSelection(self) -> bool: ...
    def areaUnit(self) -> _cs.LinearUnit: ...
    def setAreaUnit(self, areaUnit: _cs.LinearUnit) -> None: ...
    def distanceUnit(self) -> _cs.LinearUnit: ...
    def setDistanceUnit(self, distanceUnit: _cs.LinearUnit) -> None: ...
    def coordinateUnit(self) -> _cs.LinearUnit: ...
    def setCoordinateUnit(self, coordinateUnit: _cs.LinearUnit) -> None: ...


class Map(QtCore.QObject):

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, layers: typing.Any, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def editableLayerChanging(self, oldLayer: 'Layer') -> None: ...
    def editableLayerChanged(self) -> None: ...
    def visibilityChanged(self) -> None: ...
    def needRedraw(self) -> None: ...
    def labelContainer(self) -> 'FeatureLabelContainer': ...
    def setMapProperties(self, mapProperties: MapProperties) -> None: ...
    def mapProperties(self) -> typing.Any: ...
    def flatLayerList(self) -> typing.List['Layer']: ...
    def setEditableLayer(self, layer: 'Layer') -> None: ...
    def editableLayer(self) -> 'Layer': ...
    def canRenderAllLayersInCS(self, cs: _cs.CoordSystem) -> bool: ...
    def boundingRect(self, cs: _cs.CoordSystem) -> _core_dp.GeoRect: ...
    def findBestCoordSys(self) -> _cs.CoordSystem: ...
    def rootLayerGroup(self) -> 'RootLayerGroup': ...


class MapItem(QtCore.QObject):

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'MapItem') -> None: ...

    def propertiesChanged(self) -> None: ...
    def mapItemDestroyed(self, mapItem: 'MapItem') -> None: ...
    def dataChanged(self) -> None: ...
    def needRedraw(self, layer: 'Layer') -> None: ...
    def visibilityChanged(self, item: 'MapItem') -> None: ...
    @staticmethod
    def findMap(item: 'MapItem') -> Map: ...
    def setProperties(self, mapItemProperties: 'MapItemProperties') -> None: ...
    def mapItemProperties(self) -> 'MapItemProperties': ...
    def map(self) -> Map: ...
    def isVisible(self, viewport: MapViewport) -> bool: ...
    def setRenderable(self, val: bool) -> None: ...
    def renderable(self) -> bool: ...
    def contentType(self) -> _core_dp.ContentType: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...


class Layer(MapItem):

    @typing.overload
    def __init__(self, dataObject: typing.Any, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'Layer') -> None: ...

    def canBeEditable_impl(self, op: _core_dp.TypeOper) -> bool: ...
    @staticmethod
    def makeGeometryTransform(context: MapContext, coordSystem: typing.Any) -> typing.Any: ...
    def layerIcon(self) -> QtGui.QIcon: ...
    def dataObject(self) -> typing.Any: ...
    def setSelectableFlag(self, val: bool) -> None: ...
    def selectableFlag(self) -> bool: ...
    def selectable(self) -> bool: ...
    def canBeEditable(self, op: _core_dp.TypeOper = ...) -> bool: ...
    def canBeSelectable(self) -> bool: ...
    def boundingRect(self) -> _core_dp.GeoRect: ...
    def canRenderInCS(self, cs: _cs.CoordSystem) -> bool: ...
    @typing.overload
    def deviceUnitSize(self, context: MapContext) -> QtCore.QSizeF: ...
    @typing.overload
    def deviceUnitSize(self, viewport: ViewportInterface, csMap: _cs.CoordSystem) -> QtCore.QSizeF: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def renderVector(self, context: MapContext) -> None: ...
    def render(self, context: MapContext) -> None: ...


class MapItemProperties(_core_serializable.axioma.serialization.Serializable):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'MapItemProperties') -> None: ...

    def setVisibilityConstraints(self, vc: 'VisibilityConstraints') -> None: ...
    def visibilityConstraints(self) -> 'VisibilityConstraints': ...


class LayerWithThematic(Layer):

    @typing.overload
    def __init__(self, dataObject: typing.Any, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'LayerWithThematic') -> None: ...

    def overriddenByThematic(self, vp: MapViewport) -> bool: ...
    def createLegendsList(self) -> typing.Any: ...
    def appendLayer(self, layer: 'ThematicLayer') -> None: ...
    def prependLayer(self, layer: 'ThematicLayer') -> None: ...
    def thematicLayerGroup(self) -> 'LayerGroup': ...


class FeatureLayer(LayerWithThematic):

    def __init__(self, dataObject: typing.Any, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    @staticmethod
    def makeGeometryTransform(context: MapContext, geoDef: _core_dp.GeometryAttributeDefinitionInterface) -> _core_geometry.GeometryTransform: ...
    def layerIcon(self) -> QtGui.QIcon: ...
    def featureLayerProperties(self) -> 'FeatureLayerProperties': ...
    def canRenderInCS(self, cs: _cs.CoordSystem) -> bool: ...
    def drawFeatureProperties(self, geometry: _core_geometry.Geometry, properties: 'FeatureLayerProperties', context: MapContext) -> None: ...
    def drawFeatures(self, cx: MapContext, cursor: _core_dp.Cursor, styleProvider: FeatureStyleProvider, geomAttr: str, layerProperties: 'FeatureLayerProperties' = ...) -> None: ...
    def geometryAttributeName(self) -> str: ...
    def featureStyleProvider_impl(self, context: MapContext) -> FeatureStyleProvider: ...
    def featureStyleProvider(self, context: MapContext) -> FeatureStyleProvider: ...
    def visibleFeatures(self, georect: _core_dp.GeoRect, attributes: typing.Iterable[str]) -> typing.Any: ...


class TableLayer(FeatureLayer):

    @typing.overload
    def __init__(self, table: typing.Any, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'TableLayer') -> None: ...

    def canBeEditable_impl(self, op: _core_dp.TypeOper) -> bool: ...
    def hasModified(self) -> bool: ...
    def insertFeatures(self, features: typing.Any, description: str = ...) -> None: ...
    def deleteFeatures(self, features: typing.Any, description: str = ...) -> None: ...
    def updateFeatures(self, features: typing.Any, description: str = ...) -> None: ...
    def setExactMbrCalculation(self, timeout: int = ...) -> None: ...
    def isExactMbrCalculation(self) -> bool: ...
    def featuresInRect(self, rect: _core_dp.GeoRect, attributes: typing.Iterable[str]) -> typing.Any: ...
    @typing.overload
    def featuresById(self, idlist: typing.List[typing.Any], attributes: typing.Iterable[str]) -> typing.Any: ...
    @typing.overload
    def featuresById(self, idlist: typing.List[typing.Any]) -> typing.Any: ...
    def canBeSelectable(self) -> bool: ...
    def boundingRect(self) -> _core_dp.GeoRect: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def prepareCoordSystem(self, cs: typing.Any, outSchema: _core_dp.TableSchema) -> int: ...
    def contentType(self) -> _core_dp.ContentType: ...
    def geometryAttribute(self) -> _core_dp.GeometryAttributeDefinitionInterface: ...
    def tableSchema(self) -> _core_dp.TableSchema: ...
    def isReadOnly(self) -> bool: ...
    def sourceTable(self) -> typing.Any: ...
    def table(self) -> typing.Any: ...


class SimpleTableLayer(TableLayer):

    def __init__(self, table: typing.Any, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def geometryAttributeName(self) -> str: ...


class LayerGroup(MapItem):

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, lg: 'LayerGroup') -> None: ...

    def childCountChanged(self) -> None: ...
    def childItemDataChanged(self) -> None: ...
    def group(self, indexes: typing.Iterable[int]) -> None: ...
    def ungroup(self, group: 'LayerGroup') -> None: ...
    def moveDown(self, index: int) -> None: ...
    def moveUp(self, index: int) -> None: ...
    def childrenNamesList(self) -> typing.List[str]: ...
    def findChildByName(self, name: str) -> MapItem: ...
    def takeAt(self, index: int) -> MapItem: ...
    def childAt(self, index: int) -> MapItem: ...
    def moveChild(self, from_: int, to: int) -> None: ...
    def deleteChild(self, index: int) -> None: ...
    def deleteAllChildren(self) -> None: ...
    def removeItemAt(self, index: int) -> MapItem: ...
    def insert(self, item: MapItem) -> None: ...
    def append(self, child: MapItem) -> None: ...
    def insertChild(self, child: MapItem, index: int) -> None: ...
    def indexOf(self, child: MapItem) -> int: ...
    def childCount(self) -> int: ...
    def boundingRect(self, cs: _cs.CoordSystem) -> _core_dp.GeoRect: ...
    def canRenderInCs(self, cs: _cs.CoordSystem) -> bool: ...
    def flatLayerList(self) -> typing.List[Layer]: ...
    def contentType(self) -> _core_dp.ContentType: ...


class RootLayerGroup(LayerGroup):

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, sqliteFileName: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, cosmetic: TableLayer, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'RootLayerGroup') -> None: ...

    def cosmeticLayer(self) -> TableLayer: ...


class RasterLayerWithProperties(Layer):

    def __init__(self, dataObject: typing.Any, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    @staticmethod
    def applyRasterLayerProperties(image: QtGui.QImage, properties: typing.Any) -> None: ...
    @staticmethod
    def applyUniformProperties(image: QtGui.QImage, properties: typing.Any) -> None: ...
    def rasterLayerProperties(self) -> typing.Any: ...
    def contentType(self) -> _core_dp.ContentType: ...


class LayerProperties(MapItemProperties):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'LayerProperties') -> None: ...

    def opacity(self) -> int: ...
    def setOpacity(self, value: int) -> None: ...


class RasterLayerProperties(LayerProperties):

    MaxBrightnessContrastValue = ... # type: int
    MaxOpacityValue = ... # type: int
    MinBrightnessContrastValue = ... # type: int
    MinOpacityValue = ... # type: int

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'RasterLayerProperties') -> None: ...

    def isDefault(self) -> bool: ...
    def setImageOpacity(self, value: int) -> None: ...
    def imageOpacity(self) -> int: ...
    def transparentColor(self) -> int: ...
    def showUniformly(self) -> bool: ...
    def useTransparentColor(self) -> bool: ...
    def grayscale(self) -> bool: ...
    def contrast(self) -> int: ...
    def brightness(self) -> int: ...
    def setShowUniformly(self, value: bool) -> None: ...
    def setTransparentColor(self, color: int) -> None: ...
    def setUseTransparentColor(self, value: bool) -> None: ...
    def setGrayscale(self, value: bool) -> None: ...
    def setContrast(self, value: int) -> None: ...
    def setBrightness(self, value: int) -> None: ...


class RasterLayer(RasterLayerWithProperties):

    def __init__(self, rast: _core_dp.Raster, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def canBeEditable_impl(self, op: _core_dp.TypeOper) -> bool: ...
    def layerIcon(self) -> QtGui.QIcon: ...
    def raster(self) -> _core_dp.Raster: ...
    def boundingRect(self) -> _core_dp.GeoRect: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def canRenderInCS(self, cs: _cs.CoordSystem) -> bool: ...
    def canBeSelectable(self) -> bool: ...


class LegendItemComponent(sip.wrapper):

    @typing.overload
    def __init__(self, s: Style, descr: str) -> None: ...
    @typing.overload
    def __init__(self, other: 'LegendItemComponent') -> None: ...

    def setVisible(self, value: bool = ...) -> None: ...
    def isVisible(self) -> bool: ...
    def setDescriptionChanged(self, d: str) -> None: ...
    def setDescription(self, d: str) -> None: ...
    def description(self) -> str: ...
    def style(self) -> Style: ...


class LegendItem(QtCore.QObject):

    @typing.overload
    def __init__(self, caption: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, caption: str, overrideComponents: LegendItemComponent, parent: QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, item: 'LegendItem') -> None: ...

    def aboutToBeDestroyed(self) -> None: ...
    def updateComponent(self, index: int, component: LegendItemComponent) -> None: ...
    def styleItemAt(self, index: int) -> LegendItemComponent: ...
    def styleItems(self) -> typing.List[LegendItemComponent]: ...
    def moveItem(self, oldPos: int, newPos: int) -> None: ...
    def setDescriptionItem(self, index: int, value: str) -> None: ...
    def setVisibledItem(self, index: int, value: bool) -> None: ...
    def transform(self, transform: QtGui.QTransform) -> None: ...
    def space(self) -> int: ...
    def setNumberColumns(self, value: int) -> None: ...
    def numberColumns(self) -> int: ...
    def setBorderStyle(self, value: LineStringStyle) -> None: ...
    def borderStyle(self) -> LineStringStyle: ...
    def setBasePoint(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def basePoint(self) -> QtCore.QPointF: ...
    def setTextRenderSubCaption(self, value: TextRenderer) -> None: ...
    def textRenderSubCaption(self) -> TextRenderer: ...
    def setTextRenderCaption(self, value: TextRenderer) -> None: ...
    def textRenderCaption(self) -> TextRenderer: ...
    def setSubCaption(self, value: str) -> None: ...
    def subCaption(self) -> str: ...
    def setCaption(self, value: str) -> None: ...
    def caption(self) -> str: ...
    def setTextRender(self, value: TextRenderer) -> None: ...
    def textRender(self) -> TextRenderer: ...
    def setBaseSizeStyleElement(self, value: QtCore.QSize) -> None: ...
    def baseSizeStyleElement(self) -> QtCore.QSize: ...
    def name(self) -> str: ...
    @typing.overload
    def drawSelected(self, context: ContextInterface) -> None: ...
    @typing.overload
    def drawSelected(self, context: ContextInterface, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    @typing.overload
    def draw(self, context: ContextInterface) -> None: ...
    @typing.overload
    def draw(self, context: ContextInterface, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def refreshStyleItems(self) -> None: ...
    @typing.overload
    def rect(self) -> QtCore.QRectF: ...
    @typing.overload
    def rect(self, pos: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> QtCore.QRectF: ...


class DynamicSizeLegendItem(sip.wrapper):

    def calculateSizeForContext(self, context: ContextInterface) -> None: ...


class HasStatisticLegendItem(sip.wrapper):

    def setVisibledStatistic(self, v: bool) -> None: ...
    def isVisibledStatistic(self) -> bool: ...


class ThematicStyleProvider(_core_serializable.axioma.serialization.Serializable, FeatureStyleProvider):

    @typing.overload
    def __init__(self, layer: 'ThematicLayer') -> None: ...
    @typing.overload
    def __init__(self, other: 'ThematicStyleProvider') -> None: ...

    def setApplyStyleType(self, applyType: ThemeApplyStyleType) -> None: ...
    def applyStyleType(self) -> ThemeApplyStyleType: ...
    def createLegendPreview(self) -> typing.Any: ...
    def isEmpty(self) -> bool: ...
    def layer(self) -> 'ThematicLayer': ...
    def setLayer(self, layer: 'ThematicLayer') -> None: ...


class ThematicLayer(FeatureLayer):

    def __init__(self, parent: typing.Optional[FeatureLayer] = ...) -> None: ...

    def createLegend_impl(self, parent: QtCore.QObject) -> 'ThematicLegendItem': ...
    def styleProvider_common(self) -> ThematicStyleProvider: ...
    def canBeEditable_impl(self, op: _core_dp.TypeOper) -> bool: ...
    def floatPrecision(self) -> int: ...
    def legendItem(self) -> 'ThematicLegendItem': ...
    def createLegend(self) -> 'ThematicLegendItem': ...
    def setParentLayer(self, parent: FeatureLayer) -> None: ...
    def parentLayer(self) -> FeatureLayer: ...
    def boundingRect(self) -> _core_dp.GeoRect: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def canRenderInCS(self, cs: _cs.CoordSystem) -> bool: ...
    def styleAttributeName(self) -> str: ...
    def geometryAttributeName(self) -> str: ...
    def visibleFeatures(self, georect: _core_dp.GeoRect, attributes: typing.Iterable[str]) -> _core_dp.Cursor: ...
    def canBeSelectable(self) -> bool: ...


class ReportItem(QtCore.QObject):

    def __init__(self, report: 'Report') -> None: ...

    def aboutToBeDestroyed(self) -> None: ...
    def needRedraw(self, a0: QtCore.QRectF) -> None: ...
    def setBorderStyle(self, borderStyle: LineStringStyle) -> None: ...
    def borderStyle(self) -> LineStringStyle: ...
    def setParentId(self, value: typing.Any) -> None: ...
    def parentId(self) -> typing.Any: ...
    def setId(self, value: typing.Any) -> None: ...
    def id(self) -> typing.Any: ...
    def report(self) -> 'Report': ...
    def canScale(self) -> bool: ...
    def canRotate(self) -> bool: ...
    def drawSelected(self, context: ContextInterface) -> None: ...
    def intersects(self, rect: QtCore.QRectF) -> bool: ...
    def name(self) -> str: ...
    def transform(self, transform: QtGui.QTransform) -> None: ...
    def setRect(self, rect: QtCore.QRectF) -> None: ...
    def rect(self) -> QtCore.QRectF: ...
    def draw(self, context: ContextInterface) -> None: ...


class Report(QtCore.QObject):

    class ReportItemWithContext(sip.wrapper):

        context = ... # type: ContextImpl
        item = ... # type: ReportItem

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'Report.ReportItemWithContext') -> None: ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def needRedrawItem(self, a0: QtCore.QRectF) -> None: ...
    def progress(self, value: int, total: int) -> None: ...
    def dpiPrinter(self) -> int: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def fillOnPages(self) -> bool: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...
    def sizePage(self) -> QtCore.QSizeF: ...
    def unit(self) -> Unit: ...
    def setVerticalPageCount(self, v: int) -> None: ...
    def verticalPageCount(self) -> int: ...
    def setHorisontalPagesCount(self, v: int) -> None: ...
    def horisontalPagesCount(self) -> int: ...
    def setHorizontalPagesCount(self, v: int) -> None: ...
    def horizontalPagesCount(self) -> int: ...
    @typing.overload
    def render(self, context: ContextInterface, excludes: typing.Any = ..., pages: typing.Iterable[int] = ...) -> None: ...
    @typing.overload
    def render(self, items: typing.Any) -> None: ...
    def rect(self) -> QtCore.QRectF: ...
    def rectContents(self) -> QtCore.QRectF: ...
    def backItem(self) -> ReportItem: ...
    def frontItem(self) -> ReportItem: ...
    def at(self, index: int) -> ReportItem: ...
    def items(self) -> typing.Any: ...
    def index(self, item: ReportItem) -> int: ...
    def insertItem(self, item: ReportItem, index: int) -> None: ...
    def moveItem(self, item: ReportItem, index: int) -> None: ...
    @typing.overload
    def removeItem(self, index: int) -> None: ...
    @typing.overload
    def removeItem(self, item: ReportItem) -> None: ...
    def addItem(self, item: ReportItem) -> None: ...
    def count(self) -> int: ...
    def setOptions(self, printer: QtPrintSupport.QPrinter) -> None: ...


class LegendItemPosition(QtCore.QObject):

    @typing.overload
    def __init__(self, parent: QtCore.QObject, item: LegendItem, pos: typing.Union[QtCore.QPointF, QtCore.QPoint] = ...) -> None: ...
    @typing.overload
    def __init__(self, lip: 'LegendItemPosition') -> None: ...

    def updateItemContext(self) -> None: ...
    def updateItem(self) -> None: ...
    def draw(self, context: ContextInterface) -> None: ...
    def rect(self) -> QtCore.QRectF: ...
    def item(self) -> LegendItem: ...
    def setBasePoint(self, basePoint: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def basePoint(self) -> QtCore.QPointF: ...


class LegendItemGroup(QtCore.QObject):

    npos = ... # type: int

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def itemAppened(self, item: LegendItemPosition) -> None: ...
    def needUpdating(self) -> None: ...
    def removedItem(self, a0: LegendItem) -> None: ...
    def aboutToBeDestroyed(self) -> None: ...
    def calculateSizeForContext(self, context: ContextInterface) -> None: ...
    def findItemIndexByName(self, name: str) -> int: ...
    def count(self) -> int: ...
    def itemIndex(self, item: LegendItemPosition) -> int: ...
    def replace(self, ind: int, item: LegendItem) -> None: ...
    @typing.overload
    def append(self, item: LegendItem) -> None: ...
    @typing.overload
    def append(self, items: typing.Iterable[LegendItem]) -> None: ...
    def at(self, i: int) -> LegendItemPosition: ...
    def removeAll(self, item: LegendItemPosition) -> int: ...
    def items(self) -> typing.Any: ...
    def name(self) -> str: ...
    def setName(self, name: str) -> None: ...
    def drawSelected(self, item: LegendItem, context: ContextInterface) -> None: ...
    def draw(self, context: ContextInterface) -> None: ...
    def rect(self) -> QtCore.QRectF: ...


class LabelRenderer(sip.wrapper):

    def __init__(self) -> None: ...

    def renderLabels(self, map: Map, ctx: MapContext) -> None: ...


class GeoPdfWriter(QtCore.QObject):

    class CompressMethod(int): ...
    CM_NONE = ... # type: 'GeoPdfWriter.CompressMethod'
    CM_DEFLATE = ... # type: 'GeoPdfWriter.CompressMethod'
    CM_JPEG = ... # type: 'GeoPdfWriter.CompressMethod'
    CM_JPEG2000 = ... # type: 'GeoPdfWriter.CompressMethod'

    def __init__(self, map: Map, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setDpi(self, dpi: float) -> None: ...
    def setCompressMethod(self, method: 'GeoPdfWriter.CompressMethod') -> None: ...
    @staticmethod
    def compressByName(method: str) -> 'GeoPdfWriter.CompressMethod': ...
    def write(self, filename: str, viewport: MapViewport, exportAttributes: bool = ...) -> None: ...


class MapItemVisitor(sip.wrapper):

    @typing.overload
    def visit(self, layer: Layer) -> None: ...
    @typing.overload
    def visit(self, layerGroup: LayerGroup) -> None: ...
    @typing.overload
    def visit(self, root: RootLayerGroup) -> None: ...


class VisibleLayerVisitor(MapItemVisitor):

    @typing.overload
    def visit(self, layer: Layer) -> None: ...
    @typing.overload
    def visit(self, layerGroup: LayerGroup) -> None: ...
    @typing.overload
    def visit(self, root: RootLayerGroup) -> None: ...


class AutomaticColorMode(_core_serializable.axioma.serialization.Serializable):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, count: int) -> None: ...
    @typing.overload
    def __init__(self, a0: 'AutomaticColorMode') -> None: ...

    def setColorCount(self, count: int) -> None: ...
    def colorCount(self) -> int: ...
    def generateColor(self, idx: int) -> QtGui.QColor: ...


class RainbowColorMode(AutomaticColorMode):

    class OrderType(int): ...
    RandomOrder = ... # type: 'RainbowColorMode.OrderType'
    SequentialOrder = ... # type: 'RainbowColorMode.OrderType'

    @typing.overload
    def __init__(self, count: int = ..., order: 'RainbowColorMode.OrderType' = ..., startHue: float = ..., sat: float = ..., val: float = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'RainbowColorMode') -> None: ...

    def setSaturation(self, s: float) -> None: ...
    def saturation(self) -> float: ...
    def setValue(self, v: float) -> None: ...
    def value(self) -> float: ...
    def setStartHue(self, h: float) -> None: ...
    def startHue(self) -> float: ...
    def setOrder(self, o: 'RainbowColorMode.OrderType') -> None: ...
    def order(self) -> 'RainbowColorMode.OrderType': ...


class GrayMode(AutomaticColorMode):

    @typing.overload
    def __init__(self, count: int = ..., minV: int = ..., maxV: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'GrayMode') -> None: ...

    def setMaxValue(self, v: int) -> None: ...
    def maxValue(self) -> int: ...
    def setMinValue(self, v: int) -> None: ...
    def minValue(self) -> int: ...
    def generateColor(self, idx: int = ...) -> QtGui.QColor: ...


class MonotoneGradientMode(AutomaticColorMode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, count: int, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], minV: int = ..., maxV: int = ...) -> None: ...
    @typing.overload
    def __init__(self, count: int, hue: int, minV: int = ..., maxV: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'MonotoneGradientMode') -> None: ...

    def setMaxValue(self, v: int) -> None: ...
    def maxValue(self) -> int: ...
    def setMinValue(self, v: int) -> None: ...
    def minValue(self) -> int: ...
    def setBaseColor(self, base: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def baseColor(self) -> QtGui.QColor: ...
    def setHue(self, hue: int) -> None: ...
    def hue(self) -> int: ...
    def generateColor(self, idx: int = ...) -> QtGui.QColor: ...


class TwoColorGradientMode(AutomaticColorMode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, count: int, useHSV: bool, clMin: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], clMax: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'TwoColorGradientMode') -> None: ...

    def setUseHSV(self, b: bool) -> None: ...
    def useHSV(self) -> bool: ...
    def setColorMax(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def colorMax(self) -> QtGui.QColor: ...
    def setColorMin(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def colorMin(self) -> QtGui.QColor: ...
    def generateColor(self, idx: int = ...) -> QtGui.QColor: ...


class ThreeColorGradientMode(AutomaticColorMode):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, count: int, br: int, useHSV: bool, clMin: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], clMax: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], clBreak: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ThreeColorGradientMode') -> None: ...

    def setUseHSV(self, b: bool) -> None: ...
    def useHSV(self) -> bool: ...
    def setColorBreak(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def colorBreak(self) -> QtGui.QColor: ...
    def setBreakPos(self, pos: int) -> None: ...
    def breakPos(self) -> int: ...
    def setColorMax(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def colorMax(self) -> QtGui.QColor: ...
    def setColorMin(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def colorMin(self) -> QtGui.QColor: ...
    def generateColor(self, idx: int = ...) -> QtGui.QColor: ...


class SingleColorMode(AutomaticColorMode):

    @typing.overload
    def __init__(self, clr: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'SingleColorMode') -> None: ...

    def setColor(self, base: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def generateColor(self, idx: int = ...) -> QtGui.QColor: ...


class ThematicColorGenerator(_core_serializable.axioma.serialization.Serializable):

    @typing.overload
    def __init__(self, mode: typing.Optional[AutomaticColorMode] = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ThematicColorGenerator') -> None: ...

    def color(self, geom: str, idx: int = ...) -> QtGui.QColor: ...
    def setColorCount(self, count: int) -> None: ...
    @typing.overload
    def resetColorMode(self, mode: AutomaticColorMode) -> None: ...
    @typing.overload
    def resetColorMode(self, geom: str, mode: AutomaticColorMode) -> None: ...
    def colorMode(self, geom: str) -> AutomaticColorMode: ...


class AutomaticPointSizeMode(_core_serializable.axioma.serialization.Serializable):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, size: int) -> None: ...
    @typing.overload
    def __init__(self, count: int, startSize: int, finalSize: int) -> None: ...
    @typing.overload
    def __init__(self, minValue: float, startSize: int, maxValue: float, finalSize: int) -> None: ...
    @typing.overload
    def __init__(self, a0: 'AutomaticPointSizeMode') -> None: ...

    def setFinalSize(self, size: int) -> None: ...
    def finalSize(self) -> int: ...
    def setStartSize(self, size: int) -> None: ...
    def startSize(self) -> int: ...
    def setMaxValue(self, v: float) -> None: ...
    def maxValue(self) -> float: ...
    def setMinValue(self, v: float) -> None: ...
    def minValue(self) -> float: ...
    def generate(self, v: float) -> int: ...


class AutomaticLineWidthMode(_core_serializable.axioma.serialization.Serializable):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, size: UnitValue) -> None: ...
    @typing.overload
    def __init__(self, count: int, startWidth: UnitValue, finalWidth: UnitValue) -> None: ...
    @typing.overload
    def __init__(self, minValue: float, startWidth: UnitValue, maxValue: float, finalWidth: UnitValue) -> None: ...
    @typing.overload
    def __init__(self, a0: 'AutomaticLineWidthMode') -> None: ...

    def setFinalWidth(self, w: UnitValue) -> None: ...
    def finalWidth(self) -> UnitValue: ...
    def setStartWidth(self, w: UnitValue) -> None: ...
    def startWidth(self) -> UnitValue: ...
    def setMaxValue(self, v: float) -> None: ...
    def maxValue(self) -> float: ...
    def setMinValue(self, v: float) -> None: ...
    def minValue(self) -> float: ...
    def generate(self, v: float) -> UnitValue: ...


class ThematicSizeGenerator(_core_serializable.axioma.serialization.Serializable):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, pointMode: AutomaticPointSizeMode, lineMode: AutomaticLineWidthMode, polygonBorderMode: AutomaticLineWidthMode) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ThematicSizeGenerator') -> None: ...

    def polygonBorderWidth(self, idx: int) -> UnitValue: ...
    def lineWidth(self, idx: int) -> UnitValue: ...
    def pointSize(self, idx: int) -> int: ...
    def setCount(self, count: int) -> None: ...
    def resetPolygonBorderMode(self, mode: AutomaticLineWidthMode) -> None: ...
    def polygonBorderMode(self) -> AutomaticLineWidthMode: ...
    def resetPointMode(self, mode: AutomaticPointSizeMode) -> None: ...
    def pointMode(self) -> AutomaticPointSizeMode: ...
    def resetLineMode(self, mode: AutomaticLineWidthMode) -> None: ...
    def lineMode(self) -> AutomaticLineWidthMode: ...


class ThematicStyleGenerator(_core_serializable.axioma.serialization.Serializable):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, src: 'ThematicStyleGenerator') -> None: ...
    @typing.overload
    def __init__(self, style: CollectionStyle) -> None: ...

    @typing.overload
    def style(self) -> CollectionStyle: ...
    @typing.overload
    def style(self, geometryClassId: str) -> typing.Any: ...
    @typing.overload
    def style(self, geometryClass: GeometryStyleClass) -> typing.Any: ...
    @typing.overload
    def setStyle(self, style: typing.Any) -> None: ...
    @typing.overload
    def setStyle(self, geometryStyleClass: GeometryStyleClass, style: typing.Any) -> None: ...
    @typing.overload
    def setStyle(self, geomClassId: str, style: typing.Any) -> None: ...


class ThematicManualStyleProvider(_core_serializable.axioma.serialization.Serializable):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, src: 'ThematicManualStyleProvider') -> None: ...

    @typing.overload
    def style(self, idx: int) -> CollectionStyle: ...
    @typing.overload
    def style(self, idx: int, geometryClassId: str) -> typing.Any: ...
    @typing.overload
    def style(self, idx: int, geometryClass: GeometryStyleClass) -> typing.Any: ...
    def hasStyle(self, idx: int) -> bool: ...
    def removeStyle(self, idx: int) -> None: ...
    def insertStyle(self, idx: int, style: CollectionStyle) -> None: ...
    def maxIndex(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def empty(self) -> bool: ...
    def clear(self) -> None: ...


class ThematicColoredStyleParam(sip.wrapper):

    hidden = ... # type: bool
    manual = ... # type: bool
    objects = ... # type: int

    @typing.overload
    def __init__(self, style: Style) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ThematicColoredStyleParam') -> None: ...

    def setStyle(self, style: CollectionStyle) -> None: ...
    def style(self) -> CollectionStyle: ...
    def color(self, geometryClassId: str) -> QtGui.QColor: ...
    @typing.overload
    def setColor(self, cl: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    @typing.overload
    def setColor(self, geometryClassId: str, cl: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...


class SplittingThematic(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'SplittingThematic') -> None: ...

    def resetManualTemplateStyles(self, src: ThematicManualStyleProvider) -> None: ...
    def manualTemplateStyles(self) -> ThematicManualStyleProvider: ...
    def resetFillStyleGenerator(self, p: ThematicStyleGenerator) -> None: ...
    def fillStyleGenerator(self) -> ThematicStyleGenerator: ...
    def resetSizeGenerator(self, p: ThematicSizeGenerator) -> None: ...
    def sizeGenerator(self) -> ThematicSizeGenerator: ...
    def resetColorGenerator(self, p: ThematicColorGenerator) -> None: ...
    def colorGenerator(self) -> ThematicColorGenerator: ...
    def setHideEmpty(self, h: bool) -> None: ...
    def hideEmpty(self) -> bool: ...
    def setHideNulls(self, h: bool) -> None: ...
    def hideNulls(self) -> bool: ...
    def setDefaultStyle(self, s: CollectionStyle) -> None: ...
    def defaultStyle(self) -> CollectionStyle: ...
    def setApplyDefaultStyle(self) -> bool: ...
    def applyDefaultStyle(self) -> bool: ...
    @typing.overload
    def isGeometryAllowed(self, cl: str) -> bool: ...
    @typing.overload
    def isGeometryAllowed(self, geometry: typing.Any) -> bool: ...
    def allowedGeometryList(self) -> typing.List[str]: ...
    def removeAllowedGeometryClass(self, cl: str) -> None: ...
    def addAllowedGeometryClass(self, cl: str) -> None: ...
    def setAllowedGeometryList(self, clist: typing.Iterable[str]) -> None: ...
    @typing.overload
    def createGeometryClass(self) -> GeometryStyleClass: ...
    @typing.overload
    def createGeometryClass(self, geometryClassId: str) -> GeometryStyleClass: ...
    def defaultGeometryClass(self) -> str: ...
    def setDefaultGeometryClass(self, cl: str) -> None: ...
    def maxValue(self) -> typing.Any: ...
    def minValue(self) -> typing.Any: ...
    def setEvaluator(self, value: _core_sql.FeatureExpressionEvaluator) -> None: ...
    def evaluator(self) -> _core_sql.FeatureExpressionEvaluator: ...
    def initValuesFromTable(self, table: typing.Any) -> None: ...


class ThematicRangeStyleParam(ThematicColoredStyleParam):

    maxValue = ... # type: typing.Any
    minValue = ... # type: typing.Any

    @typing.overload
    def __init__(self, min_value: typing.Any, max_value: typing.Any, style: Style) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ThematicRangeStyleParam') -> None: ...


class RangeThematicStyleProvider(ThematicStyleProvider, SplittingThematic):

    class TypeSplitting(int): ...
    TS_EQUAL_INTERVAL = ... # type: 'RangeThematicStyleProvider.TypeSplitting'
    TS_EQUAL_COUNT = ... # type: 'RangeThematicStyleProvider.TypeSplitting'
    TS_MANUAL = ... # type: 'RangeThematicStyleProvider.TypeSplitting'

    @typing.overload
    def __init__(self, layer: ThematicLayer) -> None: ...
    @typing.overload
    def __init__(self, other: 'RangeThematicStyleProvider') -> None: ...

    def calculateValuesCountByIntervals(self) -> None: ...
    def reallocateColorBySettingParams(self) -> None: ...
    def createLegendPreview(self) -> typing.Any: ...
    def rangesCount(self) -> int: ...
    def setThematicStyleParam(self, ind: int, param: ThematicRangeStyleParam) -> None: ...
    def thematicStyleParam(self, index: int) -> ThematicRangeStyleParam: ...
    def setThematicStyleParamsList(self, list: typing.Iterable[ThematicRangeStyleParam]) -> None: ...
    def thematicStyleParamsList(self) -> typing.Any: ...
    def setBreakParameters(self, value: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], range: int) -> None: ...
    def breakRange(self) -> int: ...
    def colorBreak(self) -> QtGui.QColor: ...
    def setColorMax(self, value: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def colorMax(self) -> QtGui.QColor: ...
    def setColorMin(self, value: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def colorMin(self) -> QtGui.QColor: ...
    def splitValuesToIntervals(self) -> None: ...
    def initIntervals(self, ranges: int, preservedExistedStyle: bool = ...) -> None: ...
    def setTypeSplitting(self, value: 'RangeThematicStyleProvider.TypeSplitting') -> None: ...
    def typeSplitting(self) -> 'RangeThematicStyleProvider.TypeSplitting': ...
    def requiredAttributes(self) -> typing.List[str]: ...
    def style(self, feature: _core_dp.Feature, context: MapContext) -> typing.Any: ...
    @staticmethod
    def nameByTypeSplitting(tp: 'RangeThematicStyleProvider.TypeSplitting') -> str: ...


class RangeThematicLayer(ThematicLayer):

    @typing.overload
    def __init__(self, parent: FeatureLayer) -> None: ...
    @typing.overload
    def __init__(self, other: 'RangeThematicLayer') -> None: ...

    def createLegend_impl(self, parent: QtCore.QObject) -> 'ThematicLegendItem': ...
    def styleProvider_common(self) -> ThematicStyleProvider: ...
    def setStyleProvider(self, value: RangeThematicStyleProvider) -> None: ...
    def styleProvider(self) -> RangeThematicStyleProvider: ...
    def featureStyleProvider_impl(self, context: MapContext) -> FeatureStyleProvider: ...
    def class_id(self) -> str: ...


class ThematicIndividualStyleParam(ThematicColoredStyleParam):

    value = ... # type: typing.Any

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, v: typing.Any, c: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    @typing.overload
    def __init__(self, v: typing.Any, style: Style) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ThematicIndividualStyleParam') -> None: ...


class IndividualThematicStyleProvider(ThematicStyleProvider, SplittingThematic):

    @typing.overload
    def __init__(self, layer: ThematicLayer) -> None: ...
    @typing.overload
    def __init__(self, other: 'IndividualThematicStyleProvider') -> None: ...

    def removeValue(self, value: typing.Any) -> int: ...
    def appendValue(self, value: typing.Any) -> int: ...
    def thematicStyleParamCount(self) -> int: ...
    def thematicStyleParam(self, index: int) -> ThematicIndividualStyleParam: ...
    def setThematicStyleParam(self, ind: int, param: ThematicIndividualStyleParam) -> None: ...
    def setThematicStyleParamsList(self, value: typing.Any) -> None: ...
    def thematicStyleParamsList(self) -> typing.Any: ...
    def resetStylesForParams(self) -> None: ...
    def reallocateColorByValues(self, preserveOldStyles: bool = ...) -> None: ...
    def updateObjectCount(self) -> None: ...
    def createLegendPreview(self) -> LegendItem: ...
    def requiredAttributes(self) -> typing.List[str]: ...
    def style(self, feature: _core_dp.Feature, context: MapContext) -> typing.Any: ...


class IndividualThematicLayer(ThematicLayer):

    @typing.overload
    def __init__(self, parent: FeatureLayer) -> None: ...
    @typing.overload
    def __init__(self, other: 'IndividualThematicLayer') -> None: ...

    def createLegend_impl(self, parent: QtCore.QObject) -> 'ThematicLegendItem': ...
    def styleProvider_common(self) -> ThematicStyleProvider: ...
    def setStyleProvider(self, value: IndividualThematicStyleProvider) -> None: ...
    def styleProvider(self) -> IndividualThematicStyleProvider: ...
    def featureStyleProvider_impl(self, context: MapContext) -> FeatureStyleProvider: ...
    def class_id(self) -> str: ...


class StyleNonSplitGeometry(Style):

    def draw_collection(self, collection: _core_geometry.GeometryCollection, context: ContextInterface) -> None: ...


class ColorValue(sip.wrapper):

    style = ... # type: Style
    value = ... # type: typing.Any

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ColorValue') -> None: ...


class ThematicColorExpressionParam(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, s: Style, e: str, dialect: _core_sql.Dialect, manual: bool, schema: _core_dp.TableSchema) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ThematicColorExpressionParam') -> None: ...

    def setTableSchema(self, schema: _core_dp.TableSchema) -> None: ...
    def isValidExpression(self) -> bool: ...
    def evaluator(self) -> _core_sql.FeatureExpressionEvaluator: ...
    def expressionString(self) -> str: ...
    def setExpression(self, e: str) -> None: ...
    def setManual(self, v: bool) -> None: ...
    def isManual(self) -> bool: ...
    def setStyle(self, s: Style) -> None: ...
    def style(self) -> Style: ...


class AllocationThematic(sip.wrapper):

    class AllocationType(int): ...
    AT_LINEAR = ... # type: 'AllocationThematic.AllocationType'
    AT_SQRT = ... # type: 'AllocationThematic.AllocationType'
    AT_LOG10 = ... # type: 'AllocationThematic.AllocationType'

    def setAllocationType(self, value: 'AllocationThematic.AllocationType') -> None: ...
    def allocationType(self) -> 'AllocationThematic.AllocationType': ...
    @staticmethod
    def nameByAllocationType(at: 'AllocationThematic.AllocationType') -> str: ...


class OrientationThematic(sip.wrapper):

    class OrientationType(int): ...
    OT_CENTER = ... # type: 'OrientationThematic.OrientationType'
    OT_LEFT_UP = ... # type: 'OrientationThematic.OrientationType'
    OT_UP = ... # type: 'OrientationThematic.OrientationType'
    OT_RIGHT_UP = ... # type: 'OrientationThematic.OrientationType'
    OT_RIGHT = ... # type: 'OrientationThematic.OrientationType'
    OT_RIGHT_DOWN = ... # type: 'OrientationThematic.OrientationType'
    OT_DOWN = ... # type: 'OrientationThematic.OrientationType'
    OT_LEFT_DOWN = ... # type: 'OrientationThematic.OrientationType'
    OT_LEFT = ... # type: 'OrientationThematic.OrientationType'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'OrientationThematic') -> None: ...

    def setOrientationType(self, value: 'OrientationThematic.OrientationType') -> None: ...
    def orientationType(self) -> 'OrientationThematic.OrientationType': ...


class BarSizeParam(sip.wrapper):

    mapScale = ... # type: float
    size = ... # type: UnitSize
    value = ... # type: float

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, scale: float, value: float, size: UnitSize) -> None: ...
    @typing.overload
    def __init__(self, a0: 'BarSizeParam') -> None: ...


class BarThematicStyleProvider(ThematicStyleProvider, AllocationThematic, OrientationThematic):

    @typing.overload
    def __init__(self, layer: ThematicLayer) -> None: ...
    @typing.overload
    def __init__(self, other: 'BarThematicStyleProvider') -> None: ...

    def setIsGraduired(self, value: bool) -> None: ...
    def isGraduired(self) -> bool: ...
    def createLegendPreview(self) -> typing.Any: ...
    def thematicStyleParam(self, index: int) -> ThematicColorExpressionParam: ...
    def setThematicStyleParam(self, ind: int, param: ThematicColorExpressionParam) -> None: ...
    def thematicColorExpressionParams(self) -> typing.List[ThematicColorExpressionParam]: ...
    def calculateMaximum(self, table: typing.Any) -> float: ...
    def setIsStacked(self, value: bool) -> None: ...
    def isStacked(self) -> bool: ...
    def pixelSize(self, mapViewport: MapViewport, dpi: int) -> QtCore.QSizeF: ...
    def setSizeParam(self, value: BarSizeParam) -> None: ...
    def sizeParamRef(self) -> BarSizeParam: ...
    def sizeParam(self) -> BarSizeParam: ...
    def setExpressions(self, params: typing.Any) -> None: ...
    def requiredAttributes(self) -> typing.List[str]: ...
    def style(self, feature: _core_dp.Feature, context: MapContext) -> typing.Any: ...


class BarThematicLayer(ThematicLayer):

    @typing.overload
    def __init__(self, parent: FeatureLayer) -> None: ...
    @typing.overload
    def __init__(self, other: 'BarThematicLayer') -> None: ...

    def createLegend_impl(self, parent: QtCore.QObject) -> 'ThematicLegendItem': ...
    def styleProvider_common(self) -> ThematicStyleProvider: ...
    def setStyleProvider(self, styleProvider: BarThematicStyleProvider) -> None: ...
    def styleProvider(self) -> BarThematicStyleProvider: ...
    def featureStyleProvider_impl(self, context: MapContext) -> FeatureStyleProvider: ...
    def class_id(self) -> str: ...


class PieSizeParam(sip.wrapper):

    diameter = ... # type: UnitValue
    mapScale = ... # type: float
    sumValue = ... # type: float

    def __init__(self) -> None: ...


class PieThematicStyleProvider(ThematicStyleProvider, AllocationThematic, OrientationThematic):

    @typing.overload
    def __init__(self, layer: ThematicLayer) -> None: ...
    @typing.overload
    def __init__(self, a0: 'PieThematicStyleProvider') -> None: ...

    def setIsGraduired(self, value: bool) -> None: ...
    def isGraduired(self) -> bool: ...
    def createLegendPreview(self) -> LegendItem: ...
    def thematicStyleParam(self, index: int) -> ThematicColorExpressionParam: ...
    def setThematicStyleParam(self, ind: int, param: ThematicColorExpressionParam) -> None: ...
    def thematicColorExpressionParams(self) -> typing.List[ThematicColorExpressionParam]: ...
    def setIsClockwise(self, value: bool) -> None: ...
    def isClockwise(self) -> bool: ...
    def calculateMaxSum(self, table: typing.Any) -> float: ...
    def pixelDiameter(self, mapViewport: MapViewport, dpi: int) -> float: ...
    def sizeParam(self) -> PieSizeParam: ...
    def setSizeParam(self, v: PieSizeParam) -> None: ...
    def startAngle(self) -> float: ...
    def setStartAngle(self, v: float) -> None: ...
    def setExpressions(self, params: typing.Iterable[ThematicColorExpressionParam]) -> None: ...
    def requiredAttributes(self) -> typing.List[str]: ...
    def style(self, feature: _core_dp.Feature, context: MapContext) -> typing.Any: ...


class PieThematicLayer(ThematicLayer):

    @typing.overload
    def __init__(self, parent: FeatureLayer) -> None: ...
    @typing.overload
    def __init__(self, other: 'PieThematicLayer') -> None: ...

    def createLegend_impl(self, parent: QtCore.QObject) -> 'ThematicLegendItem': ...
    def styleProvider_common(self) -> ThematicStyleProvider: ...
    def setStyleProvider(self, styleProvider: PieThematicStyleProvider) -> None: ...
    def styleProvider(self) -> PieThematicStyleProvider: ...
    def featureStyleProvider_impl(self, context: MapContext) -> FeatureStyleProvider: ...
    def class_id(self) -> str: ...


class SymbolLimits(sip.wrapper):

    maximum = ... # type: typing.Any
    minimum = ... # type: typing.Any

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'SymbolLimits') -> None: ...


class SymbolThematicStyleProvider(ThematicStyleProvider, AllocationThematic):

    @typing.overload
    def __init__(self, layer: ThematicLayer, hmin: int = ..., hmax: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'SymbolThematicStyleProvider') -> None: ...

    def setLimitsValues(self, values: SymbolLimits) -> None: ...
    def limitValues(self) -> SymbolLimits: ...
    def createLegendPreview(self) -> LegendItem: ...
    def calculateLimitsValues(self, table: typing.Any) -> SymbolLimits: ...
    def setEvaluator(self, value: _core_sql.FeatureExpressionEvaluator) -> None: ...
    def evaluator(self) -> _core_sql.FeatureExpressionEvaluator: ...
    def setMaxHeight(self, value: int) -> None: ...
    def maxHeight(self) -> int: ...
    def setMinHeight(self, value: int) -> None: ...
    def minHeight(self) -> int: ...
    def setDefaultStyle(self, value: PointStyle) -> None: ...
    def defaultStyle(self) -> PointStyle: ...
    def requiredAttributes(self) -> typing.List[str]: ...
    def style(self, feature: _core_dp.Feature, context: MapContext) -> typing.Any: ...


class SymbolThematicLayer(ThematicLayer):

    @typing.overload
    def __init__(self, parent: FeatureLayer) -> None: ...
    @typing.overload
    def __init__(self, other: 'SymbolThematicLayer') -> None: ...

    def createLegend_impl(self, parent: QtCore.QObject) -> 'ThematicLegendItem': ...
    def styleProvider_common(self) -> ThematicStyleProvider: ...
    def setStyleProvider(self, value: SymbolThematicStyleProvider) -> None: ...
    def styleProvider(self) -> SymbolThematicStyleProvider: ...
    def featureStyleProvider_impl(self, context: MapContext) -> FeatureStyleProvider: ...
    def class_id(self) -> str: ...


class DensitySizeParam(sip.wrapper):

    points = ... # type: int
    value = ... # type: typing.Any

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, p: int, v: typing.Any) -> None: ...
    @typing.overload
    def __init__(self, a0: 'DensitySizeParam') -> None: ...


class DensityStyleParam(sip.wrapper):

    class FormType(int): ...
    ftRound = ... # type: 'DensityStyleParam.FormType'
    ftSquare = ... # type: 'DensityStyleParam.FormType'

    color = ... # type: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]
    formType = ... # type: 'DensityStyleParam.FormType'
    size = ... # type: UnitSize

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, ft: 'DensityStyleParam.FormType', c: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], s: UnitSize) -> None: ...
    @typing.overload
    def __init__(self, a0: 'DensityStyleParam') -> None: ...


class DensityStyle(StyleNonSplitGeometry):

    @typing.overload
    def __init__(self, pointCount: int, provider: 'DensityThematicStyleProvider', base: typing.Any = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'DensityStyle') -> None: ...


class DensityThematicStyleProvider(ThematicStyleProvider):

    @typing.overload
    def __init__(self, layer: ThematicLayer) -> None: ...
    @typing.overload
    def __init__(self, other: 'DensityThematicStyleProvider') -> None: ...

    def densityStyleParam(self) -> DensityStyleParam: ...
    def setDensityStyleParam(self, par: DensityStyleParam) -> None: ...
    def calculateMaximum(self, table: typing.Any) -> typing.Any: ...
    def setEvaluator(self, value: typing.Any) -> None: ...
    def evaluator(self) -> _core_sql.FeatureExpressionEvaluator: ...
    def setDensitySizeParam(self, value: DensitySizeParam) -> None: ...
    def densitySizeParam(self) -> DensitySizeParam: ...
    def createLegendPreview(self) -> LegendItem: ...
    def requiredAttributes(self) -> typing.List[str]: ...
    def style(self, feature: _core_dp.Feature, context: MapContext) -> typing.Any: ...


class DensityThematicLayer(ThematicLayer):

    @typing.overload
    def __init__(self, parent: FeatureLayer) -> None: ...
    @typing.overload
    def __init__(self, other: 'DensityThematicLayer') -> None: ...

    def createLegend_impl(self, parent: QtCore.QObject) -> 'ThematicLegendItem': ...
    def styleProvider_common(self) -> ThematicStyleProvider: ...
    def setStyleProvider(self, value: DensityThematicStyleProvider) -> None: ...
    def styleProvider(self) -> DensityThematicStyleProvider: ...
    def styleProviderConst(self) -> DensityThematicStyleProvider: ...
    def featureStyleProvider_impl(self, context: MapContext) -> FeatureStyleProvider: ...
    def class_id(self) -> str: ...


class ReverseVisibleLayerVisitor(VisibleLayerVisitor):

    @typing.overload
    def visit(self, layerGroup: LayerGroup) -> None: ...
    @typing.overload
    def visit(self, root: RootLayerGroup) -> None: ...


class ConcurrentMapRenderer(ReverseVisibleLayerVisitor):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ConcurrentMapRenderer') -> None: ...

    def visitVisibleLayer(self, layer: Layer) -> None: ...
    def blockingRender(self, map: Map, context: MapContext) -> None: ...


class VectorMapRenderer(ReverseVisibleLayerVisitor):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'VectorMapRenderer') -> None: ...

    def visitVisibleLayer(self, layer: Layer) -> None: ...
    def render(self, map: Map, context: MapContext) -> None: ...


class LayerVisitor(MapItemVisitor):

    @typing.overload
    def visit(self, layerGroup: LayerGroup) -> None: ...
    @typing.overload
    def visit(self, root: RootLayerGroup) -> None: ...


class LayerExtractor(LayerVisitor):

    def layers(self, root: MapItem) -> typing.List[Layer]: ...
    def visit(self, layer: Layer) -> None: ...


class FeatureLayerProperties(LayerProperties):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, other: 'FeatureLayerProperties') -> None: ...

    def showLabels(self) -> bool: ...
    def setShowLabels(self, value: bool) -> None: ...
    def setLabelPlacementPolicy(self, labelVisibilityConstraints: 'LabelPlacementPolicy') -> None: ...
    def labelPlacementPolicy(self) -> 'LabelPlacementPolicy': ...
    def setLabelProperties(self, labelProperties: 'LabelProperties') -> None: ...
    def labelProperties(self) -> 'LabelProperties': ...
    def setHotLink(self, value: _core_dp.HotLink) -> None: ...
    def hotLink(self) -> _core_dp.HotLink: ...
    def uniformStyleProvider(self) -> StyleCollectionProvider: ...
    def textRenderer(self) -> TextRenderer: ...
    def setTextRenderer(self, textRender: TextRenderer) -> None: ...
    def labelOpacity(self) -> float: ...
    def setLabelOpacity(self, opacity: float) -> None: ...
    def labelingAttributeIsExpression(self) -> bool: ...
    def setLabelingAttributeIsExpression(self, isExpression: bool) -> None: ...
    def labelingAttributeName(self) -> str: ...
    def setLabelingAttributeName(self, attributeName: str) -> None: ...
    def setShowUniformly(self, value: bool) -> None: ...
    def showUniformly(self) -> bool: ...
    def nodesVisibility(self) -> bool: ...
    def setNodesVisible(self, visible: bool) -> None: ...
    def linesDirectionVisibility(self) -> bool: ...
    def setLinesDirectionVisible(self, visible: bool) -> None: ...
    def centroidsVisibility(self) -> bool: ...
    def setCentroidsVisible(self, visible: bool) -> None: ...


class VisibilityConstraints(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, enabled: bool, min: float, max: float) -> None: ...
    @typing.overload
    def __init__(self, a0: 'VisibilityConstraints') -> None: ...

    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    def setZoomMax(self, zoom: float) -> None: ...
    def setZoomMin(self, zoom: float) -> None: ...
    def zoomMax(self) -> float: ...
    def zoomMin(self) -> float: ...
    def isVisible(self, viewport: ViewportInterface) -> bool: ...


class ThematicLegendItem(LegendItem):

    @typing.overload
    def __init__(self, layer: ThematicLayer, caption: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, item: 'ThematicLegendItem') -> None: ...

    def name(self) -> str: ...
    def layer(self) -> ThematicLayer: ...


class RangeLegendItem(ThematicLegendItem, HasStatisticLegendItem):

    @typing.overload
    def __init__(self, layer: RangeThematicLayer, caption: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, item: 'RangeLegendItem') -> None: ...

    def setVisibledStatistic(self, v: bool) -> None: ...
    def isVisibledStatistic(self) -> bool: ...
    def layer(self) -> ThematicLayer: ...


class PieLegendItem(ThematicLegendItem, DynamicSizeLegendItem):

    @typing.overload
    def __init__(self, layer: PieThematicLayer, caption: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, item: 'PieLegendItem') -> None: ...

    def calculateSizeForContext(self, context: ContextInterface) -> None: ...
    def layer(self) -> ThematicLayer: ...


class BarLegendItem(ThematicLegendItem, DynamicSizeLegendItem):

    @typing.overload
    def __init__(self, layer: BarThematicLayer, caption: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, item: 'BarLegendItem') -> None: ...

    def calculateSizeForContext(self, context: ContextInterface) -> None: ...
    def layer(self) -> ThematicLayer: ...


class SymbolLegendItem(ThematicLegendItem):

    def __init__(self, layer: SymbolThematicLayer, caption: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def layer(self) -> ThematicLayer: ...


class IndividualLegendItem(ThematicLegendItem):

    def __init__(self, layer: IndividualThematicLayer, caption: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def layer(self) -> ThematicLayer: ...


class DensityLegendItem(ThematicLegendItem):

    @typing.overload
    def __init__(self, layer: DensityThematicLayer, caption: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, provider: DensityThematicStyleProvider, caption: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def layer(self) -> ThematicLayer: ...


class FeatureLegendItem(LegendItem):

    @typing.overload
    def __init__(self, layer: Layer, caption: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, layer: Layer, overrideComponents: typing.Iterable[LegendItemComponent], caption: str, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...
    @typing.overload
    def __init__(self, item: 'FeatureLegendItem') -> None: ...

    def dataChanged(self) -> None: ...
    def name(self) -> str: ...
    def layer(self) -> Layer: ...


class GeometryReportItem(ReportItem):

    @typing.overload
    def __init__(self, report: Report) -> None: ...
    @typing.overload
    def __init__(self, geometry: _core_geometry.Geometry, style: Style, parent: Report) -> None: ...

    def canScale(self) -> bool: ...
    def canRotate(self) -> bool: ...
    def drawSelected(self, context: ContextInterface) -> None: ...
    def intersects(self, rect: QtCore.QRectF) -> bool: ...
    def name(self) -> str: ...
    def transform(self, transform: QtGui.QTransform) -> None: ...
    def setStyle(self, style: Style) -> None: ...
    def style(self) -> Style: ...
    def setGeometry(self, geometry: typing.Any) -> None: ...
    def geometry(self) -> _core_geometry.Geometry: ...
    def rect(self) -> QtCore.QRectF: ...
    def draw(self, context: ContextInterface) -> None: ...


class TableReportItem(ReportItem):

    @typing.overload
    def __init__(self, table: typing.Any, rect: QtCore.QRectF, report: Report) -> None: ...
    @typing.overload
    def __init__(self, table: typing.Any, rect: QtCore.QRectF, columns: typing.Iterable[str], offset: int, report: Report) -> None: ...
    @typing.overload
    def __init__(self, table: typing.Any, rect: QtCore.QRectF, columns: typing.Iterable[str], range: _core_dp.PageRange, report: Report) -> None: ...

    def refreshValues(self) -> None: ...
    def setCaptionScale(self, fontSize: float) -> None: ...
    def setCellScale(self, fontSize: float) -> None: ...
    def minCaptionSize(self) -> float: ...
    def captionScale(self) -> float: ...
    def minCellSize(self) -> float: ...
    def cellScale(self) -> float: ...
    def minScale(self) -> float: ...
    def table(self) -> typing.Any: ...
    def setStartNumber(self, startNumber: int) -> None: ...
    def startNumber(self) -> int: ...
    def visibleRows(self) -> int: ...
    def rows(self) -> int: ...
    def isSingleRenderer(self) -> bool: ...
    def setCaptionRenderer(self, textRenderer: TextRenderer) -> None: ...
    def setCellRenderer(self, textRenderer: TextRenderer) -> None: ...
    def setTextRenderer(self, textRenderer: TextRenderer) -> None: ...
    def textRenderer(self) -> TextRenderer: ...
    def captionRenderer(self) -> TextRenderer: ...
    def setOffset(self, offset: int) -> None: ...
    def setRange(self, range: _core_dp.PageRange) -> None: ...
    def range(self) -> _core_dp.PageRange: ...
    def offset(self) -> int: ...
    def setSelectedColumns(self, selectedColumns: typing.Iterable[str]) -> None: ...
    def selectedColumns(self) -> typing.List[str]: ...
    def allColumns(self) -> typing.List[str]: ...
    def setShowRowNumber(self, showRowNumber: bool) -> None: ...
    def showRowNumber(self) -> bool: ...
    def canScale(self) -> bool: ...
    def canRotate(self) -> bool: ...
    def name(self) -> str: ...
    def transform(self, transform: QtGui.QTransform) -> None: ...
    def rect(self) -> QtCore.QRectF: ...
    def draw(self, context: ContextInterface) -> None: ...


class ScaleBarReportItem(ReportItem):

    def __init__(self, mapReportItem: 'MapReportItem', vp: MapViewport, rect: QtCore.QRectF, report: Report) -> None: ...

    def setMapViewport(self, vp: MapViewport) -> None: ...
    def mapViewport(self) -> MapViewport: ...
    def scaleBar(self) -> 'ScaleBar': ...
    def canScale(self) -> bool: ...
    def canRotate(self) -> bool: ...
    def name(self) -> str: ...
    def transform(self, transform: QtGui.QTransform) -> None: ...
    def rect(self) -> QtCore.QRectF: ...
    def draw(self, context: ContextInterface) -> None: ...


class MapReportItem(ReportItem):

    def __init__(self, map: Map, viewPort: MapViewport, report: Report) -> None: ...

    def viewportChanged(self, vp: MapViewport) -> None: ...
    def setViewport(self, vp: MapViewport) -> None: ...
    def viewport(self) -> MapViewport: ...
    def canScale(self) -> bool: ...
    def canRotate(self) -> bool: ...
    def coordSystem(self) -> _cs.CoordSystem: ...
    def setCenter(self, pnt: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def rectMap(self) -> QtCore.QRectF: ...
    def name(self) -> str: ...
    def transform(self, transform: QtGui.QTransform) -> None: ...
    def map(self) -> Map: ...
    def setScale(self, s: float) -> None: ...
    def scale(self) -> float: ...
    def rect(self) -> QtCore.QRectF: ...
    def draw(self, context: ContextInterface) -> None: ...


class RasterReportItem(ReportItem):

    @typing.overload
    def __init__(self, layer: RasterLayer, rect: QtCore.QRectF, report: Report, perserveAspectRatio: bool = ...) -> None: ...
    @typing.overload
    def __init__(self, layer: RasterLayer, vp: Viewport, report: Report, perserveAspectRatio: bool = ...) -> None: ...

    def setPreserveAspectRatio(self, preserveAspectRatio: bool) -> None: ...
    def preserveAspectRatio(self) -> bool: ...
    def layer(self) -> RasterLayer: ...
    def setViewport(self, vp: Viewport) -> None: ...
    def viewport(self) -> Viewport: ...
    def canScale(self) -> bool: ...
    def canRotate(self) -> bool: ...
    def rectRaster(self) -> QtCore.QRect: ...
    def name(self) -> str: ...
    def transform(self, transform: QtGui.QTransform) -> None: ...
    def rect(self) -> QtCore.QRectF: ...
    def draw(self, context: ContextInterface) -> None: ...


class LegendReportItem(ReportItem):

    @typing.overload
    def __init__(self, legendPosition: LegendItemPosition, rect: QtCore.QRectF, report: Report) -> None: ...
    @typing.overload
    def __init__(self, item: LegendItem, rect: QtCore.QRectF, report: Report) -> None: ...

    def setRect(self, rect: QtCore.QRectF) -> None: ...
    def legendItemPosition(self) -> LegendItemPosition: ...
    def canScale(self) -> bool: ...
    def canRotate(self) -> bool: ...
    def name(self) -> str: ...
    def transform(self, transform: QtGui.QTransform) -> None: ...
    def rect(self) -> QtCore.QRectF: ...
    def draw(self, context: ContextInterface) -> None: ...


class ScaleBar(QtCore.QObject):

    def __init__(self, map: Map, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setAlignment(self, alignment: typing.Union[QtCore.Qt.Edges, QtCore.Qt.Edge]) -> None: ...
    def alignment(self) -> QtCore.Qt.Edges: ...
    def fitSize(self, sizePixel: QtCore.QSizeF, dpi: float) -> None: ...
    def setSize(self, size: QtCore.QSizeF) -> None: ...
    def size(self) -> QtCore.QSizeF: ...
    def setDeviceUnit(self, deviceUnit: Unit) -> None: ...
    def deviceUnit(self) -> Unit: ...
    def map(self) -> Map: ...
    def setIsAutomaticScale(self, isAutomaticScale: bool) -> None: ...
    def isAutomaticScale(self) -> bool: ...
    def setIsShowCartographScale(self, isShowCartographScale: bool) -> None: ...
    def isShowCartographScale(self) -> bool: ...
    def setFillColorTwo(self, fillColorTwo: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def fillColorTwo(self) -> QtGui.QColor: ...
    def setFillColorOne(self, fillColorOne: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def fillColorOne(self) -> QtGui.QColor: ...
    def setBorderColor(self, borderColor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def borderColor(self) -> QtGui.QColor: ...
    def setTextRender(self, textRender: TextRenderer) -> None: ...
    def textRender(self) -> TextRenderer: ...
    @typing.overload
    def render(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint], context: ContextInterface, mapViewport: MapViewport) -> None: ...
    @typing.overload
    def render(self, rect: QtCore.QRectF, context: ContextInterface, mapViewport: MapViewport) -> None: ...


class LabelCallout(sip.wrapper):

    class EndType(int): ...
    None = ... # type: 'LabelCallout.EndType'
    Line = ... # type: 'LabelCallout.EndType'
    Arrow = ... # type: 'LabelCallout.EndType'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, style: LineStringStyle, endType: 'LabelCallout.EndType' = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'LabelCallout') -> None: ...

    def setLineStringStyle(self, lineStringStyle: LineStringStyle) -> None: ...
    def lineStringStyle(self) -> LineStringStyle: ...
    def isVisible(self) -> bool: ...
    def setEndType(self, endType: 'LabelCallout.EndType') -> None: ...
    def endType(self) -> 'LabelCallout.EndType': ...


class LabelLayout(sip.wrapper):

    class ReferencePoint(int): ...
    RefPointGeneral = ... # type: 'LabelLayout.ReferencePoint'
    RefPointCentroid = ... # type: 'LabelLayout.ReferencePoint'
    RefPointFlat = ... # type: 'LabelLayout.ReferencePoint'

    class AntiAliasing(int): ...
    AntiAliasingUse = ... # type: 'LabelLayout.AntiAliasing'
    AntiAliasingNone = ... # type: 'LabelLayout.AntiAliasing'
    AntiAliasingNoneIfMany = ... # type: 'LabelLayout.AntiAliasing'

    class Interior(int): ...
    InteriorMax = ... # type: 'LabelLayout.Interior'
    InteriorCentroid = ... # type: 'LabelLayout.Interior'

    class Placement(int): ...
    PlacementCentroid = ... # type: 'LabelLayout.Placement'
    PlacementHorizontal = ... # type: 'LabelLayout.Placement'
    PlacementVertical = ... # type: 'LabelLayout.Placement'
    PlacementSelect = ... # type: 'LabelLayout.Placement'

    class Orientation(int): ...
    Horizontal = ... # type: 'LabelLayout.Orientation'
    Parallel = ... # type: 'LabelLayout.Orientation'
    FollowPath = ... # type: 'LabelLayout.Orientation'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'LabelLayout') -> None: ...

    def setAntiAliasing(self, antiAliasing: 'LabelLayout.AntiAliasing') -> 'LabelLayout': ...
    def antiAliasing(self) -> 'LabelLayout.AntiAliasing': ...
    def setInterior(self, interior: 'LabelLayout.Interior') -> 'LabelLayout': ...
    def interior(self) -> 'LabelLayout.Interior': ...
    def setPlacement(self, placement: 'LabelLayout.Placement') -> 'LabelLayout': ...
    def placement(self) -> 'LabelLayout.Placement': ...
    def setReferencePoint(self, referencePoint: 'LabelLayout.ReferencePoint') -> 'LabelLayout': ...
    def referencePoint(self) -> 'LabelLayout.ReferencePoint': ...
    def setOrientation(self, orientation: 'LabelLayout.Orientation') -> 'LabelLayout': ...
    def orientation(self) -> 'LabelLayout.Orientation': ...
    def setOffsetArea(self, value: QtCore.QSize) -> 'LabelLayout': ...
    def setOffsetCurve(self, value: int) -> 'LabelLayout': ...
    def setOffsetPoint(self, value: QtCore.QSize) -> 'LabelLayout': ...
    def setOffsets(self, value: QtCore.QSize) -> 'LabelLayout': ...
    def setOffset(self, value: int) -> 'LabelLayout': ...
    def screenOffsetArea(self) -> QtCore.QSize: ...
    def screenOffsetCurve(self) -> int: ...
    def screenOffsetPoint(self) -> QtCore.QSize: ...
    def pixelOffsetArea(self, dpiX: float, dpiY: float) -> QtCore.QSize: ...
    def pixelOffsetCurve(self, dpi: float) -> int: ...
    def pixelOffsetPoint(self, dpiX: float, dpiY: float) -> QtCore.QSize: ...
    def offsetArea(self) -> QtCore.QSize: ...
    def offsetCurve(self) -> int: ...
    def offsetPoint(self) -> QtCore.QSize: ...
    def offset(self) -> int: ...
    def setAlignmentArea(self, value: typing.Union[QtCore.Qt.Edges, QtCore.Qt.Edge] = ...) -> 'LabelLayout': ...
    def setAlignmentCurve(self, value: typing.Union[QtCore.Qt.Edges, QtCore.Qt.Edge] = ...) -> 'LabelLayout': ...
    def setAlignmentPoint(self, value: typing.Union[QtCore.Qt.Edges, QtCore.Qt.Edge] = ...) -> 'LabelLayout': ...
    def setAlignment(self, value: typing.Union[QtCore.Qt.Edges, QtCore.Qt.Edge] = ...) -> 'LabelLayout': ...
    def alignmentArea(self) -> QtCore.Qt.Edges: ...
    def alignmentCurve(self) -> QtCore.Qt.Edges: ...
    def alignmentPoint(self) -> QtCore.Qt.Edges: ...
    def alignment(self) -> QtCore.Qt.Edges: ...


class ReduceFontSize(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'ReduceFontSize') -> None: ...

    def setAllowTransgress(self, allowTransgress: bool) -> None: ...
    def allowTransgress(self) -> bool: ...
    def setDistribution(self, distribution: int) -> None: ...
    def distribution(self) -> int: ...
    def setMinSize(self, minSize: float) -> None: ...
    def minSize(self) -> float: ...


class TextProperties(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'TextProperties') -> None: ...

    def removeAngle(self) -> None: ...
    def setAngleRadian(self, angle: float) -> None: ...
    def setAngleDegree(self, angle: float) -> None: ...
    def hasAngle(self) -> bool: ...
    def angleRadian(self) -> float: ...
    def angleDegree(self) -> float: ...
    def setText(self, str: str) -> None: ...
    def text(self) -> str: ...


class LabelProperties(sip.wrapper):

    class SmoothPolyLine(int): ...
    SmoothPolyLineStandard = ... # type: 'LabelProperties.SmoothPolyLine'
    SmoothPolyLineAbsent = ... # type: 'LabelProperties.SmoothPolyLine'
    SmoothPolyLineDefault = ... # type: 'LabelProperties.SmoothPolyLine'

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, callout: LabelCallout, position: _core_geometry.Point, layout: LabelLayout) -> None: ...
    @typing.overload
    def __init__(self, other: 'LabelProperties') -> None: ...

    def setFlatAngle(self, flatAngle: float) -> None: ...
    def getFlatAngle(self) -> float: ...
    def setFlatPlotFallback(self, use: bool) -> None: ...
    def getFlatPlotFallback(self) -> bool: ...
    def setAngleMax(self, angleMax: AngleMax) -> None: ...
    def getAngleMax(self) -> AngleMax: ...
    def setSmoothPolyLine(self, smoothPolyLine: 'LabelProperties.SmoothPolyLine') -> None: ...
    def getSmoothPolyLine(self) -> 'LabelProperties.SmoothPolyLine': ...
    def setTextProperties(self, textProperties: TextProperties) -> None: ...
    def getTextProperties(self) -> TextProperties: ...
    def setReduceFontSize(self, reduceFontSize: ReduceFontSize) -> None: ...
    def getReduceFontSize(self) -> ReduceFontSize: ...
    def setLayout(self, labelLayout: LabelLayout) -> None: ...
    def getLayout(self) -> LabelLayout: ...
    def setPosition(self, point: _core_geometry.Point) -> None: ...
    def getPosition(self) -> _core_geometry.Point: ...
    def setCallout(self, value: LabelCallout) -> None: ...
    def getCallout(self) -> LabelCallout: ...
    def isEmpty(self) -> bool: ...


class FeatureLabelContainer(sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: QtCore.QObject) -> None: ...
    @typing.overload
    def __init__(self, a0: 'FeatureLabelContainer') -> None: ...

    def isEmpty(self) -> bool: ...
    @typing.overload
    def contains(self, layer: Layer, key: typing.Any) -> bool: ...
    @typing.overload
    def contains(self, layer: Layer) -> bool: ...
    @typing.overload
    def remove(self, layer: Layer, key: typing.Any) -> None: ...
    @typing.overload
    def remove(self, layer: Layer) -> None: ...
    def insert(self, layer: Layer, key: typing.Any, labelProperties: LabelProperties) -> None: ...
    def ids(self, layer: Layer) -> typing.List[typing.Any]: ...
    def value(self, layer: Layer, key: typing.Any, def_: LabelProperties = ...) -> LabelProperties: ...


class CollectionRule(sip.wrapper):

    class Rule(int): ...
    RuleDisabled = ... # type: 'CollectionRule.Rule'
    RuleBig = ... # type: 'CollectionRule.Rule'
    RuleNearToCentroid = ... # type: 'CollectionRule.Rule'
    RuleEvery = ... # type: 'CollectionRule.Rule'
    RuleAtCenter = ... # type: 'CollectionRule.Rule'
    RuleConvexHull = ... # type: 'CollectionRule.Rule'

    rule = ... # type: 'CollectionRule.Rule'
    section = ... # type: LabelSection

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'CollectionRule') -> None: ...


class LabelPlacementPolicy(sip.wrapper):

    class Duplicates(int): ...
    DuplicatesAllow = ... # type: 'LabelPlacementPolicy.Duplicates'
    DuplicatesInterLayer = ... # type: 'LabelPlacementPolicy.Duplicates'
    DuplicatesIntraLayer = ... # type: 'LabelPlacementPolicy.Duplicates'
    DuplicatesDisable = ... # type: 'LabelPlacementPolicy.Duplicates'

    class ClipPolicy(int): ...
    ClipUse = ... # type: 'LabelPlacementPolicy.ClipPolicy'
    ClipSkip = ... # type: 'LabelPlacementPolicy.ClipPolicy'

    class LabelingAlgorithmType(int): ...
    AllowOverlap = ... # type: 'LabelPlacementPolicy.LabelingAlgorithmType'
    DisallowOverlap = ... # type: 'LabelPlacementPolicy.LabelingAlgorithmType'
    TryOtherPosition = ... # type: 'LabelPlacementPolicy.LabelingAlgorithmType'

    visibleRange = ... # type: VisibilityConstraints

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'LabelPlacementPolicy') -> None: ...

    def setClipPolicyCollection(self, clipPolicy: 'LabelPlacementPolicy.ClipPolicy') -> None: ...
    def setClipPolicyCurve(self, clipPolicy: 'LabelPlacementPolicy.ClipPolicy') -> None: ...
    def setClipPolicyArea(self, clipPolicy: 'LabelPlacementPolicy.ClipPolicy') -> None: ...
    def getClipPolicyCollection(self) -> 'LabelPlacementPolicy.ClipPolicy': ...
    def getClipPolicyCurve(self) -> 'LabelPlacementPolicy.ClipPolicy': ...
    def getClipPolicyArea(self) -> 'LabelPlacementPolicy.ClipPolicy': ...
    def setDuplicates(self, duplicates: 'LabelPlacementPolicy.Duplicates') -> None: ...
    def getDuplicates(self) -> 'LabelPlacementPolicy.Duplicates': ...
    def setLabelEverySection(self, labelEverySection: bool = ...) -> None: ...
    def getLabelEverySection(self) -> bool: ...
    def setOverhang(self, overhangPercent: int) -> None: ...
    def getOverhang(self) -> int: ...
    def setCollectionRules(self, collectionRules: list[CollectionRule]) -> None: ...
    def getCollectionRules(self) -> list[CollectionRule]: ...
    def setLabelingType(self, labelingType: 'LabelPlacementPolicy.LabelingAlgorithmType') -> None: ...
    def getLabelingType(self) -> 'LabelPlacementPolicy.LabelingAlgorithmType': ...
    def setVisiblePoint(self, v: bool) -> None: ...
    def getVisiblePoint(self) -> bool: ...
    def setVisibleCurve(self, v: bool) -> None: ...
    def getVisibleCurve(self) -> bool: ...
    def setVisibleArea(self, v: bool) -> None: ...
    def getVisibleArea(self) -> bool: ...
    def setVisible(self, v: bool) -> None: ...
    def getVisible(self) -> bool: ...
    def setLabelingDisplayMode(self, displayMode: LabelingDisplayMode) -> None: ...
    def labelingDisplayMode(self) -> LabelingDisplayMode: ...
    def isVisible(self, viewport: ViewportInterface) -> bool: ...


class RenderSettingsManager(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setSymbolStyleCatalog(self, symbolStyleCatalog: str) -> None: ...
    def symbolStyleCatalog(self) -> str: ...
    def setBrushStyleCatalog(self, brushStyleCatalog: str) -> None: ...
    def brushStyleCatalog(self) -> str: ...
    def setPenStyleCatalog(self, penStyleCatalog: str) -> None: ...
    def penStyleCatalog(self) -> str: ...
    def saveSettings(self, settings: QtCore.QSettings) -> None: ...
    def loadSettings(self, settings: QtCore.QSettings) -> None: ...


def polygonStyleForColor(color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> Style: ...
def collectionStyleForColor(color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> CollectionStyle: ...
def is_style(v: typing.Any) -> bool: ...
def style_cast(v: typing.Any) -> typing.Any: ...
def transformToScreen(geom: _core_geometry.Geometry, viewport: MapViewport) -> _core_geometry.Geometry: ...
