#!/usr/bin/python3
# -*- coding: utf-8 -*-

"""
Пример получения базового перечня открытых на данный момент  различного рода сущностей
"""

# Simple list of opened objects

# Import
from axioma.render import *

import axioma.app
import axioma.gui

widgetService = axioma.app.gui.widgetManager
# Mapviews
print ("-----Mapviews---- %d" % widgetService.count(axioma.gui.MapView.staticMetaObject))
for mapview in widgetService.allWidgets(axioma.gui.MapView.staticMetaObject):
    print("Name of mapview: %s" % mapview.name())
    print("Coordsystem: %s" % mapview.viewport().coordSystem().prjStr())
    print(" Cosmetic: %s" % mapview.rootLayerGroup().cosmeticLayer().name())
    for layer in mapview.rootLayerGroup().flatLayerList():
        print(" Layer: %s (Class=%s), Selectable=%r Editable=%r" % (layer.name(), layer.metaObject().className(), layer.canBeSelectable(), layer.canBeEditable()))
        if isinstance(layer, FeatureLayer):
            if layer.thematicLayerGroup().childCount():
                for tlayer in layer.thematicLayerGroup().flatLayerList():
                    print("  ThematicLayer: %s" % (tlayer.name()))
        else:
            print("Raster Layer: %s (Class=%s)" %  (layer.name(), layer.metaObject().className()))
# legends for map
    for legend in mapview.legendManager().legends():
        print("   LegendView name: %s" % legend.name() )
        for legend_item in legend.items():
            print("    Item %s (%s)" % (legend_item.item().name(), legend_item.item().metaObject().className()))

#Browsers
print ("-----Browsers---- %d" % widgetService.count(axioma.gui.TableWindow.staticMetaObject))
for tableWindow in widgetService.allWidgets(axioma.gui.TableWindow.staticMetaObject):
    print(" Name of browser: {} ({})".format(tableWindow.browser().name(), tableWindow.windowTitle()))

#ReportViews
try:
    print ("-----ReportVews---- %d" % widgetService.count(axioma.gui.ReportView.staticMetaObject))
    for reportview in widgetService.allWidgets(axioma.gui.ReportView.staticMetaObject):
        print("Name of reportview: %s" % reportview.name())
        for item in reportview.report().items():
            print("  Report item %s (%s)" % (item.name(), item.metaObject().className()))
except Exception as ex:
   print(ex)
   
# DataObjects
print ("-----DataObjects---- %d" % len(axioma.app.mainWindow.dataCatalog().allDataObjects()))
for obj in axioma.app.mainWindow.dataCatalog().allDataObjects():
    print("  Name of object: %s (%s)" % (obj.name(), obj.originalObject().metaObject().className()))



