#!/usr/bin/python3
# -*- coding: utf-8 -*-

# Импорт
from axioma.cs import *
from axioma.core.geometry import *
from axioma.mapinfo import *
from axioma.render import *

from PyQt5.QtCore import  *
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *

# Координатная система
cs_ne = CoordSysFactory.defaultCoordSysFactory().createFromPrj("CoordSys Nonearth Units \"m\"" )

# Преобразование цвета в формат MapBasic
def colorToMapbasic(color):
    return QColor(color).rgb() - 0xFF000000
 
# Создание полилинии
def createLineString():
    poly = QPolygonF();
    poly << QPointF(110,310) << QPointF(110,400) << QPointF(150,350) << QPointF(200,400) << QPointF(200,310)
    ls = LineString(cs_ne, poly)
    return ls

# Создание полигона
def createPolygon():
    poly = QPolygonF();
    poly << QPointF(10,310) << QPointF(10,400) << QPointF(50,350) << QPointF(100,400) << QPointF(100,310) << QPointF(10,310)
    polygon = Polygon(cs_ne, poly)
    return polygon
    
# Создание точки
def createPoint():
    return Point(cs_ne, 250, 350)

# Создание текста
def createText():
    text = Text(cs_ne, "Sample text", QPointF(300,350) )
    return text

class Example(QDialog):
    
    def __init__(self, parent):
        QDialog.__init__(self, parent)
        self.initUI()

    def initUI(self):      
        self.setGeometry(200, 200, 700, 400)
        self.setWindowTitle('Пример отрисовки геометрии со стилем')

# Преобразование координат геометрии из координат карты в координаты окна
    def transformGeometry(self, geom, context):
        return geom.transformed(context.sceneToDeviceTransform())

# Отрисовка геометрии с соответствующим стилем
    def drawGeometry(self, context, style, geom):
      if style is not None:
            geom_trans = self.transformGeometry(geom, context)
            style.draw(geom_trans, context)

    def drawPolygon(self, context, num, color):
      style = MapBasicStyle().styleFromString("Pen (1, 5, 16711935) Brush (%d, 255, %d)"  % (num, color))
      self.drawGeometry(context, style, createPolygon())

    def drawLineString(self, context, num, color):
      style = MapBasicStyle().styleFromString("Pen (2, %d,%d)"  % (num, color))
      self.drawGeometry(context, style, createLineString())
      
    def drawPoint(self, context, num, color):
      style = MapBasicStyle().styleFromString("Symbol (%d,%d, 24)"  % (num, color))
      self.drawGeometry(context, style, createPoint())
      
    def drawText(self, context):
        style = MapBasicStyle().styleFromString("Font (\"Arial\",1,9,16711680)")
        self.drawGeometry(context, style, createText())

# Создание контекста
    def createContext(self, painter, deviceRect):
        sceneRect = QRectF(0,0,600,400)
        viewport = MapViewport (deviceRect,sceneRect,cs_ne)
        return MapContext(painter, viewport)

# Отрисовка
    def paintEvent(self, event):
        try:
            painter = QPainter(self)
            painter.fillRect(event.rect(), Qt.white)
# Создание контекста
            context1 = self.createContext(painter, QRectF(0,10,600,400))
# И отрисовка его (С использованием строки mapbasic)
            self.drawPolygon(context1, 8, colorToMapbasic(Qt.red))
            self.drawLineString(context1, 2, colorToMapbasic(Qt.green))
            self.drawPoint(context1, 36, colorToMapbasic(Qt.red))
            self.drawText(context1)
# Сдвинем вниз
            context2 = self.createContext(painter, QRectF(0,140,600,400))
            self.drawPolygon(context2, 2, colorToMapbasic(Qt.blue))
            self.drawLineString(context2, 90, colorToMapbasic(Qt.black))
# Ещё раз сдвинем вниз
            context3 = self.createContext(painter, QRectF(0,270,600,400))
# Полигон (создаем явно через конструктор)
            pstyle = MapInfoPolygonStyle()
            p_fill = MapInfoFillStyle(4, Qt.darkRed)
            pstyle.setAreaStyle(p_fill)
            p_pen= MapInfoLineStyle()
            p_pen.setPattern(8)
            p_pen.setColor(Qt.darkBlue)
            pstyle.setPeripheryStyle(p_pen)
            self.drawGeometry(context3, pstyle, createPolygon())
# Полилиния
            pen= MapInfoLineStyle()
            pen.setPattern(56)
            pen.setColor(Qt.darkGreen)
            pen.setWidth(UnitValue(Unit.pixel(), 4))
            self.drawGeometry(context3, pen, createLineString())
# Точка
            fs = FontSymbolStyle()
            fs.setFont(QFont("Mapinfo Symbols", 32))
            fs.setSymbolMapinfo(37)
            fs.setColor(Qt.blue)
            self.drawGeometry(context3, fs, createPoint())
# Текст
            ts = OverrideMapInfoTextStyle() # Стиль
            style_data = MapInfoTextStyleData() # Данные для стиля
            renderer = TextRenderer() # Оформление текста
            font =  QFont("Arial")
            font.setBold(True)
            renderer.setFont(font)
            renderer.setColor(Qt.blue)
            style_data.setFontSize(24)
            style_data.setTextRenderer(renderer) # Установка оформления
            ts.setMapInfoTextStyleData(style_data)  # Установка данных со стилем
            text = createText() # Непосредственно сама геометрия
            text.setAngle(45)
            text.setTextStyleData(style_data) # Устанавливаем данные
            self.drawGeometry(context3, ts, text)
# Пример отрисовки с массивом стилей 
            # Создаем предварительно стили, которые поместим в массив
            style1 = MapBasicStyle().styleFromString("Pen (2,2,0) Brush (2,%d)" % (colorToMapbasic(Qt.red)))
            style2 = MapBasicStyle().styleFromString("Pen (2,2,0) Brush (2,%d)" % (colorToMapbasic(Qt.blue)))
            arrayStyle = ArrayStyle('red', style1) # Создаем массив с одним элементом
            arrayStyle.setStyle('blue', style2)  # Добавляем еще один стиль. Установлено 2 стиля с активным red
            rectangle1 = Rectangle(cs_ne, QRectF(500, 300, 50,50))
            self.drawGeometry(context1, arrayStyle, rectangle1) # Рисуем первый прямоугольник
            arrayStyle.setActiveStyle('blue') # Меняем активный стиль на значение blue
            rectangle2 = Rectangle(cs_ne, QRectF(500, 200, 50,50))
            self.drawGeometry(context1, arrayStyle, rectangle2) # Рисуем второй прямоугольник
# Пример отрисовки с композитным стилем
            # Создаем стили-элементы
            styleComp0 = MapBasicStyle().styleFromString("Pen (5,2,16711680)")
            styleComp1 = MapBasicStyle().styleFromString("Pen (2,2,16776960)")
            styleComp2 = MapBasicStyle().styleFromString("Pen (2,9,0)")
            # Создаем сам композитный стиль
            compositeStyle = CompositeStyle()
            # Последовательно (как должны быть отрисованы) добавляем элементы в стиль
            compositeStyle.append(styleComp0)
            compositeStyle.append(styleComp1)
            compositeStyle.append(styleComp2)
            # Стиль можно создать из строки MapBasic, в которой стили разделены '|' или ';' (альтернатива предыдущим строкам)
            #compositeStyle = MapBasicStyle().styleFromString("Pen (5,2,16711680)|Pen (2,2,16776960)|Pen (2,9,0)")
            line = Line(cs_ne, QLineF(QPointF(400,100), QPointF(600,100)))
            self.drawGeometry(context1, compositeStyle, line) # Рисуем линию

        except Exception as ex:
            print(ex)

dlg = Example(axioma.app.mainWindow)
dlg.exec()

