import sys
import axioma.gui.extension
from axioma.core.plugin import *
import PyQt5.QtGui
import PyQt5.QtCore

'''
Пример пользовательской кнопки с интегрированными зависимостями
'''

# Объявим расширение для действия с возможностью управления доступностью и режима переключателя
class MyActionControllerExtension(axioma.gui.NativeActionControllerExtension):
    def __init__(self, actionControllerFactory, actionId, icon, text, slot, checkable = False):
         controller = actionControllerFactory()
         controller.setCheckable(checkable)
         super().__init__(controller, actionId, axioma.gui.RibbonActionInfo())
         self.__icon = icon
         self.__text = text
         self.__slot = slot

    def customizeAction(self, action):
          action.setText(self.__text)
          action.setIcon(self.__icon)
          action.triggered.connect(self.__slot)
         
    def setEnabled(self, v): # доступность
        self.actionController().enableChanged.emit(v)

    #def  setCheckable(self, v): # режим переключателя
      #  self.actionController().setCheckable(v)
        #self.actionController().updateChecked()

    def setChecked(self, v): # Утоплено
        self.actionController().checkedChanged.emit(v)

def addTab(tabId, description):
  ribbonExt = axioma.gui.extension.RibbonExtension()
  ribbonExt.addTab(tabId, description)
  axioma.app.gui.prependExtension(ribbonExt)
  
def addGroup(tabId, groupId, description):
  ribbonExt = axioma.gui.extension.RibbonExtension()
  ribbonExt.addGroup(tabId, groupId, description)
  axioma.app.gui.prependExtension(ribbonExt)
    
def addAction(tabId, groupId, actonId):
    ribbonExt = axioma.gui.extension.RibbonExtension()
    ribbonExt.addAction(actonId, tabId, groupId)
    axioma.app.gui.prependExtension(ribbonExt)

# Обвязка для получения некоего подобия пользовательской кнопки
class CommonButton (PyQt5.QtCore.QObject):

    def __init__(self, actionId, icon, text, checkable = False, parent = None):
          super().__init__(parent)
          self.__register(actionId, icon, text, checkable)
          self.__function = None

    def setEnabled(self, v):
        self.__actionExt.setEnabled(v)
        
    def setChecked(self, v):
        self.__actionExt.setChecked(v)
        
    def __register(self, actionId, icon, text, checkable): # регистрация в системе в виде расширения
          self.__actionExt = MyActionControllerExtension(axioma.gui.extension.ActionController, "TestActionId", PyQt5.QtGui.QIcon(":/icons/share/32px/run.png"), "Тестовое действие", self.__onTriggered, checkable)
          axioma.app.gui.prependExtension(self.__actionExt)
          
    def setExternalFuncton(self, func): # Устанавливаем функцию-обработчик, не пренадлежащую классу
        self.__function = func

    def __onTriggered(self):
        if self.__function is not None: # Если задана внешняя функция, выполняется она
            self.__function()
        else:
            self.onTriggered()
            
    def onTriggered(self): # Слот. Можно переопределить в наследуемом классе
        pass
            

# Добавляем tab если это нужно
addTab("TestPluginTab", "Тестовый модуль")

# Добавляем группу
addGroup("TestPluginTab", "TestGroupId", "Тестовая группа")

# Создаем нечто подобии кнопки. Если мы хотим использовать в качестве обработика функцию, не принадлежащую классу

def myTriggered(): # внешний обработчик
        print ('Нажали кнопку')

button = CommonButton( "TestActionId", PyQt5.QtGui.QIcon(":/icons/share/32px/run.png"), "Тестовое действие", True)
button.setChecked(True) # утоплена
#button.setEnabled(False) # доступность
button.setExternalFuncton(myTriggered) # установка обработчика

'''
Или же если в качестве обработчика мы хотим использовать метод класса, то необходимо унаследовать свой класс и переопределить метод  onTriggered

class MyCommonButton (CommonButton):

    def __init__(self, actionId, icon, text, checkable = False, parent = None):
          super().__init__( actionId, icon, text, checkable, parent)

    def onTriggered(self):
        print ('Нажали кнопку')

button = MyCommonButton( "TestActionId", PyQt5.QtGui.QIcon(":/icons/share/32px/run.png"), "Тестовое действие")
'''

# Добавляем action в систему
addAction("TestPluginTab", "TestGroupId", "TestActionId")

