# Raster transform

from axioma.raster import *
from axioma.core.dp import PointBinding
from PyQt5.QtCore import QPointF
from axioma.cs import CoordSysFactory

'''
Пример трансформации и привязки растрового изображения. Обрабатывать будем копию входного файла.
'''

print("==========raster_transform===========")
print("Алгоритмы трансформации: ", ", ".join(availableTransformMethods().values()))
print("Методы сглаживания: ", ", ".join(availableResampleMethods().values()))
print("Доступные форматы: ", ", ".join(availableFormats().values()))
print("Доступные алгоритмы сжатия: ", ", ".join(availableCompression()))

# Задаем алгоритм трансформации
# get transform algorithm
alg = TransformAlgorithmFactory.create(ThinPlateSpline)

# Устанавливаем точки привязки
# ground control points, aka PointBindings
gcps = [PointBinding(QPointF(0, 0), QPointF(0, 0)),
        PointBinding(QPointF(0, 200), QPointF(0, 10)),
        PointBinding(QPointF(200, 0), QPointF(-10, 0))]

csf = CoordSysFactory.defaultCoordSysFactory()

# Задание параметров преобразования
# set transform parameters
alg.setOutputFormat("BMP")
# alg.setCompression()
# alg.setResampling()
alg.setGCPs(gcps)
alg.setCoordSys(csf.LatLongCoordSystem())

# Преобразование
# perform transformation
input_file = "/tmp/image.png"
output_file = "/tmp/image_out.png"

if input_file == "" or output_file == "":
    raise ValueError("Входной и/или выходной файлы не заданы")

print("Трансформация прошла успешно? - ", "Да" if alg.warp(input_file, output_file) else "Нет")