from PyQt5.QtWidgets import *
from PyQt5.QtGui import QIcon
from axioma.gui import RibbonId
import axioma.app
import axioma.gui.extension

'''
Пример создания пользовательского действия, которое доступно только при условии наличия выделения на карте и если выбран изменяемый объект.
'''


def init():
    return True

def createAction(parent):

    action = QAction(parent)
    action.setText("Действие над изменяемыми объектами")
    action.setObjectName("modActionId")
    action.setIcon(QIcon.fromTheme("erase_outer_target"))

    def onTriggered():
        QMessageBox.information(axioma.app.mainWindow, "Доступность операции","Заготовка для операций над изменяемыми объектами; действие доступно только при наличии изменямых и выделенных объектов")

    action.onTriggered = onTriggered
    action.triggered.connect(action.onTriggered)

    def onSelectionChanged():
        action.setEnabled(selection_manager.hasSelection() and selection_manager.hasTarget())

    action.onSelectionChanged = onSelectionChanged

    # управлять доступностью действия
    selection_manager = axioma.app.gui.selectionManager()
    selection_manager.selectionChanged.connect(action.onSelectionChanged)
    action.onSelectionChanged()

    return action


def createExtensions():
#    print("createExtensions called")
    ribbonExt = axioma.gui.extension.RibbonExtension()
    ribbonExt.addTab("TestPluginTab", "Тестовый плагин")
    ribbonExt.addGroup("TestPluginTab","TestGroupId", "Команды плагина")
    actionExt = axioma.gui.extension.ActionExtension(createAction, "modActionId")
    ribbonExt.addAction("modActionId", "TestPluginTab", "TestGroupId")
    return [ribbonExt, actionExt]
