'''

Пример отображения информации о иекущем состоянии каталога с данными.

dependencies:
MainWindow
'''

from PyQt5.QtWidgets import QDockWidget
from PyQt5.QtGui import QIcon
from PyQt5.QtCore import Qt
import axioma.app
import axioma.core.dp
import traceback

def create_dock_widget(widget, obj_name, title, icon=QIcon(), parent=None):
    """Создает плавающую панель"""
    dock = QDockWidget(title, parent)
    dock.setObjectName(obj_name)
    dock.setWidget(widget)
    dock.toggleViewAction().setObjectName(obj_name + "Toggle")
    dock.toggleViewAction().setIcon(icon)
    return dock

class DockExtension(axioma.core.plugin.Extension):
    def __init__(self):
        super().__init__()
        self.mainWindow = self.createDependencyGetter(axioma.app.MainWindow)

    def onResolved(self):
        try:
            # создаем док область
            from .datacatalog_info_widget import DataCatalogInfoWidget
            widget = DataCatalogInfoWidget(self.mainWindow())
            dock = create_dock_widget(widget, "dataCatalogInfoDock", "Информация о катологе данных", parent=self.mainWindow())

            # добавляем в главное окно
            self.mainWindow().addDockWidget(Qt.RightDockWidgetArea, dock)
            self.mainWindow().addPanel(dock)
        except:
            traceback.print_exc()

def createExtensions():
    return [DockExtension()]
