import axioma.app

'''
Показ открытой ранее таблицы в таблице просмотра.
Перед запуском необходимо открыть хотя бы один источник данных.
'''

class InitException(Exception):
    '''Ошибка инициализации'''

    def __init__(self, message):
        if type(message) is not str:
            raise TypeError()
        self.message = message

    def __str__(self):
        return "Ошибка инициализации: " + self.message


try:
    #Если аксиома уже запущена, главное окно доступно через axioma.app.mainWindow
    #alias
    window = axioma.app.mainWindow

    # window.listTables() # Список открытых таблиц
    tables = window.listTables()
    if not len(tables):
        raise InitException("Не открыто ни одной таблицы")
    #например, у таблиц можно вызвать методы
    #таблицы также являются Объектами Данных (DataObject), можно использовать методы родительского класса
    #выведем имена таблиц
    print("Существующие таблицы:", end=" ")
    print(", ".join([table.name() for table in tables]))

    # window.showTableData(tables) # Отображает таблицу в виде таблицы и возвращает отображаемый TableWindow
    # Покажем последнюю таблицу
    print("Таблица %s выведена на передний план" % tables[-1].name())
    window.showTableData(tables[-1])

except InitException as ex:
    print(ex)
