from axioma.core.dp import *
from axioma.cs import *
from axioma.core.geometry import *
from axioma.render import *
from axioma.mapinfo import *
from axioma.common import RuntimeException

from PyQt5.QtCore import *
from PyQt5.QtGui import *

'''
Пример вставки объекта в таблицу и сохранение информации об изменениях.
Здесь используется внешний файл транзакций.
'''

# Открываем таблицу
table = axioma.core.open_json({'src': '/tmp/world.tab'})
if table is None:
    raise RuntimeException("Таблица не открыта")
assert(isinstance(table, EditableTable))

# Создаем файл транзакций
history_snapshot = HistorySnapshot(table.featureIdComparator())

# Делаем выборку из двух записей
features = table.selectToFeatureList(QuerySelectAll(table.tableSchema().attributeNames()), PageRange(0, 2))

# Определяем индексы изменяемых полей
index_geometry = table.tableSchema().geometryIndex()
index_style = table.tableSchema().styleIndex()
index_country = table.tableSchema().indexOf('Country')

# Список атрибутов можно получить
# print (table.tableSchema().attributeNames())

# Вставка
new_feature =  Feature.createFeature(table.tableSchema())
# Устанавливаем геометрию по индексу поля
poly = QPolygonF();
v = 1000000
poly << QPointF(-v, -v) << QPointF(-v, v) << QPointF(v, v) << QPointF(v, -v) << QPointF(-v, -v)
polygon = Polygon(table.coordSystem(), poly)
new_feature.setAttribute(index_geometry, polygon)
new_feature.setModified(index_geometry, True)
# Устанавливаем стиль
style = MapBasicStyle().styleFromString('Pen (1,2,0) Brush (2, 65280, 16777215)')
new_feature.setAttribute(index_style, style)
new_feature.setModified(index_style, True)
# Строковае поле по его имени
new_feature.setAttribute('Country', 'New Country')
new_feature.setModified('Country', True)
# Сохраняем в файле транзакций
history_snapshot.storeNewfoundFeature(new_feature)

# Обновление
# Берем первую запись и обновляем для нее стиль оформления
if len(features) >= 1:
    feature = features[0]
    style_red = MapBasicStyle().styleFromString('Pen (1,2,0) Brush (2, 16711680, 16777215)')
    feature.setAttribute(index_style, style_red)
    feature.setModified(index_style, True)
    # Сохраняем в файле транзакций
    history_snapshot.storeUpdatedFeature(feature)

# Удаление
# Помечаем на удаление вторую выбранную запись
if len(features) >= 2:
    history_snapshot.storeGoneFeature(features[1].id())

# Сохраняем изменения из файла транзакций в таблице
table.save(history_snapshot)
