
import axioma
import axioma.core.geometry as gm
from axioma.core import open_json
from axioma.gui import ProgressSpec, showLongWait

def user_heavy_function(json):
    """
    Пример пользовательской функции выполняющей длительные вычисления
    """
    table = open_json(json)
    features = table.allFeatures()
    index_geo = table.tableSchema().geometryIndex()
    result = []
    for feature in features: 
        geom = feature.getAttribute(index_geo)
        if not gm.isValid(geom):
            geom = gm.normalizedGeometry(geom)
        result.append(gm.ConvexHull(geom))
    return result
    

json = {"src": "path/to/tab_file_name.TAB"}
spec = ProgressSpec("Получаем минимальный окаймляющий полигон", axioma.app.mainWindow)
result = showLongWait(spec, user_heavy_function, json)
print(result)
