import sys
from axioma.core.plugin import *
import axioma.gui.extension
import PyQt5.QtGui
import PyQt5.QtCore

'''
NativeActionControllerExtension используется для регистрации пользовательского действия в системе. При этом есть возможность изменения состояния в зависимости от окружения среды.
Другими словами если необходимо создать кнопку на панели инструментов, при этом реализовать возможность управления ее доступностью, необходимо использовать данный подход.
'''

# Определяем пользовательский контроллер
class MyActionController(axioma.gui.ActionControllerWithDependencies):
    def __init__(self, parent = None):
        super().__init__(parent)
        # Определяем необходимые зависимости. В данном случае у нас будет каталог с данными
        self._dataCatalog = self.createDependencyGetter(axioma.core.dp.DataCatalogInterface)
        
    def setup(self): # зависимость с каталогом разрешена
        self._dataCatalog().updated.connect(self.updateEnabled)

    # Переопределяем виртуальный метод isEnabled. Если каталог пуст, действие недоступно. Если открыта хотя бы одна таблица действие доступно.
    def  isEnabled(self): 
        return len(self._dataCatalog().allDataObjects()) > 0

# Объявим расширение для действия с возможностью управления доступностью и режима переключателя
class MyActionControllerExtension(axioma.gui.NativeActionControllerExtension):
    def __init__(self, actionControllerFactory, actionId, icon, text, slot, checkable = False):
         controller = actionControllerFactory()
         controller.setCheckable(checkable)
         super().__init__(controller, actionId, axioma.gui.RibbonActionInfo())
         self.__icon = icon
         self.__text = text
         self.__slot = slot

# Необходимо переопределить метод customizeAction, задав параметры для создаваемого объекта QAction
    def customizeAction(self, action):
          action.setText(self.__text)
          action.setIcon(self.__icon)
          action.triggered.connect(self.__slot)


def myTriggered(): # внешний обработчик. Можно сделать его в рамках класса MyActionControllerExtension
        print ('Нажали кнопку')

# Добавляем action в систему в закладку карты и категорию инструментов
ribbonExt = axioma.gui.extension.RibbonExtension()
# Создаем расширение и передаем в него класс нашего контроллера - MyActionController
actionExt = MyActionControllerExtension(MyActionController, "ControllerActionId", PyQt5.QtGui.QIcon(":/icons/share/32px/run.png"), "Тестовое действие", myTriggered)
#Регистрируем расширение
axioma.app.gui.prependExtension(actionExt)
# добавялем связанное действие в интерфейс
ribbonExt.addAction("ControllerActionId", "map", "tools")
axioma.app.gui.prependExtension(ribbonExt)

