import axioma.gui
import sys

from axioma.core.dp import *
from axioma.gui import *

from PyQt5.QtWidgets import QApplication

'''
Пример чтения и сохранения рабочего пространства
'''

a = QApplication(sys.argv)
gui = axioma.gui.Gui()
gui.initialize()

try:
# Чтение рабочего пространства из файла
# Создаем каталог с источниками данных
    catalog = DataCatalog()
# Читаем рабочее пространство из файла
    workspaceIn = Workspace() # внутреннее представление рабочего пространства
    fileName = '/home/dima/kdev/terix/test-data/ws_world.mws' # Имя файла для чтения
    workspaceIn.loadFile(fileName)
# Контекст для чтения. Устанавливаем куда мы будем сохранять прочитанное состояние
    context = WorkspaceLoadContext(gui, catalog)
    loader = WorkspaceLoader(fileName, context)
# Читаем из внутреннего представления
    loader.load(workspaceIn)
# Контролируем зачитанную информацию из рабочего пространства
    wm = axioma.app.gui.widgetManager
    print('tables={}, maps={}, reports={}, browsers={}'.format(len(catalog.allDataObjects()),
      wm.count(MapView.staticMetaObject), wm.count(ReportView.staticMetaObject), wm.count(TableWindow.staticMetaObject)))

# Сохранение рабочего пространства в файл
    fileNameOut = "/tmp/out.mws" # Имя файла для записи
# Создаем контекст для сохранения
    contextSave = WorkspaceSaveContext(gui, catalog)
# Создаем объект преобразования данных контекста во внутреннюю структуру
    saver = WorkspaceSaver(fileNameOut, contextSave)
# Созраняем во внутренний формат
    workspaceOut = saver.save()
# Сохраняем в файл
    workspaceOut.saveFile(fileNameOut)
except Exception as ex:
    print(ex)


