import axioma.render
from axioma.common import RuntimeException
from axioma.core.dp import *
from PyQt5.QtCore import  *
from PyQt5.QtGui import QGuiApplication
import sys
from axioma.cs import *

'''
Пример экспорта таблицы в TAB MapInfo. Для простоты создается копия таблицы под другим именем.
'''

a = QGuiApplication(sys.argv)
render = axioma.render.Render()
render.initialize()

# Открываем исходную таблицу
table = axioma.core.open_json({'src': '/tmp/SubjectRF.TAB'})
# Целевая координатная система
cs_merc = CoordSysFactory.defaultCoordSysFactory().createFromPrj("Earth Projection 10, 104, \"m\", 0")

try:
    if table is None:
        raise RuntimeException("Таблица не открыта")
    # Находим необходимый провайдер.
    dataProvider = axioma.app.core.dataProviderById("TabDataProvider")
    if dataProvider is not None:
# Устанавливаем параметры экспорта
        jd = JsonDefinition()
        JsonDataCreationController.setSource(jd, '/tmp/SubjectRF_copy.TAB')
        JsonDataCreationController.setPrj(jd, cs_merc)
        JsonDataCreationController.setCreate(jd, True)
        JsonDataCreationController.setOpenWith(jd, dataProvider.class_id())
        JsonDataCreationController.setAccessMode(jd, Access_ReadWrite)
# Создаем контекст
        context = ProviderExportContext(ModifiedTableSchema(table.tableSchema()))
# Открывем запрос для исходной таблицы
        cursor = table.select(QuerySelectAll( table.tableSchema().attributeNames()))
# Производим экспорт. Если необходим отклик системы предлагаем использовать SignalingCursor
        dataProvider.exportFeatures(cursor, context, jd)
    else:
        raise RuntimeException("Провайдер не найден")
except Exception as ex:
    print(ex)

