import os
from PyQt5.QtWidgets import QDialog
from PyQt5.QtCore import Qt, QRectF, QPointF
from PyQt5.uic import loadUi
from axioma.core import *

class BoundingRectDialog(QDialog):

    def __init__(self,  rect, parent=None):
      super().__init__(parent)
      cwd = os.path.dirname(__file__)
      self.__ui = loadUi(os.path.join(cwd, "BoundingRectDialog.ui"), self)
      self.setWindowModality(Qt.WindowModal)
      self.setAttribute(Qt.WA_DeleteOnClose)
      self.__initRect(rect)
      self.__rect = rect
      self.__ui.xValueStart.valueChanged.connect(self.onValueChanged)
      self.__ui.yValueStart.valueChanged.connect(self.onValueChanged)
      self.__ui.xValueEnd.valueChanged.connect(self.onValueChanged)
      self.__ui.yValueEnd.valueChanged.connect(self.onValueChanged)
      
    def setPrecision(self):
      prec = 6
      self.__ui.xValueStart.setDecimals(prec)
      self.__ui.yValueStart.setDecimals(prec)
      self.__ui.xValueEnd.setDecimals(prec)
      self.__ui.yValueEnd.setDecimals(prec)

    def __initRect(self, rect):
      self.setPrecision()
      self.__ui.xValueStart.setValue(rect.left())
      self.__ui.yValueStart.setValue(rect.bottom())
      self.__ui.xValueEnd.setValue(rect.right())
      self.__ui.yValueEnd.setValue(rect.top())
      
    def onValueChanged(self, value):
      self.__rect.setLeft(self.__ui.xValueStart.value())
      self.__rect.setBottom(self.__ui.yValueStart.value())
      self.__rect.setRight(self.__ui.xValueEnd.value())
      self.__rect.setTop(self.__ui.yValueEnd.value())
      
    def resultRect(self):
      return self.__rect
