from typing import List, Type

from .dbms_data_provider import DatabaseDataProvider
from .source import Destination, Source

__all__: List[str] = [
    "OracleSource",
    "OracleDestination",
    "OracleDataProvider",
]


class OracleSource(Source):
    pass


class OracleDestination(Destination):
    pass


class OracleDataProvider(DatabaseDataProvider):
    """
    Провайдер для Базы Данных Oracle.

    Пример с указанием имени таблицы::

        definition = provider_manager.oracle.get_source('localhost', 'test', 'oracle', 'oracle', dataobject='world')
        table = provider_manager.open(definition)

    Пример с указанием текста запроса::

        definition = provider_manager.oracle.get_source('localhost', 'test', 'oracle', 'oracle', sql="select * from world where Страна like 'Р%'")
        table = provider_manager.open(definition)


    Note:
        Для подключения к БД Oracle необходимо настроить ``Oracle Instant Client``.

        См. Руководство по установке и активации.

    Note:
        Ссылку на провайдер можно получить через глобальную переменную :attr:`axipy.provider_manager.oracle`.
    """

    @staticmethod
    def _identifier() -> str:
        return "OracleDataProvider"

    DEFAULT_PORT: int = 1521
    """Порт по умолчанию."""

    @property
    def _get_source_class(self) -> Type[OracleSource]:
        return OracleSource

    @property
    def _get_destination_class(self) -> Type[OracleDestination]:
        return OracleDestination
