import typing
from typing import ForwardRef
import PySide2.QtCore
import PySide2.QtGui
import shiboken2.Shiboken
from __future__ import annotations
import axipy.cpp_core_geometry
import axipy.cpp_cs
import typing
QJsonValue = typing.Any

__all__ = ['AccessMode', 'Access_ReadOnly', 'Access_ReadWrite', 'AdjustmentApplied', 'AdjustmentFailure', 'AdjustmentIsIgnored', 'AdjustmentIsIncompatible', 'AdjustmentResult', 'AdjustmentSkipped', 'CouldNotConvert', 'DirectUsage', 'ExpectedFailure', 'LosslessConversion', 'MajorValueLoss', 'MinorValueLoss', 'Nearly', 'Normal', 'NormalizationLevel', 'NormalizationLevelCount', 'NormalizationLevelLast', 'NormalizationResult', 'NormalizeResultCount', 'PointBinding', 'PreferChooseObject', 'PreferFirstObject', 'PreferableMode', 'RasterFacade', 'ShadowConverter', 'ShadowDataCatalog', 'ShadowDataObject', 'ShadowDatabaseLinkedTable', 'ShadowDatabaseTable', 'ShadowFeature', 'ShadowFeatureIterator', 'ShadowMapinfoMapcatalog', 'ShadowQueryTable', 'ShadowRaster', 'ShadowRasteredTable', 'ShadowSelectionTable', 'ShadowServiceOperation', 'ShadowTabMetadata', 'ShadowTable', 'ShadowTransactional', 'TableTypeGeometry', 'accessModeFromString', 'accessModeToString', 'bindPolygon', 'bindSize']
class AccessMode(shiboken2.Shiboken.Enum):
    Access_ReadOnly: typing.ClassVar[AccessMode]  # value = axipy.cpp_core_dp.AccessMode.Access_ReadOnly
    Access_ReadWrite: typing.ClassVar[AccessMode]  # value = axipy.cpp_core_dp.AccessMode.Access_ReadWrite
    values: typing.ClassVar[dict]  # value = {'Access_ReadOnly': axipy.cpp_core_dp.AccessMode.Access_ReadOnly, 'Access_ReadWrite': axipy.cpp_core_dp.AccessMode.Access_ReadWrite}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class AdjustmentResult(shiboken2.Shiboken.Enum):
    AdjustmentApplied: typing.ClassVar[AdjustmentResult]  # value = axipy.cpp_core_dp.AdjustmentResult.AdjustmentApplied
    AdjustmentFailure: typing.ClassVar[AdjustmentResult]  # value = axipy.cpp_core_dp.AdjustmentResult.AdjustmentFailure
    AdjustmentIsIgnored: typing.ClassVar[AdjustmentResult]  # value = axipy.cpp_core_dp.AdjustmentResult.AdjustmentIsIgnored
    AdjustmentIsIncompatible: typing.ClassVar[AdjustmentResult]  # value = axipy.cpp_core_dp.AdjustmentResult.AdjustmentIsIncompatible
    AdjustmentSkipped: typing.ClassVar[AdjustmentResult]  # value = axipy.cpp_core_dp.AdjustmentResult.AdjustmentSkipped
    values: typing.ClassVar[dict]  # value = {'AdjustmentSkipped': axipy.cpp_core_dp.AdjustmentResult.AdjustmentSkipped, 'AdjustmentApplied': axipy.cpp_core_dp.AdjustmentResult.AdjustmentApplied, 'AdjustmentFailure': axipy.cpp_core_dp.AdjustmentResult.AdjustmentFailure, 'AdjustmentIsIncompatible': axipy.cpp_core_dp.AdjustmentResult.AdjustmentIsIncompatible, 'AdjustmentIsIgnored': axipy.cpp_core_dp.AdjustmentResult.AdjustmentIsIgnored}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class NormalizationLevel(shiboken2.Shiboken.Enum):
    Nearly: typing.ClassVar[NormalizationLevel]  # value = axipy.cpp_core_dp.NormalizationLevel.Nearly
    Normal: typing.ClassVar[NormalizationLevel]  # value = axipy.cpp_core_dp.NormalizationLevel.Normal
    NormalizationLevelCount: typing.ClassVar[NormalizationLevel]  # value = axipy.cpp_core_dp.NormalizationLevel.NormalizationLevelCount
    NormalizationLevelLast: typing.ClassVar[NormalizationLevel]  # value = axipy.cpp_core_dp.NormalizationLevel.NormalizationLevelLast
    values: typing.ClassVar[dict]  # value = {'Normal': axipy.cpp_core_dp.NormalizationLevel.Normal, 'Nearly': axipy.cpp_core_dp.NormalizationLevel.Nearly, 'NormalizationLevelCount': axipy.cpp_core_dp.NormalizationLevel.NormalizationLevelCount, 'NormalizationLevelLast': axipy.cpp_core_dp.NormalizationLevel.NormalizationLevelLast}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class NormalizationResult(shiboken2.Shiboken.Enum):
    CouldNotConvert: typing.ClassVar[NormalizationResult]  # value = axipy.cpp_core_dp.NormalizationResult.CouldNotConvert
    DirectUsage: typing.ClassVar[NormalizationResult]  # value = axipy.cpp_core_dp.NormalizationResult.DirectUsage
    ExpectedFailure: typing.ClassVar[NormalizationResult]  # value = axipy.cpp_core_dp.NormalizationResult.ExpectedFailure
    LosslessConversion: typing.ClassVar[NormalizationResult]  # value = axipy.cpp_core_dp.NormalizationResult.LosslessConversion
    MajorValueLoss: typing.ClassVar[NormalizationResult]  # value = axipy.cpp_core_dp.NormalizationResult.MajorValueLoss
    MinorValueLoss: typing.ClassVar[NormalizationResult]  # value = axipy.cpp_core_dp.NormalizationResult.MinorValueLoss
    NormalizeResultCount: typing.ClassVar[NormalizationResult]  # value = axipy.cpp_core_dp.NormalizationResult.NormalizeResultCount
    values: typing.ClassVar[dict]  # value = {'DirectUsage': axipy.cpp_core_dp.NormalizationResult.DirectUsage, 'LosslessConversion': axipy.cpp_core_dp.NormalizationResult.LosslessConversion, 'MinorValueLoss': axipy.cpp_core_dp.NormalizationResult.MinorValueLoss, 'MajorValueLoss': axipy.cpp_core_dp.NormalizationResult.MajorValueLoss, 'ExpectedFailure': axipy.cpp_core_dp.NormalizationResult.ExpectedFailure, 'CouldNotConvert': axipy.cpp_core_dp.NormalizationResult.CouldNotConvert, 'NormalizeResultCount': axipy.cpp_core_dp.NormalizationResult.NormalizeResultCount}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class PointBinding(shiboken2.Shiboken.Object):
    __hash__: typing.ClassVar[None] = None
    @staticmethod
    def __copy__() -> None:
        ...
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def isEqual(self, other: PointBinding) -> bool:
        ...
    def isFinite(self) -> bool:
        ...
    def toTabString(self) -> str:
        ...
class PreferableMode(shiboken2.Shiboken.Enum):
    PreferChooseObject: typing.ClassVar[PreferableMode]  # value = axipy.cpp_core_dp.PreferableMode.PreferChooseObject
    PreferFirstObject: typing.ClassVar[PreferableMode]  # value = axipy.cpp_core_dp.PreferableMode.PreferFirstObject
    values: typing.ClassVar[dict]  # value = {'PreferFirstObject': axipy.cpp_core_dp.PreferableMode.PreferFirstObject, 'PreferChooseObject': axipy.cpp_core_dp.PreferableMode.PreferChooseObject}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
class RasterFacade(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def availableCompression() -> typing.List[str]:
        ...
    @staticmethod
    def availableFormats() -> typing.Dict[str, str]:
        ...
    @staticmethod
    def availableResampleMethods() -> typing.Dict[int, str]:
        ...
    @staticmethod
    def availableTransformMethods() -> typing.Dict[int, str]:
        ...
    @staticmethod
    def getGCPs(raster: ShadowRaster) -> typing.List[axipy.cpp_core_dp.PointBinding]:
        ...
    @staticmethod
    def getTransform(raster: ShadowRaster) -> PySide2.QtGui.QTransform:
        ...
    @staticmethod
    def registerAffine(filepath: str, transform: PySide2.QtGui.QTransform, coordsystem: axipy.cpp_cs.ShadowCoordSystem, fileOverride: bool) -> None:
        ...
    @staticmethod
    def registerPoints(filepath: str, points: typing.List[axipy.cpp_core_dp.PointBinding], coordsystem: axipy.cpp_cs.ShadowCoordSystem, fileOverride: bool) -> None:
        ...
    @staticmethod
    def transform(inputfile: str, outputfile: str, points: typing.List[axipy.cpp_core_dp.PointBinding], coordsystem: axipy.cpp_cs.ShadowCoordSystem, method: int, resampling: int, outputFormat: str, compression: str) -> None:
        ...
class ShadowConverter(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def convert(source: typing.Dict[str, QJsonValue], dest: typing.Dict[str, QJsonValue]) -> None:
        ...
    @staticmethod
    def convertAcadFile(definition: typing.Dict[str, QJsonValue]) -> None:
        ...
    @staticmethod
    def convertMifToTab(mifDefinition: typing.Dict[str, QJsonValue], tabDefinition: typing.Dict[str, QJsonValue]) -> None:
        ...
    @staticmethod
    def convertPanoramaMapToSxf(definition: typing.Dict[str, QJsonValue]) -> None:
        ...
    @staticmethod
    def convertPanoramaMapToTxf(definition: typing.Dict[str, QJsonValue]) -> None:
        ...
    @staticmethod
    def convertSxfFile(definition: typing.Dict[str, QJsonValue]) -> None:
        ...
    @staticmethod
    def convertTabToTab(definition: typing.Dict[str, QJsonValue]) -> None:
        ...
    @staticmethod
    def copyTabFiles(definition: typing.Dict[str, QJsonValue]) -> None:
        ...
    @staticmethod
    def mapStoreCoordConvert(definition: typing.Dict[str, QJsonValue]) -> typing.Any:
        ...
    @staticmethod
    def mifAsIterator(source: typing.Dict[str, QJsonValue]) -> ShadowFeatureIterator:
        ...
    @staticmethod
    def mifSchema(source: typing.Dict[str, QJsonValue]) -> typing.Dict[str, QJsonValue]:
        ...
    @staticmethod
    def providersInfo() -> typing.List[typing.Dict[str, QJsonValue]]:
        ...
    @staticmethod
    def removeSourceFiles(definition: typing.Dict[str, QJsonValue]) -> None:
        ...
    @staticmethod
    def saveAs(value: object, arg__2: typing.Dict[str, QJsonValue], arg__3: typing.Dict[str, QJsonValue]) -> None:
        ...
    @staticmethod
    def setAcadPalette(definition: typing.Dict[str, QJsonValue]) -> None:
        ...
class ShadowDataCatalog(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    added: typing.ClassVar[PySide2.QtCore.Signal] = ...
    dataSourcesUpdated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    removed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    tableDataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    updated: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def add(self, obj: ShadowDataObject) -> None:
        ...
    def count(self) -> int:
        ...
    def dataObjects(self, includeHidden: bool = False) -> typing.List[axipy.cpp_core_dp.ShadowDataObject]:
        ...
    def exists(self, obj: ShadowDataObject) -> bool:
        ...
    def findById(self, id: int) -> ShadowDataObject:
        ...
    def getDbSourceDestNames(self) -> typing.List[str]:
        ...
    def getDbSourceMap(self, key: str) -> typing.Dict[str, typing.Any]:
        ...
    def remove(self, obj: ShadowDataObject) -> None:
        ...
    def selectionTable(self) -> ShadowSelectionTable:
        ...
class ShadowDataObject(PySide2.QtCore.QObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    closeRequested: typing.ClassVar[PySide2.QtCore.Signal] = ...
    innerDestroyed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def closeRequest(self) -> None:
        ...
    def isEqual(self, other: ShadowDataObject) -> bool:
        ...
    def isHidden(self) -> bool:
        ...
    def isSpatial(self) -> bool:
        ...
    def isValid(self) -> bool:
        ...
    def name(self) -> str:
        ...
    def onCloseRequested(self) -> None:
        ...
    def originalObject(self) -> ShadowDataObject:
        ...
    def properties(self) -> typing.Dict[str, QJsonValue]:
        ...
    def provider(self) -> str:
        ...
    def setIsHidden(self, v: bool) -> None:
        ...
    def setName(self, name: str) -> None:
        ...
class ShadowDatabaseLinkedTable(ShadowDatabaseTable):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def refresh(self) -> None:
        ...
class ShadowDatabaseTable(ShadowTable):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def sqlText(self) -> str:
        ...
class ShadowFeature(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def contains(*args, **kwargs):
        ...
    @staticmethod
    def geometry(feat: ShadowFeature) -> axipy.cpp_core_geometry.ShadowGeometry:
        ...
    @staticmethod
    def setValue(*args, **kwargs):
        ...
    @staticmethod
    def style(feat: ShadowFeature) -> axipy.cpp_core_geometry.ShadowStyle:
        ...
    @staticmethod
    def value(*args, **kwargs):
        ...
    def __contains__(self, key):
        """
        Return key in self.
        """
    def __delitem__(self, key):
        """
        Delete self[key].
        """
    def __getitem__(self, key):
        """
        Return self[key].
        """
    def __len__(self):
        """
        Return len(self).
        """
    def __setitem__(self, key, value):
        """
        Set self[key] to value.
        """
    def hasGeometry(self) -> bool:
        ...
    def hasStyle(self) -> bool:
        ...
    def id(self) -> int:
        ...
    def indexToKey(self, index: int) -> str:
        ...
    def isGeometry(self, index: int) -> bool:
        ...
    def isStyle(self, index: int) -> bool:
        ...
    def keyToIndex(self, key: str) -> int:
        ...
    def keys(self) -> typing.List[str]:
        ...
    def setGeometry(self, geometry: axipy.cpp_core_geometry.ShadowGeometry) -> None:
        ...
    def setId(self, newId: int) -> None:
        ...
    def setStyle(self, shadowStyle: axipy.cpp_core_geometry.ShadowStyle) -> None:
        ...
    def size(self) -> int:
        ...
    def to_clipboard(self) -> None:
        ...
class ShadowFeatureIterator(shiboken2.Shiboken.Object):
    @staticmethod
    def __copy__() -> None:
        ...
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __iter__(self) -> ShadowFeatureIterator:
        """
        Implement iter(self).
        """
    def __next__(self) -> ShadowFeature:
        """
        Implement next(self).
        """
    def atEnd(self) -> bool:
        ...
    def item(self) -> ShadowFeature:
        ...
    def moveNext(self) -> bool:
        ...
class ShadowMapinfoMapcatalog(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def coordsystem(catalog: ShadowMapinfoMapcatalog, owner: str, table: str) -> axipy.cpp_cs.ShadowCoordSystem:
        ...
    def create_structure(self, fill: bool = False) -> None:
        ...
    def is_registered(self, owner: str, table: str) -> bool:
        ...
    def rect(self, owner: str, table: str) -> PySide2.QtCore.QRectF:
        ...
    def register_table(self, owner: str, table: str, geomFieldName: str, objType: TableTypeGeometry = ...) -> None:
        ...
    def set_attribute_name(self, owner: str, table: str, styleAttribute: str) -> None:
        ...
    def set_coordsystem(self, owner: str, table: str, cs: axipy.cpp_cs.ShadowCoordSystem) -> None:
        ...
    def set_rect(self, owner: str, table: str, rect: PySide2.QtCore.QRectF) -> None:
        ...
    def set_style_string(self, owner: str, table: str, styleStr: str) -> None:
        ...
    def set_type_objects(self, owner: str, table: str, t: TableTypeGeometry) -> None:
        ...
    def set_xy_column_names(self, owner: str, table: str, names: typing.Tuple[str, str]) -> None:
        ...
    def style_attribute_name(self, owner: str, table: str) -> str:
        ...
    def style_string(self, owner: str, table: str) -> str:
        ...
    def type_objects(self, owner: str, table: str) -> TableTypeGeometry:
        ...
    def unregister_table(self, owner: str, table: str) -> None:
        ...
    def xy_column_names(self, owner: str, table: str) -> typing.Tuple[str, str]:
        ...
class ShadowQueryTable(ShadowTable):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def sqlText(self) -> str:
        ...
class ShadowRaster(ShadowDataObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def coordSystem(raster: ShadowRaster) -> axipy.cpp_cs.ShadowCoordSystem:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def size(self) -> PySide2.QtCore.QSize:
        ...
class ShadowRasteredTable(ShadowDataObject):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def coordSystem(raster: ShadowRasteredTable) -> axipy.cpp_cs.ShadowCoordSystem:
        ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def layerList(self) -> typing.List[str]:
        ...
    def schema(self) -> typing.Dict[str, QJsonValue]:
        ...
    def selectAll(self) -> ShadowFeatureIterator:
        ...
    def selectForLayer(self, layerName: str) -> ShadowFeatureIterator:
        ...
class ShadowSelectionTable(ShadowTable):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
class ShadowServiceOperation(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def getCoordSystemString(json: typing.Dict[str, QJsonValue]) -> str:
        ...
    @staticmethod
    def panoramaSupportedCoordSystem(definition: typing.Dict[str, QJsonValue]) -> bool:
        ...
    @staticmethod
    def registerGdalPlugin(json: typing.Dict[str, QJsonValue]) -> None:
        ...
class ShadowTabMetadata(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def known_keys() -> typing.Dict[str, QJsonValue]:
        ...
    def get_value(self, key: str) -> str:
        ...
    def keys(self) -> typing.List[str]:
        ...
    def set_value(self, key: str, value: str) -> None:
        ...
class ShadowTable(ShadowDataObject, ShadowTransactional):
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject]  # value = <PySide2.QtCore.QMetaObject object>
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def coordSystem(table: ShadowTable) -> axipy.cpp_cs.ShadowCoordSystem:
        ...
    dataChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    schemaChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def accessMode(self) -> AccessMode:
        ...
    def calculateMbr(self) -> PySide2.QtCore.QRectF:
        ...
    def contentTypes(self) -> typing.List[axipy.cpp_core_dp.TableTypeGeometry]:
        ...
    def count(self) -> int:
        ...
    def countInMbr(self, mbr: PySide2.QtCore.QRectF) -> int:
        ...
    def get_hotlink(self) -> str:
        ...
    def id(self) -> int:
        ...
    def isTemporary(self) -> bool:
        ...
    def itemsById(self, ids: typing.List[int]) -> ShadowFeatureIterator:
        ...
    def itemsInMbr(self, mbr: PySide2.QtCore.QRectF) -> ShadowFeatureIterator:
        ...
    def itemsInObject(self, geometry: axipy.cpp_core_geometry.ShadowGeometry) -> ShadowFeatureIterator:
        ...
    def schema(self) -> typing.Dict[str, QJsonValue]:
        ...
    def selectAll(self) -> ShadowFeatureIterator:
        ...
    def set_hotlink(self, value: str) -> None:
        ...
    def supportedOperations(self) -> int:
        ...
class ShadowTransactional(shiboken2.Shiboken.Object):
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    def __delattr__(self, name):
        """
        Implement delattr(self, name).
        """
    def __setattr__(self, name, value):
        """
        Implement setattr(self, name, value).
        """
    def autoCommit(self) -> bool:
        ...
    def canRedo(self, steps: int) -> bool:
        ...
    def canUndo(self, steps: int) -> bool:
        ...
    def commit(self) -> None:
        ...
    def hasModified(self) -> bool:
        ...
    def insert(self, value: object) -> None:
        ...
    def isEditable(self) -> bool:
        ...
    def redo(self, steps: int) -> None:
        ...
    def remove(self, ids: typing.List[int]) -> None:
        ...
    def rollback(self) -> None:
        ...
    def setAutoCommit(self, v: bool) -> None:
        ...
    def setSchema(self, newSchema: typing.Dict[str, QJsonValue]) -> None:
        ...
    def undo(self, steps: int) -> None:
        ...
    def update(self, value: object) -> None:
        ...
class TableTypeGeometry(shiboken2.Shiboken.Enum):
    Lines: typing.ClassVar[TableTypeGeometry]  # value = axipy.cpp_core_dp.TableTypeGeometry.Lines
    Points: typing.ClassVar[TableTypeGeometry]  # value = axipy.cpp_core_dp.TableTypeGeometry.Points
    Polygons: typing.ClassVar[TableTypeGeometry]  # value = axipy.cpp_core_dp.TableTypeGeometry.Polygons
    Texts: typing.ClassVar[TableTypeGeometry]  # value = axipy.cpp_core_dp.TableTypeGeometry.Texts
    Unknown: typing.ClassVar[TableTypeGeometry]  # value = axipy.cpp_core_dp.TableTypeGeometry.Unknown
    values: typing.ClassVar[dict]  # value = {'Unknown': axipy.cpp_core_dp.TableTypeGeometry.Unknown, 'Points': axipy.cpp_core_dp.TableTypeGeometry.Points, 'Lines': axipy.cpp_core_dp.TableTypeGeometry.Lines, 'Polygons': axipy.cpp_core_dp.TableTypeGeometry.Polygons, 'Texts': axipy.cpp_core_dp.TableTypeGeometry.Texts}
    @staticmethod
    def __new__(type, *args, **kwargs):
        """
        Create and return a new object.  See help(type) for accurate signature.
        """
    @staticmethod
    def __reduce__(*args, **kwargs):
        ...
    def __add__(self, value):
        """
        Return self+value.
        """
    def __and__(self, value):
        """
        Return self&value.
        """
    def __bool__(self):
        """
        self != 0
        """
    def __eq__(self, value):
        """
        Return self==value.
        """
    def __ge__(self, value):
        """
        Return self>=value.
        """
    def __gt__(self, value):
        """
        Return self>value.
        """
    def __hash__(self):
        """
        Return hash(self).
        """
    def __index__(self):
        """
        Return self converted to an integer, if self is suitable for use as an index into a list.
        """
    def __int__(self):
        """
        int(self)
        """
    def __le__(self, value):
        """
        Return self<=value.
        """
    def __lt__(self, value):
        """
        Return self<value.
        """
    def __mul__(self, value):
        """
        Return self*value.
        """
    def __ne__(self, value):
        """
        Return self!=value.
        """
    def __or__(self, value):
        """
        Return self|value.
        """
    def __pos__(self):
        """
        +self
        """
    def __radd__(self, value):
        """
        Return value+self.
        """
    def __rand__(self, value):
        """
        Return value&self.
        """
    def __repr__(self):
        """
        Return repr(self).
        """
    def __rmul__(self, value):
        """
        Return value*self.
        """
    def __ror__(self, value):
        """
        Return value|self.
        """
    def __rsub__(self, value):
        """
        Return value-self.
        """
    def __rxor__(self, value):
        """
        Return value^self.
        """
    def __str__(self):
        """
        Return str(self).
        """
    def __sub__(self, value):
        """
        Return self-value.
        """
    def __xor__(self, value):
        """
        Return self^value.
        """
def accessModeFromString(text: str, ifNull: AccessMode = ...) -> AccessMode:
    ...
def accessModeToString(mode: AccessMode) -> str:
    ...
def bindPolygon(points: typing.List[PySide2.QtCore.QPoint]) -> typing.List[axipy.cpp_core_dp.PointBinding]:
    ...
def bindSize(size: PySide2.QtCore.QSizeF) -> typing.List[axipy.cpp_core_dp.PointBinding]:
    ...
Access_ReadOnly: AccessMode  # value = axipy.cpp_core_dp.AccessMode.Access_ReadOnly
Access_ReadWrite: AccessMode  # value = axipy.cpp_core_dp.AccessMode.Access_ReadWrite
AdjustmentApplied: AdjustmentResult  # value = axipy.cpp_core_dp.AdjustmentResult.AdjustmentApplied
AdjustmentFailure: AdjustmentResult  # value = axipy.cpp_core_dp.AdjustmentResult.AdjustmentFailure
AdjustmentIsIgnored: AdjustmentResult  # value = axipy.cpp_core_dp.AdjustmentResult.AdjustmentIsIgnored
AdjustmentIsIncompatible: AdjustmentResult  # value = axipy.cpp_core_dp.AdjustmentResult.AdjustmentIsIncompatible
AdjustmentSkipped: AdjustmentResult  # value = axipy.cpp_core_dp.AdjustmentResult.AdjustmentSkipped
CouldNotConvert: NormalizationResult  # value = axipy.cpp_core_dp.NormalizationResult.CouldNotConvert
DirectUsage: NormalizationResult  # value = axipy.cpp_core_dp.NormalizationResult.DirectUsage
ExpectedFailure: NormalizationResult  # value = axipy.cpp_core_dp.NormalizationResult.ExpectedFailure
LosslessConversion: NormalizationResult  # value = axipy.cpp_core_dp.NormalizationResult.LosslessConversion
MajorValueLoss: NormalizationResult  # value = axipy.cpp_core_dp.NormalizationResult.MajorValueLoss
MinorValueLoss: NormalizationResult  # value = axipy.cpp_core_dp.NormalizationResult.MinorValueLoss
Nearly: NormalizationLevel  # value = axipy.cpp_core_dp.NormalizationLevel.Nearly
Normal: NormalizationLevel  # value = axipy.cpp_core_dp.NormalizationLevel.Normal
NormalizationLevelCount: NormalizationLevel  # value = axipy.cpp_core_dp.NormalizationLevel.NormalizationLevelCount
NormalizationLevelLast: NormalizationLevel  # value = axipy.cpp_core_dp.NormalizationLevel.NormalizationLevelLast
NormalizeResultCount: NormalizationResult  # value = axipy.cpp_core_dp.NormalizationResult.NormalizeResultCount
PreferChooseObject: PreferableMode  # value = axipy.cpp_core_dp.PreferableMode.PreferChooseObject
PreferFirstObject: PreferableMode  # value = axipy.cpp_core_dp.PreferableMode.PreferFirstObject
