import logging
from pathlib import Path
from typing import List, Optional

__all__: List[str] = [
    "Dependencies",
]


class Dependencies:
    def __init__(self, requirements_file: Path) -> None:
        self._requirements_file: Path = requirements_file

    @property
    def requirements(self) -> Path:
        """File with requirements."""
        return self._requirements_file

    def packages(self) -> List[str]:
        # split process by packages
        with open(str(self.requirements), "r") as deps_file:
            data = deps_file.read()

        return self._to_list(data)

    @staticmethod
    def _to_list(data: str) -> List[str]:
        return data.split("\n")

    @staticmethod
    def find(plugin_dir: Path) -> Optional["Dependencies"]:
        """Finds dependencies in a plugin."""
        requirements_file = plugin_dir / "requirements.txt"
        logging.debug(f"Check file with deps: {requirements_file}")
        if not requirements_file.is_file():
            return None
        return Dependencies(requirements_file)
