from typing import overload
import datetime
import shiboken2
import typing
T = typing.TypeVar('T')
QtCriticalMsg: QtMsgType
QtDebugMsg: QtMsgType
QtFatalMsg: QtMsgType
QtInfoMsg: QtMsgType
QtSystemMsg: QtMsgType
QtWarningMsg: QtMsgType

class ClassInfo:
    def __init__(self, **info: typing.Dict[str,str]) -> None: ...
    def __call__(self, *args, **kwargs) -> typing.Any: ...

class MetaFunction:
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def __call__(self, *args: typing.Any) -> typing.Any: ...

class MetaSignal(type):
    @classmethod
    def __instancecheck__(cls, object: object) -> bool: ...

class Property:
    fdel: typing.Any
    fget: typing.Any
    freset: typing.Any
    fset: typing.Any
    def __init__(self, type: type, fget: typing.Union[typing.Callable,None] = ..., fset: typing.Union[typing.Callable,None] = ..., freset: typing.Union[typing.Callable,None] = ..., fdel: typing.Union[typing.Callable,None] = ..., doc: str = ..., notify: typing.Union[typing.Callable,None] = ..., designable: bool = ..., scriptable: bool = ..., stored: bool = ..., user: bool = ..., constant: bool = ..., final: bool = ...) -> None: ...
    def deleter(self, func: typing.Callable) -> None: ...
    def getter(self, func: typing.Callable) -> None: ...
    def read(self, func: typing.Callable) -> None: ...
    def resetter(self, *args, **kwargs) -> typing.Any: ...
    def setter(self, func: typing.Callable) -> None: ...
    def write(self, func: typing.Callable) -> None: ...
    def __call__(self, *args, **kwargs) -> typing.Any: ...

class QAbstractAnimation(QObject):
    class DeletionPolicy:
        DeleteWhenStopped: typing.ClassVar[QAbstractAnimation.DeletionPolicy] = ...
        KeepWhenStopped: typing.ClassVar[QAbstractAnimation.DeletionPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractAnimation.DeletionPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractAnimation.DeletionPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractAnimation.DeletionPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractAnimation.DeletionPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractAnimation.DeletionPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractAnimation.DeletionPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractAnimation.DeletionPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractAnimation.DeletionPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractAnimation.DeletionPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractAnimation.DeletionPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractAnimation.DeletionPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractAnimation.DeletionPolicy: ...

    class Direction:
        Backward: typing.ClassVar[QAbstractAnimation.Direction] = ...
        Forward: typing.ClassVar[QAbstractAnimation.Direction] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractAnimation.Direction: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractAnimation.Direction: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractAnimation.Direction: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractAnimation.Direction: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractAnimation.Direction: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractAnimation.Direction: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractAnimation.Direction: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractAnimation.Direction: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractAnimation.Direction: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractAnimation.Direction: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractAnimation.Direction: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractAnimation.Direction: ...

    class State:
        Paused: typing.ClassVar[QAbstractAnimation.State] = ...
        Running: typing.ClassVar[QAbstractAnimation.State] = ...
        Stopped: typing.ClassVar[QAbstractAnimation.State] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractAnimation.State: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractAnimation.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractAnimation.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractAnimation.State: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractAnimation.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractAnimation.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractAnimation.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractAnimation.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractAnimation.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractAnimation.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractAnimation.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractAnimation.State: ...
    Backward: typing.ClassVar[QAbstractAnimation.Direction] = ...
    DeleteWhenStopped: typing.ClassVar[QAbstractAnimation.DeletionPolicy] = ...
    Forward: typing.ClassVar[QAbstractAnimation.Direction] = ...
    KeepWhenStopped: typing.ClassVar[QAbstractAnimation.DeletionPolicy] = ...
    Paused: typing.ClassVar[QAbstractAnimation.State] = ...
    Running: typing.ClassVar[QAbstractAnimation.State] = ...
    Stopped: typing.ClassVar[QAbstractAnimation.State] = ...
    currentLoopChanged: typing.ClassVar[Signal] = ...
    directionChanged: typing.ClassVar[Signal] = ...
    finished: typing.ClassVar[Signal] = ...
    stateChanged: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def currentLoop(self) -> int: ...
    def currentLoopTime(self) -> int: ...
    def currentTime(self) -> int: ...
    def direction(self) -> QAbstractAnimation.Direction: ...
    def duration(self) -> int: ...
    def event(self, event: QEvent) -> bool: ...
    def group(self) -> QAnimationGroup: ...
    def loopCount(self) -> int: ...
    def pause(self) -> None: ...
    def resume(self) -> None: ...
    def setCurrentTime(self, msecs: int) -> None: ...
    def setDirection(self, direction: QAbstractAnimation.Direction) -> None: ...
    def setLoopCount(self, loopCount: int) -> None: ...
    def setPaused(self, arg__1: bool) -> None: ...
    def start(self, policy: QAbstractAnimation.DeletionPolicy = ...) -> None: ...
    def state(self) -> QAbstractAnimation.State: ...
    def stop(self) -> None: ...
    def totalDuration(self) -> int: ...
    def updateCurrentTime(self, currentTime: int) -> None: ...
    def updateDirection(self, direction: QAbstractAnimation.Direction) -> None: ...
    def updateState(self, newState: QAbstractAnimation.State, oldState: QAbstractAnimation.State) -> None: ...

class QAbstractEventDispatcher(QObject):
    class TimerInfo(shiboken2.Object):
        interval: typing.Any
        timerId: typing.Any
        timerType: typing.Any
        def __init__(self, id: int, i: int, t: Qt.TimerType) -> None: ...
    aboutToBlock: typing.ClassVar[Signal] = ...
    awake: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def closingDown(self) -> None: ...
    def filterNativeEvent(self, eventType: typing.Union[QByteArray,bytes], message: int) -> typing.Tuple[bool,int]: ...
    def flush(self) -> None: ...
    def hasPendingEvents(self) -> bool: ...
    def installNativeEventFilter(self, filterObj: QAbstractNativeEventFilter) -> None: ...
    @classmethod
    def instance(cls, thread: typing.Union[QThread,None] = ...) -> QAbstractEventDispatcher: ...
    def interrupt(self) -> None: ...
    def processEvents(self, flags: typing.Union[QEventLoop.ProcessEventsFlags,QEventLoop.ProcessEventsFlag]) -> bool: ...
    def registerSocketNotifier(self, notifier: QSocketNotifier) -> None: ...
    @overload
    def registerTimer(self, timerId: int, interval: int, timerType: Qt.TimerType, object: QObject) -> None: ...
    @overload
    def registerTimer(self, interval: int, timerType: Qt.TimerType, object: QObject) -> int: ...
    def registeredTimers(self, object: QObject) -> typing.List[QAbstractEventDispatcher.TimerInfo]: ...
    def remainingTime(self, timerId: int) -> int: ...
    def removeNativeEventFilter(self, filterObj: QAbstractNativeEventFilter) -> None: ...
    def startingUp(self) -> None: ...
    def unregisterSocketNotifier(self, notifier: QSocketNotifier) -> None: ...
    def unregisterTimer(self, timerId: int) -> bool: ...
    def unregisterTimers(self, object: QObject) -> bool: ...
    def wakeUp(self) -> None: ...

class QAbstractItemModel(QObject):
    class CheckIndexOption:
        DoNotUseParent: typing.ClassVar[QAbstractItemModel.CheckIndexOption] = ...
        IndexIsValid: typing.ClassVar[QAbstractItemModel.CheckIndexOption] = ...
        NoOption: typing.ClassVar[QAbstractItemModel.CheckIndexOption] = ...
        ParentIsInvalid: typing.ClassVar[QAbstractItemModel.CheckIndexOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractItemModel.CheckIndexOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QAbstractItemModel.CheckIndexOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractItemModel.CheckIndexOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractItemModel.CheckIndexOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractItemModel.CheckIndexOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractItemModel.CheckIndexOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractItemModel.CheckIndexOptions: ...

    class CheckIndexOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractItemModel.CheckIndexOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QAbstractItemModel.CheckIndexOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractItemModel.CheckIndexOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractItemModel.CheckIndexOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractItemModel.CheckIndexOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractItemModel.CheckIndexOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractItemModel.CheckIndexOptions: ...

    class LayoutChangeHint:
        HorizontalSortHint: typing.ClassVar[QAbstractItemModel.LayoutChangeHint] = ...
        NoLayoutChangeHint: typing.ClassVar[QAbstractItemModel.LayoutChangeHint] = ...
        VerticalSortHint: typing.ClassVar[QAbstractItemModel.LayoutChangeHint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractItemModel.LayoutChangeHint: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractItemModel.LayoutChangeHint: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractItemModel.LayoutChangeHint: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractItemModel.LayoutChangeHint: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractItemModel.LayoutChangeHint: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractItemModel.LayoutChangeHint: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractItemModel.LayoutChangeHint: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractItemModel.LayoutChangeHint: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractItemModel.LayoutChangeHint: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractItemModel.LayoutChangeHint: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractItemModel.LayoutChangeHint: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractItemModel.LayoutChangeHint: ...
    HorizontalSortHint: typing.ClassVar[QAbstractItemModel.LayoutChangeHint] = ...
    NoLayoutChangeHint: typing.ClassVar[QAbstractItemModel.LayoutChangeHint] = ...
    VerticalSortHint: typing.ClassVar[QAbstractItemModel.LayoutChangeHint] = ...
    columnsAboutToBeInserted: typing.ClassVar[Signal] = ...
    columnsAboutToBeMoved: typing.ClassVar[Signal] = ...
    columnsAboutToBeRemoved: typing.ClassVar[Signal] = ...
    columnsInserted: typing.ClassVar[Signal] = ...
    columnsMoved: typing.ClassVar[Signal] = ...
    columnsRemoved: typing.ClassVar[Signal] = ...
    dataChanged: typing.ClassVar[Signal] = ...
    headerDataChanged: typing.ClassVar[Signal] = ...
    layoutAboutToBeChanged: typing.ClassVar[Signal] = ...
    layoutChanged: typing.ClassVar[Signal] = ...
    modelAboutToBeReset: typing.ClassVar[Signal] = ...
    modelReset: typing.ClassVar[Signal] = ...
    rowsAboutToBeInserted: typing.ClassVar[Signal] = ...
    rowsAboutToBeMoved: typing.ClassVar[Signal] = ...
    rowsAboutToBeRemoved: typing.ClassVar[Signal] = ...
    rowsInserted: typing.ClassVar[Signal] = ...
    rowsMoved: typing.ClassVar[Signal] = ...
    rowsRemoved: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def beginInsertColumns(self, parent: QModelIndex, first: int, last: int) -> None: ...
    def beginInsertRows(self, parent: QModelIndex, first: int, last: int) -> None: ...
    def beginMoveColumns(self, sourceParent: QModelIndex, sourceFirst: int, sourceLast: int, destinationParent: QModelIndex, destinationColumn: int) -> bool: ...
    def beginMoveRows(self, sourceParent: QModelIndex, sourceFirst: int, sourceLast: int, destinationParent: QModelIndex, destinationRow: int) -> bool: ...
    def beginRemoveColumns(self, parent: QModelIndex, first: int, last: int) -> None: ...
    def beginRemoveRows(self, parent: QModelIndex, first: int, last: int) -> None: ...
    def beginResetModel(self) -> None: ...
    def buddy(self, index: QModelIndex) -> QModelIndex: ...
    def canDropMimeData(self, data: QMimeData, action: Qt.DropAction, row: int, column: int, parent: QModelIndex) -> bool: ...
    def canFetchMore(self, parent: QModelIndex) -> bool: ...
    def changePersistentIndex(self, from_: QModelIndex, to: QModelIndex) -> None: ...
    def changePersistentIndexList(self, from_: typing.List[int], to: typing.List[int]) -> None: ...
    def checkIndex(self, index: QModelIndex, options: typing.Union[QAbstractItemModel.CheckIndexOptions,QAbstractItemModel.CheckIndexOption] = ...) -> bool: ...
    def columnCount(self, parent: QModelIndex = ...) -> int: ...
    @overload
    def createIndex(self, row: int, column: int, id: int = ...) -> QModelIndex: ...
    @overload
    def createIndex(self, row: int, column: int, ptr: object) -> QModelIndex: ...
    def data(self, index: QModelIndex, role: Qt.ItemDataRole = ...) -> typing.Any: ...
    def decodeData(self, row: int, column: int, parent: QModelIndex, stream: QDataStream) -> bool: ...
    def dropMimeData(self, data: QMimeData, action: Qt.DropAction, row: int, column: int, parent: QModelIndex) -> bool: ...
    def encodeData(self, indexes: typing.List[int], stream: QDataStream) -> None: ...
    def endInsertColumns(self) -> None: ...
    def endInsertRows(self) -> None: ...
    def endMoveColumns(self) -> None: ...
    def endMoveRows(self) -> None: ...
    def endRemoveColumns(self) -> None: ...
    def endRemoveRows(self) -> None: ...
    def endResetModel(self) -> None: ...
    def fetchMore(self, parent: QModelIndex) -> None: ...
    def flags(self, index: QModelIndex) -> typing.Union[Qt.ItemFlags,Qt.ItemFlag]: ...
    def hasChildren(self, parent: QModelIndex = ...) -> bool: ...
    def hasIndex(self, row: int, column: int, parent: QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: Qt.Orientation, role: Qt.ItemDataRole = ...) -> typing.Any: ...
    def index(self, row: int, column: int, parent: QModelIndex = ...) -> QModelIndex: ...
    def insertColumn(self, column: int, parent: QModelIndex = ...) -> bool: ...
    def insertColumns(self, column: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def insertRow(self, row: int, parent: QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def itemData(self, index: QModelIndex) -> typing.Dict[int,typing.Any]: ...
    def match(self, start: QModelIndex, role: Qt.ItemDataRole, value: typing.Any, hits: int = ..., flags: typing.Union[Qt.MatchFlags,Qt.MatchFlag] = ...) -> typing.List[int]: ...
    def mimeData(self, indexes: typing.List[QModelIndex]) -> QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def moveColumn(self, sourceParent: QModelIndex, sourceColumn: int, destinationParent: QModelIndex, destinationChild: int) -> bool: ...
    def moveColumns(self, sourceParent: QModelIndex, sourceColumn: int, count: int, destinationParent: QModelIndex, destinationChild: int) -> bool: ...
    def moveRow(self, sourceParent: QModelIndex, sourceRow: int, destinationParent: QModelIndex, destinationChild: int) -> bool: ...
    def moveRows(self, sourceParent: QModelIndex, sourceRow: int, count: int, destinationParent: QModelIndex, destinationChild: int) -> bool: ...
    @overload
    def parent(self, child: QModelIndex) -> QModelIndex: ...
    @overload
    def parent(self) -> QObject: ...
    def persistentIndexList(self) -> typing.List[int]: ...
    def removeColumn(self, column: int, parent: QModelIndex = ...) -> bool: ...
    def removeColumns(self, column: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def removeRow(self, row: int, parent: QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def resetInternalData(self) -> None: ...
    def revert(self) -> None: ...
    def roleNames(self) -> typing.Dict[int,QByteArray]: ...
    def rowCount(self, parent: QModelIndex = ...) -> int: ...
    def setData(self, index: QModelIndex, value: typing.Any, role: Qt.ItemDataRole = ...) -> bool: ...
    def setHeaderData(self, section: int, orientation: Qt.Orientation, value: typing.Any, role: Qt.ItemDataRole = ...) -> bool: ...
    def setItemData(self, index: QModelIndex, roles: typing.Dict[int,typing.Any]) -> bool: ...
    def sibling(self, row: int, column: int, idx: QModelIndex) -> QModelIndex: ...
    def sort(self, column: int, order: Qt.SortOrder = ...) -> None: ...
    def span(self, index: QModelIndex) -> QSize: ...
    def submit(self) -> bool: ...
    def supportedDragActions(self) -> typing.Union[Qt.DropActions,Qt.DropAction]: ...
    def supportedDropActions(self) -> typing.Union[Qt.DropActions,Qt.DropAction]: ...

class QAbstractListModel(QAbstractItemModel):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def columnCount(self, parent: QModelIndex) -> int: ...
    def dropMimeData(self, data: QMimeData, action: Qt.DropAction, row: int, column: int, parent: QModelIndex) -> bool: ...
    def flags(self, index: QModelIndex) -> typing.Union[Qt.ItemFlags,Qt.ItemFlag]: ...
    def hasChildren(self, parent: QModelIndex) -> bool: ...
    def index(self, row: int, column: int = ..., parent: QModelIndex = ...) -> QModelIndex: ...
    @overload
    def parent(self, child: QModelIndex) -> QModelIndex: ...
    @overload
    def parent(self) -> QObject: ...
    def sibling(self, row: int, column: int, idx: QModelIndex) -> QModelIndex: ...

class QAbstractNativeEventFilter(shiboken2.Object):
    def __init__(self) -> None: ...
    def nativeEventFilter(self, eventType: typing.Union[QByteArray,bytes], message: int) -> typing.Tuple[bool,int]: ...

class QAbstractProxyModel(QAbstractItemModel):
    sourceModelChanged: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def buddy(self, index: QModelIndex) -> QModelIndex: ...
    def canDropMimeData(self, data: QMimeData, action: Qt.DropAction, row: int, column: int, parent: QModelIndex) -> bool: ...
    def canFetchMore(self, parent: QModelIndex) -> bool: ...
    def data(self, proxyIndex: QModelIndex, role: Qt.ItemDataRole = ...) -> typing.Any: ...
    def dropMimeData(self, data: QMimeData, action: Qt.DropAction, row: int, column: int, parent: QModelIndex) -> bool: ...
    def fetchMore(self, parent: QModelIndex) -> None: ...
    def flags(self, index: QModelIndex) -> typing.Union[Qt.ItemFlags,Qt.ItemFlag]: ...
    def hasChildren(self, parent: QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: Qt.Orientation, role: Qt.ItemDataRole = ...) -> typing.Any: ...
    def itemData(self, index: QModelIndex) -> typing.Dict[int,typing.Any]: ...
    def mapFromSource(self, sourceIndex: QModelIndex) -> QModelIndex: ...
    def mapSelectionFromSource(self, selection: QItemSelection) -> QItemSelection: ...
    def mapSelectionToSource(self, selection: QItemSelection) -> QItemSelection: ...
    def mapToSource(self, proxyIndex: QModelIndex) -> QModelIndex: ...
    def mimeData(self, indexes: typing.List[int]) -> QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    def resetInternalData(self) -> None: ...
    def revert(self) -> None: ...
    def setData(self, index: QModelIndex, value: typing.Any, role: Qt.ItemDataRole = ...) -> bool: ...
    def setHeaderData(self, section: int, orientation: Qt.Orientation, value: typing.Any, role: Qt.ItemDataRole = ...) -> bool: ...
    def setItemData(self, index: QModelIndex, roles: typing.Dict[int,typing.Any]) -> bool: ...
    def setSourceModel(self, sourceModel: QAbstractItemModel) -> None: ...
    def sibling(self, row: int, column: int, idx: QModelIndex) -> QModelIndex: ...
    def sort(self, column: int, order: Qt.SortOrder = ...) -> None: ...
    def sourceModel(self) -> QAbstractItemModel: ...
    def span(self, index: QModelIndex) -> QSize: ...
    def submit(self) -> bool: ...
    def supportedDragActions(self) -> typing.Union[Qt.DropActions,Qt.DropAction]: ...
    def supportedDropActions(self) -> typing.Union[Qt.DropActions,Qt.DropAction]: ...

class QAbstractState(QObject):
    activeChanged: typing.ClassVar[Signal] = ...
    entered: typing.ClassVar[Signal] = ...
    exited: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QState,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def active(self) -> bool: ...
    def event(self, e: QEvent) -> bool: ...
    def machine(self) -> QStateMachine: ...
    def onEntry(self, event: QEvent) -> None: ...
    def onExit(self, event: QEvent) -> None: ...
    def parentState(self) -> QState: ...

class QAbstractTableModel(QAbstractItemModel):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def dropMimeData(self, data: QMimeData, action: Qt.DropAction, row: int, column: int, parent: QModelIndex) -> bool: ...
    def flags(self, index: QModelIndex) -> typing.Union[Qt.ItemFlags,Qt.ItemFlag]: ...
    def hasChildren(self, parent: QModelIndex) -> bool: ...
    def index(self, row: int, column: int, parent: QModelIndex = ...) -> QModelIndex: ...
    @overload
    def parent(self, child: QModelIndex) -> QModelIndex: ...
    @overload
    def parent(self) -> QObject: ...
    def sibling(self, row: int, column: int, idx: QModelIndex) -> QModelIndex: ...

class QAbstractTransition(QObject):
    class TransitionType:
        ExternalTransition: typing.ClassVar[QAbstractTransition.TransitionType] = ...
        InternalTransition: typing.ClassVar[QAbstractTransition.TransitionType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QAbstractTransition.TransitionType: ...
        def __and__(self, other: typing.SupportsInt) -> QAbstractTransition.TransitionType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QAbstractTransition.TransitionType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QAbstractTransition.TransitionType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QAbstractTransition.TransitionType: ...
        def __rand__(self, other: typing.SupportsInt) -> QAbstractTransition.TransitionType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QAbstractTransition.TransitionType: ...
        def __ror__(self, other: typing.SupportsInt) -> QAbstractTransition.TransitionType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QAbstractTransition.TransitionType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QAbstractTransition.TransitionType: ...
        def __sub__(self, other: typing.SupportsInt) -> QAbstractTransition.TransitionType: ...
        def __xor__(self, other: typing.SupportsInt) -> QAbstractTransition.TransitionType: ...
    ExternalTransition: typing.ClassVar[QAbstractTransition.TransitionType] = ...
    InternalTransition: typing.ClassVar[QAbstractTransition.TransitionType] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    targetStateChanged: typing.ClassVar[Signal] = ...
    targetStatesChanged: typing.ClassVar[Signal] = ...
    triggered: typing.ClassVar[Signal] = ...
    def __init__(self, sourceState: typing.Union[QState,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def addAnimation(self, animation: QAbstractAnimation) -> None: ...
    def animations(self) -> typing.List[QAbstractAnimation]: ...
    def event(self, e: QEvent) -> bool: ...
    def eventTest(self, event: QEvent) -> bool: ...
    def machine(self) -> QStateMachine: ...
    def onTransition(self, event: QEvent) -> None: ...
    def removeAnimation(self, animation: QAbstractAnimation) -> None: ...
    def setTargetState(self, target: QAbstractState) -> None: ...
    def setTargetStates(self, targets: typing.Iterable[QAbstractState]) -> None: ...
    def setTransitionType(self, type: QAbstractTransition.TransitionType) -> None: ...
    def sourceState(self) -> QState: ...
    def targetState(self) -> QAbstractState: ...
    def targetStates(self) -> typing.List[QAbstractState]: ...
    def transitionType(self) -> QAbstractTransition.TransitionType: ...

class QAnimationGroup(QAbstractAnimation):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def addAnimation(self, animation: QAbstractAnimation) -> None: ...
    def animationAt(self, index: int) -> QAbstractAnimation: ...
    def animationCount(self) -> int: ...
    def clear(self) -> None: ...
    def event(self, event: QEvent) -> bool: ...
    def indexOfAnimation(self, animation: QAbstractAnimation) -> int: ...
    def insertAnimation(self, index: int, animation: QAbstractAnimation) -> None: ...
    def removeAnimation(self, animation: QAbstractAnimation) -> None: ...
    def takeAnimation(self, index: int) -> QAbstractAnimation: ...

class QBasicMutex(shiboken2.Object):
    def __init__(self) -> None: ...
    def isRecursive(self) -> bool: ...
    def lock(self) -> None: ...
    def tryLock(self) -> bool: ...
    def try_lock(self) -> bool: ...
    def unlock(self) -> None: ...

class QBasicTimer(shiboken2.Object):
    @overload
    def __init__(self, arg__1: QBasicTimer) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def isActive(self) -> bool: ...
    @overload
    def start(self, msec: int, timerType: Qt.TimerType, obj: QObject) -> None: ...
    @overload
    def start(self, msec: int, obj: QObject) -> None: ...
    def stop(self) -> None: ...
    def swap(self, other: QBasicTimer) -> None: ...
    def timerId(self) -> int: ...

class QBitArray(shiboken2.Object):
    @overload
    def __init__(self, size: int, val: bool = ...) -> None: ...
    @overload
    def __init__(self, other: QBitArray) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def at(self, i: int) -> bool: ...
    def bits(self) -> bytes: ...
    def clear(self) -> None: ...
    def clearBit(self, i: int) -> None: ...
    @overload
    def count(self, on: bool) -> int: ...
    @overload
    def count(self) -> int: ...
    @overload
    def fill(self, val: bool, first: int, last: int) -> None: ...
    @overload
    def fill(self, val: bool, size: int = ...) -> bool: ...
    @classmethod
    def fromBits(cls, data: bytes, len: int) -> QBitArray: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def resize(self, size: int) -> None: ...
    @overload
    def setBit(self, i: int, val: bool) -> None: ...
    @overload
    def setBit(self, i: int) -> None: ...
    def size(self) -> int: ...
    def swap(self, other: QBitArray) -> None: ...
    def testBit(self, i: int) -> bool: ...
    def toggleBit(self, i: int) -> bool: ...
    def truncate(self, pos: int) -> None: ...
    def __and__(self, arg__2: QBitArray) -> QBitArray: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __delitem__(self, other) -> typing.Any: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getitem__(self, index) -> typing.Any: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __iand__(self, arg__1: QBitArray) -> QBitArray: ...
    def __invert__(self) -> QBitArray: ...
    def __ior__(self, arg__1: QBitArray) -> QBitArray: ...
    def __ixor__(self, arg__1: QBitArray) -> QBitArray: ...
    def __le__(self, other: object) -> bool: ...
    def __len__(self) -> int: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, arg__2: QBitArray) -> QBitArray: ...
    def __rand__(self, other) -> typing.Any: ...
    def __ror__(self, other) -> typing.Any: ...
    def __rxor__(self, other) -> typing.Any: ...
    def __setitem__(self, index, object) -> None: ...
    def __xor__(self, arg__2: QBitArray) -> QBitArray: ...

class QBuffer(QIODevice):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, buf: typing.Union[QByteArray,bytes], parent: typing.Union[QObject,None] = ..., aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QObject,None] = ..., aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    def atEnd(self) -> bool: ...
    def buffer(self) -> QByteArray: ...
    def canReadLine(self) -> bool: ...
    def close(self) -> None: ...
    def connectNotify(self, arg__1: QMetaMethod) -> None: ...
    def data(self) -> QByteArray: ...
    def disconnectNotify(self, arg__1: QMetaMethod) -> None: ...
    def open(self, openMode: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag]) -> bool: ...
    def pos(self) -> int: ...
    def readData(self, data: bytes, maxlen: int) -> int: ...
    def seek(self, off: int) -> bool: ...
    def setBuffer(self, a: typing.Union[QByteArray,bytes]) -> None: ...
    def setData(self, data: typing.Union[QByteArray,bytes]) -> None: ...
    def size(self) -> int: ...
    def writeData(self, data: bytes, len: int) -> int: ...

class QByteArray(shiboken2.Object):
    class Base64DecodingStatus:
        IllegalCharacter: typing.ClassVar[QByteArray.Base64DecodingStatus] = ...
        IllegalInputLength: typing.ClassVar[QByteArray.Base64DecodingStatus] = ...
        IllegalPadding: typing.ClassVar[QByteArray.Base64DecodingStatus] = ...
        Ok: typing.ClassVar[QByteArray.Base64DecodingStatus] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QByteArray.Base64DecodingStatus: ...
        def __and__(self, other: typing.SupportsInt) -> QByteArray.Base64DecodingStatus: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QByteArray.Base64DecodingStatus: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QByteArray.Base64DecodingStatus: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QByteArray.Base64DecodingStatus: ...
        def __rand__(self, other: typing.SupportsInt) -> QByteArray.Base64DecodingStatus: ...
        def __rmul__(self, other: typing.SupportsInt) -> QByteArray.Base64DecodingStatus: ...
        def __ror__(self, other: typing.SupportsInt) -> QByteArray.Base64DecodingStatus: ...
        def __rsub__(self, other: typing.SupportsInt) -> QByteArray.Base64DecodingStatus: ...
        def __rxor__(self, other: typing.SupportsInt) -> QByteArray.Base64DecodingStatus: ...
        def __sub__(self, other: typing.SupportsInt) -> QByteArray.Base64DecodingStatus: ...
        def __xor__(self, other: typing.SupportsInt) -> QByteArray.Base64DecodingStatus: ...

    class Base64Option:
        AbortOnBase64DecodingErrors: typing.ClassVar[QByteArray.Base64Option] = ...
        Base64Encoding: typing.ClassVar[QByteArray.Base64Option] = ...
        Base64UrlEncoding: typing.ClassVar[QByteArray.Base64Option] = ...
        IgnoreBase64DecodingErrors: typing.ClassVar[QByteArray.Base64Option] = ...
        KeepTrailingEquals: typing.ClassVar[QByteArray.Base64Option] = ...
        OmitTrailingEquals: typing.ClassVar[QByteArray.Base64Option] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QByteArray.Base64Options: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QByteArray.Base64Options: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QByteArray.Base64Options: ...
        def __rand__(self, other: typing.SupportsInt) -> QByteArray.Base64Options: ...
        def __ror__(self, other: typing.SupportsInt) -> QByteArray.Base64Options: ...
        def __rxor__(self, other: typing.SupportsInt) -> QByteArray.Base64Options: ...
        def __xor__(self, other: typing.SupportsInt) -> QByteArray.Base64Options: ...

    class Base64Options:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QByteArray.Base64Options: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QByteArray.Base64Options: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QByteArray.Base64Options: ...
        def __rand__(self, other: typing.SupportsInt) -> QByteArray.Base64Options: ...
        def __ror__(self, other: typing.SupportsInt) -> QByteArray.Base64Options: ...
        def __rxor__(self, other: typing.SupportsInt) -> QByteArray.Base64Options: ...
        def __xor__(self, other: typing.SupportsInt) -> QByteArray.Base64Options: ...

    class FromBase64Result(shiboken2.Object):
        decoded: typing.Any
        decodingStatus: typing.Any
        @overload
        def __init__(self, FromBase64Result: QByteArray.FromBase64Result) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def swap(self, other: QByteArray.FromBase64Result) -> None: ...
        def __copy__(self) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
    AbortOnBase64DecodingErrors: typing.ClassVar[QByteArray.Base64Option] = ...
    Base64Encoding: typing.ClassVar[QByteArray.Base64Option] = ...
    Base64UrlEncoding: typing.ClassVar[QByteArray.Base64Option] = ...
    IgnoreBase64DecodingErrors: typing.ClassVar[QByteArray.Base64Option] = ...
    KeepTrailingEquals: typing.ClassVar[QByteArray.Base64Option] = ...
    OmitTrailingEquals: typing.ClassVar[QByteArray.Base64Option] = ...
    @overload
    def __init__(self, size: int, c: int) -> None: ...
    @overload
    def __init__(self, arg__1: bytearray) -> None: ...
    @overload
    def __init__(self, arg__1: bytes) -> None: ...
    @overload
    def __init__(self, arg__1: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def append(self, count: int, c: int) -> QByteArray: ...
    @overload
    def append(self, a: typing.Union[QByteArray,bytes]) -> QByteArray: ...
    @overload
    def append(self, c: int) -> QByteArray: ...
    def at(self, i: int) -> int: ...
    def back(self) -> int: ...
    def capacity(self) -> int: ...
    def cbegin(self) -> bytes: ...
    def cend(self) -> bytes: ...
    def chop(self, n: int) -> None: ...
    def chopped(self, len: int) -> QByteArray: ...
    def clear(self) -> None: ...
    @overload
    def compare(self, a: typing.Union[QByteArray,bytes], cs: Qt.CaseSensitivity = ...) -> int: ...
    @overload
    def compare(self, c: bytes, cs: Qt.CaseSensitivity = ...) -> int: ...
    @overload
    def contains(self, a: typing.Union[QByteArray,bytes]) -> bool: ...
    @overload
    def contains(self, c: int) -> bool: ...
    @overload
    def count(self, a: typing.Union[QByteArray,bytes]) -> int: ...
    @overload
    def count(self, c: int) -> int: ...
    @overload
    def count(self) -> int: ...
    def data(self) -> bytes: ...
    @overload
    def endsWith(self, a: typing.Union[QByteArray,bytes]) -> bool: ...
    @overload
    def endsWith(self, c: int) -> bool: ...
    def fill(self, c: int, size: int = ...) -> QByteArray: ...
    @overload
    @classmethod
    def fromBase64(cls, base64: typing.Union[QByteArray,bytes], options: typing.Union[QByteArray.Base64Options,QByteArray.Base64Option]) -> QByteArray: ...
    @overload
    @classmethod
    def fromBase64(cls, base64: typing.Union[QByteArray,bytes]) -> QByteArray: ...
    @classmethod
    def fromBase64Encoding(cls, base64: typing.Union[QByteArray,bytes], options: typing.Union[QByteArray.Base64Options,QByteArray.Base64Option] = ...) -> QByteArray.FromBase64Result: ...
    @classmethod
    def fromHex(cls, hexEncoded: typing.Union[QByteArray,bytes]) -> QByteArray: ...
    @classmethod
    def fromPercentEncoding(cls, pctEncoded: typing.Union[QByteArray,bytes], percent: int = ...) -> QByteArray: ...
    @classmethod
    def fromRawData(cls, arg__1: bytes, size: int) -> QByteArray: ...
    def front(self) -> int: ...
    def indexOf(self, a: typing.Union[QByteArray,bytes], from_: int = ...) -> int: ...
    @overload
    def insert(self, i: int, count: int, c: int) -> QByteArray: ...
    @overload
    def insert(self, i: int, a: typing.Union[QByteArray,bytes]) -> QByteArray: ...
    def isEmpty(self) -> bool: ...
    def isLower(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isSharedWith(self, other: typing.Union[QByteArray,bytes]) -> bool: ...
    def isUpper(self) -> bool: ...
    def lastIndexOf(self, a: typing.Union[QByteArray,bytes], from_: int = ...) -> int: ...
    def left(self, len: int) -> QByteArray: ...
    def leftJustified(self, width: int, fill: int = ..., truncate: bool = ...) -> QByteArray: ...
    def length(self) -> int: ...
    def mid(self, index: int, len: int = ...) -> QByteArray: ...
    @overload
    @classmethod
    def number(cls, arg__1: float, f: int = ..., prec: int = ...) -> QByteArray: ...
    @overload
    @classmethod
    def number(cls, arg__1: int, base: int = ...) -> QByteArray: ...
    @overload
    def prepend(self, count: int, c: int) -> QByteArray: ...
    @overload
    def prepend(self, a: typing.Union[QByteArray,bytes]) -> QByteArray: ...
    @overload
    def prepend(self, c: int) -> QByteArray: ...
    def remove(self, index: int, len: int) -> QByteArray: ...
    def repeated(self, times: int) -> QByteArray: ...
    @overload
    def replace(self, index: int, len: int, s: typing.Union[QByteArray,bytes]) -> QByteArray: ...
    @overload
    def replace(self, before: typing.Union[QByteArray,bytes], after: typing.Union[QByteArray,bytes]) -> QByteArray: ...
    @overload
    def replace(self, before: str, after: typing.Union[QByteArray,bytes]) -> QByteArray: ...
    @overload
    def replace(self, before: int, after: typing.Union[QByteArray,bytes]) -> QByteArray: ...
    @overload
    def replace(self, before: int, after: int) -> QByteArray: ...
    def reserve(self, size: int) -> None: ...
    def resize(self, size: int) -> None: ...
    def right(self, len: int) -> QByteArray: ...
    def rightJustified(self, width: int, fill: int = ..., truncate: bool = ...) -> QByteArray: ...
    @overload
    def setNum(self, arg__1: float, f: int = ..., prec: int = ...) -> QByteArray: ...
    @overload
    def setNum(self, arg__1: int, base: int = ...) -> QByteArray: ...
    def setRawData(self, a: bytes, n: int) -> QByteArray: ...
    def shrink_to_fit(self) -> None: ...
    def simplified(self) -> QByteArray: ...
    def size(self) -> int: ...
    def split(self, sep: int) -> typing.List[QByteArray]: ...
    def squeeze(self) -> None: ...
    @overload
    def startsWith(self, a: typing.Union[QByteArray,bytes]) -> bool: ...
    @overload
    def startsWith(self, c: int) -> bool: ...
    def swap(self, other: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def toBase64(self, options: typing.Union[QByteArray.Base64Options,QByteArray.Base64Option]) -> QByteArray: ...
    @overload
    def toBase64(self) -> QByteArray: ...
    def toDouble(self) -> typing.Tuple[float,bool]: ...
    def toFloat(self) -> typing.Tuple[float,bool]: ...
    @overload
    def toHex(self, separator: int) -> QByteArray: ...
    @overload
    def toHex(self) -> QByteArray: ...
    def toInt(self, base: int = ...) -> typing.Tuple[int,bool]: ...
    def toLong(self, base: int = ...) -> typing.Tuple[int,bool]: ...
    def toLongLong(self, base: int = ...) -> typing.Tuple[int,bool]: ...
    def toLower(self) -> QByteArray: ...
    def toPercentEncoding(self, exclude: typing.Union[QByteArray,bytes] = ..., include: typing.Union[QByteArray,bytes] = ..., percent: int = ...) -> QByteArray: ...
    def toShort(self, base: int = ...) -> typing.Tuple[int,bool]: ...
    def toUInt(self, base: int = ...) -> typing.Tuple[int,bool]: ...
    def toULong(self, base: int = ...) -> typing.Tuple[int,bool]: ...
    def toULongLong(self, base: int = ...) -> typing.Tuple[int,bool]: ...
    def toUShort(self, base: int = ...) -> typing.Tuple[int,bool]: ...
    def toUpper(self) -> QByteArray: ...
    def trimmed(self) -> QByteArray: ...
    def truncate(self, pos: int) -> None: ...
    @overload
    def __add__(self, a2: typing.Union[QByteArray,bytes]) -> QByteArray: ...
    @overload
    def __add__(self, a2: int) -> QByteArray: ...
    @overload
    def __add__(self, arg__1: bytearray) -> QByteArray: ...
    @overload
    def __add__(self, arg__1: bytes) -> None: ...
    def __bool__(self) -> bool: ...
    def __bytes__(self) -> bytes: ...
    def __copy__(self) -> None: ...
    def __delitem__(self, other) -> typing.Any: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getitem__(self, index: int) -> bytes: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    @overload
    def __iadd__(self, a: typing.Union[QByteArray,bytes]) -> QByteArray: ...
    @overload
    def __iadd__(self, arg__1: bytearray) -> QByteArray: ...
    @overload
    def __iadd__(self, c: int) -> QByteArray: ...
    def __iter__(self) -> typing.Iterator[bytes]: ...
    def __le__(self, other: object) -> bool: ...
    def __len__(self) -> int: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __radd__(self, other) -> typing.Any: ...
    def __setitem__(self, index, object) -> None: ...

class QByteArrayMatcher(shiboken2.Object):
    @overload
    def __init__(self, pattern: bytes, length: int) -> None: ...
    @overload
    def __init__(self, other: QByteArrayMatcher) -> None: ...
    @overload
    def __init__(self, pattern: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def indexIn(self, str: bytes, len: int, from_: int = ...) -> int: ...
    @overload
    def indexIn(self, ba: typing.Union[QByteArray,bytes], from_: int = ...) -> int: ...
    def pattern(self) -> QByteArray: ...
    def setPattern(self, pattern: typing.Union[QByteArray,bytes]) -> None: ...
    def __copy__(self) -> None: ...

class QCalendar(shiboken2.Object):
    class System:
        Gregorian: typing.ClassVar[QCalendar.System] = ...
        IslamicCivil: typing.ClassVar[QCalendar.System] = ...
        Jalali: typing.ClassVar[QCalendar.System] = ...
        Julian: typing.ClassVar[QCalendar.System] = ...
        Last: typing.ClassVar[QCalendar.System] = ...
        Milankovic: typing.ClassVar[QCalendar.System] = ...
        User: typing.ClassVar[QCalendar.System] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCalendar.System: ...
        def __and__(self, other: typing.SupportsInt) -> QCalendar.System: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCalendar.System: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCalendar.System: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QCalendar.System: ...
        def __rand__(self, other: typing.SupportsInt) -> QCalendar.System: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCalendar.System: ...
        def __ror__(self, other: typing.SupportsInt) -> QCalendar.System: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCalendar.System: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCalendar.System: ...
        def __sub__(self, other: typing.SupportsInt) -> QCalendar.System: ...
        def __xor__(self, other: typing.SupportsInt) -> QCalendar.System: ...

    class YearMonthDay(shiboken2.Object):
        day: typing.Any
        month: typing.Any
        year: typing.Any
        @overload
        def __init__(self, y: int, m: int = ..., d: int = ...) -> None: ...
        @overload
        def __init__(self, YearMonthDay: QCalendar.YearMonthDay) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def isValid(self) -> bool: ...
        def __copy__(self) -> None: ...
    @overload
    def __init__(self, system: QCalendar.System) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def availableCalendars(cls) -> typing.List[str]: ...
    @overload
    def dateFromParts(self, year: int, month: int, day: int) -> QDate: ...
    @overload
    def dateFromParts(self, parts: QCalendar.YearMonthDay) -> QDate: ...
    def dayOfWeek(self, date: QDate) -> int: ...
    def daysInMonth(self, month: int, year: typing.Union[int,None] = ...) -> int: ...
    def daysInYear(self, year: int) -> int: ...
    def hasYearZero(self) -> bool: ...
    def isDateValid(self, year: int, month: int, day: int) -> bool: ...
    def isGregorian(self) -> bool: ...
    def isLeapYear(self, year: int) -> bool: ...
    def isLunar(self) -> bool: ...
    def isLuniSolar(self) -> bool: ...
    def isProleptic(self) -> bool: ...
    def isSolar(self) -> bool: ...
    def isValid(self) -> bool: ...
    def maximumDaysInMonth(self) -> int: ...
    def maximumMonthsInYear(self) -> int: ...
    def minimumDaysInMonth(self) -> int: ...
    def monthName(self, locale: QLocale, month: int, year: typing.Union[int,None] = ..., format: QLocale.FormatType = ...) -> str: ...
    def monthsInYear(self, year: int) -> int: ...
    def name(self) -> str: ...
    def partsFromDate(self, date: QDate) -> QCalendar.YearMonthDay: ...
    def standaloneMonthName(self, locale: QLocale, month: int, year: typing.Union[int,None] = ..., format: QLocale.FormatType = ...) -> str: ...
    def standaloneWeekDayName(self, locale: QLocale, day: int, format: QLocale.FormatType = ...) -> str: ...
    def weekDayName(self, locale: QLocale, day: int, format: QLocale.FormatType = ...) -> str: ...
    def __copy__(self) -> None: ...

class QCborArray(shiboken2.Object):
    @overload
    def __init__(self, other: QCborArray) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def append(self, value: QCborValue) -> None: ...
    def at(self, i: int) -> QCborValue: ...
    def clear(self) -> None: ...
    def compare(self, other: QCborArray) -> int: ...
    def contains(self, value: QCborValue) -> bool: ...
    def empty(self) -> bool: ...
    def first(self) -> QCborValue: ...
    @classmethod
    def fromJsonArray(cls, array: QJsonArray) -> QCborArray: ...
    @classmethod
    def fromStringList(cls, list: typing.Iterable[str]) -> QCborArray: ...
    @classmethod
    def fromVariantList(cls, list: typing.Iterable[typing.Any]) -> QCborArray: ...
    def insert(self, i: int, value: QCborValue) -> None: ...
    def isEmpty(self) -> bool: ...
    def last(self) -> QCborValue: ...
    def pop_back(self) -> None: ...
    def pop_front(self) -> None: ...
    def prepend(self, value: QCborValue) -> None: ...
    def push_back(self, t: QCborValue) -> None: ...
    def push_front(self, t: QCborValue) -> None: ...
    def removeAt(self, i: int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def size(self) -> int: ...
    def swap(self, other: QCborArray) -> None: ...
    def takeAt(self, i: int) -> QCborValue: ...
    def takeFirst(self) -> QCborValue: ...
    def takeLast(self) -> QCborValue: ...
    def toCborValue(self) -> QCborValue: ...
    def toJsonArray(self) -> QJsonArray: ...
    def toVariantList(self) -> typing.List[typing.Any]: ...
    def __add__(self, v: QCborValue) -> QCborArray: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, v: QCborValue) -> QCborArray: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, v: QCborValue) -> QCborArray: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rlshift__(self, other) -> typing.Any: ...

class QCborError(shiboken2.Object):
    class Code:
        AdvancePastEnd: typing.ClassVar[QCborError.Code] = ...
        DataTooLarge: typing.ClassVar[QCborError.Code] = ...
        EndOfFile: typing.ClassVar[QCborError.Code] = ...
        GarbageAtEnd: typing.ClassVar[QCborError.Code] = ...
        IllegalNumber: typing.ClassVar[QCborError.Code] = ...
        IllegalSimpleType: typing.ClassVar[QCborError.Code] = ...
        IllegalType: typing.ClassVar[QCborError.Code] = ...
        InputOutputError: typing.ClassVar[QCborError.Code] = ...
        InvalidUtf8String: typing.ClassVar[QCborError.Code] = ...
        NestingTooDeep: typing.ClassVar[QCborError.Code] = ...
        NoError: typing.ClassVar[QCborError.Code] = ...
        UnexpectedBreak: typing.ClassVar[QCborError.Code] = ...
        UnknownError: typing.ClassVar[QCborError.Code] = ...
        UnknownType: typing.ClassVar[QCborError.Code] = ...
        UnsupportedType: typing.ClassVar[QCborError.Code] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCborError.Code: ...
        def __and__(self, other: typing.SupportsInt) -> QCborError.Code: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCborError.Code: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCborError.Code: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QCborError.Code: ...
        def __rand__(self, other: typing.SupportsInt) -> QCborError.Code: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCborError.Code: ...
        def __ror__(self, other: typing.SupportsInt) -> QCborError.Code: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCborError.Code: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCborError.Code: ...
        def __sub__(self, other: typing.SupportsInt) -> QCborError.Code: ...
        def __xor__(self, other: typing.SupportsInt) -> QCborError.Code: ...
    AdvancePastEnd: typing.ClassVar[QCborError.Code] = ...
    DataTooLarge: typing.ClassVar[QCborError.Code] = ...
    EndOfFile: typing.ClassVar[QCborError.Code] = ...
    GarbageAtEnd: typing.ClassVar[QCborError.Code] = ...
    IllegalNumber: typing.ClassVar[QCborError.Code] = ...
    IllegalSimpleType: typing.ClassVar[QCborError.Code] = ...
    IllegalType: typing.ClassVar[QCborError.Code] = ...
    InputOutputError: typing.ClassVar[QCborError.Code] = ...
    InvalidUtf8String: typing.ClassVar[QCborError.Code] = ...
    NestingTooDeep: typing.ClassVar[QCborError.Code] = ...
    NoError: typing.ClassVar[QCborError.Code] = ...
    UnexpectedBreak: typing.ClassVar[QCborError.Code] = ...
    UnknownError: typing.ClassVar[QCborError.Code] = ...
    UnknownType: typing.ClassVar[QCborError.Code] = ...
    UnsupportedType: typing.ClassVar[QCborError.Code] = ...
    c: typing.Any
    @overload
    def __init__(self, QCborError: QCborError) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def toString(self) -> str: ...
    def __copy__(self) -> None: ...

class QCborKnownTags:
    Base64: typing.ClassVar[QCborKnownTags] = ...
    Base64url: typing.ClassVar[QCborKnownTags] = ...
    Bigfloat: typing.ClassVar[QCborKnownTags] = ...
    COSE_Encrypt: typing.ClassVar[QCborKnownTags] = ...
    COSE_Encrypt0: typing.ClassVar[QCborKnownTags] = ...
    COSE_Mac: typing.ClassVar[QCborKnownTags] = ...
    COSE_Mac0: typing.ClassVar[QCborKnownTags] = ...
    COSE_Sign: typing.ClassVar[QCborKnownTags] = ...
    COSE_Sign1: typing.ClassVar[QCborKnownTags] = ...
    DateTimeString: typing.ClassVar[QCborKnownTags] = ...
    Decimal: typing.ClassVar[QCborKnownTags] = ...
    EncodedCbor: typing.ClassVar[QCborKnownTags] = ...
    ExpectedBase16: typing.ClassVar[QCborKnownTags] = ...
    ExpectedBase64: typing.ClassVar[QCborKnownTags] = ...
    ExpectedBase64url: typing.ClassVar[QCborKnownTags] = ...
    MimeMessage: typing.ClassVar[QCborKnownTags] = ...
    NegativeBignum: typing.ClassVar[QCborKnownTags] = ...
    PositiveBignum: typing.ClassVar[QCborKnownTags] = ...
    RegularExpression: typing.ClassVar[QCborKnownTags] = ...
    Signature: typing.ClassVar[QCborKnownTags] = ...
    UnixTime_t: typing.ClassVar[QCborKnownTags] = ...
    Url: typing.ClassVar[QCborKnownTags] = ...
    Uuid: typing.ClassVar[QCborKnownTags] = ...
    values: typing.ClassVar[dict] = ...
    name: typing.Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def __add__(self, other: typing.SupportsInt) -> QCborKnownTags: ...
    def __and__(self, other: typing.SupportsInt) -> QCborKnownTags: ...
    def __bool__(self) -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> typing.Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __mul__(self, other: typing.SupportsInt) -> QCborKnownTags: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: typing.SupportsInt) -> QCborKnownTags: ...
    def __pos__(self) -> typing.Any: ...
    def __radd__(self, other: typing.SupportsInt) -> QCborKnownTags: ...
    def __rand__(self, other: typing.SupportsInt) -> QCborKnownTags: ...
    def __rmul__(self, other: typing.SupportsInt) -> QCborKnownTags: ...
    def __ror__(self, other: typing.SupportsInt) -> QCborKnownTags: ...
    def __rsub__(self, other: typing.SupportsInt) -> QCborKnownTags: ...
    def __rxor__(self, other: typing.SupportsInt) -> QCborKnownTags: ...
    def __sub__(self, other: typing.SupportsInt) -> QCborKnownTags: ...
    def __xor__(self, other: typing.SupportsInt) -> QCborKnownTags: ...

class QCborMap(shiboken2.Object):
    @overload
    def __init__(self, other: QCborMap) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def compare(self, other: QCborMap) -> int: ...
    @overload
    def contains(self, key: QCborValue) -> bool: ...
    @overload
    def contains(self, key: str) -> bool: ...
    @overload
    def contains(self, key: int) -> bool: ...
    def empty(self) -> bool: ...
    @classmethod
    def fromJsonObject(cls, o: typing.Dict[str,QJsonValue]) -> QCborMap: ...
    @classmethod
    def fromVariantHash(cls, hash: typing.Dict[str,typing.Any]) -> QCborMap: ...
    @classmethod
    def fromVariantMap(cls, map: typing.Dict[str,typing.Any]) -> QCborMap: ...
    def isEmpty(self) -> bool: ...
    def keys(self) -> typing.List[QCborValue]: ...
    @overload
    def remove(self, key: QCborValue) -> None: ...
    @overload
    def remove(self, key: str) -> None: ...
    @overload
    def remove(self, key: int) -> None: ...
    def size(self) -> int: ...
    def swap(self, other: QCborMap) -> None: ...
    @overload
    def take(self, key: QCborValue) -> QCborValue: ...
    @overload
    def take(self, key: str) -> QCborValue: ...
    @overload
    def take(self, key: int) -> QCborValue: ...
    def toCborValue(self) -> QCborValue: ...
    def toJsonObject(self) -> typing.Dict[str,QJsonValue]: ...
    def toVariantHash(self) -> typing.Dict[str,typing.Any]: ...
    def toVariantMap(self) -> typing.Dict[str,typing.Any]: ...
    @overload
    def value(self, key: QCborValue) -> QCborValue: ...
    @overload
    def value(self, key: str) -> QCborValue: ...
    @overload
    def value(self, key: int) -> QCborValue: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QCborParserError(shiboken2.Object):
    error: typing.Any
    offset: typing.Any
    @overload
    def __init__(self, QCborParserError: QCborParserError) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def errorString(self) -> str: ...
    def __copy__(self) -> None: ...

class QCborSimpleType:
    False_: typing.ClassVar[QCborSimpleType] = ...
    Null: typing.ClassVar[QCborSimpleType] = ...
    True_: typing.ClassVar[QCborSimpleType] = ...
    Undefined: typing.ClassVar[QCborSimpleType] = ...
    values: typing.ClassVar[dict] = ...
    name: typing.Any
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def __add__(self, other: typing.SupportsInt) -> QCborSimpleType: ...
    def __and__(self, other: typing.SupportsInt) -> QCborSimpleType: ...
    def __bool__(self) -> bool: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> typing.Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __mul__(self, other: typing.SupportsInt) -> QCborSimpleType: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: typing.SupportsInt) -> QCborSimpleType: ...
    def __pos__(self) -> typing.Any: ...
    def __radd__(self, other: typing.SupportsInt) -> QCborSimpleType: ...
    def __rand__(self, other: typing.SupportsInt) -> QCborSimpleType: ...
    def __rmul__(self, other: typing.SupportsInt) -> QCborSimpleType: ...
    def __ror__(self, other: typing.SupportsInt) -> QCborSimpleType: ...
    def __rsub__(self, other: typing.SupportsInt) -> QCborSimpleType: ...
    def __rxor__(self, other: typing.SupportsInt) -> QCborSimpleType: ...
    def __sub__(self, other: typing.SupportsInt) -> QCborSimpleType: ...
    def __xor__(self, other: typing.SupportsInt) -> QCborSimpleType: ...

class QCborStreamReader(shiboken2.Object):
    class StringResultCode:
        EndOfString: typing.ClassVar[QCborStreamReader.StringResultCode] = ...
        Error: typing.ClassVar[QCborStreamReader.StringResultCode] = ...
        Ok: typing.ClassVar[QCborStreamReader.StringResultCode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCborStreamReader.StringResultCode: ...
        def __and__(self, other: typing.SupportsInt) -> QCborStreamReader.StringResultCode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCborStreamReader.StringResultCode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCborStreamReader.StringResultCode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QCborStreamReader.StringResultCode: ...
        def __rand__(self, other: typing.SupportsInt) -> QCborStreamReader.StringResultCode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCborStreamReader.StringResultCode: ...
        def __ror__(self, other: typing.SupportsInt) -> QCborStreamReader.StringResultCode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCborStreamReader.StringResultCode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCborStreamReader.StringResultCode: ...
        def __sub__(self, other: typing.SupportsInt) -> QCborStreamReader.StringResultCode: ...
        def __xor__(self, other: typing.SupportsInt) -> QCborStreamReader.StringResultCode: ...

    class Type:
        Array: typing.ClassVar[QCborStreamReader.Type] = ...
        ByteArray: typing.ClassVar[QCborStreamReader.Type] = ...
        ByteString: typing.ClassVar[QCborStreamReader.Type] = ...
        Double: typing.ClassVar[QCborStreamReader.Type] = ...
        Float: typing.ClassVar[QCborStreamReader.Type] = ...
        Float16: typing.ClassVar[QCborStreamReader.Type] = ...
        HalfFloat: typing.ClassVar[QCborStreamReader.Type] = ...
        Invalid: typing.ClassVar[QCborStreamReader.Type] = ...
        Map: typing.ClassVar[QCborStreamReader.Type] = ...
        NegativeInteger: typing.ClassVar[QCborStreamReader.Type] = ...
        SimpleType: typing.ClassVar[QCborStreamReader.Type] = ...
        String: typing.ClassVar[QCborStreamReader.Type] = ...
        Tag: typing.ClassVar[QCborStreamReader.Type] = ...
        TextString: typing.ClassVar[QCborStreamReader.Type] = ...
        UnsignedInteger: typing.ClassVar[QCborStreamReader.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCborStreamReader.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QCborStreamReader.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCborStreamReader.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCborStreamReader.Type: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QCborStreamReader.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QCborStreamReader.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCborStreamReader.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QCborStreamReader.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCborStreamReader.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCborStreamReader.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QCborStreamReader.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QCborStreamReader.Type: ...
    Array: typing.ClassVar[QCborStreamReader.Type] = ...
    ByteArray: typing.ClassVar[QCborStreamReader.Type] = ...
    ByteString: typing.ClassVar[QCborStreamReader.Type] = ...
    Double: typing.ClassVar[QCborStreamReader.Type] = ...
    EndOfString: typing.ClassVar[QCborStreamReader.StringResultCode] = ...
    Error: typing.ClassVar[QCborStreamReader.StringResultCode] = ...
    Float: typing.ClassVar[QCborStreamReader.Type] = ...
    Float16: typing.ClassVar[QCborStreamReader.Type] = ...
    HalfFloat: typing.ClassVar[QCborStreamReader.Type] = ...
    Invalid: typing.ClassVar[QCborStreamReader.Type] = ...
    Map: typing.ClassVar[QCborStreamReader.Type] = ...
    NegativeInteger: typing.ClassVar[QCborStreamReader.Type] = ...
    Ok: typing.ClassVar[QCborStreamReader.StringResultCode] = ...
    SimpleType: typing.ClassVar[QCborStreamReader.Type] = ...
    String: typing.ClassVar[QCborStreamReader.Type] = ...
    Tag: typing.ClassVar[QCborStreamReader.Type] = ...
    TextString: typing.ClassVar[QCborStreamReader.Type] = ...
    UnsignedInteger: typing.ClassVar[QCborStreamReader.Type] = ...
    @overload
    def __init__(self, data: bytes, len: int) -> None: ...
    @overload
    def __init__(self, data: bytearray, len: int) -> None: ...
    @overload
    def __init__(self, data: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def __init__(self, device: QIODevice) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def addData(self, data: bytes, len: int) -> None: ...
    @overload
    def addData(self, data: bytearray, len: int) -> None: ...
    @overload
    def addData(self, data: typing.Union[QByteArray,bytes]) -> None: ...
    def clear(self) -> None: ...
    def containerDepth(self) -> int: ...
    def currentOffset(self) -> int: ...
    def currentStringChunkSize(self) -> int: ...
    def device(self) -> QIODevice: ...
    def enterContainer(self) -> bool: ...
    def hasNext(self) -> bool: ...
    def isArray(self) -> bool: ...
    def isBool(self) -> bool: ...
    def isByteArray(self) -> bool: ...
    def isContainer(self) -> bool: ...
    def isDouble(self) -> bool: ...
    def isFalse(self) -> bool: ...
    def isFloat(self) -> bool: ...
    def isFloat16(self) -> bool: ...
    def isInteger(self) -> bool: ...
    def isInvalid(self) -> bool: ...
    def isLengthKnown(self) -> bool: ...
    def isMap(self) -> bool: ...
    def isNegativeInteger(self) -> bool: ...
    def isNull(self) -> bool: ...
    @overload
    def isSimpleType(self, st: QCborSimpleType) -> bool: ...
    @overload
    def isSimpleType(self) -> bool: ...
    def isString(self) -> bool: ...
    def isTag(self) -> bool: ...
    def isTrue(self) -> bool: ...
    def isUndefined(self) -> bool: ...
    def isUnsignedInteger(self) -> bool: ...
    def isValid(self) -> bool: ...
    def lastError(self) -> QCborError: ...
    def leaveContainer(self) -> bool: ...
    def length(self) -> int: ...
    def next(self, maxRecursion: int = ...) -> bool: ...
    def parentContainerType(self) -> QCborStreamReader.Type: ...
    def readByteArray(self) -> QCborStringResultByteArray: ...
    def readString(self) -> QCborStringResultString: ...
    def reparse(self) -> None: ...
    def reset(self) -> None: ...
    def setDevice(self, device: QIODevice) -> None: ...
    def toBool(self) -> bool: ...
    def toDouble(self) -> float: ...
    def toFloat(self) -> float: ...
    def toInteger(self) -> int: ...
    def toSimpleType(self) -> QCborSimpleType: ...
    def toUnsignedInteger(self) -> int: ...
    def type(self) -> QCborStreamReader.Type: ...
    def __bool__(self) -> bool: ...

class QCborStreamWriter(shiboken2.Object):
    @overload
    def __init__(self, data: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def __init__(self, device: QIODevice) -> None: ...
    @overload
    def append(self, str: bytes, size: int = ...) -> None: ...
    @overload
    def append(self, b: bool) -> None: ...
    @overload
    def append(self, ba: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def append(self, d: float) -> None: ...
    @overload
    def append(self, f: float) -> None: ...
    @overload
    def append(self, i: int) -> None: ...
    @overload
    def append(self, st: QCborSimpleType) -> None: ...
    @overload
    def append(self, tag: QCborKnownTags) -> None: ...
    @overload
    def append(self, u: int) -> None: ...
    def appendByteString(self, data: bytes, len: int) -> None: ...
    def appendNull(self) -> None: ...
    def appendTextString(self, utf8: bytes, len: int) -> None: ...
    def appendUndefined(self) -> None: ...
    def device(self) -> QIODevice: ...
    def endArray(self) -> bool: ...
    def endMap(self) -> bool: ...
    def setDevice(self, device: QIODevice) -> None: ...
    @overload
    def startArray(self, count: int) -> None: ...
    @overload
    def startArray(self) -> None: ...
    @overload
    def startMap(self, count: int) -> None: ...
    @overload
    def startMap(self) -> None: ...

class QCborStringResultByteArray(shiboken2.Object):
    data: typing.Any
    status: typing.Any
    @overload
    def __init__(self, QCborStringResultByteArray: QCborStringResultByteArray) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def __copy__(self) -> None: ...

class QCborStringResultString(shiboken2.Object):
    data: typing.Any
    status: typing.Any
    @overload
    def __init__(self, QCborStringResultString: QCborStringResultString) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def __copy__(self) -> None: ...

class QCborValue(shiboken2.Object):
    class DiagnosticNotationOption:
        Compact: typing.ClassVar[QCborValue.DiagnosticNotationOption] = ...
        ExtendedFormat: typing.ClassVar[QCborValue.DiagnosticNotationOption] = ...
        LineWrapped: typing.ClassVar[QCborValue.DiagnosticNotationOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCborValue.DiagnosticNotationOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCborValue.DiagnosticNotationOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCborValue.DiagnosticNotationOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QCborValue.DiagnosticNotationOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QCborValue.DiagnosticNotationOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCborValue.DiagnosticNotationOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QCborValue.DiagnosticNotationOptions: ...

    class DiagnosticNotationOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCborValue.DiagnosticNotationOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCborValue.DiagnosticNotationOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCborValue.DiagnosticNotationOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QCborValue.DiagnosticNotationOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QCborValue.DiagnosticNotationOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCborValue.DiagnosticNotationOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QCborValue.DiagnosticNotationOptions: ...

    class EncodingOption:
        NoTransformation: typing.ClassVar[QCborValue.EncodingOption] = ...
        SortKeysInMaps: typing.ClassVar[QCborValue.EncodingOption] = ...
        UseFloat: typing.ClassVar[QCborValue.EncodingOption] = ...
        UseFloat16: typing.ClassVar[QCborValue.EncodingOption] = ...
        UseIntegers: typing.ClassVar[QCborValue.EncodingOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCborValue.EncodingOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCborValue.EncodingOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCborValue.EncodingOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QCborValue.EncodingOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QCborValue.EncodingOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCborValue.EncodingOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QCborValue.EncodingOptions: ...

    class EncodingOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCborValue.EncodingOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCborValue.EncodingOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCborValue.EncodingOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QCborValue.EncodingOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QCborValue.EncodingOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCborValue.EncodingOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QCborValue.EncodingOptions: ...

    class Type:
        Array: typing.ClassVar[QCborValue.Type] = ...
        ByteArray: typing.ClassVar[QCborValue.Type] = ...
        DateTime: typing.ClassVar[QCborValue.Type] = ...
        Double: typing.ClassVar[QCborValue.Type] = ...
        False_: typing.ClassVar[QCborValue.Type] = ...
        Integer: typing.ClassVar[QCborValue.Type] = ...
        Invalid: typing.ClassVar[QCborValue.Type] = ...
        Map: typing.ClassVar[QCborValue.Type] = ...
        Null: typing.ClassVar[QCborValue.Type] = ...
        RegularExpression: typing.ClassVar[QCborValue.Type] = ...
        SimpleType: typing.ClassVar[QCborValue.Type] = ...
        String: typing.ClassVar[QCborValue.Type] = ...
        Tag: typing.ClassVar[QCborValue.Type] = ...
        True_: typing.ClassVar[QCborValue.Type] = ...
        Undefined: typing.ClassVar[QCborValue.Type] = ...
        Url: typing.ClassVar[QCborValue.Type] = ...
        Uuid: typing.ClassVar[QCborValue.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCborValue.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QCborValue.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCborValue.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCborValue.Type: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QCborValue.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QCborValue.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCborValue.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QCborValue.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCborValue.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCborValue.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QCborValue.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QCborValue.Type: ...
    Array: typing.ClassVar[QCborValue.Type] = ...
    ByteArray: typing.ClassVar[QCborValue.Type] = ...
    Compact: typing.ClassVar[QCborValue.DiagnosticNotationOption] = ...
    DateTime: typing.ClassVar[QCborValue.Type] = ...
    Double: typing.ClassVar[QCborValue.Type] = ...
    ExtendedFormat: typing.ClassVar[QCborValue.DiagnosticNotationOption] = ...
    False_: typing.ClassVar[QCborValue.Type] = ...
    Integer: typing.ClassVar[QCborValue.Type] = ...
    Invalid: typing.ClassVar[QCborValue.Type] = ...
    LineWrapped: typing.ClassVar[QCborValue.DiagnosticNotationOption] = ...
    Map: typing.ClassVar[QCborValue.Type] = ...
    NoTransformation: typing.ClassVar[QCborValue.EncodingOption] = ...
    Null: typing.ClassVar[QCborValue.Type] = ...
    RegularExpression: typing.ClassVar[QCborValue.Type] = ...
    SimpleType: typing.ClassVar[QCborValue.Type] = ...
    SortKeysInMaps: typing.ClassVar[QCborValue.EncodingOption] = ...
    String: typing.ClassVar[QCborValue.Type] = ...
    Tag: typing.ClassVar[QCborValue.Type] = ...
    True_: typing.ClassVar[QCborValue.Type] = ...
    Undefined: typing.ClassVar[QCborValue.Type] = ...
    Url: typing.ClassVar[QCborValue.Type] = ...
    UseFloat: typing.ClassVar[QCborValue.EncodingOption] = ...
    UseFloat16: typing.ClassVar[QCborValue.EncodingOption] = ...
    UseIntegers: typing.ClassVar[QCborValue.EncodingOption] = ...
    Uuid: typing.ClassVar[QCborValue.Type] = ...
    @overload
    def __init__(self, t_: QCborKnownTags, tv: QCborValue = ...) -> None: ...
    @overload
    def __init__(self, a: QCborArray) -> None: ...
    @overload
    def __init__(self, b_: bool) -> None: ...
    @overload
    def __init__(self, ba: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def __init__(self, dt: QDateTime) -> None: ...
    @overload
    def __init__(self, i: int) -> None: ...
    @overload
    def __init__(self, m: QCborMap) -> None: ...
    @overload
    def __init__(self, other: QCborValue) -> None: ...
    @overload
    def __init__(self, rx: QRegularExpression) -> None: ...
    @overload
    def __init__(self, s: str) -> None: ...
    @overload
    def __init__(self, s: bytes) -> None: ...
    @overload
    def __init__(self, st: QCborSimpleType) -> None: ...
    @overload
    def __init__(self, t_: QCborValue.Type) -> None: ...
    @overload
    def __init__(self, u: int) -> None: ...
    @overload
    def __init__(self, url: QUrl) -> None: ...
    @overload
    def __init__(self, uuid: QUuid) -> None: ...
    @overload
    def __init__(self, v: float) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def compare(self, other: QCborValue) -> int: ...
    @overload
    @classmethod
    def fromCbor(cls, data: bytes, len: int, error: typing.Union[QCborParserError,None] = ...) -> QCborValue: ...
    @overload
    @classmethod
    def fromCbor(cls, data: bytearray, len: int, error: typing.Union[QCborParserError,None] = ...) -> QCborValue: ...
    @overload
    @classmethod
    def fromCbor(cls, ba: typing.Union[QByteArray,bytes], error: typing.Union[QCborParserError,None] = ...) -> QCborValue: ...
    @overload
    @classmethod
    def fromCbor(cls, reader: QCborStreamReader) -> QCborValue: ...
    @classmethod
    def fromJsonValue(cls, v: QJsonValue) -> QCborValue: ...
    @classmethod
    def fromVariant(cls, variant: typing.Any) -> QCborValue: ...
    def isArray(self) -> bool: ...
    def isBool(self) -> bool: ...
    def isByteArray(self) -> bool: ...
    def isContainer(self) -> bool: ...
    def isDateTime(self) -> bool: ...
    def isDouble(self) -> bool: ...
    def isFalse(self) -> bool: ...
    def isInteger(self) -> bool: ...
    def isInvalid(self) -> bool: ...
    def isMap(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isRegularExpression(self) -> bool: ...
    @overload
    def isSimpleType(self, st: QCborSimpleType) -> bool: ...
    @overload
    def isSimpleType(self) -> bool: ...
    def isString(self) -> bool: ...
    def isTag(self) -> bool: ...
    def isTrue(self) -> bool: ...
    def isUndefined(self) -> bool: ...
    def isUrl(self) -> bool: ...
    def isUuid(self) -> bool: ...
    def swap(self, other: QCborValue) -> None: ...
    def taggedValue(self, defaultValue: QCborValue = ...) -> QCborValue: ...
    @overload
    def toArray(self, defaultValue: QCborArray) -> QCborArray: ...
    @overload
    def toArray(self) -> QCborArray: ...
    def toBool(self, defaultValue: bool = ...) -> bool: ...
    def toByteArray(self, defaultValue: typing.Union[QByteArray,bytes] = ...) -> QByteArray: ...
    @overload
    def toCbor(self, writer: QCborStreamWriter, opt: typing.Union[QCborValue.EncodingOptions,QCborValue.EncodingOption] = ...) -> None: ...
    @overload
    def toCbor(self, opt: typing.Union[QCborValue.EncodingOptions,QCborValue.EncodingOption] = ...) -> QByteArray: ...
    def toDateTime(self, defaultValue: QDateTime = ...) -> QDateTime: ...
    def toDiagnosticNotation(self, opts: typing.Union[QCborValue.DiagnosticNotationOptions,QCborValue.DiagnosticNotationOption] = ...) -> str: ...
    def toDouble(self, defaultValue: float = ...) -> float: ...
    def toInteger(self, defaultValue: int = ...) -> int: ...
    def toJsonValue(self) -> QJsonValue: ...
    @overload
    def toMap(self, defaultValue: QCborMap) -> QCborMap: ...
    @overload
    def toMap(self) -> QCborMap: ...
    def toRegularExpression(self, defaultValue: QRegularExpression = ...) -> QRegularExpression: ...
    def toSimpleType(self, defaultValue: QCborSimpleType = ...) -> QCborSimpleType: ...
    def toString(self, defaultValue: str = ...) -> str: ...
    def toUrl(self, defaultValue: QUrl = ...) -> QUrl: ...
    def toUuid(self, defaultValue: QUuid = ...) -> QUuid: ...
    def toVariant(self) -> typing.Any: ...
    def type(self) -> QCborValue.Type: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QChildEvent(QEvent):
    def __init__(self, type: QEvent.Type, child: QObject) -> None: ...
    def added(self) -> bool: ...
    def child(self) -> QObject: ...
    def polished(self) -> bool: ...
    def removed(self) -> bool: ...

class QCollator(shiboken2.Object):
    @overload
    def __init__(self, arg__1: QCollator) -> None: ...
    @overload
    def __init__(self, locale: QLocale) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def caseSensitivity(self) -> Qt.CaseSensitivity: ...
    @overload
    def compare(self, s1: bytes, len1: int, s2: bytes, len2: int) -> int: ...
    @overload
    def compare(self, s1: str, s2: str) -> int: ...
    def ignorePunctuation(self) -> bool: ...
    def locale(self) -> QLocale: ...
    def numericMode(self) -> bool: ...
    def setCaseSensitivity(self, cs: Qt.CaseSensitivity) -> None: ...
    def setIgnorePunctuation(self, on: bool) -> None: ...
    def setLocale(self, locale: QLocale) -> None: ...
    def setNumericMode(self, on: bool) -> None: ...
    def sortKey(self, string: str) -> QCollatorSortKey: ...
    def swap(self, other: QCollator) -> None: ...
    def __call__(self, s1: str, s2: str) -> bool: ...

class QCollatorSortKey(shiboken2.Object):
    def __init__(self, other: QCollatorSortKey) -> None: ...
    def compare(self, key: QCollatorSortKey) -> int: ...
    def swap(self, other: QCollatorSortKey) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QCommandLineOption(shiboken2.Object):
    class Flag:
        HiddenFromHelp: typing.ClassVar[QCommandLineOption.Flag] = ...
        ShortOptionStyle: typing.ClassVar[QCommandLineOption.Flag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCommandLineOption.Flags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCommandLineOption.Flags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCommandLineOption.Flags: ...
        def __rand__(self, other: typing.SupportsInt) -> QCommandLineOption.Flags: ...
        def __ror__(self, other: typing.SupportsInt) -> QCommandLineOption.Flags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCommandLineOption.Flags: ...
        def __xor__(self, other: typing.SupportsInt) -> QCommandLineOption.Flags: ...

    class Flags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QCommandLineOption.Flags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QCommandLineOption.Flags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCommandLineOption.Flags: ...
        def __rand__(self, other: typing.SupportsInt) -> QCommandLineOption.Flags: ...
        def __ror__(self, other: typing.SupportsInt) -> QCommandLineOption.Flags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCommandLineOption.Flags: ...
        def __xor__(self, other: typing.SupportsInt) -> QCommandLineOption.Flags: ...
    HiddenFromHelp: typing.ClassVar[QCommandLineOption.Flag] = ...
    ShortOptionStyle: typing.ClassVar[QCommandLineOption.Flag] = ...
    @overload
    def __init__(self, name: str, description: str, valueName: str = ..., defaultValue: str = ...) -> None: ...
    @overload
    def __init__(self, names: typing.Iterable[str], description: str, valueName: str = ..., defaultValue: str = ...) -> None: ...
    @overload
    def __init__(self, name: str) -> None: ...
    @overload
    def __init__(self, names: typing.Iterable[str]) -> None: ...
    @overload
    def __init__(self, other: QCommandLineOption) -> None: ...
    def defaultValues(self) -> typing.List[str]: ...
    def description(self) -> str: ...
    def flags(self) -> typing.Union[QCommandLineOption.Flags,QCommandLineOption.Flag]: ...
    def isHidden(self) -> bool: ...
    def names(self) -> typing.List[str]: ...
    def setDefaultValue(self, defaultValue: str) -> None: ...
    def setDefaultValues(self, defaultValues: typing.Iterable[str]) -> None: ...
    def setDescription(self, description: str) -> None: ...
    def setFlags(self, aflags: typing.Union[QCommandLineOption.Flags,QCommandLineOption.Flag]) -> None: ...
    def setHidden(self, hidden: bool) -> None: ...
    def setValueName(self, name: str) -> None: ...
    def swap(self, other: QCommandLineOption) -> None: ...
    def valueName(self) -> str: ...

class QCommandLineParser(shiboken2.Object):
    class OptionsAfterPositionalArgumentsMode:
        ParseAsOptions: typing.ClassVar[QCommandLineParser.OptionsAfterPositionalArgumentsMode] = ...
        ParseAsPositionalArguments: typing.ClassVar[QCommandLineParser.OptionsAfterPositionalArgumentsMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCommandLineParser.OptionsAfterPositionalArgumentsMode: ...
        def __and__(self, other: typing.SupportsInt) -> QCommandLineParser.OptionsAfterPositionalArgumentsMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCommandLineParser.OptionsAfterPositionalArgumentsMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCommandLineParser.OptionsAfterPositionalArgumentsMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QCommandLineParser.OptionsAfterPositionalArgumentsMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QCommandLineParser.OptionsAfterPositionalArgumentsMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCommandLineParser.OptionsAfterPositionalArgumentsMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QCommandLineParser.OptionsAfterPositionalArgumentsMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCommandLineParser.OptionsAfterPositionalArgumentsMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCommandLineParser.OptionsAfterPositionalArgumentsMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QCommandLineParser.OptionsAfterPositionalArgumentsMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QCommandLineParser.OptionsAfterPositionalArgumentsMode: ...

    class SingleDashWordOptionMode:
        ParseAsCompactedShortOptions: typing.ClassVar[QCommandLineParser.SingleDashWordOptionMode] = ...
        ParseAsLongOptions: typing.ClassVar[QCommandLineParser.SingleDashWordOptionMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCommandLineParser.SingleDashWordOptionMode: ...
        def __and__(self, other: typing.SupportsInt) -> QCommandLineParser.SingleDashWordOptionMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCommandLineParser.SingleDashWordOptionMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCommandLineParser.SingleDashWordOptionMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QCommandLineParser.SingleDashWordOptionMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QCommandLineParser.SingleDashWordOptionMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCommandLineParser.SingleDashWordOptionMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QCommandLineParser.SingleDashWordOptionMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCommandLineParser.SingleDashWordOptionMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCommandLineParser.SingleDashWordOptionMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QCommandLineParser.SingleDashWordOptionMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QCommandLineParser.SingleDashWordOptionMode: ...
    ParseAsCompactedShortOptions: typing.ClassVar[QCommandLineParser.SingleDashWordOptionMode] = ...
    ParseAsLongOptions: typing.ClassVar[QCommandLineParser.SingleDashWordOptionMode] = ...
    ParseAsOptions: typing.ClassVar[QCommandLineParser.OptionsAfterPositionalArgumentsMode] = ...
    ParseAsPositionalArguments: typing.ClassVar[QCommandLineParser.OptionsAfterPositionalArgumentsMode] = ...
    def __init__(self) -> None: ...
    def addHelpOption(self) -> QCommandLineOption: ...
    def addOption(self, commandLineOption: QCommandLineOption) -> bool: ...
    def addOptions(self, options: typing.Iterable[QCommandLineOption]) -> bool: ...
    def addPositionalArgument(self, name: str, description: str, syntax: str = ...) -> None: ...
    def addVersionOption(self) -> QCommandLineOption: ...
    def applicationDescription(self) -> str: ...
    def clearPositionalArguments(self) -> None: ...
    def errorText(self) -> str: ...
    def helpText(self) -> str: ...
    @overload
    def isSet(self, name: str) -> bool: ...
    @overload
    def isSet(self, option: QCommandLineOption) -> bool: ...
    def optionNames(self) -> typing.List[str]: ...
    def parse(self, arguments: typing.Iterable[str]) -> bool: ...
    def positionalArguments(self) -> typing.List[str]: ...
    @overload
    def process(self, app: QCoreApplication) -> None: ...
    @overload
    def process(self, arguments: typing.Iterable[str]) -> None: ...
    def setApplicationDescription(self, description: str) -> None: ...
    def setOptionsAfterPositionalArgumentsMode(self, mode: QCommandLineParser.OptionsAfterPositionalArgumentsMode) -> None: ...
    def setSingleDashWordOptionMode(self, parsingMode: QCommandLineParser.SingleDashWordOptionMode) -> None: ...
    def showHelp(self, exitCode: int = ...) -> None: ...
    def showVersion(self) -> None: ...
    def unknownOptionNames(self) -> typing.List[str]: ...
    @overload
    def value(self, name: str) -> str: ...
    @overload
    def value(self, option: QCommandLineOption) -> str: ...
    @overload
    def values(self, name: str) -> typing.List[str]: ...
    @overload
    def values(self, option: QCommandLineOption) -> typing.List[str]: ...

class QConcatenateTablesProxyModel(QAbstractItemModel):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ...) -> None: ...
    def addSourceModel(self, sourceModel: QAbstractItemModel) -> None: ...
    def canDropMimeData(self, data: QMimeData, action: Qt.DropAction, row: int, column: int, parent: QModelIndex) -> bool: ...
    def columnCount(self, parent: QModelIndex = ...) -> int: ...
    def data(self, index: QModelIndex, role: Qt.ItemDataRole = ...) -> typing.Any: ...
    def dropMimeData(self, data: QMimeData, action: Qt.DropAction, row: int, column: int, parent: QModelIndex) -> bool: ...
    def flags(self, index: QModelIndex) -> typing.Union[Qt.ItemFlags,Qt.ItemFlag]: ...
    def headerData(self, section: int, orientation: Qt.Orientation, role: Qt.ItemDataRole = ...) -> typing.Any: ...
    def index(self, row: int, column: int, parent: QModelIndex = ...) -> QModelIndex: ...
    def itemData(self, proxyIndex: QModelIndex) -> typing.Dict[int,typing.Any]: ...
    def mapFromSource(self, sourceIndex: QModelIndex) -> QModelIndex: ...
    def mapToSource(self, proxyIndex: QModelIndex) -> QModelIndex: ...
    def mimeData(self, indexes: typing.List[int]) -> QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    @overload
    def parent(self, index: QModelIndex) -> QModelIndex: ...
    @overload
    def parent(self) -> QObject: ...
    def removeSourceModel(self, sourceModel: QAbstractItemModel) -> None: ...
    def rowCount(self, parent: QModelIndex = ...) -> int: ...
    def setData(self, index: QModelIndex, value: typing.Any, role: Qt.ItemDataRole = ...) -> bool: ...
    def setItemData(self, index: QModelIndex, roles: typing.Dict[int,typing.Any]) -> bool: ...
    def sourceModels(self) -> typing.List[QAbstractItemModel]: ...
    def span(self, index: QModelIndex) -> QSize: ...

class QCoreApplication(QObject):
    ApplicationFlags: typing.ClassVar[int] = ...
    aboutToQuit: typing.ClassVar[Signal] = ...
    applicationNameChanged: typing.ClassVar[Signal] = ...
    applicationVersionChanged: typing.ClassVar[Signal] = ...
    organizationDomainChanged: typing.ClassVar[Signal] = ...
    organizationNameChanged: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, arg__1: typing.Iterable[str], destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @classmethod
    def addLibraryPath(cls, arg__1: str) -> None: ...
    @classmethod
    def applicationDirPath(cls) -> str: ...
    @classmethod
    def applicationFilePath(cls) -> str: ...
    @classmethod
    def applicationName(cls) -> str: ...
    @classmethod
    def applicationPid(cls) -> int: ...
    @classmethod
    def applicationVersion(cls) -> str: ...
    @classmethod
    def arguments(cls) -> typing.List[str]: ...
    @classmethod
    def closingDown(cls) -> bool: ...
    def event(self, arg__1: QEvent) -> bool: ...
    @classmethod
    def eventDispatcher(cls) -> QAbstractEventDispatcher: ...
    @classmethod
    def exec_(cls) -> int: ...
    @classmethod
    def exit(cls, retcode: int = ...) -> None: ...
    @classmethod
    def flush(cls) -> None: ...
    @classmethod
    def hasPendingEvents(cls) -> bool: ...
    def installNativeEventFilter(self, filterObj: QAbstractNativeEventFilter) -> None: ...
    @classmethod
    def installTranslator(cls, messageFile: QTranslator) -> bool: ...
    @classmethod
    def instance(cls: typing.Type[T]) -> T: ...
    @classmethod
    def isQuitLockEnabled(cls) -> bool: ...
    @classmethod
    def isSetuidAllowed(cls) -> bool: ...
    @classmethod
    def libraryPaths(cls) -> typing.List[str]: ...
    def notify(self, arg__1: QObject, arg__2: QEvent) -> bool: ...
    @classmethod
    def organizationDomain(cls) -> str: ...
    @classmethod
    def organizationName(cls) -> str: ...
    @classmethod
    def postEvent(cls, receiver: QObject, event: QEvent, priority: int = ...) -> None: ...
    @overload
    @classmethod
    def processEvents(cls, flags: typing.Union[QEventLoop.ProcessEventsFlags,QEventLoop.ProcessEventsFlag], maxtime: int) -> None: ...
    @overload
    @classmethod
    def processEvents(cls, flags: typing.Union[QEventLoop.ProcessEventsFlags,QEventLoop.ProcessEventsFlag] = ...) -> None: ...
    @classmethod
    def quit(cls) -> None: ...
    @classmethod
    def removeLibraryPath(cls, arg__1: str) -> None: ...
    def removeNativeEventFilter(self, filterObj: QAbstractNativeEventFilter) -> None: ...
    @classmethod
    def removePostedEvents(cls, receiver: QObject, eventType: int = ...) -> None: ...
    @classmethod
    def removeTranslator(cls, messageFile: QTranslator) -> bool: ...
    @classmethod
    def sendEvent(cls, receiver: QObject, event: QEvent) -> bool: ...
    @classmethod
    def sendPostedEvents(cls, receiver: typing.Union[QObject,None] = ..., event_type: int = ...) -> None: ...
    @classmethod
    def setApplicationName(cls, application: str) -> None: ...
    @classmethod
    def setApplicationVersion(cls, version: str) -> None: ...
    @classmethod
    def setAttribute(cls, attribute: Qt.ApplicationAttribute, on: bool = ...) -> None: ...
    @classmethod
    def setEventDispatcher(cls, eventDispatcher: QAbstractEventDispatcher) -> None: ...
    @classmethod
    def setLibraryPaths(cls, arg__1: typing.Iterable[str]) -> None: ...
    @classmethod
    def setOrganizationDomain(cls, orgDomain: str) -> None: ...
    @classmethod
    def setOrganizationName(cls, orgName: str) -> None: ...
    @classmethod
    def setQuitLockEnabled(cls, enabled: bool) -> None: ...
    @classmethod
    def setSetuidAllowed(cls, allow: bool) -> None: ...
    def shutdown(self) -> None: ...
    @classmethod
    def startingUp(cls) -> bool: ...
    @classmethod
    def testAttribute(cls, attribute: Qt.ApplicationAttribute) -> bool: ...
    @classmethod
    def translate(cls, context: str, key: str, disambiguation: typing.Union[str,None] = ..., n: int = ...) -> str: ...

class QCryptographicHash(shiboken2.Object):
    class Algorithm:
        Keccak_224: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        Keccak_256: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        Keccak_384: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        Keccak_512: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        Md4: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        Md5: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        RealSha3_224: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        RealSha3_256: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        RealSha3_384: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        RealSha3_512: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        Sha1: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        Sha224: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        Sha256: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        Sha384: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        Sha3_224: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        Sha3_256: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        Sha3_384: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        Sha3_512: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        Sha512: typing.ClassVar[QCryptographicHash.Algorithm] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QCryptographicHash.Algorithm: ...
        def __and__(self, other: typing.SupportsInt) -> QCryptographicHash.Algorithm: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QCryptographicHash.Algorithm: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QCryptographicHash.Algorithm: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QCryptographicHash.Algorithm: ...
        def __rand__(self, other: typing.SupportsInt) -> QCryptographicHash.Algorithm: ...
        def __rmul__(self, other: typing.SupportsInt) -> QCryptographicHash.Algorithm: ...
        def __ror__(self, other: typing.SupportsInt) -> QCryptographicHash.Algorithm: ...
        def __rsub__(self, other: typing.SupportsInt) -> QCryptographicHash.Algorithm: ...
        def __rxor__(self, other: typing.SupportsInt) -> QCryptographicHash.Algorithm: ...
        def __sub__(self, other: typing.SupportsInt) -> QCryptographicHash.Algorithm: ...
        def __xor__(self, other: typing.SupportsInt) -> QCryptographicHash.Algorithm: ...
    Keccak_224: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    Keccak_256: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    Keccak_384: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    Keccak_512: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    Md4: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    Md5: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    RealSha3_224: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    RealSha3_256: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    RealSha3_384: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    RealSha3_512: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    Sha1: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    Sha224: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    Sha256: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    Sha384: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    Sha3_224: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    Sha3_256: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    Sha3_384: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    Sha3_512: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    Sha512: typing.ClassVar[QCryptographicHash.Algorithm] = ...
    def __init__(self, method: QCryptographicHash.Algorithm) -> None: ...
    @overload
    def addData(self, data: bytes, length: int) -> None: ...
    @overload
    def addData(self, data: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def addData(self, device: QIODevice) -> bool: ...
    @classmethod
    def hash(cls, data: typing.Union[QByteArray,bytes], method: QCryptographicHash.Algorithm) -> QByteArray: ...
    @classmethod
    def hashLength(cls, method: QCryptographicHash.Algorithm) -> int: ...
    def reset(self) -> None: ...
    def result(self) -> QByteArray: ...

class QDataStream(shiboken2.Object):
    class ByteOrder:
        BigEndian: typing.ClassVar[QDataStream.ByteOrder] = ...
        LittleEndian: typing.ClassVar[QDataStream.ByteOrder] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDataStream.ByteOrder: ...
        def __and__(self, other: typing.SupportsInt) -> QDataStream.ByteOrder: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDataStream.ByteOrder: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDataStream.ByteOrder: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QDataStream.ByteOrder: ...
        def __rand__(self, other: typing.SupportsInt) -> QDataStream.ByteOrder: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDataStream.ByteOrder: ...
        def __ror__(self, other: typing.SupportsInt) -> QDataStream.ByteOrder: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDataStream.ByteOrder: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDataStream.ByteOrder: ...
        def __sub__(self, other: typing.SupportsInt) -> QDataStream.ByteOrder: ...
        def __xor__(self, other: typing.SupportsInt) -> QDataStream.ByteOrder: ...

    class FloatingPointPrecision:
        DoublePrecision: typing.ClassVar[QDataStream.FloatingPointPrecision] = ...
        SinglePrecision: typing.ClassVar[QDataStream.FloatingPointPrecision] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDataStream.FloatingPointPrecision: ...
        def __and__(self, other: typing.SupportsInt) -> QDataStream.FloatingPointPrecision: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDataStream.FloatingPointPrecision: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDataStream.FloatingPointPrecision: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QDataStream.FloatingPointPrecision: ...
        def __rand__(self, other: typing.SupportsInt) -> QDataStream.FloatingPointPrecision: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDataStream.FloatingPointPrecision: ...
        def __ror__(self, other: typing.SupportsInt) -> QDataStream.FloatingPointPrecision: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDataStream.FloatingPointPrecision: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDataStream.FloatingPointPrecision: ...
        def __sub__(self, other: typing.SupportsInt) -> QDataStream.FloatingPointPrecision: ...
        def __xor__(self, other: typing.SupportsInt) -> QDataStream.FloatingPointPrecision: ...

    class Status:
        Ok: typing.ClassVar[QDataStream.Status] = ...
        ReadCorruptData: typing.ClassVar[QDataStream.Status] = ...
        ReadPastEnd: typing.ClassVar[QDataStream.Status] = ...
        WriteFailed: typing.ClassVar[QDataStream.Status] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDataStream.Status: ...
        def __and__(self, other: typing.SupportsInt) -> QDataStream.Status: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDataStream.Status: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDataStream.Status: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QDataStream.Status: ...
        def __rand__(self, other: typing.SupportsInt) -> QDataStream.Status: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDataStream.Status: ...
        def __ror__(self, other: typing.SupportsInt) -> QDataStream.Status: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDataStream.Status: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDataStream.Status: ...
        def __sub__(self, other: typing.SupportsInt) -> QDataStream.Status: ...
        def __xor__(self, other: typing.SupportsInt) -> QDataStream.Status: ...

    class Version:
        Qt_1_0: typing.ClassVar[QDataStream.Version] = ...
        Qt_2_0: typing.ClassVar[QDataStream.Version] = ...
        Qt_2_1: typing.ClassVar[QDataStream.Version] = ...
        Qt_3_0: typing.ClassVar[QDataStream.Version] = ...
        Qt_3_1: typing.ClassVar[QDataStream.Version] = ...
        Qt_3_3: typing.ClassVar[QDataStream.Version] = ...
        Qt_4_0: typing.ClassVar[QDataStream.Version] = ...
        Qt_4_1: typing.ClassVar[QDataStream.Version] = ...
        Qt_4_2: typing.ClassVar[QDataStream.Version] = ...
        Qt_4_3: typing.ClassVar[QDataStream.Version] = ...
        Qt_4_4: typing.ClassVar[QDataStream.Version] = ...
        Qt_4_5: typing.ClassVar[QDataStream.Version] = ...
        Qt_4_6: typing.ClassVar[QDataStream.Version] = ...
        Qt_4_7: typing.ClassVar[QDataStream.Version] = ...
        Qt_4_8: typing.ClassVar[QDataStream.Version] = ...
        Qt_4_9: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_0: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_1: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_10: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_11: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_12: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_13: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_14: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_15: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_2: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_3: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_4: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_5: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_6: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_7: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_8: typing.ClassVar[QDataStream.Version] = ...
        Qt_5_9: typing.ClassVar[QDataStream.Version] = ...
        Qt_DefaultCompiledVersion: typing.ClassVar[QDataStream.Version] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDataStream.Version: ...
        def __and__(self, other: typing.SupportsInt) -> QDataStream.Version: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDataStream.Version: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDataStream.Version: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QDataStream.Version: ...
        def __rand__(self, other: typing.SupportsInt) -> QDataStream.Version: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDataStream.Version: ...
        def __ror__(self, other: typing.SupportsInt) -> QDataStream.Version: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDataStream.Version: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDataStream.Version: ...
        def __sub__(self, other: typing.SupportsInt) -> QDataStream.Version: ...
        def __xor__(self, other: typing.SupportsInt) -> QDataStream.Version: ...
    BigEndian: typing.ClassVar[QDataStream.ByteOrder] = ...
    DoublePrecision: typing.ClassVar[QDataStream.FloatingPointPrecision] = ...
    LittleEndian: typing.ClassVar[QDataStream.ByteOrder] = ...
    Ok: typing.ClassVar[QDataStream.Status] = ...
    Qt_1_0: typing.ClassVar[QDataStream.Version] = ...
    Qt_2_0: typing.ClassVar[QDataStream.Version] = ...
    Qt_2_1: typing.ClassVar[QDataStream.Version] = ...
    Qt_3_0: typing.ClassVar[QDataStream.Version] = ...
    Qt_3_1: typing.ClassVar[QDataStream.Version] = ...
    Qt_3_3: typing.ClassVar[QDataStream.Version] = ...
    Qt_4_0: typing.ClassVar[QDataStream.Version] = ...
    Qt_4_1: typing.ClassVar[QDataStream.Version] = ...
    Qt_4_2: typing.ClassVar[QDataStream.Version] = ...
    Qt_4_3: typing.ClassVar[QDataStream.Version] = ...
    Qt_4_4: typing.ClassVar[QDataStream.Version] = ...
    Qt_4_5: typing.ClassVar[QDataStream.Version] = ...
    Qt_4_6: typing.ClassVar[QDataStream.Version] = ...
    Qt_4_7: typing.ClassVar[QDataStream.Version] = ...
    Qt_4_8: typing.ClassVar[QDataStream.Version] = ...
    Qt_4_9: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_0: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_1: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_10: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_11: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_12: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_13: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_14: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_15: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_2: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_3: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_4: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_5: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_6: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_7: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_8: typing.ClassVar[QDataStream.Version] = ...
    Qt_5_9: typing.ClassVar[QDataStream.Version] = ...
    Qt_DefaultCompiledVersion: typing.ClassVar[QDataStream.Version] = ...
    ReadCorruptData: typing.ClassVar[QDataStream.Status] = ...
    ReadPastEnd: typing.ClassVar[QDataStream.Status] = ...
    SinglePrecision: typing.ClassVar[QDataStream.FloatingPointPrecision] = ...
    WriteFailed: typing.ClassVar[QDataStream.Status] = ...
    @overload
    def __init__(self, arg__1: typing.Union[QByteArray,bytes], flags: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag]) -> None: ...
    @overload
    def __init__(self, arg__1: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def __init__(self, arg__1: QIODevice) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def abortTransaction(self) -> None: ...
    def atEnd(self) -> bool: ...
    def byteOrder(self) -> QDataStream.ByteOrder: ...
    def commitTransaction(self) -> bool: ...
    def device(self) -> QIODevice: ...
    def floatingPointPrecision(self) -> QDataStream.FloatingPointPrecision: ...
    def readBool(self) -> bool: ...
    def readDouble(self) -> float: ...
    def readFloat(self) -> float: ...
    def readInt16(self) -> int: ...
    def readInt32(self) -> int: ...
    def readInt64(self) -> int: ...
    def readInt8(self) -> int: ...
    def readQChar(self) -> str: ...
    def readQString(self) -> str: ...
    def readQStringList(self) -> typing.List[str]: ...
    def readQVariant(self) -> typing.Any: ...
    def readRawData(self, arg__1: bytes, len: int) -> int: ...
    def readString(self) -> str: ...
    def readUInt16(self) -> int: ...
    def readUInt32(self) -> int: ...
    def readUInt64(self) -> int: ...
    def readUInt8(self) -> int: ...
    def resetStatus(self) -> None: ...
    def rollbackTransaction(self) -> None: ...
    def setByteOrder(self, arg__1: QDataStream.ByteOrder) -> None: ...
    def setDevice(self, arg__1: QIODevice) -> None: ...
    def setFloatingPointPrecision(self, precision: QDataStream.FloatingPointPrecision) -> None: ...
    def setStatus(self, status: QDataStream.Status) -> None: ...
    def setVersion(self, arg__1: int) -> None: ...
    def skipRawData(self, len: int) -> int: ...
    def startTransaction(self) -> None: ...
    def status(self) -> QDataStream.Status: ...
    def unsetDevice(self) -> None: ...
    def version(self) -> int: ...
    def writeBool(self, arg__1: bool) -> None: ...
    def writeDouble(self, arg__1: float) -> None: ...
    def writeFloat(self, arg__1: float) -> None: ...
    def writeInt16(self, arg__1: int) -> None: ...
    def writeInt32(self, arg__1: int) -> None: ...
    def writeInt64(self, arg__1: int) -> None: ...
    def writeInt8(self, arg__1: int) -> None: ...
    def writeQChar(self, arg__1: str) -> None: ...
    def writeQString(self, arg__1: str) -> None: ...
    def writeQStringList(self, arg__1: typing.Iterable[str]) -> None: ...
    def writeQVariant(self, arg__1: typing.Any) -> None: ...
    def writeRawData(self, arg__1: bytes, len: int) -> int: ...
    def writeString(self, arg__1: str) -> None: ...
    def writeUInt16(self, arg__1: int) -> None: ...
    def writeUInt32(self, arg__1: int) -> None: ...
    def writeUInt64(self, arg__1: int) -> None: ...
    def writeUInt8(self, arg__1: int) -> None: ...
    @overload
    def __lshift__(self, arg__1: str) -> None: ...
    @overload
    def __lshift__(self, arg__2: QBitArray) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: typing.Union[QByteArray,bytes]) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QCborArray) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QCborMap) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QCborValue) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QDate) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QDateTime) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: typing.Union[QEasingCurve,QEasingCurve.Type]) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QJsonArray) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QJsonDocument) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QJsonValue) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QLine) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QLineF) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QLocale) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QMargins) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QMarginsF) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QPoint) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QPointF) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QRect) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QRectF) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QSize) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QSizeF) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QTime) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QUrl) -> QDataStream: ...
    @overload
    def __lshift__(self, arg__2: QUuid) -> QDataStream: ...
    @overload
    def __lshift__(self, re: QRegularExpression) -> QDataStream: ...
    @overload
    def __lshift__(self, regExp: QRegExp) -> QDataStream: ...
    @overload
    def __lshift__(self, tz: QTimeZone) -> QDataStream: ...
    @overload
    def __lshift__(self, version: QVersionNumber) -> QDataStream: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    @overload
    def __rshift__(self, arg__2: QBitArray) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: typing.Union[QByteArray,bytes]) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QCborArray) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QCborMap) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QCborValue) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QDate) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QDateTime) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: typing.Union[QEasingCurve,QEasingCurve.Type]) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QJsonArray) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QJsonDocument) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QJsonValue) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QLine) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QLineF) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QLocale) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QMargins) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QMarginsF) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QPoint) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QPointF) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QRect) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QRectF) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QSize) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QSizeF) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QTime) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QUrl) -> QDataStream: ...
    @overload
    def __rshift__(self, arg__2: QUuid) -> QDataStream: ...
    @overload
    def __rshift__(self, re: QRegularExpression) -> QDataStream: ...
    @overload
    def __rshift__(self, regExp: QRegExp) -> QDataStream: ...
    @overload
    def __rshift__(self, tz: QTimeZone) -> QDataStream: ...
    @overload
    def __rshift__(self, version: QVersionNumber) -> QDataStream: ...

class QDate(shiboken2.Object):
    class MonthNameType:
        DateFormat: typing.ClassVar[QDate.MonthNameType] = ...
        StandaloneFormat: typing.ClassVar[QDate.MonthNameType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDate.MonthNameType: ...
        def __and__(self, other: typing.SupportsInt) -> QDate.MonthNameType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDate.MonthNameType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDate.MonthNameType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QDate.MonthNameType: ...
        def __rand__(self, other: typing.SupportsInt) -> QDate.MonthNameType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDate.MonthNameType: ...
        def __ror__(self, other: typing.SupportsInt) -> QDate.MonthNameType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDate.MonthNameType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDate.MonthNameType: ...
        def __sub__(self, other: typing.SupportsInt) -> QDate.MonthNameType: ...
        def __xor__(self, other: typing.SupportsInt) -> QDate.MonthNameType: ...
    DateFormat: typing.ClassVar[QDate.MonthNameType] = ...
    StandaloneFormat: typing.ClassVar[QDate.MonthNameType] = ...
    @overload
    def __init__(self, y: int, m: int, d: int, cal: QCalendar) -> None: ...
    @overload
    def __init__(self, y: int, m: int, d: int) -> None: ...
    @overload
    def __init__(self, QDate: QDate) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, date: datetime.date) -> None: ...
    def addDays(self, days: int) -> QDate: ...
    @overload
    def addMonths(self, months: int, cal: QCalendar) -> QDate: ...
    @overload
    def addMonths(self, months: int) -> QDate: ...
    @overload
    def addYears(self, years: int, cal: QCalendar) -> QDate: ...
    @overload
    def addYears(self, years: int) -> QDate: ...
    @classmethod
    def currentDate(cls) -> QDate: ...
    @overload
    def day(self, cal: QCalendar) -> int: ...
    @overload
    def day(self) -> int: ...
    @overload
    def dayOfWeek(self, cal: QCalendar) -> int: ...
    @overload
    def dayOfWeek(self) -> int: ...
    @overload
    def dayOfYear(self, cal: QCalendar) -> int: ...
    @overload
    def dayOfYear(self) -> int: ...
    @overload
    def daysInMonth(self, cal: QCalendar) -> int: ...
    @overload
    def daysInMonth(self) -> int: ...
    @overload
    def daysInYear(self, cal: QCalendar) -> int: ...
    @overload
    def daysInYear(self) -> int: ...
    def daysTo(self, arg__1: QDate) -> int: ...
    @overload
    def endOfDay(self, spec: Qt.TimeSpec = ..., offsetSeconds: int = ...) -> QDateTime: ...
    @overload
    def endOfDay(self, zone: QTimeZone) -> QDateTime: ...
    @classmethod
    def fromJulianDay(cls, jd_: int) -> QDate: ...
    @overload
    @classmethod
    def fromString(cls, s: str, format: str, cal: QCalendar) -> QDate: ...
    @overload
    @classmethod
    def fromString(cls, s: str, f: Qt.DateFormat = ...) -> QDate: ...
    @overload
    @classmethod
    def fromString(cls, s: str, format: str) -> QDate: ...
    def getDate(self) -> typing.Tuple[int,int,int]: ...
    @classmethod
    def isLeapYear(cls, year: int) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    @classmethod
    def longDayName(cls, weekday: int, type: QDate.MonthNameType = ...) -> str: ...
    @classmethod
    def longMonthName(cls, month: int, type: QDate.MonthNameType = ...) -> str: ...
    @overload
    def month(self, cal: QCalendar) -> int: ...
    @overload
    def month(self) -> int: ...
    @overload
    def setDate(self, year: int, month: int, day: int, cal: QCalendar) -> bool: ...
    @overload
    def setDate(self, year: int, month: int, day: int) -> bool: ...
    @classmethod
    def shortDayName(cls, weekday: int, type: QDate.MonthNameType = ...) -> str: ...
    @classmethod
    def shortMonthName(cls, month: int, type: QDate.MonthNameType = ...) -> str: ...
    @overload
    def startOfDay(self, spec: Qt.TimeSpec = ..., offsetSeconds: int = ...) -> QDateTime: ...
    @overload
    def startOfDay(self, zone: QTimeZone) -> QDateTime: ...
    def toJulianDay(self) -> int: ...
    def toPython(self) -> object: ...
    @overload
    def toString(self, format: Qt.DateFormat, cal: QCalendar) -> str: ...
    @overload
    def toString(self, format: str, cal: QCalendar) -> str: ...
    @overload
    def toString(self, format: Qt.DateFormat = ...) -> str: ...
    @overload
    def toString(self, format: str) -> str: ...
    def weekNumber(self) -> typing.Tuple[int,int]: ...
    @overload
    def year(self, cal: QCalendar) -> int: ...
    @overload
    def year(self) -> int: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QDateTime(shiboken2.Object):
    class YearRange:
        First: typing.ClassVar[QDateTime.YearRange] = ...
        Last: typing.ClassVar[QDateTime.YearRange] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDateTime.YearRange: ...
        def __and__(self, other: typing.SupportsInt) -> QDateTime.YearRange: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDateTime.YearRange: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDateTime.YearRange: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QDateTime.YearRange: ...
        def __rand__(self, other: typing.SupportsInt) -> QDateTime.YearRange: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDateTime.YearRange: ...
        def __ror__(self, other: typing.SupportsInt) -> QDateTime.YearRange: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDateTime.YearRange: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDateTime.YearRange: ...
        def __sub__(self, other: typing.SupportsInt) -> QDateTime.YearRange: ...
        def __xor__(self, other: typing.SupportsInt) -> QDateTime.YearRange: ...
    @overload
    def __init__(self, arg__1: int, arg__2: int, arg__3: int, arg__4: int, arg__5: int, arg__6: int, arg__7: int, arg__8: int = ...) -> None: ...
    @overload
    def __init__(self, arg__1: int, arg__2: int, arg__3: int, arg__4: int, arg__5: int, arg__6: int) -> None: ...
    @overload
    def __init__(self, date: QDate, time: QTime, spec: Qt.TimeSpec, offsetSeconds: int) -> None: ...
    @overload
    def __init__(self, arg__1: QDate, arg__2: QTime, spec: Qt.TimeSpec = ...) -> None: ...
    @overload
    def __init__(self, date: QDate, time: QTime, timeZone: QTimeZone) -> None: ...
    @overload
    def __init__(self, arg__1: QDate) -> None: ...
    @overload
    def __init__(self, other: QDateTime) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, datetime: datetime.datetime) -> None: ...
    def addDays(self, days: int) -> QDateTime: ...
    def addMSecs(self, msecs: int) -> QDateTime: ...
    def addMonths(self, months: int) -> QDateTime: ...
    def addSecs(self, secs: int) -> QDateTime: ...
    def addYears(self, years: int) -> QDateTime: ...
    @classmethod
    def currentDateTime(cls) -> QDateTime: ...
    @classmethod
    def currentDateTimeUtc(cls) -> QDateTime: ...
    @classmethod
    def currentMSecsSinceEpoch(cls) -> int: ...
    @classmethod
    def currentSecsSinceEpoch(cls) -> int: ...
    def date(self) -> QDate: ...
    def daysTo(self, arg__1: QDateTime) -> int: ...
    @overload
    @classmethod
    def fromMSecsSinceEpoch(cls, msecs: int, spec: Qt.TimeSpec, offsetFromUtc: int = ...) -> QDateTime: ...
    @overload
    @classmethod
    def fromMSecsSinceEpoch(cls, msecs: int, timeZone: QTimeZone) -> QDateTime: ...
    @overload
    @classmethod
    def fromMSecsSinceEpoch(cls, msecs: int) -> QDateTime: ...
    @overload
    @classmethod
    def fromSecsSinceEpoch(cls, secs: int, spe: Qt.TimeSpec = ..., offsetFromUtc: int = ...) -> QDateTime: ...
    @overload
    @classmethod
    def fromSecsSinceEpoch(cls, secs: int, timeZone: QTimeZone) -> QDateTime: ...
    @overload
    @classmethod
    def fromString(cls, s: str, format: str, cal: QCalendar) -> QDateTime: ...
    @overload
    @classmethod
    def fromString(cls, s: str, f: Qt.DateFormat = ...) -> QDateTime: ...
    @overload
    @classmethod
    def fromString(cls, s: str, format: str) -> QDateTime: ...
    @overload
    @classmethod
    def fromTime_t(cls, secsSince1Jan1970UTC: int, spec: Qt.TimeSpec, offsetFromUtc: int = ...) -> QDateTime: ...
    @overload
    @classmethod
    def fromTime_t(cls, secsSince1Jan1970UTC: int, timeZone: QTimeZone) -> QDateTime: ...
    @overload
    @classmethod
    def fromTime_t(cls, secsSince1Jan1970UTC: int) -> QDateTime: ...
    def isDaylightTime(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def msecsTo(self, arg__1: QDateTime) -> int: ...
    def offsetFromUtc(self) -> int: ...
    def secsTo(self, arg__1: QDateTime) -> int: ...
    def setDate(self, date: QDate) -> None: ...
    def setMSecsSinceEpoch(self, msecs: int) -> None: ...
    def setOffsetFromUtc(self, offsetSeconds: int) -> None: ...
    def setSecsSinceEpoch(self, secs: int) -> None: ...
    def setTime(self, time: QTime) -> None: ...
    def setTimeSpec(self, spec: Qt.TimeSpec) -> None: ...
    def setTimeZone(self, toZone: QTimeZone) -> None: ...
    def setTime_t(self, secsSince1Jan1970UTC: int) -> None: ...
    def setUtcOffset(self, seconds: int) -> None: ...
    def swap(self, other: QDateTime) -> None: ...
    def time(self) -> QTime: ...
    def timeSpec(self) -> Qt.TimeSpec: ...
    def timeZone(self) -> QTimeZone: ...
    def timeZoneAbbreviation(self) -> str: ...
    def toLocalTime(self) -> QDateTime: ...
    def toMSecsSinceEpoch(self) -> int: ...
    def toOffsetFromUtc(self, offsetSeconds: int) -> QDateTime: ...
    def toPython(self) -> object: ...
    def toSecsSinceEpoch(self) -> int: ...
    @overload
    def toString(self, format: str, cal: QCalendar) -> str: ...
    @overload
    def toString(self, format: Qt.DateFormat = ...) -> str: ...
    @overload
    def toString(self, format: str) -> str: ...
    def toTimeSpec(self, spec: Qt.TimeSpec) -> QDateTime: ...
    def toTimeZone(self, toZone: QTimeZone) -> QDateTime: ...
    def toTime_t(self) -> int: ...
    def toUTC(self) -> QDateTime: ...
    def utcOffset(self) -> int: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QDeadlineTimer(shiboken2.Object):
    class ForeverConstant:
        Forever: typing.ClassVar[QDeadlineTimer.ForeverConstant] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QDeadlineTimer.ForeverConstant: ...
        def __and__(self, other: typing.SupportsInt) -> QDeadlineTimer.ForeverConstant: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QDeadlineTimer.ForeverConstant: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDeadlineTimer.ForeverConstant: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QDeadlineTimer.ForeverConstant: ...
        def __rand__(self, other: typing.SupportsInt) -> QDeadlineTimer.ForeverConstant: ...
        def __rmul__(self, other: typing.SupportsInt) -> QDeadlineTimer.ForeverConstant: ...
        def __ror__(self, other: typing.SupportsInt) -> QDeadlineTimer.ForeverConstant: ...
        def __rsub__(self, other: typing.SupportsInt) -> QDeadlineTimer.ForeverConstant: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDeadlineTimer.ForeverConstant: ...
        def __sub__(self, other: typing.SupportsInt) -> QDeadlineTimer.ForeverConstant: ...
        def __xor__(self, other: typing.SupportsInt) -> QDeadlineTimer.ForeverConstant: ...
    Forever: typing.ClassVar[QDeadlineTimer.ForeverConstant] = ...
    @overload
    def __init__(self, arg__1: QDeadlineTimer.ForeverConstant, type_: Qt.TimerType = ...) -> None: ...
    @overload
    def __init__(self, msecs: int, type: Qt.TimerType = ...) -> None: ...
    @overload
    def __init__(self, QDeadlineTimer: QDeadlineTimer) -> None: ...
    @overload
    def __init__(self, type_: Qt.TimerType = ...) -> None: ...
    def _q_data(self) -> typing.Tuple[int,int]: ...
    @classmethod
    def addNSecs(cls, dt: QDeadlineTimer, nsecs: int) -> QDeadlineTimer: ...
    @classmethod
    def current(cls, timerType: Qt.TimerType = ...) -> QDeadlineTimer: ...
    def deadline(self) -> int: ...
    def deadlineNSecs(self) -> int: ...
    def hasExpired(self) -> bool: ...
    def isForever(self) -> bool: ...
    def remainingTime(self) -> int: ...
    def remainingTimeNSecs(self) -> int: ...
    def setDeadline(self, msecs: int, timerType: Qt.TimerType = ...) -> None: ...
    def setPreciseDeadline(self, secs: int, nsecs: int = ..., type: Qt.TimerType = ...) -> None: ...
    def setPreciseRemainingTime(self, secs: int, nsecs: int = ..., type: Qt.TimerType = ...) -> None: ...
    def setRemainingTime(self, msecs: int, type: Qt.TimerType = ...) -> None: ...
    def setTimerType(self, type: Qt.TimerType) -> None: ...
    def swap(self, other: QDeadlineTimer) -> None: ...
    def timerType(self) -> Qt.TimerType: ...
    def __copy__(self) -> None: ...
    def __iadd__(self, msecs: int) -> QDeadlineTimer: ...
    def __isub__(self, msecs: int) -> QDeadlineTimer: ...

class QDir(shiboken2.Object):
    class Filter:
        AccessMask: typing.ClassVar[QDir.Filter] = ...
        AllDirs: typing.ClassVar[QDir.Filter] = ...
        AllEntries: typing.ClassVar[QDir.Filter] = ...
        CaseSensitive: typing.ClassVar[QDir.Filter] = ...
        Dirs: typing.ClassVar[QDir.Filter] = ...
        Drives: typing.ClassVar[QDir.Filter] = ...
        Executable: typing.ClassVar[QDir.Filter] = ...
        Files: typing.ClassVar[QDir.Filter] = ...
        Hidden: typing.ClassVar[QDir.Filter] = ...
        Modified: typing.ClassVar[QDir.Filter] = ...
        NoDot: typing.ClassVar[QDir.Filter] = ...
        NoDotAndDotDot: typing.ClassVar[QDir.Filter] = ...
        NoDotDot: typing.ClassVar[QDir.Filter] = ...
        NoFilter: typing.ClassVar[QDir.Filter] = ...
        NoSymLinks: typing.ClassVar[QDir.Filter] = ...
        PermissionMask: typing.ClassVar[QDir.Filter] = ...
        Readable: typing.ClassVar[QDir.Filter] = ...
        System: typing.ClassVar[QDir.Filter] = ...
        TypeMask: typing.ClassVar[QDir.Filter] = ...
        Writable: typing.ClassVar[QDir.Filter] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QDir.Filters: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QDir.Filters: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDir.Filters: ...
        def __rand__(self, other: typing.SupportsInt) -> QDir.Filters: ...
        def __ror__(self, other: typing.SupportsInt) -> QDir.Filters: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDir.Filters: ...
        def __xor__(self, other: typing.SupportsInt) -> QDir.Filters: ...

    class Filters:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QDir.Filters: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QDir.Filters: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDir.Filters: ...
        def __rand__(self, other: typing.SupportsInt) -> QDir.Filters: ...
        def __ror__(self, other: typing.SupportsInt) -> QDir.Filters: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDir.Filters: ...
        def __xor__(self, other: typing.SupportsInt) -> QDir.Filters: ...

    class SortFlag:
        DirsFirst: typing.ClassVar[QDir.SortFlag] = ...
        DirsLast: typing.ClassVar[QDir.SortFlag] = ...
        IgnoreCase: typing.ClassVar[QDir.SortFlag] = ...
        LocaleAware: typing.ClassVar[QDir.SortFlag] = ...
        Name: typing.ClassVar[QDir.SortFlag] = ...
        NoSort: typing.ClassVar[QDir.SortFlag] = ...
        Reversed: typing.ClassVar[QDir.SortFlag] = ...
        Size: typing.ClassVar[QDir.SortFlag] = ...
        SortByMask: typing.ClassVar[QDir.SortFlag] = ...
        Time: typing.ClassVar[QDir.SortFlag] = ...
        Type: typing.ClassVar[QDir.SortFlag] = ...
        Unsorted: typing.ClassVar[QDir.SortFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QDir.SortFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QDir.SortFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDir.SortFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QDir.SortFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QDir.SortFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDir.SortFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QDir.SortFlags: ...

    class SortFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QDir.SortFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QDir.SortFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDir.SortFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QDir.SortFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QDir.SortFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDir.SortFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QDir.SortFlags: ...
    AccessMask: typing.ClassVar[QDir.Filter] = ...
    AllDirs: typing.ClassVar[QDir.Filter] = ...
    AllEntries: typing.ClassVar[QDir.Filter] = ...
    CaseSensitive: typing.ClassVar[QDir.Filter] = ...
    Dirs: typing.ClassVar[QDir.Filter] = ...
    DirsFirst: typing.ClassVar[QDir.SortFlag] = ...
    DirsLast: typing.ClassVar[QDir.SortFlag] = ...
    Drives: typing.ClassVar[QDir.Filter] = ...
    Executable: typing.ClassVar[QDir.Filter] = ...
    Files: typing.ClassVar[QDir.Filter] = ...
    Hidden: typing.ClassVar[QDir.Filter] = ...
    IgnoreCase: typing.ClassVar[QDir.SortFlag] = ...
    LocaleAware: typing.ClassVar[QDir.SortFlag] = ...
    Modified: typing.ClassVar[QDir.Filter] = ...
    Name: typing.ClassVar[QDir.SortFlag] = ...
    NoDot: typing.ClassVar[QDir.Filter] = ...
    NoDotAndDotDot: typing.ClassVar[QDir.Filter] = ...
    NoDotDot: typing.ClassVar[QDir.Filter] = ...
    NoFilter: typing.ClassVar[QDir.Filter] = ...
    NoSort: typing.ClassVar[QDir.SortFlag] = ...
    NoSymLinks: typing.ClassVar[QDir.Filter] = ...
    PermissionMask: typing.ClassVar[QDir.Filter] = ...
    Readable: typing.ClassVar[QDir.Filter] = ...
    Reversed: typing.ClassVar[QDir.SortFlag] = ...
    Size: typing.ClassVar[QDir.SortFlag] = ...
    SortByMask: typing.ClassVar[QDir.SortFlag] = ...
    System: typing.ClassVar[QDir.Filter] = ...
    Time: typing.ClassVar[QDir.SortFlag] = ...
    Type: typing.ClassVar[QDir.SortFlag] = ...
    TypeMask: typing.ClassVar[QDir.Filter] = ...
    Unsorted: typing.ClassVar[QDir.SortFlag] = ...
    Writable: typing.ClassVar[QDir.Filter] = ...
    @overload
    def __init__(self, path: str, nameFilter: str, sort: typing.Union[QDir.SortFlags,QDir.SortFlag] = ..., filter: typing.Union[QDir.Filters,QDir.Filter] = ...) -> None: ...
    @overload
    def __init__(self, arg__1: QDir) -> None: ...
    @overload
    def __init__(self, path: str = ...) -> None: ...
    def absoluteFilePath(self, fileName: str) -> str: ...
    def absolutePath(self) -> str: ...
    @classmethod
    def addResourceSearchPath(cls, path: str) -> None: ...
    @classmethod
    def addSearchPath(cls, prefix: str, path: str) -> None: ...
    def canonicalPath(self) -> str: ...
    def cd(self, dirName: str) -> bool: ...
    def cdUp(self) -> bool: ...
    @classmethod
    def cleanPath(cls, path: str) -> str: ...
    def count(self) -> int: ...
    @classmethod
    def current(cls) -> QDir: ...
    @classmethod
    def currentPath(cls) -> str: ...
    def dirName(self) -> str: ...
    @classmethod
    def drives(cls) -> typing.List[QFileInfo]: ...
    @overload
    def entryInfoList(self, nameFilters: typing.Iterable[str], filters: typing.Union[QDir.Filters,QDir.Filter] = ..., sort: typing.Union[QDir.SortFlags,QDir.SortFlag] = ...) -> typing.List[QFileInfo]: ...
    @overload
    def entryInfoList(self, filters: typing.Union[QDir.Filters,QDir.Filter] = ..., sort: typing.Union[QDir.SortFlags,QDir.SortFlag] = ...) -> typing.List[QFileInfo]: ...
    @overload
    def entryList(self, nameFilters: typing.Iterable[str], filters: typing.Union[QDir.Filters,QDir.Filter] = ..., sort: typing.Union[QDir.SortFlags,QDir.SortFlag] = ...) -> typing.List[str]: ...
    @overload
    def entryList(self, filters: typing.Union[QDir.Filters,QDir.Filter] = ..., sort: typing.Union[QDir.SortFlags,QDir.SortFlag] = ...) -> typing.List[str]: ...
    @overload
    def exists(self, name: str) -> bool: ...
    @overload
    def exists(self) -> bool: ...
    def filePath(self, fileName: str) -> str: ...
    def filter(self) -> typing.Union[QDir.Filters,QDir.Filter]: ...
    @classmethod
    def fromNativeSeparators(cls, pathName: str) -> str: ...
    @classmethod
    def home(cls) -> QDir: ...
    @classmethod
    def homePath(cls) -> str: ...
    def isAbsolute(self) -> bool: ...
    @classmethod
    def isAbsolutePath(cls, path: str) -> bool: ...
    def isEmpty(self, filters: typing.Union[QDir.Filters,QDir.Filter] = ...) -> bool: ...
    def isReadable(self) -> bool: ...
    def isRelative(self) -> bool: ...
    @classmethod
    def isRelativePath(cls, path: str) -> bool: ...
    def isRoot(self) -> bool: ...
    @classmethod
    def listSeparator(cls) -> str: ...
    def makeAbsolute(self) -> bool: ...
    @overload
    @classmethod
    def match(cls, filter: str, fileName: str) -> bool: ...
    @overload
    @classmethod
    def match(cls, filters: typing.Iterable[str], fileName: str) -> bool: ...
    def mkdir(self, dirName: str) -> bool: ...
    def mkpath(self, dirPath: str) -> bool: ...
    def nameFilters(self) -> typing.List[str]: ...
    @classmethod
    def nameFiltersFromString(cls, nameFilter: str) -> typing.List[str]: ...
    def path(self) -> str: ...
    def refresh(self) -> None: ...
    def relativeFilePath(self, fileName: str) -> str: ...
    def remove(self, fileName: str) -> bool: ...
    def removeRecursively(self) -> bool: ...
    def rename(self, oldName: str, newName: str) -> bool: ...
    def rmdir(self, dirName: str) -> bool: ...
    def rmpath(self, dirPath: str) -> bool: ...
    @classmethod
    def root(cls) -> QDir: ...
    @classmethod
    def rootPath(cls) -> str: ...
    @classmethod
    def searchPaths(cls, prefix: str) -> typing.List[str]: ...
    @classmethod
    def separator(cls) -> str: ...
    @classmethod
    def setCurrent(cls, path: str) -> bool: ...
    def setFilter(self, filter: typing.Union[QDir.Filters,QDir.Filter]) -> None: ...
    def setNameFilters(self, nameFilters: typing.Iterable[str]) -> None: ...
    def setPath(self, path: str) -> None: ...
    @classmethod
    def setSearchPaths(cls, prefix: str, searchPaths: typing.Iterable[str]) -> None: ...
    def setSorting(self, sort: typing.Union[QDir.SortFlags,QDir.SortFlag]) -> None: ...
    def sorting(self) -> typing.Union[QDir.SortFlags,QDir.SortFlag]: ...
    def swap(self, other: QDir) -> None: ...
    @classmethod
    def temp(cls) -> QDir: ...
    @classmethod
    def tempPath(cls) -> str: ...
    @classmethod
    def toNativeSeparators(cls, pathName: str) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QDirIterator(shiboken2.Object):
    class IteratorFlag:
        FollowSymlinks: typing.ClassVar[QDirIterator.IteratorFlag] = ...
        NoIteratorFlags: typing.ClassVar[QDirIterator.IteratorFlag] = ...
        Subdirectories: typing.ClassVar[QDirIterator.IteratorFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QDirIterator.IteratorFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QDirIterator.IteratorFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDirIterator.IteratorFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QDirIterator.IteratorFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QDirIterator.IteratorFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDirIterator.IteratorFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QDirIterator.IteratorFlags: ...

    class IteratorFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QDirIterator.IteratorFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QDirIterator.IteratorFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QDirIterator.IteratorFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QDirIterator.IteratorFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QDirIterator.IteratorFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QDirIterator.IteratorFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QDirIterator.IteratorFlags: ...
    FollowSymlinks: typing.ClassVar[QDirIterator.IteratorFlag] = ...
    NoIteratorFlags: typing.ClassVar[QDirIterator.IteratorFlag] = ...
    Subdirectories: typing.ClassVar[QDirIterator.IteratorFlag] = ...
    @overload
    def __init__(self, path: str, nameFilters: typing.Iterable[str], filters: typing.Union[QDir.Filters,QDir.Filter] = ..., flags: typing.Union[QDirIterator.IteratorFlags,QDirIterator.IteratorFlag] = ...) -> None: ...
    @overload
    def __init__(self, path: str, filter: typing.Union[QDir.Filters,QDir.Filter], flags: typing.Union[QDirIterator.IteratorFlags,QDirIterator.IteratorFlag] = ...) -> None: ...
    @overload
    def __init__(self, dir: QDir, flags: typing.Union[QDirIterator.IteratorFlags,QDirIterator.IteratorFlag] = ...) -> None: ...
    @overload
    def __init__(self, path: str, flags: typing.Union[QDirIterator.IteratorFlags,QDirIterator.IteratorFlag] = ...) -> None: ...
    def fileInfo(self) -> QFileInfo: ...
    def fileName(self) -> str: ...
    def filePath(self) -> str: ...
    def hasNext(self) -> bool: ...
    def next(self) -> str: ...
    def path(self) -> str: ...

class QDynamicPropertyChangeEvent(QEvent):
    def __init__(self, name: typing.Union[QByteArray,bytes]) -> None: ...
    def propertyName(self) -> QByteArray: ...

class QEasingCurve(shiboken2.Object):
    class Type:
        BezierSpline: typing.ClassVar[QEasingCurve.Type] = ...
        CosineCurve: typing.ClassVar[QEasingCurve.Type] = ...
        Custom: typing.ClassVar[QEasingCurve.Type] = ...
        InBack: typing.ClassVar[QEasingCurve.Type] = ...
        InBounce: typing.ClassVar[QEasingCurve.Type] = ...
        InCirc: typing.ClassVar[QEasingCurve.Type] = ...
        InCubic: typing.ClassVar[QEasingCurve.Type] = ...
        InCurve: typing.ClassVar[QEasingCurve.Type] = ...
        InElastic: typing.ClassVar[QEasingCurve.Type] = ...
        InExpo: typing.ClassVar[QEasingCurve.Type] = ...
        InOutBack: typing.ClassVar[QEasingCurve.Type] = ...
        InOutBounce: typing.ClassVar[QEasingCurve.Type] = ...
        InOutCirc: typing.ClassVar[QEasingCurve.Type] = ...
        InOutCubic: typing.ClassVar[QEasingCurve.Type] = ...
        InOutElastic: typing.ClassVar[QEasingCurve.Type] = ...
        InOutExpo: typing.ClassVar[QEasingCurve.Type] = ...
        InOutQuad: typing.ClassVar[QEasingCurve.Type] = ...
        InOutQuart: typing.ClassVar[QEasingCurve.Type] = ...
        InOutQuint: typing.ClassVar[QEasingCurve.Type] = ...
        InOutSine: typing.ClassVar[QEasingCurve.Type] = ...
        InQuad: typing.ClassVar[QEasingCurve.Type] = ...
        InQuart: typing.ClassVar[QEasingCurve.Type] = ...
        InQuint: typing.ClassVar[QEasingCurve.Type] = ...
        InSine: typing.ClassVar[QEasingCurve.Type] = ...
        Linear: typing.ClassVar[QEasingCurve.Type] = ...
        NCurveTypes: typing.ClassVar[QEasingCurve.Type] = ...
        OutBack: typing.ClassVar[QEasingCurve.Type] = ...
        OutBounce: typing.ClassVar[QEasingCurve.Type] = ...
        OutCirc: typing.ClassVar[QEasingCurve.Type] = ...
        OutCubic: typing.ClassVar[QEasingCurve.Type] = ...
        OutCurve: typing.ClassVar[QEasingCurve.Type] = ...
        OutElastic: typing.ClassVar[QEasingCurve.Type] = ...
        OutExpo: typing.ClassVar[QEasingCurve.Type] = ...
        OutInBack: typing.ClassVar[QEasingCurve.Type] = ...
        OutInBounce: typing.ClassVar[QEasingCurve.Type] = ...
        OutInCirc: typing.ClassVar[QEasingCurve.Type] = ...
        OutInCubic: typing.ClassVar[QEasingCurve.Type] = ...
        OutInElastic: typing.ClassVar[QEasingCurve.Type] = ...
        OutInExpo: typing.ClassVar[QEasingCurve.Type] = ...
        OutInQuad: typing.ClassVar[QEasingCurve.Type] = ...
        OutInQuart: typing.ClassVar[QEasingCurve.Type] = ...
        OutInQuint: typing.ClassVar[QEasingCurve.Type] = ...
        OutInSine: typing.ClassVar[QEasingCurve.Type] = ...
        OutQuad: typing.ClassVar[QEasingCurve.Type] = ...
        OutQuart: typing.ClassVar[QEasingCurve.Type] = ...
        OutQuint: typing.ClassVar[QEasingCurve.Type] = ...
        OutSine: typing.ClassVar[QEasingCurve.Type] = ...
        SineCurve: typing.ClassVar[QEasingCurve.Type] = ...
        TCBSpline: typing.ClassVar[QEasingCurve.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QEasingCurve.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QEasingCurve.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QEasingCurve.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QEasingCurve.Type: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QEasingCurve.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QEasingCurve.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QEasingCurve.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QEasingCurve.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QEasingCurve.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QEasingCurve.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QEasingCurve.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QEasingCurve.Type: ...
    BezierSpline: typing.ClassVar[QEasingCurve.Type] = ...
    CosineCurve: typing.ClassVar[QEasingCurve.Type] = ...
    Custom: typing.ClassVar[QEasingCurve.Type] = ...
    InBack: typing.ClassVar[QEasingCurve.Type] = ...
    InBounce: typing.ClassVar[QEasingCurve.Type] = ...
    InCirc: typing.ClassVar[QEasingCurve.Type] = ...
    InCubic: typing.ClassVar[QEasingCurve.Type] = ...
    InCurve: typing.ClassVar[QEasingCurve.Type] = ...
    InElastic: typing.ClassVar[QEasingCurve.Type] = ...
    InExpo: typing.ClassVar[QEasingCurve.Type] = ...
    InOutBack: typing.ClassVar[QEasingCurve.Type] = ...
    InOutBounce: typing.ClassVar[QEasingCurve.Type] = ...
    InOutCirc: typing.ClassVar[QEasingCurve.Type] = ...
    InOutCubic: typing.ClassVar[QEasingCurve.Type] = ...
    InOutElastic: typing.ClassVar[QEasingCurve.Type] = ...
    InOutExpo: typing.ClassVar[QEasingCurve.Type] = ...
    InOutQuad: typing.ClassVar[QEasingCurve.Type] = ...
    InOutQuart: typing.ClassVar[QEasingCurve.Type] = ...
    InOutQuint: typing.ClassVar[QEasingCurve.Type] = ...
    InOutSine: typing.ClassVar[QEasingCurve.Type] = ...
    InQuad: typing.ClassVar[QEasingCurve.Type] = ...
    InQuart: typing.ClassVar[QEasingCurve.Type] = ...
    InQuint: typing.ClassVar[QEasingCurve.Type] = ...
    InSine: typing.ClassVar[QEasingCurve.Type] = ...
    Linear: typing.ClassVar[QEasingCurve.Type] = ...
    NCurveTypes: typing.ClassVar[QEasingCurve.Type] = ...
    OutBack: typing.ClassVar[QEasingCurve.Type] = ...
    OutBounce: typing.ClassVar[QEasingCurve.Type] = ...
    OutCirc: typing.ClassVar[QEasingCurve.Type] = ...
    OutCubic: typing.ClassVar[QEasingCurve.Type] = ...
    OutCurve: typing.ClassVar[QEasingCurve.Type] = ...
    OutElastic: typing.ClassVar[QEasingCurve.Type] = ...
    OutExpo: typing.ClassVar[QEasingCurve.Type] = ...
    OutInBack: typing.ClassVar[QEasingCurve.Type] = ...
    OutInBounce: typing.ClassVar[QEasingCurve.Type] = ...
    OutInCirc: typing.ClassVar[QEasingCurve.Type] = ...
    OutInCubic: typing.ClassVar[QEasingCurve.Type] = ...
    OutInElastic: typing.ClassVar[QEasingCurve.Type] = ...
    OutInExpo: typing.ClassVar[QEasingCurve.Type] = ...
    OutInQuad: typing.ClassVar[QEasingCurve.Type] = ...
    OutInQuart: typing.ClassVar[QEasingCurve.Type] = ...
    OutInQuint: typing.ClassVar[QEasingCurve.Type] = ...
    OutInSine: typing.ClassVar[QEasingCurve.Type] = ...
    OutQuad: typing.ClassVar[QEasingCurve.Type] = ...
    OutQuart: typing.ClassVar[QEasingCurve.Type] = ...
    OutQuint: typing.ClassVar[QEasingCurve.Type] = ...
    OutSine: typing.ClassVar[QEasingCurve.Type] = ...
    SineCurve: typing.ClassVar[QEasingCurve.Type] = ...
    TCBSpline: typing.ClassVar[QEasingCurve.Type] = ...
    @overload
    def __init__(self, other: typing.Union[QEasingCurve,QEasingCurve.Type]) -> None: ...
    @overload
    def __init__(self, type: QEasingCurve.Type = ...) -> None: ...
    def addCubicBezierSegment(self, c1: QPointF, c2: QPointF, endPoint: QPointF) -> None: ...
    def addTCBSegment(self, nextPoint: QPointF, t: float, c: float, b: float) -> None: ...
    def amplitude(self) -> float: ...
    def customType(self) -> object: ...
    def overshoot(self) -> float: ...
    def period(self) -> float: ...
    def setAmplitude(self, amplitude: float) -> None: ...
    def setCustomType(self, arg__1: object) -> None: ...
    def setOvershoot(self, overshoot: float) -> None: ...
    def setPeriod(self, period: float) -> None: ...
    def setType(self, type: QEasingCurve.Type) -> None: ...
    def swap(self, other: typing.Union[QEasingCurve,QEasingCurve.Type]) -> None: ...
    def toCubicSpline(self) -> typing.List[QPointF]: ...
    def type(self) -> QEasingCurve.Type: ...
    def valueForProgress(self, progress: float) -> float: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QElapsedTimer(shiboken2.Object):
    class ClockType:
        MachAbsoluteTime: typing.ClassVar[QElapsedTimer.ClockType] = ...
        MonotonicClock: typing.ClassVar[QElapsedTimer.ClockType] = ...
        PerformanceCounter: typing.ClassVar[QElapsedTimer.ClockType] = ...
        SystemTime: typing.ClassVar[QElapsedTimer.ClockType] = ...
        TickCounter: typing.ClassVar[QElapsedTimer.ClockType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QElapsedTimer.ClockType: ...
        def __and__(self, other: typing.SupportsInt) -> QElapsedTimer.ClockType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QElapsedTimer.ClockType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QElapsedTimer.ClockType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QElapsedTimer.ClockType: ...
        def __rand__(self, other: typing.SupportsInt) -> QElapsedTimer.ClockType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QElapsedTimer.ClockType: ...
        def __ror__(self, other: typing.SupportsInt) -> QElapsedTimer.ClockType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QElapsedTimer.ClockType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QElapsedTimer.ClockType: ...
        def __sub__(self, other: typing.SupportsInt) -> QElapsedTimer.ClockType: ...
        def __xor__(self, other: typing.SupportsInt) -> QElapsedTimer.ClockType: ...
    MachAbsoluteTime: typing.ClassVar[QElapsedTimer.ClockType] = ...
    MonotonicClock: typing.ClassVar[QElapsedTimer.ClockType] = ...
    PerformanceCounter: typing.ClassVar[QElapsedTimer.ClockType] = ...
    SystemTime: typing.ClassVar[QElapsedTimer.ClockType] = ...
    TickCounter: typing.ClassVar[QElapsedTimer.ClockType] = ...
    @overload
    def __init__(self, QElapsedTimer: QElapsedTimer) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def clockType(cls) -> QElapsedTimer.ClockType: ...
    def elapsed(self) -> int: ...
    def hasExpired(self, timeout: int) -> bool: ...
    def invalidate(self) -> None: ...
    @classmethod
    def isMonotonic(cls) -> bool: ...
    def isValid(self) -> bool: ...
    def msecsSinceReference(self) -> int: ...
    def msecsTo(self, other: QElapsedTimer) -> int: ...
    def nsecsElapsed(self) -> int: ...
    def restart(self) -> int: ...
    def secsTo(self, other: QElapsedTimer) -> int: ...
    def start(self) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QEvent(shiboken2.Object):
    class Type:
        AcceptDropsChange: typing.ClassVar[QEvent.Type] = ...
        ActionAdded: typing.ClassVar[QEvent.Type] = ...
        ActionChanged: typing.ClassVar[QEvent.Type] = ...
        ActionRemoved: typing.ClassVar[QEvent.Type] = ...
        ActivateControl: typing.ClassVar[QEvent.Type] = ...
        ActivationChange: typing.ClassVar[QEvent.Type] = ...
        ApplicationActivate: typing.ClassVar[QEvent.Type] = ...
        ApplicationActivated: typing.ClassVar[QEvent.Type] = ...
        ApplicationDeactivate: typing.ClassVar[QEvent.Type] = ...
        ApplicationDeactivated: typing.ClassVar[QEvent.Type] = ...
        ApplicationFontChange: typing.ClassVar[QEvent.Type] = ...
        ApplicationLayoutDirectionChange: typing.ClassVar[QEvent.Type] = ...
        ApplicationPaletteChange: typing.ClassVar[QEvent.Type] = ...
        ApplicationStateChange: typing.ClassVar[QEvent.Type] = ...
        ApplicationWindowIconChange: typing.ClassVar[QEvent.Type] = ...
        ChildAdded: typing.ClassVar[QEvent.Type] = ...
        ChildPolished: typing.ClassVar[QEvent.Type] = ...
        ChildRemoved: typing.ClassVar[QEvent.Type] = ...
        Clipboard: typing.ClassVar[QEvent.Type] = ...
        Close: typing.ClassVar[QEvent.Type] = ...
        CloseSoftwareInputPanel: typing.ClassVar[QEvent.Type] = ...
        ContentsRectChange: typing.ClassVar[QEvent.Type] = ...
        ContextMenu: typing.ClassVar[QEvent.Type] = ...
        Create: typing.ClassVar[QEvent.Type] = ...
        CursorChange: typing.ClassVar[QEvent.Type] = ...
        DeactivateControl: typing.ClassVar[QEvent.Type] = ...
        DeferredDelete: typing.ClassVar[QEvent.Type] = ...
        Destroy: typing.ClassVar[QEvent.Type] = ...
        DragEnter: typing.ClassVar[QEvent.Type] = ...
        DragLeave: typing.ClassVar[QEvent.Type] = ...
        DragMove: typing.ClassVar[QEvent.Type] = ...
        DragResponse: typing.ClassVar[QEvent.Type] = ...
        Drop: typing.ClassVar[QEvent.Type] = ...
        DynamicPropertyChange: typing.ClassVar[QEvent.Type] = ...
        EmbeddingControl: typing.ClassVar[QEvent.Type] = ...
        EnabledChange: typing.ClassVar[QEvent.Type] = ...
        Enter: typing.ClassVar[QEvent.Type] = ...
        EnterWhatsThisMode: typing.ClassVar[QEvent.Type] = ...
        Expose: typing.ClassVar[QEvent.Type] = ...
        FileOpen: typing.ClassVar[QEvent.Type] = ...
        FocusAboutToChange: typing.ClassVar[QEvent.Type] = ...
        FocusIn: typing.ClassVar[QEvent.Type] = ...
        FocusOut: typing.ClassVar[QEvent.Type] = ...
        FontChange: typing.ClassVar[QEvent.Type] = ...
        FutureCallOut: typing.ClassVar[QEvent.Type] = ...
        Gesture: typing.ClassVar[QEvent.Type] = ...
        GestureOverride: typing.ClassVar[QEvent.Type] = ...
        GrabKeyboard: typing.ClassVar[QEvent.Type] = ...
        GrabMouse: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneContextMenu: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneDragEnter: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneDragLeave: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneDragMove: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneDrop: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneHelp: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneHoverEnter: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneHoverLeave: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneHoverMove: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneMouseDoubleClick: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneMouseMove: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneMousePress: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneMouseRelease: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneMove: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneResize: typing.ClassVar[QEvent.Type] = ...
        GraphicsSceneWheel: typing.ClassVar[QEvent.Type] = ...
        HelpRequest: typing.ClassVar[QEvent.Type] = ...
        Hide: typing.ClassVar[QEvent.Type] = ...
        HideToParent: typing.ClassVar[QEvent.Type] = ...
        HoverEnter: typing.ClassVar[QEvent.Type] = ...
        HoverLeave: typing.ClassVar[QEvent.Type] = ...
        HoverMove: typing.ClassVar[QEvent.Type] = ...
        IconDrag: typing.ClassVar[QEvent.Type] = ...
        IconTextChange: typing.ClassVar[QEvent.Type] = ...
        InputMethod: typing.ClassVar[QEvent.Type] = ...
        InputMethodQuery: typing.ClassVar[QEvent.Type] = ...
        KeyPress: typing.ClassVar[QEvent.Type] = ...
        KeyRelease: typing.ClassVar[QEvent.Type] = ...
        KeyboardLayoutChange: typing.ClassVar[QEvent.Type] = ...
        LanguageChange: typing.ClassVar[QEvent.Type] = ...
        LayoutDirectionChange: typing.ClassVar[QEvent.Type] = ...
        LayoutRequest: typing.ClassVar[QEvent.Type] = ...
        Leave: typing.ClassVar[QEvent.Type] = ...
        LeaveWhatsThisMode: typing.ClassVar[QEvent.Type] = ...
        LocaleChange: typing.ClassVar[QEvent.Type] = ...
        MacGLClearDrawable: typing.ClassVar[QEvent.Type] = ...
        MacGLWindowChange: typing.ClassVar[QEvent.Type] = ...
        MacSizeChange: typing.ClassVar[QEvent.Type] = ...
        MaxUser: typing.ClassVar[QEvent.Type] = ...
        MetaCall: typing.ClassVar[QEvent.Type] = ...
        ModifiedChange: typing.ClassVar[QEvent.Type] = ...
        MouseButtonDblClick: typing.ClassVar[QEvent.Type] = ...
        MouseButtonPress: typing.ClassVar[QEvent.Type] = ...
        MouseButtonRelease: typing.ClassVar[QEvent.Type] = ...
        MouseMove: typing.ClassVar[QEvent.Type] = ...
        MouseTrackingChange: typing.ClassVar[QEvent.Type] = ...
        Move: typing.ClassVar[QEvent.Type] = ...
        NativeGesture: typing.ClassVar[QEvent.Type] = ...
        NetworkReplyUpdated: typing.ClassVar[QEvent.Type] = ...
        NonClientAreaMouseButtonDblClick: typing.ClassVar[QEvent.Type] = ...
        NonClientAreaMouseButtonPress: typing.ClassVar[QEvent.Type] = ...
        NonClientAreaMouseButtonRelease: typing.ClassVar[QEvent.Type] = ...
        NonClientAreaMouseMove: typing.ClassVar[QEvent.Type] = ...
        None_: typing.ClassVar[QEvent.Type] = ...
        OkRequest: typing.ClassVar[QEvent.Type] = ...
        OrientationChange: typing.ClassVar[QEvent.Type] = ...
        Paint: typing.ClassVar[QEvent.Type] = ...
        PaletteChange: typing.ClassVar[QEvent.Type] = ...
        ParentAboutToChange: typing.ClassVar[QEvent.Type] = ...
        ParentChange: typing.ClassVar[QEvent.Type] = ...
        PlatformPanel: typing.ClassVar[QEvent.Type] = ...
        PlatformSurface: typing.ClassVar[QEvent.Type] = ...
        Pointer: typing.ClassVar[QEvent.Type] = ...
        Polish: typing.ClassVar[QEvent.Type] = ...
        PolishRequest: typing.ClassVar[QEvent.Type] = ...
        QueryWhatsThis: typing.ClassVar[QEvent.Type] = ...
        Quit: typing.ClassVar[QEvent.Type] = ...
        ReadOnlyChange: typing.ClassVar[QEvent.Type] = ...
        RequestSoftwareInputPanel: typing.ClassVar[QEvent.Type] = ...
        Resize: typing.ClassVar[QEvent.Type] = ...
        ScreenChangeInternal: typing.ClassVar[QEvent.Type] = ...
        Scroll: typing.ClassVar[QEvent.Type] = ...
        ScrollPrepare: typing.ClassVar[QEvent.Type] = ...
        Shortcut: typing.ClassVar[QEvent.Type] = ...
        ShortcutOverride: typing.ClassVar[QEvent.Type] = ...
        Show: typing.ClassVar[QEvent.Type] = ...
        ShowToParent: typing.ClassVar[QEvent.Type] = ...
        ShowWindowRequest: typing.ClassVar[QEvent.Type] = ...
        SockAct: typing.ClassVar[QEvent.Type] = ...
        SockClose: typing.ClassVar[QEvent.Type] = ...
        Speech: typing.ClassVar[QEvent.Type] = ...
        StateMachineSignal: typing.ClassVar[QEvent.Type] = ...
        StateMachineWrapped: typing.ClassVar[QEvent.Type] = ...
        StatusTip: typing.ClassVar[QEvent.Type] = ...
        Style: typing.ClassVar[QEvent.Type] = ...
        StyleAnimationUpdate: typing.ClassVar[QEvent.Type] = ...
        StyleChange: typing.ClassVar[QEvent.Type] = ...
        TabletEnterProximity: typing.ClassVar[QEvent.Type] = ...
        TabletLeaveProximity: typing.ClassVar[QEvent.Type] = ...
        TabletMove: typing.ClassVar[QEvent.Type] = ...
        TabletPress: typing.ClassVar[QEvent.Type] = ...
        TabletRelease: typing.ClassVar[QEvent.Type] = ...
        TabletTrackingChange: typing.ClassVar[QEvent.Type] = ...
        ThemeChange: typing.ClassVar[QEvent.Type] = ...
        ThreadChange: typing.ClassVar[QEvent.Type] = ...
        Timer: typing.ClassVar[QEvent.Type] = ...
        ToolBarChange: typing.ClassVar[QEvent.Type] = ...
        ToolTip: typing.ClassVar[QEvent.Type] = ...
        ToolTipChange: typing.ClassVar[QEvent.Type] = ...
        TouchBegin: typing.ClassVar[QEvent.Type] = ...
        TouchCancel: typing.ClassVar[QEvent.Type] = ...
        TouchEnd: typing.ClassVar[QEvent.Type] = ...
        TouchUpdate: typing.ClassVar[QEvent.Type] = ...
        UngrabKeyboard: typing.ClassVar[QEvent.Type] = ...
        UngrabMouse: typing.ClassVar[QEvent.Type] = ...
        UpdateLater: typing.ClassVar[QEvent.Type] = ...
        UpdateRequest: typing.ClassVar[QEvent.Type] = ...
        User: typing.ClassVar[QEvent.Type] = ...
        WhatsThis: typing.ClassVar[QEvent.Type] = ...
        WhatsThisClicked: typing.ClassVar[QEvent.Type] = ...
        Wheel: typing.ClassVar[QEvent.Type] = ...
        WinEventAct: typing.ClassVar[QEvent.Type] = ...
        WinIdChange: typing.ClassVar[QEvent.Type] = ...
        WindowActivate: typing.ClassVar[QEvent.Type] = ...
        WindowBlocked: typing.ClassVar[QEvent.Type] = ...
        WindowChangeInternal: typing.ClassVar[QEvent.Type] = ...
        WindowDeactivate: typing.ClassVar[QEvent.Type] = ...
        WindowIconChange: typing.ClassVar[QEvent.Type] = ...
        WindowStateChange: typing.ClassVar[QEvent.Type] = ...
        WindowTitleChange: typing.ClassVar[QEvent.Type] = ...
        WindowUnblocked: typing.ClassVar[QEvent.Type] = ...
        ZOrderChange: typing.ClassVar[QEvent.Type] = ...
        ZeroTimerEvent: typing.ClassVar[QEvent.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QEvent.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QEvent.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QEvent.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QEvent.Type: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QEvent.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QEvent.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QEvent.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QEvent.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QEvent.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QEvent.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QEvent.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QEvent.Type: ...
    AcceptDropsChange: typing.ClassVar[QEvent.Type] = ...
    ActionAdded: typing.ClassVar[QEvent.Type] = ...
    ActionChanged: typing.ClassVar[QEvent.Type] = ...
    ActionRemoved: typing.ClassVar[QEvent.Type] = ...
    ActivateControl: typing.ClassVar[QEvent.Type] = ...
    ActivationChange: typing.ClassVar[QEvent.Type] = ...
    ApplicationActivate: typing.ClassVar[QEvent.Type] = ...
    ApplicationActivated: typing.ClassVar[QEvent.Type] = ...
    ApplicationDeactivate: typing.ClassVar[QEvent.Type] = ...
    ApplicationDeactivated: typing.ClassVar[QEvent.Type] = ...
    ApplicationFontChange: typing.ClassVar[QEvent.Type] = ...
    ApplicationLayoutDirectionChange: typing.ClassVar[QEvent.Type] = ...
    ApplicationPaletteChange: typing.ClassVar[QEvent.Type] = ...
    ApplicationStateChange: typing.ClassVar[QEvent.Type] = ...
    ApplicationWindowIconChange: typing.ClassVar[QEvent.Type] = ...
    ChildAdded: typing.ClassVar[QEvent.Type] = ...
    ChildPolished: typing.ClassVar[QEvent.Type] = ...
    ChildRemoved: typing.ClassVar[QEvent.Type] = ...
    Clipboard: typing.ClassVar[QEvent.Type] = ...
    Close: typing.ClassVar[QEvent.Type] = ...
    CloseSoftwareInputPanel: typing.ClassVar[QEvent.Type] = ...
    ContentsRectChange: typing.ClassVar[QEvent.Type] = ...
    ContextMenu: typing.ClassVar[QEvent.Type] = ...
    Create: typing.ClassVar[QEvent.Type] = ...
    CursorChange: typing.ClassVar[QEvent.Type] = ...
    DeactivateControl: typing.ClassVar[QEvent.Type] = ...
    DeferredDelete: typing.ClassVar[QEvent.Type] = ...
    Destroy: typing.ClassVar[QEvent.Type] = ...
    DragEnter: typing.ClassVar[QEvent.Type] = ...
    DragLeave: typing.ClassVar[QEvent.Type] = ...
    DragMove: typing.ClassVar[QEvent.Type] = ...
    DragResponse: typing.ClassVar[QEvent.Type] = ...
    Drop: typing.ClassVar[QEvent.Type] = ...
    DynamicPropertyChange: typing.ClassVar[QEvent.Type] = ...
    EmbeddingControl: typing.ClassVar[QEvent.Type] = ...
    EnabledChange: typing.ClassVar[QEvent.Type] = ...
    Enter: typing.ClassVar[QEvent.Type] = ...
    EnterWhatsThisMode: typing.ClassVar[QEvent.Type] = ...
    Expose: typing.ClassVar[QEvent.Type] = ...
    FileOpen: typing.ClassVar[QEvent.Type] = ...
    FocusAboutToChange: typing.ClassVar[QEvent.Type] = ...
    FocusIn: typing.ClassVar[QEvent.Type] = ...
    FocusOut: typing.ClassVar[QEvent.Type] = ...
    FontChange: typing.ClassVar[QEvent.Type] = ...
    FutureCallOut: typing.ClassVar[QEvent.Type] = ...
    Gesture: typing.ClassVar[QEvent.Type] = ...
    GestureOverride: typing.ClassVar[QEvent.Type] = ...
    GrabKeyboard: typing.ClassVar[QEvent.Type] = ...
    GrabMouse: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneContextMenu: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneDragEnter: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneDragLeave: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneDragMove: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneDrop: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneHelp: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneHoverEnter: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneHoverLeave: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneHoverMove: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneMouseDoubleClick: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneMouseMove: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneMousePress: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneMouseRelease: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneMove: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneResize: typing.ClassVar[QEvent.Type] = ...
    GraphicsSceneWheel: typing.ClassVar[QEvent.Type] = ...
    HelpRequest: typing.ClassVar[QEvent.Type] = ...
    Hide: typing.ClassVar[QEvent.Type] = ...
    HideToParent: typing.ClassVar[QEvent.Type] = ...
    HoverEnter: typing.ClassVar[QEvent.Type] = ...
    HoverLeave: typing.ClassVar[QEvent.Type] = ...
    HoverMove: typing.ClassVar[QEvent.Type] = ...
    IconDrag: typing.ClassVar[QEvent.Type] = ...
    IconTextChange: typing.ClassVar[QEvent.Type] = ...
    InputMethod: typing.ClassVar[QEvent.Type] = ...
    InputMethodQuery: typing.ClassVar[QEvent.Type] = ...
    KeyPress: typing.ClassVar[QEvent.Type] = ...
    KeyRelease: typing.ClassVar[QEvent.Type] = ...
    KeyboardLayoutChange: typing.ClassVar[QEvent.Type] = ...
    LanguageChange: typing.ClassVar[QEvent.Type] = ...
    LayoutDirectionChange: typing.ClassVar[QEvent.Type] = ...
    LayoutRequest: typing.ClassVar[QEvent.Type] = ...
    Leave: typing.ClassVar[QEvent.Type] = ...
    LeaveWhatsThisMode: typing.ClassVar[QEvent.Type] = ...
    LocaleChange: typing.ClassVar[QEvent.Type] = ...
    MacGLClearDrawable: typing.ClassVar[QEvent.Type] = ...
    MacGLWindowChange: typing.ClassVar[QEvent.Type] = ...
    MacSizeChange: typing.ClassVar[QEvent.Type] = ...
    MaxUser: typing.ClassVar[QEvent.Type] = ...
    MetaCall: typing.ClassVar[QEvent.Type] = ...
    ModifiedChange: typing.ClassVar[QEvent.Type] = ...
    MouseButtonDblClick: typing.ClassVar[QEvent.Type] = ...
    MouseButtonPress: typing.ClassVar[QEvent.Type] = ...
    MouseButtonRelease: typing.ClassVar[QEvent.Type] = ...
    MouseMove: typing.ClassVar[QEvent.Type] = ...
    MouseTrackingChange: typing.ClassVar[QEvent.Type] = ...
    Move: typing.ClassVar[QEvent.Type] = ...
    NativeGesture: typing.ClassVar[QEvent.Type] = ...
    NetworkReplyUpdated: typing.ClassVar[QEvent.Type] = ...
    NonClientAreaMouseButtonDblClick: typing.ClassVar[QEvent.Type] = ...
    NonClientAreaMouseButtonPress: typing.ClassVar[QEvent.Type] = ...
    NonClientAreaMouseButtonRelease: typing.ClassVar[QEvent.Type] = ...
    NonClientAreaMouseMove: typing.ClassVar[QEvent.Type] = ...
    None_: typing.ClassVar[QEvent.Type] = ...
    OkRequest: typing.ClassVar[QEvent.Type] = ...
    OrientationChange: typing.ClassVar[QEvent.Type] = ...
    Paint: typing.ClassVar[QEvent.Type] = ...
    PaletteChange: typing.ClassVar[QEvent.Type] = ...
    ParentAboutToChange: typing.ClassVar[QEvent.Type] = ...
    ParentChange: typing.ClassVar[QEvent.Type] = ...
    PlatformPanel: typing.ClassVar[QEvent.Type] = ...
    PlatformSurface: typing.ClassVar[QEvent.Type] = ...
    Pointer: typing.ClassVar[QEvent.Type] = ...
    Polish: typing.ClassVar[QEvent.Type] = ...
    PolishRequest: typing.ClassVar[QEvent.Type] = ...
    QueryWhatsThis: typing.ClassVar[QEvent.Type] = ...
    Quit: typing.ClassVar[QEvent.Type] = ...
    ReadOnlyChange: typing.ClassVar[QEvent.Type] = ...
    RequestSoftwareInputPanel: typing.ClassVar[QEvent.Type] = ...
    Resize: typing.ClassVar[QEvent.Type] = ...
    ScreenChangeInternal: typing.ClassVar[QEvent.Type] = ...
    Scroll: typing.ClassVar[QEvent.Type] = ...
    ScrollPrepare: typing.ClassVar[QEvent.Type] = ...
    Shortcut: typing.ClassVar[QEvent.Type] = ...
    ShortcutOverride: typing.ClassVar[QEvent.Type] = ...
    Show: typing.ClassVar[QEvent.Type] = ...
    ShowToParent: typing.ClassVar[QEvent.Type] = ...
    ShowWindowRequest: typing.ClassVar[QEvent.Type] = ...
    SockAct: typing.ClassVar[QEvent.Type] = ...
    SockClose: typing.ClassVar[QEvent.Type] = ...
    Speech: typing.ClassVar[QEvent.Type] = ...
    StateMachineSignal: typing.ClassVar[QEvent.Type] = ...
    StateMachineWrapped: typing.ClassVar[QEvent.Type] = ...
    StatusTip: typing.ClassVar[QEvent.Type] = ...
    Style: typing.ClassVar[QEvent.Type] = ...
    StyleAnimationUpdate: typing.ClassVar[QEvent.Type] = ...
    StyleChange: typing.ClassVar[QEvent.Type] = ...
    TabletEnterProximity: typing.ClassVar[QEvent.Type] = ...
    TabletLeaveProximity: typing.ClassVar[QEvent.Type] = ...
    TabletMove: typing.ClassVar[QEvent.Type] = ...
    TabletPress: typing.ClassVar[QEvent.Type] = ...
    TabletRelease: typing.ClassVar[QEvent.Type] = ...
    TabletTrackingChange: typing.ClassVar[QEvent.Type] = ...
    ThemeChange: typing.ClassVar[QEvent.Type] = ...
    ThreadChange: typing.ClassVar[QEvent.Type] = ...
    Timer: typing.ClassVar[QEvent.Type] = ...
    ToolBarChange: typing.ClassVar[QEvent.Type] = ...
    ToolTip: typing.ClassVar[QEvent.Type] = ...
    ToolTipChange: typing.ClassVar[QEvent.Type] = ...
    TouchBegin: typing.ClassVar[QEvent.Type] = ...
    TouchCancel: typing.ClassVar[QEvent.Type] = ...
    TouchEnd: typing.ClassVar[QEvent.Type] = ...
    TouchUpdate: typing.ClassVar[QEvent.Type] = ...
    UngrabKeyboard: typing.ClassVar[QEvent.Type] = ...
    UngrabMouse: typing.ClassVar[QEvent.Type] = ...
    UpdateLater: typing.ClassVar[QEvent.Type] = ...
    UpdateRequest: typing.ClassVar[QEvent.Type] = ...
    User: typing.ClassVar[QEvent.Type] = ...
    WhatsThis: typing.ClassVar[QEvent.Type] = ...
    WhatsThisClicked: typing.ClassVar[QEvent.Type] = ...
    Wheel: typing.ClassVar[QEvent.Type] = ...
    WinEventAct: typing.ClassVar[QEvent.Type] = ...
    WinIdChange: typing.ClassVar[QEvent.Type] = ...
    WindowActivate: typing.ClassVar[QEvent.Type] = ...
    WindowBlocked: typing.ClassVar[QEvent.Type] = ...
    WindowChangeInternal: typing.ClassVar[QEvent.Type] = ...
    WindowDeactivate: typing.ClassVar[QEvent.Type] = ...
    WindowIconChange: typing.ClassVar[QEvent.Type] = ...
    WindowStateChange: typing.ClassVar[QEvent.Type] = ...
    WindowTitleChange: typing.ClassVar[QEvent.Type] = ...
    WindowUnblocked: typing.ClassVar[QEvent.Type] = ...
    ZOrderChange: typing.ClassVar[QEvent.Type] = ...
    ZeroTimerEvent: typing.ClassVar[QEvent.Type] = ...
    @overload
    def __init__(self, other: QEvent) -> None: ...
    @overload
    def __init__(self, type: QEvent.Type) -> None: ...
    def accept(self) -> None: ...
    def ignore(self) -> None: ...
    def isAccepted(self) -> bool: ...
    @classmethod
    def registerEventType(cls, hint: int = ...) -> int: ...
    def setAccepted(self, accepted: bool) -> None: ...
    def spontaneous(self) -> bool: ...
    def type(self) -> QEvent.Type: ...

class QEventLoop(QObject):
    class ProcessEventsFlag:
        AllEvents: typing.ClassVar[QEventLoop.ProcessEventsFlag] = ...
        DialogExec: typing.ClassVar[QEventLoop.ProcessEventsFlag] = ...
        EventLoopExec: typing.ClassVar[QEventLoop.ProcessEventsFlag] = ...
        ExcludeSocketNotifiers: typing.ClassVar[QEventLoop.ProcessEventsFlag] = ...
        ExcludeUserInputEvents: typing.ClassVar[QEventLoop.ProcessEventsFlag] = ...
        WaitForMoreEvents: typing.ClassVar[QEventLoop.ProcessEventsFlag] = ...
        X11ExcludeTimers: typing.ClassVar[QEventLoop.ProcessEventsFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QEventLoop.ProcessEventsFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QEventLoop.ProcessEventsFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QEventLoop.ProcessEventsFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QEventLoop.ProcessEventsFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QEventLoop.ProcessEventsFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QEventLoop.ProcessEventsFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QEventLoop.ProcessEventsFlags: ...

    class ProcessEventsFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QEventLoop.ProcessEventsFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QEventLoop.ProcessEventsFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QEventLoop.ProcessEventsFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QEventLoop.ProcessEventsFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QEventLoop.ProcessEventsFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QEventLoop.ProcessEventsFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QEventLoop.ProcessEventsFlags: ...
    AllEvents: typing.ClassVar[QEventLoop.ProcessEventsFlag] = ...
    DialogExec: typing.ClassVar[QEventLoop.ProcessEventsFlag] = ...
    EventLoopExec: typing.ClassVar[QEventLoop.ProcessEventsFlag] = ...
    ExcludeSocketNotifiers: typing.ClassVar[QEventLoop.ProcessEventsFlag] = ...
    ExcludeUserInputEvents: typing.ClassVar[QEventLoop.ProcessEventsFlag] = ...
    WaitForMoreEvents: typing.ClassVar[QEventLoop.ProcessEventsFlag] = ...
    X11ExcludeTimers: typing.ClassVar[QEventLoop.ProcessEventsFlag] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def event(self, event: QEvent) -> bool: ...
    def exec_(self, flags: typing.Union[QEventLoop.ProcessEventsFlags,QEventLoop.ProcessEventsFlag] = ...) -> int: ...
    def exit(self, returnCode: int = ...) -> None: ...
    def isRunning(self) -> bool: ...
    @overload
    def processEvents(self, flags: typing.Union[QEventLoop.ProcessEventsFlags,QEventLoop.ProcessEventsFlag], maximumTime: int) -> None: ...
    @overload
    def processEvents(self, flags: typing.Union[QEventLoop.ProcessEventsFlags,QEventLoop.ProcessEventsFlag] = ...) -> bool: ...
    def quit(self) -> None: ...
    def wakeUp(self) -> None: ...

class QEventTransition(QAbstractTransition):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, object: QObject, type: QEvent.Type, sourceState: typing.Union[QState,None] = ..., destroyed: typing.Callable = ..., eventSource: QObject = ..., eventType: typing.Any = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., targetState: typing.Any = ..., targetStateChanged: typing.Callable = ..., targetStates: typing.Any = ..., targetStatesChanged: typing.Callable = ..., transitionType: QEventTransition.TransitionType = ..., triggered: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, sourceState: typing.Union[QState,None] = ..., destroyed: typing.Callable = ..., eventSource: QObject = ..., eventType: typing.Any = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., targetState: typing.Any = ..., targetStateChanged: typing.Callable = ..., targetStates: typing.Any = ..., targetStatesChanged: typing.Callable = ..., transitionType: QEventTransition.TransitionType = ..., triggered: typing.Callable = ...) -> None: ...
    def event(self, e: QEvent) -> bool: ...
    def eventSource(self) -> QObject: ...
    def eventTest(self, event: QEvent) -> bool: ...
    def eventType(self) -> QEvent.Type: ...
    def onTransition(self, event: QEvent) -> None: ...
    def setEventSource(self, object: QObject) -> None: ...
    def setEventType(self, type: QEvent.Type) -> None: ...

class QFactoryInterface(shiboken2.Object):
    def __init__(self) -> None: ...
    def keys(self) -> typing.List[str]: ...

class QFile(QFileDevice):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, name: str, parent: typing.Union[QObject,None], aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, name: str, aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QObject,None], aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    def copy(self, newName: str) -> bool: ...
    @overload
    @classmethod
    def decodeName(cls, localFileName: typing.Union[QByteArray,bytes]) -> str: ...
    @overload
    @classmethod
    def decodeName(cls, localFileName: bytes) -> str: ...
    @classmethod
    def encodeName(cls, fileName: str) -> QByteArray: ...
    def exists(self) -> bool: ...
    def fileName(self) -> str: ...
    def link(self, newName: str) -> bool: ...
    def moveToTrash(self) -> bool: ...
    @overload
    def open(self, fd: int, ioFlags: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag], handleFlags: typing.Union[QFileDevice.FileHandleFlags,QFileDevice.FileHandleFlag] = ...) -> bool: ...
    @overload
    def open(self, flags: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag]) -> bool: ...
    def permissions(self) -> typing.Union[QFileDevice.Permissions,QFileDevice.Permission]: ...
    def readLink(self) -> str: ...
    def remove(self) -> bool: ...
    def rename(self, newName: str) -> bool: ...
    def resize(self, sz: int) -> bool: ...
    def setFileName(self, name: str) -> None: ...
    def setPermissions(self, permissionSpec: typing.Union[QFileDevice.Permissions,QFileDevice.Permission]) -> bool: ...
    def size(self) -> int: ...
    def symLinkTarget(self) -> str: ...

class QFileDevice(QIODevice):
    class FileError:
        AbortError: typing.ClassVar[QFileDevice.FileError] = ...
        CopyError: typing.ClassVar[QFileDevice.FileError] = ...
        FatalError: typing.ClassVar[QFileDevice.FileError] = ...
        NoError: typing.ClassVar[QFileDevice.FileError] = ...
        OpenError: typing.ClassVar[QFileDevice.FileError] = ...
        PermissionsError: typing.ClassVar[QFileDevice.FileError] = ...
        PositionError: typing.ClassVar[QFileDevice.FileError] = ...
        ReadError: typing.ClassVar[QFileDevice.FileError] = ...
        RemoveError: typing.ClassVar[QFileDevice.FileError] = ...
        RenameError: typing.ClassVar[QFileDevice.FileError] = ...
        ResizeError: typing.ClassVar[QFileDevice.FileError] = ...
        ResourceError: typing.ClassVar[QFileDevice.FileError] = ...
        TimeOutError: typing.ClassVar[QFileDevice.FileError] = ...
        UnspecifiedError: typing.ClassVar[QFileDevice.FileError] = ...
        WriteError: typing.ClassVar[QFileDevice.FileError] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFileDevice.FileError: ...
        def __and__(self, other: typing.SupportsInt) -> QFileDevice.FileError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFileDevice.FileError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileDevice.FileError: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFileDevice.FileError: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileDevice.FileError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFileDevice.FileError: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileDevice.FileError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFileDevice.FileError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileDevice.FileError: ...
        def __sub__(self, other: typing.SupportsInt) -> QFileDevice.FileError: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileDevice.FileError: ...

    class FileHandleFlag:
        AutoCloseHandle: typing.ClassVar[QFileDevice.FileHandleFlag] = ...
        DontCloseHandle: typing.ClassVar[QFileDevice.FileHandleFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QFileDevice.FileHandleFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QFileDevice.FileHandleFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileDevice.FileHandleFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileDevice.FileHandleFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileDevice.FileHandleFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileDevice.FileHandleFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileDevice.FileHandleFlags: ...

    class FileHandleFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QFileDevice.FileHandleFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QFileDevice.FileHandleFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileDevice.FileHandleFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileDevice.FileHandleFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileDevice.FileHandleFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileDevice.FileHandleFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileDevice.FileHandleFlags: ...

    class FileTime:
        FileAccessTime: typing.ClassVar[QFileDevice.FileTime] = ...
        FileBirthTime: typing.ClassVar[QFileDevice.FileTime] = ...
        FileMetadataChangeTime: typing.ClassVar[QFileDevice.FileTime] = ...
        FileModificationTime: typing.ClassVar[QFileDevice.FileTime] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFileDevice.FileTime: ...
        def __and__(self, other: typing.SupportsInt) -> QFileDevice.FileTime: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFileDevice.FileTime: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileDevice.FileTime: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFileDevice.FileTime: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileDevice.FileTime: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFileDevice.FileTime: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileDevice.FileTime: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFileDevice.FileTime: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileDevice.FileTime: ...
        def __sub__(self, other: typing.SupportsInt) -> QFileDevice.FileTime: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileDevice.FileTime: ...

    class MemoryMapFlags:
        MapPrivateOption: typing.ClassVar[QFileDevice.MemoryMapFlags] = ...
        NoOptions: typing.ClassVar[QFileDevice.MemoryMapFlags] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFileDevice.MemoryMapFlags: ...
        def __and__(self, other: typing.SupportsInt) -> QFileDevice.MemoryMapFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFileDevice.MemoryMapFlags: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileDevice.MemoryMapFlags: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFileDevice.MemoryMapFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileDevice.MemoryMapFlags: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFileDevice.MemoryMapFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileDevice.MemoryMapFlags: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFileDevice.MemoryMapFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileDevice.MemoryMapFlags: ...
        def __sub__(self, other: typing.SupportsInt) -> QFileDevice.MemoryMapFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileDevice.MemoryMapFlags: ...

    class Permission:
        ExeGroup: typing.ClassVar[QFileDevice.Permission] = ...
        ExeOther: typing.ClassVar[QFileDevice.Permission] = ...
        ExeOwner: typing.ClassVar[QFileDevice.Permission] = ...
        ExeUser: typing.ClassVar[QFileDevice.Permission] = ...
        ReadGroup: typing.ClassVar[QFileDevice.Permission] = ...
        ReadOther: typing.ClassVar[QFileDevice.Permission] = ...
        ReadOwner: typing.ClassVar[QFileDevice.Permission] = ...
        ReadUser: typing.ClassVar[QFileDevice.Permission] = ...
        WriteGroup: typing.ClassVar[QFileDevice.Permission] = ...
        WriteOther: typing.ClassVar[QFileDevice.Permission] = ...
        WriteOwner: typing.ClassVar[QFileDevice.Permission] = ...
        WriteUser: typing.ClassVar[QFileDevice.Permission] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QFileDevice.Permissions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QFileDevice.Permissions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileDevice.Permissions: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileDevice.Permissions: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileDevice.Permissions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileDevice.Permissions: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileDevice.Permissions: ...

    class Permissions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QFileDevice.Permissions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QFileDevice.Permissions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFileDevice.Permissions: ...
        def __rand__(self, other: typing.SupportsInt) -> QFileDevice.Permissions: ...
        def __ror__(self, other: typing.SupportsInt) -> QFileDevice.Permissions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFileDevice.Permissions: ...
        def __xor__(self, other: typing.SupportsInt) -> QFileDevice.Permissions: ...
    AbortError: typing.ClassVar[QFileDevice.FileError] = ...
    AutoCloseHandle: typing.ClassVar[QFileDevice.FileHandleFlag] = ...
    CopyError: typing.ClassVar[QFileDevice.FileError] = ...
    DontCloseHandle: typing.ClassVar[QFileDevice.FileHandleFlag] = ...
    ExeGroup: typing.ClassVar[QFileDevice.Permission] = ...
    ExeOther: typing.ClassVar[QFileDevice.Permission] = ...
    ExeOwner: typing.ClassVar[QFileDevice.Permission] = ...
    ExeUser: typing.ClassVar[QFileDevice.Permission] = ...
    FatalError: typing.ClassVar[QFileDevice.FileError] = ...
    FileAccessTime: typing.ClassVar[QFileDevice.FileTime] = ...
    FileBirthTime: typing.ClassVar[QFileDevice.FileTime] = ...
    FileMetadataChangeTime: typing.ClassVar[QFileDevice.FileTime] = ...
    FileModificationTime: typing.ClassVar[QFileDevice.FileTime] = ...
    MapPrivateOption: typing.ClassVar[QFileDevice.MemoryMapFlags] = ...
    NoError: typing.ClassVar[QFileDevice.FileError] = ...
    NoOptions: typing.ClassVar[QFileDevice.MemoryMapFlags] = ...
    OpenError: typing.ClassVar[QFileDevice.FileError] = ...
    PermissionsError: typing.ClassVar[QFileDevice.FileError] = ...
    PositionError: typing.ClassVar[QFileDevice.FileError] = ...
    ReadError: typing.ClassVar[QFileDevice.FileError] = ...
    ReadGroup: typing.ClassVar[QFileDevice.Permission] = ...
    ReadOther: typing.ClassVar[QFileDevice.Permission] = ...
    ReadOwner: typing.ClassVar[QFileDevice.Permission] = ...
    ReadUser: typing.ClassVar[QFileDevice.Permission] = ...
    RemoveError: typing.ClassVar[QFileDevice.FileError] = ...
    RenameError: typing.ClassVar[QFileDevice.FileError] = ...
    ResizeError: typing.ClassVar[QFileDevice.FileError] = ...
    ResourceError: typing.ClassVar[QFileDevice.FileError] = ...
    TimeOutError: typing.ClassVar[QFileDevice.FileError] = ...
    UnspecifiedError: typing.ClassVar[QFileDevice.FileError] = ...
    WriteError: typing.ClassVar[QFileDevice.FileError] = ...
    WriteGroup: typing.ClassVar[QFileDevice.Permission] = ...
    WriteOther: typing.ClassVar[QFileDevice.Permission] = ...
    WriteOwner: typing.ClassVar[QFileDevice.Permission] = ...
    WriteUser: typing.ClassVar[QFileDevice.Permission] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, parent: typing.Union[QObject,None], aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    def atEnd(self) -> bool: ...
    def close(self) -> None: ...
    def error(self) -> QFileDevice.FileError: ...
    def fileName(self) -> str: ...
    def fileTime(self, time: QFileDevice.FileTime) -> QDateTime: ...
    def flush(self) -> bool: ...
    def handle(self) -> int: ...
    def isSequential(self) -> bool: ...
    def map(self, offset: int, size: int, flags: QFileDevice.MemoryMapFlags = ...) -> bytes: ...
    def permissions(self) -> typing.Union[QFileDevice.Permissions,QFileDevice.Permission]: ...
    def pos(self) -> int: ...
    def readData(self, data: bytes, maxlen: int) -> int: ...
    def readLineData(self, data: bytes, maxlen: int) -> int: ...
    def resize(self, sz: int) -> bool: ...
    def seek(self, offset: int) -> bool: ...
    def setFileTime(self, newDate: QDateTime, fileTime: QFileDevice.FileTime) -> bool: ...
    def setPermissions(self, permissionSpec: typing.Union[QFileDevice.Permissions,QFileDevice.Permission]) -> bool: ...
    def size(self) -> int: ...
    def unmap(self, address: bytes) -> bool: ...
    def unsetError(self) -> None: ...
    def writeData(self, data: bytes, len: int) -> int: ...

class QFileInfo(shiboken2.Object):
    @overload
    def __init__(self, dir: QDir, file: str) -> None: ...
    @overload
    def __init__(self, file: QFile) -> None: ...
    @overload
    def __init__(self, file: str) -> None: ...
    @overload
    def __init__(self, fileinfo: QFileInfo) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def absoluteDir(self) -> QDir: ...
    def absoluteFilePath(self) -> str: ...
    def absolutePath(self) -> str: ...
    def baseName(self) -> str: ...
    def birthTime(self) -> QDateTime: ...
    def bundleName(self) -> str: ...
    def caching(self) -> bool: ...
    def canonicalFilePath(self) -> str: ...
    def canonicalPath(self) -> str: ...
    def completeBaseName(self) -> str: ...
    def completeSuffix(self) -> str: ...
    def created(self) -> QDateTime: ...
    def dir(self) -> QDir: ...
    def exists(self) -> bool: ...
    def fileName(self) -> str: ...
    def filePath(self) -> str: ...
    def group(self) -> str: ...
    def groupId(self) -> int: ...
    def isAbsolute(self) -> bool: ...
    def isBundle(self) -> bool: ...
    def isDir(self) -> bool: ...
    def isExecutable(self) -> bool: ...
    def isFile(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def isJunction(self) -> bool: ...
    def isNativePath(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isRelative(self) -> bool: ...
    def isRoot(self) -> bool: ...
    def isShortcut(self) -> bool: ...
    def isSymLink(self) -> bool: ...
    def isSymbolicLink(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def lastModified(self) -> QDateTime: ...
    def lastRead(self) -> QDateTime: ...
    def makeAbsolute(self) -> bool: ...
    def metadataChangeTime(self) -> QDateTime: ...
    def owner(self) -> str: ...
    def ownerId(self) -> int: ...
    def path(self) -> str: ...
    def readLink(self) -> str: ...
    def refresh(self) -> None: ...
    def setCaching(self, on: bool) -> None: ...
    @overload
    def setFile(self, dir: QDir, file: str) -> None: ...
    @overload
    def setFile(self, file: QFile) -> None: ...
    @overload
    def setFile(self, file: str) -> None: ...
    def size(self) -> int: ...
    def suffix(self) -> str: ...
    def swap(self, other: QFileInfo) -> None: ...
    def symLinkTarget(self) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QFileSelector(QObject):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def allSelectors(self) -> typing.List[str]: ...
    def extraSelectors(self) -> typing.List[str]: ...
    @overload
    def select(self, filePath: QUrl) -> QUrl: ...
    @overload
    def select(self, filePath: str) -> str: ...
    def setExtraSelectors(self, list: typing.Iterable[str]) -> None: ...

class QFileSystemWatcher(QObject):
    directoryChanged: typing.ClassVar[Signal] = ...
    fileChanged: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, paths: typing.Iterable[str], parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., directoryChanged: typing.Callable = ..., fileChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., directoryChanged: typing.Callable = ..., fileChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def addPath(self, file: str) -> bool: ...
    def addPaths(self, files: typing.Iterable[str]) -> typing.List[str]: ...
    def directories(self) -> typing.List[str]: ...
    def files(self) -> typing.List[str]: ...
    def removePath(self, file: str) -> bool: ...
    def removePaths(self, files: typing.Iterable[str]) -> typing.List[str]: ...

class QFinalState(QAbstractState):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QState,None] = ..., active: bool = ..., activeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., entered: typing.Callable = ..., exited: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def event(self, e: QEvent) -> bool: ...
    def onEntry(self, event: QEvent) -> None: ...
    def onExit(self, event: QEvent) -> None: ...

class QFutureInterfaceBase(shiboken2.Object):
    class State:
        Canceled: typing.ClassVar[QFutureInterfaceBase.State] = ...
        Finished: typing.ClassVar[QFutureInterfaceBase.State] = ...
        NoState: typing.ClassVar[QFutureInterfaceBase.State] = ...
        Paused: typing.ClassVar[QFutureInterfaceBase.State] = ...
        Running: typing.ClassVar[QFutureInterfaceBase.State] = ...
        Started: typing.ClassVar[QFutureInterfaceBase.State] = ...
        Throttled: typing.ClassVar[QFutureInterfaceBase.State] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QFutureInterfaceBase.State: ...
        def __and__(self, other: typing.SupportsInt) -> QFutureInterfaceBase.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QFutureInterfaceBase.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QFutureInterfaceBase.State: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QFutureInterfaceBase.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QFutureInterfaceBase.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QFutureInterfaceBase.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QFutureInterfaceBase.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QFutureInterfaceBase.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QFutureInterfaceBase.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QFutureInterfaceBase.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QFutureInterfaceBase.State: ...
    Canceled: typing.ClassVar[QFutureInterfaceBase.State] = ...
    Finished: typing.ClassVar[QFutureInterfaceBase.State] = ...
    NoState: typing.ClassVar[QFutureInterfaceBase.State] = ...
    Paused: typing.ClassVar[QFutureInterfaceBase.State] = ...
    Running: typing.ClassVar[QFutureInterfaceBase.State] = ...
    Started: typing.ClassVar[QFutureInterfaceBase.State] = ...
    Throttled: typing.ClassVar[QFutureInterfaceBase.State] = ...
    @overload
    def __init__(self, initialState: QFutureInterfaceBase.State = ...) -> None: ...
    @overload
    def __init__(self, other: QFutureInterfaceBase) -> None: ...
    def cancel(self) -> None: ...
    def derefT(self) -> bool: ...
    def expectedResultCount(self) -> int: ...
    def isCanceled(self) -> bool: ...
    def isFinished(self) -> bool: ...
    def isPaused(self) -> bool: ...
    def isProgressUpdateNeeded(self) -> bool: ...
    def isResultReadyAt(self, index: int) -> bool: ...
    def isRunning(self) -> bool: ...
    def isStarted(self) -> bool: ...
    def isThrottled(self) -> bool: ...
    @overload
    def mutex(self, arg__1: int) -> QMutex: ...
    @overload
    def mutex(self) -> QMutex: ...
    def progressMaximum(self) -> int: ...
    def progressMinimum(self) -> int: ...
    def progressText(self) -> str: ...
    def progressValue(self) -> int: ...
    def queryState(self, state: QFutureInterfaceBase.State) -> bool: ...
    def refT(self) -> bool: ...
    def reportCanceled(self) -> None: ...
    def reportFinished(self) -> None: ...
    def reportResultsReady(self, beginIndex: int, endIndex: int) -> None: ...
    def reportStarted(self) -> None: ...
    def resultCount(self) -> int: ...
    def setExpectedResultCount(self, resultCount: int) -> None: ...
    def setFilterMode(self, enable: bool) -> None: ...
    def setPaused(self, paused: bool) -> None: ...
    def setProgressRange(self, minimum: int, maximum: int) -> None: ...
    def setProgressValue(self, progressValue: int) -> None: ...
    def setProgressValueAndText(self, progressValue: int, progressText: str) -> None: ...
    def setRunnable(self, runnable: QRunnable) -> None: ...
    def setThreadPool(self, pool: QThreadPool) -> None: ...
    def setThrottled(self, enable: bool) -> None: ...
    def togglePaused(self) -> None: ...
    def waitForFinished(self) -> None: ...
    def waitForNextResult(self) -> bool: ...
    def waitForResult(self, resultIndex: int) -> None: ...
    def waitForResume(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QGenericArgument(shiboken2.Object):
    @overload
    def __init__(self, aName: typing.Union[bytes,None] = ..., aData: typing.Union[int,None] = ...) -> None: ...
    @overload
    def __init__(self, QGenericArgument: QGenericArgument) -> None: ...
    def data(self) -> int: ...
    def name(self) -> bytes: ...
    def __copy__(self) -> None: ...

class QGenericReturnArgument(QGenericArgument):
    @overload
    def __init__(self, aName: typing.Union[bytes,None] = ..., aData: typing.Union[int,None] = ...) -> None: ...
    @overload
    def __init__(self, QGenericReturnArgument: QGenericReturnArgument) -> None: ...
    def __copy__(self) -> None: ...

class QHistoryState(QAbstractState):
    class HistoryType:
        DeepHistory: typing.ClassVar[QHistoryState.HistoryType] = ...
        ShallowHistory: typing.ClassVar[QHistoryState.HistoryType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QHistoryState.HistoryType: ...
        def __and__(self, other: typing.SupportsInt) -> QHistoryState.HistoryType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QHistoryState.HistoryType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QHistoryState.HistoryType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QHistoryState.HistoryType: ...
        def __rand__(self, other: typing.SupportsInt) -> QHistoryState.HistoryType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QHistoryState.HistoryType: ...
        def __ror__(self, other: typing.SupportsInt) -> QHistoryState.HistoryType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QHistoryState.HistoryType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QHistoryState.HistoryType: ...
        def __sub__(self, other: typing.SupportsInt) -> QHistoryState.HistoryType: ...
        def __xor__(self, other: typing.SupportsInt) -> QHistoryState.HistoryType: ...
    DeepHistory: typing.ClassVar[QHistoryState.HistoryType] = ...
    ShallowHistory: typing.ClassVar[QHistoryState.HistoryType] = ...
    defaultStateChanged: typing.ClassVar[Signal] = ...
    defaultTransitionChanged: typing.ClassVar[Signal] = ...
    historyTypeChanged: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, type: QHistoryState.HistoryType, parent: typing.Union[QState,None] = ..., active: bool = ..., activeChanged: typing.Callable = ..., defaultState: QAbstractState = ..., defaultStateChanged: typing.Callable = ..., defaultTransition: QAbstractTransition = ..., defaultTransitionChanged: typing.Callable = ..., destroyed: typing.Callable = ..., entered: typing.Callable = ..., exited: typing.Callable = ..., historyType: QHistoryState.HistoryType = ..., historyTypeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QState,None] = ..., active: bool = ..., activeChanged: typing.Callable = ..., defaultState: QAbstractState = ..., defaultStateChanged: typing.Callable = ..., defaultTransition: QAbstractTransition = ..., defaultTransitionChanged: typing.Callable = ..., destroyed: typing.Callable = ..., entered: typing.Callable = ..., exited: typing.Callable = ..., historyType: QHistoryState.HistoryType = ..., historyTypeChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def defaultState(self) -> QAbstractState: ...
    def defaultTransition(self) -> QAbstractTransition: ...
    def event(self, e: QEvent) -> bool: ...
    def historyType(self) -> QHistoryState.HistoryType: ...
    def onEntry(self, event: QEvent) -> None: ...
    def onExit(self, event: QEvent) -> None: ...
    def setDefaultState(self, state: QAbstractState) -> None: ...
    def setDefaultTransition(self, transition: QAbstractTransition) -> None: ...
    def setHistoryType(self, type: QHistoryState.HistoryType) -> None: ...

class QIODevice(QObject):
    class OpenMode:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QIODevice.OpenMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QIODevice.OpenMode: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QIODevice.OpenMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QIODevice.OpenMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QIODevice.OpenMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QIODevice.OpenMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QIODevice.OpenMode: ...

    class OpenModeFlag:
        Append: typing.ClassVar[QIODevice.OpenModeFlag] = ...
        ExistingOnly: typing.ClassVar[QIODevice.OpenModeFlag] = ...
        NewOnly: typing.ClassVar[QIODevice.OpenModeFlag] = ...
        NotOpen: typing.ClassVar[QIODevice.OpenModeFlag] = ...
        ReadOnly: typing.ClassVar[QIODevice.OpenModeFlag] = ...
        ReadWrite: typing.ClassVar[QIODevice.OpenModeFlag] = ...
        Text: typing.ClassVar[QIODevice.OpenModeFlag] = ...
        Truncate: typing.ClassVar[QIODevice.OpenModeFlag] = ...
        Unbuffered: typing.ClassVar[QIODevice.OpenModeFlag] = ...
        WriteOnly: typing.ClassVar[QIODevice.OpenModeFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QIODevice.OpenMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QIODevice.OpenMode: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QIODevice.OpenMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QIODevice.OpenMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QIODevice.OpenMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QIODevice.OpenMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QIODevice.OpenMode: ...
    Append: typing.ClassVar[QIODevice.OpenModeFlag] = ...
    ExistingOnly: typing.ClassVar[QIODevice.OpenModeFlag] = ...
    NewOnly: typing.ClassVar[QIODevice.OpenModeFlag] = ...
    NotOpen: typing.ClassVar[QIODevice.OpenModeFlag] = ...
    ReadOnly: typing.ClassVar[QIODevice.OpenModeFlag] = ...
    ReadWrite: typing.ClassVar[QIODevice.OpenModeFlag] = ...
    Text: typing.ClassVar[QIODevice.OpenModeFlag] = ...
    Truncate: typing.ClassVar[QIODevice.OpenModeFlag] = ...
    Unbuffered: typing.ClassVar[QIODevice.OpenModeFlag] = ...
    WriteOnly: typing.ClassVar[QIODevice.OpenModeFlag] = ...
    aboutToClose: typing.ClassVar[Signal] = ...
    bytesWritten: typing.ClassVar[Signal] = ...
    channelBytesWritten: typing.ClassVar[Signal] = ...
    channelReadyRead: typing.ClassVar[Signal] = ...
    readChannelFinished: typing.ClassVar[Signal] = ...
    readyRead: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, parent: typing.Union[QObject,None], destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def atEnd(self) -> bool: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def close(self) -> None: ...
    def commitTransaction(self) -> None: ...
    def currentReadChannel(self) -> int: ...
    def currentWriteChannel(self) -> int: ...
    def errorString(self) -> str: ...
    def getChar(self, c: bytes) -> bool: ...
    def isOpen(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isSequential(self) -> bool: ...
    def isTextModeEnabled(self) -> bool: ...
    def isTransactionStarted(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def open(self, mode: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag]) -> bool: ...
    def openMode(self) -> typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag]: ...
    def peek(self, maxlen: int) -> QByteArray: ...
    def pos(self) -> int: ...
    def putChar(self, c: int) -> bool: ...
    def read(self, maxlen: int) -> QByteArray: ...
    def readAll(self) -> QByteArray: ...
    def readChannelCount(self) -> int: ...
    def readData(self, data: bytes, maxlen: int) -> int: ...
    def readLine(self, maxlen: int = ...) -> QByteArray: ...
    def readLineData(self, data: bytes, maxlen: int) -> int: ...
    def reset(self) -> bool: ...
    def rollbackTransaction(self) -> None: ...
    def seek(self, pos: int) -> bool: ...
    def setCurrentReadChannel(self, channel: int) -> None: ...
    def setCurrentWriteChannel(self, channel: int) -> None: ...
    def setErrorString(self, errorString: str) -> None: ...
    def setOpenMode(self, openMode: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag]) -> None: ...
    def setTextModeEnabled(self, enabled: bool) -> None: ...
    def size(self) -> int: ...
    def skip(self, maxSize: int) -> int: ...
    def startTransaction(self) -> None: ...
    def ungetChar(self, c: int) -> None: ...
    def waitForBytesWritten(self, msecs: int) -> bool: ...
    def waitForReadyRead(self, msecs: int) -> bool: ...
    def write(self, data: typing.Union[QByteArray,bytes]) -> int: ...
    def writeChannelCount(self) -> int: ...
    def writeData(self, data: bytes, len: int) -> int: ...

class QIdentityProxyModel(QAbstractProxyModel):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ..., sourceModel: typing.Any = ..., sourceModelChanged: typing.Callable = ...) -> None: ...
    def columnCount(self, parent: QModelIndex = ...) -> int: ...
    def dropMimeData(self, data: QMimeData, action: Qt.DropAction, row: int, column: int, parent: QModelIndex) -> bool: ...
    def headerData(self, section: int, orientation: Qt.Orientation, role: Qt.ItemDataRole = ...) -> typing.Any: ...
    def index(self, row: int, column: int, parent: QModelIndex = ...) -> QModelIndex: ...
    def insertColumns(self, column: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def mapFromSource(self, sourceIndex: QModelIndex) -> QModelIndex: ...
    def mapSelectionFromSource(self, selection: QItemSelection) -> QItemSelection: ...
    def mapSelectionToSource(self, selection: QItemSelection) -> QItemSelection: ...
    def mapToSource(self, proxyIndex: QModelIndex) -> QModelIndex: ...
    def match(self, start: QModelIndex, role: Qt.ItemDataRole, value: typing.Any, hits: int = ..., flags: typing.Union[Qt.MatchFlags,Qt.MatchFlag] = ...) -> typing.List[int]: ...
    def moveColumns(self, sourceParent: QModelIndex, sourceColumn: int, count: int, destinationParent: QModelIndex, destinationChild: int) -> bool: ...
    def moveRows(self, sourceParent: QModelIndex, sourceRow: int, count: int, destinationParent: QModelIndex, destinationChild: int) -> bool: ...
    @overload
    def parent(self, child: QModelIndex) -> QModelIndex: ...
    @overload
    def parent(self) -> QObject: ...
    def removeColumns(self, column: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def rowCount(self, parent: QModelIndex = ...) -> int: ...
    def setSourceModel(self, sourceModel: QAbstractItemModel) -> None: ...
    def sibling(self, row: int, column: int, idx: QModelIndex) -> QModelIndex: ...

class QItemSelection(shiboken2.Object):
    @overload
    def __init__(self, topLeft: QModelIndex, bottomRight: QModelIndex) -> None: ...
    @overload
    def __init__(self, QItemSelection: QItemSelection) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def append(self, t: QItemSelectionRange) -> None: ...
    @overload
    def append(self, t: typing.Iterable[QItemSelectionRange]) -> None: ...
    def at(self, i: int) -> QItemSelectionRange: ...
    def back(self) -> QItemSelectionRange: ...
    def clear(self) -> None: ...
    def constFirst(self) -> QItemSelectionRange: ...
    def constLast(self) -> QItemSelectionRange: ...
    def contains(self, index: QModelIndex) -> bool: ...
    @overload
    def count(self, t: QItemSelectionRange) -> int: ...
    @overload
    def count(self) -> int: ...
    def detachShared(self) -> None: ...
    def empty(self) -> bool: ...
    def endsWith(self, t: QItemSelectionRange) -> bool: ...
    def first(self) -> QItemSelectionRange: ...
    @classmethod
    def fromSet(cls, set: typing.Set[QItemSelectionRange]) -> typing.List[QItemSelectionRange]: ...
    @classmethod
    def fromVector(cls, vector: typing.List[QItemSelectionRange]) -> typing.List[QItemSelectionRange]: ...
    def front(self) -> QItemSelectionRange: ...
    def indexOf(self, t: QItemSelectionRange, from_: int = ...) -> int: ...
    def indexes(self) -> typing.List[QModelIndex]: ...
    def insert(self, i: int, t: QItemSelectionRange) -> None: ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other: typing.Iterable[QItemSelectionRange]) -> bool: ...
    def last(self) -> QItemSelectionRange: ...
    def lastIndexOf(self, t: QItemSelectionRange, from_: int = ...) -> int: ...
    def length(self) -> int: ...
    def merge(self, other: QItemSelection, command: typing.Union[QItemSelectionModel.SelectionFlags,QItemSelectionModel.SelectionFlag]) -> None: ...
    def mid(self, pos: int, length: int = ...) -> typing.List[QItemSelectionRange]: ...
    def move(self, from_: int, to: int) -> None: ...
    def pop_back(self) -> None: ...
    def pop_front(self) -> None: ...
    def prepend(self, t: QItemSelectionRange) -> None: ...
    def push_back(self, t: QItemSelectionRange) -> None: ...
    def push_front(self, t: QItemSelectionRange) -> None: ...
    def removeAll(self, t: QItemSelectionRange) -> int: ...
    def removeAt(self, i: int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def removeOne(self, t: QItemSelectionRange) -> bool: ...
    def replace(self, i: int, t: QItemSelectionRange) -> None: ...
    def reserve(self, size: int) -> None: ...
    def select(self, topLeft: QModelIndex, bottomRight: QModelIndex) -> None: ...
    def setSharable(self, sharable: bool) -> None: ...
    def size(self) -> int: ...
    @classmethod
    def split(cls, range: QItemSelectionRange, other: QItemSelectionRange, result: QItemSelection) -> None: ...
    def startsWith(self, t: QItemSelectionRange) -> bool: ...
    @overload
    def swap(self, i: int, j: int) -> None: ...
    @overload
    def swap(self, other: typing.Iterable[QItemSelectionRange]) -> None: ...
    def swapItemsAt(self, i: int, j: int) -> None: ...
    def takeAt(self, i: int) -> QItemSelectionRange: ...
    def takeFirst(self) -> QItemSelectionRange: ...
    def takeLast(self) -> QItemSelectionRange: ...
    def toSet(self) -> typing.Set[QItemSelectionRange]: ...
    def toVector(self) -> typing.List[QItemSelectionRange]: ...
    @overload
    def value(self, i: int, defaultValue: QItemSelectionRange) -> QItemSelectionRange: ...
    @overload
    def value(self, i: int) -> QItemSelectionRange: ...
    def __add__(self, l: typing.Iterable[QItemSelectionRange]) -> typing.List[QItemSelectionRange]: ...
    def __copy__(self) -> None: ...
    def __delitem__(self, other) -> typing.Any: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getitem__(self, index) -> typing.Any: ...
    def __gt__(self, other: object) -> bool: ...
    @overload
    def __iadd__(self, l: typing.Iterable[QItemSelectionRange]) -> typing.List[QItemSelectionRange]: ...
    @overload
    def __iadd__(self, t: QItemSelectionRange) -> typing.List[QItemSelectionRange]: ...
    def __le__(self, other: object) -> bool: ...
    def __len__(self) -> int: ...
    @overload
    def __lshift__(self, l: typing.Iterable[QItemSelectionRange]) -> typing.List[QItemSelectionRange]: ...
    @overload
    def __lshift__(self, t: QItemSelectionRange) -> typing.List[QItemSelectionRange]: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __setitem__(self, index, object) -> None: ...

class QItemSelectionModel(QObject):
    class SelectionFlag:
        Clear: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
        ClearAndSelect: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
        Columns: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
        Current: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
        Deselect: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
        NoUpdate: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
        Rows: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
        Select: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
        SelectCurrent: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
        Toggle: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
        ToggleCurrent: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QItemSelectionModel.SelectionFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QItemSelectionModel.SelectionFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QItemSelectionModel.SelectionFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QItemSelectionModel.SelectionFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QItemSelectionModel.SelectionFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QItemSelectionModel.SelectionFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QItemSelectionModel.SelectionFlags: ...

    class SelectionFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QItemSelectionModel.SelectionFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QItemSelectionModel.SelectionFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QItemSelectionModel.SelectionFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QItemSelectionModel.SelectionFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QItemSelectionModel.SelectionFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QItemSelectionModel.SelectionFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QItemSelectionModel.SelectionFlags: ...
    Clear: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
    ClearAndSelect: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
    Columns: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
    Current: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
    Deselect: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
    NoUpdate: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
    Rows: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
    Select: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
    SelectCurrent: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
    Toggle: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
    ToggleCurrent: typing.ClassVar[QItemSelectionModel.SelectionFlag] = ...
    currentChanged: typing.ClassVar[Signal] = ...
    currentColumnChanged: typing.ClassVar[Signal] = ...
    currentRowChanged: typing.ClassVar[Signal] = ...
    modelChanged: typing.ClassVar[Signal] = ...
    selectionChanged: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, model: QAbstractItemModel, parent: typing.Union[QObject,None], currentChanged: typing.Callable = ..., currentColumnChanged: typing.Callable = ..., currentIndex: QModelIndex = ..., currentRowChanged: typing.Callable = ..., destroyed: typing.Callable = ..., hasSelection: bool = ..., modelChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., selectedIndexes: typing.List[int] = ..., selection: QItemSelection = ..., selectionChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, model: typing.Union[QAbstractItemModel,None] = ..., currentChanged: typing.Callable = ..., currentColumnChanged: typing.Callable = ..., currentIndex: QModelIndex = ..., currentRowChanged: typing.Callable = ..., destroyed: typing.Callable = ..., hasSelection: bool = ..., modelChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., selectedIndexes: typing.List[int] = ..., selection: QItemSelection = ..., selectionChanged: typing.Callable = ...) -> None: ...
    def clear(self) -> None: ...
    def clearCurrentIndex(self) -> None: ...
    def clearSelection(self) -> None: ...
    def columnIntersectsSelection(self, column: int, parent: QModelIndex = ...) -> bool: ...
    def currentIndex(self) -> QModelIndex: ...
    def emitSelectionChanged(self, newSelection: QItemSelection, oldSelection: QItemSelection) -> None: ...
    def hasSelection(self) -> bool: ...
    def isColumnSelected(self, column: int, parent: QModelIndex = ...) -> bool: ...
    def isRowSelected(self, row: int, parent: QModelIndex = ...) -> bool: ...
    def isSelected(self, index: QModelIndex) -> bool: ...
    def model(self) -> QAbstractItemModel: ...
    def reset(self) -> None: ...
    def rowIntersectsSelection(self, row: int, parent: QModelIndex = ...) -> bool: ...
    @overload
    def select(self, index: QModelIndex, command: typing.Union[QItemSelectionModel.SelectionFlags,QItemSelectionModel.SelectionFlag]) -> None: ...
    @overload
    def select(self, selection: QItemSelection, command: typing.Union[QItemSelectionModel.SelectionFlags,QItemSelectionModel.SelectionFlag]) -> None: ...
    def selectedColumns(self, row: int = ...) -> typing.List[QModelIndex]: ...
    def selectedIndexes(self) -> typing.List[QModelIndex]: ...
    def selectedRows(self, column: int = ...) -> typing.List[QModelIndex]: ...
    def selection(self) -> QItemSelection: ...
    def setCurrentIndex(self, index: QModelIndex, command: typing.Union[QItemSelectionModel.SelectionFlags,QItemSelectionModel.SelectionFlag]) -> None: ...
    def setModel(self, model: typing.Union[QAbstractItemModel,None]) -> None: ...

class QItemSelectionRange(shiboken2.Object):
    @overload
    def __init__(self, topL: QModelIndex, bottomR: QModelIndex) -> None: ...
    @overload
    def __init__(self, index: QModelIndex) -> None: ...
    @overload
    def __init__(self, other: QItemSelectionRange) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def bottom(self) -> int: ...
    def bottomRight(self) -> QPersistentModelIndex: ...
    @overload
    def contains(self, row: int, column: int, parentIndex: QModelIndex) -> bool: ...
    @overload
    def contains(self, index: QModelIndex) -> bool: ...
    def height(self) -> int: ...
    def indexes(self) -> typing.List[QModelIndex]: ...
    def intersected(self, other: QItemSelectionRange) -> QItemSelectionRange: ...
    def intersects(self, other: QItemSelectionRange) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isValid(self) -> bool: ...
    def left(self) -> int: ...
    def model(self) -> QAbstractItemModel: ...
    def parent(self) -> QModelIndex: ...
    def right(self) -> int: ...
    def swap(self, other: QItemSelectionRange) -> None: ...
    def top(self) -> int: ...
    def topLeft(self) -> QPersistentModelIndex: ...
    def width(self) -> int: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QJsonArray(shiboken2.Object):
    @overload
    def __init__(self, other: QJsonArray) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def append(self, value: QJsonValue) -> None: ...
    def at(self, i: int) -> QJsonValue: ...
    def contains(self, element: QJsonValue) -> bool: ...
    def count(self) -> int: ...
    def empty(self) -> bool: ...
    def first(self) -> QJsonValue: ...
    @classmethod
    def fromStringList(cls, list: typing.Iterable[str]) -> QJsonArray: ...
    @classmethod
    def fromVariantList(cls, list: typing.Iterable[typing.Any]) -> QJsonArray: ...
    def insert(self, i: int, value: QJsonValue) -> None: ...
    def isEmpty(self) -> bool: ...
    def last(self) -> QJsonValue: ...
    def pop_back(self) -> None: ...
    def pop_front(self) -> None: ...
    def prepend(self, value: QJsonValue) -> None: ...
    def push_back(self, t: QJsonValue) -> None: ...
    def push_front(self, t: QJsonValue) -> None: ...
    def removeAt(self, i: int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def replace(self, i: int, value: QJsonValue) -> None: ...
    def size(self) -> int: ...
    def swap(self, other: QJsonArray) -> None: ...
    def takeAt(self, i: int) -> QJsonValue: ...
    def toVariantList(self) -> typing.List[typing.Any]: ...
    def __add__(self, v: QJsonValue) -> QJsonArray: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, v: QJsonValue) -> QJsonArray: ...
    def __le__(self, other: object) -> bool: ...
    def __lshift__(self, v: QJsonValue) -> QJsonArray: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rlshift__(self, other) -> typing.Any: ...

class QJsonDocument(shiboken2.Object):
    class DataValidation:
        BypassValidation: typing.ClassVar[QJsonDocument.DataValidation] = ...
        Validate: typing.ClassVar[QJsonDocument.DataValidation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QJsonDocument.DataValidation: ...
        def __and__(self, other: typing.SupportsInt) -> QJsonDocument.DataValidation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QJsonDocument.DataValidation: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QJsonDocument.DataValidation: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QJsonDocument.DataValidation: ...
        def __rand__(self, other: typing.SupportsInt) -> QJsonDocument.DataValidation: ...
        def __rmul__(self, other: typing.SupportsInt) -> QJsonDocument.DataValidation: ...
        def __ror__(self, other: typing.SupportsInt) -> QJsonDocument.DataValidation: ...
        def __rsub__(self, other: typing.SupportsInt) -> QJsonDocument.DataValidation: ...
        def __rxor__(self, other: typing.SupportsInt) -> QJsonDocument.DataValidation: ...
        def __sub__(self, other: typing.SupportsInt) -> QJsonDocument.DataValidation: ...
        def __xor__(self, other: typing.SupportsInt) -> QJsonDocument.DataValidation: ...

    class JsonFormat:
        Compact: typing.ClassVar[QJsonDocument.JsonFormat] = ...
        Indented: typing.ClassVar[QJsonDocument.JsonFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QJsonDocument.JsonFormat: ...
        def __and__(self, other: typing.SupportsInt) -> QJsonDocument.JsonFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QJsonDocument.JsonFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QJsonDocument.JsonFormat: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QJsonDocument.JsonFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> QJsonDocument.JsonFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> QJsonDocument.JsonFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> QJsonDocument.JsonFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> QJsonDocument.JsonFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> QJsonDocument.JsonFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> QJsonDocument.JsonFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> QJsonDocument.JsonFormat: ...
    BypassValidation: typing.ClassVar[QJsonDocument.DataValidation] = ...
    Compact: typing.ClassVar[QJsonDocument.JsonFormat] = ...
    Indented: typing.ClassVar[QJsonDocument.JsonFormat] = ...
    Validate: typing.ClassVar[QJsonDocument.DataValidation] = ...
    @overload
    def __init__(self, array: QJsonArray) -> None: ...
    @overload
    def __init__(self, object: typing.Dict[str,QJsonValue]) -> None: ...
    @overload
    def __init__(self, other: QJsonDocument) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def array(self) -> QJsonArray: ...
    @classmethod
    def fromBinaryData(cls, data: typing.Union[QByteArray,bytes], validation: QJsonDocument.DataValidation = ...) -> QJsonDocument: ...
    @classmethod
    def fromJson(cls, json: typing.Union[QByteArray,bytes], error: typing.Union[QJsonParseError,None] = ...) -> QJsonDocument: ...
    @classmethod
    def fromRawData(cls, data: bytes, size: int, validation: QJsonDocument.DataValidation = ...) -> QJsonDocument: ...
    @classmethod
    def fromVariant(cls, variant: typing.Any) -> QJsonDocument: ...
    def isArray(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isObject(self) -> bool: ...
    def object(self) -> typing.Dict[str,QJsonValue]: ...
    def rawData(self) -> typing.Tuple[bytes,int]: ...
    def setArray(self, array: QJsonArray) -> None: ...
    def setObject(self, object: typing.Dict[str,QJsonValue]) -> None: ...
    def swap(self, other: QJsonDocument) -> None: ...
    def toBinaryData(self) -> QByteArray: ...
    @overload
    def toJson(self, format: QJsonDocument.JsonFormat) -> QByteArray: ...
    @overload
    def toJson(self) -> QByteArray: ...
    def toVariant(self) -> typing.Any: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QJsonParseError(shiboken2.Object):
    class ParseError:
        DeepNesting: typing.ClassVar[QJsonParseError.ParseError] = ...
        DocumentTooLarge: typing.ClassVar[QJsonParseError.ParseError] = ...
        GarbageAtEnd: typing.ClassVar[QJsonParseError.ParseError] = ...
        IllegalEscapeSequence: typing.ClassVar[QJsonParseError.ParseError] = ...
        IllegalNumber: typing.ClassVar[QJsonParseError.ParseError] = ...
        IllegalUTF8String: typing.ClassVar[QJsonParseError.ParseError] = ...
        IllegalValue: typing.ClassVar[QJsonParseError.ParseError] = ...
        MissingNameSeparator: typing.ClassVar[QJsonParseError.ParseError] = ...
        MissingObject: typing.ClassVar[QJsonParseError.ParseError] = ...
        MissingValueSeparator: typing.ClassVar[QJsonParseError.ParseError] = ...
        NoError: typing.ClassVar[QJsonParseError.ParseError] = ...
        TerminationByNumber: typing.ClassVar[QJsonParseError.ParseError] = ...
        UnterminatedArray: typing.ClassVar[QJsonParseError.ParseError] = ...
        UnterminatedObject: typing.ClassVar[QJsonParseError.ParseError] = ...
        UnterminatedString: typing.ClassVar[QJsonParseError.ParseError] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QJsonParseError.ParseError: ...
        def __and__(self, other: typing.SupportsInt) -> QJsonParseError.ParseError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QJsonParseError.ParseError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QJsonParseError.ParseError: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QJsonParseError.ParseError: ...
        def __rand__(self, other: typing.SupportsInt) -> QJsonParseError.ParseError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QJsonParseError.ParseError: ...
        def __ror__(self, other: typing.SupportsInt) -> QJsonParseError.ParseError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QJsonParseError.ParseError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QJsonParseError.ParseError: ...
        def __sub__(self, other: typing.SupportsInt) -> QJsonParseError.ParseError: ...
        def __xor__(self, other: typing.SupportsInt) -> QJsonParseError.ParseError: ...
    DeepNesting: typing.ClassVar[QJsonParseError.ParseError] = ...
    DocumentTooLarge: typing.ClassVar[QJsonParseError.ParseError] = ...
    GarbageAtEnd: typing.ClassVar[QJsonParseError.ParseError] = ...
    IllegalEscapeSequence: typing.ClassVar[QJsonParseError.ParseError] = ...
    IllegalNumber: typing.ClassVar[QJsonParseError.ParseError] = ...
    IllegalUTF8String: typing.ClassVar[QJsonParseError.ParseError] = ...
    IllegalValue: typing.ClassVar[QJsonParseError.ParseError] = ...
    MissingNameSeparator: typing.ClassVar[QJsonParseError.ParseError] = ...
    MissingObject: typing.ClassVar[QJsonParseError.ParseError] = ...
    MissingValueSeparator: typing.ClassVar[QJsonParseError.ParseError] = ...
    NoError: typing.ClassVar[QJsonParseError.ParseError] = ...
    TerminationByNumber: typing.ClassVar[QJsonParseError.ParseError] = ...
    UnterminatedArray: typing.ClassVar[QJsonParseError.ParseError] = ...
    UnterminatedObject: typing.ClassVar[QJsonParseError.ParseError] = ...
    UnterminatedString: typing.ClassVar[QJsonParseError.ParseError] = ...
    error: typing.Any
    offset: typing.Any
    @overload
    def __init__(self, QJsonParseError: QJsonParseError) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def errorString(self) -> str: ...
    def __copy__(self) -> None: ...

class QJsonValue(shiboken2.Object):
    class Type:
        Array: typing.ClassVar[QJsonValue.Type] = ...
        Bool: typing.ClassVar[QJsonValue.Type] = ...
        Double: typing.ClassVar[QJsonValue.Type] = ...
        Null: typing.ClassVar[QJsonValue.Type] = ...
        Object: typing.ClassVar[QJsonValue.Type] = ...
        String: typing.ClassVar[QJsonValue.Type] = ...
        Undefined: typing.ClassVar[QJsonValue.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QJsonValue.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QJsonValue.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QJsonValue.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QJsonValue.Type: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QJsonValue.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QJsonValue.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QJsonValue.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QJsonValue.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QJsonValue.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QJsonValue.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QJsonValue.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QJsonValue.Type: ...
    Array: typing.ClassVar[QJsonValue.Type] = ...
    Bool: typing.ClassVar[QJsonValue.Type] = ...
    Double: typing.ClassVar[QJsonValue.Type] = ...
    Null: typing.ClassVar[QJsonValue.Type] = ...
    Object: typing.ClassVar[QJsonValue.Type] = ...
    String: typing.ClassVar[QJsonValue.Type] = ...
    Undefined: typing.ClassVar[QJsonValue.Type] = ...
    @overload
    def __init__(self, a: QJsonArray) -> None: ...
    @overload
    def __init__(self, arg__1: QJsonValue.Type = ...) -> None: ...
    @overload
    def __init__(self, b: bool) -> None: ...
    @overload
    def __init__(self, n: float) -> None: ...
    @overload
    def __init__(self, n: int) -> None: ...
    @overload
    def __init__(self, o: typing.Dict[str,QJsonValue]) -> None: ...
    @overload
    def __init__(self, other: QJsonValue) -> None: ...
    @overload
    def __init__(self, s: str) -> None: ...
    @overload
    def __init__(self, s: bytes) -> None: ...
    @overload
    def __init__(self, v: int) -> None: ...
    @classmethod
    def fromVariant(cls, variant: typing.Any) -> QJsonValue: ...
    def isArray(self) -> bool: ...
    def isBool(self) -> bool: ...
    def isDouble(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isObject(self) -> bool: ...
    def isString(self) -> bool: ...
    def isUndefined(self) -> bool: ...
    def swap(self, other: QJsonValue) -> None: ...
    @overload
    def toArray(self, defaultValue: QJsonArray) -> QJsonArray: ...
    @overload
    def toArray(self) -> QJsonArray: ...
    def toBool(self, defaultValue: bool = ...) -> bool: ...
    def toDouble(self, defaultValue: float = ...) -> float: ...
    def toInt(self, defaultValue: int = ...) -> int: ...
    @overload
    def toObject(self, defaultValue: typing.Dict[str,QJsonValue]) -> typing.Dict[str,QJsonValue]: ...
    @overload
    def toObject(self) -> typing.Dict[str,QJsonValue]: ...
    @overload
    def toString(self, defaultValue: str) -> str: ...
    @overload
    def toString(self) -> str: ...
    def toVariant(self) -> typing.Any: ...
    def type(self) -> QJsonValue.Type: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QLibraryInfo(shiboken2.Object):
    class LibraryLocation:
        ArchDataPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        BinariesPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        DataPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        DocumentationPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        ExamplesPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        HeadersPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        ImportsPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        LibrariesPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        LibraryExecutablesPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        PluginsPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        PrefixPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        Qml2ImportsPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        SettingsPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        TestsPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        TranslationsPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLibraryInfo.LibraryLocation: ...
        def __and__(self, other: typing.SupportsInt) -> QLibraryInfo.LibraryLocation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLibraryInfo.LibraryLocation: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLibraryInfo.LibraryLocation: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLibraryInfo.LibraryLocation: ...
        def __rand__(self, other: typing.SupportsInt) -> QLibraryInfo.LibraryLocation: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLibraryInfo.LibraryLocation: ...
        def __ror__(self, other: typing.SupportsInt) -> QLibraryInfo.LibraryLocation: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLibraryInfo.LibraryLocation: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLibraryInfo.LibraryLocation: ...
        def __sub__(self, other: typing.SupportsInt) -> QLibraryInfo.LibraryLocation: ...
        def __xor__(self, other: typing.SupportsInt) -> QLibraryInfo.LibraryLocation: ...
    ArchDataPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    BinariesPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    DataPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    DocumentationPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    ExamplesPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    HeadersPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    ImportsPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    LibrariesPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    LibraryExecutablesPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    PluginsPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    PrefixPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    Qml2ImportsPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    SettingsPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    TestsPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    TranslationsPath: typing.ClassVar[QLibraryInfo.LibraryLocation] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def build(cls) -> bytes: ...
    @classmethod
    def buildDate(cls) -> QDate: ...
    @classmethod
    def isDebugBuild(cls) -> bool: ...
    @classmethod
    def licensedProducts(cls) -> str: ...
    @classmethod
    def licensee(cls) -> str: ...
    @classmethod
    def location(cls, arg__1: QLibraryInfo.LibraryLocation) -> str: ...
    @classmethod
    def platformPluginArguments(cls, platformName: str) -> typing.List[str]: ...
    @classmethod
    def version(cls) -> QVersionNumber: ...

class QLine(shiboken2.Object):
    @overload
    def __init__(self, x1: int, y1: int, x2: int, y2: int) -> None: ...
    @overload
    def __init__(self, pt1: QPoint, pt2: QPoint) -> None: ...
    @overload
    def __init__(self, QLine: QLine) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def center(self) -> QPoint: ...
    def dx(self) -> int: ...
    def dy(self) -> int: ...
    def isNull(self) -> bool: ...
    def p1(self) -> QPoint: ...
    def p2(self) -> QPoint: ...
    def setLine(self, x1: int, y1: int, x2: int, y2: int) -> None: ...
    def setP1(self, p1: QPoint) -> None: ...
    def setP2(self, p2: QPoint) -> None: ...
    def setPoints(self, p1: QPoint, p2: QPoint) -> None: ...
    def toTuple(self) -> object: ...
    @overload
    def translate(self, dx: int, dy: int) -> None: ...
    @overload
    def translate(self, p: QPoint) -> None: ...
    @overload
    def translated(self, dx: int, dy: int) -> QLine: ...
    @overload
    def translated(self, p: QPoint) -> QLine: ...
    def x1(self) -> int: ...
    def x2(self) -> int: ...
    def y1(self) -> int: ...
    def y2(self) -> int: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QLineF(shiboken2.Object):
    class IntersectType:
        BoundedIntersection: typing.ClassVar[QLineF.IntersectType] = ...
        NoIntersection: typing.ClassVar[QLineF.IntersectType] = ...
        UnboundedIntersection: typing.ClassVar[QLineF.IntersectType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLineF.IntersectType: ...
        def __and__(self, other: typing.SupportsInt) -> QLineF.IntersectType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLineF.IntersectType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLineF.IntersectType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLineF.IntersectType: ...
        def __rand__(self, other: typing.SupportsInt) -> QLineF.IntersectType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLineF.IntersectType: ...
        def __ror__(self, other: typing.SupportsInt) -> QLineF.IntersectType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLineF.IntersectType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLineF.IntersectType: ...
        def __sub__(self, other: typing.SupportsInt) -> QLineF.IntersectType: ...
        def __xor__(self, other: typing.SupportsInt) -> QLineF.IntersectType: ...
    BoundedIntersection: typing.ClassVar[QLineF.IntersectType] = ...
    NoIntersection: typing.ClassVar[QLineF.IntersectType] = ...
    UnboundedIntersection: typing.ClassVar[QLineF.IntersectType] = ...
    @overload
    def __init__(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    @overload
    def __init__(self, pt1: QPointF, pt2: QPointF) -> None: ...
    @overload
    def __init__(self, QLineF: QLineF) -> None: ...
    @overload
    def __init__(self, line: QLine) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def angle(self, l: QLineF) -> float: ...
    @overload
    def angle(self) -> float: ...
    def angleTo(self, l: QLineF) -> float: ...
    def center(self) -> QPointF: ...
    def dx(self) -> float: ...
    def dy(self) -> float: ...
    @classmethod
    def fromPolar(cls, length: float, angle: float) -> QLineF: ...
    def intersect(self, l: QLineF, intersectionPoint: QPointF) -> QLineF.IntersectType: ...
    def intersects(self, l: QLineF, intersectionPoint: QPointF) -> QLineF.IntersectType: ...
    def isNull(self) -> bool: ...
    def length(self) -> float: ...
    def normalVector(self) -> QLineF: ...
    def p1(self) -> QPointF: ...
    def p2(self) -> QPointF: ...
    def pointAt(self, t: float) -> QPointF: ...
    def setAngle(self, angle: float) -> None: ...
    def setLength(self, len: float) -> None: ...
    def setLine(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def setP1(self, p1: QPointF) -> None: ...
    def setP2(self, p2: QPointF) -> None: ...
    def setPoints(self, p1: QPointF, p2: QPointF) -> None: ...
    def toLine(self) -> QLine: ...
    def toTuple(self) -> object: ...
    @overload
    def translate(self, dx: float, dy: float) -> None: ...
    @overload
    def translate(self, p: QPointF) -> None: ...
    @overload
    def translated(self, dx: float, dy: float) -> QLineF: ...
    @overload
    def translated(self, p: QPointF) -> QLineF: ...
    def unitVector(self) -> QLineF: ...
    def x1(self) -> float: ...
    def x2(self) -> float: ...
    def y1(self) -> float: ...
    def y2(self) -> float: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QLocale(shiboken2.Object):
    class Country:
        Afghanistan: typing.ClassVar[QLocale.Country] = ...
        AlandIslands: typing.ClassVar[QLocale.Country] = ...
        Albania: typing.ClassVar[QLocale.Country] = ...
        Algeria: typing.ClassVar[QLocale.Country] = ...
        AmericanSamoa: typing.ClassVar[QLocale.Country] = ...
        Andorra: typing.ClassVar[QLocale.Country] = ...
        Angola: typing.ClassVar[QLocale.Country] = ...
        Anguilla: typing.ClassVar[QLocale.Country] = ...
        Antarctica: typing.ClassVar[QLocale.Country] = ...
        AntiguaAndBarbuda: typing.ClassVar[QLocale.Country] = ...
        AnyCountry: typing.ClassVar[QLocale.Country] = ...
        Argentina: typing.ClassVar[QLocale.Country] = ...
        Armenia: typing.ClassVar[QLocale.Country] = ...
        Aruba: typing.ClassVar[QLocale.Country] = ...
        AscensionIsland: typing.ClassVar[QLocale.Country] = ...
        Australia: typing.ClassVar[QLocale.Country] = ...
        Austria: typing.ClassVar[QLocale.Country] = ...
        Azerbaijan: typing.ClassVar[QLocale.Country] = ...
        Bahamas: typing.ClassVar[QLocale.Country] = ...
        Bahrain: typing.ClassVar[QLocale.Country] = ...
        Bangladesh: typing.ClassVar[QLocale.Country] = ...
        Barbados: typing.ClassVar[QLocale.Country] = ...
        Belarus: typing.ClassVar[QLocale.Country] = ...
        Belgium: typing.ClassVar[QLocale.Country] = ...
        Belize: typing.ClassVar[QLocale.Country] = ...
        Benin: typing.ClassVar[QLocale.Country] = ...
        Bermuda: typing.ClassVar[QLocale.Country] = ...
        Bhutan: typing.ClassVar[QLocale.Country] = ...
        Bolivia: typing.ClassVar[QLocale.Country] = ...
        Bonaire: typing.ClassVar[QLocale.Country] = ...
        BosniaAndHerzegowina: typing.ClassVar[QLocale.Country] = ...
        Botswana: typing.ClassVar[QLocale.Country] = ...
        BouvetIsland: typing.ClassVar[QLocale.Country] = ...
        Brazil: typing.ClassVar[QLocale.Country] = ...
        BritishIndianOceanTerritory: typing.ClassVar[QLocale.Country] = ...
        BritishVirginIslands: typing.ClassVar[QLocale.Country] = ...
        Brunei: typing.ClassVar[QLocale.Country] = ...
        Bulgaria: typing.ClassVar[QLocale.Country] = ...
        BurkinaFaso: typing.ClassVar[QLocale.Country] = ...
        Burundi: typing.ClassVar[QLocale.Country] = ...
        Cambodia: typing.ClassVar[QLocale.Country] = ...
        Cameroon: typing.ClassVar[QLocale.Country] = ...
        Canada: typing.ClassVar[QLocale.Country] = ...
        CanaryIslands: typing.ClassVar[QLocale.Country] = ...
        CapeVerde: typing.ClassVar[QLocale.Country] = ...
        CaymanIslands: typing.ClassVar[QLocale.Country] = ...
        CentralAfricanRepublic: typing.ClassVar[QLocale.Country] = ...
        CeutaAndMelilla: typing.ClassVar[QLocale.Country] = ...
        Chad: typing.ClassVar[QLocale.Country] = ...
        Chile: typing.ClassVar[QLocale.Country] = ...
        China: typing.ClassVar[QLocale.Country] = ...
        ChristmasIsland: typing.ClassVar[QLocale.Country] = ...
        ClippertonIsland: typing.ClassVar[QLocale.Country] = ...
        CocosIslands: typing.ClassVar[QLocale.Country] = ...
        Colombia: typing.ClassVar[QLocale.Country] = ...
        Comoros: typing.ClassVar[QLocale.Country] = ...
        CongoBrazzaville: typing.ClassVar[QLocale.Country] = ...
        CongoKinshasa: typing.ClassVar[QLocale.Country] = ...
        CookIslands: typing.ClassVar[QLocale.Country] = ...
        CostaRica: typing.ClassVar[QLocale.Country] = ...
        Croatia: typing.ClassVar[QLocale.Country] = ...
        Cuba: typing.ClassVar[QLocale.Country] = ...
        CuraSao: typing.ClassVar[QLocale.Country] = ...
        Cyprus: typing.ClassVar[QLocale.Country] = ...
        CzechRepublic: typing.ClassVar[QLocale.Country] = ...
        DemocraticRepublicOfCongo: typing.ClassVar[QLocale.Country] = ...
        DemocraticRepublicOfKorea: typing.ClassVar[QLocale.Country] = ...
        Denmark: typing.ClassVar[QLocale.Country] = ...
        DiegoGarcia: typing.ClassVar[QLocale.Country] = ...
        Djibouti: typing.ClassVar[QLocale.Country] = ...
        Dominica: typing.ClassVar[QLocale.Country] = ...
        DominicanRepublic: typing.ClassVar[QLocale.Country] = ...
        EastTimor: typing.ClassVar[QLocale.Country] = ...
        Ecuador: typing.ClassVar[QLocale.Country] = ...
        Egypt: typing.ClassVar[QLocale.Country] = ...
        ElSalvador: typing.ClassVar[QLocale.Country] = ...
        EquatorialGuinea: typing.ClassVar[QLocale.Country] = ...
        Eritrea: typing.ClassVar[QLocale.Country] = ...
        Estonia: typing.ClassVar[QLocale.Country] = ...
        Ethiopia: typing.ClassVar[QLocale.Country] = ...
        Europe: typing.ClassVar[QLocale.Country] = ...
        EuropeanUnion: typing.ClassVar[QLocale.Country] = ...
        FalklandIslands: typing.ClassVar[QLocale.Country] = ...
        FaroeIslands: typing.ClassVar[QLocale.Country] = ...
        Fiji: typing.ClassVar[QLocale.Country] = ...
        Finland: typing.ClassVar[QLocale.Country] = ...
        France: typing.ClassVar[QLocale.Country] = ...
        FrenchGuiana: typing.ClassVar[QLocale.Country] = ...
        FrenchPolynesia: typing.ClassVar[QLocale.Country] = ...
        FrenchSouthernTerritories: typing.ClassVar[QLocale.Country] = ...
        Gabon: typing.ClassVar[QLocale.Country] = ...
        Gambia: typing.ClassVar[QLocale.Country] = ...
        Georgia: typing.ClassVar[QLocale.Country] = ...
        Germany: typing.ClassVar[QLocale.Country] = ...
        Ghana: typing.ClassVar[QLocale.Country] = ...
        Gibraltar: typing.ClassVar[QLocale.Country] = ...
        Greece: typing.ClassVar[QLocale.Country] = ...
        Greenland: typing.ClassVar[QLocale.Country] = ...
        Grenada: typing.ClassVar[QLocale.Country] = ...
        Guadeloupe: typing.ClassVar[QLocale.Country] = ...
        Guam: typing.ClassVar[QLocale.Country] = ...
        Guatemala: typing.ClassVar[QLocale.Country] = ...
        Guernsey: typing.ClassVar[QLocale.Country] = ...
        Guinea: typing.ClassVar[QLocale.Country] = ...
        GuineaBissau: typing.ClassVar[QLocale.Country] = ...
        Guyana: typing.ClassVar[QLocale.Country] = ...
        Haiti: typing.ClassVar[QLocale.Country] = ...
        HeardAndMcDonaldIslands: typing.ClassVar[QLocale.Country] = ...
        Honduras: typing.ClassVar[QLocale.Country] = ...
        HongKong: typing.ClassVar[QLocale.Country] = ...
        Hungary: typing.ClassVar[QLocale.Country] = ...
        Iceland: typing.ClassVar[QLocale.Country] = ...
        India: typing.ClassVar[QLocale.Country] = ...
        Indonesia: typing.ClassVar[QLocale.Country] = ...
        Iran: typing.ClassVar[QLocale.Country] = ...
        Iraq: typing.ClassVar[QLocale.Country] = ...
        Ireland: typing.ClassVar[QLocale.Country] = ...
        IsleOfMan: typing.ClassVar[QLocale.Country] = ...
        Israel: typing.ClassVar[QLocale.Country] = ...
        Italy: typing.ClassVar[QLocale.Country] = ...
        IvoryCoast: typing.ClassVar[QLocale.Country] = ...
        Jamaica: typing.ClassVar[QLocale.Country] = ...
        Japan: typing.ClassVar[QLocale.Country] = ...
        Jersey: typing.ClassVar[QLocale.Country] = ...
        Jordan: typing.ClassVar[QLocale.Country] = ...
        Kazakhstan: typing.ClassVar[QLocale.Country] = ...
        Kenya: typing.ClassVar[QLocale.Country] = ...
        Kiribati: typing.ClassVar[QLocale.Country] = ...
        Kosovo: typing.ClassVar[QLocale.Country] = ...
        Kuwait: typing.ClassVar[QLocale.Country] = ...
        Kyrgyzstan: typing.ClassVar[QLocale.Country] = ...
        Laos: typing.ClassVar[QLocale.Country] = ...
        LastCountry: typing.ClassVar[QLocale.Country] = ...
        LatinAmerica: typing.ClassVar[QLocale.Country] = ...
        LatinAmericaAndTheCaribbean: typing.ClassVar[QLocale.Country] = ...
        Latvia: typing.ClassVar[QLocale.Country] = ...
        Lebanon: typing.ClassVar[QLocale.Country] = ...
        Lesotho: typing.ClassVar[QLocale.Country] = ...
        Liberia: typing.ClassVar[QLocale.Country] = ...
        Libya: typing.ClassVar[QLocale.Country] = ...
        Liechtenstein: typing.ClassVar[QLocale.Country] = ...
        Lithuania: typing.ClassVar[QLocale.Country] = ...
        Luxembourg: typing.ClassVar[QLocale.Country] = ...
        Macau: typing.ClassVar[QLocale.Country] = ...
        Macedonia: typing.ClassVar[QLocale.Country] = ...
        Madagascar: typing.ClassVar[QLocale.Country] = ...
        Malawi: typing.ClassVar[QLocale.Country] = ...
        Malaysia: typing.ClassVar[QLocale.Country] = ...
        Maldives: typing.ClassVar[QLocale.Country] = ...
        Mali: typing.ClassVar[QLocale.Country] = ...
        Malta: typing.ClassVar[QLocale.Country] = ...
        MarshallIslands: typing.ClassVar[QLocale.Country] = ...
        Martinique: typing.ClassVar[QLocale.Country] = ...
        Mauritania: typing.ClassVar[QLocale.Country] = ...
        Mauritius: typing.ClassVar[QLocale.Country] = ...
        Mayotte: typing.ClassVar[QLocale.Country] = ...
        Mexico: typing.ClassVar[QLocale.Country] = ...
        Micronesia: typing.ClassVar[QLocale.Country] = ...
        Moldova: typing.ClassVar[QLocale.Country] = ...
        Monaco: typing.ClassVar[QLocale.Country] = ...
        Mongolia: typing.ClassVar[QLocale.Country] = ...
        Montenegro: typing.ClassVar[QLocale.Country] = ...
        Montserrat: typing.ClassVar[QLocale.Country] = ...
        Morocco: typing.ClassVar[QLocale.Country] = ...
        Mozambique: typing.ClassVar[QLocale.Country] = ...
        Myanmar: typing.ClassVar[QLocale.Country] = ...
        Namibia: typing.ClassVar[QLocale.Country] = ...
        NauruCountry: typing.ClassVar[QLocale.Country] = ...
        Nepal: typing.ClassVar[QLocale.Country] = ...
        Netherlands: typing.ClassVar[QLocale.Country] = ...
        NewCaledonia: typing.ClassVar[QLocale.Country] = ...
        NewZealand: typing.ClassVar[QLocale.Country] = ...
        Nicaragua: typing.ClassVar[QLocale.Country] = ...
        Niger: typing.ClassVar[QLocale.Country] = ...
        Nigeria: typing.ClassVar[QLocale.Country] = ...
        Niue: typing.ClassVar[QLocale.Country] = ...
        NorfolkIsland: typing.ClassVar[QLocale.Country] = ...
        NorthKorea: typing.ClassVar[QLocale.Country] = ...
        NorthernMarianaIslands: typing.ClassVar[QLocale.Country] = ...
        Norway: typing.ClassVar[QLocale.Country] = ...
        Oman: typing.ClassVar[QLocale.Country] = ...
        OutlyingOceania: typing.ClassVar[QLocale.Country] = ...
        Pakistan: typing.ClassVar[QLocale.Country] = ...
        Palau: typing.ClassVar[QLocale.Country] = ...
        PalestinianTerritories: typing.ClassVar[QLocale.Country] = ...
        Panama: typing.ClassVar[QLocale.Country] = ...
        PapuaNewGuinea: typing.ClassVar[QLocale.Country] = ...
        Paraguay: typing.ClassVar[QLocale.Country] = ...
        PeoplesRepublicOfCongo: typing.ClassVar[QLocale.Country] = ...
        Peru: typing.ClassVar[QLocale.Country] = ...
        Philippines: typing.ClassVar[QLocale.Country] = ...
        Pitcairn: typing.ClassVar[QLocale.Country] = ...
        Poland: typing.ClassVar[QLocale.Country] = ...
        Portugal: typing.ClassVar[QLocale.Country] = ...
        PuertoRico: typing.ClassVar[QLocale.Country] = ...
        Qatar: typing.ClassVar[QLocale.Country] = ...
        RepublicOfKorea: typing.ClassVar[QLocale.Country] = ...
        Reunion: typing.ClassVar[QLocale.Country] = ...
        Romania: typing.ClassVar[QLocale.Country] = ...
        Russia: typing.ClassVar[QLocale.Country] = ...
        RussianFederation: typing.ClassVar[QLocale.Country] = ...
        Rwanda: typing.ClassVar[QLocale.Country] = ...
        SaintBarthelemy: typing.ClassVar[QLocale.Country] = ...
        SaintHelena: typing.ClassVar[QLocale.Country] = ...
        SaintKittsAndNevis: typing.ClassVar[QLocale.Country] = ...
        SaintLucia: typing.ClassVar[QLocale.Country] = ...
        SaintMartin: typing.ClassVar[QLocale.Country] = ...
        SaintPierreAndMiquelon: typing.ClassVar[QLocale.Country] = ...
        SaintVincentAndTheGrenadines: typing.ClassVar[QLocale.Country] = ...
        Samoa: typing.ClassVar[QLocale.Country] = ...
        SanMarino: typing.ClassVar[QLocale.Country] = ...
        SaoTomeAndPrincipe: typing.ClassVar[QLocale.Country] = ...
        SaudiArabia: typing.ClassVar[QLocale.Country] = ...
        Senegal: typing.ClassVar[QLocale.Country] = ...
        Serbia: typing.ClassVar[QLocale.Country] = ...
        Seychelles: typing.ClassVar[QLocale.Country] = ...
        SierraLeone: typing.ClassVar[QLocale.Country] = ...
        Singapore: typing.ClassVar[QLocale.Country] = ...
        SintMaarten: typing.ClassVar[QLocale.Country] = ...
        Slovakia: typing.ClassVar[QLocale.Country] = ...
        Slovenia: typing.ClassVar[QLocale.Country] = ...
        SolomonIslands: typing.ClassVar[QLocale.Country] = ...
        Somalia: typing.ClassVar[QLocale.Country] = ...
        SouthAfrica: typing.ClassVar[QLocale.Country] = ...
        SouthGeorgiaAndTheSouthSandwichIslands: typing.ClassVar[QLocale.Country] = ...
        SouthKorea: typing.ClassVar[QLocale.Country] = ...
        SouthSudan: typing.ClassVar[QLocale.Country] = ...
        Spain: typing.ClassVar[QLocale.Country] = ...
        SriLanka: typing.ClassVar[QLocale.Country] = ...
        Sudan: typing.ClassVar[QLocale.Country] = ...
        Suriname: typing.ClassVar[QLocale.Country] = ...
        SvalbardAndJanMayenIslands: typing.ClassVar[QLocale.Country] = ...
        Swaziland: typing.ClassVar[QLocale.Country] = ...
        Sweden: typing.ClassVar[QLocale.Country] = ...
        Switzerland: typing.ClassVar[QLocale.Country] = ...
        Syria: typing.ClassVar[QLocale.Country] = ...
        SyrianArabRepublic: typing.ClassVar[QLocale.Country] = ...
        Taiwan: typing.ClassVar[QLocale.Country] = ...
        Tajikistan: typing.ClassVar[QLocale.Country] = ...
        Tanzania: typing.ClassVar[QLocale.Country] = ...
        Thailand: typing.ClassVar[QLocale.Country] = ...
        Togo: typing.ClassVar[QLocale.Country] = ...
        Tokelau: typing.ClassVar[QLocale.Country] = ...
        TokelauCountry: typing.ClassVar[QLocale.Country] = ...
        Tonga: typing.ClassVar[QLocale.Country] = ...
        TrinidadAndTobago: typing.ClassVar[QLocale.Country] = ...
        TristanDaCunha: typing.ClassVar[QLocale.Country] = ...
        Tunisia: typing.ClassVar[QLocale.Country] = ...
        Turkey: typing.ClassVar[QLocale.Country] = ...
        Turkmenistan: typing.ClassVar[QLocale.Country] = ...
        TurksAndCaicosIslands: typing.ClassVar[QLocale.Country] = ...
        Tuvalu: typing.ClassVar[QLocale.Country] = ...
        TuvaluCountry: typing.ClassVar[QLocale.Country] = ...
        Uganda: typing.ClassVar[QLocale.Country] = ...
        Ukraine: typing.ClassVar[QLocale.Country] = ...
        UnitedArabEmirates: typing.ClassVar[QLocale.Country] = ...
        UnitedKingdom: typing.ClassVar[QLocale.Country] = ...
        UnitedStates: typing.ClassVar[QLocale.Country] = ...
        UnitedStatesMinorOutlyingIslands: typing.ClassVar[QLocale.Country] = ...
        UnitedStatesVirginIslands: typing.ClassVar[QLocale.Country] = ...
        Uruguay: typing.ClassVar[QLocale.Country] = ...
        Uzbekistan: typing.ClassVar[QLocale.Country] = ...
        Vanuatu: typing.ClassVar[QLocale.Country] = ...
        VaticanCityState: typing.ClassVar[QLocale.Country] = ...
        Venezuela: typing.ClassVar[QLocale.Country] = ...
        Vietnam: typing.ClassVar[QLocale.Country] = ...
        WallisAndFutunaIslands: typing.ClassVar[QLocale.Country] = ...
        WesternSahara: typing.ClassVar[QLocale.Country] = ...
        World: typing.ClassVar[QLocale.Country] = ...
        Yemen: typing.ClassVar[QLocale.Country] = ...
        Zambia: typing.ClassVar[QLocale.Country] = ...
        Zimbabwe: typing.ClassVar[QLocale.Country] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLocale.Country: ...
        def __and__(self, other: typing.SupportsInt) -> QLocale.Country: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLocale.Country: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocale.Country: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLocale.Country: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocale.Country: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLocale.Country: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocale.Country: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLocale.Country: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocale.Country: ...
        def __sub__(self, other: typing.SupportsInt) -> QLocale.Country: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocale.Country: ...

    class CurrencySymbolFormat:
        CurrencyDisplayName: typing.ClassVar[QLocale.CurrencySymbolFormat] = ...
        CurrencyIsoCode: typing.ClassVar[QLocale.CurrencySymbolFormat] = ...
        CurrencySymbol: typing.ClassVar[QLocale.CurrencySymbolFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLocale.CurrencySymbolFormat: ...
        def __and__(self, other: typing.SupportsInt) -> QLocale.CurrencySymbolFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLocale.CurrencySymbolFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocale.CurrencySymbolFormat: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLocale.CurrencySymbolFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocale.CurrencySymbolFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLocale.CurrencySymbolFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocale.CurrencySymbolFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLocale.CurrencySymbolFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocale.CurrencySymbolFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> QLocale.CurrencySymbolFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocale.CurrencySymbolFormat: ...

    class DataSizeFormat:
        DataSizeBase1000: typing.ClassVar[QLocale.DataSizeFormat] = ...
        DataSizeIecFormat: typing.ClassVar[QLocale.DataSizeFormat] = ...
        DataSizeSIFormat: typing.ClassVar[QLocale.DataSizeFormat] = ...
        DataSizeSIQuantifiers: typing.ClassVar[QLocale.DataSizeFormat] = ...
        DataSizeTraditionalFormat: typing.ClassVar[QLocale.DataSizeFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QLocale.DataSizeFormats: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QLocale.DataSizeFormats: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocale.DataSizeFormats: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocale.DataSizeFormats: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocale.DataSizeFormats: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocale.DataSizeFormats: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocale.DataSizeFormats: ...

    class DataSizeFormats:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QLocale.DataSizeFormats: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QLocale.DataSizeFormats: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocale.DataSizeFormats: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocale.DataSizeFormats: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocale.DataSizeFormats: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocale.DataSizeFormats: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocale.DataSizeFormats: ...

    class FloatingPointPrecisionOption:
        FloatingPointShortest: typing.ClassVar[QLocale.FloatingPointPrecisionOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLocale.FloatingPointPrecisionOption: ...
        def __and__(self, other: typing.SupportsInt) -> QLocale.FloatingPointPrecisionOption: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLocale.FloatingPointPrecisionOption: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocale.FloatingPointPrecisionOption: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLocale.FloatingPointPrecisionOption: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocale.FloatingPointPrecisionOption: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLocale.FloatingPointPrecisionOption: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocale.FloatingPointPrecisionOption: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLocale.FloatingPointPrecisionOption: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocale.FloatingPointPrecisionOption: ...
        def __sub__(self, other: typing.SupportsInt) -> QLocale.FloatingPointPrecisionOption: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocale.FloatingPointPrecisionOption: ...

    class FormatType:
        LongFormat: typing.ClassVar[QLocale.FormatType] = ...
        NarrowFormat: typing.ClassVar[QLocale.FormatType] = ...
        ShortFormat: typing.ClassVar[QLocale.FormatType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLocale.FormatType: ...
        def __and__(self, other: typing.SupportsInt) -> QLocale.FormatType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLocale.FormatType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocale.FormatType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLocale.FormatType: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocale.FormatType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLocale.FormatType: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocale.FormatType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLocale.FormatType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocale.FormatType: ...
        def __sub__(self, other: typing.SupportsInt) -> QLocale.FormatType: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocale.FormatType: ...

    class Language:
        Abkhazian: typing.ClassVar[QLocale.Language] = ...
        Afan: typing.ClassVar[QLocale.Language] = ...
        Afar: typing.ClassVar[QLocale.Language] = ...
        Afrikaans: typing.ClassVar[QLocale.Language] = ...
        Aghem: typing.ClassVar[QLocale.Language] = ...
        Ahom: typing.ClassVar[QLocale.Language] = ...
        Akan: typing.ClassVar[QLocale.Language] = ...
        Akkadian: typing.ClassVar[QLocale.Language] = ...
        Akoose: typing.ClassVar[QLocale.Language] = ...
        Albanian: typing.ClassVar[QLocale.Language] = ...
        AmericanSignLanguage: typing.ClassVar[QLocale.Language] = ...
        Amharic: typing.ClassVar[QLocale.Language] = ...
        AncientEgyptian: typing.ClassVar[QLocale.Language] = ...
        AncientGreek: typing.ClassVar[QLocale.Language] = ...
        AncientNorthArabian: typing.ClassVar[QLocale.Language] = ...
        AnyLanguage: typing.ClassVar[QLocale.Language] = ...
        Arabic: typing.ClassVar[QLocale.Language] = ...
        Aragonese: typing.ClassVar[QLocale.Language] = ...
        Aramaic: typing.ClassVar[QLocale.Language] = ...
        ArdhamagadhiPrakrit: typing.ClassVar[QLocale.Language] = ...
        Armenian: typing.ClassVar[QLocale.Language] = ...
        Assamese: typing.ClassVar[QLocale.Language] = ...
        Asturian: typing.ClassVar[QLocale.Language] = ...
        Asu: typing.ClassVar[QLocale.Language] = ...
        Atsam: typing.ClassVar[QLocale.Language] = ...
        Avaric: typing.ClassVar[QLocale.Language] = ...
        Avestan: typing.ClassVar[QLocale.Language] = ...
        Aymara: typing.ClassVar[QLocale.Language] = ...
        Azerbaijani: typing.ClassVar[QLocale.Language] = ...
        Bafia: typing.ClassVar[QLocale.Language] = ...
        Balinese: typing.ClassVar[QLocale.Language] = ...
        Bambara: typing.ClassVar[QLocale.Language] = ...
        Bamun: typing.ClassVar[QLocale.Language] = ...
        Basaa: typing.ClassVar[QLocale.Language] = ...
        Bashkir: typing.ClassVar[QLocale.Language] = ...
        Basque: typing.ClassVar[QLocale.Language] = ...
        Bassa: typing.ClassVar[QLocale.Language] = ...
        BatakToba: typing.ClassVar[QLocale.Language] = ...
        Belarusian: typing.ClassVar[QLocale.Language] = ...
        Bemba: typing.ClassVar[QLocale.Language] = ...
        Bena: typing.ClassVar[QLocale.Language] = ...
        Bengali: typing.ClassVar[QLocale.Language] = ...
        Bhojpuri: typing.ClassVar[QLocale.Language] = ...
        Bhutani: typing.ClassVar[QLocale.Language] = ...
        Bihari: typing.ClassVar[QLocale.Language] = ...
        Bislama: typing.ClassVar[QLocale.Language] = ...
        Blin: typing.ClassVar[QLocale.Language] = ...
        Bodo: typing.ClassVar[QLocale.Language] = ...
        Bosnian: typing.ClassVar[QLocale.Language] = ...
        Breton: typing.ClassVar[QLocale.Language] = ...
        Buginese: typing.ClassVar[QLocale.Language] = ...
        Buhid: typing.ClassVar[QLocale.Language] = ...
        Bulgarian: typing.ClassVar[QLocale.Language] = ...
        Burmese: typing.ClassVar[QLocale.Language] = ...
        Byelorussian: typing.ClassVar[QLocale.Language] = ...
        C: typing.ClassVar[QLocale.Language] = ...
        Cambodian: typing.ClassVar[QLocale.Language] = ...
        Cantonese: typing.ClassVar[QLocale.Language] = ...
        Carian: typing.ClassVar[QLocale.Language] = ...
        Catalan: typing.ClassVar[QLocale.Language] = ...
        Cebuano: typing.ClassVar[QLocale.Language] = ...
        CentralKurdish: typing.ClassVar[QLocale.Language] = ...
        CentralMoroccoTamazight: typing.ClassVar[QLocale.Language] = ...
        Chakma: typing.ClassVar[QLocale.Language] = ...
        Chamorro: typing.ClassVar[QLocale.Language] = ...
        Chechen: typing.ClassVar[QLocale.Language] = ...
        Cherokee: typing.ClassVar[QLocale.Language] = ...
        Chewa: typing.ClassVar[QLocale.Language] = ...
        Chickasaw: typing.ClassVar[QLocale.Language] = ...
        Chiga: typing.ClassVar[QLocale.Language] = ...
        Chinese: typing.ClassVar[QLocale.Language] = ...
        Church: typing.ClassVar[QLocale.Language] = ...
        Chuvash: typing.ClassVar[QLocale.Language] = ...
        ClassicalMandaic: typing.ClassVar[QLocale.Language] = ...
        Colognian: typing.ClassVar[QLocale.Language] = ...
        CongoSwahili: typing.ClassVar[QLocale.Language] = ...
        Coptic: typing.ClassVar[QLocale.Language] = ...
        Cornish: typing.ClassVar[QLocale.Language] = ...
        Corsican: typing.ClassVar[QLocale.Language] = ...
        Cree: typing.ClassVar[QLocale.Language] = ...
        Croatian: typing.ClassVar[QLocale.Language] = ...
        Czech: typing.ClassVar[QLocale.Language] = ...
        Danish: typing.ClassVar[QLocale.Language] = ...
        Divehi: typing.ClassVar[QLocale.Language] = ...
        Dogri: typing.ClassVar[QLocale.Language] = ...
        Duala: typing.ClassVar[QLocale.Language] = ...
        Dutch: typing.ClassVar[QLocale.Language] = ...
        Dzongkha: typing.ClassVar[QLocale.Language] = ...
        EasternCham: typing.ClassVar[QLocale.Language] = ...
        EasternKayah: typing.ClassVar[QLocale.Language] = ...
        Embu: typing.ClassVar[QLocale.Language] = ...
        English: typing.ClassVar[QLocale.Language] = ...
        Erzya: typing.ClassVar[QLocale.Language] = ...
        Esperanto: typing.ClassVar[QLocale.Language] = ...
        Estonian: typing.ClassVar[QLocale.Language] = ...
        Etruscan: typing.ClassVar[QLocale.Language] = ...
        Ewe: typing.ClassVar[QLocale.Language] = ...
        Ewondo: typing.ClassVar[QLocale.Language] = ...
        Faroese: typing.ClassVar[QLocale.Language] = ...
        Fijian: typing.ClassVar[QLocale.Language] = ...
        Filipino: typing.ClassVar[QLocale.Language] = ...
        Finnish: typing.ClassVar[QLocale.Language] = ...
        French: typing.ClassVar[QLocale.Language] = ...
        Frisian: typing.ClassVar[QLocale.Language] = ...
        Friulian: typing.ClassVar[QLocale.Language] = ...
        Fulah: typing.ClassVar[QLocale.Language] = ...
        Ga: typing.ClassVar[QLocale.Language] = ...
        Gaelic: typing.ClassVar[QLocale.Language] = ...
        Galician: typing.ClassVar[QLocale.Language] = ...
        Ganda: typing.ClassVar[QLocale.Language] = ...
        Geez: typing.ClassVar[QLocale.Language] = ...
        Georgian: typing.ClassVar[QLocale.Language] = ...
        German: typing.ClassVar[QLocale.Language] = ...
        Gothic: typing.ClassVar[QLocale.Language] = ...
        Greek: typing.ClassVar[QLocale.Language] = ...
        Greenlandic: typing.ClassVar[QLocale.Language] = ...
        Guarani: typing.ClassVar[QLocale.Language] = ...
        Gujarati: typing.ClassVar[QLocale.Language] = ...
        Gusii: typing.ClassVar[QLocale.Language] = ...
        Haitian: typing.ClassVar[QLocale.Language] = ...
        Hanunoo: typing.ClassVar[QLocale.Language] = ...
        Hausa: typing.ClassVar[QLocale.Language] = ...
        Hawaiian: typing.ClassVar[QLocale.Language] = ...
        Hebrew: typing.ClassVar[QLocale.Language] = ...
        Herero: typing.ClassVar[QLocale.Language] = ...
        HieroglyphicLuwian: typing.ClassVar[QLocale.Language] = ...
        Hindi: typing.ClassVar[QLocale.Language] = ...
        HiriMotu: typing.ClassVar[QLocale.Language] = ...
        HmongNjua: typing.ClassVar[QLocale.Language] = ...
        Ho: typing.ClassVar[QLocale.Language] = ...
        Hungarian: typing.ClassVar[QLocale.Language] = ...
        Icelandic: typing.ClassVar[QLocale.Language] = ...
        Ido: typing.ClassVar[QLocale.Language] = ...
        Igbo: typing.ClassVar[QLocale.Language] = ...
        InariSami: typing.ClassVar[QLocale.Language] = ...
        Indonesian: typing.ClassVar[QLocale.Language] = ...
        Ingush: typing.ClassVar[QLocale.Language] = ...
        Interlingua: typing.ClassVar[QLocale.Language] = ...
        Interlingue: typing.ClassVar[QLocale.Language] = ...
        Inuktitut: typing.ClassVar[QLocale.Language] = ...
        Inupiak: typing.ClassVar[QLocale.Language] = ...
        Irish: typing.ClassVar[QLocale.Language] = ...
        Italian: typing.ClassVar[QLocale.Language] = ...
        Japanese: typing.ClassVar[QLocale.Language] = ...
        Javanese: typing.ClassVar[QLocale.Language] = ...
        Jju: typing.ClassVar[QLocale.Language] = ...
        JolaFonyi: typing.ClassVar[QLocale.Language] = ...
        Kabuverdianu: typing.ClassVar[QLocale.Language] = ...
        Kabyle: typing.ClassVar[QLocale.Language] = ...
        Kako: typing.ClassVar[QLocale.Language] = ...
        Kalenjin: typing.ClassVar[QLocale.Language] = ...
        Kamba: typing.ClassVar[QLocale.Language] = ...
        Kannada: typing.ClassVar[QLocale.Language] = ...
        Kanuri: typing.ClassVar[QLocale.Language] = ...
        Kashmiri: typing.ClassVar[QLocale.Language] = ...
        Kazakh: typing.ClassVar[QLocale.Language] = ...
        Kenyang: typing.ClassVar[QLocale.Language] = ...
        Khmer: typing.ClassVar[QLocale.Language] = ...
        Kiche: typing.ClassVar[QLocale.Language] = ...
        Kikuyu: typing.ClassVar[QLocale.Language] = ...
        Kinyarwanda: typing.ClassVar[QLocale.Language] = ...
        Kirghiz: typing.ClassVar[QLocale.Language] = ...
        Komi: typing.ClassVar[QLocale.Language] = ...
        Kongo: typing.ClassVar[QLocale.Language] = ...
        Konkani: typing.ClassVar[QLocale.Language] = ...
        Korean: typing.ClassVar[QLocale.Language] = ...
        Koro: typing.ClassVar[QLocale.Language] = ...
        KoyraChiini: typing.ClassVar[QLocale.Language] = ...
        KoyraboroSenni: typing.ClassVar[QLocale.Language] = ...
        Kpelle: typing.ClassVar[QLocale.Language] = ...
        Kurdish: typing.ClassVar[QLocale.Language] = ...
        Kurundi: typing.ClassVar[QLocale.Language] = ...
        Kwanyama: typing.ClassVar[QLocale.Language] = ...
        Kwasio: typing.ClassVar[QLocale.Language] = ...
        Lakota: typing.ClassVar[QLocale.Language] = ...
        Langi: typing.ClassVar[QLocale.Language] = ...
        Lao: typing.ClassVar[QLocale.Language] = ...
        LargeFloweryMiao: typing.ClassVar[QLocale.Language] = ...
        LastLanguage: typing.ClassVar[QLocale.Language] = ...
        Latin: typing.ClassVar[QLocale.Language] = ...
        Latvian: typing.ClassVar[QLocale.Language] = ...
        Lepcha: typing.ClassVar[QLocale.Language] = ...
        Lezghian: typing.ClassVar[QLocale.Language] = ...
        Limbu: typing.ClassVar[QLocale.Language] = ...
        Limburgish: typing.ClassVar[QLocale.Language] = ...
        LinearA: typing.ClassVar[QLocale.Language] = ...
        Lingala: typing.ClassVar[QLocale.Language] = ...
        Lisu: typing.ClassVar[QLocale.Language] = ...
        LiteraryChinese: typing.ClassVar[QLocale.Language] = ...
        Lithuanian: typing.ClassVar[QLocale.Language] = ...
        Lojban: typing.ClassVar[QLocale.Language] = ...
        LowGerman: typing.ClassVar[QLocale.Language] = ...
        LowerSorbian: typing.ClassVar[QLocale.Language] = ...
        Lu: typing.ClassVar[QLocale.Language] = ...
        LubaKatanga: typing.ClassVar[QLocale.Language] = ...
        LuleSami: typing.ClassVar[QLocale.Language] = ...
        Luo: typing.ClassVar[QLocale.Language] = ...
        Luxembourgish: typing.ClassVar[QLocale.Language] = ...
        Luyia: typing.ClassVar[QLocale.Language] = ...
        Lycian: typing.ClassVar[QLocale.Language] = ...
        Lydian: typing.ClassVar[QLocale.Language] = ...
        Macedonian: typing.ClassVar[QLocale.Language] = ...
        Machame: typing.ClassVar[QLocale.Language] = ...
        Maithili: typing.ClassVar[QLocale.Language] = ...
        MakhuwaMeetto: typing.ClassVar[QLocale.Language] = ...
        Makonde: typing.ClassVar[QLocale.Language] = ...
        Malagasy: typing.ClassVar[QLocale.Language] = ...
        Malay: typing.ClassVar[QLocale.Language] = ...
        Malayalam: typing.ClassVar[QLocale.Language] = ...
        Maltese: typing.ClassVar[QLocale.Language] = ...
        Mandingo: typing.ClassVar[QLocale.Language] = ...
        ManichaeanMiddlePersian: typing.ClassVar[QLocale.Language] = ...
        Manipuri: typing.ClassVar[QLocale.Language] = ...
        Manx: typing.ClassVar[QLocale.Language] = ...
        Maori: typing.ClassVar[QLocale.Language] = ...
        Mapuche: typing.ClassVar[QLocale.Language] = ...
        Marathi: typing.ClassVar[QLocale.Language] = ...
        Marshallese: typing.ClassVar[QLocale.Language] = ...
        Masai: typing.ClassVar[QLocale.Language] = ...
        Mazanderani: typing.ClassVar[QLocale.Language] = ...
        Mende: typing.ClassVar[QLocale.Language] = ...
        Meroitic: typing.ClassVar[QLocale.Language] = ...
        Meru: typing.ClassVar[QLocale.Language] = ...
        Meta: typing.ClassVar[QLocale.Language] = ...
        Mohawk: typing.ClassVar[QLocale.Language] = ...
        Moldavian: typing.ClassVar[QLocale.Language] = ...
        Mongolian: typing.ClassVar[QLocale.Language] = ...
        Mono: typing.ClassVar[QLocale.Language] = ...
        Morisyen: typing.ClassVar[QLocale.Language] = ...
        Mru: typing.ClassVar[QLocale.Language] = ...
        Mundang: typing.ClassVar[QLocale.Language] = ...
        Muscogee: typing.ClassVar[QLocale.Language] = ...
        Nama: typing.ClassVar[QLocale.Language] = ...
        NauruLanguage: typing.ClassVar[QLocale.Language] = ...
        Navaho: typing.ClassVar[QLocale.Language] = ...
        Ndonga: typing.ClassVar[QLocale.Language] = ...
        Nepali: typing.ClassVar[QLocale.Language] = ...
        Newari: typing.ClassVar[QLocale.Language] = ...
        Ngiemboon: typing.ClassVar[QLocale.Language] = ...
        Ngomba: typing.ClassVar[QLocale.Language] = ...
        NigerianPidgin: typing.ClassVar[QLocale.Language] = ...
        Nko: typing.ClassVar[QLocale.Language] = ...
        NorthNdebele: typing.ClassVar[QLocale.Language] = ...
        NorthernLuri: typing.ClassVar[QLocale.Language] = ...
        NorthernSami: typing.ClassVar[QLocale.Language] = ...
        NorthernSotho: typing.ClassVar[QLocale.Language] = ...
        NorthernThai: typing.ClassVar[QLocale.Language] = ...
        Norwegian: typing.ClassVar[QLocale.Language] = ...
        NorwegianBokmal: typing.ClassVar[QLocale.Language] = ...
        NorwegianNynorsk: typing.ClassVar[QLocale.Language] = ...
        Nuer: typing.ClassVar[QLocale.Language] = ...
        Nyanja: typing.ClassVar[QLocale.Language] = ...
        Nyankole: typing.ClassVar[QLocale.Language] = ...
        Occitan: typing.ClassVar[QLocale.Language] = ...
        Ojibwa: typing.ClassVar[QLocale.Language] = ...
        OldIrish: typing.ClassVar[QLocale.Language] = ...
        OldNorse: typing.ClassVar[QLocale.Language] = ...
        OldPersian: typing.ClassVar[QLocale.Language] = ...
        OldTurkish: typing.ClassVar[QLocale.Language] = ...
        Oriya: typing.ClassVar[QLocale.Language] = ...
        Oromo: typing.ClassVar[QLocale.Language] = ...
        Osage: typing.ClassVar[QLocale.Language] = ...
        Ossetic: typing.ClassVar[QLocale.Language] = ...
        Pahlavi: typing.ClassVar[QLocale.Language] = ...
        Palauan: typing.ClassVar[QLocale.Language] = ...
        Pali: typing.ClassVar[QLocale.Language] = ...
        Papiamento: typing.ClassVar[QLocale.Language] = ...
        Parthian: typing.ClassVar[QLocale.Language] = ...
        Pashto: typing.ClassVar[QLocale.Language] = ...
        Persian: typing.ClassVar[QLocale.Language] = ...
        Phoenician: typing.ClassVar[QLocale.Language] = ...
        Polish: typing.ClassVar[QLocale.Language] = ...
        Portuguese: typing.ClassVar[QLocale.Language] = ...
        PrakritLanguage: typing.ClassVar[QLocale.Language] = ...
        Prussian: typing.ClassVar[QLocale.Language] = ...
        Punjabi: typing.ClassVar[QLocale.Language] = ...
        Quechua: typing.ClassVar[QLocale.Language] = ...
        Rejang: typing.ClassVar[QLocale.Language] = ...
        RhaetoRomance: typing.ClassVar[QLocale.Language] = ...
        Romanian: typing.ClassVar[QLocale.Language] = ...
        Romansh: typing.ClassVar[QLocale.Language] = ...
        Rombo: typing.ClassVar[QLocale.Language] = ...
        Rundi: typing.ClassVar[QLocale.Language] = ...
        Russian: typing.ClassVar[QLocale.Language] = ...
        Rwa: typing.ClassVar[QLocale.Language] = ...
        Sabaean: typing.ClassVar[QLocale.Language] = ...
        Saho: typing.ClassVar[QLocale.Language] = ...
        Sakha: typing.ClassVar[QLocale.Language] = ...
        Samaritan: typing.ClassVar[QLocale.Language] = ...
        Samburu: typing.ClassVar[QLocale.Language] = ...
        Samoan: typing.ClassVar[QLocale.Language] = ...
        Sango: typing.ClassVar[QLocale.Language] = ...
        Sangu: typing.ClassVar[QLocale.Language] = ...
        Sanskrit: typing.ClassVar[QLocale.Language] = ...
        Santali: typing.ClassVar[QLocale.Language] = ...
        Saraiki: typing.ClassVar[QLocale.Language] = ...
        Sardinian: typing.ClassVar[QLocale.Language] = ...
        Saurashtra: typing.ClassVar[QLocale.Language] = ...
        Sena: typing.ClassVar[QLocale.Language] = ...
        Serbian: typing.ClassVar[QLocale.Language] = ...
        SerboCroatian: typing.ClassVar[QLocale.Language] = ...
        Shambala: typing.ClassVar[QLocale.Language] = ...
        Shona: typing.ClassVar[QLocale.Language] = ...
        SichuanYi: typing.ClassVar[QLocale.Language] = ...
        Sicilian: typing.ClassVar[QLocale.Language] = ...
        Sidamo: typing.ClassVar[QLocale.Language] = ...
        Silesian: typing.ClassVar[QLocale.Language] = ...
        Sindhi: typing.ClassVar[QLocale.Language] = ...
        Sinhala: typing.ClassVar[QLocale.Language] = ...
        SkoltSami: typing.ClassVar[QLocale.Language] = ...
        Slovak: typing.ClassVar[QLocale.Language] = ...
        Slovenian: typing.ClassVar[QLocale.Language] = ...
        Soga: typing.ClassVar[QLocale.Language] = ...
        Somali: typing.ClassVar[QLocale.Language] = ...
        Sora: typing.ClassVar[QLocale.Language] = ...
        SouthNdebele: typing.ClassVar[QLocale.Language] = ...
        SouthernKurdish: typing.ClassVar[QLocale.Language] = ...
        SouthernSami: typing.ClassVar[QLocale.Language] = ...
        SouthernSotho: typing.ClassVar[QLocale.Language] = ...
        Spanish: typing.ClassVar[QLocale.Language] = ...
        StandardMoroccanTamazight: typing.ClassVar[QLocale.Language] = ...
        Sundanese: typing.ClassVar[QLocale.Language] = ...
        Swahili: typing.ClassVar[QLocale.Language] = ...
        Swati: typing.ClassVar[QLocale.Language] = ...
        Swedish: typing.ClassVar[QLocale.Language] = ...
        SwissGerman: typing.ClassVar[QLocale.Language] = ...
        Sylheti: typing.ClassVar[QLocale.Language] = ...
        Syriac: typing.ClassVar[QLocale.Language] = ...
        Tachelhit: typing.ClassVar[QLocale.Language] = ...
        Tagalog: typing.ClassVar[QLocale.Language] = ...
        Tagbanwa: typing.ClassVar[QLocale.Language] = ...
        Tahitian: typing.ClassVar[QLocale.Language] = ...
        TaiDam: typing.ClassVar[QLocale.Language] = ...
        TaiNua: typing.ClassVar[QLocale.Language] = ...
        Taita: typing.ClassVar[QLocale.Language] = ...
        Tajik: typing.ClassVar[QLocale.Language] = ...
        Tamil: typing.ClassVar[QLocale.Language] = ...
        Tangut: typing.ClassVar[QLocale.Language] = ...
        Taroko: typing.ClassVar[QLocale.Language] = ...
        Tasawaq: typing.ClassVar[QLocale.Language] = ...
        Tatar: typing.ClassVar[QLocale.Language] = ...
        TedimChin: typing.ClassVar[QLocale.Language] = ...
        Telugu: typing.ClassVar[QLocale.Language] = ...
        Teso: typing.ClassVar[QLocale.Language] = ...
        Thai: typing.ClassVar[QLocale.Language] = ...
        Tibetan: typing.ClassVar[QLocale.Language] = ...
        Tigre: typing.ClassVar[QLocale.Language] = ...
        Tigrinya: typing.ClassVar[QLocale.Language] = ...
        TokPisin: typing.ClassVar[QLocale.Language] = ...
        TokelauLanguage: typing.ClassVar[QLocale.Language] = ...
        Tongan: typing.ClassVar[QLocale.Language] = ...
        Tsonga: typing.ClassVar[QLocale.Language] = ...
        Tswana: typing.ClassVar[QLocale.Language] = ...
        Turkish: typing.ClassVar[QLocale.Language] = ...
        Turkmen: typing.ClassVar[QLocale.Language] = ...
        TuvaluLanguage: typing.ClassVar[QLocale.Language] = ...
        Twi: typing.ClassVar[QLocale.Language] = ...
        Tyap: typing.ClassVar[QLocale.Language] = ...
        Ugaritic: typing.ClassVar[QLocale.Language] = ...
        Uighur: typing.ClassVar[QLocale.Language] = ...
        Uigur: typing.ClassVar[QLocale.Language] = ...
        Ukrainian: typing.ClassVar[QLocale.Language] = ...
        UncodedLanguages: typing.ClassVar[QLocale.Language] = ...
        UpperSorbian: typing.ClassVar[QLocale.Language] = ...
        Urdu: typing.ClassVar[QLocale.Language] = ...
        Uzbek: typing.ClassVar[QLocale.Language] = ...
        Vai: typing.ClassVar[QLocale.Language] = ...
        Venda: typing.ClassVar[QLocale.Language] = ...
        Vietnamese: typing.ClassVar[QLocale.Language] = ...
        Volapuk: typing.ClassVar[QLocale.Language] = ...
        Vunjo: typing.ClassVar[QLocale.Language] = ...
        Walamo: typing.ClassVar[QLocale.Language] = ...
        Walloon: typing.ClassVar[QLocale.Language] = ...
        Walser: typing.ClassVar[QLocale.Language] = ...
        Warlpiri: typing.ClassVar[QLocale.Language] = ...
        Welsh: typing.ClassVar[QLocale.Language] = ...
        WesternBalochi: typing.ClassVar[QLocale.Language] = ...
        WesternFrisian: typing.ClassVar[QLocale.Language] = ...
        Wolof: typing.ClassVar[QLocale.Language] = ...
        Xhosa: typing.ClassVar[QLocale.Language] = ...
        Yangben: typing.ClassVar[QLocale.Language] = ...
        Yiddish: typing.ClassVar[QLocale.Language] = ...
        Yoruba: typing.ClassVar[QLocale.Language] = ...
        Zarma: typing.ClassVar[QLocale.Language] = ...
        Zhuang: typing.ClassVar[QLocale.Language] = ...
        Zulu: typing.ClassVar[QLocale.Language] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLocale.Language: ...
        def __and__(self, other: typing.SupportsInt) -> QLocale.Language: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLocale.Language: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocale.Language: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLocale.Language: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocale.Language: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLocale.Language: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocale.Language: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLocale.Language: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocale.Language: ...
        def __sub__(self, other: typing.SupportsInt) -> QLocale.Language: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocale.Language: ...

    class MeasurementSystem:
        ImperialSystem: typing.ClassVar[QLocale.MeasurementSystem] = ...
        ImperialUKSystem: typing.ClassVar[QLocale.MeasurementSystem] = ...
        ImperialUSSystem: typing.ClassVar[QLocale.MeasurementSystem] = ...
        MetricSystem: typing.ClassVar[QLocale.MeasurementSystem] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLocale.MeasurementSystem: ...
        def __and__(self, other: typing.SupportsInt) -> QLocale.MeasurementSystem: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLocale.MeasurementSystem: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocale.MeasurementSystem: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLocale.MeasurementSystem: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocale.MeasurementSystem: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLocale.MeasurementSystem: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocale.MeasurementSystem: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLocale.MeasurementSystem: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocale.MeasurementSystem: ...
        def __sub__(self, other: typing.SupportsInt) -> QLocale.MeasurementSystem: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocale.MeasurementSystem: ...

    class NumberOption:
        DefaultNumberOptions: typing.ClassVar[QLocale.NumberOption] = ...
        IncludeTrailingZeroesAfterDot: typing.ClassVar[QLocale.NumberOption] = ...
        OmitGroupSeparator: typing.ClassVar[QLocale.NumberOption] = ...
        OmitLeadingZeroInExponent: typing.ClassVar[QLocale.NumberOption] = ...
        RejectGroupSeparator: typing.ClassVar[QLocale.NumberOption] = ...
        RejectLeadingZeroInExponent: typing.ClassVar[QLocale.NumberOption] = ...
        RejectTrailingZeroesAfterDot: typing.ClassVar[QLocale.NumberOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QLocale.NumberOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QLocale.NumberOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocale.NumberOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocale.NumberOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocale.NumberOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocale.NumberOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocale.NumberOptions: ...

    class NumberOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QLocale.NumberOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QLocale.NumberOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocale.NumberOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocale.NumberOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocale.NumberOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocale.NumberOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocale.NumberOptions: ...

    class QuotationStyle:
        AlternateQuotation: typing.ClassVar[QLocale.QuotationStyle] = ...
        StandardQuotation: typing.ClassVar[QLocale.QuotationStyle] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLocale.QuotationStyle: ...
        def __and__(self, other: typing.SupportsInt) -> QLocale.QuotationStyle: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLocale.QuotationStyle: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocale.QuotationStyle: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLocale.QuotationStyle: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocale.QuotationStyle: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLocale.QuotationStyle: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocale.QuotationStyle: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLocale.QuotationStyle: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocale.QuotationStyle: ...
        def __sub__(self, other: typing.SupportsInt) -> QLocale.QuotationStyle: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocale.QuotationStyle: ...

    class Script:
        AdlamScript: typing.ClassVar[QLocale.Script] = ...
        AhomScript: typing.ClassVar[QLocale.Script] = ...
        AnatolianHieroglyphsScript: typing.ClassVar[QLocale.Script] = ...
        AnyScript: typing.ClassVar[QLocale.Script] = ...
        ArabicScript: typing.ClassVar[QLocale.Script] = ...
        ArmenianScript: typing.ClassVar[QLocale.Script] = ...
        AvestanScript: typing.ClassVar[QLocale.Script] = ...
        BalineseScript: typing.ClassVar[QLocale.Script] = ...
        BamumScript: typing.ClassVar[QLocale.Script] = ...
        BassaVahScript: typing.ClassVar[QLocale.Script] = ...
        BatakScript: typing.ClassVar[QLocale.Script] = ...
        BengaliScript: typing.ClassVar[QLocale.Script] = ...
        BhaiksukiScript: typing.ClassVar[QLocale.Script] = ...
        BopomofoScript: typing.ClassVar[QLocale.Script] = ...
        BrahmiScript: typing.ClassVar[QLocale.Script] = ...
        BrailleScript: typing.ClassVar[QLocale.Script] = ...
        BugineseScript: typing.ClassVar[QLocale.Script] = ...
        BuhidScript: typing.ClassVar[QLocale.Script] = ...
        CanadianAboriginalScript: typing.ClassVar[QLocale.Script] = ...
        CarianScript: typing.ClassVar[QLocale.Script] = ...
        CaucasianAlbanianScript: typing.ClassVar[QLocale.Script] = ...
        ChakmaScript: typing.ClassVar[QLocale.Script] = ...
        ChamScript: typing.ClassVar[QLocale.Script] = ...
        CherokeeScript: typing.ClassVar[QLocale.Script] = ...
        CopticScript: typing.ClassVar[QLocale.Script] = ...
        CuneiformScript: typing.ClassVar[QLocale.Script] = ...
        CypriotScript: typing.ClassVar[QLocale.Script] = ...
        CyrillicScript: typing.ClassVar[QLocale.Script] = ...
        DeseretScript: typing.ClassVar[QLocale.Script] = ...
        DevanagariScript: typing.ClassVar[QLocale.Script] = ...
        DuployanScript: typing.ClassVar[QLocale.Script] = ...
        EgyptianHieroglyphsScript: typing.ClassVar[QLocale.Script] = ...
        ElbasanScript: typing.ClassVar[QLocale.Script] = ...
        EthiopicScript: typing.ClassVar[QLocale.Script] = ...
        FraserScript: typing.ClassVar[QLocale.Script] = ...
        GeorgianScript: typing.ClassVar[QLocale.Script] = ...
        GlagoliticScript: typing.ClassVar[QLocale.Script] = ...
        GothicScript: typing.ClassVar[QLocale.Script] = ...
        GranthaScript: typing.ClassVar[QLocale.Script] = ...
        GreekScript: typing.ClassVar[QLocale.Script] = ...
        GujaratiScript: typing.ClassVar[QLocale.Script] = ...
        GurmukhiScript: typing.ClassVar[QLocale.Script] = ...
        HanScript: typing.ClassVar[QLocale.Script] = ...
        HanWithBopomofoScript: typing.ClassVar[QLocale.Script] = ...
        HangulScript: typing.ClassVar[QLocale.Script] = ...
        HanunooScript: typing.ClassVar[QLocale.Script] = ...
        HatranScript: typing.ClassVar[QLocale.Script] = ...
        HebrewScript: typing.ClassVar[QLocale.Script] = ...
        HiraganaScript: typing.ClassVar[QLocale.Script] = ...
        ImperialAramaicScript: typing.ClassVar[QLocale.Script] = ...
        InscriptionalPahlaviScript: typing.ClassVar[QLocale.Script] = ...
        InscriptionalParthianScript: typing.ClassVar[QLocale.Script] = ...
        JamoScript: typing.ClassVar[QLocale.Script] = ...
        JapaneseScript: typing.ClassVar[QLocale.Script] = ...
        JavaneseScript: typing.ClassVar[QLocale.Script] = ...
        KaithiScript: typing.ClassVar[QLocale.Script] = ...
        KannadaScript: typing.ClassVar[QLocale.Script] = ...
        KatakanaScript: typing.ClassVar[QLocale.Script] = ...
        KayahLiScript: typing.ClassVar[QLocale.Script] = ...
        KharoshthiScript: typing.ClassVar[QLocale.Script] = ...
        KhmerScript: typing.ClassVar[QLocale.Script] = ...
        KhojkiScript: typing.ClassVar[QLocale.Script] = ...
        KhudawadiScript: typing.ClassVar[QLocale.Script] = ...
        KoreanScript: typing.ClassVar[QLocale.Script] = ...
        LannaScript: typing.ClassVar[QLocale.Script] = ...
        LaoScript: typing.ClassVar[QLocale.Script] = ...
        LastScript: typing.ClassVar[QLocale.Script] = ...
        LatinScript: typing.ClassVar[QLocale.Script] = ...
        LepchaScript: typing.ClassVar[QLocale.Script] = ...
        LimbuScript: typing.ClassVar[QLocale.Script] = ...
        LinearAScript: typing.ClassVar[QLocale.Script] = ...
        LinearBScript: typing.ClassVar[QLocale.Script] = ...
        LycianScript: typing.ClassVar[QLocale.Script] = ...
        LydianScript: typing.ClassVar[QLocale.Script] = ...
        MahajaniScript: typing.ClassVar[QLocale.Script] = ...
        MalayalamScript: typing.ClassVar[QLocale.Script] = ...
        MandaeanScript: typing.ClassVar[QLocale.Script] = ...
        ManichaeanScript: typing.ClassVar[QLocale.Script] = ...
        MarchenScript: typing.ClassVar[QLocale.Script] = ...
        MeiteiMayekScript: typing.ClassVar[QLocale.Script] = ...
        MendeKikakuiScript: typing.ClassVar[QLocale.Script] = ...
        MeroiticCursiveScript: typing.ClassVar[QLocale.Script] = ...
        MeroiticScript: typing.ClassVar[QLocale.Script] = ...
        ModiScript: typing.ClassVar[QLocale.Script] = ...
        MongolianScript: typing.ClassVar[QLocale.Script] = ...
        MroScript: typing.ClassVar[QLocale.Script] = ...
        MultaniScript: typing.ClassVar[QLocale.Script] = ...
        MyanmarScript: typing.ClassVar[QLocale.Script] = ...
        NabataeanScript: typing.ClassVar[QLocale.Script] = ...
        NewTaiLueScript: typing.ClassVar[QLocale.Script] = ...
        NewaScript: typing.ClassVar[QLocale.Script] = ...
        NkoScript: typing.ClassVar[QLocale.Script] = ...
        OghamScript: typing.ClassVar[QLocale.Script] = ...
        OlChikiScript: typing.ClassVar[QLocale.Script] = ...
        OldHungarianScript: typing.ClassVar[QLocale.Script] = ...
        OldItalicScript: typing.ClassVar[QLocale.Script] = ...
        OldNorthArabianScript: typing.ClassVar[QLocale.Script] = ...
        OldPermicScript: typing.ClassVar[QLocale.Script] = ...
        OldPersianScript: typing.ClassVar[QLocale.Script] = ...
        OldSouthArabianScript: typing.ClassVar[QLocale.Script] = ...
        OriyaScript: typing.ClassVar[QLocale.Script] = ...
        OrkhonScript: typing.ClassVar[QLocale.Script] = ...
        OsageScript: typing.ClassVar[QLocale.Script] = ...
        OsmanyaScript: typing.ClassVar[QLocale.Script] = ...
        PahawhHmongScript: typing.ClassVar[QLocale.Script] = ...
        PalmyreneScript: typing.ClassVar[QLocale.Script] = ...
        PauCinHauScript: typing.ClassVar[QLocale.Script] = ...
        PhagsPaScript: typing.ClassVar[QLocale.Script] = ...
        PhoenicianScript: typing.ClassVar[QLocale.Script] = ...
        PollardPhoneticScript: typing.ClassVar[QLocale.Script] = ...
        PsalterPahlaviScript: typing.ClassVar[QLocale.Script] = ...
        RejangScript: typing.ClassVar[QLocale.Script] = ...
        RunicScript: typing.ClassVar[QLocale.Script] = ...
        SamaritanScript: typing.ClassVar[QLocale.Script] = ...
        SaurashtraScript: typing.ClassVar[QLocale.Script] = ...
        SharadaScript: typing.ClassVar[QLocale.Script] = ...
        ShavianScript: typing.ClassVar[QLocale.Script] = ...
        SiddhamScript: typing.ClassVar[QLocale.Script] = ...
        SignWritingScript: typing.ClassVar[QLocale.Script] = ...
        SimplifiedChineseScript: typing.ClassVar[QLocale.Script] = ...
        SimplifiedHanScript: typing.ClassVar[QLocale.Script] = ...
        SinhalaScript: typing.ClassVar[QLocale.Script] = ...
        SoraSompengScript: typing.ClassVar[QLocale.Script] = ...
        SundaneseScript: typing.ClassVar[QLocale.Script] = ...
        SylotiNagriScript: typing.ClassVar[QLocale.Script] = ...
        SyriacScript: typing.ClassVar[QLocale.Script] = ...
        TagalogScript: typing.ClassVar[QLocale.Script] = ...
        TagbanwaScript: typing.ClassVar[QLocale.Script] = ...
        TaiLeScript: typing.ClassVar[QLocale.Script] = ...
        TaiVietScript: typing.ClassVar[QLocale.Script] = ...
        TakriScript: typing.ClassVar[QLocale.Script] = ...
        TamilScript: typing.ClassVar[QLocale.Script] = ...
        TangutScript: typing.ClassVar[QLocale.Script] = ...
        TeluguScript: typing.ClassVar[QLocale.Script] = ...
        ThaanaScript: typing.ClassVar[QLocale.Script] = ...
        ThaiScript: typing.ClassVar[QLocale.Script] = ...
        TibetanScript: typing.ClassVar[QLocale.Script] = ...
        TifinaghScript: typing.ClassVar[QLocale.Script] = ...
        TirhutaScript: typing.ClassVar[QLocale.Script] = ...
        TraditionalChineseScript: typing.ClassVar[QLocale.Script] = ...
        TraditionalHanScript: typing.ClassVar[QLocale.Script] = ...
        UgariticScript: typing.ClassVar[QLocale.Script] = ...
        VaiScript: typing.ClassVar[QLocale.Script] = ...
        VarangKshitiScript: typing.ClassVar[QLocale.Script] = ...
        YiScript: typing.ClassVar[QLocale.Script] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLocale.Script: ...
        def __and__(self, other: typing.SupportsInt) -> QLocale.Script: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLocale.Script: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLocale.Script: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLocale.Script: ...
        def __rand__(self, other: typing.SupportsInt) -> QLocale.Script: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLocale.Script: ...
        def __ror__(self, other: typing.SupportsInt) -> QLocale.Script: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLocale.Script: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLocale.Script: ...
        def __sub__(self, other: typing.SupportsInt) -> QLocale.Script: ...
        def __xor__(self, other: typing.SupportsInt) -> QLocale.Script: ...
    Abkhazian: typing.ClassVar[QLocale.Language] = ...
    AdlamScript: typing.ClassVar[QLocale.Script] = ...
    Afan: typing.ClassVar[QLocale.Language] = ...
    Afar: typing.ClassVar[QLocale.Language] = ...
    Afghanistan: typing.ClassVar[QLocale.Country] = ...
    Afrikaans: typing.ClassVar[QLocale.Language] = ...
    Aghem: typing.ClassVar[QLocale.Language] = ...
    Ahom: typing.ClassVar[QLocale.Language] = ...
    AhomScript: typing.ClassVar[QLocale.Script] = ...
    Akan: typing.ClassVar[QLocale.Language] = ...
    Akkadian: typing.ClassVar[QLocale.Language] = ...
    Akoose: typing.ClassVar[QLocale.Language] = ...
    AlandIslands: typing.ClassVar[QLocale.Country] = ...
    Albania: typing.ClassVar[QLocale.Country] = ...
    Albanian: typing.ClassVar[QLocale.Language] = ...
    Algeria: typing.ClassVar[QLocale.Country] = ...
    AlternateQuotation: typing.ClassVar[QLocale.QuotationStyle] = ...
    AmericanSamoa: typing.ClassVar[QLocale.Country] = ...
    AmericanSignLanguage: typing.ClassVar[QLocale.Language] = ...
    Amharic: typing.ClassVar[QLocale.Language] = ...
    AnatolianHieroglyphsScript: typing.ClassVar[QLocale.Script] = ...
    AncientEgyptian: typing.ClassVar[QLocale.Language] = ...
    AncientGreek: typing.ClassVar[QLocale.Language] = ...
    AncientNorthArabian: typing.ClassVar[QLocale.Language] = ...
    Andorra: typing.ClassVar[QLocale.Country] = ...
    Angola: typing.ClassVar[QLocale.Country] = ...
    Anguilla: typing.ClassVar[QLocale.Country] = ...
    Antarctica: typing.ClassVar[QLocale.Country] = ...
    AntiguaAndBarbuda: typing.ClassVar[QLocale.Country] = ...
    AnyCountry: typing.ClassVar[QLocale.Country] = ...
    AnyLanguage: typing.ClassVar[QLocale.Language] = ...
    AnyScript: typing.ClassVar[QLocale.Script] = ...
    Arabic: typing.ClassVar[QLocale.Language] = ...
    ArabicScript: typing.ClassVar[QLocale.Script] = ...
    Aragonese: typing.ClassVar[QLocale.Language] = ...
    Aramaic: typing.ClassVar[QLocale.Language] = ...
    ArdhamagadhiPrakrit: typing.ClassVar[QLocale.Language] = ...
    Argentina: typing.ClassVar[QLocale.Country] = ...
    Armenia: typing.ClassVar[QLocale.Country] = ...
    Armenian: typing.ClassVar[QLocale.Language] = ...
    ArmenianScript: typing.ClassVar[QLocale.Script] = ...
    Aruba: typing.ClassVar[QLocale.Country] = ...
    AscensionIsland: typing.ClassVar[QLocale.Country] = ...
    Assamese: typing.ClassVar[QLocale.Language] = ...
    Asturian: typing.ClassVar[QLocale.Language] = ...
    Asu: typing.ClassVar[QLocale.Language] = ...
    Atsam: typing.ClassVar[QLocale.Language] = ...
    Australia: typing.ClassVar[QLocale.Country] = ...
    Austria: typing.ClassVar[QLocale.Country] = ...
    Avaric: typing.ClassVar[QLocale.Language] = ...
    Avestan: typing.ClassVar[QLocale.Language] = ...
    AvestanScript: typing.ClassVar[QLocale.Script] = ...
    Aymara: typing.ClassVar[QLocale.Language] = ...
    Azerbaijan: typing.ClassVar[QLocale.Country] = ...
    Azerbaijani: typing.ClassVar[QLocale.Language] = ...
    Bafia: typing.ClassVar[QLocale.Language] = ...
    Bahamas: typing.ClassVar[QLocale.Country] = ...
    Bahrain: typing.ClassVar[QLocale.Country] = ...
    Balinese: typing.ClassVar[QLocale.Language] = ...
    BalineseScript: typing.ClassVar[QLocale.Script] = ...
    Bambara: typing.ClassVar[QLocale.Language] = ...
    BamumScript: typing.ClassVar[QLocale.Script] = ...
    Bamun: typing.ClassVar[QLocale.Language] = ...
    Bangladesh: typing.ClassVar[QLocale.Country] = ...
    Barbados: typing.ClassVar[QLocale.Country] = ...
    Basaa: typing.ClassVar[QLocale.Language] = ...
    Bashkir: typing.ClassVar[QLocale.Language] = ...
    Basque: typing.ClassVar[QLocale.Language] = ...
    Bassa: typing.ClassVar[QLocale.Language] = ...
    BassaVahScript: typing.ClassVar[QLocale.Script] = ...
    BatakScript: typing.ClassVar[QLocale.Script] = ...
    BatakToba: typing.ClassVar[QLocale.Language] = ...
    Belarus: typing.ClassVar[QLocale.Country] = ...
    Belarusian: typing.ClassVar[QLocale.Language] = ...
    Belgium: typing.ClassVar[QLocale.Country] = ...
    Belize: typing.ClassVar[QLocale.Country] = ...
    Bemba: typing.ClassVar[QLocale.Language] = ...
    Bena: typing.ClassVar[QLocale.Language] = ...
    Bengali: typing.ClassVar[QLocale.Language] = ...
    BengaliScript: typing.ClassVar[QLocale.Script] = ...
    Benin: typing.ClassVar[QLocale.Country] = ...
    Bermuda: typing.ClassVar[QLocale.Country] = ...
    BhaiksukiScript: typing.ClassVar[QLocale.Script] = ...
    Bhojpuri: typing.ClassVar[QLocale.Language] = ...
    Bhutan: typing.ClassVar[QLocale.Country] = ...
    Bhutani: typing.ClassVar[QLocale.Language] = ...
    Bihari: typing.ClassVar[QLocale.Language] = ...
    Bislama: typing.ClassVar[QLocale.Language] = ...
    Blin: typing.ClassVar[QLocale.Language] = ...
    Bodo: typing.ClassVar[QLocale.Language] = ...
    Bolivia: typing.ClassVar[QLocale.Country] = ...
    Bonaire: typing.ClassVar[QLocale.Country] = ...
    BopomofoScript: typing.ClassVar[QLocale.Script] = ...
    BosniaAndHerzegowina: typing.ClassVar[QLocale.Country] = ...
    Bosnian: typing.ClassVar[QLocale.Language] = ...
    Botswana: typing.ClassVar[QLocale.Country] = ...
    BouvetIsland: typing.ClassVar[QLocale.Country] = ...
    BrahmiScript: typing.ClassVar[QLocale.Script] = ...
    BrailleScript: typing.ClassVar[QLocale.Script] = ...
    Brazil: typing.ClassVar[QLocale.Country] = ...
    Breton: typing.ClassVar[QLocale.Language] = ...
    BritishIndianOceanTerritory: typing.ClassVar[QLocale.Country] = ...
    BritishVirginIslands: typing.ClassVar[QLocale.Country] = ...
    Brunei: typing.ClassVar[QLocale.Country] = ...
    Buginese: typing.ClassVar[QLocale.Language] = ...
    BugineseScript: typing.ClassVar[QLocale.Script] = ...
    Buhid: typing.ClassVar[QLocale.Language] = ...
    BuhidScript: typing.ClassVar[QLocale.Script] = ...
    Bulgaria: typing.ClassVar[QLocale.Country] = ...
    Bulgarian: typing.ClassVar[QLocale.Language] = ...
    BurkinaFaso: typing.ClassVar[QLocale.Country] = ...
    Burmese: typing.ClassVar[QLocale.Language] = ...
    Burundi: typing.ClassVar[QLocale.Country] = ...
    Byelorussian: typing.ClassVar[QLocale.Language] = ...
    C: typing.ClassVar[QLocale.Language] = ...
    Cambodia: typing.ClassVar[QLocale.Country] = ...
    Cambodian: typing.ClassVar[QLocale.Language] = ...
    Cameroon: typing.ClassVar[QLocale.Country] = ...
    Canada: typing.ClassVar[QLocale.Country] = ...
    CanadianAboriginalScript: typing.ClassVar[QLocale.Script] = ...
    CanaryIslands: typing.ClassVar[QLocale.Country] = ...
    Cantonese: typing.ClassVar[QLocale.Language] = ...
    CapeVerde: typing.ClassVar[QLocale.Country] = ...
    Carian: typing.ClassVar[QLocale.Language] = ...
    CarianScript: typing.ClassVar[QLocale.Script] = ...
    Catalan: typing.ClassVar[QLocale.Language] = ...
    CaucasianAlbanianScript: typing.ClassVar[QLocale.Script] = ...
    CaymanIslands: typing.ClassVar[QLocale.Country] = ...
    Cebuano: typing.ClassVar[QLocale.Language] = ...
    CentralAfricanRepublic: typing.ClassVar[QLocale.Country] = ...
    CentralKurdish: typing.ClassVar[QLocale.Language] = ...
    CentralMoroccoTamazight: typing.ClassVar[QLocale.Language] = ...
    CeutaAndMelilla: typing.ClassVar[QLocale.Country] = ...
    Chad: typing.ClassVar[QLocale.Country] = ...
    Chakma: typing.ClassVar[QLocale.Language] = ...
    ChakmaScript: typing.ClassVar[QLocale.Script] = ...
    ChamScript: typing.ClassVar[QLocale.Script] = ...
    Chamorro: typing.ClassVar[QLocale.Language] = ...
    Chechen: typing.ClassVar[QLocale.Language] = ...
    Cherokee: typing.ClassVar[QLocale.Language] = ...
    CherokeeScript: typing.ClassVar[QLocale.Script] = ...
    Chewa: typing.ClassVar[QLocale.Language] = ...
    Chickasaw: typing.ClassVar[QLocale.Language] = ...
    Chiga: typing.ClassVar[QLocale.Language] = ...
    Chile: typing.ClassVar[QLocale.Country] = ...
    China: typing.ClassVar[QLocale.Country] = ...
    Chinese: typing.ClassVar[QLocale.Language] = ...
    ChristmasIsland: typing.ClassVar[QLocale.Country] = ...
    Church: typing.ClassVar[QLocale.Language] = ...
    Chuvash: typing.ClassVar[QLocale.Language] = ...
    ClassicalMandaic: typing.ClassVar[QLocale.Language] = ...
    ClippertonIsland: typing.ClassVar[QLocale.Country] = ...
    CocosIslands: typing.ClassVar[QLocale.Country] = ...
    Colognian: typing.ClassVar[QLocale.Language] = ...
    Colombia: typing.ClassVar[QLocale.Country] = ...
    Comoros: typing.ClassVar[QLocale.Country] = ...
    CongoBrazzaville: typing.ClassVar[QLocale.Country] = ...
    CongoKinshasa: typing.ClassVar[QLocale.Country] = ...
    CongoSwahili: typing.ClassVar[QLocale.Language] = ...
    CookIslands: typing.ClassVar[QLocale.Country] = ...
    Coptic: typing.ClassVar[QLocale.Language] = ...
    CopticScript: typing.ClassVar[QLocale.Script] = ...
    Cornish: typing.ClassVar[QLocale.Language] = ...
    Corsican: typing.ClassVar[QLocale.Language] = ...
    CostaRica: typing.ClassVar[QLocale.Country] = ...
    Cree: typing.ClassVar[QLocale.Language] = ...
    Croatia: typing.ClassVar[QLocale.Country] = ...
    Croatian: typing.ClassVar[QLocale.Language] = ...
    Cuba: typing.ClassVar[QLocale.Country] = ...
    CuneiformScript: typing.ClassVar[QLocale.Script] = ...
    CuraSao: typing.ClassVar[QLocale.Country] = ...
    CurrencyDisplayName: typing.ClassVar[QLocale.CurrencySymbolFormat] = ...
    CurrencyIsoCode: typing.ClassVar[QLocale.CurrencySymbolFormat] = ...
    CurrencySymbol: typing.ClassVar[QLocale.CurrencySymbolFormat] = ...
    CypriotScript: typing.ClassVar[QLocale.Script] = ...
    Cyprus: typing.ClassVar[QLocale.Country] = ...
    CyrillicScript: typing.ClassVar[QLocale.Script] = ...
    Czech: typing.ClassVar[QLocale.Language] = ...
    CzechRepublic: typing.ClassVar[QLocale.Country] = ...
    Danish: typing.ClassVar[QLocale.Language] = ...
    DataSizeBase1000: typing.ClassVar[QLocale.DataSizeFormat] = ...
    DataSizeIecFormat: typing.ClassVar[QLocale.DataSizeFormat] = ...
    DataSizeSIFormat: typing.ClassVar[QLocale.DataSizeFormat] = ...
    DataSizeSIQuantifiers: typing.ClassVar[QLocale.DataSizeFormat] = ...
    DataSizeTraditionalFormat: typing.ClassVar[QLocale.DataSizeFormat] = ...
    DefaultNumberOptions: typing.ClassVar[QLocale.NumberOption] = ...
    DemocraticRepublicOfCongo: typing.ClassVar[QLocale.Country] = ...
    DemocraticRepublicOfKorea: typing.ClassVar[QLocale.Country] = ...
    Denmark: typing.ClassVar[QLocale.Country] = ...
    DeseretScript: typing.ClassVar[QLocale.Script] = ...
    DevanagariScript: typing.ClassVar[QLocale.Script] = ...
    DiegoGarcia: typing.ClassVar[QLocale.Country] = ...
    Divehi: typing.ClassVar[QLocale.Language] = ...
    Djibouti: typing.ClassVar[QLocale.Country] = ...
    Dogri: typing.ClassVar[QLocale.Language] = ...
    Dominica: typing.ClassVar[QLocale.Country] = ...
    DominicanRepublic: typing.ClassVar[QLocale.Country] = ...
    Duala: typing.ClassVar[QLocale.Language] = ...
    DuployanScript: typing.ClassVar[QLocale.Script] = ...
    Dutch: typing.ClassVar[QLocale.Language] = ...
    Dzongkha: typing.ClassVar[QLocale.Language] = ...
    EastTimor: typing.ClassVar[QLocale.Country] = ...
    EasternCham: typing.ClassVar[QLocale.Language] = ...
    EasternKayah: typing.ClassVar[QLocale.Language] = ...
    Ecuador: typing.ClassVar[QLocale.Country] = ...
    Egypt: typing.ClassVar[QLocale.Country] = ...
    EgyptianHieroglyphsScript: typing.ClassVar[QLocale.Script] = ...
    ElSalvador: typing.ClassVar[QLocale.Country] = ...
    ElbasanScript: typing.ClassVar[QLocale.Script] = ...
    Embu: typing.ClassVar[QLocale.Language] = ...
    English: typing.ClassVar[QLocale.Language] = ...
    EquatorialGuinea: typing.ClassVar[QLocale.Country] = ...
    Eritrea: typing.ClassVar[QLocale.Country] = ...
    Erzya: typing.ClassVar[QLocale.Language] = ...
    Esperanto: typing.ClassVar[QLocale.Language] = ...
    Estonia: typing.ClassVar[QLocale.Country] = ...
    Estonian: typing.ClassVar[QLocale.Language] = ...
    Ethiopia: typing.ClassVar[QLocale.Country] = ...
    EthiopicScript: typing.ClassVar[QLocale.Script] = ...
    Etruscan: typing.ClassVar[QLocale.Language] = ...
    Europe: typing.ClassVar[QLocale.Country] = ...
    EuropeanUnion: typing.ClassVar[QLocale.Country] = ...
    Ewe: typing.ClassVar[QLocale.Language] = ...
    Ewondo: typing.ClassVar[QLocale.Language] = ...
    FalklandIslands: typing.ClassVar[QLocale.Country] = ...
    FaroeIslands: typing.ClassVar[QLocale.Country] = ...
    Faroese: typing.ClassVar[QLocale.Language] = ...
    Fiji: typing.ClassVar[QLocale.Country] = ...
    Fijian: typing.ClassVar[QLocale.Language] = ...
    Filipino: typing.ClassVar[QLocale.Language] = ...
    Finland: typing.ClassVar[QLocale.Country] = ...
    Finnish: typing.ClassVar[QLocale.Language] = ...
    FloatingPointShortest: typing.ClassVar[QLocale.FloatingPointPrecisionOption] = ...
    France: typing.ClassVar[QLocale.Country] = ...
    FraserScript: typing.ClassVar[QLocale.Script] = ...
    French: typing.ClassVar[QLocale.Language] = ...
    FrenchGuiana: typing.ClassVar[QLocale.Country] = ...
    FrenchPolynesia: typing.ClassVar[QLocale.Country] = ...
    FrenchSouthernTerritories: typing.ClassVar[QLocale.Country] = ...
    Frisian: typing.ClassVar[QLocale.Language] = ...
    Friulian: typing.ClassVar[QLocale.Language] = ...
    Fulah: typing.ClassVar[QLocale.Language] = ...
    Ga: typing.ClassVar[QLocale.Language] = ...
    Gabon: typing.ClassVar[QLocale.Country] = ...
    Gaelic: typing.ClassVar[QLocale.Language] = ...
    Galician: typing.ClassVar[QLocale.Language] = ...
    Gambia: typing.ClassVar[QLocale.Country] = ...
    Ganda: typing.ClassVar[QLocale.Language] = ...
    Geez: typing.ClassVar[QLocale.Language] = ...
    Georgia: typing.ClassVar[QLocale.Country] = ...
    Georgian: typing.ClassVar[QLocale.Language] = ...
    GeorgianScript: typing.ClassVar[QLocale.Script] = ...
    German: typing.ClassVar[QLocale.Language] = ...
    Germany: typing.ClassVar[QLocale.Country] = ...
    Ghana: typing.ClassVar[QLocale.Country] = ...
    Gibraltar: typing.ClassVar[QLocale.Country] = ...
    GlagoliticScript: typing.ClassVar[QLocale.Script] = ...
    Gothic: typing.ClassVar[QLocale.Language] = ...
    GothicScript: typing.ClassVar[QLocale.Script] = ...
    GranthaScript: typing.ClassVar[QLocale.Script] = ...
    Greece: typing.ClassVar[QLocale.Country] = ...
    Greek: typing.ClassVar[QLocale.Language] = ...
    GreekScript: typing.ClassVar[QLocale.Script] = ...
    Greenland: typing.ClassVar[QLocale.Country] = ...
    Greenlandic: typing.ClassVar[QLocale.Language] = ...
    Grenada: typing.ClassVar[QLocale.Country] = ...
    Guadeloupe: typing.ClassVar[QLocale.Country] = ...
    Guam: typing.ClassVar[QLocale.Country] = ...
    Guarani: typing.ClassVar[QLocale.Language] = ...
    Guatemala: typing.ClassVar[QLocale.Country] = ...
    Guernsey: typing.ClassVar[QLocale.Country] = ...
    Guinea: typing.ClassVar[QLocale.Country] = ...
    GuineaBissau: typing.ClassVar[QLocale.Country] = ...
    Gujarati: typing.ClassVar[QLocale.Language] = ...
    GujaratiScript: typing.ClassVar[QLocale.Script] = ...
    GurmukhiScript: typing.ClassVar[QLocale.Script] = ...
    Gusii: typing.ClassVar[QLocale.Language] = ...
    Guyana: typing.ClassVar[QLocale.Country] = ...
    Haiti: typing.ClassVar[QLocale.Country] = ...
    Haitian: typing.ClassVar[QLocale.Language] = ...
    HanScript: typing.ClassVar[QLocale.Script] = ...
    HanWithBopomofoScript: typing.ClassVar[QLocale.Script] = ...
    HangulScript: typing.ClassVar[QLocale.Script] = ...
    Hanunoo: typing.ClassVar[QLocale.Language] = ...
    HanunooScript: typing.ClassVar[QLocale.Script] = ...
    HatranScript: typing.ClassVar[QLocale.Script] = ...
    Hausa: typing.ClassVar[QLocale.Language] = ...
    Hawaiian: typing.ClassVar[QLocale.Language] = ...
    HeardAndMcDonaldIslands: typing.ClassVar[QLocale.Country] = ...
    Hebrew: typing.ClassVar[QLocale.Language] = ...
    HebrewScript: typing.ClassVar[QLocale.Script] = ...
    Herero: typing.ClassVar[QLocale.Language] = ...
    HieroglyphicLuwian: typing.ClassVar[QLocale.Language] = ...
    Hindi: typing.ClassVar[QLocale.Language] = ...
    HiraganaScript: typing.ClassVar[QLocale.Script] = ...
    HiriMotu: typing.ClassVar[QLocale.Language] = ...
    HmongNjua: typing.ClassVar[QLocale.Language] = ...
    Ho: typing.ClassVar[QLocale.Language] = ...
    Honduras: typing.ClassVar[QLocale.Country] = ...
    HongKong: typing.ClassVar[QLocale.Country] = ...
    Hungarian: typing.ClassVar[QLocale.Language] = ...
    Hungary: typing.ClassVar[QLocale.Country] = ...
    Iceland: typing.ClassVar[QLocale.Country] = ...
    Icelandic: typing.ClassVar[QLocale.Language] = ...
    Ido: typing.ClassVar[QLocale.Language] = ...
    Igbo: typing.ClassVar[QLocale.Language] = ...
    ImperialAramaicScript: typing.ClassVar[QLocale.Script] = ...
    ImperialSystem: typing.ClassVar[QLocale.MeasurementSystem] = ...
    ImperialUKSystem: typing.ClassVar[QLocale.MeasurementSystem] = ...
    ImperialUSSystem: typing.ClassVar[QLocale.MeasurementSystem] = ...
    InariSami: typing.ClassVar[QLocale.Language] = ...
    IncludeTrailingZeroesAfterDot: typing.ClassVar[QLocale.NumberOption] = ...
    India: typing.ClassVar[QLocale.Country] = ...
    Indonesia: typing.ClassVar[QLocale.Country] = ...
    Indonesian: typing.ClassVar[QLocale.Language] = ...
    Ingush: typing.ClassVar[QLocale.Language] = ...
    InscriptionalPahlaviScript: typing.ClassVar[QLocale.Script] = ...
    InscriptionalParthianScript: typing.ClassVar[QLocale.Script] = ...
    Interlingua: typing.ClassVar[QLocale.Language] = ...
    Interlingue: typing.ClassVar[QLocale.Language] = ...
    Inuktitut: typing.ClassVar[QLocale.Language] = ...
    Inupiak: typing.ClassVar[QLocale.Language] = ...
    Iran: typing.ClassVar[QLocale.Country] = ...
    Iraq: typing.ClassVar[QLocale.Country] = ...
    Ireland: typing.ClassVar[QLocale.Country] = ...
    Irish: typing.ClassVar[QLocale.Language] = ...
    IsleOfMan: typing.ClassVar[QLocale.Country] = ...
    Israel: typing.ClassVar[QLocale.Country] = ...
    Italian: typing.ClassVar[QLocale.Language] = ...
    Italy: typing.ClassVar[QLocale.Country] = ...
    IvoryCoast: typing.ClassVar[QLocale.Country] = ...
    Jamaica: typing.ClassVar[QLocale.Country] = ...
    JamoScript: typing.ClassVar[QLocale.Script] = ...
    Japan: typing.ClassVar[QLocale.Country] = ...
    Japanese: typing.ClassVar[QLocale.Language] = ...
    JapaneseScript: typing.ClassVar[QLocale.Script] = ...
    Javanese: typing.ClassVar[QLocale.Language] = ...
    JavaneseScript: typing.ClassVar[QLocale.Script] = ...
    Jersey: typing.ClassVar[QLocale.Country] = ...
    Jju: typing.ClassVar[QLocale.Language] = ...
    JolaFonyi: typing.ClassVar[QLocale.Language] = ...
    Jordan: typing.ClassVar[QLocale.Country] = ...
    Kabuverdianu: typing.ClassVar[QLocale.Language] = ...
    Kabyle: typing.ClassVar[QLocale.Language] = ...
    KaithiScript: typing.ClassVar[QLocale.Script] = ...
    Kako: typing.ClassVar[QLocale.Language] = ...
    Kalenjin: typing.ClassVar[QLocale.Language] = ...
    Kamba: typing.ClassVar[QLocale.Language] = ...
    Kannada: typing.ClassVar[QLocale.Language] = ...
    KannadaScript: typing.ClassVar[QLocale.Script] = ...
    Kanuri: typing.ClassVar[QLocale.Language] = ...
    Kashmiri: typing.ClassVar[QLocale.Language] = ...
    KatakanaScript: typing.ClassVar[QLocale.Script] = ...
    KayahLiScript: typing.ClassVar[QLocale.Script] = ...
    Kazakh: typing.ClassVar[QLocale.Language] = ...
    Kazakhstan: typing.ClassVar[QLocale.Country] = ...
    Kenya: typing.ClassVar[QLocale.Country] = ...
    Kenyang: typing.ClassVar[QLocale.Language] = ...
    KharoshthiScript: typing.ClassVar[QLocale.Script] = ...
    Khmer: typing.ClassVar[QLocale.Language] = ...
    KhmerScript: typing.ClassVar[QLocale.Script] = ...
    KhojkiScript: typing.ClassVar[QLocale.Script] = ...
    KhudawadiScript: typing.ClassVar[QLocale.Script] = ...
    Kiche: typing.ClassVar[QLocale.Language] = ...
    Kikuyu: typing.ClassVar[QLocale.Language] = ...
    Kinyarwanda: typing.ClassVar[QLocale.Language] = ...
    Kirghiz: typing.ClassVar[QLocale.Language] = ...
    Kiribati: typing.ClassVar[QLocale.Country] = ...
    Komi: typing.ClassVar[QLocale.Language] = ...
    Kongo: typing.ClassVar[QLocale.Language] = ...
    Konkani: typing.ClassVar[QLocale.Language] = ...
    Korean: typing.ClassVar[QLocale.Language] = ...
    KoreanScript: typing.ClassVar[QLocale.Script] = ...
    Koro: typing.ClassVar[QLocale.Language] = ...
    Kosovo: typing.ClassVar[QLocale.Country] = ...
    KoyraChiini: typing.ClassVar[QLocale.Language] = ...
    KoyraboroSenni: typing.ClassVar[QLocale.Language] = ...
    Kpelle: typing.ClassVar[QLocale.Language] = ...
    Kurdish: typing.ClassVar[QLocale.Language] = ...
    Kurundi: typing.ClassVar[QLocale.Language] = ...
    Kuwait: typing.ClassVar[QLocale.Country] = ...
    Kwanyama: typing.ClassVar[QLocale.Language] = ...
    Kwasio: typing.ClassVar[QLocale.Language] = ...
    Kyrgyzstan: typing.ClassVar[QLocale.Country] = ...
    Lakota: typing.ClassVar[QLocale.Language] = ...
    Langi: typing.ClassVar[QLocale.Language] = ...
    LannaScript: typing.ClassVar[QLocale.Script] = ...
    Lao: typing.ClassVar[QLocale.Language] = ...
    LaoScript: typing.ClassVar[QLocale.Script] = ...
    Laos: typing.ClassVar[QLocale.Country] = ...
    LargeFloweryMiao: typing.ClassVar[QLocale.Language] = ...
    LastCountry: typing.ClassVar[QLocale.Country] = ...
    LastLanguage: typing.ClassVar[QLocale.Language] = ...
    LastScript: typing.ClassVar[QLocale.Script] = ...
    Latin: typing.ClassVar[QLocale.Language] = ...
    LatinAmerica: typing.ClassVar[QLocale.Country] = ...
    LatinAmericaAndTheCaribbean: typing.ClassVar[QLocale.Country] = ...
    LatinScript: typing.ClassVar[QLocale.Script] = ...
    Latvia: typing.ClassVar[QLocale.Country] = ...
    Latvian: typing.ClassVar[QLocale.Language] = ...
    Lebanon: typing.ClassVar[QLocale.Country] = ...
    Lepcha: typing.ClassVar[QLocale.Language] = ...
    LepchaScript: typing.ClassVar[QLocale.Script] = ...
    Lesotho: typing.ClassVar[QLocale.Country] = ...
    Lezghian: typing.ClassVar[QLocale.Language] = ...
    Liberia: typing.ClassVar[QLocale.Country] = ...
    Libya: typing.ClassVar[QLocale.Country] = ...
    Liechtenstein: typing.ClassVar[QLocale.Country] = ...
    Limbu: typing.ClassVar[QLocale.Language] = ...
    LimbuScript: typing.ClassVar[QLocale.Script] = ...
    Limburgish: typing.ClassVar[QLocale.Language] = ...
    LinearA: typing.ClassVar[QLocale.Language] = ...
    LinearAScript: typing.ClassVar[QLocale.Script] = ...
    LinearBScript: typing.ClassVar[QLocale.Script] = ...
    Lingala: typing.ClassVar[QLocale.Language] = ...
    Lisu: typing.ClassVar[QLocale.Language] = ...
    LiteraryChinese: typing.ClassVar[QLocale.Language] = ...
    Lithuania: typing.ClassVar[QLocale.Country] = ...
    Lithuanian: typing.ClassVar[QLocale.Language] = ...
    Lojban: typing.ClassVar[QLocale.Language] = ...
    LongFormat: typing.ClassVar[QLocale.FormatType] = ...
    LowGerman: typing.ClassVar[QLocale.Language] = ...
    LowerSorbian: typing.ClassVar[QLocale.Language] = ...
    Lu: typing.ClassVar[QLocale.Language] = ...
    LubaKatanga: typing.ClassVar[QLocale.Language] = ...
    LuleSami: typing.ClassVar[QLocale.Language] = ...
    Luo: typing.ClassVar[QLocale.Language] = ...
    Luxembourg: typing.ClassVar[QLocale.Country] = ...
    Luxembourgish: typing.ClassVar[QLocale.Language] = ...
    Luyia: typing.ClassVar[QLocale.Language] = ...
    Lycian: typing.ClassVar[QLocale.Language] = ...
    LycianScript: typing.ClassVar[QLocale.Script] = ...
    Lydian: typing.ClassVar[QLocale.Language] = ...
    LydianScript: typing.ClassVar[QLocale.Script] = ...
    Macau: typing.ClassVar[QLocale.Country] = ...
    Macedonia: typing.ClassVar[QLocale.Country] = ...
    Macedonian: typing.ClassVar[QLocale.Language] = ...
    Machame: typing.ClassVar[QLocale.Language] = ...
    Madagascar: typing.ClassVar[QLocale.Country] = ...
    MahajaniScript: typing.ClassVar[QLocale.Script] = ...
    Maithili: typing.ClassVar[QLocale.Language] = ...
    MakhuwaMeetto: typing.ClassVar[QLocale.Language] = ...
    Makonde: typing.ClassVar[QLocale.Language] = ...
    Malagasy: typing.ClassVar[QLocale.Language] = ...
    Malawi: typing.ClassVar[QLocale.Country] = ...
    Malay: typing.ClassVar[QLocale.Language] = ...
    Malayalam: typing.ClassVar[QLocale.Language] = ...
    MalayalamScript: typing.ClassVar[QLocale.Script] = ...
    Malaysia: typing.ClassVar[QLocale.Country] = ...
    Maldives: typing.ClassVar[QLocale.Country] = ...
    Mali: typing.ClassVar[QLocale.Country] = ...
    Malta: typing.ClassVar[QLocale.Country] = ...
    Maltese: typing.ClassVar[QLocale.Language] = ...
    MandaeanScript: typing.ClassVar[QLocale.Script] = ...
    Mandingo: typing.ClassVar[QLocale.Language] = ...
    ManichaeanMiddlePersian: typing.ClassVar[QLocale.Language] = ...
    ManichaeanScript: typing.ClassVar[QLocale.Script] = ...
    Manipuri: typing.ClassVar[QLocale.Language] = ...
    Manx: typing.ClassVar[QLocale.Language] = ...
    Maori: typing.ClassVar[QLocale.Language] = ...
    Mapuche: typing.ClassVar[QLocale.Language] = ...
    Marathi: typing.ClassVar[QLocale.Language] = ...
    MarchenScript: typing.ClassVar[QLocale.Script] = ...
    MarshallIslands: typing.ClassVar[QLocale.Country] = ...
    Marshallese: typing.ClassVar[QLocale.Language] = ...
    Martinique: typing.ClassVar[QLocale.Country] = ...
    Masai: typing.ClassVar[QLocale.Language] = ...
    Mauritania: typing.ClassVar[QLocale.Country] = ...
    Mauritius: typing.ClassVar[QLocale.Country] = ...
    Mayotte: typing.ClassVar[QLocale.Country] = ...
    Mazanderani: typing.ClassVar[QLocale.Language] = ...
    MeiteiMayekScript: typing.ClassVar[QLocale.Script] = ...
    Mende: typing.ClassVar[QLocale.Language] = ...
    MendeKikakuiScript: typing.ClassVar[QLocale.Script] = ...
    Meroitic: typing.ClassVar[QLocale.Language] = ...
    MeroiticCursiveScript: typing.ClassVar[QLocale.Script] = ...
    MeroiticScript: typing.ClassVar[QLocale.Script] = ...
    Meru: typing.ClassVar[QLocale.Language] = ...
    Meta: typing.ClassVar[QLocale.Language] = ...
    MetricSystem: typing.ClassVar[QLocale.MeasurementSystem] = ...
    Mexico: typing.ClassVar[QLocale.Country] = ...
    Micronesia: typing.ClassVar[QLocale.Country] = ...
    ModiScript: typing.ClassVar[QLocale.Script] = ...
    Mohawk: typing.ClassVar[QLocale.Language] = ...
    Moldavian: typing.ClassVar[QLocale.Language] = ...
    Moldova: typing.ClassVar[QLocale.Country] = ...
    Monaco: typing.ClassVar[QLocale.Country] = ...
    Mongolia: typing.ClassVar[QLocale.Country] = ...
    Mongolian: typing.ClassVar[QLocale.Language] = ...
    MongolianScript: typing.ClassVar[QLocale.Script] = ...
    Mono: typing.ClassVar[QLocale.Language] = ...
    Montenegro: typing.ClassVar[QLocale.Country] = ...
    Montserrat: typing.ClassVar[QLocale.Country] = ...
    Morisyen: typing.ClassVar[QLocale.Language] = ...
    Morocco: typing.ClassVar[QLocale.Country] = ...
    Mozambique: typing.ClassVar[QLocale.Country] = ...
    MroScript: typing.ClassVar[QLocale.Script] = ...
    Mru: typing.ClassVar[QLocale.Language] = ...
    MultaniScript: typing.ClassVar[QLocale.Script] = ...
    Mundang: typing.ClassVar[QLocale.Language] = ...
    Muscogee: typing.ClassVar[QLocale.Language] = ...
    Myanmar: typing.ClassVar[QLocale.Country] = ...
    MyanmarScript: typing.ClassVar[QLocale.Script] = ...
    NabataeanScript: typing.ClassVar[QLocale.Script] = ...
    Nama: typing.ClassVar[QLocale.Language] = ...
    Namibia: typing.ClassVar[QLocale.Country] = ...
    NarrowFormat: typing.ClassVar[QLocale.FormatType] = ...
    NauruCountry: typing.ClassVar[QLocale.Country] = ...
    NauruLanguage: typing.ClassVar[QLocale.Language] = ...
    Navaho: typing.ClassVar[QLocale.Language] = ...
    Ndonga: typing.ClassVar[QLocale.Language] = ...
    Nepal: typing.ClassVar[QLocale.Country] = ...
    Nepali: typing.ClassVar[QLocale.Language] = ...
    Netherlands: typing.ClassVar[QLocale.Country] = ...
    NewCaledonia: typing.ClassVar[QLocale.Country] = ...
    NewTaiLueScript: typing.ClassVar[QLocale.Script] = ...
    NewZealand: typing.ClassVar[QLocale.Country] = ...
    NewaScript: typing.ClassVar[QLocale.Script] = ...
    Newari: typing.ClassVar[QLocale.Language] = ...
    Ngiemboon: typing.ClassVar[QLocale.Language] = ...
    Ngomba: typing.ClassVar[QLocale.Language] = ...
    Nicaragua: typing.ClassVar[QLocale.Country] = ...
    Niger: typing.ClassVar[QLocale.Country] = ...
    Nigeria: typing.ClassVar[QLocale.Country] = ...
    NigerianPidgin: typing.ClassVar[QLocale.Language] = ...
    Niue: typing.ClassVar[QLocale.Country] = ...
    Nko: typing.ClassVar[QLocale.Language] = ...
    NkoScript: typing.ClassVar[QLocale.Script] = ...
    NorfolkIsland: typing.ClassVar[QLocale.Country] = ...
    NorthKorea: typing.ClassVar[QLocale.Country] = ...
    NorthNdebele: typing.ClassVar[QLocale.Language] = ...
    NorthernLuri: typing.ClassVar[QLocale.Language] = ...
    NorthernMarianaIslands: typing.ClassVar[QLocale.Country] = ...
    NorthernSami: typing.ClassVar[QLocale.Language] = ...
    NorthernSotho: typing.ClassVar[QLocale.Language] = ...
    NorthernThai: typing.ClassVar[QLocale.Language] = ...
    Norway: typing.ClassVar[QLocale.Country] = ...
    Norwegian: typing.ClassVar[QLocale.Language] = ...
    NorwegianBokmal: typing.ClassVar[QLocale.Language] = ...
    NorwegianNynorsk: typing.ClassVar[QLocale.Language] = ...
    Nuer: typing.ClassVar[QLocale.Language] = ...
    Nyanja: typing.ClassVar[QLocale.Language] = ...
    Nyankole: typing.ClassVar[QLocale.Language] = ...
    Occitan: typing.ClassVar[QLocale.Language] = ...
    OghamScript: typing.ClassVar[QLocale.Script] = ...
    Ojibwa: typing.ClassVar[QLocale.Language] = ...
    OlChikiScript: typing.ClassVar[QLocale.Script] = ...
    OldHungarianScript: typing.ClassVar[QLocale.Script] = ...
    OldIrish: typing.ClassVar[QLocale.Language] = ...
    OldItalicScript: typing.ClassVar[QLocale.Script] = ...
    OldNorse: typing.ClassVar[QLocale.Language] = ...
    OldNorthArabianScript: typing.ClassVar[QLocale.Script] = ...
    OldPermicScript: typing.ClassVar[QLocale.Script] = ...
    OldPersian: typing.ClassVar[QLocale.Language] = ...
    OldPersianScript: typing.ClassVar[QLocale.Script] = ...
    OldSouthArabianScript: typing.ClassVar[QLocale.Script] = ...
    OldTurkish: typing.ClassVar[QLocale.Language] = ...
    Oman: typing.ClassVar[QLocale.Country] = ...
    OmitGroupSeparator: typing.ClassVar[QLocale.NumberOption] = ...
    OmitLeadingZeroInExponent: typing.ClassVar[QLocale.NumberOption] = ...
    Oriya: typing.ClassVar[QLocale.Language] = ...
    OriyaScript: typing.ClassVar[QLocale.Script] = ...
    OrkhonScript: typing.ClassVar[QLocale.Script] = ...
    Oromo: typing.ClassVar[QLocale.Language] = ...
    Osage: typing.ClassVar[QLocale.Language] = ...
    OsageScript: typing.ClassVar[QLocale.Script] = ...
    OsmanyaScript: typing.ClassVar[QLocale.Script] = ...
    Ossetic: typing.ClassVar[QLocale.Language] = ...
    OutlyingOceania: typing.ClassVar[QLocale.Country] = ...
    PahawhHmongScript: typing.ClassVar[QLocale.Script] = ...
    Pahlavi: typing.ClassVar[QLocale.Language] = ...
    Pakistan: typing.ClassVar[QLocale.Country] = ...
    Palau: typing.ClassVar[QLocale.Country] = ...
    Palauan: typing.ClassVar[QLocale.Language] = ...
    PalestinianTerritories: typing.ClassVar[QLocale.Country] = ...
    Pali: typing.ClassVar[QLocale.Language] = ...
    PalmyreneScript: typing.ClassVar[QLocale.Script] = ...
    Panama: typing.ClassVar[QLocale.Country] = ...
    Papiamento: typing.ClassVar[QLocale.Language] = ...
    PapuaNewGuinea: typing.ClassVar[QLocale.Country] = ...
    Paraguay: typing.ClassVar[QLocale.Country] = ...
    Parthian: typing.ClassVar[QLocale.Language] = ...
    Pashto: typing.ClassVar[QLocale.Language] = ...
    PauCinHauScript: typing.ClassVar[QLocale.Script] = ...
    PeoplesRepublicOfCongo: typing.ClassVar[QLocale.Country] = ...
    Persian: typing.ClassVar[QLocale.Language] = ...
    Peru: typing.ClassVar[QLocale.Country] = ...
    PhagsPaScript: typing.ClassVar[QLocale.Script] = ...
    Philippines: typing.ClassVar[QLocale.Country] = ...
    Phoenician: typing.ClassVar[QLocale.Language] = ...
    PhoenicianScript: typing.ClassVar[QLocale.Script] = ...
    Pitcairn: typing.ClassVar[QLocale.Country] = ...
    Poland: typing.ClassVar[QLocale.Country] = ...
    Polish: typing.ClassVar[QLocale.Language] = ...
    PollardPhoneticScript: typing.ClassVar[QLocale.Script] = ...
    Portugal: typing.ClassVar[QLocale.Country] = ...
    Portuguese: typing.ClassVar[QLocale.Language] = ...
    PrakritLanguage: typing.ClassVar[QLocale.Language] = ...
    Prussian: typing.ClassVar[QLocale.Language] = ...
    PsalterPahlaviScript: typing.ClassVar[QLocale.Script] = ...
    PuertoRico: typing.ClassVar[QLocale.Country] = ...
    Punjabi: typing.ClassVar[QLocale.Language] = ...
    Qatar: typing.ClassVar[QLocale.Country] = ...
    Quechua: typing.ClassVar[QLocale.Language] = ...
    Rejang: typing.ClassVar[QLocale.Language] = ...
    RejangScript: typing.ClassVar[QLocale.Script] = ...
    RejectGroupSeparator: typing.ClassVar[QLocale.NumberOption] = ...
    RejectLeadingZeroInExponent: typing.ClassVar[QLocale.NumberOption] = ...
    RejectTrailingZeroesAfterDot: typing.ClassVar[QLocale.NumberOption] = ...
    RepublicOfKorea: typing.ClassVar[QLocale.Country] = ...
    Reunion: typing.ClassVar[QLocale.Country] = ...
    RhaetoRomance: typing.ClassVar[QLocale.Language] = ...
    Romania: typing.ClassVar[QLocale.Country] = ...
    Romanian: typing.ClassVar[QLocale.Language] = ...
    Romansh: typing.ClassVar[QLocale.Language] = ...
    Rombo: typing.ClassVar[QLocale.Language] = ...
    Rundi: typing.ClassVar[QLocale.Language] = ...
    RunicScript: typing.ClassVar[QLocale.Script] = ...
    Russia: typing.ClassVar[QLocale.Country] = ...
    Russian: typing.ClassVar[QLocale.Language] = ...
    RussianFederation: typing.ClassVar[QLocale.Country] = ...
    Rwa: typing.ClassVar[QLocale.Language] = ...
    Rwanda: typing.ClassVar[QLocale.Country] = ...
    Sabaean: typing.ClassVar[QLocale.Language] = ...
    Saho: typing.ClassVar[QLocale.Language] = ...
    SaintBarthelemy: typing.ClassVar[QLocale.Country] = ...
    SaintHelena: typing.ClassVar[QLocale.Country] = ...
    SaintKittsAndNevis: typing.ClassVar[QLocale.Country] = ...
    SaintLucia: typing.ClassVar[QLocale.Country] = ...
    SaintMartin: typing.ClassVar[QLocale.Country] = ...
    SaintPierreAndMiquelon: typing.ClassVar[QLocale.Country] = ...
    SaintVincentAndTheGrenadines: typing.ClassVar[QLocale.Country] = ...
    Sakha: typing.ClassVar[QLocale.Language] = ...
    Samaritan: typing.ClassVar[QLocale.Language] = ...
    SamaritanScript: typing.ClassVar[QLocale.Script] = ...
    Samburu: typing.ClassVar[QLocale.Language] = ...
    Samoa: typing.ClassVar[QLocale.Country] = ...
    Samoan: typing.ClassVar[QLocale.Language] = ...
    SanMarino: typing.ClassVar[QLocale.Country] = ...
    Sango: typing.ClassVar[QLocale.Language] = ...
    Sangu: typing.ClassVar[QLocale.Language] = ...
    Sanskrit: typing.ClassVar[QLocale.Language] = ...
    Santali: typing.ClassVar[QLocale.Language] = ...
    SaoTomeAndPrincipe: typing.ClassVar[QLocale.Country] = ...
    Saraiki: typing.ClassVar[QLocale.Language] = ...
    Sardinian: typing.ClassVar[QLocale.Language] = ...
    SaudiArabia: typing.ClassVar[QLocale.Country] = ...
    Saurashtra: typing.ClassVar[QLocale.Language] = ...
    SaurashtraScript: typing.ClassVar[QLocale.Script] = ...
    Sena: typing.ClassVar[QLocale.Language] = ...
    Senegal: typing.ClassVar[QLocale.Country] = ...
    Serbia: typing.ClassVar[QLocale.Country] = ...
    Serbian: typing.ClassVar[QLocale.Language] = ...
    SerboCroatian: typing.ClassVar[QLocale.Language] = ...
    Seychelles: typing.ClassVar[QLocale.Country] = ...
    Shambala: typing.ClassVar[QLocale.Language] = ...
    SharadaScript: typing.ClassVar[QLocale.Script] = ...
    ShavianScript: typing.ClassVar[QLocale.Script] = ...
    Shona: typing.ClassVar[QLocale.Language] = ...
    ShortFormat: typing.ClassVar[QLocale.FormatType] = ...
    SichuanYi: typing.ClassVar[QLocale.Language] = ...
    Sicilian: typing.ClassVar[QLocale.Language] = ...
    Sidamo: typing.ClassVar[QLocale.Language] = ...
    SiddhamScript: typing.ClassVar[QLocale.Script] = ...
    SierraLeone: typing.ClassVar[QLocale.Country] = ...
    SignWritingScript: typing.ClassVar[QLocale.Script] = ...
    Silesian: typing.ClassVar[QLocale.Language] = ...
    SimplifiedChineseScript: typing.ClassVar[QLocale.Script] = ...
    SimplifiedHanScript: typing.ClassVar[QLocale.Script] = ...
    Sindhi: typing.ClassVar[QLocale.Language] = ...
    Singapore: typing.ClassVar[QLocale.Country] = ...
    Sinhala: typing.ClassVar[QLocale.Language] = ...
    SinhalaScript: typing.ClassVar[QLocale.Script] = ...
    SintMaarten: typing.ClassVar[QLocale.Country] = ...
    SkoltSami: typing.ClassVar[QLocale.Language] = ...
    Slovak: typing.ClassVar[QLocale.Language] = ...
    Slovakia: typing.ClassVar[QLocale.Country] = ...
    Slovenia: typing.ClassVar[QLocale.Country] = ...
    Slovenian: typing.ClassVar[QLocale.Language] = ...
    Soga: typing.ClassVar[QLocale.Language] = ...
    SolomonIslands: typing.ClassVar[QLocale.Country] = ...
    Somali: typing.ClassVar[QLocale.Language] = ...
    Somalia: typing.ClassVar[QLocale.Country] = ...
    Sora: typing.ClassVar[QLocale.Language] = ...
    SoraSompengScript: typing.ClassVar[QLocale.Script] = ...
    SouthAfrica: typing.ClassVar[QLocale.Country] = ...
    SouthGeorgiaAndTheSouthSandwichIslands: typing.ClassVar[QLocale.Country] = ...
    SouthKorea: typing.ClassVar[QLocale.Country] = ...
    SouthNdebele: typing.ClassVar[QLocale.Language] = ...
    SouthSudan: typing.ClassVar[QLocale.Country] = ...
    SouthernKurdish: typing.ClassVar[QLocale.Language] = ...
    SouthernSami: typing.ClassVar[QLocale.Language] = ...
    SouthernSotho: typing.ClassVar[QLocale.Language] = ...
    Spain: typing.ClassVar[QLocale.Country] = ...
    Spanish: typing.ClassVar[QLocale.Language] = ...
    SriLanka: typing.ClassVar[QLocale.Country] = ...
    StandardMoroccanTamazight: typing.ClassVar[QLocale.Language] = ...
    StandardQuotation: typing.ClassVar[QLocale.QuotationStyle] = ...
    Sudan: typing.ClassVar[QLocale.Country] = ...
    Sundanese: typing.ClassVar[QLocale.Language] = ...
    SundaneseScript: typing.ClassVar[QLocale.Script] = ...
    Suriname: typing.ClassVar[QLocale.Country] = ...
    SvalbardAndJanMayenIslands: typing.ClassVar[QLocale.Country] = ...
    Swahili: typing.ClassVar[QLocale.Language] = ...
    Swati: typing.ClassVar[QLocale.Language] = ...
    Swaziland: typing.ClassVar[QLocale.Country] = ...
    Sweden: typing.ClassVar[QLocale.Country] = ...
    Swedish: typing.ClassVar[QLocale.Language] = ...
    SwissGerman: typing.ClassVar[QLocale.Language] = ...
    Switzerland: typing.ClassVar[QLocale.Country] = ...
    Sylheti: typing.ClassVar[QLocale.Language] = ...
    SylotiNagriScript: typing.ClassVar[QLocale.Script] = ...
    Syria: typing.ClassVar[QLocale.Country] = ...
    Syriac: typing.ClassVar[QLocale.Language] = ...
    SyriacScript: typing.ClassVar[QLocale.Script] = ...
    SyrianArabRepublic: typing.ClassVar[QLocale.Country] = ...
    Tachelhit: typing.ClassVar[QLocale.Language] = ...
    Tagalog: typing.ClassVar[QLocale.Language] = ...
    TagalogScript: typing.ClassVar[QLocale.Script] = ...
    Tagbanwa: typing.ClassVar[QLocale.Language] = ...
    TagbanwaScript: typing.ClassVar[QLocale.Script] = ...
    Tahitian: typing.ClassVar[QLocale.Language] = ...
    TaiDam: typing.ClassVar[QLocale.Language] = ...
    TaiLeScript: typing.ClassVar[QLocale.Script] = ...
    TaiNua: typing.ClassVar[QLocale.Language] = ...
    TaiVietScript: typing.ClassVar[QLocale.Script] = ...
    Taita: typing.ClassVar[QLocale.Language] = ...
    Taiwan: typing.ClassVar[QLocale.Country] = ...
    Tajik: typing.ClassVar[QLocale.Language] = ...
    Tajikistan: typing.ClassVar[QLocale.Country] = ...
    TakriScript: typing.ClassVar[QLocale.Script] = ...
    Tamil: typing.ClassVar[QLocale.Language] = ...
    TamilScript: typing.ClassVar[QLocale.Script] = ...
    Tangut: typing.ClassVar[QLocale.Language] = ...
    TangutScript: typing.ClassVar[QLocale.Script] = ...
    Tanzania: typing.ClassVar[QLocale.Country] = ...
    Taroko: typing.ClassVar[QLocale.Language] = ...
    Tasawaq: typing.ClassVar[QLocale.Language] = ...
    Tatar: typing.ClassVar[QLocale.Language] = ...
    TedimChin: typing.ClassVar[QLocale.Language] = ...
    Telugu: typing.ClassVar[QLocale.Language] = ...
    TeluguScript: typing.ClassVar[QLocale.Script] = ...
    Teso: typing.ClassVar[QLocale.Language] = ...
    ThaanaScript: typing.ClassVar[QLocale.Script] = ...
    Thai: typing.ClassVar[QLocale.Language] = ...
    ThaiScript: typing.ClassVar[QLocale.Script] = ...
    Thailand: typing.ClassVar[QLocale.Country] = ...
    Tibetan: typing.ClassVar[QLocale.Language] = ...
    TibetanScript: typing.ClassVar[QLocale.Script] = ...
    TifinaghScript: typing.ClassVar[QLocale.Script] = ...
    Tigre: typing.ClassVar[QLocale.Language] = ...
    Tigrinya: typing.ClassVar[QLocale.Language] = ...
    TirhutaScript: typing.ClassVar[QLocale.Script] = ...
    Togo: typing.ClassVar[QLocale.Country] = ...
    TokPisin: typing.ClassVar[QLocale.Language] = ...
    Tokelau: typing.ClassVar[QLocale.Country] = ...
    TokelauCountry: typing.ClassVar[QLocale.Country] = ...
    TokelauLanguage: typing.ClassVar[QLocale.Language] = ...
    Tonga: typing.ClassVar[QLocale.Country] = ...
    Tongan: typing.ClassVar[QLocale.Language] = ...
    TraditionalChineseScript: typing.ClassVar[QLocale.Script] = ...
    TraditionalHanScript: typing.ClassVar[QLocale.Script] = ...
    TrinidadAndTobago: typing.ClassVar[QLocale.Country] = ...
    TristanDaCunha: typing.ClassVar[QLocale.Country] = ...
    Tsonga: typing.ClassVar[QLocale.Language] = ...
    Tswana: typing.ClassVar[QLocale.Language] = ...
    Tunisia: typing.ClassVar[QLocale.Country] = ...
    Turkey: typing.ClassVar[QLocale.Country] = ...
    Turkish: typing.ClassVar[QLocale.Language] = ...
    Turkmen: typing.ClassVar[QLocale.Language] = ...
    Turkmenistan: typing.ClassVar[QLocale.Country] = ...
    TurksAndCaicosIslands: typing.ClassVar[QLocale.Country] = ...
    Tuvalu: typing.ClassVar[QLocale.Country] = ...
    TuvaluCountry: typing.ClassVar[QLocale.Country] = ...
    TuvaluLanguage: typing.ClassVar[QLocale.Language] = ...
    Twi: typing.ClassVar[QLocale.Language] = ...
    Tyap: typing.ClassVar[QLocale.Language] = ...
    Uganda: typing.ClassVar[QLocale.Country] = ...
    Ugaritic: typing.ClassVar[QLocale.Language] = ...
    UgariticScript: typing.ClassVar[QLocale.Script] = ...
    Uighur: typing.ClassVar[QLocale.Language] = ...
    Uigur: typing.ClassVar[QLocale.Language] = ...
    Ukraine: typing.ClassVar[QLocale.Country] = ...
    Ukrainian: typing.ClassVar[QLocale.Language] = ...
    UncodedLanguages: typing.ClassVar[QLocale.Language] = ...
    UnitedArabEmirates: typing.ClassVar[QLocale.Country] = ...
    UnitedKingdom: typing.ClassVar[QLocale.Country] = ...
    UnitedStates: typing.ClassVar[QLocale.Country] = ...
    UnitedStatesMinorOutlyingIslands: typing.ClassVar[QLocale.Country] = ...
    UnitedStatesVirginIslands: typing.ClassVar[QLocale.Country] = ...
    UpperSorbian: typing.ClassVar[QLocale.Language] = ...
    Urdu: typing.ClassVar[QLocale.Language] = ...
    Uruguay: typing.ClassVar[QLocale.Country] = ...
    Uzbek: typing.ClassVar[QLocale.Language] = ...
    Uzbekistan: typing.ClassVar[QLocale.Country] = ...
    Vai: typing.ClassVar[QLocale.Language] = ...
    VaiScript: typing.ClassVar[QLocale.Script] = ...
    Vanuatu: typing.ClassVar[QLocale.Country] = ...
    VarangKshitiScript: typing.ClassVar[QLocale.Script] = ...
    VaticanCityState: typing.ClassVar[QLocale.Country] = ...
    Venda: typing.ClassVar[QLocale.Language] = ...
    Venezuela: typing.ClassVar[QLocale.Country] = ...
    Vietnam: typing.ClassVar[QLocale.Country] = ...
    Vietnamese: typing.ClassVar[QLocale.Language] = ...
    Volapuk: typing.ClassVar[QLocale.Language] = ...
    Vunjo: typing.ClassVar[QLocale.Language] = ...
    Walamo: typing.ClassVar[QLocale.Language] = ...
    WallisAndFutunaIslands: typing.ClassVar[QLocale.Country] = ...
    Walloon: typing.ClassVar[QLocale.Language] = ...
    Walser: typing.ClassVar[QLocale.Language] = ...
    Warlpiri: typing.ClassVar[QLocale.Language] = ...
    Welsh: typing.ClassVar[QLocale.Language] = ...
    WesternBalochi: typing.ClassVar[QLocale.Language] = ...
    WesternFrisian: typing.ClassVar[QLocale.Language] = ...
    WesternSahara: typing.ClassVar[QLocale.Country] = ...
    Wolof: typing.ClassVar[QLocale.Language] = ...
    World: typing.ClassVar[QLocale.Country] = ...
    Xhosa: typing.ClassVar[QLocale.Language] = ...
    Yangben: typing.ClassVar[QLocale.Language] = ...
    Yemen: typing.ClassVar[QLocale.Country] = ...
    YiScript: typing.ClassVar[QLocale.Script] = ...
    Yiddish: typing.ClassVar[QLocale.Language] = ...
    Yoruba: typing.ClassVar[QLocale.Language] = ...
    Zambia: typing.ClassVar[QLocale.Country] = ...
    Zarma: typing.ClassVar[QLocale.Language] = ...
    Zhuang: typing.ClassVar[QLocale.Language] = ...
    Zimbabwe: typing.ClassVar[QLocale.Country] = ...
    Zulu: typing.ClassVar[QLocale.Language] = ...
    @overload
    def __init__(self, language: QLocale.Language, script: QLocale.Script, country: QLocale.Country) -> None: ...
    @overload
    def __init__(self, language: QLocale.Language, country: QLocale.Country = ...) -> None: ...
    @overload
    def __init__(self, name: str) -> None: ...
    @overload
    def __init__(self, other: QLocale) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def amText(self) -> str: ...
    def bcp47Name(self) -> str: ...
    @classmethod
    def c(cls) -> QLocale: ...
    def collation(self) -> QLocale: ...
    @classmethod
    def countriesForLanguage(cls, lang: QLocale.Language) -> typing.List[QLocale.Country]: ...
    def country(self) -> QLocale.Country: ...
    @classmethod
    def countryToString(cls, country: QLocale.Country) -> str: ...
    def createSeparatedList(self, strl: typing.Iterable[str]) -> str: ...
    def currencySymbol(self, arg__1: QLocale.CurrencySymbolFormat = ...) -> str: ...
    def dateFormat(self, format: QLocale.FormatType = ...) -> str: ...
    def dateTimeFormat(self, format: QLocale.FormatType = ...) -> str: ...
    def dayName(self, arg__1: int, format: QLocale.FormatType = ...) -> str: ...
    def decimalPoint(self) -> str: ...
    def exponential(self) -> str: ...
    def firstDayOfWeek(self) -> Qt.DayOfWeek: ...
    def formattedDataSize(self, bytes: int, precision: int = ..., format: typing.Union[QLocale.DataSizeFormats,QLocale.DataSizeFormat] = ...) -> str: ...
    def groupSeparator(self) -> str: ...
    def language(self) -> QLocale.Language: ...
    @classmethod
    def languageToString(cls, language: QLocale.Language) -> str: ...
    @classmethod
    def matchingLocales(cls, language: QLocale.Language, script: QLocale.Script, country: QLocale.Country) -> typing.List[QLocale]: ...
    def measurementSystem(self) -> QLocale.MeasurementSystem: ...
    def monthName(self, arg__1: int, format: QLocale.FormatType = ...) -> str: ...
    def name(self) -> str: ...
    def nativeCountryName(self) -> str: ...
    def nativeLanguageName(self) -> str: ...
    def negativeSign(self) -> str: ...
    def numberOptions(self) -> typing.Union[QLocale.NumberOptions,QLocale.NumberOption]: ...
    def percent(self) -> str: ...
    def pmText(self) -> str: ...
    def positiveSign(self) -> str: ...
    def quoteString(self, str: str, style: QLocale.QuotationStyle = ...) -> str: ...
    def script(self) -> QLocale.Script: ...
    @classmethod
    def scriptToString(cls, script: QLocale.Script) -> str: ...
    @classmethod
    def setDefault(cls, locale: QLocale) -> None: ...
    def setNumberOptions(self, options: typing.Union[QLocale.NumberOptions,QLocale.NumberOption]) -> None: ...
    def standaloneDayName(self, arg__1: int, format: QLocale.FormatType = ...) -> str: ...
    def standaloneMonthName(self, arg__1: int, format: QLocale.FormatType = ...) -> str: ...
    def swap(self, other: QLocale) -> None: ...
    @classmethod
    def system(cls) -> QLocale: ...
    def textDirection(self) -> Qt.LayoutDirection: ...
    def timeFormat(self, format: QLocale.FormatType = ...) -> str: ...
    @overload
    def toCurrencyString(self, arg__1: float, symbol: str, precision: int) -> str: ...
    @overload
    def toCurrencyString(self, i: float, symbol: str, precision: int) -> str: ...
    @overload
    def toCurrencyString(self, arg__1: float, symbol: str = ...) -> str: ...
    @overload
    def toCurrencyString(self, arg__1: int, symbol: str = ...) -> str: ...
    @overload
    def toCurrencyString(self, i: float, symbol: str = ...) -> str: ...
    @overload
    def toDate(self, string: str, format: QLocale.FormatType, cal: QCalendar) -> QDate: ...
    @overload
    def toDate(self, string: str, format: str, cal: QCalendar) -> QDate: ...
    @overload
    def toDate(self, string: str, format: QLocale.FormatType = ...) -> QDate: ...
    @overload
    def toDate(self, string: str, format: str) -> QDate: ...
    @overload
    def toDateTime(self, string: str, format: QLocale.FormatType, cal: QCalendar) -> QDateTime: ...
    @overload
    def toDateTime(self, string: str, format: str, cal: QCalendar) -> QDateTime: ...
    @overload
    def toDateTime(self, string: str, format: QLocale.FormatType = ...) -> QDateTime: ...
    @overload
    def toDateTime(self, string: str, format: str) -> QDateTime: ...
    def toDouble(self, s: str) -> typing.Tuple[float,bool]: ...
    def toFloat(self, s: str) -> typing.Tuple[float,bool]: ...
    def toInt(self, s: str) -> typing.Tuple[int,bool]: ...
    def toLong(self, s: str) -> typing.Tuple[int,bool]: ...
    def toLongLong(self, s: str) -> typing.Tuple[int,bool]: ...
    def toLower(self, str: str) -> str: ...
    def toShort(self, s: str) -> typing.Tuple[int,bool]: ...
    @overload
    def toString(self, date: QDate, format: QLocale.FormatType, cal: QCalendar) -> str: ...
    @overload
    def toString(self, dateTime: QDateTime, format: QLocale.FormatType, cal: QCalendar) -> str: ...
    @overload
    def toString(self, i: float, f: int = ..., prec: int = ...) -> str: ...
    @overload
    def toString(self, date: QDate, format: QLocale.FormatType = ...) -> str: ...
    @overload
    def toString(self, date: QDate, formatStr: str) -> str: ...
    @overload
    def toString(self, dateTime: QDateTime, format: QLocale.FormatType = ...) -> str: ...
    @overload
    def toString(self, dateTime: QDateTime, format: str) -> str: ...
    @overload
    def toString(self, time: QTime, format: QLocale.FormatType = ...) -> str: ...
    @overload
    def toString(self, time: QTime, formatStr: str) -> str: ...
    @overload
    def toString(self, i: int) -> str: ...
    @overload
    def toTime(self, string: str, format: QLocale.FormatType, cal: QCalendar) -> QTime: ...
    @overload
    def toTime(self, string: str, format: str, cal: QCalendar) -> QTime: ...
    @overload
    def toTime(self, string: str, format: QLocale.FormatType = ...) -> QTime: ...
    @overload
    def toTime(self, string: str, format: str) -> QTime: ...
    def toUInt(self, s: str) -> typing.Tuple[int,bool]: ...
    def toULong(self, s: str) -> typing.Tuple[int,bool]: ...
    def toULongLong(self, s: str) -> typing.Tuple[int,bool]: ...
    def toUShort(self, s: str) -> typing.Tuple[int,bool]: ...
    def toUpper(self, str: str) -> str: ...
    def uiLanguages(self) -> typing.List[str]: ...
    def weekdays(self) -> typing.List[Qt.DayOfWeek]: ...
    def zeroDigit(self) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QLockFile(shiboken2.Object):
    class LockError:
        LockFailedError: typing.ClassVar[QLockFile.LockError] = ...
        NoError: typing.ClassVar[QLockFile.LockError] = ...
        PermissionError: typing.ClassVar[QLockFile.LockError] = ...
        UnknownError: typing.ClassVar[QLockFile.LockError] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QLockFile.LockError: ...
        def __and__(self, other: typing.SupportsInt) -> QLockFile.LockError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QLockFile.LockError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QLockFile.LockError: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QLockFile.LockError: ...
        def __rand__(self, other: typing.SupportsInt) -> QLockFile.LockError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QLockFile.LockError: ...
        def __ror__(self, other: typing.SupportsInt) -> QLockFile.LockError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QLockFile.LockError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QLockFile.LockError: ...
        def __sub__(self, other: typing.SupportsInt) -> QLockFile.LockError: ...
        def __xor__(self, other: typing.SupportsInt) -> QLockFile.LockError: ...
    LockFailedError: typing.ClassVar[QLockFile.LockError] = ...
    NoError: typing.ClassVar[QLockFile.LockError] = ...
    PermissionError: typing.ClassVar[QLockFile.LockError] = ...
    UnknownError: typing.ClassVar[QLockFile.LockError] = ...
    def __init__(self, fileName: str) -> None: ...
    def error(self) -> QLockFile.LockError: ...
    def getLockInfo(self) -> typing.Tuple[bool,int,str,str]: ...
    def isLocked(self) -> bool: ...
    def lock(self) -> bool: ...
    def removeStaleLockFile(self) -> bool: ...
    def setStaleLockTime(self, arg__1: int) -> None: ...
    def staleLockTime(self) -> int: ...
    def tryLock(self, timeout: int = ...) -> bool: ...
    def unlock(self) -> None: ...

class QMargins(shiboken2.Object):
    @overload
    def __init__(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @overload
    def __init__(self, QMargins: QMargins) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def bottom(self) -> int: ...
    def isNull(self) -> bool: ...
    def left(self) -> int: ...
    def right(self) -> int: ...
    def setBottom(self, bottom: int) -> None: ...
    def setLeft(self, left: int) -> None: ...
    def setRight(self, right: int) -> None: ...
    def setTop(self, top: int) -> None: ...
    def top(self) -> int: ...
    @overload
    def __add__(self, lhs: int) -> QMargins: ...
    @overload
    def __add__(self, m2: QMargins) -> QMargins: ...
    @overload
    def __add__(self, rhs: int) -> QMargins: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    @overload
    def __iadd__(self, arg__1: int) -> QMargins: ...
    @overload
    def __iadd__(self, margins: QMargins) -> QMargins: ...
    @overload
    def __imul__(self, arg__1: int) -> QMargins: ...
    @overload
    def __imul__(self, arg__1: float) -> QMargins: ...
    @overload
    def __isub__(self, arg__1: int) -> QMargins: ...
    @overload
    def __isub__(self, margins: QMargins) -> QMargins: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    @overload
    def __mul__(self, factor: int) -> QMargins: ...
    @overload
    def __mul__(self, factor: float) -> QMargins: ...
    def __ne__(self, other: object) -> bool: ...
    def __neg__(self) -> QMargins: ...
    def __pos__(self) -> QMargins: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __rtruediv__(self, other) -> typing.Any: ...
    @overload
    def __sub__(self, m2: QMargins) -> QMargins: ...
    @overload
    def __sub__(self, rhs: int) -> QMargins: ...
    def __truediv__(self, other) -> typing.Any: ...

class QMarginsF(shiboken2.Object):
    @overload
    def __init__(self, left: float, top: float, right: float, bottom: float) -> None: ...
    @overload
    def __init__(self, QMarginsF: QMarginsF) -> None: ...
    @overload
    def __init__(self, margins: QMargins) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def bottom(self) -> float: ...
    def isNull(self) -> bool: ...
    def left(self) -> float: ...
    def right(self) -> float: ...
    def setBottom(self, bottom: float) -> None: ...
    def setLeft(self, left: float) -> None: ...
    def setRight(self, right: float) -> None: ...
    def setTop(self, top: float) -> None: ...
    def toMargins(self) -> QMargins: ...
    def top(self) -> float: ...
    @overload
    def __add__(self, lhs: float) -> QMarginsF: ...
    @overload
    def __add__(self, rhs: QMarginsF) -> QMarginsF: ...
    @overload
    def __add__(self, rhs: float) -> QMarginsF: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    @overload
    def __iadd__(self, addend: float) -> QMarginsF: ...
    @overload
    def __iadd__(self, margins: QMarginsF) -> QMarginsF: ...
    def __imul__(self, factor: float) -> QMarginsF: ...
    @overload
    def __isub__(self, margins: QMarginsF) -> QMarginsF: ...
    @overload
    def __isub__(self, subtrahend: float) -> QMarginsF: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    @overload
    def __mul__(self, lhs: float) -> QMarginsF: ...
    @overload
    def __mul__(self, rhs: float) -> QMarginsF: ...
    def __ne__(self, other: object) -> bool: ...
    def __neg__(self) -> QMarginsF: ...
    def __pos__(self) -> QMarginsF: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __rtruediv__(self, other) -> typing.Any: ...
    @overload
    def __sub__(self, rhs: QMarginsF) -> QMarginsF: ...
    @overload
    def __sub__(self, rhs: float) -> QMarginsF: ...
    def __truediv__(self, other) -> typing.Any: ...

class QMessageAuthenticationCode(shiboken2.Object):
    def __init__(self, method: QCryptographicHash.Algorithm, key: typing.Union[QByteArray,bytes] = ...) -> None: ...
    @overload
    def addData(self, data: bytes, length: int) -> None: ...
    @overload
    def addData(self, data: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def addData(self, device: QIODevice) -> bool: ...
    @classmethod
    def hash(cls, message: typing.Union[QByteArray,bytes], key: typing.Union[QByteArray,bytes], method: QCryptographicHash.Algorithm) -> QByteArray: ...
    def reset(self) -> None: ...
    def result(self) -> QByteArray: ...
    def setKey(self, key: typing.Union[QByteArray,bytes]) -> None: ...

class QMessageLogContext(shiboken2.Object):
    category: typing.Any
    file: typing.Any
    function: typing.Any
    line: typing.Any
    version: typing.Any
    @overload
    def __init__(self, fileName: bytes, lineNumber: int, functionName: bytes, categoryName: bytes) -> None: ...
    @overload
    def __init__(self) -> None: ...

class QMetaClassInfo(shiboken2.Object):
    @overload
    def __init__(self, QMetaClassInfo: QMetaClassInfo) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def name(self) -> bytes: ...
    def value(self) -> bytes: ...
    def __copy__(self) -> None: ...

class QMetaEnum(shiboken2.Object):
    @overload
    def __init__(self, QMetaEnum: QMetaEnum) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def enumName(self) -> bytes: ...
    def isFlag(self) -> bool: ...
    def isScoped(self) -> bool: ...
    def isValid(self) -> bool: ...
    def key(self, index: int) -> bytes: ...
    def keyCount(self) -> int: ...
    def keyToValue(self, key: bytes) -> typing.Tuple[int,bool]: ...
    def keysToValue(self, keys: bytes) -> typing.Tuple[int,bool]: ...
    def name(self) -> bytes: ...
    def scope(self) -> bytes: ...
    def value(self, index: int) -> int: ...
    def valueToKey(self, value: int) -> bytes: ...
    def valueToKeys(self, value: int) -> QByteArray: ...
    def __copy__(self) -> None: ...

class QMetaMethod(shiboken2.Object):
    class Access:
        Private: typing.ClassVar[QMetaMethod.Access] = ...
        Protected: typing.ClassVar[QMetaMethod.Access] = ...
        Public: typing.ClassVar[QMetaMethod.Access] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMetaMethod.Access: ...
        def __and__(self, other: typing.SupportsInt) -> QMetaMethod.Access: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMetaMethod.Access: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMetaMethod.Access: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QMetaMethod.Access: ...
        def __rand__(self, other: typing.SupportsInt) -> QMetaMethod.Access: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMetaMethod.Access: ...
        def __ror__(self, other: typing.SupportsInt) -> QMetaMethod.Access: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMetaMethod.Access: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMetaMethod.Access: ...
        def __sub__(self, other: typing.SupportsInt) -> QMetaMethod.Access: ...
        def __xor__(self, other: typing.SupportsInt) -> QMetaMethod.Access: ...

    class MethodType:
        Constructor: typing.ClassVar[QMetaMethod.MethodType] = ...
        Method: typing.ClassVar[QMetaMethod.MethodType] = ...
        Signal: typing.ClassVar[QMetaMethod.MethodType] = ...
        Slot: typing.ClassVar[QMetaMethod.MethodType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMetaMethod.MethodType: ...
        def __and__(self, other: typing.SupportsInt) -> QMetaMethod.MethodType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMetaMethod.MethodType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMetaMethod.MethodType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QMetaMethod.MethodType: ...
        def __rand__(self, other: typing.SupportsInt) -> QMetaMethod.MethodType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMetaMethod.MethodType: ...
        def __ror__(self, other: typing.SupportsInt) -> QMetaMethod.MethodType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMetaMethod.MethodType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMetaMethod.MethodType: ...
        def __sub__(self, other: typing.SupportsInt) -> QMetaMethod.MethodType: ...
        def __xor__(self, other: typing.SupportsInt) -> QMetaMethod.MethodType: ...
    Constructor: typing.ClassVar[QMetaMethod.MethodType] = ...
    Method: typing.ClassVar[QMetaMethod.MethodType] = ...
    Private: typing.ClassVar[QMetaMethod.Access] = ...
    Protected: typing.ClassVar[QMetaMethod.Access] = ...
    Public: typing.ClassVar[QMetaMethod.Access] = ...
    Signal: typing.ClassVar[QMetaMethod.MethodType] = ...
    Slot: typing.ClassVar[QMetaMethod.MethodType] = ...
    @overload
    def __init__(self, QMetaMethod: QMetaMethod) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def access(self) -> QMetaMethod.Access: ...
    def enclosingMetaObject(self) -> QMetaObject: ...
    @overload
    def invoke(self, object: QObject, connectionType: Qt.ConnectionType, returnValue: QGenericReturnArgument, val0: QGenericArgument = ..., val1: QGenericArgument = ..., val2: QGenericArgument = ..., val3: QGenericArgument = ..., val4: QGenericArgument = ..., val5: QGenericArgument = ..., val6: QGenericArgument = ..., val7: QGenericArgument = ..., val8: QGenericArgument = ..., val9: QGenericArgument = ...) -> bool: ...
    @overload
    def invoke(self, object: QObject, connectionType: Qt.ConnectionType, val0: QGenericArgument = ..., val1: QGenericArgument = ..., val2: QGenericArgument = ..., val3: QGenericArgument = ..., val4: QGenericArgument = ..., val5: QGenericArgument = ..., val6: QGenericArgument = ..., val7: QGenericArgument = ..., val8: QGenericArgument = ..., val9: QGenericArgument = ...) -> bool: ...
    @overload
    def invoke(self, object: QObject, returnValue: QGenericReturnArgument, val0: QGenericArgument = ..., val1: QGenericArgument = ..., val2: QGenericArgument = ..., val3: QGenericArgument = ..., val4: QGenericArgument = ..., val5: QGenericArgument = ..., val6: QGenericArgument = ..., val7: QGenericArgument = ..., val8: QGenericArgument = ..., val9: QGenericArgument = ...) -> bool: ...
    @overload
    def invoke(self, object: QObject, val0: QGenericArgument = ..., val1: QGenericArgument = ..., val2: QGenericArgument = ..., val3: QGenericArgument = ..., val4: QGenericArgument = ..., val5: QGenericArgument = ..., val6: QGenericArgument = ..., val7: QGenericArgument = ..., val8: QGenericArgument = ..., val9: QGenericArgument = ...) -> bool: ...
    @overload
    def invokeOnGadget(self, gadget: int, returnValue: QGenericReturnArgument, val0: QGenericArgument = ..., val1: QGenericArgument = ..., val2: QGenericArgument = ..., val3: QGenericArgument = ..., val4: QGenericArgument = ..., val5: QGenericArgument = ..., val6: QGenericArgument = ..., val7: QGenericArgument = ..., val8: QGenericArgument = ..., val9: QGenericArgument = ...) -> bool: ...
    @overload
    def invokeOnGadget(self, gadget: int, val0: QGenericArgument = ..., val1: QGenericArgument = ..., val2: QGenericArgument = ..., val3: QGenericArgument = ..., val4: QGenericArgument = ..., val5: QGenericArgument = ..., val6: QGenericArgument = ..., val7: QGenericArgument = ..., val8: QGenericArgument = ..., val9: QGenericArgument = ...) -> bool: ...
    def isValid(self) -> bool: ...
    def methodIndex(self) -> int: ...
    def methodSignature(self) -> QByteArray: ...
    def methodType(self) -> QMetaMethod.MethodType: ...
    def name(self) -> QByteArray: ...
    def parameterCount(self) -> int: ...
    def parameterNames(self) -> typing.List[QByteArray]: ...
    def parameterType(self, index: int) -> int: ...
    def parameterTypes(self) -> typing.List[QByteArray]: ...
    def returnType(self) -> int: ...
    def revision(self) -> int: ...
    def tag(self) -> bytes: ...
    def typeName(self) -> bytes: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMetaObject(shiboken2.Object):
    class Call:
        CreateInstance: typing.ClassVar[QMetaObject.Call] = ...
        IndexOfMethod: typing.ClassVar[QMetaObject.Call] = ...
        InvokeMetaMethod: typing.ClassVar[QMetaObject.Call] = ...
        QueryPropertyDesignable: typing.ClassVar[QMetaObject.Call] = ...
        QueryPropertyEditable: typing.ClassVar[QMetaObject.Call] = ...
        QueryPropertyScriptable: typing.ClassVar[QMetaObject.Call] = ...
        QueryPropertyStored: typing.ClassVar[QMetaObject.Call] = ...
        QueryPropertyUser: typing.ClassVar[QMetaObject.Call] = ...
        ReadProperty: typing.ClassVar[QMetaObject.Call] = ...
        RegisterMethodArgumentMetaType: typing.ClassVar[QMetaObject.Call] = ...
        RegisterPropertyMetaType: typing.ClassVar[QMetaObject.Call] = ...
        ResetProperty: typing.ClassVar[QMetaObject.Call] = ...
        WriteProperty: typing.ClassVar[QMetaObject.Call] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMetaObject.Call: ...
        def __and__(self, other: typing.SupportsInt) -> QMetaObject.Call: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMetaObject.Call: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMetaObject.Call: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QMetaObject.Call: ...
        def __rand__(self, other: typing.SupportsInt) -> QMetaObject.Call: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMetaObject.Call: ...
        def __ror__(self, other: typing.SupportsInt) -> QMetaObject.Call: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMetaObject.Call: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMetaObject.Call: ...
        def __sub__(self, other: typing.SupportsInt) -> QMetaObject.Call: ...
        def __xor__(self, other: typing.SupportsInt) -> QMetaObject.Call: ...

    class Connection(shiboken2.Object):
        @overload
        def __init__(self, other: QMetaObject.Connection) -> None: ...
        @overload
        def __init__(self) -> None: ...
    CreateInstance: typing.ClassVar[QMetaObject.Call] = ...
    IndexOfMethod: typing.ClassVar[QMetaObject.Call] = ...
    InvokeMetaMethod: typing.ClassVar[QMetaObject.Call] = ...
    QueryPropertyDesignable: typing.ClassVar[QMetaObject.Call] = ...
    QueryPropertyEditable: typing.ClassVar[QMetaObject.Call] = ...
    QueryPropertyScriptable: typing.ClassVar[QMetaObject.Call] = ...
    QueryPropertyStored: typing.ClassVar[QMetaObject.Call] = ...
    QueryPropertyUser: typing.ClassVar[QMetaObject.Call] = ...
    ReadProperty: typing.ClassVar[QMetaObject.Call] = ...
    RegisterMethodArgumentMetaType: typing.ClassVar[QMetaObject.Call] = ...
    RegisterPropertyMetaType: typing.ClassVar[QMetaObject.Call] = ...
    ResetProperty: typing.ClassVar[QMetaObject.Call] = ...
    WriteProperty: typing.ClassVar[QMetaObject.Call] = ...
    def __init__(self) -> None: ...
    def cast(self, obj: QObject) -> QObject: ...
    @overload
    @classmethod
    def checkConnectArgs(cls, signal: QMetaMethod, method: QMetaMethod) -> bool: ...
    @overload
    @classmethod
    def checkConnectArgs(cls, signal: bytes, method: bytes) -> bool: ...
    def classInfo(self, index: int) -> QMetaClassInfo: ...
    def classInfoCount(self) -> int: ...
    def classInfoOffset(self) -> int: ...
    def className(self) -> bytes: ...
    @classmethod
    def connectSlotsByName(cls, o: QObject) -> None: ...
    def constructor(self, index: int) -> QMetaMethod: ...
    def constructorCount(self) -> int: ...
    @classmethod
    def disconnect(cls, sender: QObject, signal_index: int, receiver: QObject, method_index: int) -> bool: ...
    @classmethod
    def disconnectOne(cls, sender: QObject, signal_index: int, receiver: QObject, method_index: int) -> bool: ...
    def enumerator(self, index: int) -> QMetaEnum: ...
    def enumeratorCount(self) -> int: ...
    def enumeratorOffset(self) -> int: ...
    def indexOfClassInfo(self, name: bytes) -> int: ...
    def indexOfConstructor(self, constructor: bytes) -> int: ...
    def indexOfEnumerator(self, name: bytes) -> int: ...
    def indexOfMethod(self, method: bytes) -> int: ...
    def indexOfProperty(self, name: bytes) -> int: ...
    def indexOfSignal(self, signal: bytes) -> int: ...
    def indexOfSlot(self, slot: bytes) -> int: ...
    def inherits(self, metaObject: QMetaObject) -> bool: ...
    @overload
    @classmethod
    def invokeMethod(cls, obj: QObject, member: typing.Union[bytes, str], arg__3: Qt.ConnectionType, ret: QGenericReturnArgument, val0: QGenericArgument = ..., val1: QGenericArgument = ..., val2: QGenericArgument = ..., val3: QGenericArgument = ..., val4: QGenericArgument = ..., val5: QGenericArgument = ..., val6: QGenericArgument = ..., val7: QGenericArgument = ..., val8: QGenericArgument = ..., val9: QGenericArgument = ...) -> bool: ...
    @overload
    @classmethod
    def invokeMethod(cls, obj: QObject, member: typing.Union[bytes, str], ret: QGenericReturnArgument, val0: QGenericArgument = ..., val1: QGenericArgument = ..., val2: QGenericArgument = ..., val3: QGenericArgument = ..., val4: QGenericArgument = ..., val5: QGenericArgument = ..., val6: QGenericArgument = ..., val7: QGenericArgument = ..., val8: QGenericArgument = ..., val9: QGenericArgument = ...) -> bool: ...
    @overload
    @classmethod
    def invokeMethod(cls, obj: QObject, member: typing.Union[bytes, str], type: Qt.ConnectionType, val0: QGenericArgument = ..., val1: QGenericArgument = ..., val2: QGenericArgument = ..., val3: QGenericArgument = ..., val4: QGenericArgument = ..., val5: QGenericArgument = ..., val6: QGenericArgument = ..., val7: QGenericArgument = ..., val8: QGenericArgument = ..., val9: QGenericArgument = ...) -> bool: ...
    @overload
    @classmethod
    def invokeMethod(cls, obj: QObject, member: typing.Union[bytes, str], val0: QGenericArgument = ..., val1: QGenericArgument = ..., val2: QGenericArgument = ..., val3: QGenericArgument = ..., val4: QGenericArgument = ..., val5: QGenericArgument = ..., val6: QGenericArgument = ..., val7: QGenericArgument = ..., val8: QGenericArgument = ..., val9: QGenericArgument = ...) -> bool: ...
    def method(self, index: int) -> QMetaMethod: ...
    def methodCount(self) -> int: ...
    def methodOffset(self) -> int: ...
    def newInstance(self, val0: QGenericArgument = ..., val1: QGenericArgument = ..., val2: QGenericArgument = ..., val3: QGenericArgument = ..., val4: QGenericArgument = ..., val5: QGenericArgument = ..., val6: QGenericArgument = ..., val7: QGenericArgument = ..., val8: QGenericArgument = ..., val9: QGenericArgument = ...) -> QObject: ...
    @classmethod
    def normalizedSignature(cls, method: bytes) -> QByteArray: ...
    @classmethod
    def normalizedType(cls, type: bytes) -> QByteArray: ...
    def property(self, index: int) -> QMetaProperty: ...
    def propertyCount(self) -> int: ...
    def propertyOffset(self) -> int: ...
    def superClass(self) -> QMetaObject: ...
    def userProperty(self) -> QMetaProperty: ...

class QMetaProperty(shiboken2.Object):
    @overload
    def __init__(self, QMetaProperty: QMetaProperty) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def enumerator(self) -> QMetaEnum: ...
    def hasNotifySignal(self) -> bool: ...
    def hasStdCppSet(self) -> bool: ...
    def isConstant(self) -> bool: ...
    def isDesignable(self, obj: typing.Union[QObject,None] = ...) -> bool: ...
    def isEditable(self, obj: typing.Union[QObject,None] = ...) -> bool: ...
    def isEnumType(self) -> bool: ...
    def isFinal(self) -> bool: ...
    def isFlagType(self) -> bool: ...
    def isReadable(self) -> bool: ...
    def isRequired(self) -> bool: ...
    def isResettable(self) -> bool: ...
    def isScriptable(self, obj: typing.Union[QObject,None] = ...) -> bool: ...
    def isStored(self, obj: typing.Union[QObject,None] = ...) -> bool: ...
    def isUser(self, obj: typing.Union[QObject,None] = ...) -> bool: ...
    def isValid(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def name(self) -> bytes: ...
    def notifySignal(self) -> QMetaMethod: ...
    def notifySignalIndex(self) -> int: ...
    def propertyIndex(self) -> int: ...
    def read(self, obj: QObject) -> typing.Any: ...
    def readOnGadget(self, gadget: int) -> typing.Any: ...
    def relativePropertyIndex(self) -> int: ...
    def reset(self, obj: QObject) -> bool: ...
    def resetOnGadget(self, gadget: int) -> bool: ...
    def revision(self) -> int: ...
    def type(self) -> type: ...
    def typeName(self) -> bytes: ...
    def userType(self) -> int: ...
    def write(self, obj: QObject, value: typing.Any) -> bool: ...
    def writeOnGadget(self, gadget: int, value: typing.Any) -> bool: ...
    def __copy__(self) -> None: ...

class QMimeData(QObject):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def clear(self) -> None: ...
    def colorData(self) -> typing.Any: ...
    def data(self, mimetype: str) -> QByteArray: ...
    def formats(self) -> typing.List[str]: ...
    def hasColor(self) -> bool: ...
    def hasFormat(self, mimetype: str) -> bool: ...
    def hasHtml(self) -> bool: ...
    def hasImage(self) -> bool: ...
    def hasText(self) -> bool: ...
    def hasUrls(self) -> bool: ...
    def html(self) -> str: ...
    def imageData(self) -> typing.Any: ...
    def removeFormat(self, mimetype: str) -> None: ...
    def retrieveData(self, mimetype: str, preferredType: type) -> typing.Any: ...
    def setColorData(self, color: typing.Any) -> None: ...
    def setData(self, mimetype: str, data: typing.Union[QByteArray,bytes]) -> None: ...
    def setHtml(self, html: str) -> None: ...
    def setImageData(self, image: typing.Any) -> None: ...
    def setText(self, text: str) -> None: ...
    def setUrls(self, urls: typing.Iterable[QUrl]) -> None: ...
    def text(self) -> str: ...
    def urls(self) -> typing.List[QUrl]: ...

class QMimeDatabase(shiboken2.Object):
    class MatchMode:
        MatchContent: typing.ClassVar[QMimeDatabase.MatchMode] = ...
        MatchDefault: typing.ClassVar[QMimeDatabase.MatchMode] = ...
        MatchExtension: typing.ClassVar[QMimeDatabase.MatchMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMimeDatabase.MatchMode: ...
        def __and__(self, other: typing.SupportsInt) -> QMimeDatabase.MatchMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMimeDatabase.MatchMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMimeDatabase.MatchMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QMimeDatabase.MatchMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QMimeDatabase.MatchMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMimeDatabase.MatchMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QMimeDatabase.MatchMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMimeDatabase.MatchMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMimeDatabase.MatchMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QMimeDatabase.MatchMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QMimeDatabase.MatchMode: ...
    MatchContent: typing.ClassVar[QMimeDatabase.MatchMode] = ...
    MatchDefault: typing.ClassVar[QMimeDatabase.MatchMode] = ...
    MatchExtension: typing.ClassVar[QMimeDatabase.MatchMode] = ...
    def __init__(self) -> None: ...
    def allMimeTypes(self) -> typing.List[QMimeType]: ...
    @overload
    def mimeTypeForData(self, data: typing.Union[QByteArray,bytes]) -> QMimeType: ...
    @overload
    def mimeTypeForData(self, device: QIODevice) -> QMimeType: ...
    @overload
    def mimeTypeForFile(self, fileInfo: QFileInfo, mode: QMimeDatabase.MatchMode = ...) -> QMimeType: ...
    @overload
    def mimeTypeForFile(self, fileName: str, mode: QMimeDatabase.MatchMode = ...) -> QMimeType: ...
    @overload
    def mimeTypeForFileNameAndData(self, fileName: str, data: typing.Union[QByteArray,bytes]) -> QMimeType: ...
    @overload
    def mimeTypeForFileNameAndData(self, fileName: str, device: QIODevice) -> QMimeType: ...
    def mimeTypeForName(self, nameOrAlias: str) -> QMimeType: ...
    def mimeTypeForUrl(self, url: QUrl) -> QMimeType: ...
    def mimeTypesForFileName(self, fileName: str) -> typing.List[QMimeType]: ...
    def suffixForFileName(self, fileName: str) -> str: ...

class QMimeType(shiboken2.Object):
    @overload
    def __init__(self, other: QMimeType) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def aliases(self) -> typing.List[str]: ...
    def allAncestors(self) -> typing.List[str]: ...
    def comment(self) -> str: ...
    def filterString(self) -> str: ...
    def genericIconName(self) -> str: ...
    def globPatterns(self) -> typing.List[str]: ...
    def iconName(self) -> str: ...
    def inherits(self, mimeTypeName: str) -> bool: ...
    def isDefault(self) -> bool: ...
    def isValid(self) -> bool: ...
    def name(self) -> str: ...
    def parentMimeTypes(self) -> typing.List[str]: ...
    def preferredSuffix(self) -> str: ...
    def suffixes(self) -> typing.List[str]: ...
    def swap(self, other: QMimeType) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QModelIndex(shiboken2.Object):
    @overload
    def __init__(self, QModelIndex: QModelIndex) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def child(self, row: int, column: int) -> QModelIndex: ...
    def column(self) -> int: ...
    def data(self, role: Qt.ItemDataRole = ...) -> typing.Any: ...
    def flags(self) -> typing.Union[Qt.ItemFlags,Qt.ItemFlag]: ...
    def internalId(self) -> int: ...
    def internalPointer(self) -> typing.Any: ...
    def isValid(self) -> bool: ...
    def model(self) -> QAbstractItemModel: ...
    def parent(self) -> QModelIndex: ...
    def row(self) -> int: ...
    def sibling(self, row: int, column: int) -> QModelIndex: ...
    def siblingAtColumn(self, column: int) -> QModelIndex: ...
    def siblingAtRow(self, row: int) -> QModelIndex: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QMutex(QBasicMutex):
    class RecursionMode:
        NonRecursive: typing.ClassVar[QMutex.RecursionMode] = ...
        Recursive: typing.ClassVar[QMutex.RecursionMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QMutex.RecursionMode: ...
        def __and__(self, other: typing.SupportsInt) -> QMutex.RecursionMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QMutex.RecursionMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QMutex.RecursionMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QMutex.RecursionMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QMutex.RecursionMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QMutex.RecursionMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QMutex.RecursionMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QMutex.RecursionMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QMutex.RecursionMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QMutex.RecursionMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QMutex.RecursionMode: ...
    NonRecursive: typing.ClassVar[QMutex.RecursionMode] = ...
    Recursive: typing.ClassVar[QMutex.RecursionMode] = ...
    @overload
    def __init__(self, mode: QMutex.RecursionMode) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def isRecursive(self) -> bool: ...
    def lock(self) -> None: ...
    def tryLock(self, timeout: int = ...) -> bool: ...
    def try_lock(self) -> bool: ...
    def unlock(self) -> None: ...

class QMutexLocker(shiboken2.Object):
    @overload
    def __init__(self, m: QBasicMutex) -> None: ...
    @overload
    def __init__(self, m: QRecursiveMutex) -> None: ...
    def mutex(self) -> QMutex: ...
    def relock(self) -> None: ...
    def unlock(self) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, arg__1: object, arg__2: object, arg__3: object) -> None: ...

class QObject(shiboken2.Object):
    destroyed: typing.ClassVar[Signal] = ...
    objectNameChanged: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def blockSignals(self, b: bool) -> bool: ...
    def childEvent(self, event: QChildEvent) -> None: ...
    def children(self) -> typing.List[QObject]: ...
    @overload
    def connect(self, arg__1: bytes, arg__2: QObject, arg__3: bytes, type: Qt.ConnectionType = ...) -> bool: ...
    @overload
    def connect(self, sender: QObject, signal: bytes, member: bytes, type: Qt.ConnectionType = ...) -> QMetaObject.Connection: ...
    @overload
    def connect(self, arg__1: bytes, arg__2: typing.Callable, type: Qt.ConnectionType = ...) -> bool: ...
    def connectNotify(self, signal: QMetaMethod) -> None: ...
    def customEvent(self, event: QEvent) -> None: ...
    def deleteLater(self) -> None: ...
    @overload
    @classmethod
    def disconnect(cls, sender: QObject, signal: QMetaMethod, receiver: QObject = ..., member: QMetaMethod = ...) -> bool: ...
    @overload
    @classmethod
    def disconnect(cls, arg__1: QObject, arg__2: str = ..., arg__3: typing.Callable = ...) -> bool: ...
    @overload
    @classmethod
    def disconnect(cls, arg__1: QMetaObject.Connection) -> bool: ...
    def disconnectNotify(self, signal: QMetaMethod) -> None: ...
    def dumpObjectInfo(self) -> None: ...
    def dumpObjectTree(self) -> None: ...
    def dynamicPropertyNames(self) -> typing.List[QByteArray]: ...
    def emit(self, arg__1: bytes, *args: None) -> bool: ...
    def event(self, event: QEvent) -> bool: ...
    def eventFilter(self, watched: QObject, event: QEvent) -> bool: ...
    def findChild(self, arg__1: typing.Type[T], arg__2: str = ...) -> T: ...
    @overload
    def findChildren(self, arg__1: typing.Type[T], arg__2: QRegExp = ...) -> typing.List[T]: ...
    @overload
    def findChildren(self, arg__1: typing.Type[T], arg__2: QRegularExpression = ...) -> typing.List[T]: ...
    @overload
    def findChildren(self, arg__1: typing.Type[T], arg__2: str = ...) -> typing.List[T]: ...
    def inherits(self, classname: bytes) -> bool: ...
    def installEventFilter(self, filterObj: QObject) -> None: ...
    def isSignalConnected(self, signal: QMetaMethod) -> bool: ...
    def isWidgetType(self) -> bool: ...
    def isWindowType(self) -> bool: ...
    def killTimer(self, id: int) -> None: ...
    def metaObject(self) -> QMetaObject: ...
    def moveToThread(self, thread: QThread) -> None: ...
    def objectName(self) -> str: ...
    def parent(self) -> QObject: ...
    def property(self, name: str) -> typing.Any: ...
    def receivers(self, signal: bytes) -> int: ...
    @classmethod
    def registerUserData(cls) -> int: ...
    def removeEventFilter(self, obj: QObject) -> None: ...
    def sender(self) -> QObject: ...
    def senderSignalIndex(self) -> int: ...
    def setObjectName(self, name: str) -> None: ...
    def setParent(self, parent: typing.Union[QObject,None]) -> None: ...
    def setProperty(self, name: str, value: typing.Any) -> bool: ...
    def signalsBlocked(self) -> bool: ...
    def startTimer(self, interval: int, timerType: Qt.TimerType = ...) -> int: ...
    def thread(self) -> QThread: ...
    def timerEvent(self, event: QTimerEvent) -> None: ...
    def tr(self, arg__1: bytes, arg__2: bytes = ..., arg__3: int = ...) -> str: ...

class QOperatingSystemVersion(shiboken2.Object):
    class OSType:
        Android: typing.ClassVar[QOperatingSystemVersion.OSType] = ...
        IOS: typing.ClassVar[QOperatingSystemVersion.OSType] = ...
        MacOS: typing.ClassVar[QOperatingSystemVersion.OSType] = ...
        TvOS: typing.ClassVar[QOperatingSystemVersion.OSType] = ...
        Unknown: typing.ClassVar[QOperatingSystemVersion.OSType] = ...
        WatchOS: typing.ClassVar[QOperatingSystemVersion.OSType] = ...
        Windows: typing.ClassVar[QOperatingSystemVersion.OSType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QOperatingSystemVersion.OSType: ...
        def __and__(self, other: typing.SupportsInt) -> QOperatingSystemVersion.OSType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QOperatingSystemVersion.OSType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QOperatingSystemVersion.OSType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QOperatingSystemVersion.OSType: ...
        def __rand__(self, other: typing.SupportsInt) -> QOperatingSystemVersion.OSType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QOperatingSystemVersion.OSType: ...
        def __ror__(self, other: typing.SupportsInt) -> QOperatingSystemVersion.OSType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QOperatingSystemVersion.OSType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QOperatingSystemVersion.OSType: ...
        def __sub__(self, other: typing.SupportsInt) -> QOperatingSystemVersion.OSType: ...
        def __xor__(self, other: typing.SupportsInt) -> QOperatingSystemVersion.OSType: ...
    Android: typing.ClassVar[QOperatingSystemVersion.OSType] = ...
    AndroidJellyBean: typing.ClassVar[QOperatingSystemVersion] = ...
    AndroidJellyBean_MR1: typing.ClassVar[QOperatingSystemVersion] = ...
    AndroidJellyBean_MR2: typing.ClassVar[QOperatingSystemVersion] = ...
    AndroidKitKat: typing.ClassVar[QOperatingSystemVersion] = ...
    AndroidLollipop: typing.ClassVar[QOperatingSystemVersion] = ...
    AndroidLollipop_MR1: typing.ClassVar[QOperatingSystemVersion] = ...
    AndroidMarshmallow: typing.ClassVar[QOperatingSystemVersion] = ...
    AndroidNougat: typing.ClassVar[QOperatingSystemVersion] = ...
    AndroidNougat_MR1: typing.ClassVar[QOperatingSystemVersion] = ...
    AndroidOreo: typing.ClassVar[QOperatingSystemVersion] = ...
    IOS: typing.ClassVar[QOperatingSystemVersion.OSType] = ...
    MacOS: typing.ClassVar[QOperatingSystemVersion.OSType] = ...
    MacOSBigSur: typing.ClassVar[QOperatingSystemVersion] = ...
    MacOSCatalina: typing.ClassVar[QOperatingSystemVersion] = ...
    MacOSHighSierra: typing.ClassVar[QOperatingSystemVersion] = ...
    MacOSMojave: typing.ClassVar[QOperatingSystemVersion] = ...
    MacOSSierra: typing.ClassVar[QOperatingSystemVersion] = ...
    OSXElCapitan: typing.ClassVar[QOperatingSystemVersion] = ...
    OSXMavericks: typing.ClassVar[QOperatingSystemVersion] = ...
    OSXYosemite: typing.ClassVar[QOperatingSystemVersion] = ...
    TvOS: typing.ClassVar[QOperatingSystemVersion.OSType] = ...
    Unknown: typing.ClassVar[QOperatingSystemVersion.OSType] = ...
    WatchOS: typing.ClassVar[QOperatingSystemVersion.OSType] = ...
    Windows: typing.ClassVar[QOperatingSystemVersion.OSType] = ...
    Windows10: typing.ClassVar[QOperatingSystemVersion] = ...
    Windows7: typing.ClassVar[QOperatingSystemVersion] = ...
    Windows8: typing.ClassVar[QOperatingSystemVersion] = ...
    Windows8_1: typing.ClassVar[QOperatingSystemVersion] = ...
    @overload
    def __init__(self, osType: QOperatingSystemVersion.OSType, vmajor: int, vminor: int = ..., vmicro: int = ...) -> None: ...
    @overload
    def __init__(self, QOperatingSystemVersion: QOperatingSystemVersion) -> None: ...
    @classmethod
    def current(cls) -> QOperatingSystemVersion: ...
    @classmethod
    def currentType(cls) -> QOperatingSystemVersion.OSType: ...
    def majorVersion(self) -> int: ...
    def microVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    def name(self) -> str: ...
    def segmentCount(self) -> int: ...
    def type(self) -> QOperatingSystemVersion.OSType: ...
    def __copy__(self) -> None: ...

class QParallelAnimationGroup(QAnimationGroup):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., currentLoop: int = ..., currentLoopChanged: typing.Callable = ..., currentTime: int = ..., destroyed: typing.Callable = ..., direction: QParallelAnimationGroup.Direction = ..., directionChanged: typing.Callable = ..., duration: int = ..., finished: typing.Callable = ..., loopCount: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., state: QParallelAnimationGroup.State = ..., stateChanged: typing.Callable = ...) -> None: ...
    def duration(self) -> int: ...
    def event(self, event: QEvent) -> bool: ...
    def updateCurrentTime(self, currentTime: int) -> None: ...
    def updateDirection(self, direction: QAbstractAnimation.Direction) -> None: ...
    def updateState(self, newState: QAbstractAnimation.State, oldState: QAbstractAnimation.State) -> None: ...

class QPauseAnimation(QAbstractAnimation):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, msecs: int, parent: typing.Union[QObject,None] = ..., currentLoop: int = ..., currentLoopChanged: typing.Callable = ..., currentTime: int = ..., destroyed: typing.Callable = ..., direction: QPauseAnimation.Direction = ..., directionChanged: typing.Callable = ..., duration: int = ..., finished: typing.Callable = ..., loopCount: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., state: QPauseAnimation.State = ..., stateChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QObject,None] = ..., currentLoop: int = ..., currentLoopChanged: typing.Callable = ..., currentTime: int = ..., destroyed: typing.Callable = ..., direction: QPauseAnimation.Direction = ..., directionChanged: typing.Callable = ..., duration: int = ..., finished: typing.Callable = ..., loopCount: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., state: QPauseAnimation.State = ..., stateChanged: typing.Callable = ...) -> None: ...
    def duration(self) -> int: ...
    def event(self, e: QEvent) -> bool: ...
    def setDuration(self, msecs: int) -> None: ...
    def updateCurrentTime(self, arg__1: int) -> None: ...

class QPersistentModelIndex(shiboken2.Object):
    @overload
    def __init__(self, index: QModelIndex) -> None: ...
    @overload
    def __init__(self, other: QPersistentModelIndex) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def child(self, row: int, column: int) -> QModelIndex: ...
    def column(self) -> int: ...
    def data(self, role: Qt.ItemDataRole = ...) -> typing.Any: ...
    def flags(self) -> typing.Union[Qt.ItemFlags,Qt.ItemFlag]: ...
    def internalId(self) -> int: ...
    def internalPointer(self) -> typing.Any: ...
    def isValid(self) -> bool: ...
    def model(self) -> QAbstractItemModel: ...
    def parent(self) -> QModelIndex: ...
    def row(self) -> int: ...
    def sibling(self, row: int, column: int) -> QModelIndex: ...
    def swap(self, other: QPersistentModelIndex) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPluginLoader(QObject):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, fileName: str, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., loadHints: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., fileName: str = ..., loadHints: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def errorString(self) -> str: ...
    def fileName(self) -> str: ...
    def instance(self) -> QObject: ...
    def isLoaded(self) -> bool: ...
    def load(self) -> bool: ...
    def metaData(self) -> typing.Dict[str,QJsonValue]: ...
    def setFileName(self, fileName: str) -> None: ...
    @classmethod
    def staticInstances(cls) -> typing.List[QObject]: ...
    def unload(self) -> bool: ...

class QPoint(shiboken2.Object):
    @overload
    def __init__(self, xpos: int, ypos: int) -> None: ...
    @overload
    def __init__(self, QPoint: QPoint) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def dotProduct(cls, p1: QPoint, p2: QPoint) -> int: ...
    def isNull(self) -> bool: ...
    def manhattanLength(self) -> int: ...
    def setX(self, x: int) -> None: ...
    def setY(self, y: int) -> None: ...
    def toTuple(self) -> object: ...
    def transposed(self) -> QPoint: ...
    def x(self) -> int: ...
    def y(self) -> int: ...
    def __add__(self, p2: QPoint) -> QPoint: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __iadd__(self, p: QPoint) -> QPoint: ...
    @overload
    def __imul__(self, factor: float) -> QPoint: ...
    @overload
    def __imul__(self, factor: int) -> QPoint: ...
    def __isub__(self, p: QPoint) -> QPoint: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    @overload
    def __mul__(self, factor: float) -> QPoint: ...
    @overload
    def __mul__(self, factor: int) -> QPoint: ...
    def __ne__(self, other: object) -> bool: ...
    def __neg__(self) -> QPoint: ...
    def __pos__(self) -> QPoint: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __rtruediv__(self, other) -> typing.Any: ...
    def __sub__(self, p2: QPoint) -> QPoint: ...
    def __truediv__(self, other) -> typing.Any: ...

class QPointF(shiboken2.Object):
    @overload
    def __init__(self, xpos: float, ypos: float) -> None: ...
    @overload
    def __init__(self, QPointF: QPointF) -> None: ...
    @overload
    def __init__(self, p: QPoint) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def dotProduct(cls, p1: QPointF, p2: QPointF) -> float: ...
    def isNull(self) -> bool: ...
    def manhattanLength(self) -> float: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def toPoint(self) -> QPoint: ...
    def toTuple(self) -> object: ...
    def transposed(self) -> QPointF: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def __add__(self, p2: QPointF) -> QPointF: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, p: QPointF) -> QPointF: ...
    def __imul__(self, c: float) -> QPointF: ...
    def __isub__(self, p: QPointF) -> QPointF: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __mul__(self, c: float) -> QPointF: ...
    def __ne__(self, other: object) -> bool: ...
    def __neg__(self) -> QPointF: ...
    def __pos__(self) -> QPointF: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __rtruediv__(self, other) -> typing.Any: ...
    def __sub__(self, p2: QPointF) -> QPointF: ...
    def __truediv__(self, other) -> typing.Any: ...

class QProcess(QIODevice):
    class ExitStatus:
        CrashExit: typing.ClassVar[QProcess.ExitStatus] = ...
        NormalExit: typing.ClassVar[QProcess.ExitStatus] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QProcess.ExitStatus: ...
        def __and__(self, other: typing.SupportsInt) -> QProcess.ExitStatus: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QProcess.ExitStatus: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QProcess.ExitStatus: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QProcess.ExitStatus: ...
        def __rand__(self, other: typing.SupportsInt) -> QProcess.ExitStatus: ...
        def __rmul__(self, other: typing.SupportsInt) -> QProcess.ExitStatus: ...
        def __ror__(self, other: typing.SupportsInt) -> QProcess.ExitStatus: ...
        def __rsub__(self, other: typing.SupportsInt) -> QProcess.ExitStatus: ...
        def __rxor__(self, other: typing.SupportsInt) -> QProcess.ExitStatus: ...
        def __sub__(self, other: typing.SupportsInt) -> QProcess.ExitStatus: ...
        def __xor__(self, other: typing.SupportsInt) -> QProcess.ExitStatus: ...

    class InputChannelMode:
        ForwardedInputChannel: typing.ClassVar[QProcess.InputChannelMode] = ...
        ManagedInputChannel: typing.ClassVar[QProcess.InputChannelMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QProcess.InputChannelMode: ...
        def __and__(self, other: typing.SupportsInt) -> QProcess.InputChannelMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QProcess.InputChannelMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QProcess.InputChannelMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QProcess.InputChannelMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QProcess.InputChannelMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QProcess.InputChannelMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QProcess.InputChannelMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QProcess.InputChannelMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QProcess.InputChannelMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QProcess.InputChannelMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QProcess.InputChannelMode: ...

    class ProcessChannel:
        StandardError: typing.ClassVar[QProcess.ProcessChannel] = ...
        StandardOutput: typing.ClassVar[QProcess.ProcessChannel] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QProcess.ProcessChannel: ...
        def __and__(self, other: typing.SupportsInt) -> QProcess.ProcessChannel: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QProcess.ProcessChannel: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QProcess.ProcessChannel: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QProcess.ProcessChannel: ...
        def __rand__(self, other: typing.SupportsInt) -> QProcess.ProcessChannel: ...
        def __rmul__(self, other: typing.SupportsInt) -> QProcess.ProcessChannel: ...
        def __ror__(self, other: typing.SupportsInt) -> QProcess.ProcessChannel: ...
        def __rsub__(self, other: typing.SupportsInt) -> QProcess.ProcessChannel: ...
        def __rxor__(self, other: typing.SupportsInt) -> QProcess.ProcessChannel: ...
        def __sub__(self, other: typing.SupportsInt) -> QProcess.ProcessChannel: ...
        def __xor__(self, other: typing.SupportsInt) -> QProcess.ProcessChannel: ...

    class ProcessChannelMode:
        ForwardedChannels: typing.ClassVar[QProcess.ProcessChannelMode] = ...
        ForwardedErrorChannel: typing.ClassVar[QProcess.ProcessChannelMode] = ...
        ForwardedOutputChannel: typing.ClassVar[QProcess.ProcessChannelMode] = ...
        MergedChannels: typing.ClassVar[QProcess.ProcessChannelMode] = ...
        SeparateChannels: typing.ClassVar[QProcess.ProcessChannelMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QProcess.ProcessChannelMode: ...
        def __and__(self, other: typing.SupportsInt) -> QProcess.ProcessChannelMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QProcess.ProcessChannelMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QProcess.ProcessChannelMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QProcess.ProcessChannelMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QProcess.ProcessChannelMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QProcess.ProcessChannelMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QProcess.ProcessChannelMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QProcess.ProcessChannelMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QProcess.ProcessChannelMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QProcess.ProcessChannelMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QProcess.ProcessChannelMode: ...

    class ProcessError:
        Crashed: typing.ClassVar[QProcess.ProcessError] = ...
        FailedToStart: typing.ClassVar[QProcess.ProcessError] = ...
        ReadError: typing.ClassVar[QProcess.ProcessError] = ...
        Timedout: typing.ClassVar[QProcess.ProcessError] = ...
        UnknownError: typing.ClassVar[QProcess.ProcessError] = ...
        WriteError: typing.ClassVar[QProcess.ProcessError] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QProcess.ProcessError: ...
        def __and__(self, other: typing.SupportsInt) -> QProcess.ProcessError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QProcess.ProcessError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QProcess.ProcessError: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QProcess.ProcessError: ...
        def __rand__(self, other: typing.SupportsInt) -> QProcess.ProcessError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QProcess.ProcessError: ...
        def __ror__(self, other: typing.SupportsInt) -> QProcess.ProcessError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QProcess.ProcessError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QProcess.ProcessError: ...
        def __sub__(self, other: typing.SupportsInt) -> QProcess.ProcessError: ...
        def __xor__(self, other: typing.SupportsInt) -> QProcess.ProcessError: ...

    class ProcessState:
        NotRunning: typing.ClassVar[QProcess.ProcessState] = ...
        Running: typing.ClassVar[QProcess.ProcessState] = ...
        Starting: typing.ClassVar[QProcess.ProcessState] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QProcess.ProcessState: ...
        def __and__(self, other: typing.SupportsInt) -> QProcess.ProcessState: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QProcess.ProcessState: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QProcess.ProcessState: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QProcess.ProcessState: ...
        def __rand__(self, other: typing.SupportsInt) -> QProcess.ProcessState: ...
        def __rmul__(self, other: typing.SupportsInt) -> QProcess.ProcessState: ...
        def __ror__(self, other: typing.SupportsInt) -> QProcess.ProcessState: ...
        def __rsub__(self, other: typing.SupportsInt) -> QProcess.ProcessState: ...
        def __rxor__(self, other: typing.SupportsInt) -> QProcess.ProcessState: ...
        def __sub__(self, other: typing.SupportsInt) -> QProcess.ProcessState: ...
        def __xor__(self, other: typing.SupportsInt) -> QProcess.ProcessState: ...
    CrashExit: typing.ClassVar[QProcess.ExitStatus] = ...
    Crashed: typing.ClassVar[QProcess.ProcessError] = ...
    FailedToStart: typing.ClassVar[QProcess.ProcessError] = ...
    ForwardedChannels: typing.ClassVar[QProcess.ProcessChannelMode] = ...
    ForwardedErrorChannel: typing.ClassVar[QProcess.ProcessChannelMode] = ...
    ForwardedInputChannel: typing.ClassVar[QProcess.InputChannelMode] = ...
    ForwardedOutputChannel: typing.ClassVar[QProcess.ProcessChannelMode] = ...
    ManagedInputChannel: typing.ClassVar[QProcess.InputChannelMode] = ...
    MergedChannels: typing.ClassVar[QProcess.ProcessChannelMode] = ...
    NormalExit: typing.ClassVar[QProcess.ExitStatus] = ...
    NotRunning: typing.ClassVar[QProcess.ProcessState] = ...
    ReadError: typing.ClassVar[QProcess.ProcessError] = ...
    Running: typing.ClassVar[QProcess.ProcessState] = ...
    SeparateChannels: typing.ClassVar[QProcess.ProcessChannelMode] = ...
    StandardError: typing.ClassVar[QProcess.ProcessChannel] = ...
    StandardOutput: typing.ClassVar[QProcess.ProcessChannel] = ...
    Starting: typing.ClassVar[QProcess.ProcessState] = ...
    Timedout: typing.ClassVar[QProcess.ProcessError] = ...
    UnknownError: typing.ClassVar[QProcess.ProcessError] = ...
    WriteError: typing.ClassVar[QProcess.ProcessError] = ...
    error: typing.ClassVar[Signal] = ...
    errorOccurred: typing.ClassVar[Signal] = ...
    finished: typing.ClassVar[Signal] = ...
    readyReadStandardError: typing.ClassVar[Signal] = ...
    readyReadStandardOutput: typing.ClassVar[Signal] = ...
    started: typing.ClassVar[Signal] = ...
    stateChanged: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., error: typing.Callable = ..., errorOccurred: typing.Callable = ..., finished: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ..., readyReadStandardError: typing.Callable = ..., readyReadStandardOutput: typing.Callable = ..., started: typing.Callable = ..., stateChanged: typing.Callable = ...) -> None: ...
    def arguments(self) -> typing.List[str]: ...
    def atEnd(self) -> bool: ...
    def bytesAvailable(self) -> int: ...
    def bytesToWrite(self) -> int: ...
    def canReadLine(self) -> bool: ...
    def close(self) -> None: ...
    def closeReadChannel(self, channel: QProcess.ProcessChannel) -> None: ...
    def closeWriteChannel(self) -> None: ...
    def environment(self) -> typing.List[str]: ...
    @overload
    @classmethod
    def execute(cls, program: str, arguments: typing.Iterable[str]) -> int: ...
    @overload
    @classmethod
    def execute(cls, command: str) -> int: ...
    def exitCode(self) -> int: ...
    def exitStatus(self) -> QProcess.ExitStatus: ...
    def inputChannelMode(self) -> QProcess.InputChannelMode: ...
    def isSequential(self) -> bool: ...
    def kill(self) -> None: ...
    @classmethod
    def nullDevice(cls) -> str: ...
    def open(self, mode: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag] = ...) -> bool: ...
    def pid(self) -> int: ...
    def processChannelMode(self) -> QProcess.ProcessChannelMode: ...
    def processEnvironment(self) -> QProcessEnvironment: ...
    def processId(self) -> int: ...
    def program(self) -> str: ...
    def readAllStandardError(self) -> QByteArray: ...
    def readAllStandardOutput(self) -> QByteArray: ...
    def readChannel(self) -> QProcess.ProcessChannel: ...
    def readData(self, data: bytes, maxlen: int) -> int: ...
    def setArguments(self, arguments: typing.Iterable[str]) -> None: ...
    def setEnvironment(self, environment: typing.Iterable[str]) -> None: ...
    def setInputChannelMode(self, mode: QProcess.InputChannelMode) -> None: ...
    def setProcessChannelMode(self, mode: QProcess.ProcessChannelMode) -> None: ...
    def setProcessEnvironment(self, environment: QProcessEnvironment) -> None: ...
    def setProcessState(self, state: QProcess.ProcessState) -> None: ...
    def setProgram(self, program: str) -> None: ...
    def setReadChannel(self, channel: QProcess.ProcessChannel) -> None: ...
    def setStandardErrorFile(self, fileName: str, mode: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag] = ...) -> None: ...
    def setStandardInputFile(self, fileName: str) -> None: ...
    def setStandardOutputFile(self, fileName: str, mode: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag] = ...) -> None: ...
    def setStandardOutputProcess(self, destination: QProcess) -> None: ...
    def setWorkingDirectory(self, dir: str) -> None: ...
    def setupChildProcess(self) -> None: ...
    @overload
    def start(self, program: str, arguments: typing.Iterable[str], mode: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag] = ...) -> None: ...
    @overload
    def start(self, command: str, mode: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag] = ...) -> None: ...
    @overload
    def start(self, mode: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag] = ...) -> None: ...
    def startDetached(self) -> typing.Tuple[bool,int]: ...
    def state(self) -> QProcess.ProcessState: ...
    @classmethod
    def systemEnvironment(cls) -> typing.List[str]: ...
    def terminate(self) -> None: ...
    def waitForBytesWritten(self, msecs: int = ...) -> bool: ...
    def waitForFinished(self, msecs: int = ...) -> bool: ...
    def waitForReadyRead(self, msecs: int = ...) -> bool: ...
    def waitForStarted(self, msecs: int = ...) -> bool: ...
    def workingDirectory(self) -> str: ...
    def writeData(self, data: bytes, len: int) -> int: ...

class QProcessEnvironment(shiboken2.Object):
    @overload
    def __init__(self, other: QProcessEnvironment) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def contains(self, name: str) -> bool: ...
    @overload
    def insert(self, name: str, value: str) -> None: ...
    @overload
    def insert(self, e: QProcessEnvironment) -> None: ...
    def isEmpty(self) -> bool: ...
    def keys(self) -> typing.List[str]: ...
    def remove(self, name: str) -> None: ...
    def swap(self, other: QProcessEnvironment) -> None: ...
    @classmethod
    def systemEnvironment(cls) -> QProcessEnvironment: ...
    def toStringList(self) -> typing.List[str]: ...
    def value(self, name: str, defaultValue: str = ...) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QPropertyAnimation(QVariantAnimation):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, target: QObject, propertyName: typing.Union[QByteArray,bytes], parent: typing.Union[QObject,None] = ..., currentLoop: int = ..., currentLoopChanged: typing.Callable = ..., currentTime: int = ..., currentValue: object = ..., destroyed: typing.Callable = ..., direction: QPropertyAnimation.Direction = ..., directionChanged: typing.Callable = ..., duration: int = ..., easingCurve: typing.Union[QEasingCurve,QEasingCurve.Type] = ..., endValue: object = ..., finished: typing.Callable = ..., loopCount: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., startValue: object = ..., state: QPropertyAnimation.State = ..., stateChanged: typing.Callable = ..., targetObject: QObject = ..., valueChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QObject,None] = ..., currentLoop: int = ..., currentLoopChanged: typing.Callable = ..., currentTime: int = ..., currentValue: object = ..., destroyed: typing.Callable = ..., direction: QPropertyAnimation.Direction = ..., directionChanged: typing.Callable = ..., duration: int = ..., easingCurve: typing.Union[QEasingCurve,QEasingCurve.Type] = ..., endValue: object = ..., finished: typing.Callable = ..., loopCount: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., propertyName: typing.Union[QByteArray,bytes] = ..., startValue: object = ..., state: QPropertyAnimation.State = ..., stateChanged: typing.Callable = ..., targetObject: QObject = ..., valueChanged: typing.Callable = ...) -> None: ...
    def event(self, event: QEvent) -> bool: ...
    def propertyName(self) -> QByteArray: ...
    def setPropertyName(self, propertyName: typing.Union[QByteArray,bytes]) -> None: ...
    def setTargetObject(self, target: QObject) -> None: ...
    def targetObject(self) -> QObject: ...
    def updateCurrentValue(self, value: typing.Any) -> None: ...
    def updateState(self, newState: QAbstractAnimation.State, oldState: QAbstractAnimation.State) -> None: ...

class QRandomGenerator(shiboken2.Object):
    @overload
    def __init__(self, begin: int, end: int) -> None: ...
    @overload
    def __init__(self, seedBuffer: int, len: int) -> None: ...
    @overload
    def __init__(self, other: QRandomGenerator) -> None: ...
    @overload
    def __init__(self, seedValue: int = ...) -> None: ...
    @overload
    def bounded(self, lowest: int, highest: int) -> int: ...
    @overload
    def bounded(self, highest: float) -> float: ...
    @overload
    def bounded(self, highest: int) -> int: ...
    def discard(self, z: int) -> None: ...
    def generate(self) -> int: ...
    def generate64(self) -> int: ...
    def generateDouble(self) -> float: ...
    @classmethod
    def global_(cls) -> QRandomGenerator: ...
    @classmethod
    def max(cls) -> int: ...
    @classmethod
    def min(cls) -> int: ...
    @classmethod
    def securelySeeded(cls) -> QRandomGenerator: ...
    def seed(self, s: int = ...) -> None: ...
    @classmethod
    def system(cls) -> QRandomGenerator: ...

class QRandomGenerator64(QRandomGenerator):
    @overload
    def __init__(self, begin: int, end: int) -> None: ...
    @overload
    def __init__(self, seedBuffer: int, len: int) -> None: ...
    @overload
    def __init__(self, other: QRandomGenerator) -> None: ...
    @overload
    def __init__(self, seedValue: int = ...) -> None: ...
    def discard(self, z: int) -> None: ...
    def generate(self) -> int: ...
    @classmethod
    def global_(cls) -> QRandomGenerator64: ...
    @classmethod
    def max(cls) -> int: ...
    @classmethod
    def min(cls) -> int: ...
    @classmethod
    def securelySeeded(cls) -> QRandomGenerator64: ...
    @classmethod
    def system(cls) -> QRandomGenerator64: ...

class QReadLocker(shiboken2.Object):
    def __init__(self, readWriteLock: QReadWriteLock) -> None: ...
    def readWriteLock(self) -> QReadWriteLock: ...
    def relock(self) -> None: ...
    def unlock(self) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, arg__1: object, arg__2: object, arg__3: object) -> None: ...

class QReadWriteLock(shiboken2.Object):
    class RecursionMode:
        NonRecursive: typing.ClassVar[QReadWriteLock.RecursionMode] = ...
        Recursive: typing.ClassVar[QReadWriteLock.RecursionMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QReadWriteLock.RecursionMode: ...
        def __and__(self, other: typing.SupportsInt) -> QReadWriteLock.RecursionMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QReadWriteLock.RecursionMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QReadWriteLock.RecursionMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QReadWriteLock.RecursionMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QReadWriteLock.RecursionMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QReadWriteLock.RecursionMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QReadWriteLock.RecursionMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QReadWriteLock.RecursionMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QReadWriteLock.RecursionMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QReadWriteLock.RecursionMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QReadWriteLock.RecursionMode: ...
    NonRecursive: typing.ClassVar[QReadWriteLock.RecursionMode] = ...
    Recursive: typing.ClassVar[QReadWriteLock.RecursionMode] = ...
    def __init__(self, recursionMode: QReadWriteLock.RecursionMode = ...) -> None: ...
    def lockForRead(self) -> None: ...
    def lockForWrite(self) -> None: ...
    @overload
    def tryLockForRead(self, timeout: int) -> bool: ...
    @overload
    def tryLockForRead(self) -> bool: ...
    @overload
    def tryLockForWrite(self, timeout: int) -> bool: ...
    @overload
    def tryLockForWrite(self) -> bool: ...
    def unlock(self) -> None: ...

class QRect(shiboken2.Object):
    @overload
    def __init__(self, left: int, top: int, width: int, height: int) -> None: ...
    @overload
    def __init__(self, topleft: QPoint, bottomright: QPoint) -> None: ...
    @overload
    def __init__(self, topleft: QPoint, size: QSize) -> None: ...
    @overload
    def __init__(self, QRect: QRect) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def adjust(self, x1: int, y1: int, x2: int, y2: int) -> None: ...
    def adjusted(self, x1: int, y1: int, x2: int, y2: int) -> QRect: ...
    def bottom(self) -> int: ...
    def bottomLeft(self) -> QPoint: ...
    def bottomRight(self) -> QPoint: ...
    def center(self) -> QPoint: ...
    @overload
    def contains(self, x: int, y: int, proper: bool) -> bool: ...
    @overload
    def contains(self, p: QPoint, proper: bool = ...) -> bool: ...
    @overload
    def contains(self, r: QRect, proper: bool = ...) -> bool: ...
    @overload
    def contains(self, x: int, y: int) -> bool: ...
    def getCoords(self) -> typing.Tuple[int,int,int,int]: ...
    def getRect(self) -> typing.Tuple[int,int,int,int]: ...
    def height(self) -> int: ...
    def intersected(self, other: QRect) -> QRect: ...
    def intersects(self, r: QRect) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def left(self) -> int: ...
    def marginsAdded(self, margins: QMargins) -> QRect: ...
    def marginsRemoved(self, margins: QMargins) -> QRect: ...
    def moveBottom(self, pos: int) -> None: ...
    def moveBottomLeft(self, p: QPoint) -> None: ...
    def moveBottomRight(self, p: QPoint) -> None: ...
    def moveCenter(self, p: QPoint) -> None: ...
    def moveLeft(self, pos: int) -> None: ...
    def moveRight(self, pos: int) -> None: ...
    @overload
    def moveTo(self, x: int, t: int) -> None: ...
    @overload
    def moveTo(self, p: QPoint) -> None: ...
    def moveTop(self, pos: int) -> None: ...
    def moveTopLeft(self, p: QPoint) -> None: ...
    def moveTopRight(self, p: QPoint) -> None: ...
    def normalized(self) -> QRect: ...
    def right(self) -> int: ...
    def setBottom(self, pos: int) -> None: ...
    def setBottomLeft(self, p: QPoint) -> None: ...
    def setBottomRight(self, p: QPoint) -> None: ...
    def setCoords(self, x1: int, y1: int, x2: int, y2: int) -> None: ...
    def setHeight(self, h: int) -> None: ...
    def setLeft(self, pos: int) -> None: ...
    def setRect(self, x: int, y: int, w: int, h: int) -> None: ...
    def setRight(self, pos: int) -> None: ...
    def setSize(self, s: QSize) -> None: ...
    def setTop(self, pos: int) -> None: ...
    def setTopLeft(self, p: QPoint) -> None: ...
    def setTopRight(self, p: QPoint) -> None: ...
    def setWidth(self, w: int) -> None: ...
    def setX(self, x: int) -> None: ...
    def setY(self, y: int) -> None: ...
    def size(self) -> QSize: ...
    def top(self) -> int: ...
    def topLeft(self) -> QPoint: ...
    def topRight(self) -> QPoint: ...
    @overload
    def translate(self, dx: int, dy: int) -> None: ...
    @overload
    def translate(self, p: QPoint) -> None: ...
    @overload
    def translated(self, dx: int, dy: int) -> QRect: ...
    @overload
    def translated(self, p: QPoint) -> QRect: ...
    def transposed(self) -> QRect: ...
    def united(self, other: QRect) -> QRect: ...
    def width(self) -> int: ...
    def x(self) -> int: ...
    def y(self) -> int: ...
    def __add__(self, margins: QMargins) -> QRect: ...
    def __and__(self, r: QRect) -> QRect: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __iadd__(self, margins: QMargins) -> QRect: ...
    def __iand__(self, r: QRect) -> QRect: ...
    def __ior__(self, r: QRect) -> QRect: ...
    def __isub__(self, margins: QMargins) -> QRect: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, r: QRect) -> QRect: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rand__(self, other) -> typing.Any: ...
    def __ror__(self, other) -> typing.Any: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __sub__(self, rhs: QMargins) -> QRect: ...

class QRectF(shiboken2.Object):
    @overload
    def __init__(self, left: float, top: float, width: float, height: float) -> None: ...
    @overload
    def __init__(self, topleft: QPointF, bottomRight: QPointF) -> None: ...
    @overload
    def __init__(self, topleft: QPointF, size: QSizeF) -> None: ...
    @overload
    def __init__(self, QRectF: QRectF) -> None: ...
    @overload
    def __init__(self, rect: QRect) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def adjust(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def adjusted(self, x1: float, y1: float, x2: float, y2: float) -> QRectF: ...
    def bottom(self) -> float: ...
    def bottomLeft(self) -> QPointF: ...
    def bottomRight(self) -> QPointF: ...
    def center(self) -> QPointF: ...
    @overload
    def contains(self, x: float, y: float) -> bool: ...
    @overload
    def contains(self, p: QPointF) -> bool: ...
    @overload
    def contains(self, r: QRectF) -> bool: ...
    def getCoords(self) -> typing.Tuple[float,float,float,float]: ...
    def getRect(self) -> typing.Tuple[float,float,float,float]: ...
    def height(self) -> float: ...
    def intersected(self, other: QRectF) -> QRectF: ...
    def intersects(self, r: QRectF) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def left(self) -> float: ...
    def marginsAdded(self, margins: QMarginsF) -> QRectF: ...
    def marginsRemoved(self, margins: QMarginsF) -> QRectF: ...
    def moveBottom(self, pos: float) -> None: ...
    def moveBottomLeft(self, p: QPointF) -> None: ...
    def moveBottomRight(self, p: QPointF) -> None: ...
    def moveCenter(self, p: QPointF) -> None: ...
    def moveLeft(self, pos: float) -> None: ...
    def moveRight(self, pos: float) -> None: ...
    @overload
    def moveTo(self, x: float, y: float) -> None: ...
    @overload
    def moveTo(self, p: QPointF) -> None: ...
    def moveTop(self, pos: float) -> None: ...
    def moveTopLeft(self, p: QPointF) -> None: ...
    def moveTopRight(self, p: QPointF) -> None: ...
    def normalized(self) -> QRectF: ...
    def right(self) -> float: ...
    def setBottom(self, pos: float) -> None: ...
    def setBottomLeft(self, p: QPointF) -> None: ...
    def setBottomRight(self, p: QPointF) -> None: ...
    def setCoords(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def setHeight(self, h: float) -> None: ...
    def setLeft(self, pos: float) -> None: ...
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def setRight(self, pos: float) -> None: ...
    def setSize(self, s: QSizeF) -> None: ...
    def setTop(self, pos: float) -> None: ...
    def setTopLeft(self, p: QPointF) -> None: ...
    def setTopRight(self, p: QPointF) -> None: ...
    def setWidth(self, w: float) -> None: ...
    def setX(self, pos: float) -> None: ...
    def setY(self, pos: float) -> None: ...
    def size(self) -> QSizeF: ...
    def toAlignedRect(self) -> QRect: ...
    def toRect(self) -> QRect: ...
    def top(self) -> float: ...
    def topLeft(self) -> QPointF: ...
    def topRight(self) -> QPointF: ...
    @overload
    def translate(self, dx: float, dy: float) -> None: ...
    @overload
    def translate(self, p: QPointF) -> None: ...
    @overload
    def translated(self, dx: float, dy: float) -> QRectF: ...
    @overload
    def translated(self, p: QPointF) -> QRectF: ...
    def transposed(self) -> QRectF: ...
    def united(self, other: QRectF) -> QRectF: ...
    def width(self) -> float: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    @overload
    def __add__(self, lhs: QMarginsF) -> QRectF: ...
    @overload
    def __add__(self, rhs: QMarginsF) -> QRectF: ...
    def __and__(self, r: QRectF) -> QRectF: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, margins: QMarginsF) -> QRectF: ...
    def __iand__(self, r: QRectF) -> QRectF: ...
    def __ior__(self, r: QRectF) -> QRectF: ...
    def __isub__(self, margins: QMarginsF) -> QRectF: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, r: QRectF) -> QRectF: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rand__(self, other) -> typing.Any: ...
    def __ror__(self, other) -> typing.Any: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __sub__(self, rhs: QMarginsF) -> QRectF: ...

class QRecursiveMutex(shiboken2.Object):
    def __init__(self) -> None: ...

class QRegExp(shiboken2.Object):
    class CaretMode:
        CaretAtOffset: typing.ClassVar[QRegExp.CaretMode] = ...
        CaretAtZero: typing.ClassVar[QRegExp.CaretMode] = ...
        CaretWontMatch: typing.ClassVar[QRegExp.CaretMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRegExp.CaretMode: ...
        def __and__(self, other: typing.SupportsInt) -> QRegExp.CaretMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRegExp.CaretMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRegExp.CaretMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QRegExp.CaretMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QRegExp.CaretMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRegExp.CaretMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QRegExp.CaretMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRegExp.CaretMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRegExp.CaretMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QRegExp.CaretMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QRegExp.CaretMode: ...

    class PatternSyntax:
        FixedString: typing.ClassVar[QRegExp.PatternSyntax] = ...
        RegExp: typing.ClassVar[QRegExp.PatternSyntax] = ...
        RegExp2: typing.ClassVar[QRegExp.PatternSyntax] = ...
        W3CXmlSchema11: typing.ClassVar[QRegExp.PatternSyntax] = ...
        Wildcard: typing.ClassVar[QRegExp.PatternSyntax] = ...
        WildcardUnix: typing.ClassVar[QRegExp.PatternSyntax] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRegExp.PatternSyntax: ...
        def __and__(self, other: typing.SupportsInt) -> QRegExp.PatternSyntax: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRegExp.PatternSyntax: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRegExp.PatternSyntax: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QRegExp.PatternSyntax: ...
        def __rand__(self, other: typing.SupportsInt) -> QRegExp.PatternSyntax: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRegExp.PatternSyntax: ...
        def __ror__(self, other: typing.SupportsInt) -> QRegExp.PatternSyntax: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRegExp.PatternSyntax: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRegExp.PatternSyntax: ...
        def __sub__(self, other: typing.SupportsInt) -> QRegExp.PatternSyntax: ...
        def __xor__(self, other: typing.SupportsInt) -> QRegExp.PatternSyntax: ...
    CaretAtOffset: typing.ClassVar[QRegExp.CaretMode] = ...
    CaretAtZero: typing.ClassVar[QRegExp.CaretMode] = ...
    CaretWontMatch: typing.ClassVar[QRegExp.CaretMode] = ...
    FixedString: typing.ClassVar[QRegExp.PatternSyntax] = ...
    RegExp: typing.ClassVar[QRegExp.PatternSyntax] = ...
    RegExp2: typing.ClassVar[QRegExp.PatternSyntax] = ...
    W3CXmlSchema11: typing.ClassVar[QRegExp.PatternSyntax] = ...
    Wildcard: typing.ClassVar[QRegExp.PatternSyntax] = ...
    WildcardUnix: typing.ClassVar[QRegExp.PatternSyntax] = ...
    @overload
    def __init__(self, pattern: str, cs: Qt.CaseSensitivity = ..., syntax: QRegExp.PatternSyntax = ...) -> None: ...
    @overload
    def __init__(self, rx: QRegExp) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def cap(self, nth: int = ...) -> str: ...
    def captureCount(self) -> int: ...
    def capturedTexts(self) -> typing.List[str]: ...
    def caseSensitivity(self) -> Qt.CaseSensitivity: ...
    def errorString(self) -> str: ...
    @classmethod
    def escape(cls, str: str) -> str: ...
    def exactMatch(self, str: str) -> bool: ...
    def indexIn(self, str: str, offset: int = ..., caretMode: QRegExp.CaretMode = ...) -> int: ...
    def isEmpty(self) -> bool: ...
    def isMinimal(self) -> bool: ...
    def isValid(self) -> bool: ...
    def lastIndexIn(self, str: str, offset: int = ..., caretMode: QRegExp.CaretMode = ...) -> int: ...
    def matchedLength(self) -> int: ...
    def pattern(self) -> str: ...
    def patternSyntax(self) -> QRegExp.PatternSyntax: ...
    def pos(self, nth: int = ...) -> int: ...
    def replace(self, sourceString: str, after: str) -> str: ...
    def setCaseSensitivity(self, cs: Qt.CaseSensitivity) -> None: ...
    def setMinimal(self, minimal: bool) -> None: ...
    def setPattern(self, pattern: str) -> None: ...
    def setPatternSyntax(self, syntax: QRegExp.PatternSyntax) -> None: ...
    def swap(self, other: QRegExp) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QRegularExpression(shiboken2.Object):
    class MatchOption:
        AnchoredMatchOption: typing.ClassVar[QRegularExpression.MatchOption] = ...
        DontCheckSubjectStringMatchOption: typing.ClassVar[QRegularExpression.MatchOption] = ...
        NoMatchOption: typing.ClassVar[QRegularExpression.MatchOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QRegularExpression.MatchOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QRegularExpression.MatchOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRegularExpression.MatchOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QRegularExpression.MatchOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QRegularExpression.MatchOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRegularExpression.MatchOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QRegularExpression.MatchOptions: ...

    class MatchOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QRegularExpression.MatchOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QRegularExpression.MatchOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRegularExpression.MatchOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QRegularExpression.MatchOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QRegularExpression.MatchOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRegularExpression.MatchOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QRegularExpression.MatchOptions: ...

    class MatchType:
        NoMatch: typing.ClassVar[QRegularExpression.MatchType] = ...
        NormalMatch: typing.ClassVar[QRegularExpression.MatchType] = ...
        PartialPreferCompleteMatch: typing.ClassVar[QRegularExpression.MatchType] = ...
        PartialPreferFirstMatch: typing.ClassVar[QRegularExpression.MatchType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QRegularExpression.MatchType: ...
        def __and__(self, other: typing.SupportsInt) -> QRegularExpression.MatchType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QRegularExpression.MatchType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRegularExpression.MatchType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QRegularExpression.MatchType: ...
        def __rand__(self, other: typing.SupportsInt) -> QRegularExpression.MatchType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QRegularExpression.MatchType: ...
        def __ror__(self, other: typing.SupportsInt) -> QRegularExpression.MatchType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QRegularExpression.MatchType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRegularExpression.MatchType: ...
        def __sub__(self, other: typing.SupportsInt) -> QRegularExpression.MatchType: ...
        def __xor__(self, other: typing.SupportsInt) -> QRegularExpression.MatchType: ...

    class PatternOption:
        CaseInsensitiveOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
        DontAutomaticallyOptimizeOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
        DontCaptureOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
        DotMatchesEverythingOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
        ExtendedPatternSyntaxOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
        InvertedGreedinessOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
        MultilineOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
        NoPatternOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
        OptimizeOnFirstUsageOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
        UseUnicodePropertiesOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QRegularExpression.PatternOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QRegularExpression.PatternOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRegularExpression.PatternOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QRegularExpression.PatternOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QRegularExpression.PatternOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRegularExpression.PatternOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QRegularExpression.PatternOptions: ...

    class PatternOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QRegularExpression.PatternOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QRegularExpression.PatternOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QRegularExpression.PatternOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QRegularExpression.PatternOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QRegularExpression.PatternOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QRegularExpression.PatternOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QRegularExpression.PatternOptions: ...
    AnchoredMatchOption: typing.ClassVar[QRegularExpression.MatchOption] = ...
    CaseInsensitiveOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
    DontAutomaticallyOptimizeOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
    DontCaptureOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
    DontCheckSubjectStringMatchOption: typing.ClassVar[QRegularExpression.MatchOption] = ...
    DotMatchesEverythingOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
    ExtendedPatternSyntaxOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
    InvertedGreedinessOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
    MultilineOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
    NoMatch: typing.ClassVar[QRegularExpression.MatchType] = ...
    NoMatchOption: typing.ClassVar[QRegularExpression.MatchOption] = ...
    NoPatternOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
    NormalMatch: typing.ClassVar[QRegularExpression.MatchType] = ...
    OptimizeOnFirstUsageOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
    PartialPreferCompleteMatch: typing.ClassVar[QRegularExpression.MatchType] = ...
    PartialPreferFirstMatch: typing.ClassVar[QRegularExpression.MatchType] = ...
    UseUnicodePropertiesOption: typing.ClassVar[QRegularExpression.PatternOption] = ...
    @overload
    def __init__(self, pattern: str, options: typing.Union[QRegularExpression.PatternOptions,QRegularExpression.PatternOption] = ...) -> None: ...
    @overload
    def __init__(self, re: QRegularExpression) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def anchoredPattern(cls, expression: str) -> str: ...
    def captureCount(self) -> int: ...
    def errorString(self) -> str: ...
    @classmethod
    def escape(cls, str: str) -> str: ...
    @overload
    def globalMatch(self, subject: str, offset: int = ..., matchType: QRegularExpression.MatchType = ..., matchOptions: typing.Union[QRegularExpression.MatchOptions,QRegularExpression.MatchOption] = ...) -> QRegularExpressionMatchIterator: ...
    @overload
    def globalMatch(self, subjectRef: str, offset: int = ..., matchType: QRegularExpression.MatchType = ..., matchOptions: typing.Union[QRegularExpression.MatchOptions,QRegularExpression.MatchOption] = ...) -> QRegularExpressionMatchIterator: ...
    def isValid(self) -> bool: ...
    @overload
    def match(self, subject: str, offset: int = ..., matchType: QRegularExpression.MatchType = ..., matchOptions: typing.Union[QRegularExpression.MatchOptions,QRegularExpression.MatchOption] = ...) -> QRegularExpressionMatch: ...
    @overload
    def match(self, subjectRef: str, offset: int = ..., matchType: QRegularExpression.MatchType = ..., matchOptions: typing.Union[QRegularExpression.MatchOptions,QRegularExpression.MatchOption] = ...) -> QRegularExpressionMatch: ...
    def namedCaptureGroups(self) -> typing.List[str]: ...
    def optimize(self) -> None: ...
    def pattern(self) -> str: ...
    def patternErrorOffset(self) -> int: ...
    def patternOptions(self) -> typing.Union[QRegularExpression.PatternOptions,QRegularExpression.PatternOption]: ...
    def setPattern(self, pattern: str) -> None: ...
    def setPatternOptions(self, options: typing.Union[QRegularExpression.PatternOptions,QRegularExpression.PatternOption]) -> None: ...
    def swap(self, other: QRegularExpression) -> None: ...
    @classmethod
    def wildcardToRegularExpression(cls, str: str) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QRegularExpressionMatch(shiboken2.Object):
    @overload
    def __init__(self, match: QRegularExpressionMatch) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def captured(self, name: str) -> str: ...
    @overload
    def captured(self, nth: int = ...) -> str: ...
    @overload
    def capturedEnd(self, name: str) -> int: ...
    @overload
    def capturedEnd(self, nth: int = ...) -> int: ...
    @overload
    def capturedLength(self, name: str) -> int: ...
    @overload
    def capturedLength(self, nth: int = ...) -> int: ...
    @overload
    def capturedRef(self, name: str) -> str: ...
    @overload
    def capturedRef(self, nth: int = ...) -> str: ...
    @overload
    def capturedStart(self, name: str) -> int: ...
    @overload
    def capturedStart(self, nth: int = ...) -> int: ...
    def capturedTexts(self) -> typing.List[str]: ...
    def hasMatch(self) -> bool: ...
    def hasPartialMatch(self) -> bool: ...
    def isValid(self) -> bool: ...
    def lastCapturedIndex(self) -> int: ...
    def matchOptions(self) -> typing.Union[QRegularExpression.MatchOptions,QRegularExpression.MatchOption]: ...
    def matchType(self) -> QRegularExpression.MatchType: ...
    def regularExpression(self) -> QRegularExpression: ...
    def swap(self, other: QRegularExpressionMatch) -> None: ...
    def __copy__(self) -> None: ...

class QRegularExpressionMatchIterator(shiboken2.Object):
    @overload
    def __init__(self, iterator: QRegularExpressionMatchIterator) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def hasNext(self) -> bool: ...
    def isValid(self) -> bool: ...
    def matchOptions(self) -> typing.Union[QRegularExpression.MatchOptions,QRegularExpression.MatchOption]: ...
    def matchType(self) -> QRegularExpression.MatchType: ...
    def next(self) -> QRegularExpressionMatch: ...
    def peekNext(self) -> QRegularExpressionMatch: ...
    def regularExpression(self) -> QRegularExpression: ...
    def swap(self, other: QRegularExpressionMatchIterator) -> None: ...
    def __copy__(self) -> None: ...

class QResource(shiboken2.Object):
    class Compression:
        NoCompression: typing.ClassVar[QResource.Compression] = ...
        ZlibCompression: typing.ClassVar[QResource.Compression] = ...
        ZstdCompression: typing.ClassVar[QResource.Compression] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QResource.Compression: ...
        def __and__(self, other: typing.SupportsInt) -> QResource.Compression: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QResource.Compression: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QResource.Compression: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QResource.Compression: ...
        def __rand__(self, other: typing.SupportsInt) -> QResource.Compression: ...
        def __rmul__(self, other: typing.SupportsInt) -> QResource.Compression: ...
        def __ror__(self, other: typing.SupportsInt) -> QResource.Compression: ...
        def __rsub__(self, other: typing.SupportsInt) -> QResource.Compression: ...
        def __rxor__(self, other: typing.SupportsInt) -> QResource.Compression: ...
        def __sub__(self, other: typing.SupportsInt) -> QResource.Compression: ...
        def __xor__(self, other: typing.SupportsInt) -> QResource.Compression: ...
    NoCompression: typing.ClassVar[QResource.Compression] = ...
    ZlibCompression: typing.ClassVar[QResource.Compression] = ...
    ZstdCompression: typing.ClassVar[QResource.Compression] = ...
    def __init__(self, file: str = ..., locale: QLocale = ...) -> None: ...
    def absoluteFilePath(self) -> str: ...
    @classmethod
    def addSearchPath(cls, path: str) -> None: ...
    def children(self) -> typing.List[str]: ...
    def compressionAlgorithm(self) -> QResource.Compression: ...
    def data(self) -> bytes: ...
    def fileName(self) -> str: ...
    def isCompressed(self) -> bool: ...
    def isDir(self) -> bool: ...
    def isFile(self) -> bool: ...
    def isValid(self) -> bool: ...
    def lastModified(self) -> QDateTime: ...
    def locale(self) -> QLocale: ...
    @classmethod
    def registerResource(cls, rccFilename: str, resourceRoot: str = ...) -> bool: ...
    @classmethod
    def registerResourceData(cls, rccData: bytes, resourceRoot: str = ...) -> bool: ...
    @classmethod
    def searchPaths(cls) -> typing.List[str]: ...
    def setFileName(self, file: str) -> None: ...
    def setLocale(self, locale: QLocale) -> None: ...
    def size(self) -> int: ...
    def uncompressedData(self) -> QByteArray: ...
    def uncompressedSize(self) -> int: ...
    @classmethod
    def unregisterResource(cls, rccFilename: str, resourceRoot: str = ...) -> bool: ...
    @classmethod
    def unregisterResourceData(cls, rccData: bytes, resourceRoot: str = ...) -> bool: ...

class QRunnable(shiboken2.Object):
    def __init__(self) -> None: ...
    def autoDelete(self) -> bool: ...
    def run(self) -> None: ...
    def setAutoDelete(self, _autoDelete: bool) -> None: ...

class QSaveFile(QFileDevice):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, name: str, parent: typing.Union[QObject,None], aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, name: str, aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QObject,None] = ..., aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    def cancelWriting(self) -> None: ...
    def close(self) -> None: ...
    def commit(self) -> bool: ...
    def directWriteFallback(self) -> bool: ...
    def fileName(self) -> str: ...
    def open(self, flags: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag]) -> bool: ...
    def setDirectWriteFallback(self, enabled: bool) -> None: ...
    def setFileName(self, name: str) -> None: ...
    def writeData(self, data: bytes, len: int) -> int: ...

class QSemaphore(shiboken2.Object):
    def __init__(self, n: int = ...) -> None: ...
    def acquire(self, n: int = ...) -> None: ...
    def available(self) -> int: ...
    def release(self, n: int = ...) -> None: ...
    @overload
    def tryAcquire(self, n: int, timeout: int) -> bool: ...
    @overload
    def tryAcquire(self, n: int = ...) -> bool: ...

class QSemaphoreReleaser(shiboken2.Object):
    @overload
    def __init__(self, sem: QSemaphore, n: int = ...) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def cancel(self) -> QSemaphore: ...
    def semaphore(self) -> QSemaphore: ...
    def swap(self, other: QSemaphoreReleaser) -> None: ...

class QSequentialAnimationGroup(QAnimationGroup):
    currentAnimationChanged: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., currentAnimation: QAbstractAnimation = ..., currentAnimationChanged: typing.Callable = ..., currentLoop: int = ..., currentLoopChanged: typing.Callable = ..., currentTime: int = ..., destroyed: typing.Callable = ..., direction: QSequentialAnimationGroup.Direction = ..., directionChanged: typing.Callable = ..., duration: int = ..., finished: typing.Callable = ..., loopCount: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., state: QSequentialAnimationGroup.State = ..., stateChanged: typing.Callable = ...) -> None: ...
    def addPause(self, msecs: int) -> QPauseAnimation: ...
    def currentAnimation(self) -> QAbstractAnimation: ...
    def duration(self) -> int: ...
    def event(self, event: QEvent) -> bool: ...
    def insertPause(self, index: int, msecs: int) -> QPauseAnimation: ...
    def updateCurrentTime(self, arg__1: int) -> None: ...
    def updateDirection(self, direction: QAbstractAnimation.Direction) -> None: ...
    def updateState(self, newState: QAbstractAnimation.State, oldState: QAbstractAnimation.State) -> None: ...

class QSettings(QObject):
    class Format:
        CustomFormat1: typing.ClassVar[QSettings.Format] = ...
        CustomFormat10: typing.ClassVar[QSettings.Format] = ...
        CustomFormat11: typing.ClassVar[QSettings.Format] = ...
        CustomFormat12: typing.ClassVar[QSettings.Format] = ...
        CustomFormat13: typing.ClassVar[QSettings.Format] = ...
        CustomFormat14: typing.ClassVar[QSettings.Format] = ...
        CustomFormat15: typing.ClassVar[QSettings.Format] = ...
        CustomFormat16: typing.ClassVar[QSettings.Format] = ...
        CustomFormat2: typing.ClassVar[QSettings.Format] = ...
        CustomFormat3: typing.ClassVar[QSettings.Format] = ...
        CustomFormat4: typing.ClassVar[QSettings.Format] = ...
        CustomFormat5: typing.ClassVar[QSettings.Format] = ...
        CustomFormat6: typing.ClassVar[QSettings.Format] = ...
        CustomFormat7: typing.ClassVar[QSettings.Format] = ...
        CustomFormat8: typing.ClassVar[QSettings.Format] = ...
        CustomFormat9: typing.ClassVar[QSettings.Format] = ...
        IniFormat: typing.ClassVar[QSettings.Format] = ...
        InvalidFormat: typing.ClassVar[QSettings.Format] = ...
        NativeFormat: typing.ClassVar[QSettings.Format] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSettings.Format: ...
        def __and__(self, other: typing.SupportsInt) -> QSettings.Format: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSettings.Format: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSettings.Format: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSettings.Format: ...
        def __rand__(self, other: typing.SupportsInt) -> QSettings.Format: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSettings.Format: ...
        def __ror__(self, other: typing.SupportsInt) -> QSettings.Format: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSettings.Format: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSettings.Format: ...
        def __sub__(self, other: typing.SupportsInt) -> QSettings.Format: ...
        def __xor__(self, other: typing.SupportsInt) -> QSettings.Format: ...

    class Scope:
        SystemScope: typing.ClassVar[QSettings.Scope] = ...
        UserScope: typing.ClassVar[QSettings.Scope] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSettings.Scope: ...
        def __and__(self, other: typing.SupportsInt) -> QSettings.Scope: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSettings.Scope: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSettings.Scope: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSettings.Scope: ...
        def __rand__(self, other: typing.SupportsInt) -> QSettings.Scope: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSettings.Scope: ...
        def __ror__(self, other: typing.SupportsInt) -> QSettings.Scope: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSettings.Scope: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSettings.Scope: ...
        def __sub__(self, other: typing.SupportsInt) -> QSettings.Scope: ...
        def __xor__(self, other: typing.SupportsInt) -> QSettings.Scope: ...

    class Status:
        AccessError: typing.ClassVar[QSettings.Status] = ...
        FormatError: typing.ClassVar[QSettings.Status] = ...
        NoError: typing.ClassVar[QSettings.Status] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSettings.Status: ...
        def __and__(self, other: typing.SupportsInt) -> QSettings.Status: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSettings.Status: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSettings.Status: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSettings.Status: ...
        def __rand__(self, other: typing.SupportsInt) -> QSettings.Status: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSettings.Status: ...
        def __ror__(self, other: typing.SupportsInt) -> QSettings.Status: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSettings.Status: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSettings.Status: ...
        def __sub__(self, other: typing.SupportsInt) -> QSettings.Status: ...
        def __xor__(self, other: typing.SupportsInt) -> QSettings.Status: ...
    AccessError: typing.ClassVar[QSettings.Status] = ...
    CustomFormat1: typing.ClassVar[QSettings.Format] = ...
    CustomFormat10: typing.ClassVar[QSettings.Format] = ...
    CustomFormat11: typing.ClassVar[QSettings.Format] = ...
    CustomFormat12: typing.ClassVar[QSettings.Format] = ...
    CustomFormat13: typing.ClassVar[QSettings.Format] = ...
    CustomFormat14: typing.ClassVar[QSettings.Format] = ...
    CustomFormat15: typing.ClassVar[QSettings.Format] = ...
    CustomFormat16: typing.ClassVar[QSettings.Format] = ...
    CustomFormat2: typing.ClassVar[QSettings.Format] = ...
    CustomFormat3: typing.ClassVar[QSettings.Format] = ...
    CustomFormat4: typing.ClassVar[QSettings.Format] = ...
    CustomFormat5: typing.ClassVar[QSettings.Format] = ...
    CustomFormat6: typing.ClassVar[QSettings.Format] = ...
    CustomFormat7: typing.ClassVar[QSettings.Format] = ...
    CustomFormat8: typing.ClassVar[QSettings.Format] = ...
    CustomFormat9: typing.ClassVar[QSettings.Format] = ...
    FormatError: typing.ClassVar[QSettings.Status] = ...
    IniFormat: typing.ClassVar[QSettings.Format] = ...
    InvalidFormat: typing.ClassVar[QSettings.Format] = ...
    NativeFormat: typing.ClassVar[QSettings.Format] = ...
    NoError: typing.ClassVar[QSettings.Status] = ...
    SystemScope: typing.ClassVar[QSettings.Scope] = ...
    UserScope: typing.ClassVar[QSettings.Scope] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, format: QSettings.Format, scope: QSettings.Scope, organization: str, application: str = ..., parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, scope: QSettings.Scope, organization: str, application: str = ..., parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, fileName: str, format: QSettings.Format, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, organization: str, application: str = ..., parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, scope: QSettings.Scope, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def allKeys(self) -> typing.List[str]: ...
    def applicationName(self) -> str: ...
    def beginGroup(self, prefix: str) -> None: ...
    def beginReadArray(self, prefix: str) -> int: ...
    def beginWriteArray(self, prefix: str, size: int = ...) -> None: ...
    def childGroups(self) -> typing.List[str]: ...
    def childKeys(self) -> typing.List[str]: ...
    def clear(self) -> None: ...
    def contains(self, key: str) -> bool: ...
    @classmethod
    def defaultFormat(cls) -> QSettings.Format: ...
    def endArray(self) -> None: ...
    def endGroup(self) -> None: ...
    def event(self, event: QEvent) -> bool: ...
    def fallbacksEnabled(self) -> bool: ...
    def fileName(self) -> str: ...
    def format(self) -> QSettings.Format: ...
    def group(self) -> str: ...
    def iniCodec(self) -> QTextCodec: ...
    def isAtomicSyncRequired(self) -> bool: ...
    def isWritable(self) -> bool: ...
    def organizationName(self) -> str: ...
    def remove(self, key: str) -> None: ...
    def scope(self) -> QSettings.Scope: ...
    def setArrayIndex(self, i: int) -> None: ...
    def setAtomicSyncRequired(self, enable: bool) -> None: ...
    @classmethod
    def setDefaultFormat(cls, format: QSettings.Format) -> None: ...
    def setFallbacksEnabled(self, b: bool) -> None: ...
    @overload
    def setIniCodec(self, codec: QTextCodec) -> None: ...
    @overload
    def setIniCodec(self, codecName: bytes) -> None: ...
    @classmethod
    def setPath(cls, format: QSettings.Format, scope: QSettings.Scope, path: str) -> None: ...
    def setValue(self, key: str, value: typing.Any) -> None: ...
    def status(self) -> QSettings.Status: ...
    def sync(self) -> None: ...
    def value(self, arg__1: str, defaultValue: typing.Union[typing.Any,None] = ..., type: typing.Union[typing.Any,None] = ...) -> typing.Any: ...

class QSignalBlocker(shiboken2.Object):
    def __init__(self, o: QObject) -> None: ...
    def reblock(self) -> None: ...
    def unblock(self) -> None: ...

class QSignalMapper(QObject):
    mapped: typing.ClassVar[Signal] = ...
    mappedInt: typing.ClassVar[Signal] = ...
    mappedObject: typing.ClassVar[Signal] = ...
    mappedString: typing.ClassVar[Signal] = ...
    mappedWidget: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., mapped: typing.Callable = ..., mappedInt: typing.Callable = ..., mappedObject: typing.Callable = ..., mappedString: typing.Callable = ..., mappedWidget: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def map(self, sender: QObject) -> None: ...
    @overload
    def map(self) -> None: ...
    @overload
    def mapping(self, id: int) -> QObject: ...
    @overload
    def mapping(self, object: QObject) -> QObject: ...
    @overload
    def mapping(self, text: str) -> QObject: ...
    def removeMappings(self, sender: QObject) -> None: ...
    @overload
    def setMapping(self, sender: QObject, id: int) -> None: ...
    @overload
    def setMapping(self, sender: QObject, object: QObject) -> None: ...
    @overload
    def setMapping(self, sender: QObject, text: str) -> None: ...

class QSignalTransition(QAbstractTransition):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, sender: QObject, signal: bytes, sourceState: typing.Union[QState,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., senderObject: QObject = ..., senderObjectChanged: typing.Callable = ..., signalChanged: typing.Callable = ..., targetState: typing.Any = ..., targetStateChanged: typing.Callable = ..., targetStates: typing.Any = ..., targetStatesChanged: typing.Callable = ..., transitionType: QSignalTransition.TransitionType = ..., triggered: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, arg__1: object, arg__2: typing.Union[QState,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., senderObject: QObject = ..., senderObjectChanged: typing.Callable = ..., signal: typing.Union[QByteArray,bytes] = ..., signalChanged: typing.Callable = ..., sourceState: typing.Any = ..., targetState: typing.Any = ..., targetStateChanged: typing.Callable = ..., targetStates: typing.Any = ..., targetStatesChanged: typing.Callable = ..., transitionType: QSignalTransition.TransitionType = ..., triggered: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, sourceState: typing.Union[QState,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., senderObject: QObject = ..., senderObjectChanged: typing.Callable = ..., signal: typing.Union[QByteArray,bytes] = ..., signalChanged: typing.Callable = ..., targetState: typing.Any = ..., targetStateChanged: typing.Callable = ..., targetStates: typing.Any = ..., targetStatesChanged: typing.Callable = ..., transitionType: QSignalTransition.TransitionType = ..., triggered: typing.Callable = ...) -> None: ...
    def event(self, e: QEvent) -> bool: ...
    def eventTest(self, event: QEvent) -> bool: ...
    def onTransition(self, event: QEvent) -> None: ...
    def senderObject(self) -> QObject: ...
    def setSenderObject(self, sender: QObject) -> None: ...
    def setSignal(self, signal: typing.Union[QByteArray,bytes]) -> None: ...
    def signal(self) -> QByteArray: ...

class QSize(shiboken2.Object):
    @overload
    def __init__(self, w: int, h: int) -> None: ...
    @overload
    def __init__(self, QSize: QSize) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def boundedTo(self, arg__1: QSize) -> QSize: ...
    def expandedTo(self, arg__1: QSize) -> QSize: ...
    def grownBy(self, m: QMargins) -> QSize: ...
    def height(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    @overload
    def scale(self, w: int, h: int, mode: Qt.AspectRatioMode) -> None: ...
    @overload
    def scale(self, s: QSize, mode: Qt.AspectRatioMode) -> None: ...
    @overload
    def scaled(self, w: int, h: int, mode: Qt.AspectRatioMode) -> QSize: ...
    @overload
    def scaled(self, s: QSize, mode: Qt.AspectRatioMode) -> QSize: ...
    def setHeight(self, h: int) -> None: ...
    def setWidth(self, w: int) -> None: ...
    def shrunkBy(self, m: QMargins) -> QSize: ...
    def toTuple(self) -> object: ...
    def transpose(self) -> None: ...
    def transposed(self) -> QSize: ...
    def width(self) -> int: ...
    def __add__(self, s2: QSize) -> QSize: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __iadd__(self, arg__1: QSize) -> QSize: ...
    def __imul__(self, c: float) -> QSize: ...
    def __isub__(self, arg__1: QSize) -> QSize: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __mul__(self, c: float) -> QSize: ...
    def __ne__(self, other: object) -> bool: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __rtruediv__(self, other) -> typing.Any: ...
    def __sub__(self, s2: QSize) -> QSize: ...
    def __truediv__(self, other) -> typing.Any: ...

class QSizeF(shiboken2.Object):
    @overload
    def __init__(self, w: float, h: float) -> None: ...
    @overload
    def __init__(self, QSizeF: QSizeF) -> None: ...
    @overload
    def __init__(self, sz: QSize) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def boundedTo(self, arg__1: QSizeF) -> QSizeF: ...
    def expandedTo(self, arg__1: QSizeF) -> QSizeF: ...
    def grownBy(self, m: QMarginsF) -> QSizeF: ...
    def height(self) -> float: ...
    def isEmpty(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    @overload
    def scale(self, w: float, h: float, mode: Qt.AspectRatioMode) -> None: ...
    @overload
    def scale(self, s: QSizeF, mode: Qt.AspectRatioMode) -> None: ...
    @overload
    def scaled(self, w: float, h: float, mode: Qt.AspectRatioMode) -> QSizeF: ...
    @overload
    def scaled(self, s: QSizeF, mode: Qt.AspectRatioMode) -> QSizeF: ...
    def setHeight(self, h: float) -> None: ...
    def setWidth(self, w: float) -> None: ...
    def shrunkBy(self, m: QMarginsF) -> QSizeF: ...
    def toSize(self) -> QSize: ...
    def toTuple(self) -> object: ...
    def transpose(self) -> None: ...
    def transposed(self) -> QSizeF: ...
    def width(self) -> float: ...
    def __add__(self, s2: QSizeF) -> QSizeF: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, arg__1: QSizeF) -> QSizeF: ...
    def __imul__(self, c: float) -> QSizeF: ...
    def __isub__(self, arg__1: QSizeF) -> QSizeF: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __mul__(self, c: float) -> QSizeF: ...
    def __ne__(self, other: object) -> bool: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rmul__(self, other) -> typing.Any: ...
    def __rsub__(self, other) -> typing.Any: ...
    def __rtruediv__(self, other) -> typing.Any: ...
    def __sub__(self, s2: QSizeF) -> QSizeF: ...
    def __truediv__(self, other) -> typing.Any: ...

class QSocketDescriptor(shiboken2.Object):
    @overload
    def __init__(self, QSocketDescriptor: QSocketDescriptor) -> None: ...
    @overload
    def __init__(self, descriptor: int = ...) -> None: ...
    def isValid(self) -> bool: ...
    def __copy__(self) -> None: ...

class QSocketNotifier(QObject):
    class Type:
        Exception: typing.ClassVar[QSocketNotifier.Type] = ...
        Read: typing.ClassVar[QSocketNotifier.Type] = ...
        Write: typing.ClassVar[QSocketNotifier.Type] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSocketNotifier.Type: ...
        def __and__(self, other: typing.SupportsInt) -> QSocketNotifier.Type: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSocketNotifier.Type: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSocketNotifier.Type: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSocketNotifier.Type: ...
        def __rand__(self, other: typing.SupportsInt) -> QSocketNotifier.Type: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSocketNotifier.Type: ...
        def __ror__(self, other: typing.SupportsInt) -> QSocketNotifier.Type: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSocketNotifier.Type: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSocketNotifier.Type: ...
        def __sub__(self, other: typing.SupportsInt) -> QSocketNotifier.Type: ...
        def __xor__(self, other: typing.SupportsInt) -> QSocketNotifier.Type: ...
    Exception: typing.ClassVar[QSocketNotifier.Type] = ...
    Read: typing.ClassVar[QSocketNotifier.Type] = ...
    Write: typing.ClassVar[QSocketNotifier.Type] = ...
    activated: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, arg__1: object, arg__2: QSocketNotifier.Type, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, socket: int, arg__2: QSocketNotifier.Type, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def event(self, arg__1: QEvent) -> bool: ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def socket(self) -> int: ...
    def type(self) -> QSocketNotifier.Type: ...

class QSortFilterProxyModel(QAbstractProxyModel):
    dynamicSortFilterChanged: typing.ClassVar[Signal] = ...
    filterCaseSensitivityChanged: typing.ClassVar[Signal] = ...
    filterRoleChanged: typing.ClassVar[Signal] = ...
    recursiveFilteringEnabledChanged: typing.ClassVar[Signal] = ...
    sortCaseSensitivityChanged: typing.ClassVar[Signal] = ...
    sortLocaleAwareChanged: typing.ClassVar[Signal] = ...
    sortRoleChanged: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., dynamicSortFilter: bool = ..., dynamicSortFilterChanged: typing.Callable = ..., filterCaseSensitivity: Qt.CaseSensitivity = ..., filterCaseSensitivityChanged: typing.Callable = ..., filterKeyColumn: int = ..., filterRegExp: QRegExp = ..., filterRegularExpression: QRegularExpression = ..., filterRole: int = ..., filterRoleChanged: typing.Callable = ..., headerDataChanged: typing.Callable = ..., isSortLocaleAware: bool = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., recursiveFilteringEnabled: bool = ..., recursiveFilteringEnabledChanged: typing.Callable = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ..., sortCaseSensitivity: Qt.CaseSensitivity = ..., sortCaseSensitivityChanged: typing.Callable = ..., sortLocaleAwareChanged: typing.Callable = ..., sortRole: int = ..., sortRoleChanged: typing.Callable = ..., sourceModel: typing.Any = ..., sourceModelChanged: typing.Callable = ...) -> None: ...
    def buddy(self, index: QModelIndex) -> QModelIndex: ...
    def canFetchMore(self, parent: QModelIndex) -> bool: ...
    def columnCount(self, parent: QModelIndex = ...) -> int: ...
    def data(self, index: QModelIndex, role: Qt.ItemDataRole = ...) -> typing.Any: ...
    def dropMimeData(self, data: QMimeData, action: Qt.DropAction, row: int, column: int, parent: QModelIndex) -> bool: ...
    def dynamicSortFilter(self) -> bool: ...
    def fetchMore(self, parent: QModelIndex) -> None: ...
    def filterAcceptsColumn(self, source_column: int, source_parent: QModelIndex) -> bool: ...
    def filterAcceptsRow(self, source_row: int, source_parent: QModelIndex) -> bool: ...
    def filterCaseSensitivity(self) -> Qt.CaseSensitivity: ...
    def filterKeyColumn(self) -> int: ...
    def filterRegExp(self) -> QRegExp: ...
    def filterRegularExpression(self) -> QRegularExpression: ...
    def filterRole(self) -> Qt.ItemDataRole: ...
    def flags(self, index: QModelIndex) -> typing.Union[Qt.ItemFlags,Qt.ItemFlag]: ...
    def hasChildren(self, parent: QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: Qt.Orientation, role: Qt.ItemDataRole = ...) -> typing.Any: ...
    def index(self, row: int, column: int, parent: QModelIndex = ...) -> QModelIndex: ...
    def insertColumns(self, column: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def invalidate(self) -> None: ...
    def invalidateFilter(self) -> None: ...
    def isRecursiveFilteringEnabled(self) -> bool: ...
    def isSortLocaleAware(self) -> bool: ...
    def lessThan(self, source_left: QModelIndex, source_right: QModelIndex) -> bool: ...
    def mapFromSource(self, sourceIndex: QModelIndex) -> QModelIndex: ...
    def mapSelectionFromSource(self, sourceSelection: QItemSelection) -> QItemSelection: ...
    def mapSelectionToSource(self, proxySelection: QItemSelection) -> QItemSelection: ...
    def mapToSource(self, proxyIndex: QModelIndex) -> QModelIndex: ...
    def match(self, start: QModelIndex, role: Qt.ItemDataRole, value: typing.Any, hits: int = ..., flags: typing.Union[Qt.MatchFlags,Qt.MatchFlag] = ...) -> typing.List[int]: ...
    def mimeData(self, indexes: typing.List[int]) -> QMimeData: ...
    def mimeTypes(self) -> typing.List[str]: ...
    @overload
    def parent(self, child: QModelIndex) -> QModelIndex: ...
    @overload
    def parent(self) -> QObject: ...
    def removeColumns(self, column: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def rowCount(self, parent: QModelIndex = ...) -> int: ...
    def setData(self, index: QModelIndex, value: typing.Any, role: Qt.ItemDataRole = ...) -> bool: ...
    def setDynamicSortFilter(self, enable: bool) -> None: ...
    def setFilterCaseSensitivity(self, cs: Qt.CaseSensitivity) -> None: ...
    def setFilterFixedString(self, pattern: str) -> None: ...
    def setFilterKeyColumn(self, column: int) -> None: ...
    @overload
    def setFilterRegExp(self, pattern: str) -> None: ...
    @overload
    def setFilterRegExp(self, regExp: QRegExp) -> None: ...
    @overload
    def setFilterRegularExpression(self, pattern: str) -> None: ...
    @overload
    def setFilterRegularExpression(self, regularExpression: QRegularExpression) -> None: ...
    def setFilterRole(self, role: Qt.ItemDataRole) -> None: ...
    def setFilterWildcard(self, pattern: str) -> None: ...
    def setHeaderData(self, section: int, orientation: Qt.Orientation, value: typing.Any, role: Qt.ItemDataRole = ...) -> bool: ...
    def setRecursiveFilteringEnabled(self, recursive: bool) -> None: ...
    def setSortCaseSensitivity(self, cs: Qt.CaseSensitivity) -> None: ...
    def setSortLocaleAware(self, on: bool) -> None: ...
    def setSortRole(self, role: Qt.ItemDataRole) -> None: ...
    def setSourceModel(self, sourceModel: QAbstractItemModel) -> None: ...
    def sibling(self, row: int, column: int, idx: QModelIndex) -> QModelIndex: ...
    def sort(self, column: int, order: Qt.SortOrder = ...) -> None: ...
    def sortCaseSensitivity(self) -> Qt.CaseSensitivity: ...
    def sortColumn(self) -> int: ...
    def sortOrder(self) -> Qt.SortOrder: ...
    def sortRole(self) -> int: ...
    def span(self, index: QModelIndex) -> QSize: ...
    def supportedDropActions(self) -> typing.Union[Qt.DropActions,Qt.DropAction]: ...

class QStandardPaths(shiboken2.Object):
    class LocateOption:
        LocateDirectory: typing.ClassVar[QStandardPaths.LocateOption] = ...
        LocateFile: typing.ClassVar[QStandardPaths.LocateOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QStandardPaths.LocateOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QStandardPaths.LocateOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStandardPaths.LocateOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QStandardPaths.LocateOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QStandardPaths.LocateOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStandardPaths.LocateOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QStandardPaths.LocateOptions: ...

    class LocateOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QStandardPaths.LocateOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QStandardPaths.LocateOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStandardPaths.LocateOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QStandardPaths.LocateOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QStandardPaths.LocateOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStandardPaths.LocateOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QStandardPaths.LocateOptions: ...

    class StandardLocation:
        AppConfigLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        AppDataLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        AppLocalDataLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        ApplicationsLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        CacheLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        ConfigLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        DataLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        DesktopLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        DocumentsLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        DownloadLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        FontsLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        GenericCacheLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        GenericConfigLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        GenericDataLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        HomeLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        MoviesLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        MusicLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        PicturesLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        RuntimeLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        TempLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStandardPaths.StandardLocation: ...
        def __and__(self, other: typing.SupportsInt) -> QStandardPaths.StandardLocation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStandardPaths.StandardLocation: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStandardPaths.StandardLocation: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStandardPaths.StandardLocation: ...
        def __rand__(self, other: typing.SupportsInt) -> QStandardPaths.StandardLocation: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStandardPaths.StandardLocation: ...
        def __ror__(self, other: typing.SupportsInt) -> QStandardPaths.StandardLocation: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStandardPaths.StandardLocation: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStandardPaths.StandardLocation: ...
        def __sub__(self, other: typing.SupportsInt) -> QStandardPaths.StandardLocation: ...
        def __xor__(self, other: typing.SupportsInt) -> QStandardPaths.StandardLocation: ...
    AppConfigLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    AppDataLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    AppLocalDataLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    ApplicationsLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    CacheLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    ConfigLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    DataLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    DesktopLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    DocumentsLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    DownloadLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    FontsLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    GenericCacheLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    GenericConfigLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    GenericDataLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    HomeLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    LocateDirectory: typing.ClassVar[QStandardPaths.LocateOption] = ...
    LocateFile: typing.ClassVar[QStandardPaths.LocateOption] = ...
    MoviesLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    MusicLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    PicturesLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    RuntimeLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    TempLocation: typing.ClassVar[QStandardPaths.StandardLocation] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    @classmethod
    def displayName(cls, type: QStandardPaths.StandardLocation) -> str: ...
    @classmethod
    def enableTestMode(cls, testMode: bool) -> None: ...
    @classmethod
    def findExecutable(cls, executableName: str, paths: typing.Iterable[str] = ...) -> str: ...
    @classmethod
    def isTestModeEnabled(cls) -> bool: ...
    @classmethod
    def locate(cls, type: QStandardPaths.StandardLocation, fileName: str, options: typing.Union[QStandardPaths.LocateOptions,QStandardPaths.LocateOption] = ...) -> str: ...
    @classmethod
    def locateAll(cls, type: QStandardPaths.StandardLocation, fileName: str, options: typing.Union[QStandardPaths.LocateOptions,QStandardPaths.LocateOption] = ...) -> typing.List[str]: ...
    @classmethod
    def setTestModeEnabled(cls, testMode: bool) -> None: ...
    @classmethod
    def standardLocations(cls, type: QStandardPaths.StandardLocation) -> typing.List[str]: ...
    @classmethod
    def writableLocation(cls, type: QStandardPaths.StandardLocation) -> str: ...

class QState(QAbstractState):
    class ChildMode:
        ExclusiveStates: typing.ClassVar[QState.ChildMode] = ...
        ParallelStates: typing.ClassVar[QState.ChildMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QState.ChildMode: ...
        def __and__(self, other: typing.SupportsInt) -> QState.ChildMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QState.ChildMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QState.ChildMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QState.ChildMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QState.ChildMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QState.ChildMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QState.ChildMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QState.ChildMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QState.ChildMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QState.ChildMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QState.ChildMode: ...

    class RestorePolicy:
        DontRestoreProperties: typing.ClassVar[QState.RestorePolicy] = ...
        RestoreProperties: typing.ClassVar[QState.RestorePolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QState.RestorePolicy: ...
        def __and__(self, other: typing.SupportsInt) -> QState.RestorePolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QState.RestorePolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QState.RestorePolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QState.RestorePolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> QState.RestorePolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> QState.RestorePolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> QState.RestorePolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> QState.RestorePolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> QState.RestorePolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> QState.RestorePolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> QState.RestorePolicy: ...
    DontRestoreProperties: typing.ClassVar[QState.RestorePolicy] = ...
    ExclusiveStates: typing.ClassVar[QState.ChildMode] = ...
    ParallelStates: typing.ClassVar[QState.ChildMode] = ...
    RestoreProperties: typing.ClassVar[QState.RestorePolicy] = ...
    childModeChanged: typing.ClassVar[Signal] = ...
    errorStateChanged: typing.ClassVar[Signal] = ...
    finished: typing.ClassVar[Signal] = ...
    initialStateChanged: typing.ClassVar[Signal] = ...
    propertiesAssigned: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, childMode: QState.ChildMode, parent: typing.Union[QState,None] = ..., active: bool = ..., activeChanged: typing.Callable = ..., childModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., entered: typing.Callable = ..., errorState: QAbstractState = ..., errorStateChanged: typing.Callable = ..., exited: typing.Callable = ..., finished: typing.Callable = ..., initialState: QAbstractState = ..., initialStateChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., propertiesAssigned: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QState,None] = ..., active: bool = ..., activeChanged: typing.Callable = ..., childMode: QState.ChildMode = ..., childModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., entered: typing.Callable = ..., errorState: QAbstractState = ..., errorStateChanged: typing.Callable = ..., exited: typing.Callable = ..., finished: typing.Callable = ..., initialState: QAbstractState = ..., initialStateChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., propertiesAssigned: typing.Callable = ...) -> None: ...
    @overload
    def addTransition(self, sender: QObject, signal: bytes, target: QAbstractState) -> QSignalTransition: ...
    @overload
    def addTransition(self, arg__1: object, arg__2: QAbstractState) -> QSignalTransition: ...
    @overload
    def addTransition(self, target: QAbstractState) -> QAbstractTransition: ...
    @overload
    def addTransition(self, transition: QAbstractTransition) -> None: ...
    def assignProperty(self, object: QObject, name: str, value: typing.Any) -> None: ...
    def childMode(self) -> QState.ChildMode: ...
    def errorState(self) -> QAbstractState: ...
    def event(self, e: QEvent) -> bool: ...
    def initialState(self) -> QAbstractState: ...
    def onEntry(self, event: QEvent) -> None: ...
    def onExit(self, event: QEvent) -> None: ...
    def removeTransition(self, transition: QAbstractTransition) -> None: ...
    def setChildMode(self, mode: QState.ChildMode) -> None: ...
    def setErrorState(self, state: QAbstractState) -> None: ...
    def setInitialState(self, state: QAbstractState) -> None: ...
    def transitions(self) -> typing.List[QAbstractTransition]: ...

class QStateMachine(QState):
    class Error:
        NoCommonAncestorForTransitionError: typing.ClassVar[QStateMachine.Error] = ...
        NoDefaultStateInHistoryStateError: typing.ClassVar[QStateMachine.Error] = ...
        NoError: typing.ClassVar[QStateMachine.Error] = ...
        NoInitialStateError: typing.ClassVar[QStateMachine.Error] = ...
        StateMachineChildModeSetToParallelError: typing.ClassVar[QStateMachine.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStateMachine.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QStateMachine.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStateMachine.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStateMachine.Error: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStateMachine.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QStateMachine.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStateMachine.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QStateMachine.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStateMachine.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStateMachine.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QStateMachine.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QStateMachine.Error: ...

    class EventPriority:
        HighPriority: typing.ClassVar[QStateMachine.EventPriority] = ...
        NormalPriority: typing.ClassVar[QStateMachine.EventPriority] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QStateMachine.EventPriority: ...
        def __and__(self, other: typing.SupportsInt) -> QStateMachine.EventPriority: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QStateMachine.EventPriority: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QStateMachine.EventPriority: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QStateMachine.EventPriority: ...
        def __rand__(self, other: typing.SupportsInt) -> QStateMachine.EventPriority: ...
        def __rmul__(self, other: typing.SupportsInt) -> QStateMachine.EventPriority: ...
        def __ror__(self, other: typing.SupportsInt) -> QStateMachine.EventPriority: ...
        def __rsub__(self, other: typing.SupportsInt) -> QStateMachine.EventPriority: ...
        def __rxor__(self, other: typing.SupportsInt) -> QStateMachine.EventPriority: ...
        def __sub__(self, other: typing.SupportsInt) -> QStateMachine.EventPriority: ...
        def __xor__(self, other: typing.SupportsInt) -> QStateMachine.EventPriority: ...

    class SignalEvent(QEvent):
        @overload
        def __init__(self, sender: QObject, signalIndex: int, arguments: typing.Iterable[typing.Any]) -> None: ...
        @overload
        def __init__(self, SignalEvent: QStateMachine.SignalEvent) -> None: ...
        def arguments(self) -> typing.List[typing.Any]: ...
        def sender(self) -> QObject: ...
        def signalIndex(self) -> int: ...
        def __copy__(self) -> None: ...

    class WrappedEvent(QEvent):
        @overload
        def __init__(self, object: QObject, event: QEvent) -> None: ...
        @overload
        def __init__(self, WrappedEvent: QStateMachine.WrappedEvent) -> None: ...
        def event(self) -> QEvent: ...
        def object(self) -> QObject: ...
        def __copy__(self) -> None: ...
    HighPriority: typing.ClassVar[QStateMachine.EventPriority] = ...
    NoCommonAncestorForTransitionError: typing.ClassVar[QStateMachine.Error] = ...
    NoDefaultStateInHistoryStateError: typing.ClassVar[QStateMachine.Error] = ...
    NoError: typing.ClassVar[QStateMachine.Error] = ...
    NoInitialStateError: typing.ClassVar[QStateMachine.Error] = ...
    NormalPriority: typing.ClassVar[QStateMachine.EventPriority] = ...
    StateMachineChildModeSetToParallelError: typing.ClassVar[QStateMachine.Error] = ...
    runningChanged: typing.ClassVar[Signal] = ...
    started: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    stopped: typing.ClassVar[Signal] = ...
    @overload
    def __init__(self, childMode: QState.ChildMode, parent: typing.Union[QObject,None] = ..., active: bool = ..., activeChanged: typing.Callable = ..., animated: bool = ..., childModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., entered: typing.Callable = ..., errorState: typing.Any = ..., errorStateChanged: typing.Callable = ..., errorString: str = ..., exited: typing.Callable = ..., finished: typing.Callable = ..., globalRestorePolicy: typing.Any = ..., initialState: typing.Any = ..., initialStateChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., propertiesAssigned: typing.Callable = ..., running: bool = ..., runningChanged: typing.Callable = ..., started: typing.Callable = ..., stopped: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QObject,None] = ..., active: bool = ..., activeChanged: typing.Callable = ..., animated: bool = ..., childMode: QStateMachine.ChildMode = ..., childModeChanged: typing.Callable = ..., destroyed: typing.Callable = ..., entered: typing.Callable = ..., errorState: typing.Any = ..., errorStateChanged: typing.Callable = ..., errorString: str = ..., exited: typing.Callable = ..., finished: typing.Callable = ..., globalRestorePolicy: typing.Any = ..., initialState: typing.Any = ..., initialStateChanged: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., propertiesAssigned: typing.Callable = ..., running: bool = ..., runningChanged: typing.Callable = ..., started: typing.Callable = ..., stopped: typing.Callable = ...) -> None: ...
    def addDefaultAnimation(self, animation: QAbstractAnimation) -> None: ...
    def addState(self, state: QAbstractState) -> None: ...
    def beginMicrostep(self, event: QEvent) -> None: ...
    def beginSelectTransitions(self, event: QEvent) -> None: ...
    def cancelDelayedEvent(self, id: int) -> bool: ...
    def clearError(self) -> None: ...
    @overload
    def configuration(self) -> typing.Set[QAbstractState]: ...
    @overload
    def configuration(self) -> typing.List[QAbstractState]: ...
    def defaultAnimations(self) -> typing.List[QAbstractAnimation]: ...
    def endMicrostep(self, event: QEvent) -> None: ...
    def endSelectTransitions(self, event: QEvent) -> None: ...
    def error(self) -> QStateMachine.Error: ...
    def errorString(self) -> str: ...
    def event(self, e: QEvent) -> bool: ...
    def eventFilter(self, watched: QObject, event: QEvent) -> bool: ...
    def globalRestorePolicy(self) -> QState.RestorePolicy: ...
    def isAnimated(self) -> bool: ...
    def isRunning(self) -> bool: ...
    def onEntry(self, event: QEvent) -> None: ...
    def onExit(self, event: QEvent) -> None: ...
    def postDelayedEvent(self, event: QEvent, delay: int) -> int: ...
    def postEvent(self, event: QEvent, priority: QStateMachine.EventPriority = ...) -> None: ...
    def removeDefaultAnimation(self, animation: QAbstractAnimation) -> None: ...
    def removeState(self, state: QAbstractState) -> None: ...
    def setAnimated(self, enabled: bool) -> None: ...
    def setGlobalRestorePolicy(self, restorePolicy: QState.RestorePolicy) -> None: ...
    def setRunning(self, running: bool) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...

class QStorageInfo(shiboken2.Object):
    @overload
    def __init__(self, dir: QDir) -> None: ...
    @overload
    def __init__(self, other: QStorageInfo) -> None: ...
    @overload
    def __init__(self, path: str) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def blockSize(self) -> int: ...
    def bytesAvailable(self) -> int: ...
    def bytesFree(self) -> int: ...
    def bytesTotal(self) -> int: ...
    def device(self) -> QByteArray: ...
    def displayName(self) -> str: ...
    def fileSystemType(self) -> QByteArray: ...
    def isReadOnly(self) -> bool: ...
    def isReady(self) -> bool: ...
    def isRoot(self) -> bool: ...
    def isValid(self) -> bool: ...
    @classmethod
    def mountedVolumes(cls) -> typing.List[QStorageInfo]: ...
    def name(self) -> str: ...
    def refresh(self) -> None: ...
    @classmethod
    def root(cls) -> QStorageInfo: ...
    def rootPath(self) -> str: ...
    def setPath(self, path: str) -> None: ...
    def subvolume(self) -> QByteArray: ...
    def swap(self, other: QStorageInfo) -> None: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QStringListModel(QAbstractListModel):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, strings: typing.Iterable[str], parent: typing.Union[QObject,None] = ..., columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QObject,None] = ..., columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ...) -> None: ...
    def data(self, index: QModelIndex, role: Qt.ItemDataRole = ...) -> typing.Any: ...
    def flags(self, index: QModelIndex) -> typing.Union[Qt.ItemFlags,Qt.ItemFlag]: ...
    def insertRows(self, row: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def itemData(self, index: QModelIndex) -> typing.Dict[int,typing.Any]: ...
    def moveRows(self, sourceParent: QModelIndex, sourceRow: int, count: int, destinationParent: QModelIndex, destinationChild: int) -> bool: ...
    def removeRows(self, row: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def rowCount(self, parent: QModelIndex = ...) -> int: ...
    def setData(self, index: QModelIndex, value: typing.Any, role: Qt.ItemDataRole = ...) -> bool: ...
    def setItemData(self, index: QModelIndex, roles: typing.Dict[int,typing.Any]) -> bool: ...
    def setStringList(self, strings: typing.Iterable[str]) -> None: ...
    def sibling(self, row: int, column: int, idx: QModelIndex) -> QModelIndex: ...
    def sort(self, column: int, order: Qt.SortOrder = ...) -> None: ...
    def stringList(self) -> typing.List[str]: ...
    def supportedDropActions(self) -> typing.Union[Qt.DropActions,Qt.DropAction]: ...

class QSysInfo(shiboken2.Object):
    class Endian:
        BigEndian: typing.ClassVar[QSysInfo.Endian] = ...
        ByteOrder: typing.ClassVar[QSysInfo.Endian] = ...
        LittleEndian: typing.ClassVar[QSysInfo.Endian] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSysInfo.Endian: ...
        def __and__(self, other: typing.SupportsInt) -> QSysInfo.Endian: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSysInfo.Endian: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSysInfo.Endian: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSysInfo.Endian: ...
        def __rand__(self, other: typing.SupportsInt) -> QSysInfo.Endian: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSysInfo.Endian: ...
        def __ror__(self, other: typing.SupportsInt) -> QSysInfo.Endian: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSysInfo.Endian: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSysInfo.Endian: ...
        def __sub__(self, other: typing.SupportsInt) -> QSysInfo.Endian: ...
        def __xor__(self, other: typing.SupportsInt) -> QSysInfo.Endian: ...

    class MacVersion:
        MV_10_0: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_10_1: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_10_10: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_10_11: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_10_12: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_10_2: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_10_3: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_10_4: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_10_5: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_10_6: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_10_7: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_10_8: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_10_9: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_9: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_CHEETAH: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_ELCAPITAN: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_10_0: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_4_3: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_5_0: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_5_1: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_6_0: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_6_1: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_7_0: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_7_1: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_8_0: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_8_1: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_8_2: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_8_3: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_8_4: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_9_0: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_9_1: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_9_2: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_IOS_9_3: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_JAGUAR: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_LEOPARD: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_LION: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_MAVERICKS: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_MOUNTAINLION: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_None: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_PANTHER: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_PUMA: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_SIERRA: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_SNOWLEOPARD: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_TIGER: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_TVOS: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_TVOS_10_0: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_TVOS_9_0: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_TVOS_9_1: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_TVOS_9_2: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_Unknown: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_WATCHOS: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_WATCHOS_2_0: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_WATCHOS_2_1: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_WATCHOS_2_2: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_WATCHOS_3_0: typing.ClassVar[QSysInfo.MacVersion] = ...
        MV_YOSEMITE: typing.ClassVar[QSysInfo.MacVersion] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSysInfo.MacVersion: ...
        def __and__(self, other: typing.SupportsInt) -> QSysInfo.MacVersion: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSysInfo.MacVersion: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSysInfo.MacVersion: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSysInfo.MacVersion: ...
        def __rand__(self, other: typing.SupportsInt) -> QSysInfo.MacVersion: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSysInfo.MacVersion: ...
        def __ror__(self, other: typing.SupportsInt) -> QSysInfo.MacVersion: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSysInfo.MacVersion: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSysInfo.MacVersion: ...
        def __sub__(self, other: typing.SupportsInt) -> QSysInfo.MacVersion: ...
        def __xor__(self, other: typing.SupportsInt) -> QSysInfo.MacVersion: ...

    class Sizes:
        WordSize: typing.ClassVar[QSysInfo.Sizes] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSysInfo.Sizes: ...
        def __and__(self, other: typing.SupportsInt) -> QSysInfo.Sizes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSysInfo.Sizes: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSysInfo.Sizes: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSysInfo.Sizes: ...
        def __rand__(self, other: typing.SupportsInt) -> QSysInfo.Sizes: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSysInfo.Sizes: ...
        def __ror__(self, other: typing.SupportsInt) -> QSysInfo.Sizes: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSysInfo.Sizes: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSysInfo.Sizes: ...
        def __sub__(self, other: typing.SupportsInt) -> QSysInfo.Sizes: ...
        def __xor__(self, other: typing.SupportsInt) -> QSysInfo.Sizes: ...
    BigEndian: typing.ClassVar[QSysInfo.Endian] = ...
    ByteOrder: typing.ClassVar[QSysInfo.Endian] = ...
    LittleEndian: typing.ClassVar[QSysInfo.Endian] = ...
    MV_10_0: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_10_1: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_10_10: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_10_11: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_10_12: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_10_2: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_10_3: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_10_4: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_10_5: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_10_6: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_10_7: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_10_8: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_10_9: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_9: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_CHEETAH: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_ELCAPITAN: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_10_0: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_4_3: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_5_0: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_5_1: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_6_0: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_6_1: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_7_0: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_7_1: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_8_0: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_8_1: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_8_2: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_8_3: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_8_4: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_9_0: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_9_1: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_9_2: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_IOS_9_3: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_JAGUAR: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_LEOPARD: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_LION: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_MAVERICKS: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_MOUNTAINLION: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_None: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_PANTHER: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_PUMA: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_SIERRA: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_SNOWLEOPARD: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_TIGER: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_TVOS: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_TVOS_10_0: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_TVOS_9_0: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_TVOS_9_1: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_TVOS_9_2: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_Unknown: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_WATCHOS: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_WATCHOS_2_0: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_WATCHOS_2_1: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_WATCHOS_2_2: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_WATCHOS_3_0: typing.ClassVar[QSysInfo.MacVersion] = ...
    MV_YOSEMITE: typing.ClassVar[QSysInfo.MacVersion] = ...
    MacintoshVersion: typing.ClassVar[QSysInfo.MacVersion] = ...
    WordSize: typing.ClassVar[QSysInfo.Sizes] = ...
    def __init__(self) -> None: ...
    @classmethod
    def bootUniqueId(cls) -> QByteArray: ...
    @classmethod
    def buildAbi(cls) -> str: ...
    @classmethod
    def buildCpuArchitecture(cls) -> str: ...
    @classmethod
    def currentCpuArchitecture(cls) -> str: ...
    @classmethod
    def kernelType(cls) -> str: ...
    @classmethod
    def kernelVersion(cls) -> str: ...
    @classmethod
    def macVersion(cls) -> QSysInfo.MacVersion: ...
    @classmethod
    def machineHostName(cls) -> str: ...
    @classmethod
    def machineUniqueId(cls) -> QByteArray: ...
    @classmethod
    def prettyProductName(cls) -> str: ...
    @classmethod
    def productType(cls) -> str: ...
    @classmethod
    def productVersion(cls) -> str: ...

class QSystemSemaphore(shiboken2.Object):
    class AccessMode:
        Create: typing.ClassVar[QSystemSemaphore.AccessMode] = ...
        Open: typing.ClassVar[QSystemSemaphore.AccessMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSystemSemaphore.AccessMode: ...
        def __and__(self, other: typing.SupportsInt) -> QSystemSemaphore.AccessMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSystemSemaphore.AccessMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSystemSemaphore.AccessMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSystemSemaphore.AccessMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QSystemSemaphore.AccessMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSystemSemaphore.AccessMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QSystemSemaphore.AccessMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSystemSemaphore.AccessMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSystemSemaphore.AccessMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QSystemSemaphore.AccessMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QSystemSemaphore.AccessMode: ...

    class SystemSemaphoreError:
        AlreadyExists: typing.ClassVar[QSystemSemaphore.SystemSemaphoreError] = ...
        KeyError: typing.ClassVar[QSystemSemaphore.SystemSemaphoreError] = ...
        NoError: typing.ClassVar[QSystemSemaphore.SystemSemaphoreError] = ...
        NotFound: typing.ClassVar[QSystemSemaphore.SystemSemaphoreError] = ...
        OutOfResources: typing.ClassVar[QSystemSemaphore.SystemSemaphoreError] = ...
        PermissionDenied: typing.ClassVar[QSystemSemaphore.SystemSemaphoreError] = ...
        UnknownError: typing.ClassVar[QSystemSemaphore.SystemSemaphoreError] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QSystemSemaphore.SystemSemaphoreError: ...
        def __and__(self, other: typing.SupportsInt) -> QSystemSemaphore.SystemSemaphoreError: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QSystemSemaphore.SystemSemaphoreError: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QSystemSemaphore.SystemSemaphoreError: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QSystemSemaphore.SystemSemaphoreError: ...
        def __rand__(self, other: typing.SupportsInt) -> QSystemSemaphore.SystemSemaphoreError: ...
        def __rmul__(self, other: typing.SupportsInt) -> QSystemSemaphore.SystemSemaphoreError: ...
        def __ror__(self, other: typing.SupportsInt) -> QSystemSemaphore.SystemSemaphoreError: ...
        def __rsub__(self, other: typing.SupportsInt) -> QSystemSemaphore.SystemSemaphoreError: ...
        def __rxor__(self, other: typing.SupportsInt) -> QSystemSemaphore.SystemSemaphoreError: ...
        def __sub__(self, other: typing.SupportsInt) -> QSystemSemaphore.SystemSemaphoreError: ...
        def __xor__(self, other: typing.SupportsInt) -> QSystemSemaphore.SystemSemaphoreError: ...
    AlreadyExists: typing.ClassVar[QSystemSemaphore.SystemSemaphoreError] = ...
    Create: typing.ClassVar[QSystemSemaphore.AccessMode] = ...
    KeyError: typing.ClassVar[QSystemSemaphore.SystemSemaphoreError] = ...
    NoError: typing.ClassVar[QSystemSemaphore.SystemSemaphoreError] = ...
    NotFound: typing.ClassVar[QSystemSemaphore.SystemSemaphoreError] = ...
    Open: typing.ClassVar[QSystemSemaphore.AccessMode] = ...
    OutOfResources: typing.ClassVar[QSystemSemaphore.SystemSemaphoreError] = ...
    PermissionDenied: typing.ClassVar[QSystemSemaphore.SystemSemaphoreError] = ...
    UnknownError: typing.ClassVar[QSystemSemaphore.SystemSemaphoreError] = ...
    def __init__(self, key: str, initialValue: int = ..., mode: QSystemSemaphore.AccessMode = ...) -> None: ...
    def acquire(self) -> bool: ...
    def error(self) -> QSystemSemaphore.SystemSemaphoreError: ...
    def errorString(self) -> str: ...
    def key(self) -> str: ...
    def release(self, n: int = ...) -> bool: ...
    def setKey(self, key: str, initialValue: int = ..., mode: QSystemSemaphore.AccessMode = ...) -> None: ...

class QTemporaryDir(shiboken2.Object):
    @overload
    def __init__(self, templateName: str) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def autoRemove(self) -> bool: ...
    def errorString(self) -> str: ...
    def filePath(self, fileName: str) -> str: ...
    def isValid(self) -> bool: ...
    def path(self) -> str: ...
    def remove(self) -> bool: ...
    def setAutoRemove(self, b: bool) -> None: ...

class QTemporaryFile(QFile):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    @overload
    def __init__(self, templateName: str, parent: typing.Union[QObject,None], aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, parent: typing.Union[QObject,None], aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, templateName: str, aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    @overload
    def __init__(self, aboutToClose: typing.Callable = ..., bytesWritten: typing.Callable = ..., channelBytesWritten: typing.Callable = ..., channelReadyRead: typing.Callable = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., readChannelFinished: typing.Callable = ..., readyRead: typing.Callable = ...) -> None: ...
    def autoRemove(self) -> bool: ...
    @overload
    @classmethod
    def createLocalFile(cls, file: QFile) -> QTemporaryFile: ...
    @overload
    @classmethod
    def createLocalFile(cls, fileName: str) -> QTemporaryFile: ...
    @overload
    @classmethod
    def createNativeFile(cls, file: QFile) -> QTemporaryFile: ...
    @overload
    @classmethod
    def createNativeFile(cls, fileName: str) -> QTemporaryFile: ...
    def fileName(self) -> str: ...
    def fileTemplate(self) -> str: ...
    @overload
    def open(self, flags: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag]) -> bool: ...
    @overload
    def open(self) -> bool: ...
    def rename(self, newName: str) -> bool: ...
    def setAutoRemove(self, b: bool) -> None: ...
    def setFileTemplate(self, name: str) -> None: ...

class QTextBoundaryFinder(shiboken2.Object):
    class BoundaryReason:
        BreakOpportunity: typing.ClassVar[QTextBoundaryFinder.BoundaryReason] = ...
        EndOfItem: typing.ClassVar[QTextBoundaryFinder.BoundaryReason] = ...
        MandatoryBreak: typing.ClassVar[QTextBoundaryFinder.BoundaryReason] = ...
        NotAtBoundary: typing.ClassVar[QTextBoundaryFinder.BoundaryReason] = ...
        SoftHyphen: typing.ClassVar[QTextBoundaryFinder.BoundaryReason] = ...
        StartOfItem: typing.ClassVar[QTextBoundaryFinder.BoundaryReason] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryReasons: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextBoundaryFinder.BoundaryReasons: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryReasons: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryReasons: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryReasons: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryReasons: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryReasons: ...

    class BoundaryReasons:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryReasons: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextBoundaryFinder.BoundaryReasons: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryReasons: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryReasons: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryReasons: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryReasons: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryReasons: ...

    class BoundaryType:
        Grapheme: typing.ClassVar[QTextBoundaryFinder.BoundaryType] = ...
        Line: typing.ClassVar[QTextBoundaryFinder.BoundaryType] = ...
        Sentence: typing.ClassVar[QTextBoundaryFinder.BoundaryType] = ...
        Word: typing.ClassVar[QTextBoundaryFinder.BoundaryType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryType: ...
        def __and__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryType: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryType: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryType: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryType: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextBoundaryFinder.BoundaryType: ...
    BreakOpportunity: typing.ClassVar[QTextBoundaryFinder.BoundaryReason] = ...
    EndOfItem: typing.ClassVar[QTextBoundaryFinder.BoundaryReason] = ...
    Grapheme: typing.ClassVar[QTextBoundaryFinder.BoundaryType] = ...
    Line: typing.ClassVar[QTextBoundaryFinder.BoundaryType] = ...
    MandatoryBreak: typing.ClassVar[QTextBoundaryFinder.BoundaryReason] = ...
    NotAtBoundary: typing.ClassVar[QTextBoundaryFinder.BoundaryReason] = ...
    Sentence: typing.ClassVar[QTextBoundaryFinder.BoundaryType] = ...
    SoftHyphen: typing.ClassVar[QTextBoundaryFinder.BoundaryReason] = ...
    StartOfItem: typing.ClassVar[QTextBoundaryFinder.BoundaryReason] = ...
    Word: typing.ClassVar[QTextBoundaryFinder.BoundaryType] = ...
    @overload
    def __init__(self, type: QTextBoundaryFinder.BoundaryType, string: str) -> None: ...
    @overload
    def __init__(self, other: QTextBoundaryFinder) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def boundaryReasons(self) -> typing.Union[QTextBoundaryFinder.BoundaryReasons,QTextBoundaryFinder.BoundaryReason]: ...
    def isAtBoundary(self) -> bool: ...
    def isValid(self) -> bool: ...
    def position(self) -> int: ...
    def setPosition(self, position: int) -> None: ...
    def string(self) -> str: ...
    def toEnd(self) -> None: ...
    def toNextBoundary(self) -> int: ...
    def toPreviousBoundary(self) -> int: ...
    def toStart(self) -> None: ...
    def type(self) -> QTextBoundaryFinder.BoundaryType: ...
    def __copy__(self) -> None: ...

class QTextCodec(shiboken2.Object):
    class ConversionFlag:
        ConvertInvalidToNull: typing.ClassVar[QTextCodec.ConversionFlag] = ...
        DefaultConversion: typing.ClassVar[QTextCodec.ConversionFlag] = ...
        FreeFunction: typing.ClassVar[QTextCodec.ConversionFlag] = ...
        IgnoreHeader: typing.ClassVar[QTextCodec.ConversionFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextCodec.ConversionFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextCodec.ConversionFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextCodec.ConversionFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextCodec.ConversionFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextCodec.ConversionFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextCodec.ConversionFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextCodec.ConversionFlags: ...

    class ConversionFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextCodec.ConversionFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextCodec.ConversionFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextCodec.ConversionFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextCodec.ConversionFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextCodec.ConversionFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextCodec.ConversionFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextCodec.ConversionFlags: ...

    class ConverterState(shiboken2.Object):
        flags: typing.Any
        invalidChars: typing.Any
        remainingChars: typing.Any
        def __init__(self, f: typing.Union[QTextCodec.ConversionFlags,QTextCodec.ConversionFlag] = ...) -> None: ...
    ConvertInvalidToNull: typing.ClassVar[QTextCodec.ConversionFlag] = ...
    DefaultConversion: typing.ClassVar[QTextCodec.ConversionFlag] = ...
    FreeFunction: typing.ClassVar[QTextCodec.ConversionFlag] = ...
    IgnoreHeader: typing.ClassVar[QTextCodec.ConversionFlag] = ...
    def __init__(self) -> None: ...
    def aliases(self) -> typing.List[QByteArray]: ...
    @classmethod
    def availableCodecs(cls) -> typing.List[QByteArray]: ...
    @classmethod
    def availableMibs(cls) -> typing.List[int]: ...
    def canEncode(self, arg__1: str) -> bool: ...
    @overload
    @classmethod
    def codecForHtml(cls, ba: typing.Union[QByteArray,bytes], defaultCodec: QTextCodec) -> QTextCodec: ...
    @overload
    @classmethod
    def codecForHtml(cls, ba: typing.Union[QByteArray,bytes]) -> QTextCodec: ...
    @classmethod
    def codecForLocale(cls) -> QTextCodec: ...
    @classmethod
    def codecForMib(cls, mib: int) -> QTextCodec: ...
    @overload
    @classmethod
    def codecForName(cls, name: typing.Union[QByteArray,bytes]) -> QTextCodec: ...
    @overload
    @classmethod
    def codecForName(cls, name: bytes) -> QTextCodec: ...
    @overload
    @classmethod
    def codecForUtfText(cls, ba: typing.Union[QByteArray,bytes], defaultCodec: QTextCodec) -> QTextCodec: ...
    @overload
    @classmethod
    def codecForUtfText(cls, ba: typing.Union[QByteArray,bytes]) -> QTextCodec: ...
    def convertToUnicode(self, in_: bytes, length: int, state: QTextCodec.ConverterState) -> str: ...
    def fromUnicode(self, uc: str) -> QByteArray: ...
    def makeDecoder(self, flags: typing.Union[QTextCodec.ConversionFlags,QTextCodec.ConversionFlag] = ...) -> QTextDecoder: ...
    def makeEncoder(self, flags: typing.Union[QTextCodec.ConversionFlags,QTextCodec.ConversionFlag] = ...) -> QTextEncoder: ...
    def mibEnum(self) -> int: ...
    def name(self) -> QByteArray: ...
    @classmethod
    def setCodecForLocale(cls, c: QTextCodec) -> None: ...
    @overload
    def toUnicode(self, in_: bytes, length: int, state: typing.Union[QTextCodec.ConverterState,None] = ...) -> str: ...
    @overload
    def toUnicode(self, arg__1: typing.Union[QByteArray,bytes]) -> str: ...
    @overload
    def toUnicode(self, chars: bytes) -> str: ...

class QTextDecoder(shiboken2.Object):
    @overload
    def __init__(self, codec: QTextCodec, flags: typing.Union[QTextCodec.ConversionFlags,QTextCodec.ConversionFlag]) -> None: ...
    @overload
    def __init__(self, codec: QTextCodec) -> None: ...
    def hasFailure(self) -> bool: ...
    def needsMoreData(self) -> bool: ...
    def toUnicode(self, ba: typing.Union[QByteArray,bytes]) -> str: ...

class QTextEncoder(shiboken2.Object):
    @overload
    def __init__(self, codec: QTextCodec, flags: typing.Union[QTextCodec.ConversionFlags,QTextCodec.ConversionFlag]) -> None: ...
    @overload
    def __init__(self, codec: QTextCodec) -> None: ...
    def fromUnicode(self, str: str) -> QByteArray: ...
    def hasFailure(self) -> bool: ...

class QTextStream(shiboken2.Object):
    class FieldAlignment:
        AlignAccountingStyle: typing.ClassVar[QTextStream.FieldAlignment] = ...
        AlignCenter: typing.ClassVar[QTextStream.FieldAlignment] = ...
        AlignLeft: typing.ClassVar[QTextStream.FieldAlignment] = ...
        AlignRight: typing.ClassVar[QTextStream.FieldAlignment] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextStream.FieldAlignment: ...
        def __and__(self, other: typing.SupportsInt) -> QTextStream.FieldAlignment: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextStream.FieldAlignment: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextStream.FieldAlignment: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextStream.FieldAlignment: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextStream.FieldAlignment: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextStream.FieldAlignment: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextStream.FieldAlignment: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextStream.FieldAlignment: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextStream.FieldAlignment: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextStream.FieldAlignment: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextStream.FieldAlignment: ...

    class NumberFlag:
        ForcePoint: typing.ClassVar[QTextStream.NumberFlag] = ...
        ForceSign: typing.ClassVar[QTextStream.NumberFlag] = ...
        ShowBase: typing.ClassVar[QTextStream.NumberFlag] = ...
        UppercaseBase: typing.ClassVar[QTextStream.NumberFlag] = ...
        UppercaseDigits: typing.ClassVar[QTextStream.NumberFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextStream.NumberFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextStream.NumberFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextStream.NumberFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextStream.NumberFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextStream.NumberFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextStream.NumberFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextStream.NumberFlags: ...

    class NumberFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QTextStream.NumberFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QTextStream.NumberFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextStream.NumberFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextStream.NumberFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextStream.NumberFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextStream.NumberFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextStream.NumberFlags: ...

    class RealNumberNotation:
        FixedNotation: typing.ClassVar[QTextStream.RealNumberNotation] = ...
        ScientificNotation: typing.ClassVar[QTextStream.RealNumberNotation] = ...
        SmartNotation: typing.ClassVar[QTextStream.RealNumberNotation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextStream.RealNumberNotation: ...
        def __and__(self, other: typing.SupportsInt) -> QTextStream.RealNumberNotation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextStream.RealNumberNotation: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextStream.RealNumberNotation: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextStream.RealNumberNotation: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextStream.RealNumberNotation: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextStream.RealNumberNotation: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextStream.RealNumberNotation: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextStream.RealNumberNotation: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextStream.RealNumberNotation: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextStream.RealNumberNotation: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextStream.RealNumberNotation: ...

    class Status:
        Ok: typing.ClassVar[QTextStream.Status] = ...
        ReadCorruptData: typing.ClassVar[QTextStream.Status] = ...
        ReadPastEnd: typing.ClassVar[QTextStream.Status] = ...
        WriteFailed: typing.ClassVar[QTextStream.Status] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTextStream.Status: ...
        def __and__(self, other: typing.SupportsInt) -> QTextStream.Status: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTextStream.Status: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTextStream.Status: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTextStream.Status: ...
        def __rand__(self, other: typing.SupportsInt) -> QTextStream.Status: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTextStream.Status: ...
        def __ror__(self, other: typing.SupportsInt) -> QTextStream.Status: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTextStream.Status: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTextStream.Status: ...
        def __sub__(self, other: typing.SupportsInt) -> QTextStream.Status: ...
        def __xor__(self, other: typing.SupportsInt) -> QTextStream.Status: ...
    AlignAccountingStyle: typing.ClassVar[QTextStream.FieldAlignment] = ...
    AlignCenter: typing.ClassVar[QTextStream.FieldAlignment] = ...
    AlignLeft: typing.ClassVar[QTextStream.FieldAlignment] = ...
    AlignRight: typing.ClassVar[QTextStream.FieldAlignment] = ...
    FixedNotation: typing.ClassVar[QTextStream.RealNumberNotation] = ...
    ForcePoint: typing.ClassVar[QTextStream.NumberFlag] = ...
    ForceSign: typing.ClassVar[QTextStream.NumberFlag] = ...
    Ok: typing.ClassVar[QTextStream.Status] = ...
    ReadCorruptData: typing.ClassVar[QTextStream.Status] = ...
    ReadPastEnd: typing.ClassVar[QTextStream.Status] = ...
    ScientificNotation: typing.ClassVar[QTextStream.RealNumberNotation] = ...
    ShowBase: typing.ClassVar[QTextStream.NumberFlag] = ...
    SmartNotation: typing.ClassVar[QTextStream.RealNumberNotation] = ...
    UppercaseBase: typing.ClassVar[QTextStream.NumberFlag] = ...
    UppercaseDigits: typing.ClassVar[QTextStream.NumberFlag] = ...
    WriteFailed: typing.ClassVar[QTextStream.Status] = ...
    @overload
    def __init__(self, array: typing.Union[QByteArray,bytes], openMode: typing.Union[QIODevice.OpenMode,QIODevice.OpenModeFlag] = ...) -> None: ...
    @overload
    def __init__(self, device: QIODevice) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def atEnd(self) -> bool: ...
    def autoDetectUnicode(self) -> bool: ...
    def codec(self) -> QTextCodec: ...
    def device(self) -> QIODevice: ...
    def fieldAlignment(self) -> QTextStream.FieldAlignment: ...
    def fieldWidth(self) -> int: ...
    def flush(self) -> None: ...
    def generateByteOrderMark(self) -> bool: ...
    def integerBase(self) -> int: ...
    def locale(self) -> QLocale: ...
    def numberFlags(self) -> typing.Union[QTextStream.NumberFlags,QTextStream.NumberFlag]: ...
    def padChar(self) -> str: ...
    def pos(self) -> int: ...
    def read(self, maxlen: int) -> str: ...
    def readAll(self) -> str: ...
    def readLine(self, maxlen: int = ...) -> str: ...
    def realNumberNotation(self) -> QTextStream.RealNumberNotation: ...
    def realNumberPrecision(self) -> int: ...
    def reset(self) -> None: ...
    def resetStatus(self) -> None: ...
    def seek(self, pos: int) -> bool: ...
    def setAutoDetectUnicode(self, enabled: bool) -> None: ...
    @overload
    def setCodec(self, codec: QTextCodec) -> None: ...
    @overload
    def setCodec(self, codecName: bytes) -> None: ...
    def setDevice(self, device: QIODevice) -> None: ...
    def setFieldAlignment(self, alignment: QTextStream.FieldAlignment) -> None: ...
    def setFieldWidth(self, width: int) -> None: ...
    def setGenerateByteOrderMark(self, generate: bool) -> None: ...
    def setIntegerBase(self, base: int) -> None: ...
    def setLocale(self, locale: QLocale) -> None: ...
    def setNumberFlags(self, flags: typing.Union[QTextStream.NumberFlags,QTextStream.NumberFlag]) -> None: ...
    def setPadChar(self, ch: str) -> None: ...
    def setRealNumberNotation(self, notation: QTextStream.RealNumberNotation) -> None: ...
    def setRealNumberPrecision(self, precision: int) -> None: ...
    def setStatus(self, status: QTextStream.Status) -> None: ...
    def skipWhiteSpace(self) -> None: ...
    def status(self) -> QTextStream.Status: ...
    def string(self) -> typing.List[str]: ...
    @overload
    def __lshift__(self, array: typing.Union[QByteArray,bytes]) -> QTextStream: ...
    @overload
    def __lshift__(self, ch: str) -> QTextStream: ...
    @overload
    def __lshift__(self, ch: int) -> QTextStream: ...
    @overload
    def __lshift__(self, f: float) -> QTextStream: ...
    @overload
    def __lshift__(self, i: int) -> QTextStream: ...
    @overload
    def __lshift__(self, m: QTextStreamManipulator) -> QTextStream: ...
    @overload
    def __lshift__(self, s: str) -> QTextStream: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __rrshift__(self, other) -> typing.Any: ...
    def __rshift__(self, array: typing.Union[QByteArray,bytes]) -> QTextStream: ...

class QTextStreamManipulator(shiboken2.Object):
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def exec_(self, s: QTextStream) -> None: ...
    def __copy__(self) -> None: ...

class QThread(QObject):
    class Priority:
        HighPriority: typing.ClassVar[QThread.Priority] = ...
        HighestPriority: typing.ClassVar[QThread.Priority] = ...
        IdlePriority: typing.ClassVar[QThread.Priority] = ...
        InheritPriority: typing.ClassVar[QThread.Priority] = ...
        LowPriority: typing.ClassVar[QThread.Priority] = ...
        LowestPriority: typing.ClassVar[QThread.Priority] = ...
        NormalPriority: typing.ClassVar[QThread.Priority] = ...
        TimeCriticalPriority: typing.ClassVar[QThread.Priority] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QThread.Priority: ...
        def __and__(self, other: typing.SupportsInt) -> QThread.Priority: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QThread.Priority: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QThread.Priority: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QThread.Priority: ...
        def __rand__(self, other: typing.SupportsInt) -> QThread.Priority: ...
        def __rmul__(self, other: typing.SupportsInt) -> QThread.Priority: ...
        def __ror__(self, other: typing.SupportsInt) -> QThread.Priority: ...
        def __rsub__(self, other: typing.SupportsInt) -> QThread.Priority: ...
        def __rxor__(self, other: typing.SupportsInt) -> QThread.Priority: ...
        def __sub__(self, other: typing.SupportsInt) -> QThread.Priority: ...
        def __xor__(self, other: typing.SupportsInt) -> QThread.Priority: ...
    HighPriority: typing.ClassVar[QThread.Priority] = ...
    HighestPriority: typing.ClassVar[QThread.Priority] = ...
    IdlePriority: typing.ClassVar[QThread.Priority] = ...
    InheritPriority: typing.ClassVar[QThread.Priority] = ...
    LowPriority: typing.ClassVar[QThread.Priority] = ...
    LowestPriority: typing.ClassVar[QThread.Priority] = ...
    NormalPriority: typing.ClassVar[QThread.Priority] = ...
    TimeCriticalPriority: typing.ClassVar[QThread.Priority] = ...
    finished: typing.ClassVar[Signal] = ...
    started: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., finished: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., started: typing.Callable = ...) -> None: ...
    @classmethod
    def currentThread(cls) -> QThread: ...
    def event(self, event: QEvent) -> bool: ...
    def eventDispatcher(self) -> QAbstractEventDispatcher: ...
    def exec_(self) -> int: ...
    def exit(self, retcode: int = ...) -> None: ...
    @classmethod
    def idealThreadCount(cls) -> int: ...
    def isFinished(self) -> bool: ...
    def isInterruptionRequested(self) -> bool: ...
    def isRunning(self) -> bool: ...
    def loopLevel(self) -> int: ...
    @classmethod
    def msleep(cls, arg__1: int) -> None: ...
    def priority(self) -> QThread.Priority: ...
    def quit(self) -> None: ...
    def requestInterruption(self) -> None: ...
    def run(self) -> None: ...
    def setEventDispatcher(self, eventDispatcher: QAbstractEventDispatcher) -> None: ...
    def setPriority(self, priority: QThread.Priority) -> None: ...
    def setStackSize(self, stackSize: int) -> None: ...
    @classmethod
    def setTerminationEnabled(cls, enabled: bool = ...) -> None: ...
    @classmethod
    def sleep(cls, arg__1: int) -> None: ...
    def stackSize(self) -> int: ...
    def start(self, priority: QThread.Priority = ...) -> None: ...
    def terminate(self) -> None: ...
    @classmethod
    def usleep(cls, arg__1: int) -> None: ...
    @overload
    def wait(self, deadline: QDeadlineTimer = ...) -> bool: ...
    @overload
    def wait(self, time: int) -> bool: ...
    @classmethod
    def yieldCurrentThread(cls) -> None: ...

class QThreadPool(QObject):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., activeThreadCount: int = ..., destroyed: typing.Callable = ..., expiryTimeout: int = ..., maxThreadCount: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., stackSize: int = ...) -> None: ...
    def activeThreadCount(self) -> int: ...
    def cancel(self, runnable: QRunnable) -> None: ...
    def clear(self) -> None: ...
    def contains(self, thread: QThread) -> bool: ...
    def expiryTimeout(self) -> int: ...
    @classmethod
    def globalInstance(cls) -> QThreadPool: ...
    def maxThreadCount(self) -> int: ...
    def releaseThread(self) -> None: ...
    def reserveThread(self) -> None: ...
    def setExpiryTimeout(self, expiryTimeout: int) -> None: ...
    def setMaxThreadCount(self, maxThreadCount: int) -> None: ...
    def setStackSize(self, stackSize: int) -> None: ...
    def stackSize(self) -> int: ...
    def start(self, runnable: QRunnable, priority: int = ...) -> None: ...
    def tryStart(self, runnable: QRunnable) -> bool: ...
    def tryTake(self, runnable: QRunnable) -> bool: ...
    def waitForDone(self, msecs: int = ...) -> bool: ...

class QTime(shiboken2.Object):
    @overload
    def __init__(self, h: int, m: int, s: int = ..., ms: int = ...) -> None: ...
    @overload
    def __init__(self, QTime: QTime) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def addMSecs(self, ms: int) -> QTime: ...
    def addSecs(self, secs: int) -> QTime: ...
    @classmethod
    def currentTime(cls) -> QTime: ...
    def elapsed(self) -> int: ...
    @classmethod
    def fromMSecsSinceStartOfDay(cls, msecs: int) -> QTime: ...
    @overload
    @classmethod
    def fromString(cls, s: str, f: Qt.DateFormat = ...) -> QTime: ...
    @overload
    @classmethod
    def fromString(cls, s: str, format: str) -> QTime: ...
    def hour(self) -> int: ...
    def isNull(self) -> bool: ...
    def isValid(self) -> bool: ...
    def minute(self) -> int: ...
    def msec(self) -> int: ...
    def msecsSinceStartOfDay(self) -> int: ...
    def msecsTo(self, arg__1: QTime) -> int: ...
    def restart(self) -> int: ...
    def second(self) -> int: ...
    def secsTo(self, arg__1: QTime) -> int: ...
    def setHMS(self, h: int, m: int, s: int, ms: int = ...) -> bool: ...
    def start(self) -> None: ...
    def toPython(self) -> object: ...
    @overload
    def toString(self, f: Qt.DateFormat = ...) -> str: ...
    @overload
    def toString(self, format: str) -> str: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QTimeLine(QObject):
    class CurveShape:
        CosineCurve: typing.ClassVar[QTimeLine.CurveShape] = ...
        EaseInCurve: typing.ClassVar[QTimeLine.CurveShape] = ...
        EaseInOutCurve: typing.ClassVar[QTimeLine.CurveShape] = ...
        EaseOutCurve: typing.ClassVar[QTimeLine.CurveShape] = ...
        LinearCurve: typing.ClassVar[QTimeLine.CurveShape] = ...
        SineCurve: typing.ClassVar[QTimeLine.CurveShape] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTimeLine.CurveShape: ...
        def __and__(self, other: typing.SupportsInt) -> QTimeLine.CurveShape: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTimeLine.CurveShape: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTimeLine.CurveShape: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTimeLine.CurveShape: ...
        def __rand__(self, other: typing.SupportsInt) -> QTimeLine.CurveShape: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTimeLine.CurveShape: ...
        def __ror__(self, other: typing.SupportsInt) -> QTimeLine.CurveShape: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTimeLine.CurveShape: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTimeLine.CurveShape: ...
        def __sub__(self, other: typing.SupportsInt) -> QTimeLine.CurveShape: ...
        def __xor__(self, other: typing.SupportsInt) -> QTimeLine.CurveShape: ...

    class Direction:
        Backward: typing.ClassVar[QTimeLine.Direction] = ...
        Forward: typing.ClassVar[QTimeLine.Direction] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTimeLine.Direction: ...
        def __and__(self, other: typing.SupportsInt) -> QTimeLine.Direction: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTimeLine.Direction: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTimeLine.Direction: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTimeLine.Direction: ...
        def __rand__(self, other: typing.SupportsInt) -> QTimeLine.Direction: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTimeLine.Direction: ...
        def __ror__(self, other: typing.SupportsInt) -> QTimeLine.Direction: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTimeLine.Direction: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTimeLine.Direction: ...
        def __sub__(self, other: typing.SupportsInt) -> QTimeLine.Direction: ...
        def __xor__(self, other: typing.SupportsInt) -> QTimeLine.Direction: ...

    class State:
        NotRunning: typing.ClassVar[QTimeLine.State] = ...
        Paused: typing.ClassVar[QTimeLine.State] = ...
        Running: typing.ClassVar[QTimeLine.State] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTimeLine.State: ...
        def __and__(self, other: typing.SupportsInt) -> QTimeLine.State: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTimeLine.State: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTimeLine.State: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTimeLine.State: ...
        def __rand__(self, other: typing.SupportsInt) -> QTimeLine.State: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTimeLine.State: ...
        def __ror__(self, other: typing.SupportsInt) -> QTimeLine.State: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTimeLine.State: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTimeLine.State: ...
        def __sub__(self, other: typing.SupportsInt) -> QTimeLine.State: ...
        def __xor__(self, other: typing.SupportsInt) -> QTimeLine.State: ...
    Backward: typing.ClassVar[QTimeLine.Direction] = ...
    CosineCurve: typing.ClassVar[QTimeLine.CurveShape] = ...
    EaseInCurve: typing.ClassVar[QTimeLine.CurveShape] = ...
    EaseInOutCurve: typing.ClassVar[QTimeLine.CurveShape] = ...
    EaseOutCurve: typing.ClassVar[QTimeLine.CurveShape] = ...
    Forward: typing.ClassVar[QTimeLine.Direction] = ...
    LinearCurve: typing.ClassVar[QTimeLine.CurveShape] = ...
    NotRunning: typing.ClassVar[QTimeLine.State] = ...
    Paused: typing.ClassVar[QTimeLine.State] = ...
    Running: typing.ClassVar[QTimeLine.State] = ...
    SineCurve: typing.ClassVar[QTimeLine.CurveShape] = ...
    finished: typing.ClassVar[Signal] = ...
    frameChanged: typing.ClassVar[Signal] = ...
    stateChanged: typing.ClassVar[Signal] = ...
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    valueChanged: typing.ClassVar[Signal] = ...
    def __init__(self, duration: int = ..., parent: typing.Union[QObject,None] = ..., currentTime: int = ..., curveShape: typing.Any = ..., destroyed: typing.Callable = ..., direction: typing.Any = ..., easingCurve: typing.Union[QEasingCurve,QEasingCurve.Type] = ..., finished: typing.Callable = ..., frameChanged: typing.Callable = ..., loopCount: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., stateChanged: typing.Callable = ..., updateInterval: int = ..., valueChanged: typing.Callable = ...) -> None: ...
    def currentFrame(self) -> int: ...
    def currentTime(self) -> int: ...
    def currentValue(self) -> float: ...
    def curveShape(self) -> QTimeLine.CurveShape: ...
    def direction(self) -> QTimeLine.Direction: ...
    def duration(self) -> int: ...
    def easingCurve(self) -> QEasingCurve: ...
    def endFrame(self) -> int: ...
    def frameForTime(self, msec: int) -> int: ...
    def loopCount(self) -> int: ...
    def resume(self) -> None: ...
    def setCurrentTime(self, msec: int) -> None: ...
    def setCurveShape(self, shape: QTimeLine.CurveShape) -> None: ...
    def setDirection(self, direction: QTimeLine.Direction) -> None: ...
    def setDuration(self, duration: int) -> None: ...
    def setEasingCurve(self, curve: typing.Union[QEasingCurve,QEasingCurve.Type]) -> None: ...
    def setEndFrame(self, frame: int) -> None: ...
    def setFrameRange(self, startFrame: int, endFrame: int) -> None: ...
    def setLoopCount(self, count: int) -> None: ...
    def setPaused(self, paused: bool) -> None: ...
    def setStartFrame(self, frame: int) -> None: ...
    def setUpdateInterval(self, interval: int) -> None: ...
    def start(self) -> None: ...
    def startFrame(self) -> int: ...
    def state(self) -> QTimeLine.State: ...
    def stop(self) -> None: ...
    def timerEvent(self, event: QTimerEvent) -> None: ...
    def toggleDirection(self) -> None: ...
    def updateInterval(self) -> int: ...
    def valueForTime(self, msec: int) -> float: ...

class QTimeZone(shiboken2.Object):
    class NameType:
        DefaultName: typing.ClassVar[QTimeZone.NameType] = ...
        LongName: typing.ClassVar[QTimeZone.NameType] = ...
        OffsetName: typing.ClassVar[QTimeZone.NameType] = ...
        ShortName: typing.ClassVar[QTimeZone.NameType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTimeZone.NameType: ...
        def __and__(self, other: typing.SupportsInt) -> QTimeZone.NameType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTimeZone.NameType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTimeZone.NameType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTimeZone.NameType: ...
        def __rand__(self, other: typing.SupportsInt) -> QTimeZone.NameType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTimeZone.NameType: ...
        def __ror__(self, other: typing.SupportsInt) -> QTimeZone.NameType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTimeZone.NameType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTimeZone.NameType: ...
        def __sub__(self, other: typing.SupportsInt) -> QTimeZone.NameType: ...
        def __xor__(self, other: typing.SupportsInt) -> QTimeZone.NameType: ...

    class OffsetData(shiboken2.Object):
        abbreviation: typing.Any
        atUtc: typing.Any
        daylightTimeOffset: typing.Any
        offsetFromUtc: typing.Any
        standardTimeOffset: typing.Any
        @overload
        def __init__(self, OffsetData: QTimeZone.OffsetData) -> None: ...
        @overload
        def __init__(self) -> None: ...
        def __copy__(self) -> None: ...

    class TimeType:
        DaylightTime: typing.ClassVar[QTimeZone.TimeType] = ...
        GenericTime: typing.ClassVar[QTimeZone.TimeType] = ...
        StandardTime: typing.ClassVar[QTimeZone.TimeType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QTimeZone.TimeType: ...
        def __and__(self, other: typing.SupportsInt) -> QTimeZone.TimeType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QTimeZone.TimeType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QTimeZone.TimeType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QTimeZone.TimeType: ...
        def __rand__(self, other: typing.SupportsInt) -> QTimeZone.TimeType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QTimeZone.TimeType: ...
        def __ror__(self, other: typing.SupportsInt) -> QTimeZone.TimeType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QTimeZone.TimeType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QTimeZone.TimeType: ...
        def __sub__(self, other: typing.SupportsInt) -> QTimeZone.TimeType: ...
        def __xor__(self, other: typing.SupportsInt) -> QTimeZone.TimeType: ...
    DaylightTime: typing.ClassVar[QTimeZone.TimeType] = ...
    DefaultName: typing.ClassVar[QTimeZone.NameType] = ...
    GenericTime: typing.ClassVar[QTimeZone.TimeType] = ...
    LongName: typing.ClassVar[QTimeZone.NameType] = ...
    OffsetName: typing.ClassVar[QTimeZone.NameType] = ...
    ShortName: typing.ClassVar[QTimeZone.NameType] = ...
    StandardTime: typing.ClassVar[QTimeZone.TimeType] = ...
    @overload
    def __init__(self, zoneId: typing.Union[QByteArray,bytes], offsetSeconds: int, name: str, abbreviation: str, country: QLocale.Country = ..., comment: str = ...) -> None: ...
    @overload
    def __init__(self, ianaId: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def __init__(self, offsetSeconds: int) -> None: ...
    @overload
    def __init__(self, other: QTimeZone) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def abbreviation(self, atDateTime: QDateTime) -> str: ...
    @overload
    @classmethod
    def availableTimeZoneIds(cls, country: QLocale.Country) -> typing.List[QByteArray]: ...
    @overload
    @classmethod
    def availableTimeZoneIds(cls, offsetSeconds: int) -> typing.List[QByteArray]: ...
    @overload
    @classmethod
    def availableTimeZoneIds(cls) -> typing.List[QByteArray]: ...
    def comment(self) -> str: ...
    def country(self) -> QLocale.Country: ...
    def daylightTimeOffset(self, atDateTime: QDateTime) -> int: ...
    @overload
    def displayName(self, atDateTime: QDateTime, nameType: QTimeZone.NameType = ..., locale: QLocale = ...) -> str: ...
    @overload
    def displayName(self, timeType: QTimeZone.TimeType, nameType: QTimeZone.NameType = ..., locale: QLocale = ...) -> str: ...
    def hasDaylightTime(self) -> bool: ...
    def hasTransitions(self) -> bool: ...
    @classmethod
    def ianaIdToWindowsId(cls, ianaId: typing.Union[QByteArray,bytes]) -> QByteArray: ...
    def id(self) -> QByteArray: ...
    def isDaylightTime(self, atDateTime: QDateTime) -> bool: ...
    @classmethod
    def isTimeZoneIdAvailable(cls, ianaId: typing.Union[QByteArray,bytes]) -> bool: ...
    def isValid(self) -> bool: ...
    def nextTransition(self, afterDateTime: QDateTime) -> QTimeZone.OffsetData: ...
    def offsetData(self, forDateTime: QDateTime) -> QTimeZone.OffsetData: ...
    def offsetFromUtc(self, atDateTime: QDateTime) -> int: ...
    def previousTransition(self, beforeDateTime: QDateTime) -> QTimeZone.OffsetData: ...
    def standardTimeOffset(self, atDateTime: QDateTime) -> int: ...
    def swap(self, other: QTimeZone) -> None: ...
    @classmethod
    def systemTimeZone(cls) -> QTimeZone: ...
    @classmethod
    def systemTimeZoneId(cls) -> QByteArray: ...
    def transitions(self, fromDateTime: QDateTime, toDateTime: QDateTime) -> typing.List[QTimeZone.OffsetData]: ...
    @classmethod
    def utc(cls) -> QTimeZone: ...
    @overload
    @classmethod
    def windowsIdToDefaultIanaId(cls, windowsId: typing.Union[QByteArray,bytes], country: QLocale.Country) -> QByteArray: ...
    @overload
    @classmethod
    def windowsIdToDefaultIanaId(cls, windowsId: typing.Union[QByteArray,bytes]) -> QByteArray: ...
    @overload
    @classmethod
    def windowsIdToIanaIds(cls, windowsId: typing.Union[QByteArray,bytes], country: QLocale.Country) -> typing.List[QByteArray]: ...
    @overload
    @classmethod
    def windowsIdToIanaIds(cls, windowsId: typing.Union[QByteArray,bytes]) -> typing.List[QByteArray]: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QTimer(QObject):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    timeout: typing.ClassVar[Signal] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., active: bool = ..., destroyed: typing.Callable = ..., interval: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., remainingTime: int = ..., singleShot: bool = ..., timeout: typing.Callable = ..., timerType: Qt.TimerType = ...) -> None: ...
    def interval(self) -> int: ...
    def isActive(self) -> bool: ...
    def isSingleShot(self) -> bool: ...
    def killTimer(self, arg__1: int) -> None: ...
    def remainingTime(self) -> int: ...
    def setInterval(self, msec: int) -> None: ...
    def setSingleShot(self, singleShot: bool) -> None: ...
    def setTimerType(self, atype: Qt.TimerType) -> None: ...
    @overload
    @classmethod
    def singleShot(cls, msec: int, timerType: Qt.TimerType, receiver: QObject, member: bytes) -> None: ...
    @overload
    @classmethod
    def singleShot(cls, msec: int, receiver: QObject, member: bytes) -> None: ...
    @overload
    @classmethod
    def singleShot(cls, arg__1: int, arg__2: typing.Callable) -> None: ...
    @overload
    def start(self, msec: int) -> None: ...
    @overload
    def start(self) -> None: ...
    def stop(self) -> None: ...
    def timerEvent(self, arg__1: QTimerEvent) -> None: ...
    def timerId(self) -> int: ...
    def timerType(self) -> Qt.TimerType: ...

class QTimerEvent(QEvent):
    def __init__(self, timerId: int) -> None: ...
    def timerId(self) -> int: ...

class QTranslator(QObject):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def filePath(self) -> str: ...
    def isEmpty(self) -> bool: ...
    def language(self) -> str: ...
    @overload
    def load(self, locale: QLocale, filename: str, prefix: str = ..., directory: str = ..., suffix: str = ...) -> bool: ...
    @overload
    def load(self, filename: str, directory: str = ..., search_delimiters: str = ..., suffix: str = ...) -> bool: ...
    @overload
    def load(self, data: bytes, len: int, directory: str = ...) -> bool: ...
    def translate(self, context: bytes, sourceText: bytes, disambiguation: typing.Union[bytes,None] = ..., n: int = ...) -> str: ...

class QTransposeProxyModel(QAbstractProxyModel):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., columnsAboutToBeInserted: typing.Callable = ..., columnsAboutToBeMoved: typing.Callable = ..., columnsAboutToBeRemoved: typing.Callable = ..., columnsInserted: typing.Callable = ..., columnsMoved: typing.Callable = ..., columnsRemoved: typing.Callable = ..., dataChanged: typing.Callable = ..., destroyed: typing.Callable = ..., headerDataChanged: typing.Callable = ..., layoutAboutToBeChanged: typing.Callable = ..., layoutChanged: typing.Callable = ..., modelAboutToBeReset: typing.Callable = ..., modelReset: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., rowsAboutToBeInserted: typing.Callable = ..., rowsAboutToBeMoved: typing.Callable = ..., rowsAboutToBeRemoved: typing.Callable = ..., rowsInserted: typing.Callable = ..., rowsMoved: typing.Callable = ..., rowsRemoved: typing.Callable = ..., sourceModel: typing.Any = ..., sourceModelChanged: typing.Callable = ...) -> None: ...
    def columnCount(self, parent: QModelIndex = ...) -> int: ...
    def headerData(self, section: int, orientation: Qt.Orientation, role: Qt.ItemDataRole = ...) -> typing.Any: ...
    def index(self, row: int, column: int, parent: QModelIndex = ...) -> QModelIndex: ...
    def insertColumns(self, column: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def itemData(self, index: QModelIndex) -> typing.Dict[int,typing.Any]: ...
    def mapFromSource(self, sourceIndex: QModelIndex) -> QModelIndex: ...
    def mapToSource(self, proxyIndex: QModelIndex) -> QModelIndex: ...
    def moveColumns(self, sourceParent: QModelIndex, sourceColumn: int, count: int, destinationParent: QModelIndex, destinationChild: int) -> bool: ...
    def moveRows(self, sourceParent: QModelIndex, sourceRow: int, count: int, destinationParent: QModelIndex, destinationChild: int) -> bool: ...
    @overload
    def parent(self, index: QModelIndex) -> QModelIndex: ...
    @overload
    def parent(self) -> QObject: ...
    def removeColumns(self, column: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: QModelIndex = ...) -> bool: ...
    def rowCount(self, parent: QModelIndex = ...) -> int: ...
    def setHeaderData(self, section: int, orientation: Qt.Orientation, value: typing.Any, role: Qt.ItemDataRole = ...) -> bool: ...
    def setItemData(self, index: QModelIndex, roles: typing.Dict[int,typing.Any]) -> bool: ...
    def setSourceModel(self, newSourceModel: QAbstractItemModel) -> None: ...
    def sort(self, column: int, order: Qt.SortOrder = ...) -> None: ...
    def span(self, index: QModelIndex) -> QSize: ...

class QUrl(shiboken2.Object):
    class ComponentFormattingOption:
        DecodeReserved: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
        EncodeDelimiters: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
        EncodeReserved: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
        EncodeSpaces: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
        EncodeUnicode: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
        FullyDecoded: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
        FullyEncoded: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
        PrettyDecoded: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QUrl.FormattingOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QUrl.FormattingOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QUrl.FormattingOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QUrl.FormattingOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QUrl.FormattingOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QUrl.FormattingOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QUrl.FormattingOptions: ...

    class FormattingOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QUrl.FormattingOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QUrl.FormattingOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QUrl.FormattingOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QUrl.FormattingOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QUrl.FormattingOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QUrl.FormattingOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QUrl.FormattingOptions: ...

    class ParsingMode:
        DecodedMode: typing.ClassVar[QUrl.ParsingMode] = ...
        StrictMode: typing.ClassVar[QUrl.ParsingMode] = ...
        TolerantMode: typing.ClassVar[QUrl.ParsingMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QUrl.ParsingMode: ...
        def __and__(self, other: typing.SupportsInt) -> QUrl.ParsingMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QUrl.ParsingMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QUrl.ParsingMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QUrl.ParsingMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QUrl.ParsingMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QUrl.ParsingMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QUrl.ParsingMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QUrl.ParsingMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QUrl.ParsingMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QUrl.ParsingMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QUrl.ParsingMode: ...

    class UrlFormattingOption:
        None_: typing.ClassVar[QUrl.UrlFormattingOption] = ...
        NormalizePathSegments: typing.ClassVar[QUrl.UrlFormattingOption] = ...
        PreferLocalFile: typing.ClassVar[QUrl.UrlFormattingOption] = ...
        RemoveAuthority: typing.ClassVar[QUrl.UrlFormattingOption] = ...
        RemoveFilename: typing.ClassVar[QUrl.UrlFormattingOption] = ...
        RemoveFragment: typing.ClassVar[QUrl.UrlFormattingOption] = ...
        RemovePassword: typing.ClassVar[QUrl.UrlFormattingOption] = ...
        RemovePath: typing.ClassVar[QUrl.UrlFormattingOption] = ...
        RemovePort: typing.ClassVar[QUrl.UrlFormattingOption] = ...
        RemoveQuery: typing.ClassVar[QUrl.UrlFormattingOption] = ...
        RemoveScheme: typing.ClassVar[QUrl.UrlFormattingOption] = ...
        RemoveUserInfo: typing.ClassVar[QUrl.UrlFormattingOption] = ...
        StripTrailingSlash: typing.ClassVar[QUrl.UrlFormattingOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QUrl.UrlFormattingOption: ...
        def __and__(self, other: typing.SupportsInt) -> QUrl.UrlFormattingOption: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QUrl.UrlFormattingOption: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QUrl.UrlFormattingOption: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QUrl.UrlFormattingOption: ...
        def __rand__(self, other: typing.SupportsInt) -> QUrl.UrlFormattingOption: ...
        def __rmul__(self, other: typing.SupportsInt) -> QUrl.UrlFormattingOption: ...
        def __ror__(self, other: typing.SupportsInt) -> QUrl.UrlFormattingOption: ...
        def __rsub__(self, other: typing.SupportsInt) -> QUrl.UrlFormattingOption: ...
        def __rxor__(self, other: typing.SupportsInt) -> QUrl.UrlFormattingOption: ...
        def __sub__(self, other: typing.SupportsInt) -> QUrl.UrlFormattingOption: ...
        def __xor__(self, other: typing.SupportsInt) -> QUrl.UrlFormattingOption: ...

    class UserInputResolutionOption:
        AssumeLocalFile: typing.ClassVar[QUrl.UserInputResolutionOption] = ...
        DefaultResolution: typing.ClassVar[QUrl.UserInputResolutionOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QUrl.UserInputResolutionOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QUrl.UserInputResolutionOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QUrl.UserInputResolutionOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QUrl.UserInputResolutionOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QUrl.UserInputResolutionOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QUrl.UserInputResolutionOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QUrl.UserInputResolutionOptions: ...

    class UserInputResolutionOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> QUrl.UserInputResolutionOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> QUrl.UserInputResolutionOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QUrl.UserInputResolutionOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> QUrl.UserInputResolutionOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> QUrl.UserInputResolutionOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> QUrl.UserInputResolutionOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> QUrl.UserInputResolutionOptions: ...
    AssumeLocalFile: typing.ClassVar[QUrl.UserInputResolutionOption] = ...
    DecodeReserved: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
    DecodedMode: typing.ClassVar[QUrl.ParsingMode] = ...
    DefaultResolution: typing.ClassVar[QUrl.UserInputResolutionOption] = ...
    EncodeDelimiters: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
    EncodeReserved: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
    EncodeSpaces: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
    EncodeUnicode: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
    FullyDecoded: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
    FullyEncoded: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
    None_: typing.ClassVar[QUrl.UrlFormattingOption] = ...
    NormalizePathSegments: typing.ClassVar[QUrl.UrlFormattingOption] = ...
    PreferLocalFile: typing.ClassVar[QUrl.UrlFormattingOption] = ...
    PrettyDecoded: typing.ClassVar[QUrl.ComponentFormattingOption] = ...
    RemoveAuthority: typing.ClassVar[QUrl.UrlFormattingOption] = ...
    RemoveFilename: typing.ClassVar[QUrl.UrlFormattingOption] = ...
    RemoveFragment: typing.ClassVar[QUrl.UrlFormattingOption] = ...
    RemovePassword: typing.ClassVar[QUrl.UrlFormattingOption] = ...
    RemovePath: typing.ClassVar[QUrl.UrlFormattingOption] = ...
    RemovePort: typing.ClassVar[QUrl.UrlFormattingOption] = ...
    RemoveQuery: typing.ClassVar[QUrl.UrlFormattingOption] = ...
    RemoveScheme: typing.ClassVar[QUrl.UrlFormattingOption] = ...
    RemoveUserInfo: typing.ClassVar[QUrl.UrlFormattingOption] = ...
    StrictMode: typing.ClassVar[QUrl.ParsingMode] = ...
    StripTrailingSlash: typing.ClassVar[QUrl.UrlFormattingOption] = ...
    TolerantMode: typing.ClassVar[QUrl.ParsingMode] = ...
    @overload
    def __init__(self, url: str, mode: QUrl.ParsingMode = ...) -> None: ...
    @overload
    def __init__(self, copy: QUrl) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def adjusted(self, options: typing.Union[QUrl.FormattingOptions,QUrl.ComponentFormattingOption]) -> QUrl: ...
    def authority(self, options: QUrl.ComponentFormattingOption = ...) -> str: ...
    def clear(self) -> None: ...
    def errorString(self) -> str: ...
    def fileName(self, options: QUrl.ComponentFormattingOption = ...) -> str: ...
    def fragment(self, options: QUrl.ComponentFormattingOption = ...) -> str: ...
    @classmethod
    def fromAce(cls, arg__1: typing.Union[QByteArray,bytes]) -> str: ...
    @classmethod
    def fromEncoded(cls, url: typing.Union[QByteArray,bytes], mode: QUrl.ParsingMode = ...) -> QUrl: ...
    @classmethod
    def fromLocalFile(cls, localfile: str) -> QUrl: ...
    @classmethod
    def fromPercentEncoding(cls, arg__1: typing.Union[QByteArray,bytes]) -> str: ...
    @classmethod
    def fromStringList(cls, uris: typing.Iterable[str], mode: QUrl.ParsingMode = ...) -> typing.List[QUrl]: ...
    @overload
    @classmethod
    def fromUserInput(cls, userInput: str, workingDirectory: str, options: typing.Union[QUrl.UserInputResolutionOptions,QUrl.UserInputResolutionOption] = ...) -> QUrl: ...
    @overload
    @classmethod
    def fromUserInput(cls, userInput: str) -> QUrl: ...
    def hasFragment(self) -> bool: ...
    def hasQuery(self) -> bool: ...
    def host(self, arg__1: QUrl.ComponentFormattingOption = ...) -> str: ...
    @classmethod
    def idnWhitelist(cls) -> typing.List[str]: ...
    def isEmpty(self) -> bool: ...
    def isLocalFile(self) -> bool: ...
    def isParentOf(self, url: QUrl) -> bool: ...
    def isRelative(self) -> bool: ...
    def isValid(self) -> bool: ...
    def matches(self, url: QUrl, options: typing.Union[QUrl.FormattingOptions,QUrl.ComponentFormattingOption]) -> bool: ...
    def password(self, arg__1: QUrl.ComponentFormattingOption = ...) -> str: ...
    def path(self, options: QUrl.ComponentFormattingOption = ...) -> str: ...
    def port(self, defaultPort: int = ...) -> int: ...
    def query(self, arg__1: QUrl.ComponentFormattingOption = ...) -> str: ...
    def resolved(self, relative: QUrl) -> QUrl: ...
    def scheme(self) -> str: ...
    def setAuthority(self, authority: str, mode: QUrl.ParsingMode = ...) -> None: ...
    def setFragment(self, fragment: str, mode: QUrl.ParsingMode = ...) -> None: ...
    def setHost(self, host: str, mode: QUrl.ParsingMode = ...) -> None: ...
    @classmethod
    def setIdnWhitelist(cls, arg__1: typing.Iterable[str]) -> None: ...
    def setPassword(self, password: str, mode: QUrl.ParsingMode = ...) -> None: ...
    def setPath(self, path: str, mode: QUrl.ParsingMode = ...) -> None: ...
    def setPort(self, port: int) -> None: ...
    @overload
    def setQuery(self, query: str, mode: QUrl.ParsingMode = ...) -> None: ...
    @overload
    def setQuery(self, query: QUrlQuery) -> None: ...
    def setScheme(self, scheme: str) -> None: ...
    def setUrl(self, url: str, mode: QUrl.ParsingMode = ...) -> None: ...
    def setUserInfo(self, userInfo: str, mode: QUrl.ParsingMode = ...) -> None: ...
    def setUserName(self, userName: str, mode: QUrl.ParsingMode = ...) -> None: ...
    def swap(self, other: QUrl) -> None: ...
    @classmethod
    def toAce(cls, arg__1: str) -> QByteArray: ...
    def toDisplayString(self, options: typing.Union[QUrl.FormattingOptions,QUrl.ComponentFormattingOption] = ...) -> str: ...
    def toEncoded(self, options: typing.Union[QUrl.FormattingOptions,QUrl.ComponentFormattingOption] = ...) -> QByteArray: ...
    def toLocalFile(self) -> str: ...
    @classmethod
    def toPercentEncoding(cls, arg__1: str, exclude: typing.Union[QByteArray,bytes] = ..., include: typing.Union[QByteArray,bytes] = ...) -> QByteArray: ...
    def toString(self, options: typing.Union[QUrl.FormattingOptions,QUrl.ComponentFormattingOption] = ...) -> str: ...
    @classmethod
    def toStringList(cls, uris: typing.Iterable[QUrl], options: typing.Union[QUrl.FormattingOptions,QUrl.ComponentFormattingOption] = ...) -> typing.List[str]: ...
    def topLevelDomain(self, options: QUrl.ComponentFormattingOption = ...) -> str: ...
    def url(self, options: typing.Union[QUrl.FormattingOptions,QUrl.ComponentFormattingOption] = ...) -> str: ...
    def userInfo(self, options: QUrl.ComponentFormattingOption = ...) -> str: ...
    def userName(self, options: QUrl.ComponentFormattingOption = ...) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QUrlQuery(shiboken2.Object):
    @overload
    def __init__(self, other: QUrlQuery) -> None: ...
    @overload
    def __init__(self, queryString: str) -> None: ...
    @overload
    def __init__(self, url: QUrl) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def addQueryItem(self, key: str, value: str) -> None: ...
    def allQueryItemValues(self, key: str, encoding: QUrl.ComponentFormattingOption = ...) -> typing.List[str]: ...
    def clear(self) -> None: ...
    @classmethod
    def defaultQueryPairDelimiter(cls) -> str: ...
    @classmethod
    def defaultQueryValueDelimiter(cls) -> str: ...
    def hasQueryItem(self, key: str) -> bool: ...
    def isEmpty(self) -> bool: ...
    def query(self, encoding: QUrl.ComponentFormattingOption = ...) -> str: ...
    def queryItemValue(self, key: str, encoding: QUrl.ComponentFormattingOption = ...) -> str: ...
    def queryItems(self, encoding: QUrl.ComponentFormattingOption = ...) -> typing.List[typing.Tuple[str,str]]: ...
    def queryPairDelimiter(self) -> str: ...
    def queryValueDelimiter(self) -> str: ...
    def removeAllQueryItems(self, key: str) -> None: ...
    def removeQueryItem(self, key: str) -> None: ...
    def setQuery(self, queryString: str) -> None: ...
    def setQueryDelimiters(self, valueDelimiter: str, pairDelimiter: str) -> None: ...
    def setQueryItems(self, query: typing.Iterable[typing.Tuple[str,str]]) -> None: ...
    def swap(self, other: QUrlQuery) -> None: ...
    def toString(self, encoding: QUrl.ComponentFormattingOption = ...) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QUuid(shiboken2.Object):
    class StringFormat:
        Id128: typing.ClassVar[QUuid.StringFormat] = ...
        WithBraces: typing.ClassVar[QUuid.StringFormat] = ...
        WithoutBraces: typing.ClassVar[QUuid.StringFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QUuid.StringFormat: ...
        def __and__(self, other: typing.SupportsInt) -> QUuid.StringFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QUuid.StringFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QUuid.StringFormat: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QUuid.StringFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> QUuid.StringFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> QUuid.StringFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> QUuid.StringFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> QUuid.StringFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> QUuid.StringFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> QUuid.StringFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> QUuid.StringFormat: ...

    class Variant:
        DCE: typing.ClassVar[QUuid.Variant] = ...
        Microsoft: typing.ClassVar[QUuid.Variant] = ...
        NCS: typing.ClassVar[QUuid.Variant] = ...
        Reserved: typing.ClassVar[QUuid.Variant] = ...
        VarUnknown: typing.ClassVar[QUuid.Variant] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QUuid.Variant: ...
        def __and__(self, other: typing.SupportsInt) -> QUuid.Variant: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QUuid.Variant: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QUuid.Variant: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QUuid.Variant: ...
        def __rand__(self, other: typing.SupportsInt) -> QUuid.Variant: ...
        def __rmul__(self, other: typing.SupportsInt) -> QUuid.Variant: ...
        def __ror__(self, other: typing.SupportsInt) -> QUuid.Variant: ...
        def __rsub__(self, other: typing.SupportsInt) -> QUuid.Variant: ...
        def __rxor__(self, other: typing.SupportsInt) -> QUuid.Variant: ...
        def __sub__(self, other: typing.SupportsInt) -> QUuid.Variant: ...
        def __xor__(self, other: typing.SupportsInt) -> QUuid.Variant: ...

    class Version:
        EmbeddedPOSIX: typing.ClassVar[QUuid.Version] = ...
        Md5: typing.ClassVar[QUuid.Version] = ...
        Name: typing.ClassVar[QUuid.Version] = ...
        Random: typing.ClassVar[QUuid.Version] = ...
        Sha1: typing.ClassVar[QUuid.Version] = ...
        Time: typing.ClassVar[QUuid.Version] = ...
        VerUnknown: typing.ClassVar[QUuid.Version] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QUuid.Version: ...
        def __and__(self, other: typing.SupportsInt) -> QUuid.Version: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QUuid.Version: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QUuid.Version: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QUuid.Version: ...
        def __rand__(self, other: typing.SupportsInt) -> QUuid.Version: ...
        def __rmul__(self, other: typing.SupportsInt) -> QUuid.Version: ...
        def __ror__(self, other: typing.SupportsInt) -> QUuid.Version: ...
        def __rsub__(self, other: typing.SupportsInt) -> QUuid.Version: ...
        def __rxor__(self, other: typing.SupportsInt) -> QUuid.Version: ...
        def __sub__(self, other: typing.SupportsInt) -> QUuid.Version: ...
        def __xor__(self, other: typing.SupportsInt) -> QUuid.Version: ...
    DCE: typing.ClassVar[QUuid.Variant] = ...
    EmbeddedPOSIX: typing.ClassVar[QUuid.Version] = ...
    Id128: typing.ClassVar[QUuid.StringFormat] = ...
    Md5: typing.ClassVar[QUuid.Version] = ...
    Microsoft: typing.ClassVar[QUuid.Variant] = ...
    NCS: typing.ClassVar[QUuid.Variant] = ...
    Name: typing.ClassVar[QUuid.Version] = ...
    Random: typing.ClassVar[QUuid.Version] = ...
    Reserved: typing.ClassVar[QUuid.Variant] = ...
    Sha1: typing.ClassVar[QUuid.Version] = ...
    Time: typing.ClassVar[QUuid.Version] = ...
    VarUnknown: typing.ClassVar[QUuid.Variant] = ...
    VerUnknown: typing.ClassVar[QUuid.Version] = ...
    WithBraces: typing.ClassVar[QUuid.StringFormat] = ...
    WithoutBraces: typing.ClassVar[QUuid.StringFormat] = ...
    @overload
    def __init__(self, l: int, w1: int, w2: int, b1: int, b2: int, b3: int, b4: int, b5: int, b6: int, b7: int, b8: int) -> None: ...
    @overload
    def __init__(self, arg__1: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def __init__(self, arg__1: str) -> None: ...
    @overload
    def __init__(self, arg__1: bytes) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def createUuid(cls) -> QUuid: ...
    @overload
    @classmethod
    def createUuidV3(cls, ns: QUuid, baseData: typing.Union[QByteArray,bytes]) -> QUuid: ...
    @overload
    @classmethod
    def createUuidV3(cls, ns: QUuid, baseData: str) -> QUuid: ...
    @overload
    @classmethod
    def createUuidV5(cls, ns: QUuid, baseData: typing.Union[QByteArray,bytes]) -> QUuid: ...
    @overload
    @classmethod
    def createUuidV5(cls, ns: QUuid, baseData: str) -> QUuid: ...
    @classmethod
    def fromRfc4122(cls, arg__1: typing.Union[QByteArray,bytes]) -> QUuid: ...
    def isNull(self) -> bool: ...
    @overload
    def toByteArray(self, mode: QUuid.StringFormat) -> QByteArray: ...
    @overload
    def toByteArray(self) -> QByteArray: ...
    def toRfc4122(self) -> QByteArray: ...
    @overload
    def toString(self, mode: QUuid.StringFormat) -> str: ...
    @overload
    def toString(self) -> str: ...
    def variant(self) -> QUuid.Variant: ...
    def version(self) -> QUuid.Version: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QVariantAnimation(QAbstractAnimation):
    staticMetaObject: typing.ClassVar[QMetaObject] = ...
    valueChanged: typing.ClassVar[Signal] = ...
    def __init__(self, parent: typing.Union[QObject,None] = ..., currentLoop: int = ..., currentLoopChanged: typing.Callable = ..., currentTime: int = ..., currentValue: object = ..., destroyed: typing.Callable = ..., direction: QVariantAnimation.Direction = ..., directionChanged: typing.Callable = ..., duration: int = ..., easingCurve: typing.Union[QEasingCurve,QEasingCurve.Type] = ..., endValue: object = ..., finished: typing.Callable = ..., loopCount: int = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., startValue: object = ..., state: QVariantAnimation.State = ..., stateChanged: typing.Callable = ..., valueChanged: typing.Callable = ...) -> None: ...
    def currentValue(self) -> typing.Any: ...
    def duration(self) -> int: ...
    def easingCurve(self) -> QEasingCurve: ...
    def endValue(self) -> typing.Any: ...
    def event(self, event: QEvent) -> bool: ...
    def interpolated(self, from_: typing.Any, to: typing.Any, progress: float) -> typing.Any: ...
    def keyValueAt(self, step: float) -> typing.Any: ...
    def keyValues(self) -> typing.List[typing.Tuple[float,typing.Any]]: ...
    def setDuration(self, msecs: int) -> None: ...
    def setEasingCurve(self, easing: typing.Union[QEasingCurve,QEasingCurve.Type]) -> None: ...
    def setEndValue(self, value: typing.Any) -> None: ...
    def setKeyValueAt(self, step: float, value: typing.Any) -> None: ...
    def setKeyValues(self, values: typing.List[typing.Tuple[float,typing.Any]]) -> None: ...
    def setStartValue(self, value: typing.Any) -> None: ...
    def startValue(self) -> typing.Any: ...
    def updateCurrentTime(self, arg__1: int) -> None: ...
    def updateCurrentValue(self, value: typing.Any) -> None: ...
    def updateState(self, newState: QAbstractAnimation.State, oldState: QAbstractAnimation.State) -> None: ...

class QVersionNumber(shiboken2.Object):
    @overload
    def __init__(self, maj: int, min: int, mic: int) -> None: ...
    @overload
    def __init__(self, maj: int, min: int) -> None: ...
    @overload
    def __init__(self, maj: int) -> None: ...
    @overload
    def __init__(self, seg: typing.List[int]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @classmethod
    def commonPrefix(cls, v1: QVersionNumber, v2: QVersionNumber) -> QVersionNumber: ...
    @classmethod
    def compare(cls, v1: QVersionNumber, v2: QVersionNumber) -> int: ...
    @classmethod
    def fromString(cls, string: str) -> typing.Tuple[QVersionNumber,int]: ...
    def isNormalized(self) -> bool: ...
    def isNull(self) -> bool: ...
    def isPrefixOf(self, other: QVersionNumber) -> bool: ...
    def majorVersion(self) -> int: ...
    def microVersion(self) -> int: ...
    def minorVersion(self) -> int: ...
    def normalized(self) -> QVersionNumber: ...
    def segmentAt(self, index: int) -> int: ...
    def segmentCount(self) -> int: ...
    def segments(self) -> typing.List[int]: ...
    def toString(self) -> str: ...
    def __bool__(self) -> bool: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QWaitCondition(shiboken2.Object):
    def __init__(self) -> None: ...
    def notify_all(self) -> None: ...
    def notify_one(self) -> None: ...
    @overload
    def wait(self, lockedMutex: QMutex, deadline: QDeadlineTimer = ...) -> bool: ...
    @overload
    def wait(self, lockedMutex: QMutex, time: int) -> bool: ...
    @overload
    def wait(self, lockedReadWriteLock: QReadWriteLock, deadline: QDeadlineTimer = ...) -> bool: ...
    @overload
    def wait(self, lockedReadWriteLock: QReadWriteLock, time: int) -> bool: ...
    def wakeAll(self) -> None: ...
    def wakeOne(self) -> None: ...

class QWriteLocker(shiboken2.Object):
    def __init__(self, readWriteLock: QReadWriteLock) -> None: ...
    def readWriteLock(self) -> QReadWriteLock: ...
    def relock(self) -> None: ...
    def unlock(self) -> None: ...
    def __enter__(self) -> None: ...
    def __exit__(self, arg__1: object, arg__2: object, arg__3: object) -> None: ...

class QXmlStreamAttribute(shiboken2.Object):
    @overload
    def __init__(self, namespaceUri: str, name: str, value: str) -> None: ...
    @overload
    def __init__(self, qualifiedName: str, value: str) -> None: ...
    @overload
    def __init__(self, arg__1: QXmlStreamAttribute) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def isDefault(self) -> bool: ...
    def name(self) -> str: ...
    def namespaceUri(self) -> str: ...
    def prefix(self) -> str: ...
    def qualifiedName(self) -> str: ...
    def value(self) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QXmlStreamAttributes(shiboken2.Object):
    @overload
    def __init__(self, QXmlStreamAttributes: QXmlStreamAttributes) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def append(self, namespaceUri: str, name: str, value: str) -> None: ...
    @overload
    def append(self, qualifiedName: str, value: str) -> None: ...
    def at(self, i: int) -> QXmlStreamAttribute: ...
    def back(self) -> QXmlStreamAttribute: ...
    def capacity(self) -> int: ...
    def clear(self) -> None: ...
    def constData(self) -> QXmlStreamAttribute: ...
    def constFirst(self) -> QXmlStreamAttribute: ...
    def constLast(self) -> QXmlStreamAttribute: ...
    def contains(self, t: QXmlStreamAttribute) -> bool: ...
    @overload
    def count(self, t: QXmlStreamAttribute) -> int: ...
    @overload
    def count(self) -> int: ...
    def data(self) -> QXmlStreamAttribute: ...
    def empty(self) -> bool: ...
    def endsWith(self, t: QXmlStreamAttribute) -> bool: ...
    def fill(self, t: QXmlStreamAttribute, size: int = ...) -> typing.List[QXmlStreamAttribute]: ...
    def first(self) -> QXmlStreamAttribute: ...
    def front(self) -> QXmlStreamAttribute: ...
    @overload
    def hasAttribute(self, namespaceUri: str, name: str) -> bool: ...
    @overload
    def hasAttribute(self, qualifiedName: str) -> bool: ...
    def indexOf(self, t: QXmlStreamAttribute, from_: int = ...) -> int: ...
    @overload
    def insert(self, i: int, n: int, t: QXmlStreamAttribute) -> None: ...
    @overload
    def insert(self, i: int, t: QXmlStreamAttribute) -> None: ...
    def isEmpty(self) -> bool: ...
    def isSharedWith(self, other: typing.List[QXmlStreamAttribute]) -> bool: ...
    def last(self) -> QXmlStreamAttribute: ...
    def lastIndexOf(self, t: QXmlStreamAttribute, from_: int = ...) -> int: ...
    def length(self) -> int: ...
    def mid(self, pos: int, len: int = ...) -> typing.List[QXmlStreamAttribute]: ...
    def move(self, from_: int, to: int) -> None: ...
    def prepend(self, t: QXmlStreamAttribute) -> None: ...
    @overload
    def remove(self, i: int, n: int) -> None: ...
    @overload
    def remove(self, i: int) -> None: ...
    def removeAll(self, t: QXmlStreamAttribute) -> int: ...
    def removeAt(self, i: int) -> None: ...
    def removeFirst(self) -> None: ...
    def removeLast(self) -> None: ...
    def removeOne(self, t: QXmlStreamAttribute) -> bool: ...
    def replace(self, i: int, t: QXmlStreamAttribute) -> None: ...
    def reserve(self, size: int) -> None: ...
    def resize(self, size: int) -> None: ...
    def setSharable(self, sharable: bool) -> None: ...
    def shrink_to_fit(self) -> None: ...
    def size(self) -> int: ...
    def squeeze(self) -> None: ...
    def startsWith(self, t: QXmlStreamAttribute) -> bool: ...
    def swap(self, other: typing.List[QXmlStreamAttribute]) -> None: ...
    def swapItemsAt(self, i: int, j: int) -> None: ...
    def takeAt(self, i: int) -> QXmlStreamAttribute: ...
    def takeFirst(self) -> QXmlStreamAttribute: ...
    def takeLast(self) -> QXmlStreamAttribute: ...
    @overload
    def value(self, namespaceUri: str, name: str) -> str: ...
    @overload
    def value(self, qualifiedName: str) -> str: ...
    def __add__(self, l: typing.List[QXmlStreamAttribute]) -> typing.List[QXmlStreamAttribute]: ...
    def __copy__(self) -> None: ...
    def __delitem__(self, other) -> typing.Any: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getitem__(self, index) -> typing.Any: ...
    def __gt__(self, other: object) -> bool: ...
    def __iadd__(self, t: QXmlStreamAttribute) -> typing.List[QXmlStreamAttribute]: ...
    def __le__(self, other: object) -> bool: ...
    def __len__(self) -> int: ...
    @overload
    def __lshift__(self, l: typing.List[QXmlStreamAttribute]) -> typing.List[QXmlStreamAttribute]: ...
    @overload
    def __lshift__(self, t: QXmlStreamAttribute) -> typing.List[QXmlStreamAttribute]: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __radd__(self, other) -> typing.Any: ...
    def __rlshift__(self, other) -> typing.Any: ...
    def __setitem__(self, index, object) -> None: ...

class QXmlStreamEntityDeclaration(shiboken2.Object):
    @overload
    def __init__(self, arg__1: QXmlStreamEntityDeclaration) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def name(self) -> str: ...
    def notationName(self) -> str: ...
    def publicId(self) -> str: ...
    def systemId(self) -> str: ...
    def value(self) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QXmlStreamEntityResolver(shiboken2.Object):
    def __init__(self) -> None: ...
    def resolveEntity(self, publicId: str, systemId: str) -> str: ...
    def resolveUndeclaredEntity(self, name: str) -> str: ...

class QXmlStreamNamespaceDeclaration(shiboken2.Object):
    @overload
    def __init__(self, prefix: str, namespaceUri: str) -> None: ...
    @overload
    def __init__(self, arg__1: QXmlStreamNamespaceDeclaration) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def namespaceUri(self) -> str: ...
    def prefix(self) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QXmlStreamNotationDeclaration(shiboken2.Object):
    @overload
    def __init__(self, arg__1: QXmlStreamNotationDeclaration) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def name(self) -> str: ...
    def publicId(self) -> str: ...
    def systemId(self) -> str: ...
    def __copy__(self) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...

class QXmlStreamReader(shiboken2.Object):
    class Error:
        CustomError: typing.ClassVar[QXmlStreamReader.Error] = ...
        NoError: typing.ClassVar[QXmlStreamReader.Error] = ...
        NotWellFormedError: typing.ClassVar[QXmlStreamReader.Error] = ...
        PrematureEndOfDocumentError: typing.ClassVar[QXmlStreamReader.Error] = ...
        UnexpectedElementError: typing.ClassVar[QXmlStreamReader.Error] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QXmlStreamReader.Error: ...
        def __and__(self, other: typing.SupportsInt) -> QXmlStreamReader.Error: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QXmlStreamReader.Error: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QXmlStreamReader.Error: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QXmlStreamReader.Error: ...
        def __rand__(self, other: typing.SupportsInt) -> QXmlStreamReader.Error: ...
        def __rmul__(self, other: typing.SupportsInt) -> QXmlStreamReader.Error: ...
        def __ror__(self, other: typing.SupportsInt) -> QXmlStreamReader.Error: ...
        def __rsub__(self, other: typing.SupportsInt) -> QXmlStreamReader.Error: ...
        def __rxor__(self, other: typing.SupportsInt) -> QXmlStreamReader.Error: ...
        def __sub__(self, other: typing.SupportsInt) -> QXmlStreamReader.Error: ...
        def __xor__(self, other: typing.SupportsInt) -> QXmlStreamReader.Error: ...

    class ReadElementTextBehaviour:
        ErrorOnUnexpectedElement: typing.ClassVar[QXmlStreamReader.ReadElementTextBehaviour] = ...
        IncludeChildElements: typing.ClassVar[QXmlStreamReader.ReadElementTextBehaviour] = ...
        SkipChildElements: typing.ClassVar[QXmlStreamReader.ReadElementTextBehaviour] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QXmlStreamReader.ReadElementTextBehaviour: ...
        def __and__(self, other: typing.SupportsInt) -> QXmlStreamReader.ReadElementTextBehaviour: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QXmlStreamReader.ReadElementTextBehaviour: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QXmlStreamReader.ReadElementTextBehaviour: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QXmlStreamReader.ReadElementTextBehaviour: ...
        def __rand__(self, other: typing.SupportsInt) -> QXmlStreamReader.ReadElementTextBehaviour: ...
        def __rmul__(self, other: typing.SupportsInt) -> QXmlStreamReader.ReadElementTextBehaviour: ...
        def __ror__(self, other: typing.SupportsInt) -> QXmlStreamReader.ReadElementTextBehaviour: ...
        def __rsub__(self, other: typing.SupportsInt) -> QXmlStreamReader.ReadElementTextBehaviour: ...
        def __rxor__(self, other: typing.SupportsInt) -> QXmlStreamReader.ReadElementTextBehaviour: ...
        def __sub__(self, other: typing.SupportsInt) -> QXmlStreamReader.ReadElementTextBehaviour: ...
        def __xor__(self, other: typing.SupportsInt) -> QXmlStreamReader.ReadElementTextBehaviour: ...

    class TokenType:
        Characters: typing.ClassVar[QXmlStreamReader.TokenType] = ...
        Comment: typing.ClassVar[QXmlStreamReader.TokenType] = ...
        DTD: typing.ClassVar[QXmlStreamReader.TokenType] = ...
        EndDocument: typing.ClassVar[QXmlStreamReader.TokenType] = ...
        EndElement: typing.ClassVar[QXmlStreamReader.TokenType] = ...
        EntityReference: typing.ClassVar[QXmlStreamReader.TokenType] = ...
        Invalid: typing.ClassVar[QXmlStreamReader.TokenType] = ...
        NoToken: typing.ClassVar[QXmlStreamReader.TokenType] = ...
        ProcessingInstruction: typing.ClassVar[QXmlStreamReader.TokenType] = ...
        StartDocument: typing.ClassVar[QXmlStreamReader.TokenType] = ...
        StartElement: typing.ClassVar[QXmlStreamReader.TokenType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QXmlStreamReader.TokenType: ...
        def __and__(self, other: typing.SupportsInt) -> QXmlStreamReader.TokenType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QXmlStreamReader.TokenType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QXmlStreamReader.TokenType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QXmlStreamReader.TokenType: ...
        def __rand__(self, other: typing.SupportsInt) -> QXmlStreamReader.TokenType: ...
        def __rmul__(self, other: typing.SupportsInt) -> QXmlStreamReader.TokenType: ...
        def __ror__(self, other: typing.SupportsInt) -> QXmlStreamReader.TokenType: ...
        def __rsub__(self, other: typing.SupportsInt) -> QXmlStreamReader.TokenType: ...
        def __rxor__(self, other: typing.SupportsInt) -> QXmlStreamReader.TokenType: ...
        def __sub__(self, other: typing.SupportsInt) -> QXmlStreamReader.TokenType: ...
        def __xor__(self, other: typing.SupportsInt) -> QXmlStreamReader.TokenType: ...
    Characters: typing.ClassVar[QXmlStreamReader.TokenType] = ...
    Comment: typing.ClassVar[QXmlStreamReader.TokenType] = ...
    CustomError: typing.ClassVar[QXmlStreamReader.Error] = ...
    DTD: typing.ClassVar[QXmlStreamReader.TokenType] = ...
    EndDocument: typing.ClassVar[QXmlStreamReader.TokenType] = ...
    EndElement: typing.ClassVar[QXmlStreamReader.TokenType] = ...
    EntityReference: typing.ClassVar[QXmlStreamReader.TokenType] = ...
    ErrorOnUnexpectedElement: typing.ClassVar[QXmlStreamReader.ReadElementTextBehaviour] = ...
    IncludeChildElements: typing.ClassVar[QXmlStreamReader.ReadElementTextBehaviour] = ...
    Invalid: typing.ClassVar[QXmlStreamReader.TokenType] = ...
    NoError: typing.ClassVar[QXmlStreamReader.Error] = ...
    NoToken: typing.ClassVar[QXmlStreamReader.TokenType] = ...
    NotWellFormedError: typing.ClassVar[QXmlStreamReader.Error] = ...
    PrematureEndOfDocumentError: typing.ClassVar[QXmlStreamReader.Error] = ...
    ProcessingInstruction: typing.ClassVar[QXmlStreamReader.TokenType] = ...
    SkipChildElements: typing.ClassVar[QXmlStreamReader.ReadElementTextBehaviour] = ...
    StartDocument: typing.ClassVar[QXmlStreamReader.TokenType] = ...
    StartElement: typing.ClassVar[QXmlStreamReader.TokenType] = ...
    UnexpectedElementError: typing.ClassVar[QXmlStreamReader.Error] = ...
    @overload
    def __init__(self, data: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def __init__(self, data: str) -> None: ...
    @overload
    def __init__(self, data: bytes) -> None: ...
    @overload
    def __init__(self, device: QIODevice) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def addData(self, data: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def addData(self, data: str) -> None: ...
    @overload
    def addData(self, data: bytes) -> None: ...
    def addExtraNamespaceDeclaration(self, extraNamespaceDeclaraction: QXmlStreamNamespaceDeclaration) -> None: ...
    def addExtraNamespaceDeclarations(self, extraNamespaceDeclaractions: typing.List[QXmlStreamNamespaceDeclaration]) -> None: ...
    def atEnd(self) -> bool: ...
    def attributes(self) -> QXmlStreamAttributes: ...
    def characterOffset(self) -> int: ...
    def clear(self) -> None: ...
    def columnNumber(self) -> int: ...
    def device(self) -> QIODevice: ...
    def documentEncoding(self) -> str: ...
    def documentVersion(self) -> str: ...
    def dtdName(self) -> str: ...
    def dtdPublicId(self) -> str: ...
    def dtdSystemId(self) -> str: ...
    def entityDeclarations(self) -> typing.List[QXmlStreamEntityDeclaration]: ...
    def entityExpansionLimit(self) -> int: ...
    def entityResolver(self) -> QXmlStreamEntityResolver: ...
    def error(self) -> QXmlStreamReader.Error: ...
    def errorString(self) -> str: ...
    def hasError(self) -> bool: ...
    def isCDATA(self) -> bool: ...
    def isCharacters(self) -> bool: ...
    def isComment(self) -> bool: ...
    def isDTD(self) -> bool: ...
    def isEndDocument(self) -> bool: ...
    def isEndElement(self) -> bool: ...
    def isEntityReference(self) -> bool: ...
    def isProcessingInstruction(self) -> bool: ...
    def isStandaloneDocument(self) -> bool: ...
    def isStartDocument(self) -> bool: ...
    def isStartElement(self) -> bool: ...
    def isWhitespace(self) -> bool: ...
    def lineNumber(self) -> int: ...
    def name(self) -> str: ...
    def namespaceDeclarations(self) -> typing.List[QXmlStreamNamespaceDeclaration]: ...
    def namespaceProcessing(self) -> bool: ...
    def namespaceUri(self) -> str: ...
    def notationDeclarations(self) -> typing.List[QXmlStreamNotationDeclaration]: ...
    def prefix(self) -> str: ...
    def processingInstructionData(self) -> str: ...
    def processingInstructionTarget(self) -> str: ...
    def qualifiedName(self) -> str: ...
    def raiseError(self, message: str = ...) -> None: ...
    def readElementText(self, behaviour: QXmlStreamReader.ReadElementTextBehaviour = ...) -> str: ...
    def readNext(self) -> QXmlStreamReader.TokenType: ...
    def readNextStartElement(self) -> bool: ...
    def setDevice(self, device: QIODevice) -> None: ...
    def setEntityExpansionLimit(self, limit: int) -> None: ...
    def setEntityResolver(self, resolver: QXmlStreamEntityResolver) -> None: ...
    def setNamespaceProcessing(self, arg__1: bool) -> None: ...
    def skipCurrentElement(self) -> None: ...
    def text(self) -> str: ...
    def tokenString(self) -> str: ...
    def tokenType(self) -> QXmlStreamReader.TokenType: ...

class QXmlStreamWriter(shiboken2.Object):
    @overload
    def __init__(self, array: typing.Union[QByteArray,bytes]) -> None: ...
    @overload
    def __init__(self, device: QIODevice) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def autoFormatting(self) -> bool: ...
    def autoFormattingIndent(self) -> int: ...
    def codec(self) -> QTextCodec: ...
    def device(self) -> QIODevice: ...
    def hasError(self) -> bool: ...
    def setAutoFormatting(self, arg__1: bool) -> None: ...
    def setAutoFormattingIndent(self, spacesOrTabs: int) -> None: ...
    @overload
    def setCodec(self, codec: QTextCodec) -> None: ...
    @overload
    def setCodec(self, codecName: bytes) -> None: ...
    def setDevice(self, device: QIODevice) -> None: ...
    @overload
    def writeAttribute(self, namespaceUri: str, name: str, value: str) -> None: ...
    @overload
    def writeAttribute(self, qualifiedName: str, value: str) -> None: ...
    @overload
    def writeAttribute(self, attribute: QXmlStreamAttribute) -> None: ...
    def writeAttributes(self, attributes: QXmlStreamAttributes) -> None: ...
    def writeCDATA(self, text: str) -> None: ...
    def writeCharacters(self, text: str) -> None: ...
    def writeComment(self, text: str) -> None: ...
    def writeCurrentToken(self, reader: QXmlStreamReader) -> None: ...
    def writeDTD(self, dtd: str) -> None: ...
    def writeDefaultNamespace(self, namespaceUri: str) -> None: ...
    @overload
    def writeEmptyElement(self, namespaceUri: str, name: str) -> None: ...
    @overload
    def writeEmptyElement(self, qualifiedName: str) -> None: ...
    def writeEndDocument(self) -> None: ...
    def writeEndElement(self) -> None: ...
    def writeEntityReference(self, name: str) -> None: ...
    def writeNamespace(self, namespaceUri: str, prefix: str = ...) -> None: ...
    def writeProcessingInstruction(self, target: str, data: str = ...) -> None: ...
    @overload
    def writeStartDocument(self, version: str, standalone: bool) -> None: ...
    @overload
    def writeStartDocument(self, version: str) -> None: ...
    @overload
    def writeStartDocument(self) -> None: ...
    @overload
    def writeStartElement(self, namespaceUri: str, name: str) -> None: ...
    @overload
    def writeStartElement(self, qualifiedName: str) -> None: ...
    @overload
    def writeTextElement(self, namespaceUri: str, name: str, text: str) -> None: ...
    @overload
    def writeTextElement(self, qualifiedName: str, text: str) -> None: ...

class Qt(shiboken2.Object):
    class Alignment:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.Alignment: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.Alignment: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.Alignment: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.Alignment: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.Alignment: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.Alignment: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.Alignment: ...

    class AlignmentFlag:
        AlignAbsolute: typing.ClassVar[Qt.AlignmentFlag] = ...
        AlignBaseline: typing.ClassVar[Qt.AlignmentFlag] = ...
        AlignBottom: typing.ClassVar[Qt.AlignmentFlag] = ...
        AlignCenter: typing.ClassVar[Qt.AlignmentFlag] = ...
        AlignHCenter: typing.ClassVar[Qt.AlignmentFlag] = ...
        AlignHorizontal_Mask: typing.ClassVar[Qt.AlignmentFlag] = ...
        AlignJustify: typing.ClassVar[Qt.AlignmentFlag] = ...
        AlignLeading: typing.ClassVar[Qt.AlignmentFlag] = ...
        AlignLeft: typing.ClassVar[Qt.AlignmentFlag] = ...
        AlignRight: typing.ClassVar[Qt.AlignmentFlag] = ...
        AlignTop: typing.ClassVar[Qt.AlignmentFlag] = ...
        AlignTrailing: typing.ClassVar[Qt.AlignmentFlag] = ...
        AlignVCenter: typing.ClassVar[Qt.AlignmentFlag] = ...
        AlignVertical_Mask: typing.ClassVar[Qt.AlignmentFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.Alignment: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.Alignment: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.Alignment: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.Alignment: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.Alignment: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.Alignment: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.Alignment: ...

    class AnchorPoint:
        AnchorBottom: typing.ClassVar[Qt.AnchorPoint] = ...
        AnchorHorizontalCenter: typing.ClassVar[Qt.AnchorPoint] = ...
        AnchorLeft: typing.ClassVar[Qt.AnchorPoint] = ...
        AnchorRight: typing.ClassVar[Qt.AnchorPoint] = ...
        AnchorTop: typing.ClassVar[Qt.AnchorPoint] = ...
        AnchorVerticalCenter: typing.ClassVar[Qt.AnchorPoint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.AnchorPoint: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.AnchorPoint: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.AnchorPoint: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.AnchorPoint: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.AnchorPoint: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.AnchorPoint: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.AnchorPoint: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.AnchorPoint: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.AnchorPoint: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.AnchorPoint: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.AnchorPoint: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.AnchorPoint: ...

    class ApplicationAttribute:
        AA_AttributeCount: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_CompressHighFrequencyEvents: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_CompressTabletEvents: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_DisableHighDpiScaling: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_DisableNativeVirtualKeyboard: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_DisableSessionManager: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_DisableShaderDiskCache: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_DisableWindowContextHelpButton: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_DontCheckOpenGLContextThreadAffinity: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_DontCreateNativeWidgetSiblings: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_DontShowIconsInMenus: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_DontShowShortcutsInContextMenus: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_DontUseNativeDialogs: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_DontUseNativeMenuBar: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_EnableHighDpiScaling: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_ForceRasterWidgets: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_ImmediateWidgetCreation: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_MSWindowsUseDirect3DByDefault: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_MacDontSwapCtrlAndMeta: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_MacPluginApplication: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_NativeWindows: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_PluginApplication: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_SetPalette: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_ShareOpenGLContexts: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_SynthesizeMouseForUnhandledTabletEvents: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_SynthesizeMouseForUnhandledTouchEvents: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_SynthesizeTouchForUnhandledMouseEvents: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_Use96Dpi: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_UseDesktopOpenGL: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_UseHighDpiPixmaps: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_UseOpenGLES: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_UseSoftwareOpenGL: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_UseStyleSheetPropagationInWidgetStyles: typing.ClassVar[Qt.ApplicationAttribute] = ...
        AA_X11InitThreads: typing.ClassVar[Qt.ApplicationAttribute] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.ApplicationAttribute: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ApplicationAttribute: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.ApplicationAttribute: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ApplicationAttribute: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.ApplicationAttribute: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ApplicationAttribute: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.ApplicationAttribute: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ApplicationAttribute: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.ApplicationAttribute: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ApplicationAttribute: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.ApplicationAttribute: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ApplicationAttribute: ...

    class ApplicationState:
        ApplicationActive: typing.ClassVar[Qt.ApplicationState] = ...
        ApplicationHidden: typing.ClassVar[Qt.ApplicationState] = ...
        ApplicationInactive: typing.ClassVar[Qt.ApplicationState] = ...
        ApplicationSuspended: typing.ClassVar[Qt.ApplicationState] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ApplicationStates: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.ApplicationStates: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ApplicationStates: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ApplicationStates: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ApplicationStates: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ApplicationStates: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ApplicationStates: ...

    class ApplicationStates:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ApplicationStates: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.ApplicationStates: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ApplicationStates: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ApplicationStates: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ApplicationStates: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ApplicationStates: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ApplicationStates: ...

    class ArrowType:
        DownArrow: typing.ClassVar[Qt.ArrowType] = ...
        LeftArrow: typing.ClassVar[Qt.ArrowType] = ...
        NoArrow: typing.ClassVar[Qt.ArrowType] = ...
        RightArrow: typing.ClassVar[Qt.ArrowType] = ...
        UpArrow: typing.ClassVar[Qt.ArrowType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.ArrowType: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ArrowType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.ArrowType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ArrowType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.ArrowType: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ArrowType: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.ArrowType: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ArrowType: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.ArrowType: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ArrowType: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.ArrowType: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ArrowType: ...

    class AspectRatioMode:
        IgnoreAspectRatio: typing.ClassVar[Qt.AspectRatioMode] = ...
        KeepAspectRatio: typing.ClassVar[Qt.AspectRatioMode] = ...
        KeepAspectRatioByExpanding: typing.ClassVar[Qt.AspectRatioMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.AspectRatioMode: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.AspectRatioMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.AspectRatioMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.AspectRatioMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.AspectRatioMode: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.AspectRatioMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.AspectRatioMode: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.AspectRatioMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.AspectRatioMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.AspectRatioMode: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.AspectRatioMode: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.AspectRatioMode: ...

    class Axis:
        XAxis: typing.ClassVar[Qt.Axis] = ...
        YAxis: typing.ClassVar[Qt.Axis] = ...
        ZAxis: typing.ClassVar[Qt.Axis] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.Axis: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.Axis: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.Axis: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.Axis: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.Axis: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.Axis: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.Axis: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.Axis: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.Axis: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.Axis: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.Axis: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.Axis: ...

    class BGMode:
        OpaqueMode: typing.ClassVar[Qt.BGMode] = ...
        TransparentMode: typing.ClassVar[Qt.BGMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.BGMode: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.BGMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.BGMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.BGMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.BGMode: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.BGMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.BGMode: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.BGMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.BGMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.BGMode: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.BGMode: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.BGMode: ...

    class BrushStyle:
        BDiagPattern: typing.ClassVar[Qt.BrushStyle] = ...
        ConicalGradientPattern: typing.ClassVar[Qt.BrushStyle] = ...
        CrossPattern: typing.ClassVar[Qt.BrushStyle] = ...
        Dense1Pattern: typing.ClassVar[Qt.BrushStyle] = ...
        Dense2Pattern: typing.ClassVar[Qt.BrushStyle] = ...
        Dense3Pattern: typing.ClassVar[Qt.BrushStyle] = ...
        Dense4Pattern: typing.ClassVar[Qt.BrushStyle] = ...
        Dense5Pattern: typing.ClassVar[Qt.BrushStyle] = ...
        Dense6Pattern: typing.ClassVar[Qt.BrushStyle] = ...
        Dense7Pattern: typing.ClassVar[Qt.BrushStyle] = ...
        DiagCrossPattern: typing.ClassVar[Qt.BrushStyle] = ...
        FDiagPattern: typing.ClassVar[Qt.BrushStyle] = ...
        HorPattern: typing.ClassVar[Qt.BrushStyle] = ...
        LinearGradientPattern: typing.ClassVar[Qt.BrushStyle] = ...
        NoBrush: typing.ClassVar[Qt.BrushStyle] = ...
        RadialGradientPattern: typing.ClassVar[Qt.BrushStyle] = ...
        SolidPattern: typing.ClassVar[Qt.BrushStyle] = ...
        TexturePattern: typing.ClassVar[Qt.BrushStyle] = ...
        VerPattern: typing.ClassVar[Qt.BrushStyle] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.BrushStyle: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.BrushStyle: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.BrushStyle: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.BrushStyle: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.BrushStyle: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.BrushStyle: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.BrushStyle: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.BrushStyle: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.BrushStyle: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.BrushStyle: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.BrushStyle: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.BrushStyle: ...

    class CaseSensitivity:
        CaseInsensitive: typing.ClassVar[Qt.CaseSensitivity] = ...
        CaseSensitive: typing.ClassVar[Qt.CaseSensitivity] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.CaseSensitivity: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.CaseSensitivity: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.CaseSensitivity: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.CaseSensitivity: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.CaseSensitivity: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.CaseSensitivity: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.CaseSensitivity: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.CaseSensitivity: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.CaseSensitivity: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.CaseSensitivity: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.CaseSensitivity: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.CaseSensitivity: ...

    class CheckState:
        Checked: typing.ClassVar[Qt.CheckState] = ...
        PartiallyChecked: typing.ClassVar[Qt.CheckState] = ...
        Unchecked: typing.ClassVar[Qt.CheckState] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.CheckState: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.CheckState: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.CheckState: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.CheckState: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.CheckState: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.CheckState: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.CheckState: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.CheckState: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.CheckState: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.CheckState: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.CheckState: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.CheckState: ...

    class ChecksumType:
        ChecksumIso3309: typing.ClassVar[Qt.ChecksumType] = ...
        ChecksumItuV41: typing.ClassVar[Qt.ChecksumType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.ChecksumType: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ChecksumType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.ChecksumType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ChecksumType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.ChecksumType: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ChecksumType: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.ChecksumType: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ChecksumType: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.ChecksumType: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ChecksumType: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.ChecksumType: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ChecksumType: ...

    class ClipOperation:
        IntersectClip: typing.ClassVar[Qt.ClipOperation] = ...
        NoClip: typing.ClassVar[Qt.ClipOperation] = ...
        ReplaceClip: typing.ClassVar[Qt.ClipOperation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.ClipOperation: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ClipOperation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.ClipOperation: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ClipOperation: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.ClipOperation: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ClipOperation: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.ClipOperation: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ClipOperation: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.ClipOperation: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ClipOperation: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.ClipOperation: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ClipOperation: ...

    class ConnectionType:
        AutoConnection: typing.ClassVar[Qt.ConnectionType] = ...
        BlockingQueuedConnection: typing.ClassVar[Qt.ConnectionType] = ...
        DirectConnection: typing.ClassVar[Qt.ConnectionType] = ...
        QueuedConnection: typing.ClassVar[Qt.ConnectionType] = ...
        UniqueConnection: typing.ClassVar[Qt.ConnectionType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.ConnectionType: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ConnectionType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.ConnectionType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ConnectionType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.ConnectionType: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ConnectionType: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.ConnectionType: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ConnectionType: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.ConnectionType: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ConnectionType: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.ConnectionType: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ConnectionType: ...

    class ContextMenuPolicy:
        ActionsContextMenu: typing.ClassVar[Qt.ContextMenuPolicy] = ...
        CustomContextMenu: typing.ClassVar[Qt.ContextMenuPolicy] = ...
        DefaultContextMenu: typing.ClassVar[Qt.ContextMenuPolicy] = ...
        NoContextMenu: typing.ClassVar[Qt.ContextMenuPolicy] = ...
        PreventContextMenu: typing.ClassVar[Qt.ContextMenuPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.ContextMenuPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ContextMenuPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.ContextMenuPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ContextMenuPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.ContextMenuPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ContextMenuPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.ContextMenuPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ContextMenuPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.ContextMenuPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ContextMenuPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.ContextMenuPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ContextMenuPolicy: ...

    class CoordinateSystem:
        DeviceCoordinates: typing.ClassVar[Qt.CoordinateSystem] = ...
        LogicalCoordinates: typing.ClassVar[Qt.CoordinateSystem] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.CoordinateSystem: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.CoordinateSystem: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.CoordinateSystem: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.CoordinateSystem: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.CoordinateSystem: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.CoordinateSystem: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.CoordinateSystem: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.CoordinateSystem: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.CoordinateSystem: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.CoordinateSystem: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.CoordinateSystem: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.CoordinateSystem: ...

    class Corner:
        BottomLeftCorner: typing.ClassVar[Qt.Corner] = ...
        BottomRightCorner: typing.ClassVar[Qt.Corner] = ...
        TopLeftCorner: typing.ClassVar[Qt.Corner] = ...
        TopRightCorner: typing.ClassVar[Qt.Corner] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.Corner: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.Corner: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.Corner: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.Corner: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.Corner: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.Corner: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.Corner: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.Corner: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.Corner: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.Corner: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.Corner: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.Corner: ...

    class CursorMoveStyle:
        LogicalMoveStyle: typing.ClassVar[Qt.CursorMoveStyle] = ...
        VisualMoveStyle: typing.ClassVar[Qt.CursorMoveStyle] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.CursorMoveStyle: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.CursorMoveStyle: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.CursorMoveStyle: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.CursorMoveStyle: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.CursorMoveStyle: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.CursorMoveStyle: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.CursorMoveStyle: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.CursorMoveStyle: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.CursorMoveStyle: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.CursorMoveStyle: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.CursorMoveStyle: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.CursorMoveStyle: ...

    class CursorShape:
        ArrowCursor: typing.ClassVar[Qt.CursorShape] = ...
        BitmapCursor: typing.ClassVar[Qt.CursorShape] = ...
        BlankCursor: typing.ClassVar[Qt.CursorShape] = ...
        BusyCursor: typing.ClassVar[Qt.CursorShape] = ...
        ClosedHandCursor: typing.ClassVar[Qt.CursorShape] = ...
        CrossCursor: typing.ClassVar[Qt.CursorShape] = ...
        CustomCursor: typing.ClassVar[Qt.CursorShape] = ...
        DragCopyCursor: typing.ClassVar[Qt.CursorShape] = ...
        DragLinkCursor: typing.ClassVar[Qt.CursorShape] = ...
        DragMoveCursor: typing.ClassVar[Qt.CursorShape] = ...
        ForbiddenCursor: typing.ClassVar[Qt.CursorShape] = ...
        IBeamCursor: typing.ClassVar[Qt.CursorShape] = ...
        LastCursor: typing.ClassVar[Qt.CursorShape] = ...
        OpenHandCursor: typing.ClassVar[Qt.CursorShape] = ...
        PointingHandCursor: typing.ClassVar[Qt.CursorShape] = ...
        SizeAllCursor: typing.ClassVar[Qt.CursorShape] = ...
        SizeBDiagCursor: typing.ClassVar[Qt.CursorShape] = ...
        SizeFDiagCursor: typing.ClassVar[Qt.CursorShape] = ...
        SizeHorCursor: typing.ClassVar[Qt.CursorShape] = ...
        SizeVerCursor: typing.ClassVar[Qt.CursorShape] = ...
        SplitHCursor: typing.ClassVar[Qt.CursorShape] = ...
        SplitVCursor: typing.ClassVar[Qt.CursorShape] = ...
        UpArrowCursor: typing.ClassVar[Qt.CursorShape] = ...
        WaitCursor: typing.ClassVar[Qt.CursorShape] = ...
        WhatsThisCursor: typing.ClassVar[Qt.CursorShape] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.CursorShape: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.CursorShape: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.CursorShape: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.CursorShape: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.CursorShape: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.CursorShape: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.CursorShape: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.CursorShape: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.CursorShape: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.CursorShape: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.CursorShape: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.CursorShape: ...

    class DateFormat:
        DefaultLocaleLongDate: typing.ClassVar[Qt.DateFormat] = ...
        DefaultLocaleShortDate: typing.ClassVar[Qt.DateFormat] = ...
        ISODate: typing.ClassVar[Qt.DateFormat] = ...
        ISODateWithMs: typing.ClassVar[Qt.DateFormat] = ...
        LocalDate: typing.ClassVar[Qt.DateFormat] = ...
        LocaleDate: typing.ClassVar[Qt.DateFormat] = ...
        RFC2822Date: typing.ClassVar[Qt.DateFormat] = ...
        SystemLocaleDate: typing.ClassVar[Qt.DateFormat] = ...
        SystemLocaleLongDate: typing.ClassVar[Qt.DateFormat] = ...
        SystemLocaleShortDate: typing.ClassVar[Qt.DateFormat] = ...
        TextDate: typing.ClassVar[Qt.DateFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.DateFormat: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.DateFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.DateFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.DateFormat: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.DateFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.DateFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.DateFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.DateFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.DateFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.DateFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.DateFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.DateFormat: ...

    class DayOfWeek:
        Friday: typing.ClassVar[Qt.DayOfWeek] = ...
        Monday: typing.ClassVar[Qt.DayOfWeek] = ...
        Saturday: typing.ClassVar[Qt.DayOfWeek] = ...
        Sunday: typing.ClassVar[Qt.DayOfWeek] = ...
        Thursday: typing.ClassVar[Qt.DayOfWeek] = ...
        Tuesday: typing.ClassVar[Qt.DayOfWeek] = ...
        Wednesday: typing.ClassVar[Qt.DayOfWeek] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.DayOfWeek: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.DayOfWeek: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.DayOfWeek: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.DayOfWeek: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.DayOfWeek: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.DayOfWeek: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.DayOfWeek: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.DayOfWeek: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.DayOfWeek: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.DayOfWeek: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.DayOfWeek: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.DayOfWeek: ...

    class DockWidgetArea:
        AllDockWidgetAreas: typing.ClassVar[Qt.DockWidgetArea] = ...
        BottomDockWidgetArea: typing.ClassVar[Qt.DockWidgetArea] = ...
        DockWidgetArea_Mask: typing.ClassVar[Qt.DockWidgetArea] = ...
        LeftDockWidgetArea: typing.ClassVar[Qt.DockWidgetArea] = ...
        NoDockWidgetArea: typing.ClassVar[Qt.DockWidgetArea] = ...
        RightDockWidgetArea: typing.ClassVar[Qt.DockWidgetArea] = ...
        TopDockWidgetArea: typing.ClassVar[Qt.DockWidgetArea] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreas: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.DockWidgetAreas: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreas: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreas: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreas: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreas: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreas: ...

    class DockWidgetAreaSizes:
        NDockWidgetAreas: typing.ClassVar[Qt.DockWidgetAreaSizes] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreaSizes: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreaSizes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreaSizes: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreaSizes: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreaSizes: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreaSizes: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreaSizes: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreaSizes: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreaSizes: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreaSizes: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreaSizes: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreaSizes: ...

    class DockWidgetAreas:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreas: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.DockWidgetAreas: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreas: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreas: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreas: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreas: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.DockWidgetAreas: ...

    class DropAction:
        ActionMask: typing.ClassVar[Qt.DropAction] = ...
        CopyAction: typing.ClassVar[Qt.DropAction] = ...
        IgnoreAction: typing.ClassVar[Qt.DropAction] = ...
        LinkAction: typing.ClassVar[Qt.DropAction] = ...
        MoveAction: typing.ClassVar[Qt.DropAction] = ...
        TargetMoveAction: typing.ClassVar[Qt.DropAction] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.DropActions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.DropActions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.DropActions: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.DropActions: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.DropActions: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.DropActions: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.DropActions: ...

    class DropActions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.DropActions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.DropActions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.DropActions: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.DropActions: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.DropActions: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.DropActions: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.DropActions: ...

    class Edge:
        BottomEdge: typing.ClassVar[Qt.Edge] = ...
        LeftEdge: typing.ClassVar[Qt.Edge] = ...
        RightEdge: typing.ClassVar[Qt.Edge] = ...
        TopEdge: typing.ClassVar[Qt.Edge] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.Edges: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.Edges: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.Edges: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.Edges: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.Edges: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.Edges: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.Edges: ...

    class Edges:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.Edges: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.Edges: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.Edges: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.Edges: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.Edges: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.Edges: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.Edges: ...

    class EnterKeyType:
        EnterKeyDefault: typing.ClassVar[Qt.EnterKeyType] = ...
        EnterKeyDone: typing.ClassVar[Qt.EnterKeyType] = ...
        EnterKeyGo: typing.ClassVar[Qt.EnterKeyType] = ...
        EnterKeyNext: typing.ClassVar[Qt.EnterKeyType] = ...
        EnterKeyPrevious: typing.ClassVar[Qt.EnterKeyType] = ...
        EnterKeyReturn: typing.ClassVar[Qt.EnterKeyType] = ...
        EnterKeySearch: typing.ClassVar[Qt.EnterKeyType] = ...
        EnterKeySend: typing.ClassVar[Qt.EnterKeyType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.EnterKeyType: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.EnterKeyType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.EnterKeyType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.EnterKeyType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.EnterKeyType: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.EnterKeyType: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.EnterKeyType: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.EnterKeyType: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.EnterKeyType: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.EnterKeyType: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.EnterKeyType: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.EnterKeyType: ...

    class EventPriority:
        HighEventPriority: typing.ClassVar[Qt.EventPriority] = ...
        LowEventPriority: typing.ClassVar[Qt.EventPriority] = ...
        NormalEventPriority: typing.ClassVar[Qt.EventPriority] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.EventPriority: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.EventPriority: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.EventPriority: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.EventPriority: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.EventPriority: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.EventPriority: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.EventPriority: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.EventPriority: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.EventPriority: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.EventPriority: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.EventPriority: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.EventPriority: ...

    class FillRule:
        OddEvenFill: typing.ClassVar[Qt.FillRule] = ...
        WindingFill: typing.ClassVar[Qt.FillRule] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.FillRule: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.FillRule: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.FillRule: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.FillRule: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.FillRule: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.FillRule: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.FillRule: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.FillRule: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.FillRule: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.FillRule: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.FillRule: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.FillRule: ...

    class FindChildOption:
        FindChildrenRecursively: typing.ClassVar[Qt.FindChildOption] = ...
        FindDirectChildrenOnly: typing.ClassVar[Qt.FindChildOption] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.FindChildOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.FindChildOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.FindChildOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.FindChildOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.FindChildOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.FindChildOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.FindChildOptions: ...

    class FindChildOptions:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.FindChildOptions: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.FindChildOptions: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.FindChildOptions: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.FindChildOptions: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.FindChildOptions: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.FindChildOptions: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.FindChildOptions: ...

    class FocusPolicy:
        ClickFocus: typing.ClassVar[Qt.FocusPolicy] = ...
        NoFocus: typing.ClassVar[Qt.FocusPolicy] = ...
        StrongFocus: typing.ClassVar[Qt.FocusPolicy] = ...
        TabFocus: typing.ClassVar[Qt.FocusPolicy] = ...
        WheelFocus: typing.ClassVar[Qt.FocusPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.FocusPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.FocusPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.FocusPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.FocusPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.FocusPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.FocusPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.FocusPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.FocusPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.FocusPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.FocusPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.FocusPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.FocusPolicy: ...

    class FocusReason:
        ActiveWindowFocusReason: typing.ClassVar[Qt.FocusReason] = ...
        BacktabFocusReason: typing.ClassVar[Qt.FocusReason] = ...
        MenuBarFocusReason: typing.ClassVar[Qt.FocusReason] = ...
        MouseFocusReason: typing.ClassVar[Qt.FocusReason] = ...
        NoFocusReason: typing.ClassVar[Qt.FocusReason] = ...
        OtherFocusReason: typing.ClassVar[Qt.FocusReason] = ...
        PopupFocusReason: typing.ClassVar[Qt.FocusReason] = ...
        ShortcutFocusReason: typing.ClassVar[Qt.FocusReason] = ...
        TabFocusReason: typing.ClassVar[Qt.FocusReason] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.FocusReason: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.FocusReason: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.FocusReason: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.FocusReason: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.FocusReason: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.FocusReason: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.FocusReason: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.FocusReason: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.FocusReason: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.FocusReason: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.FocusReason: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.FocusReason: ...

    class GestureFlag:
        DontStartGestureOnChildren: typing.ClassVar[Qt.GestureFlag] = ...
        IgnoredGesturesPropagateToParent: typing.ClassVar[Qt.GestureFlag] = ...
        ReceivePartialGestures: typing.ClassVar[Qt.GestureFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.GestureFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.GestureFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.GestureFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.GestureFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.GestureFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.GestureFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.GestureFlags: ...

    class GestureFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.GestureFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.GestureFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.GestureFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.GestureFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.GestureFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.GestureFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.GestureFlags: ...

    class GestureState:
        GestureCanceled: typing.ClassVar[Qt.GestureState] = ...
        GestureFinished: typing.ClassVar[Qt.GestureState] = ...
        GestureStarted: typing.ClassVar[Qt.GestureState] = ...
        GestureUpdated: typing.ClassVar[Qt.GestureState] = ...
        NoGesture: typing.ClassVar[Qt.GestureState] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.GestureState: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.GestureState: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.GestureState: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.GestureState: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.GestureState: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.GestureState: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.GestureState: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.GestureState: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.GestureState: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.GestureState: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.GestureState: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.GestureState: ...

    class GestureType:
        CustomGesture: typing.ClassVar[Qt.GestureType] = ...
        LastGestureType: typing.ClassVar[Qt.GestureType] = ...
        PanGesture: typing.ClassVar[Qt.GestureType] = ...
        PinchGesture: typing.ClassVar[Qt.GestureType] = ...
        SwipeGesture: typing.ClassVar[Qt.GestureType] = ...
        TapAndHoldGesture: typing.ClassVar[Qt.GestureType] = ...
        TapGesture: typing.ClassVar[Qt.GestureType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.GestureType: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.GestureType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.GestureType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.GestureType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.GestureType: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.GestureType: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.GestureType: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.GestureType: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.GestureType: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.GestureType: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.GestureType: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.GestureType: ...

    class GlobalColor:
        black: typing.ClassVar[Qt.GlobalColor] = ...
        blue: typing.ClassVar[Qt.GlobalColor] = ...
        color0: typing.ClassVar[Qt.GlobalColor] = ...
        color1: typing.ClassVar[Qt.GlobalColor] = ...
        cyan: typing.ClassVar[Qt.GlobalColor] = ...
        darkBlue: typing.ClassVar[Qt.GlobalColor] = ...
        darkCyan: typing.ClassVar[Qt.GlobalColor] = ...
        darkGray: typing.ClassVar[Qt.GlobalColor] = ...
        darkGreen: typing.ClassVar[Qt.GlobalColor] = ...
        darkMagenta: typing.ClassVar[Qt.GlobalColor] = ...
        darkRed: typing.ClassVar[Qt.GlobalColor] = ...
        darkYellow: typing.ClassVar[Qt.GlobalColor] = ...
        gray: typing.ClassVar[Qt.GlobalColor] = ...
        green: typing.ClassVar[Qt.GlobalColor] = ...
        lightGray: typing.ClassVar[Qt.GlobalColor] = ...
        magenta: typing.ClassVar[Qt.GlobalColor] = ...
        red: typing.ClassVar[Qt.GlobalColor] = ...
        transparent: typing.ClassVar[Qt.GlobalColor] = ...
        values: typing.ClassVar[dict] = ...
        white: typing.ClassVar[Qt.GlobalColor] = ...
        yellow: typing.ClassVar[Qt.GlobalColor] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.GlobalColor: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.GlobalColor: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.GlobalColor: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.GlobalColor: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.GlobalColor: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.GlobalColor: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.GlobalColor: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.GlobalColor: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.GlobalColor: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.GlobalColor: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.GlobalColor: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.GlobalColor: ...

    class HighDpiScaleFactorRoundingPolicy:
        Ceil: typing.ClassVar[Qt.HighDpiScaleFactorRoundingPolicy] = ...
        Floor: typing.ClassVar[Qt.HighDpiScaleFactorRoundingPolicy] = ...
        PassThrough: typing.ClassVar[Qt.HighDpiScaleFactorRoundingPolicy] = ...
        Round: typing.ClassVar[Qt.HighDpiScaleFactorRoundingPolicy] = ...
        RoundPreferFloor: typing.ClassVar[Qt.HighDpiScaleFactorRoundingPolicy] = ...
        Unset: typing.ClassVar[Qt.HighDpiScaleFactorRoundingPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.HighDpiScaleFactorRoundingPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.HighDpiScaleFactorRoundingPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.HighDpiScaleFactorRoundingPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.HighDpiScaleFactorRoundingPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.HighDpiScaleFactorRoundingPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.HighDpiScaleFactorRoundingPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.HighDpiScaleFactorRoundingPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.HighDpiScaleFactorRoundingPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.HighDpiScaleFactorRoundingPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.HighDpiScaleFactorRoundingPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.HighDpiScaleFactorRoundingPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.HighDpiScaleFactorRoundingPolicy: ...

    class HitTestAccuracy:
        ExactHit: typing.ClassVar[Qt.HitTestAccuracy] = ...
        FuzzyHit: typing.ClassVar[Qt.HitTestAccuracy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.HitTestAccuracy: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.HitTestAccuracy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.HitTestAccuracy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.HitTestAccuracy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.HitTestAccuracy: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.HitTestAccuracy: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.HitTestAccuracy: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.HitTestAccuracy: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.HitTestAccuracy: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.HitTestAccuracy: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.HitTestAccuracy: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.HitTestAccuracy: ...

    class ImageConversionFlag:
        AlphaDither_Mask: typing.ClassVar[Qt.ImageConversionFlag] = ...
        AutoColor: typing.ClassVar[Qt.ImageConversionFlag] = ...
        AutoDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
        AvoidDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
        ColorMode_Mask: typing.ClassVar[Qt.ImageConversionFlag] = ...
        ColorOnly: typing.ClassVar[Qt.ImageConversionFlag] = ...
        DiffuseAlphaDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
        DiffuseDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
        DitherMode_Mask: typing.ClassVar[Qt.ImageConversionFlag] = ...
        Dither_Mask: typing.ClassVar[Qt.ImageConversionFlag] = ...
        MonoOnly: typing.ClassVar[Qt.ImageConversionFlag] = ...
        NoAlpha: typing.ClassVar[Qt.ImageConversionFlag] = ...
        NoFormatConversion: typing.ClassVar[Qt.ImageConversionFlag] = ...
        NoOpaqueDetection: typing.ClassVar[Qt.ImageConversionFlag] = ...
        OrderedAlphaDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
        OrderedDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
        PreferDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
        ThresholdAlphaDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
        ThresholdDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ImageConversionFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.ImageConversionFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ImageConversionFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ImageConversionFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ImageConversionFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ImageConversionFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ImageConversionFlags: ...

    class ImageConversionFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ImageConversionFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.ImageConversionFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ImageConversionFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ImageConversionFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ImageConversionFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ImageConversionFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ImageConversionFlags: ...

    class InputMethodHint:
        ImhDate: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhDialableCharactersOnly: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhDigitsOnly: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhEmailCharactersOnly: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhExclusiveInputMask: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhFormattedNumbersOnly: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhHiddenText: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhLatinOnly: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhLowercaseOnly: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhMultiLine: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhNoAutoUppercase: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhNoEditMenu: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhNoPredictiveText: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhNoTextHandles: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhNone: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhPreferLatin: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhPreferLowercase: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhPreferNumbers: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhPreferUppercase: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhSensitiveData: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhTime: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhUppercaseOnly: typing.ClassVar[Qt.InputMethodHint] = ...
        ImhUrlCharactersOnly: typing.ClassVar[Qt.InputMethodHint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.InputMethodHints: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.InputMethodHints: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.InputMethodHints: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.InputMethodHints: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.InputMethodHints: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.InputMethodHints: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.InputMethodHints: ...

    class InputMethodHints:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.InputMethodHints: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.InputMethodHints: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.InputMethodHints: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.InputMethodHints: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.InputMethodHints: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.InputMethodHints: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.InputMethodHints: ...

    class InputMethodQueries:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.InputMethodQueries: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.InputMethodQueries: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.InputMethodQueries: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.InputMethodQueries: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.InputMethodQueries: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.InputMethodQueries: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.InputMethodQueries: ...

    class InputMethodQuery:
        ImAbsolutePosition: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImAnchorPosition: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImAnchorRectangle: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImCurrentSelection: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImCursorPosition: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImCursorRectangle: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImEnabled: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImEnterKeyType: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImFont: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImHints: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImInputItemClipRectangle: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImMaximumTextLength: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImMicroFocus: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImPlatformData: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImPreferredLanguage: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImQueryAll: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImQueryInput: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImSurroundingText: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImTextAfterCursor: typing.ClassVar[Qt.InputMethodQuery] = ...
        ImTextBeforeCursor: typing.ClassVar[Qt.InputMethodQuery] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.InputMethodQueries: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.InputMethodQueries: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.InputMethodQueries: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.InputMethodQueries: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.InputMethodQueries: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.InputMethodQueries: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.InputMethodQueries: ...

    class ItemDataRole:
        AccessibleDescriptionRole: typing.ClassVar[Qt.ItemDataRole] = ...
        AccessibleTextRole: typing.ClassVar[Qt.ItemDataRole] = ...
        BackgroundColorRole: typing.ClassVar[Qt.ItemDataRole] = ...
        BackgroundRole: typing.ClassVar[Qt.ItemDataRole] = ...
        CheckStateRole: typing.ClassVar[Qt.ItemDataRole] = ...
        DecorationPropertyRole: typing.ClassVar[Qt.ItemDataRole] = ...
        DecorationRole: typing.ClassVar[Qt.ItemDataRole] = ...
        DisplayPropertyRole: typing.ClassVar[Qt.ItemDataRole] = ...
        DisplayRole: typing.ClassVar[Qt.ItemDataRole] = ...
        EditRole: typing.ClassVar[Qt.ItemDataRole] = ...
        FontRole: typing.ClassVar[Qt.ItemDataRole] = ...
        ForegroundRole: typing.ClassVar[Qt.ItemDataRole] = ...
        InitialSortOrderRole: typing.ClassVar[Qt.ItemDataRole] = ...
        SizeHintRole: typing.ClassVar[Qt.ItemDataRole] = ...
        StatusTipPropertyRole: typing.ClassVar[Qt.ItemDataRole] = ...
        StatusTipRole: typing.ClassVar[Qt.ItemDataRole] = ...
        TextAlignmentRole: typing.ClassVar[Qt.ItemDataRole] = ...
        TextColorRole: typing.ClassVar[Qt.ItemDataRole] = ...
        ToolTipPropertyRole: typing.ClassVar[Qt.ItemDataRole] = ...
        ToolTipRole: typing.ClassVar[Qt.ItemDataRole] = ...
        UserRole: typing.ClassVar[Qt.ItemDataRole] = ...
        WhatsThisPropertyRole: typing.ClassVar[Qt.ItemDataRole] = ...
        WhatsThisRole: typing.ClassVar[Qt.ItemDataRole] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.ItemDataRole: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ItemDataRole: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.ItemDataRole: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ItemDataRole: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.ItemDataRole: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ItemDataRole: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.ItemDataRole: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ItemDataRole: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.ItemDataRole: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ItemDataRole: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.ItemDataRole: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ItemDataRole: ...

    class ItemFlag:
        ItemIsAutoTristate: typing.ClassVar[Qt.ItemFlag] = ...
        ItemIsDragEnabled: typing.ClassVar[Qt.ItemFlag] = ...
        ItemIsDropEnabled: typing.ClassVar[Qt.ItemFlag] = ...
        ItemIsEditable: typing.ClassVar[Qt.ItemFlag] = ...
        ItemIsEnabled: typing.ClassVar[Qt.ItemFlag] = ...
        ItemIsSelectable: typing.ClassVar[Qt.ItemFlag] = ...
        ItemIsTristate: typing.ClassVar[Qt.ItemFlag] = ...
        ItemIsUserCheckable: typing.ClassVar[Qt.ItemFlag] = ...
        ItemIsUserTristate: typing.ClassVar[Qt.ItemFlag] = ...
        ItemNeverHasChildren: typing.ClassVar[Qt.ItemFlag] = ...
        NoItemFlags: typing.ClassVar[Qt.ItemFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ItemFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.ItemFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ItemFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ItemFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ItemFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ItemFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ItemFlags: ...

    class ItemFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ItemFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.ItemFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ItemFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ItemFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ItemFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ItemFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ItemFlags: ...

    class ItemSelectionMode:
        ContainsItemBoundingRect: typing.ClassVar[Qt.ItemSelectionMode] = ...
        ContainsItemShape: typing.ClassVar[Qt.ItemSelectionMode] = ...
        IntersectsItemBoundingRect: typing.ClassVar[Qt.ItemSelectionMode] = ...
        IntersectsItemShape: typing.ClassVar[Qt.ItemSelectionMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.ItemSelectionMode: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ItemSelectionMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.ItemSelectionMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ItemSelectionMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.ItemSelectionMode: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ItemSelectionMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.ItemSelectionMode: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ItemSelectionMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.ItemSelectionMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ItemSelectionMode: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.ItemSelectionMode: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ItemSelectionMode: ...

    class ItemSelectionOperation:
        AddToSelection: typing.ClassVar[Qt.ItemSelectionOperation] = ...
        ReplaceSelection: typing.ClassVar[Qt.ItemSelectionOperation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.ItemSelectionOperation: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ItemSelectionOperation: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.ItemSelectionOperation: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ItemSelectionOperation: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.ItemSelectionOperation: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ItemSelectionOperation: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.ItemSelectionOperation: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ItemSelectionOperation: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.ItemSelectionOperation: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ItemSelectionOperation: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.ItemSelectionOperation: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ItemSelectionOperation: ...

    class Key:
        Key_0: typing.ClassVar[Qt.Key] = ...
        Key_1: typing.ClassVar[Qt.Key] = ...
        Key_2: typing.ClassVar[Qt.Key] = ...
        Key_3: typing.ClassVar[Qt.Key] = ...
        Key_4: typing.ClassVar[Qt.Key] = ...
        Key_5: typing.ClassVar[Qt.Key] = ...
        Key_6: typing.ClassVar[Qt.Key] = ...
        Key_7: typing.ClassVar[Qt.Key] = ...
        Key_8: typing.ClassVar[Qt.Key] = ...
        Key_9: typing.ClassVar[Qt.Key] = ...
        Key_A: typing.ClassVar[Qt.Key] = ...
        Key_AE: typing.ClassVar[Qt.Key] = ...
        Key_Aacute: typing.ClassVar[Qt.Key] = ...
        Key_Acircumflex: typing.ClassVar[Qt.Key] = ...
        Key_AddFavorite: typing.ClassVar[Qt.Key] = ...
        Key_Adiaeresis: typing.ClassVar[Qt.Key] = ...
        Key_Agrave: typing.ClassVar[Qt.Key] = ...
        Key_Alt: typing.ClassVar[Qt.Key] = ...
        Key_AltGr: typing.ClassVar[Qt.Key] = ...
        Key_Ampersand: typing.ClassVar[Qt.Key] = ...
        Key_Any: typing.ClassVar[Qt.Key] = ...
        Key_Apostrophe: typing.ClassVar[Qt.Key] = ...
        Key_ApplicationLeft: typing.ClassVar[Qt.Key] = ...
        Key_ApplicationRight: typing.ClassVar[Qt.Key] = ...
        Key_Aring: typing.ClassVar[Qt.Key] = ...
        Key_AsciiCircum: typing.ClassVar[Qt.Key] = ...
        Key_AsciiTilde: typing.ClassVar[Qt.Key] = ...
        Key_Asterisk: typing.ClassVar[Qt.Key] = ...
        Key_At: typing.ClassVar[Qt.Key] = ...
        Key_Atilde: typing.ClassVar[Qt.Key] = ...
        Key_AudioCycleTrack: typing.ClassVar[Qt.Key] = ...
        Key_AudioForward: typing.ClassVar[Qt.Key] = ...
        Key_AudioRandomPlay: typing.ClassVar[Qt.Key] = ...
        Key_AudioRepeat: typing.ClassVar[Qt.Key] = ...
        Key_AudioRewind: typing.ClassVar[Qt.Key] = ...
        Key_Away: typing.ClassVar[Qt.Key] = ...
        Key_B: typing.ClassVar[Qt.Key] = ...
        Key_Back: typing.ClassVar[Qt.Key] = ...
        Key_BackForward: typing.ClassVar[Qt.Key] = ...
        Key_Backslash: typing.ClassVar[Qt.Key] = ...
        Key_Backspace: typing.ClassVar[Qt.Key] = ...
        Key_Backtab: typing.ClassVar[Qt.Key] = ...
        Key_Bar: typing.ClassVar[Qt.Key] = ...
        Key_BassBoost: typing.ClassVar[Qt.Key] = ...
        Key_BassDown: typing.ClassVar[Qt.Key] = ...
        Key_BassUp: typing.ClassVar[Qt.Key] = ...
        Key_Battery: typing.ClassVar[Qt.Key] = ...
        Key_Blue: typing.ClassVar[Qt.Key] = ...
        Key_Bluetooth: typing.ClassVar[Qt.Key] = ...
        Key_Book: typing.ClassVar[Qt.Key] = ...
        Key_BraceLeft: typing.ClassVar[Qt.Key] = ...
        Key_BraceRight: typing.ClassVar[Qt.Key] = ...
        Key_BracketLeft: typing.ClassVar[Qt.Key] = ...
        Key_BracketRight: typing.ClassVar[Qt.Key] = ...
        Key_BrightnessAdjust: typing.ClassVar[Qt.Key] = ...
        Key_C: typing.ClassVar[Qt.Key] = ...
        Key_CD: typing.ClassVar[Qt.Key] = ...
        Key_Calculator: typing.ClassVar[Qt.Key] = ...
        Key_Calendar: typing.ClassVar[Qt.Key] = ...
        Key_Call: typing.ClassVar[Qt.Key] = ...
        Key_Camera: typing.ClassVar[Qt.Key] = ...
        Key_CameraFocus: typing.ClassVar[Qt.Key] = ...
        Key_Cancel: typing.ClassVar[Qt.Key] = ...
        Key_CapsLock: typing.ClassVar[Qt.Key] = ...
        Key_Ccedilla: typing.ClassVar[Qt.Key] = ...
        Key_ChannelDown: typing.ClassVar[Qt.Key] = ...
        Key_ChannelUp: typing.ClassVar[Qt.Key] = ...
        Key_Clear: typing.ClassVar[Qt.Key] = ...
        Key_ClearGrab: typing.ClassVar[Qt.Key] = ...
        Key_Close: typing.ClassVar[Qt.Key] = ...
        Key_Codeinput: typing.ClassVar[Qt.Key] = ...
        Key_Colon: typing.ClassVar[Qt.Key] = ...
        Key_Comma: typing.ClassVar[Qt.Key] = ...
        Key_Community: typing.ClassVar[Qt.Key] = ...
        Key_Context1: typing.ClassVar[Qt.Key] = ...
        Key_Context2: typing.ClassVar[Qt.Key] = ...
        Key_Context3: typing.ClassVar[Qt.Key] = ...
        Key_Context4: typing.ClassVar[Qt.Key] = ...
        Key_ContrastAdjust: typing.ClassVar[Qt.Key] = ...
        Key_Control: typing.ClassVar[Qt.Key] = ...
        Key_Copy: typing.ClassVar[Qt.Key] = ...
        Key_Cut: typing.ClassVar[Qt.Key] = ...
        Key_D: typing.ClassVar[Qt.Key] = ...
        Key_DOS: typing.ClassVar[Qt.Key] = ...
        Key_Dead_A: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Abovecomma: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Abovedot: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Abovereversedcomma: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Abovering: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Aboveverticalline: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Acute: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Belowbreve: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Belowcircumflex: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Belowcomma: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Belowdiaeresis: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Belowdot: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Belowmacron: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Belowring: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Belowtilde: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Belowverticalline: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Breve: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Capital_Schwa: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Caron: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Cedilla: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Circumflex: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Currency: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Diaeresis: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Doubleacute: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Doublegrave: typing.ClassVar[Qt.Key] = ...
        Key_Dead_E: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Grave: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Greek: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Hook: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Horn: typing.ClassVar[Qt.Key] = ...
        Key_Dead_I: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Invertedbreve: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Iota: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Longsolidusoverlay: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Lowline: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Macron: typing.ClassVar[Qt.Key] = ...
        Key_Dead_O: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Ogonek: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Semivoiced_Sound: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Small_Schwa: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Stroke: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Tilde: typing.ClassVar[Qt.Key] = ...
        Key_Dead_U: typing.ClassVar[Qt.Key] = ...
        Key_Dead_Voiced_Sound: typing.ClassVar[Qt.Key] = ...
        Key_Dead_a: typing.ClassVar[Qt.Key] = ...
        Key_Dead_e: typing.ClassVar[Qt.Key] = ...
        Key_Dead_i: typing.ClassVar[Qt.Key] = ...
        Key_Dead_o: typing.ClassVar[Qt.Key] = ...
        Key_Dead_u: typing.ClassVar[Qt.Key] = ...
        Key_Delete: typing.ClassVar[Qt.Key] = ...
        Key_Direction_L: typing.ClassVar[Qt.Key] = ...
        Key_Direction_R: typing.ClassVar[Qt.Key] = ...
        Key_Display: typing.ClassVar[Qt.Key] = ...
        Key_Documents: typing.ClassVar[Qt.Key] = ...
        Key_Dollar: typing.ClassVar[Qt.Key] = ...
        Key_Down: typing.ClassVar[Qt.Key] = ...
        Key_E: typing.ClassVar[Qt.Key] = ...
        Key_ETH: typing.ClassVar[Qt.Key] = ...
        Key_Eacute: typing.ClassVar[Qt.Key] = ...
        Key_Ecircumflex: typing.ClassVar[Qt.Key] = ...
        Key_Ediaeresis: typing.ClassVar[Qt.Key] = ...
        Key_Egrave: typing.ClassVar[Qt.Key] = ...
        Key_Eisu_Shift: typing.ClassVar[Qt.Key] = ...
        Key_Eisu_toggle: typing.ClassVar[Qt.Key] = ...
        Key_Eject: typing.ClassVar[Qt.Key] = ...
        Key_End: typing.ClassVar[Qt.Key] = ...
        Key_Enter: typing.ClassVar[Qt.Key] = ...
        Key_Equal: typing.ClassVar[Qt.Key] = ...
        Key_Escape: typing.ClassVar[Qt.Key] = ...
        Key_Excel: typing.ClassVar[Qt.Key] = ...
        Key_Exclam: typing.ClassVar[Qt.Key] = ...
        Key_Execute: typing.ClassVar[Qt.Key] = ...
        Key_Exit: typing.ClassVar[Qt.Key] = ...
        Key_Explorer: typing.ClassVar[Qt.Key] = ...
        Key_F: typing.ClassVar[Qt.Key] = ...
        Key_F1: typing.ClassVar[Qt.Key] = ...
        Key_F10: typing.ClassVar[Qt.Key] = ...
        Key_F11: typing.ClassVar[Qt.Key] = ...
        Key_F12: typing.ClassVar[Qt.Key] = ...
        Key_F13: typing.ClassVar[Qt.Key] = ...
        Key_F14: typing.ClassVar[Qt.Key] = ...
        Key_F15: typing.ClassVar[Qt.Key] = ...
        Key_F16: typing.ClassVar[Qt.Key] = ...
        Key_F17: typing.ClassVar[Qt.Key] = ...
        Key_F18: typing.ClassVar[Qt.Key] = ...
        Key_F19: typing.ClassVar[Qt.Key] = ...
        Key_F2: typing.ClassVar[Qt.Key] = ...
        Key_F20: typing.ClassVar[Qt.Key] = ...
        Key_F21: typing.ClassVar[Qt.Key] = ...
        Key_F22: typing.ClassVar[Qt.Key] = ...
        Key_F23: typing.ClassVar[Qt.Key] = ...
        Key_F24: typing.ClassVar[Qt.Key] = ...
        Key_F25: typing.ClassVar[Qt.Key] = ...
        Key_F26: typing.ClassVar[Qt.Key] = ...
        Key_F27: typing.ClassVar[Qt.Key] = ...
        Key_F28: typing.ClassVar[Qt.Key] = ...
        Key_F29: typing.ClassVar[Qt.Key] = ...
        Key_F3: typing.ClassVar[Qt.Key] = ...
        Key_F30: typing.ClassVar[Qt.Key] = ...
        Key_F31: typing.ClassVar[Qt.Key] = ...
        Key_F32: typing.ClassVar[Qt.Key] = ...
        Key_F33: typing.ClassVar[Qt.Key] = ...
        Key_F34: typing.ClassVar[Qt.Key] = ...
        Key_F35: typing.ClassVar[Qt.Key] = ...
        Key_F4: typing.ClassVar[Qt.Key] = ...
        Key_F5: typing.ClassVar[Qt.Key] = ...
        Key_F6: typing.ClassVar[Qt.Key] = ...
        Key_F7: typing.ClassVar[Qt.Key] = ...
        Key_F8: typing.ClassVar[Qt.Key] = ...
        Key_F9: typing.ClassVar[Qt.Key] = ...
        Key_Favorites: typing.ClassVar[Qt.Key] = ...
        Key_Finance: typing.ClassVar[Qt.Key] = ...
        Key_Find: typing.ClassVar[Qt.Key] = ...
        Key_Flip: typing.ClassVar[Qt.Key] = ...
        Key_Forward: typing.ClassVar[Qt.Key] = ...
        Key_G: typing.ClassVar[Qt.Key] = ...
        Key_Game: typing.ClassVar[Qt.Key] = ...
        Key_Go: typing.ClassVar[Qt.Key] = ...
        Key_Greater: typing.ClassVar[Qt.Key] = ...
        Key_Green: typing.ClassVar[Qt.Key] = ...
        Key_Guide: typing.ClassVar[Qt.Key] = ...
        Key_H: typing.ClassVar[Qt.Key] = ...
        Key_Hangul: typing.ClassVar[Qt.Key] = ...
        Key_Hangul_Banja: typing.ClassVar[Qt.Key] = ...
        Key_Hangul_End: typing.ClassVar[Qt.Key] = ...
        Key_Hangul_Hanja: typing.ClassVar[Qt.Key] = ...
        Key_Hangul_Jamo: typing.ClassVar[Qt.Key] = ...
        Key_Hangul_Jeonja: typing.ClassVar[Qt.Key] = ...
        Key_Hangul_PostHanja: typing.ClassVar[Qt.Key] = ...
        Key_Hangul_PreHanja: typing.ClassVar[Qt.Key] = ...
        Key_Hangul_Romaja: typing.ClassVar[Qt.Key] = ...
        Key_Hangul_Special: typing.ClassVar[Qt.Key] = ...
        Key_Hangul_Start: typing.ClassVar[Qt.Key] = ...
        Key_Hangup: typing.ClassVar[Qt.Key] = ...
        Key_Hankaku: typing.ClassVar[Qt.Key] = ...
        Key_Help: typing.ClassVar[Qt.Key] = ...
        Key_Henkan: typing.ClassVar[Qt.Key] = ...
        Key_Hibernate: typing.ClassVar[Qt.Key] = ...
        Key_Hiragana: typing.ClassVar[Qt.Key] = ...
        Key_Hiragana_Katakana: typing.ClassVar[Qt.Key] = ...
        Key_History: typing.ClassVar[Qt.Key] = ...
        Key_Home: typing.ClassVar[Qt.Key] = ...
        Key_HomePage: typing.ClassVar[Qt.Key] = ...
        Key_HotLinks: typing.ClassVar[Qt.Key] = ...
        Key_Hyper_L: typing.ClassVar[Qt.Key] = ...
        Key_Hyper_R: typing.ClassVar[Qt.Key] = ...
        Key_I: typing.ClassVar[Qt.Key] = ...
        Key_Iacute: typing.ClassVar[Qt.Key] = ...
        Key_Icircumflex: typing.ClassVar[Qt.Key] = ...
        Key_Idiaeresis: typing.ClassVar[Qt.Key] = ...
        Key_Igrave: typing.ClassVar[Qt.Key] = ...
        Key_Info: typing.ClassVar[Qt.Key] = ...
        Key_Insert: typing.ClassVar[Qt.Key] = ...
        Key_J: typing.ClassVar[Qt.Key] = ...
        Key_K: typing.ClassVar[Qt.Key] = ...
        Key_Kana_Lock: typing.ClassVar[Qt.Key] = ...
        Key_Kana_Shift: typing.ClassVar[Qt.Key] = ...
        Key_Kanji: typing.ClassVar[Qt.Key] = ...
        Key_Katakana: typing.ClassVar[Qt.Key] = ...
        Key_KeyboardBrightnessDown: typing.ClassVar[Qt.Key] = ...
        Key_KeyboardBrightnessUp: typing.ClassVar[Qt.Key] = ...
        Key_KeyboardLightOnOff: typing.ClassVar[Qt.Key] = ...
        Key_L: typing.ClassVar[Qt.Key] = ...
        Key_LastNumberRedial: typing.ClassVar[Qt.Key] = ...
        Key_Launch0: typing.ClassVar[Qt.Key] = ...
        Key_Launch1: typing.ClassVar[Qt.Key] = ...
        Key_Launch2: typing.ClassVar[Qt.Key] = ...
        Key_Launch3: typing.ClassVar[Qt.Key] = ...
        Key_Launch4: typing.ClassVar[Qt.Key] = ...
        Key_Launch5: typing.ClassVar[Qt.Key] = ...
        Key_Launch6: typing.ClassVar[Qt.Key] = ...
        Key_Launch7: typing.ClassVar[Qt.Key] = ...
        Key_Launch8: typing.ClassVar[Qt.Key] = ...
        Key_Launch9: typing.ClassVar[Qt.Key] = ...
        Key_LaunchA: typing.ClassVar[Qt.Key] = ...
        Key_LaunchB: typing.ClassVar[Qt.Key] = ...
        Key_LaunchC: typing.ClassVar[Qt.Key] = ...
        Key_LaunchD: typing.ClassVar[Qt.Key] = ...
        Key_LaunchE: typing.ClassVar[Qt.Key] = ...
        Key_LaunchF: typing.ClassVar[Qt.Key] = ...
        Key_LaunchG: typing.ClassVar[Qt.Key] = ...
        Key_LaunchH: typing.ClassVar[Qt.Key] = ...
        Key_LaunchMail: typing.ClassVar[Qt.Key] = ...
        Key_LaunchMedia: typing.ClassVar[Qt.Key] = ...
        Key_Left: typing.ClassVar[Qt.Key] = ...
        Key_Less: typing.ClassVar[Qt.Key] = ...
        Key_LightBulb: typing.ClassVar[Qt.Key] = ...
        Key_LogOff: typing.ClassVar[Qt.Key] = ...
        Key_M: typing.ClassVar[Qt.Key] = ...
        Key_MailForward: typing.ClassVar[Qt.Key] = ...
        Key_Market: typing.ClassVar[Qt.Key] = ...
        Key_Massyo: typing.ClassVar[Qt.Key] = ...
        Key_MediaLast: typing.ClassVar[Qt.Key] = ...
        Key_MediaNext: typing.ClassVar[Qt.Key] = ...
        Key_MediaPause: typing.ClassVar[Qt.Key] = ...
        Key_MediaPlay: typing.ClassVar[Qt.Key] = ...
        Key_MediaPrevious: typing.ClassVar[Qt.Key] = ...
        Key_MediaRecord: typing.ClassVar[Qt.Key] = ...
        Key_MediaStop: typing.ClassVar[Qt.Key] = ...
        Key_MediaTogglePlayPause: typing.ClassVar[Qt.Key] = ...
        Key_Meeting: typing.ClassVar[Qt.Key] = ...
        Key_Memo: typing.ClassVar[Qt.Key] = ...
        Key_Menu: typing.ClassVar[Qt.Key] = ...
        Key_MenuKB: typing.ClassVar[Qt.Key] = ...
        Key_MenuPB: typing.ClassVar[Qt.Key] = ...
        Key_Messenger: typing.ClassVar[Qt.Key] = ...
        Key_Meta: typing.ClassVar[Qt.Key] = ...
        Key_MicMute: typing.ClassVar[Qt.Key] = ...
        Key_MicVolumeDown: typing.ClassVar[Qt.Key] = ...
        Key_MicVolumeUp: typing.ClassVar[Qt.Key] = ...
        Key_Minus: typing.ClassVar[Qt.Key] = ...
        Key_Mode_switch: typing.ClassVar[Qt.Key] = ...
        Key_MonBrightnessDown: typing.ClassVar[Qt.Key] = ...
        Key_MonBrightnessUp: typing.ClassVar[Qt.Key] = ...
        Key_Muhenkan: typing.ClassVar[Qt.Key] = ...
        Key_Multi_key: typing.ClassVar[Qt.Key] = ...
        Key_MultipleCandidate: typing.ClassVar[Qt.Key] = ...
        Key_Music: typing.ClassVar[Qt.Key] = ...
        Key_MySites: typing.ClassVar[Qt.Key] = ...
        Key_N: typing.ClassVar[Qt.Key] = ...
        Key_New: typing.ClassVar[Qt.Key] = ...
        Key_News: typing.ClassVar[Qt.Key] = ...
        Key_No: typing.ClassVar[Qt.Key] = ...
        Key_Ntilde: typing.ClassVar[Qt.Key] = ...
        Key_NumLock: typing.ClassVar[Qt.Key] = ...
        Key_NumberSign: typing.ClassVar[Qt.Key] = ...
        Key_O: typing.ClassVar[Qt.Key] = ...
        Key_Oacute: typing.ClassVar[Qt.Key] = ...
        Key_Ocircumflex: typing.ClassVar[Qt.Key] = ...
        Key_Odiaeresis: typing.ClassVar[Qt.Key] = ...
        Key_OfficeHome: typing.ClassVar[Qt.Key] = ...
        Key_Ograve: typing.ClassVar[Qt.Key] = ...
        Key_Ooblique: typing.ClassVar[Qt.Key] = ...
        Key_Open: typing.ClassVar[Qt.Key] = ...
        Key_OpenUrl: typing.ClassVar[Qt.Key] = ...
        Key_Option: typing.ClassVar[Qt.Key] = ...
        Key_Otilde: typing.ClassVar[Qt.Key] = ...
        Key_P: typing.ClassVar[Qt.Key] = ...
        Key_PageDown: typing.ClassVar[Qt.Key] = ...
        Key_PageUp: typing.ClassVar[Qt.Key] = ...
        Key_ParenLeft: typing.ClassVar[Qt.Key] = ...
        Key_ParenRight: typing.ClassVar[Qt.Key] = ...
        Key_Paste: typing.ClassVar[Qt.Key] = ...
        Key_Pause: typing.ClassVar[Qt.Key] = ...
        Key_Percent: typing.ClassVar[Qt.Key] = ...
        Key_Period: typing.ClassVar[Qt.Key] = ...
        Key_Phone: typing.ClassVar[Qt.Key] = ...
        Key_Pictures: typing.ClassVar[Qt.Key] = ...
        Key_Play: typing.ClassVar[Qt.Key] = ...
        Key_Plus: typing.ClassVar[Qt.Key] = ...
        Key_PowerDown: typing.ClassVar[Qt.Key] = ...
        Key_PowerOff: typing.ClassVar[Qt.Key] = ...
        Key_PreviousCandidate: typing.ClassVar[Qt.Key] = ...
        Key_Print: typing.ClassVar[Qt.Key] = ...
        Key_Printer: typing.ClassVar[Qt.Key] = ...
        Key_Q: typing.ClassVar[Qt.Key] = ...
        Key_Question: typing.ClassVar[Qt.Key] = ...
        Key_QuoteDbl: typing.ClassVar[Qt.Key] = ...
        Key_QuoteLeft: typing.ClassVar[Qt.Key] = ...
        Key_R: typing.ClassVar[Qt.Key] = ...
        Key_Red: typing.ClassVar[Qt.Key] = ...
        Key_Redo: typing.ClassVar[Qt.Key] = ...
        Key_Refresh: typing.ClassVar[Qt.Key] = ...
        Key_Reload: typing.ClassVar[Qt.Key] = ...
        Key_Reply: typing.ClassVar[Qt.Key] = ...
        Key_Return: typing.ClassVar[Qt.Key] = ...
        Key_Right: typing.ClassVar[Qt.Key] = ...
        Key_Romaji: typing.ClassVar[Qt.Key] = ...
        Key_RotateWindows: typing.ClassVar[Qt.Key] = ...
        Key_RotationKB: typing.ClassVar[Qt.Key] = ...
        Key_RotationPB: typing.ClassVar[Qt.Key] = ...
        Key_S: typing.ClassVar[Qt.Key] = ...
        Key_Save: typing.ClassVar[Qt.Key] = ...
        Key_ScreenSaver: typing.ClassVar[Qt.Key] = ...
        Key_ScrollLock: typing.ClassVar[Qt.Key] = ...
        Key_Search: typing.ClassVar[Qt.Key] = ...
        Key_Select: typing.ClassVar[Qt.Key] = ...
        Key_Semicolon: typing.ClassVar[Qt.Key] = ...
        Key_Send: typing.ClassVar[Qt.Key] = ...
        Key_Settings: typing.ClassVar[Qt.Key] = ...
        Key_Shift: typing.ClassVar[Qt.Key] = ...
        Key_Shop: typing.ClassVar[Qt.Key] = ...
        Key_SingleCandidate: typing.ClassVar[Qt.Key] = ...
        Key_Slash: typing.ClassVar[Qt.Key] = ...
        Key_Sleep: typing.ClassVar[Qt.Key] = ...
        Key_Space: typing.ClassVar[Qt.Key] = ...
        Key_Spell: typing.ClassVar[Qt.Key] = ...
        Key_SplitScreen: typing.ClassVar[Qt.Key] = ...
        Key_Standby: typing.ClassVar[Qt.Key] = ...
        Key_Stop: typing.ClassVar[Qt.Key] = ...
        Key_Subtitle: typing.ClassVar[Qt.Key] = ...
        Key_Super_L: typing.ClassVar[Qt.Key] = ...
        Key_Super_R: typing.ClassVar[Qt.Key] = ...
        Key_Support: typing.ClassVar[Qt.Key] = ...
        Key_Suspend: typing.ClassVar[Qt.Key] = ...
        Key_SysReq: typing.ClassVar[Qt.Key] = ...
        Key_T: typing.ClassVar[Qt.Key] = ...
        Key_THORN: typing.ClassVar[Qt.Key] = ...
        Key_Tab: typing.ClassVar[Qt.Key] = ...
        Key_TaskPane: typing.ClassVar[Qt.Key] = ...
        Key_Terminal: typing.ClassVar[Qt.Key] = ...
        Key_Time: typing.ClassVar[Qt.Key] = ...
        Key_ToDoList: typing.ClassVar[Qt.Key] = ...
        Key_ToggleCallHangup: typing.ClassVar[Qt.Key] = ...
        Key_Tools: typing.ClassVar[Qt.Key] = ...
        Key_TopMenu: typing.ClassVar[Qt.Key] = ...
        Key_TouchpadOff: typing.ClassVar[Qt.Key] = ...
        Key_TouchpadOn: typing.ClassVar[Qt.Key] = ...
        Key_TouchpadToggle: typing.ClassVar[Qt.Key] = ...
        Key_Touroku: typing.ClassVar[Qt.Key] = ...
        Key_Travel: typing.ClassVar[Qt.Key] = ...
        Key_TrebleDown: typing.ClassVar[Qt.Key] = ...
        Key_TrebleUp: typing.ClassVar[Qt.Key] = ...
        Key_U: typing.ClassVar[Qt.Key] = ...
        Key_UWB: typing.ClassVar[Qt.Key] = ...
        Key_Uacute: typing.ClassVar[Qt.Key] = ...
        Key_Ucircumflex: typing.ClassVar[Qt.Key] = ...
        Key_Udiaeresis: typing.ClassVar[Qt.Key] = ...
        Key_Ugrave: typing.ClassVar[Qt.Key] = ...
        Key_Underscore: typing.ClassVar[Qt.Key] = ...
        Key_Undo: typing.ClassVar[Qt.Key] = ...
        Key_Up: typing.ClassVar[Qt.Key] = ...
        Key_V: typing.ClassVar[Qt.Key] = ...
        Key_Video: typing.ClassVar[Qt.Key] = ...
        Key_View: typing.ClassVar[Qt.Key] = ...
        Key_VoiceDial: typing.ClassVar[Qt.Key] = ...
        Key_VolumeDown: typing.ClassVar[Qt.Key] = ...
        Key_VolumeMute: typing.ClassVar[Qt.Key] = ...
        Key_VolumeUp: typing.ClassVar[Qt.Key] = ...
        Key_W: typing.ClassVar[Qt.Key] = ...
        Key_WLAN: typing.ClassVar[Qt.Key] = ...
        Key_WWW: typing.ClassVar[Qt.Key] = ...
        Key_WakeUp: typing.ClassVar[Qt.Key] = ...
        Key_WebCam: typing.ClassVar[Qt.Key] = ...
        Key_Word: typing.ClassVar[Qt.Key] = ...
        Key_X: typing.ClassVar[Qt.Key] = ...
        Key_Xfer: typing.ClassVar[Qt.Key] = ...
        Key_Y: typing.ClassVar[Qt.Key] = ...
        Key_Yacute: typing.ClassVar[Qt.Key] = ...
        Key_Yellow: typing.ClassVar[Qt.Key] = ...
        Key_Yes: typing.ClassVar[Qt.Key] = ...
        Key_Z: typing.ClassVar[Qt.Key] = ...
        Key_Zenkaku: typing.ClassVar[Qt.Key] = ...
        Key_Zenkaku_Hankaku: typing.ClassVar[Qt.Key] = ...
        Key_Zoom: typing.ClassVar[Qt.Key] = ...
        Key_ZoomIn: typing.ClassVar[Qt.Key] = ...
        Key_ZoomOut: typing.ClassVar[Qt.Key] = ...
        Key_acute: typing.ClassVar[Qt.Key] = ...
        Key_brokenbar: typing.ClassVar[Qt.Key] = ...
        Key_cedilla: typing.ClassVar[Qt.Key] = ...
        Key_cent: typing.ClassVar[Qt.Key] = ...
        Key_copyright: typing.ClassVar[Qt.Key] = ...
        Key_currency: typing.ClassVar[Qt.Key] = ...
        Key_degree: typing.ClassVar[Qt.Key] = ...
        Key_diaeresis: typing.ClassVar[Qt.Key] = ...
        Key_division: typing.ClassVar[Qt.Key] = ...
        Key_exclamdown: typing.ClassVar[Qt.Key] = ...
        Key_guillemotleft: typing.ClassVar[Qt.Key] = ...
        Key_guillemotright: typing.ClassVar[Qt.Key] = ...
        Key_hyphen: typing.ClassVar[Qt.Key] = ...
        Key_iTouch: typing.ClassVar[Qt.Key] = ...
        Key_macron: typing.ClassVar[Qt.Key] = ...
        Key_masculine: typing.ClassVar[Qt.Key] = ...
        Key_mu: typing.ClassVar[Qt.Key] = ...
        Key_multiply: typing.ClassVar[Qt.Key] = ...
        Key_nobreakspace: typing.ClassVar[Qt.Key] = ...
        Key_notsign: typing.ClassVar[Qt.Key] = ...
        Key_onehalf: typing.ClassVar[Qt.Key] = ...
        Key_onequarter: typing.ClassVar[Qt.Key] = ...
        Key_onesuperior: typing.ClassVar[Qt.Key] = ...
        Key_ordfeminine: typing.ClassVar[Qt.Key] = ...
        Key_paragraph: typing.ClassVar[Qt.Key] = ...
        Key_periodcentered: typing.ClassVar[Qt.Key] = ...
        Key_plusminus: typing.ClassVar[Qt.Key] = ...
        Key_questiondown: typing.ClassVar[Qt.Key] = ...
        Key_registered: typing.ClassVar[Qt.Key] = ...
        Key_section: typing.ClassVar[Qt.Key] = ...
        Key_ssharp: typing.ClassVar[Qt.Key] = ...
        Key_sterling: typing.ClassVar[Qt.Key] = ...
        Key_threequarters: typing.ClassVar[Qt.Key] = ...
        Key_threesuperior: typing.ClassVar[Qt.Key] = ...
        Key_twosuperior: typing.ClassVar[Qt.Key] = ...
        Key_unknown: typing.ClassVar[Qt.Key] = ...
        Key_ydiaeresis: typing.ClassVar[Qt.Key] = ...
        Key_yen: typing.ClassVar[Qt.Key] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.Key: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.Key: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.Key: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.Key: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.Key: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.Key: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.Key: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.Key: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.Key: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.Key: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.Key: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.Key: ...

    class KeyboardModifier:
        AltModifier: typing.ClassVar[Qt.KeyboardModifier] = ...
        ControlModifier: typing.ClassVar[Qt.KeyboardModifier] = ...
        GroupSwitchModifier: typing.ClassVar[Qt.KeyboardModifier] = ...
        KeyboardModifierMask: typing.ClassVar[Qt.KeyboardModifier] = ...
        KeypadModifier: typing.ClassVar[Qt.KeyboardModifier] = ...
        MetaModifier: typing.ClassVar[Qt.KeyboardModifier] = ...
        NoModifier: typing.ClassVar[Qt.KeyboardModifier] = ...
        ShiftModifier: typing.ClassVar[Qt.KeyboardModifier] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.KeyboardModifiers: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.KeyboardModifiers: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.KeyboardModifiers: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.KeyboardModifiers: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.KeyboardModifiers: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.KeyboardModifiers: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.KeyboardModifiers: ...

    class KeyboardModifiers:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.KeyboardModifiers: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.KeyboardModifiers: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.KeyboardModifiers: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.KeyboardModifiers: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.KeyboardModifiers: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.KeyboardModifiers: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.KeyboardModifiers: ...

    class LayoutDirection:
        LayoutDirectionAuto: typing.ClassVar[Qt.LayoutDirection] = ...
        LeftToRight: typing.ClassVar[Qt.LayoutDirection] = ...
        RightToLeft: typing.ClassVar[Qt.LayoutDirection] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.LayoutDirection: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.LayoutDirection: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.LayoutDirection: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.LayoutDirection: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.LayoutDirection: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.LayoutDirection: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.LayoutDirection: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.LayoutDirection: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.LayoutDirection: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.LayoutDirection: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.LayoutDirection: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.LayoutDirection: ...

    class MaskMode:
        MaskInColor: typing.ClassVar[Qt.MaskMode] = ...
        MaskOutColor: typing.ClassVar[Qt.MaskMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.MaskMode: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.MaskMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.MaskMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.MaskMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.MaskMode: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.MaskMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.MaskMode: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.MaskMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.MaskMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.MaskMode: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.MaskMode: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.MaskMode: ...

    class MatchFlag:
        MatchCaseSensitive: typing.ClassVar[Qt.MatchFlag] = ...
        MatchContains: typing.ClassVar[Qt.MatchFlag] = ...
        MatchEndsWith: typing.ClassVar[Qt.MatchFlag] = ...
        MatchExactly: typing.ClassVar[Qt.MatchFlag] = ...
        MatchFixedString: typing.ClassVar[Qt.MatchFlag] = ...
        MatchRecursive: typing.ClassVar[Qt.MatchFlag] = ...
        MatchRegExp: typing.ClassVar[Qt.MatchFlag] = ...
        MatchRegularExpression: typing.ClassVar[Qt.MatchFlag] = ...
        MatchStartsWith: typing.ClassVar[Qt.MatchFlag] = ...
        MatchWildcard: typing.ClassVar[Qt.MatchFlag] = ...
        MatchWrap: typing.ClassVar[Qt.MatchFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.MatchFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.MatchFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.MatchFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.MatchFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.MatchFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.MatchFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.MatchFlags: ...

    class MatchFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.MatchFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.MatchFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.MatchFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.MatchFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.MatchFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.MatchFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.MatchFlags: ...

    class Modifier:
        ALT: typing.ClassVar[Qt.Modifier] = ...
        CTRL: typing.ClassVar[Qt.Modifier] = ...
        META: typing.ClassVar[Qt.Modifier] = ...
        MODIFIER_MASK: typing.ClassVar[Qt.Modifier] = ...
        SHIFT: typing.ClassVar[Qt.Modifier] = ...
        UNICODE_ACCEL: typing.ClassVar[Qt.Modifier] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.Modifier: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.Modifier: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.Modifier: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.Modifier: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.Modifier: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.Modifier: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.Modifier: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.Modifier: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.Modifier: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.Modifier: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.Modifier: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.Modifier: ...

    class MouseButton:
        AllButtons: typing.ClassVar[Qt.MouseButton] = ...
        BackButton: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton1: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton10: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton11: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton12: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton13: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton14: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton15: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton16: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton17: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton18: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton19: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton2: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton20: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton21: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton22: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton23: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton24: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton3: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton4: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton5: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton6: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton7: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton8: typing.ClassVar[Qt.MouseButton] = ...
        ExtraButton9: typing.ClassVar[Qt.MouseButton] = ...
        ForwardButton: typing.ClassVar[Qt.MouseButton] = ...
        LeftButton: typing.ClassVar[Qt.MouseButton] = ...
        MaxMouseButton: typing.ClassVar[Qt.MouseButton] = ...
        MidButton: typing.ClassVar[Qt.MouseButton] = ...
        MiddleButton: typing.ClassVar[Qt.MouseButton] = ...
        MouseButtonMask: typing.ClassVar[Qt.MouseButton] = ...
        NoButton: typing.ClassVar[Qt.MouseButton] = ...
        RightButton: typing.ClassVar[Qt.MouseButton] = ...
        TaskButton: typing.ClassVar[Qt.MouseButton] = ...
        XButton1: typing.ClassVar[Qt.MouseButton] = ...
        XButton2: typing.ClassVar[Qt.MouseButton] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.MouseButtons: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.MouseButtons: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.MouseButtons: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.MouseButtons: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.MouseButtons: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.MouseButtons: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.MouseButtons: ...

    class MouseButtons:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.MouseButtons: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.MouseButtons: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.MouseButtons: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.MouseButtons: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.MouseButtons: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.MouseButtons: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.MouseButtons: ...

    class MouseEventFlag:
        MouseEventCreatedDoubleClick: typing.ClassVar[Qt.MouseEventFlag] = ...
        MouseEventFlagMask: typing.ClassVar[Qt.MouseEventFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.MouseEventFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.MouseEventFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.MouseEventFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.MouseEventFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.MouseEventFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.MouseEventFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.MouseEventFlags: ...

    class MouseEventFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.MouseEventFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.MouseEventFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.MouseEventFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.MouseEventFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.MouseEventFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.MouseEventFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.MouseEventFlags: ...

    class MouseEventSource:
        MouseEventNotSynthesized: typing.ClassVar[Qt.MouseEventSource] = ...
        MouseEventSynthesizedByApplication: typing.ClassVar[Qt.MouseEventSource] = ...
        MouseEventSynthesizedByQt: typing.ClassVar[Qt.MouseEventSource] = ...
        MouseEventSynthesizedBySystem: typing.ClassVar[Qt.MouseEventSource] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.MouseEventSource: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.MouseEventSource: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.MouseEventSource: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.MouseEventSource: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.MouseEventSource: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.MouseEventSource: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.MouseEventSource: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.MouseEventSource: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.MouseEventSource: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.MouseEventSource: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.MouseEventSource: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.MouseEventSource: ...

    class NativeGestureType:
        BeginNativeGesture: typing.ClassVar[Qt.NativeGestureType] = ...
        EndNativeGesture: typing.ClassVar[Qt.NativeGestureType] = ...
        PanNativeGesture: typing.ClassVar[Qt.NativeGestureType] = ...
        RotateNativeGesture: typing.ClassVar[Qt.NativeGestureType] = ...
        SmartZoomNativeGesture: typing.ClassVar[Qt.NativeGestureType] = ...
        SwipeNativeGesture: typing.ClassVar[Qt.NativeGestureType] = ...
        ZoomNativeGesture: typing.ClassVar[Qt.NativeGestureType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.NativeGestureType: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.NativeGestureType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.NativeGestureType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.NativeGestureType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.NativeGestureType: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.NativeGestureType: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.NativeGestureType: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.NativeGestureType: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.NativeGestureType: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.NativeGestureType: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.NativeGestureType: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.NativeGestureType: ...

    class NavigationMode:
        NavigationModeCursorAuto: typing.ClassVar[Qt.NavigationMode] = ...
        NavigationModeCursorForceVisible: typing.ClassVar[Qt.NavigationMode] = ...
        NavigationModeKeypadDirectional: typing.ClassVar[Qt.NavigationMode] = ...
        NavigationModeKeypadTabOrder: typing.ClassVar[Qt.NavigationMode] = ...
        NavigationModeNone: typing.ClassVar[Qt.NavigationMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.NavigationMode: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.NavigationMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.NavigationMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.NavigationMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.NavigationMode: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.NavigationMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.NavigationMode: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.NavigationMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.NavigationMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.NavigationMode: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.NavigationMode: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.NavigationMode: ...

    class Orientation:
        Horizontal: typing.ClassVar[Qt.Orientation] = ...
        Vertical: typing.ClassVar[Qt.Orientation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.Orientations: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.Orientations: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.Orientations: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.Orientations: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.Orientations: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.Orientations: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.Orientations: ...

    class Orientations:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.Orientations: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.Orientations: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.Orientations: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.Orientations: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.Orientations: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.Orientations: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.Orientations: ...

    class PenCapStyle:
        FlatCap: typing.ClassVar[Qt.PenCapStyle] = ...
        MPenCapStyle: typing.ClassVar[Qt.PenCapStyle] = ...
        RoundCap: typing.ClassVar[Qt.PenCapStyle] = ...
        SquareCap: typing.ClassVar[Qt.PenCapStyle] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.PenCapStyle: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.PenCapStyle: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.PenCapStyle: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.PenCapStyle: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.PenCapStyle: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.PenCapStyle: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.PenCapStyle: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.PenCapStyle: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.PenCapStyle: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.PenCapStyle: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.PenCapStyle: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.PenCapStyle: ...

    class PenJoinStyle:
        BevelJoin: typing.ClassVar[Qt.PenJoinStyle] = ...
        MPenJoinStyle: typing.ClassVar[Qt.PenJoinStyle] = ...
        MiterJoin: typing.ClassVar[Qt.PenJoinStyle] = ...
        RoundJoin: typing.ClassVar[Qt.PenJoinStyle] = ...
        SvgMiterJoin: typing.ClassVar[Qt.PenJoinStyle] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.PenJoinStyle: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.PenJoinStyle: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.PenJoinStyle: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.PenJoinStyle: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.PenJoinStyle: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.PenJoinStyle: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.PenJoinStyle: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.PenJoinStyle: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.PenJoinStyle: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.PenJoinStyle: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.PenJoinStyle: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.PenJoinStyle: ...

    class PenStyle:
        CustomDashLine: typing.ClassVar[Qt.PenStyle] = ...
        DashDotDotLine: typing.ClassVar[Qt.PenStyle] = ...
        DashDotLine: typing.ClassVar[Qt.PenStyle] = ...
        DashLine: typing.ClassVar[Qt.PenStyle] = ...
        DotLine: typing.ClassVar[Qt.PenStyle] = ...
        MPenStyle: typing.ClassVar[Qt.PenStyle] = ...
        NoPen: typing.ClassVar[Qt.PenStyle] = ...
        SolidLine: typing.ClassVar[Qt.PenStyle] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.PenStyle: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.PenStyle: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.PenStyle: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.PenStyle: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.PenStyle: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.PenStyle: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.PenStyle: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.PenStyle: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.PenStyle: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.PenStyle: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.PenStyle: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.PenStyle: ...

    class ScreenOrientation:
        InvertedLandscapeOrientation: typing.ClassVar[Qt.ScreenOrientation] = ...
        InvertedPortraitOrientation: typing.ClassVar[Qt.ScreenOrientation] = ...
        LandscapeOrientation: typing.ClassVar[Qt.ScreenOrientation] = ...
        PortraitOrientation: typing.ClassVar[Qt.ScreenOrientation] = ...
        PrimaryOrientation: typing.ClassVar[Qt.ScreenOrientation] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ScreenOrientations: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.ScreenOrientations: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ScreenOrientations: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ScreenOrientations: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ScreenOrientations: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ScreenOrientations: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ScreenOrientations: ...

    class ScreenOrientations:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ScreenOrientations: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.ScreenOrientations: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ScreenOrientations: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ScreenOrientations: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ScreenOrientations: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ScreenOrientations: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ScreenOrientations: ...

    class ScrollBarPolicy:
        ScrollBarAlwaysOff: typing.ClassVar[Qt.ScrollBarPolicy] = ...
        ScrollBarAlwaysOn: typing.ClassVar[Qt.ScrollBarPolicy] = ...
        ScrollBarAsNeeded: typing.ClassVar[Qt.ScrollBarPolicy] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.ScrollBarPolicy: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ScrollBarPolicy: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.ScrollBarPolicy: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ScrollBarPolicy: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.ScrollBarPolicy: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ScrollBarPolicy: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.ScrollBarPolicy: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ScrollBarPolicy: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.ScrollBarPolicy: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ScrollBarPolicy: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.ScrollBarPolicy: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ScrollBarPolicy: ...

    class ScrollPhase:
        NoScrollPhase: typing.ClassVar[Qt.ScrollPhase] = ...
        ScrollBegin: typing.ClassVar[Qt.ScrollPhase] = ...
        ScrollEnd: typing.ClassVar[Qt.ScrollPhase] = ...
        ScrollMomentum: typing.ClassVar[Qt.ScrollPhase] = ...
        ScrollUpdate: typing.ClassVar[Qt.ScrollPhase] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.ScrollPhase: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ScrollPhase: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.ScrollPhase: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ScrollPhase: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.ScrollPhase: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ScrollPhase: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.ScrollPhase: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ScrollPhase: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.ScrollPhase: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ScrollPhase: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.ScrollPhase: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ScrollPhase: ...

    class ShortcutContext:
        ApplicationShortcut: typing.ClassVar[Qt.ShortcutContext] = ...
        WidgetShortcut: typing.ClassVar[Qt.ShortcutContext] = ...
        WidgetWithChildrenShortcut: typing.ClassVar[Qt.ShortcutContext] = ...
        WindowShortcut: typing.ClassVar[Qt.ShortcutContext] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.ShortcutContext: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ShortcutContext: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.ShortcutContext: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ShortcutContext: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.ShortcutContext: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ShortcutContext: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.ShortcutContext: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ShortcutContext: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.ShortcutContext: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ShortcutContext: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.ShortcutContext: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ShortcutContext: ...

    class SizeHint:
        MaximumSize: typing.ClassVar[Qt.SizeHint] = ...
        MinimumDescent: typing.ClassVar[Qt.SizeHint] = ...
        MinimumSize: typing.ClassVar[Qt.SizeHint] = ...
        NSizeHints: typing.ClassVar[Qt.SizeHint] = ...
        PreferredSize: typing.ClassVar[Qt.SizeHint] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.SizeHint: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.SizeHint: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.SizeHint: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.SizeHint: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.SizeHint: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.SizeHint: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.SizeHint: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.SizeHint: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.SizeHint: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.SizeHint: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.SizeHint: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.SizeHint: ...

    class SizeMode:
        AbsoluteSize: typing.ClassVar[Qt.SizeMode] = ...
        RelativeSize: typing.ClassVar[Qt.SizeMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.SizeMode: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.SizeMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.SizeMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.SizeMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.SizeMode: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.SizeMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.SizeMode: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.SizeMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.SizeMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.SizeMode: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.SizeMode: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.SizeMode: ...

    class SortOrder:
        AscendingOrder: typing.ClassVar[Qt.SortOrder] = ...
        DescendingOrder: typing.ClassVar[Qt.SortOrder] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.SortOrder: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.SortOrder: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.SortOrder: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.SortOrder: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.SortOrder: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.SortOrder: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.SortOrder: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.SortOrder: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.SortOrder: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.SortOrder: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.SortOrder: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.SortOrder: ...

    class SplitBehavior:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.SplitBehavior: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.SplitBehavior: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.SplitBehavior: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.SplitBehavior: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.SplitBehavior: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.SplitBehavior: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.SplitBehavior: ...

    class SplitBehaviorFlags:
        KeepEmptyParts: typing.ClassVar[Qt.SplitBehaviorFlags] = ...
        SkipEmptyParts: typing.ClassVar[Qt.SplitBehaviorFlags] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.SplitBehavior: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.SplitBehavior: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.SplitBehavior: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.SplitBehavior: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.SplitBehavior: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.SplitBehavior: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.SplitBehavior: ...

    class TabFocusBehavior:
        NoTabFocus: typing.ClassVar[Qt.TabFocusBehavior] = ...
        TabFocusAllControls: typing.ClassVar[Qt.TabFocusBehavior] = ...
        TabFocusListControls: typing.ClassVar[Qt.TabFocusBehavior] = ...
        TabFocusTextControls: typing.ClassVar[Qt.TabFocusBehavior] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.TabFocusBehavior: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.TabFocusBehavior: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.TabFocusBehavior: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.TabFocusBehavior: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.TabFocusBehavior: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.TabFocusBehavior: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.TabFocusBehavior: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.TabFocusBehavior: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.TabFocusBehavior: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.TabFocusBehavior: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.TabFocusBehavior: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.TabFocusBehavior: ...

    class TextElideMode:
        ElideLeft: typing.ClassVar[Qt.TextElideMode] = ...
        ElideMiddle: typing.ClassVar[Qt.TextElideMode] = ...
        ElideNone: typing.ClassVar[Qt.TextElideMode] = ...
        ElideRight: typing.ClassVar[Qt.TextElideMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.TextElideMode: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.TextElideMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.TextElideMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.TextElideMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.TextElideMode: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.TextElideMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.TextElideMode: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.TextElideMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.TextElideMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.TextElideMode: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.TextElideMode: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.TextElideMode: ...

    class TextFlag:
        TextBypassShaping: typing.ClassVar[Qt.TextFlag] = ...
        TextDontClip: typing.ClassVar[Qt.TextFlag] = ...
        TextDontPrint: typing.ClassVar[Qt.TextFlag] = ...
        TextExpandTabs: typing.ClassVar[Qt.TextFlag] = ...
        TextForceLeftToRight: typing.ClassVar[Qt.TextFlag] = ...
        TextForceRightToLeft: typing.ClassVar[Qt.TextFlag] = ...
        TextHideMnemonic: typing.ClassVar[Qt.TextFlag] = ...
        TextIncludeTrailingSpaces: typing.ClassVar[Qt.TextFlag] = ...
        TextJustificationForced: typing.ClassVar[Qt.TextFlag] = ...
        TextLongestVariant: typing.ClassVar[Qt.TextFlag] = ...
        TextShowMnemonic: typing.ClassVar[Qt.TextFlag] = ...
        TextSingleLine: typing.ClassVar[Qt.TextFlag] = ...
        TextWordWrap: typing.ClassVar[Qt.TextFlag] = ...
        TextWrapAnywhere: typing.ClassVar[Qt.TextFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.TextFlag: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.TextFlag: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.TextFlag: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.TextFlag: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.TextFlag: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.TextFlag: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.TextFlag: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.TextFlag: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.TextFlag: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.TextFlag: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.TextFlag: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.TextFlag: ...

    class TextFormat:
        AutoText: typing.ClassVar[Qt.TextFormat] = ...
        MarkdownText: typing.ClassVar[Qt.TextFormat] = ...
        PlainText: typing.ClassVar[Qt.TextFormat] = ...
        RichText: typing.ClassVar[Qt.TextFormat] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.TextFormat: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.TextFormat: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.TextFormat: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.TextFormat: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.TextFormat: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.TextFormat: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.TextFormat: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.TextFormat: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.TextFormat: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.TextFormat: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.TextFormat: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.TextFormat: ...

    class TextInteractionFlag:
        LinksAccessibleByKeyboard: typing.ClassVar[Qt.TextInteractionFlag] = ...
        LinksAccessibleByMouse: typing.ClassVar[Qt.TextInteractionFlag] = ...
        NoTextInteraction: typing.ClassVar[Qt.TextInteractionFlag] = ...
        TextBrowserInteraction: typing.ClassVar[Qt.TextInteractionFlag] = ...
        TextEditable: typing.ClassVar[Qt.TextInteractionFlag] = ...
        TextEditorInteraction: typing.ClassVar[Qt.TextInteractionFlag] = ...
        TextSelectableByKeyboard: typing.ClassVar[Qt.TextInteractionFlag] = ...
        TextSelectableByMouse: typing.ClassVar[Qt.TextInteractionFlag] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.TextInteractionFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.TextInteractionFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.TextInteractionFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.TextInteractionFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.TextInteractionFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.TextInteractionFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.TextInteractionFlags: ...

    class TextInteractionFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.TextInteractionFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.TextInteractionFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.TextInteractionFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.TextInteractionFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.TextInteractionFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.TextInteractionFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.TextInteractionFlags: ...

    class TileRule:
        RepeatTile: typing.ClassVar[Qt.TileRule] = ...
        RoundTile: typing.ClassVar[Qt.TileRule] = ...
        StretchTile: typing.ClassVar[Qt.TileRule] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.TileRule: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.TileRule: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.TileRule: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.TileRule: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.TileRule: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.TileRule: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.TileRule: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.TileRule: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.TileRule: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.TileRule: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.TileRule: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.TileRule: ...

    class TimeSpec:
        LocalTime: typing.ClassVar[Qt.TimeSpec] = ...
        OffsetFromUTC: typing.ClassVar[Qt.TimeSpec] = ...
        TimeZone: typing.ClassVar[Qt.TimeSpec] = ...
        UTC: typing.ClassVar[Qt.TimeSpec] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.TimeSpec: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.TimeSpec: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.TimeSpec: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.TimeSpec: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.TimeSpec: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.TimeSpec: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.TimeSpec: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.TimeSpec: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.TimeSpec: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.TimeSpec: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.TimeSpec: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.TimeSpec: ...

    class TimerType:
        CoarseTimer: typing.ClassVar[Qt.TimerType] = ...
        PreciseTimer: typing.ClassVar[Qt.TimerType] = ...
        VeryCoarseTimer: typing.ClassVar[Qt.TimerType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.TimerType: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.TimerType: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.TimerType: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.TimerType: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.TimerType: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.TimerType: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.TimerType: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.TimerType: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.TimerType: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.TimerType: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.TimerType: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.TimerType: ...

    class ToolBarArea:
        AllToolBarAreas: typing.ClassVar[Qt.ToolBarArea] = ...
        BottomToolBarArea: typing.ClassVar[Qt.ToolBarArea] = ...
        LeftToolBarArea: typing.ClassVar[Qt.ToolBarArea] = ...
        NoToolBarArea: typing.ClassVar[Qt.ToolBarArea] = ...
        RightToolBarArea: typing.ClassVar[Qt.ToolBarArea] = ...
        ToolBarArea_Mask: typing.ClassVar[Qt.ToolBarArea] = ...
        TopToolBarArea: typing.ClassVar[Qt.ToolBarArea] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ToolBarAreas: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.ToolBarAreas: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ToolBarAreas: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ToolBarAreas: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ToolBarAreas: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ToolBarAreas: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ToolBarAreas: ...

    class ToolBarAreaSizes:
        NToolBarAreas: typing.ClassVar[Qt.ToolBarAreaSizes] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.ToolBarAreaSizes: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ToolBarAreaSizes: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.ToolBarAreaSizes: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ToolBarAreaSizes: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.ToolBarAreaSizes: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ToolBarAreaSizes: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.ToolBarAreaSizes: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ToolBarAreaSizes: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.ToolBarAreaSizes: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ToolBarAreaSizes: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.ToolBarAreaSizes: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ToolBarAreaSizes: ...

    class ToolBarAreas:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ToolBarAreas: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.ToolBarAreas: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ToolBarAreas: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ToolBarAreas: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ToolBarAreas: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ToolBarAreas: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ToolBarAreas: ...

    class ToolButtonStyle:
        ToolButtonFollowStyle: typing.ClassVar[Qt.ToolButtonStyle] = ...
        ToolButtonIconOnly: typing.ClassVar[Qt.ToolButtonStyle] = ...
        ToolButtonTextBesideIcon: typing.ClassVar[Qt.ToolButtonStyle] = ...
        ToolButtonTextOnly: typing.ClassVar[Qt.ToolButtonStyle] = ...
        ToolButtonTextUnderIcon: typing.ClassVar[Qt.ToolButtonStyle] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.ToolButtonStyle: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.ToolButtonStyle: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.ToolButtonStyle: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.ToolButtonStyle: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.ToolButtonStyle: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.ToolButtonStyle: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.ToolButtonStyle: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.ToolButtonStyle: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.ToolButtonStyle: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.ToolButtonStyle: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.ToolButtonStyle: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.ToolButtonStyle: ...

    class TouchPointState:
        TouchPointMoved: typing.ClassVar[Qt.TouchPointState] = ...
        TouchPointPressed: typing.ClassVar[Qt.TouchPointState] = ...
        TouchPointReleased: typing.ClassVar[Qt.TouchPointState] = ...
        TouchPointStationary: typing.ClassVar[Qt.TouchPointState] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.TouchPointStates: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.TouchPointStates: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.TouchPointStates: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.TouchPointStates: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.TouchPointStates: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.TouchPointStates: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.TouchPointStates: ...

    class TouchPointStates:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.TouchPointStates: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.TouchPointStates: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.TouchPointStates: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.TouchPointStates: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.TouchPointStates: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.TouchPointStates: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.TouchPointStates: ...

    class TransformationMode:
        FastTransformation: typing.ClassVar[Qt.TransformationMode] = ...
        SmoothTransformation: typing.ClassVar[Qt.TransformationMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.TransformationMode: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.TransformationMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.TransformationMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.TransformationMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.TransformationMode: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.TransformationMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.TransformationMode: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.TransformationMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.TransformationMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.TransformationMode: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.TransformationMode: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.TransformationMode: ...

    class UIEffect:
        UI_AnimateCombo: typing.ClassVar[Qt.UIEffect] = ...
        UI_AnimateMenu: typing.ClassVar[Qt.UIEffect] = ...
        UI_AnimateToolBox: typing.ClassVar[Qt.UIEffect] = ...
        UI_AnimateTooltip: typing.ClassVar[Qt.UIEffect] = ...
        UI_FadeMenu: typing.ClassVar[Qt.UIEffect] = ...
        UI_FadeTooltip: typing.ClassVar[Qt.UIEffect] = ...
        UI_General: typing.ClassVar[Qt.UIEffect] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.UIEffect: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.UIEffect: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.UIEffect: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.UIEffect: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.UIEffect: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.UIEffect: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.UIEffect: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.UIEffect: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.UIEffect: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.UIEffect: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.UIEffect: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.UIEffect: ...

    class WhiteSpaceMode:
        WhiteSpaceModeUndefined: typing.ClassVar[Qt.WhiteSpaceMode] = ...
        WhiteSpaceNoWrap: typing.ClassVar[Qt.WhiteSpaceMode] = ...
        WhiteSpaceNormal: typing.ClassVar[Qt.WhiteSpaceMode] = ...
        WhiteSpacePre: typing.ClassVar[Qt.WhiteSpaceMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.WhiteSpaceMode: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.WhiteSpaceMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.WhiteSpaceMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.WhiteSpaceMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.WhiteSpaceMode: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.WhiteSpaceMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.WhiteSpaceMode: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.WhiteSpaceMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.WhiteSpaceMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.WhiteSpaceMode: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.WhiteSpaceMode: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.WhiteSpaceMode: ...

    class WidgetAttribute:
        WA_AcceptDrops: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_AcceptTouchEvents: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_AlwaysShowToolTips: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_AlwaysStackOnTop: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_AttributeCount: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_CanHostQMdiSubWindowTitleBar: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_ContentsMarginsRespectsSafeArea: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_ContentsPropagated: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_CustomWhatsThis: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_DeleteOnClose: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_Disabled: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_DontCreateNativeAncestors: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_DontShowOnScreen: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_DropSiteRegistered: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_ForceAcceptDrops: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_ForceDisabled: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_ForceUpdatesDisabled: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_GrabbedShortcut: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_GroupLeader: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_Hover: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_InputMethodEnabled: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_InputMethodTransparent: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_InvalidSize: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_KeyCompression: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_KeyboardFocusChange: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_LaidOut: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_LayoutOnEntireRect: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_LayoutUsesWidgetRect: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MSWindowsUseDirect3D: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MacAlwaysShowToolWindow: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MacBrushedMetal: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MacFrameworkScaled: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MacMetalStyle: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MacMiniSize: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MacNoClickThrough: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MacNoShadow: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MacNormalSize: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MacOpaqueSizeGrip: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MacShowFocusRect: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MacSmallSize: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MacVariableSize: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_Mapped: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MouseNoMask: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_MouseTracking: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_Moved: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_NativeWindow: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_NoBackground: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_NoChildEventsForParent: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_NoChildEventsFromChildren: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_NoMousePropagation: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_NoMouseReplay: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_NoSystemBackground: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_NoX11EventCompression: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_OpaquePaintEvent: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_OutsideWSRange: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_PaintOnScreen: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_PaintUnclipped: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_PendingMoveEvent: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_PendingResizeEvent: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_PendingUpdate: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_QuitOnClose: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_Resized: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_RightToLeft: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_SetCursor: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_SetFont: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_SetLayoutDirection: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_SetLocale: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_SetPalette: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_SetStyle: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_SetWindowIcon: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_SetWindowModality: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_ShowModal: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_ShowWithoutActivating: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_StaticContents: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_StyleSheet: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_StyleSheetTarget: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_StyledBackground: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_TabletTracking: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_TintedBackground: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_TouchPadAcceptSingleTouchEvents: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_TranslucentBackground: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_TransparentForMouseEvents: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_UnderMouse: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_UpdatesDisabled: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WState_AcceptedTouchBeginEvent: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WState_CompressKeys: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WState_ConfigPending: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WState_Created: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WState_DND: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WState_ExplicitShowHide: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WState_Hidden: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WState_InPaintEvent: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WState_OwnSizePolicy: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WState_Polished: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WState_Reparented: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WState_Visible: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WState_WindowOpacitySet: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WindowModified: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_WindowPropagation: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11BypassTransientForHint: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11DoNotAcceptFocus: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11NetWmWindowTypeCombo: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11NetWmWindowTypeDND: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11NetWmWindowTypeDesktop: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11NetWmWindowTypeDialog: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11NetWmWindowTypeDock: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11NetWmWindowTypeDropDownMenu: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11NetWmWindowTypeMenu: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11NetWmWindowTypeNotification: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11NetWmWindowTypePopupMenu: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11NetWmWindowTypeSplash: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11NetWmWindowTypeToolBar: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11NetWmWindowTypeToolTip: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11NetWmWindowTypeUtility: typing.ClassVar[Qt.WidgetAttribute] = ...
        WA_X11OpenGLOverlay: typing.ClassVar[Qt.WidgetAttribute] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.WidgetAttribute: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.WidgetAttribute: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.WidgetAttribute: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.WidgetAttribute: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.WidgetAttribute: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.WidgetAttribute: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.WidgetAttribute: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.WidgetAttribute: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.WidgetAttribute: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.WidgetAttribute: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.WidgetAttribute: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.WidgetAttribute: ...

    class WindowFlags:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.WindowFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.WindowFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.WindowFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.WindowFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.WindowFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.WindowFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.WindowFlags: ...

    class WindowFrameSection:
        BottomLeftSection: typing.ClassVar[Qt.WindowFrameSection] = ...
        BottomRightSection: typing.ClassVar[Qt.WindowFrameSection] = ...
        BottomSection: typing.ClassVar[Qt.WindowFrameSection] = ...
        LeftSection: typing.ClassVar[Qt.WindowFrameSection] = ...
        NoSection: typing.ClassVar[Qt.WindowFrameSection] = ...
        RightSection: typing.ClassVar[Qt.WindowFrameSection] = ...
        TitleBarArea: typing.ClassVar[Qt.WindowFrameSection] = ...
        TopLeftSection: typing.ClassVar[Qt.WindowFrameSection] = ...
        TopRightSection: typing.ClassVar[Qt.WindowFrameSection] = ...
        TopSection: typing.ClassVar[Qt.WindowFrameSection] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.WindowFrameSection: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.WindowFrameSection: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.WindowFrameSection: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.WindowFrameSection: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.WindowFrameSection: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.WindowFrameSection: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.WindowFrameSection: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.WindowFrameSection: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.WindowFrameSection: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.WindowFrameSection: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.WindowFrameSection: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.WindowFrameSection: ...

    class WindowModality:
        ApplicationModal: typing.ClassVar[Qt.WindowModality] = ...
        NonModal: typing.ClassVar[Qt.WindowModality] = ...
        WindowModal: typing.ClassVar[Qt.WindowModality] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> Qt.WindowModality: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.WindowModality: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> Qt.WindowModality: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.WindowModality: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> Qt.WindowModality: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.WindowModality: ...
        def __rmul__(self, other: typing.SupportsInt) -> Qt.WindowModality: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.WindowModality: ...
        def __rsub__(self, other: typing.SupportsInt) -> Qt.WindowModality: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.WindowModality: ...
        def __sub__(self, other: typing.SupportsInt) -> Qt.WindowModality: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.WindowModality: ...

    class WindowState:
        WindowActive: typing.ClassVar[Qt.WindowState] = ...
        WindowFullScreen: typing.ClassVar[Qt.WindowState] = ...
        WindowMaximized: typing.ClassVar[Qt.WindowState] = ...
        WindowMinimized: typing.ClassVar[Qt.WindowState] = ...
        WindowNoState: typing.ClassVar[Qt.WindowState] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.WindowStates: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.WindowStates: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.WindowStates: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.WindowStates: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.WindowStates: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.WindowStates: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.WindowStates: ...

    class WindowStates:
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.WindowStates: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.WindowStates: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.WindowStates: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.WindowStates: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.WindowStates: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.WindowStates: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.WindowStates: ...

    class WindowType:
        BypassGraphicsProxyWidget: typing.ClassVar[Qt.WindowType] = ...
        BypassWindowManagerHint: typing.ClassVar[Qt.WindowType] = ...
        CoverWindow: typing.ClassVar[Qt.WindowType] = ...
        CustomizeWindowHint: typing.ClassVar[Qt.WindowType] = ...
        Desktop: typing.ClassVar[Qt.WindowType] = ...
        Dialog: typing.ClassVar[Qt.WindowType] = ...
        Drawer: typing.ClassVar[Qt.WindowType] = ...
        ForeignWindow: typing.ClassVar[Qt.WindowType] = ...
        FramelessWindowHint: typing.ClassVar[Qt.WindowType] = ...
        MSWindowsFixedSizeDialogHint: typing.ClassVar[Qt.WindowType] = ...
        MSWindowsOwnDC: typing.ClassVar[Qt.WindowType] = ...
        MacWindowToolBarButtonHint: typing.ClassVar[Qt.WindowType] = ...
        MaximizeUsingFullscreenGeometryHint: typing.ClassVar[Qt.WindowType] = ...
        NoDropShadowWindowHint: typing.ClassVar[Qt.WindowType] = ...
        Popup: typing.ClassVar[Qt.WindowType] = ...
        Sheet: typing.ClassVar[Qt.WindowType] = ...
        SplashScreen: typing.ClassVar[Qt.WindowType] = ...
        SubWindow: typing.ClassVar[Qt.WindowType] = ...
        Tool: typing.ClassVar[Qt.WindowType] = ...
        ToolTip: typing.ClassVar[Qt.WindowType] = ...
        Widget: typing.ClassVar[Qt.WindowType] = ...
        Window: typing.ClassVar[Qt.WindowType] = ...
        WindowCloseButtonHint: typing.ClassVar[Qt.WindowType] = ...
        WindowContextHelpButtonHint: typing.ClassVar[Qt.WindowType] = ...
        WindowDoesNotAcceptFocus: typing.ClassVar[Qt.WindowType] = ...
        WindowFullscreenButtonHint: typing.ClassVar[Qt.WindowType] = ...
        WindowMaximizeButtonHint: typing.ClassVar[Qt.WindowType] = ...
        WindowMinMaxButtonsHint: typing.ClassVar[Qt.WindowType] = ...
        WindowMinimizeButtonHint: typing.ClassVar[Qt.WindowType] = ...
        WindowOverridesSystemGestures: typing.ClassVar[Qt.WindowType] = ...
        WindowShadeButtonHint: typing.ClassVar[Qt.WindowType] = ...
        WindowStaysOnBottomHint: typing.ClassVar[Qt.WindowType] = ...
        WindowStaysOnTopHint: typing.ClassVar[Qt.WindowType] = ...
        WindowSystemMenuHint: typing.ClassVar[Qt.WindowType] = ...
        WindowTitleHint: typing.ClassVar[Qt.WindowType] = ...
        WindowTransparentForInput: typing.ClassVar[Qt.WindowType] = ...
        WindowType_Mask: typing.ClassVar[Qt.WindowType] = ...
        X11BypassWindowManagerHint: typing.ClassVar[Qt.WindowType] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __and__(self, other: typing.SupportsInt) -> Qt.WindowFlags: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> Qt.WindowFlags: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> Qt.WindowFlags: ...
        def __rand__(self, other: typing.SupportsInt) -> Qt.WindowFlags: ...
        def __ror__(self, other: typing.SupportsInt) -> Qt.WindowFlags: ...
        def __rxor__(self, other: typing.SupportsInt) -> Qt.WindowFlags: ...
        def __xor__(self, other: typing.SupportsInt) -> Qt.WindowFlags: ...
    AA_AttributeCount: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_CompressHighFrequencyEvents: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_CompressTabletEvents: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_DisableHighDpiScaling: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_DisableNativeVirtualKeyboard: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_DisableSessionManager: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_DisableShaderDiskCache: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_DisableWindowContextHelpButton: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_DontCheckOpenGLContextThreadAffinity: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_DontCreateNativeWidgetSiblings: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_DontShowIconsInMenus: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_DontShowShortcutsInContextMenus: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_DontUseNativeDialogs: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_DontUseNativeMenuBar: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_EnableHighDpiScaling: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_ForceRasterWidgets: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_ImmediateWidgetCreation: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_MSWindowsUseDirect3DByDefault: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_MacDontSwapCtrlAndMeta: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_MacPluginApplication: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_NativeWindows: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_PluginApplication: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_SetPalette: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_ShareOpenGLContexts: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_SynthesizeMouseForUnhandledTabletEvents: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_SynthesizeMouseForUnhandledTouchEvents: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_SynthesizeTouchForUnhandledMouseEvents: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_Use96Dpi: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_UseDesktopOpenGL: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_UseHighDpiPixmaps: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_UseOpenGLES: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_UseSoftwareOpenGL: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_UseStyleSheetPropagationInWidgetStyles: typing.ClassVar[Qt.ApplicationAttribute] = ...
    AA_X11InitThreads: typing.ClassVar[Qt.ApplicationAttribute] = ...
    ALT: typing.ClassVar[Qt.Modifier] = ...
    AbsoluteSize: typing.ClassVar[Qt.SizeMode] = ...
    AccessibleDescriptionRole: typing.ClassVar[Qt.ItemDataRole] = ...
    AccessibleTextRole: typing.ClassVar[Qt.ItemDataRole] = ...
    ActionMask: typing.ClassVar[Qt.DropAction] = ...
    ActionsContextMenu: typing.ClassVar[Qt.ContextMenuPolicy] = ...
    ActiveWindowFocusReason: typing.ClassVar[Qt.FocusReason] = ...
    AddToSelection: typing.ClassVar[Qt.ItemSelectionOperation] = ...
    AlignAbsolute: typing.ClassVar[Qt.AlignmentFlag] = ...
    AlignBaseline: typing.ClassVar[Qt.AlignmentFlag] = ...
    AlignBottom: typing.ClassVar[Qt.AlignmentFlag] = ...
    AlignCenter: typing.ClassVar[Qt.AlignmentFlag] = ...
    AlignHCenter: typing.ClassVar[Qt.AlignmentFlag] = ...
    AlignHorizontal_Mask: typing.ClassVar[Qt.AlignmentFlag] = ...
    AlignJustify: typing.ClassVar[Qt.AlignmentFlag] = ...
    AlignLeading: typing.ClassVar[Qt.AlignmentFlag] = ...
    AlignLeft: typing.ClassVar[Qt.AlignmentFlag] = ...
    AlignRight: typing.ClassVar[Qt.AlignmentFlag] = ...
    AlignTop: typing.ClassVar[Qt.AlignmentFlag] = ...
    AlignTrailing: typing.ClassVar[Qt.AlignmentFlag] = ...
    AlignVCenter: typing.ClassVar[Qt.AlignmentFlag] = ...
    AlignVertical_Mask: typing.ClassVar[Qt.AlignmentFlag] = ...
    AllButtons: typing.ClassVar[Qt.MouseButton] = ...
    AllDockWidgetAreas: typing.ClassVar[Qt.DockWidgetArea] = ...
    AllToolBarAreas: typing.ClassVar[Qt.ToolBarArea] = ...
    AlphaDither_Mask: typing.ClassVar[Qt.ImageConversionFlag] = ...
    AltModifier: typing.ClassVar[Qt.KeyboardModifier] = ...
    AnchorBottom: typing.ClassVar[Qt.AnchorPoint] = ...
    AnchorHorizontalCenter: typing.ClassVar[Qt.AnchorPoint] = ...
    AnchorLeft: typing.ClassVar[Qt.AnchorPoint] = ...
    AnchorRight: typing.ClassVar[Qt.AnchorPoint] = ...
    AnchorTop: typing.ClassVar[Qt.AnchorPoint] = ...
    AnchorVerticalCenter: typing.ClassVar[Qt.AnchorPoint] = ...
    ApplicationActive: typing.ClassVar[Qt.ApplicationState] = ...
    ApplicationHidden: typing.ClassVar[Qt.ApplicationState] = ...
    ApplicationInactive: typing.ClassVar[Qt.ApplicationState] = ...
    ApplicationModal: typing.ClassVar[Qt.WindowModality] = ...
    ApplicationShortcut: typing.ClassVar[Qt.ShortcutContext] = ...
    ApplicationSuspended: typing.ClassVar[Qt.ApplicationState] = ...
    ArrowCursor: typing.ClassVar[Qt.CursorShape] = ...
    AscendingOrder: typing.ClassVar[Qt.SortOrder] = ...
    AutoColor: typing.ClassVar[Qt.ImageConversionFlag] = ...
    AutoConnection: typing.ClassVar[Qt.ConnectionType] = ...
    AutoDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
    AutoText: typing.ClassVar[Qt.TextFormat] = ...
    AvoidDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
    BDiagPattern: typing.ClassVar[Qt.BrushStyle] = ...
    BackButton: typing.ClassVar[Qt.MouseButton] = ...
    BackgroundColorRole: typing.ClassVar[Qt.ItemDataRole] = ...
    BackgroundRole: typing.ClassVar[Qt.ItemDataRole] = ...
    BacktabFocusReason: typing.ClassVar[Qt.FocusReason] = ...
    BeginNativeGesture: typing.ClassVar[Qt.NativeGestureType] = ...
    BevelJoin: typing.ClassVar[Qt.PenJoinStyle] = ...
    BitmapCursor: typing.ClassVar[Qt.CursorShape] = ...
    BlankCursor: typing.ClassVar[Qt.CursorShape] = ...
    BlockingQueuedConnection: typing.ClassVar[Qt.ConnectionType] = ...
    BottomDockWidgetArea: typing.ClassVar[Qt.DockWidgetArea] = ...
    BottomEdge: typing.ClassVar[Qt.Edge] = ...
    BottomLeftCorner: typing.ClassVar[Qt.Corner] = ...
    BottomLeftSection: typing.ClassVar[Qt.WindowFrameSection] = ...
    BottomRightCorner: typing.ClassVar[Qt.Corner] = ...
    BottomRightSection: typing.ClassVar[Qt.WindowFrameSection] = ...
    BottomSection: typing.ClassVar[Qt.WindowFrameSection] = ...
    BottomToolBarArea: typing.ClassVar[Qt.ToolBarArea] = ...
    BusyCursor: typing.ClassVar[Qt.CursorShape] = ...
    BypassGraphicsProxyWidget: typing.ClassVar[Qt.WindowType] = ...
    BypassWindowManagerHint: typing.ClassVar[Qt.WindowType] = ...
    CTRL: typing.ClassVar[Qt.Modifier] = ...
    CaseInsensitive: typing.ClassVar[Qt.CaseSensitivity] = ...
    CaseSensitive: typing.ClassVar[Qt.CaseSensitivity] = ...
    CheckStateRole: typing.ClassVar[Qt.ItemDataRole] = ...
    Checked: typing.ClassVar[Qt.CheckState] = ...
    ChecksumIso3309: typing.ClassVar[Qt.ChecksumType] = ...
    ChecksumItuV41: typing.ClassVar[Qt.ChecksumType] = ...
    ClickFocus: typing.ClassVar[Qt.FocusPolicy] = ...
    ClosedHandCursor: typing.ClassVar[Qt.CursorShape] = ...
    CoarseTimer: typing.ClassVar[Qt.TimerType] = ...
    ColorMode_Mask: typing.ClassVar[Qt.ImageConversionFlag] = ...
    ColorOnly: typing.ClassVar[Qt.ImageConversionFlag] = ...
    ConicalGradientPattern: typing.ClassVar[Qt.BrushStyle] = ...
    ContainsItemBoundingRect: typing.ClassVar[Qt.ItemSelectionMode] = ...
    ContainsItemShape: typing.ClassVar[Qt.ItemSelectionMode] = ...
    ControlModifier: typing.ClassVar[Qt.KeyboardModifier] = ...
    CopyAction: typing.ClassVar[Qt.DropAction] = ...
    CoverWindow: typing.ClassVar[Qt.WindowType] = ...
    CrossCursor: typing.ClassVar[Qt.CursorShape] = ...
    CrossPattern: typing.ClassVar[Qt.BrushStyle] = ...
    CustomContextMenu: typing.ClassVar[Qt.ContextMenuPolicy] = ...
    CustomCursor: typing.ClassVar[Qt.CursorShape] = ...
    CustomDashLine: typing.ClassVar[Qt.PenStyle] = ...
    CustomGesture: typing.ClassVar[Qt.GestureType] = ...
    CustomizeWindowHint: typing.ClassVar[Qt.WindowType] = ...
    DashDotDotLine: typing.ClassVar[Qt.PenStyle] = ...
    DashDotLine: typing.ClassVar[Qt.PenStyle] = ...
    DashLine: typing.ClassVar[Qt.PenStyle] = ...
    DecorationPropertyRole: typing.ClassVar[Qt.ItemDataRole] = ...
    DecorationRole: typing.ClassVar[Qt.ItemDataRole] = ...
    DefaultContextMenu: typing.ClassVar[Qt.ContextMenuPolicy] = ...
    DefaultLocaleLongDate: typing.ClassVar[Qt.DateFormat] = ...
    DefaultLocaleShortDate: typing.ClassVar[Qt.DateFormat] = ...
    Dense1Pattern: typing.ClassVar[Qt.BrushStyle] = ...
    Dense2Pattern: typing.ClassVar[Qt.BrushStyle] = ...
    Dense3Pattern: typing.ClassVar[Qt.BrushStyle] = ...
    Dense4Pattern: typing.ClassVar[Qt.BrushStyle] = ...
    Dense5Pattern: typing.ClassVar[Qt.BrushStyle] = ...
    Dense6Pattern: typing.ClassVar[Qt.BrushStyle] = ...
    Dense7Pattern: typing.ClassVar[Qt.BrushStyle] = ...
    DescendingOrder: typing.ClassVar[Qt.SortOrder] = ...
    Desktop: typing.ClassVar[Qt.WindowType] = ...
    DeviceCoordinates: typing.ClassVar[Qt.CoordinateSystem] = ...
    DiagCrossPattern: typing.ClassVar[Qt.BrushStyle] = ...
    Dialog: typing.ClassVar[Qt.WindowType] = ...
    DiffuseAlphaDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
    DiffuseDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
    DirectConnection: typing.ClassVar[Qt.ConnectionType] = ...
    DisplayPropertyRole: typing.ClassVar[Qt.ItemDataRole] = ...
    DisplayRole: typing.ClassVar[Qt.ItemDataRole] = ...
    DitherMode_Mask: typing.ClassVar[Qt.ImageConversionFlag] = ...
    Dither_Mask: typing.ClassVar[Qt.ImageConversionFlag] = ...
    DockWidgetArea_Mask: typing.ClassVar[Qt.DockWidgetArea] = ...
    DontStartGestureOnChildren: typing.ClassVar[Qt.GestureFlag] = ...
    DotLine: typing.ClassVar[Qt.PenStyle] = ...
    DownArrow: typing.ClassVar[Qt.ArrowType] = ...
    DragCopyCursor: typing.ClassVar[Qt.CursorShape] = ...
    DragLinkCursor: typing.ClassVar[Qt.CursorShape] = ...
    DragMoveCursor: typing.ClassVar[Qt.CursorShape] = ...
    Drawer: typing.ClassVar[Qt.WindowType] = ...
    EditRole: typing.ClassVar[Qt.ItemDataRole] = ...
    ElideLeft: typing.ClassVar[Qt.TextElideMode] = ...
    ElideMiddle: typing.ClassVar[Qt.TextElideMode] = ...
    ElideNone: typing.ClassVar[Qt.TextElideMode] = ...
    ElideRight: typing.ClassVar[Qt.TextElideMode] = ...
    EndNativeGesture: typing.ClassVar[Qt.NativeGestureType] = ...
    EnterKeyDefault: typing.ClassVar[Qt.EnterKeyType] = ...
    EnterKeyDone: typing.ClassVar[Qt.EnterKeyType] = ...
    EnterKeyGo: typing.ClassVar[Qt.EnterKeyType] = ...
    EnterKeyNext: typing.ClassVar[Qt.EnterKeyType] = ...
    EnterKeyPrevious: typing.ClassVar[Qt.EnterKeyType] = ...
    EnterKeyReturn: typing.ClassVar[Qt.EnterKeyType] = ...
    EnterKeySearch: typing.ClassVar[Qt.EnterKeyType] = ...
    EnterKeySend: typing.ClassVar[Qt.EnterKeyType] = ...
    ExactHit: typing.ClassVar[Qt.HitTestAccuracy] = ...
    ExtraButton1: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton10: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton11: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton12: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton13: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton14: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton15: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton16: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton17: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton18: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton19: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton2: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton20: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton21: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton22: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton23: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton24: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton3: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton4: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton5: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton6: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton7: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton8: typing.ClassVar[Qt.MouseButton] = ...
    ExtraButton9: typing.ClassVar[Qt.MouseButton] = ...
    FDiagPattern: typing.ClassVar[Qt.BrushStyle] = ...
    FastTransformation: typing.ClassVar[Qt.TransformationMode] = ...
    FindChildrenRecursively: typing.ClassVar[Qt.FindChildOption] = ...
    FindDirectChildrenOnly: typing.ClassVar[Qt.FindChildOption] = ...
    FlatCap: typing.ClassVar[Qt.PenCapStyle] = ...
    FontRole: typing.ClassVar[Qt.ItemDataRole] = ...
    ForbiddenCursor: typing.ClassVar[Qt.CursorShape] = ...
    ForegroundRole: typing.ClassVar[Qt.ItemDataRole] = ...
    ForeignWindow: typing.ClassVar[Qt.WindowType] = ...
    ForwardButton: typing.ClassVar[Qt.MouseButton] = ...
    FramelessWindowHint: typing.ClassVar[Qt.WindowType] = ...
    Friday: typing.ClassVar[Qt.DayOfWeek] = ...
    FuzzyHit: typing.ClassVar[Qt.HitTestAccuracy] = ...
    GestureCanceled: typing.ClassVar[Qt.GestureState] = ...
    GestureFinished: typing.ClassVar[Qt.GestureState] = ...
    GestureStarted: typing.ClassVar[Qt.GestureState] = ...
    GestureUpdated: typing.ClassVar[Qt.GestureState] = ...
    GroupSwitchModifier: typing.ClassVar[Qt.KeyboardModifier] = ...
    HighEventPriority: typing.ClassVar[Qt.EventPriority] = ...
    HorPattern: typing.ClassVar[Qt.BrushStyle] = ...
    Horizontal: typing.ClassVar[Qt.Orientation] = ...
    IBeamCursor: typing.ClassVar[Qt.CursorShape] = ...
    ISODate: typing.ClassVar[Qt.DateFormat] = ...
    ISODateWithMs: typing.ClassVar[Qt.DateFormat] = ...
    IgnoreAction: typing.ClassVar[Qt.DropAction] = ...
    IgnoreAspectRatio: typing.ClassVar[Qt.AspectRatioMode] = ...
    IgnoredGesturesPropagateToParent: typing.ClassVar[Qt.GestureFlag] = ...
    ImAbsolutePosition: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImAnchorPosition: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImAnchorRectangle: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImCurrentSelection: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImCursorPosition: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImCursorRectangle: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImEnabled: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImEnterKeyType: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImFont: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImHints: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImInputItemClipRectangle: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImMaximumTextLength: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImMicroFocus: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImPlatformData: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImPreferredLanguage: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImQueryAll: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImQueryInput: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImSurroundingText: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImTextAfterCursor: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImTextBeforeCursor: typing.ClassVar[Qt.InputMethodQuery] = ...
    ImhDate: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhDialableCharactersOnly: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhDigitsOnly: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhEmailCharactersOnly: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhExclusiveInputMask: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhFormattedNumbersOnly: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhHiddenText: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhLatinOnly: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhLowercaseOnly: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhMultiLine: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhNoAutoUppercase: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhNoEditMenu: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhNoPredictiveText: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhNoTextHandles: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhNone: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhPreferLatin: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhPreferLowercase: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhPreferNumbers: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhPreferUppercase: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhSensitiveData: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhTime: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhUppercaseOnly: typing.ClassVar[Qt.InputMethodHint] = ...
    ImhUrlCharactersOnly: typing.ClassVar[Qt.InputMethodHint] = ...
    InitialSortOrderRole: typing.ClassVar[Qt.ItemDataRole] = ...
    IntersectClip: typing.ClassVar[Qt.ClipOperation] = ...
    IntersectsItemBoundingRect: typing.ClassVar[Qt.ItemSelectionMode] = ...
    IntersectsItemShape: typing.ClassVar[Qt.ItemSelectionMode] = ...
    InvertedLandscapeOrientation: typing.ClassVar[Qt.ScreenOrientation] = ...
    InvertedPortraitOrientation: typing.ClassVar[Qt.ScreenOrientation] = ...
    ItemIsAutoTristate: typing.ClassVar[Qt.ItemFlag] = ...
    ItemIsDragEnabled: typing.ClassVar[Qt.ItemFlag] = ...
    ItemIsDropEnabled: typing.ClassVar[Qt.ItemFlag] = ...
    ItemIsEditable: typing.ClassVar[Qt.ItemFlag] = ...
    ItemIsEnabled: typing.ClassVar[Qt.ItemFlag] = ...
    ItemIsSelectable: typing.ClassVar[Qt.ItemFlag] = ...
    ItemIsTristate: typing.ClassVar[Qt.ItemFlag] = ...
    ItemIsUserCheckable: typing.ClassVar[Qt.ItemFlag] = ...
    ItemIsUserTristate: typing.ClassVar[Qt.ItemFlag] = ...
    ItemNeverHasChildren: typing.ClassVar[Qt.ItemFlag] = ...
    KeepAspectRatio: typing.ClassVar[Qt.AspectRatioMode] = ...
    KeepAspectRatioByExpanding: typing.ClassVar[Qt.AspectRatioMode] = ...
    KeepEmptyParts: typing.ClassVar[Qt.SplitBehaviorFlags] = ...
    Key_0: typing.ClassVar[Qt.Key] = ...
    Key_1: typing.ClassVar[Qt.Key] = ...
    Key_2: typing.ClassVar[Qt.Key] = ...
    Key_3: typing.ClassVar[Qt.Key] = ...
    Key_4: typing.ClassVar[Qt.Key] = ...
    Key_5: typing.ClassVar[Qt.Key] = ...
    Key_6: typing.ClassVar[Qt.Key] = ...
    Key_7: typing.ClassVar[Qt.Key] = ...
    Key_8: typing.ClassVar[Qt.Key] = ...
    Key_9: typing.ClassVar[Qt.Key] = ...
    Key_A: typing.ClassVar[Qt.Key] = ...
    Key_AE: typing.ClassVar[Qt.Key] = ...
    Key_Aacute: typing.ClassVar[Qt.Key] = ...
    Key_Acircumflex: typing.ClassVar[Qt.Key] = ...
    Key_AddFavorite: typing.ClassVar[Qt.Key] = ...
    Key_Adiaeresis: typing.ClassVar[Qt.Key] = ...
    Key_Agrave: typing.ClassVar[Qt.Key] = ...
    Key_Alt: typing.ClassVar[Qt.Key] = ...
    Key_AltGr: typing.ClassVar[Qt.Key] = ...
    Key_Ampersand: typing.ClassVar[Qt.Key] = ...
    Key_Any: typing.ClassVar[Qt.Key] = ...
    Key_Apostrophe: typing.ClassVar[Qt.Key] = ...
    Key_ApplicationLeft: typing.ClassVar[Qt.Key] = ...
    Key_ApplicationRight: typing.ClassVar[Qt.Key] = ...
    Key_Aring: typing.ClassVar[Qt.Key] = ...
    Key_AsciiCircum: typing.ClassVar[Qt.Key] = ...
    Key_AsciiTilde: typing.ClassVar[Qt.Key] = ...
    Key_Asterisk: typing.ClassVar[Qt.Key] = ...
    Key_At: typing.ClassVar[Qt.Key] = ...
    Key_Atilde: typing.ClassVar[Qt.Key] = ...
    Key_AudioCycleTrack: typing.ClassVar[Qt.Key] = ...
    Key_AudioForward: typing.ClassVar[Qt.Key] = ...
    Key_AudioRandomPlay: typing.ClassVar[Qt.Key] = ...
    Key_AudioRepeat: typing.ClassVar[Qt.Key] = ...
    Key_AudioRewind: typing.ClassVar[Qt.Key] = ...
    Key_Away: typing.ClassVar[Qt.Key] = ...
    Key_B: typing.ClassVar[Qt.Key] = ...
    Key_Back: typing.ClassVar[Qt.Key] = ...
    Key_BackForward: typing.ClassVar[Qt.Key] = ...
    Key_Backslash: typing.ClassVar[Qt.Key] = ...
    Key_Backspace: typing.ClassVar[Qt.Key] = ...
    Key_Backtab: typing.ClassVar[Qt.Key] = ...
    Key_Bar: typing.ClassVar[Qt.Key] = ...
    Key_BassBoost: typing.ClassVar[Qt.Key] = ...
    Key_BassDown: typing.ClassVar[Qt.Key] = ...
    Key_BassUp: typing.ClassVar[Qt.Key] = ...
    Key_Battery: typing.ClassVar[Qt.Key] = ...
    Key_Blue: typing.ClassVar[Qt.Key] = ...
    Key_Bluetooth: typing.ClassVar[Qt.Key] = ...
    Key_Book: typing.ClassVar[Qt.Key] = ...
    Key_BraceLeft: typing.ClassVar[Qt.Key] = ...
    Key_BraceRight: typing.ClassVar[Qt.Key] = ...
    Key_BracketLeft: typing.ClassVar[Qt.Key] = ...
    Key_BracketRight: typing.ClassVar[Qt.Key] = ...
    Key_BrightnessAdjust: typing.ClassVar[Qt.Key] = ...
    Key_C: typing.ClassVar[Qt.Key] = ...
    Key_CD: typing.ClassVar[Qt.Key] = ...
    Key_Calculator: typing.ClassVar[Qt.Key] = ...
    Key_Calendar: typing.ClassVar[Qt.Key] = ...
    Key_Call: typing.ClassVar[Qt.Key] = ...
    Key_Camera: typing.ClassVar[Qt.Key] = ...
    Key_CameraFocus: typing.ClassVar[Qt.Key] = ...
    Key_Cancel: typing.ClassVar[Qt.Key] = ...
    Key_CapsLock: typing.ClassVar[Qt.Key] = ...
    Key_Ccedilla: typing.ClassVar[Qt.Key] = ...
    Key_ChannelDown: typing.ClassVar[Qt.Key] = ...
    Key_ChannelUp: typing.ClassVar[Qt.Key] = ...
    Key_Clear: typing.ClassVar[Qt.Key] = ...
    Key_ClearGrab: typing.ClassVar[Qt.Key] = ...
    Key_Close: typing.ClassVar[Qt.Key] = ...
    Key_Codeinput: typing.ClassVar[Qt.Key] = ...
    Key_Colon: typing.ClassVar[Qt.Key] = ...
    Key_Comma: typing.ClassVar[Qt.Key] = ...
    Key_Community: typing.ClassVar[Qt.Key] = ...
    Key_Context1: typing.ClassVar[Qt.Key] = ...
    Key_Context2: typing.ClassVar[Qt.Key] = ...
    Key_Context3: typing.ClassVar[Qt.Key] = ...
    Key_Context4: typing.ClassVar[Qt.Key] = ...
    Key_ContrastAdjust: typing.ClassVar[Qt.Key] = ...
    Key_Control: typing.ClassVar[Qt.Key] = ...
    Key_Copy: typing.ClassVar[Qt.Key] = ...
    Key_Cut: typing.ClassVar[Qt.Key] = ...
    Key_D: typing.ClassVar[Qt.Key] = ...
    Key_DOS: typing.ClassVar[Qt.Key] = ...
    Key_Dead_A: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Abovecomma: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Abovedot: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Abovereversedcomma: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Abovering: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Aboveverticalline: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Acute: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Belowbreve: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Belowcircumflex: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Belowcomma: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Belowdiaeresis: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Belowdot: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Belowmacron: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Belowring: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Belowtilde: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Belowverticalline: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Breve: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Capital_Schwa: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Caron: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Cedilla: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Circumflex: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Currency: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Diaeresis: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Doubleacute: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Doublegrave: typing.ClassVar[Qt.Key] = ...
    Key_Dead_E: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Grave: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Greek: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Hook: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Horn: typing.ClassVar[Qt.Key] = ...
    Key_Dead_I: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Invertedbreve: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Iota: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Longsolidusoverlay: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Lowline: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Macron: typing.ClassVar[Qt.Key] = ...
    Key_Dead_O: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Ogonek: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Semivoiced_Sound: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Small_Schwa: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Stroke: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Tilde: typing.ClassVar[Qt.Key] = ...
    Key_Dead_U: typing.ClassVar[Qt.Key] = ...
    Key_Dead_Voiced_Sound: typing.ClassVar[Qt.Key] = ...
    Key_Dead_a: typing.ClassVar[Qt.Key] = ...
    Key_Dead_e: typing.ClassVar[Qt.Key] = ...
    Key_Dead_i: typing.ClassVar[Qt.Key] = ...
    Key_Dead_o: typing.ClassVar[Qt.Key] = ...
    Key_Dead_u: typing.ClassVar[Qt.Key] = ...
    Key_Delete: typing.ClassVar[Qt.Key] = ...
    Key_Direction_L: typing.ClassVar[Qt.Key] = ...
    Key_Direction_R: typing.ClassVar[Qt.Key] = ...
    Key_Display: typing.ClassVar[Qt.Key] = ...
    Key_Documents: typing.ClassVar[Qt.Key] = ...
    Key_Dollar: typing.ClassVar[Qt.Key] = ...
    Key_Down: typing.ClassVar[Qt.Key] = ...
    Key_E: typing.ClassVar[Qt.Key] = ...
    Key_ETH: typing.ClassVar[Qt.Key] = ...
    Key_Eacute: typing.ClassVar[Qt.Key] = ...
    Key_Ecircumflex: typing.ClassVar[Qt.Key] = ...
    Key_Ediaeresis: typing.ClassVar[Qt.Key] = ...
    Key_Egrave: typing.ClassVar[Qt.Key] = ...
    Key_Eisu_Shift: typing.ClassVar[Qt.Key] = ...
    Key_Eisu_toggle: typing.ClassVar[Qt.Key] = ...
    Key_Eject: typing.ClassVar[Qt.Key] = ...
    Key_End: typing.ClassVar[Qt.Key] = ...
    Key_Enter: typing.ClassVar[Qt.Key] = ...
    Key_Equal: typing.ClassVar[Qt.Key] = ...
    Key_Escape: typing.ClassVar[Qt.Key] = ...
    Key_Excel: typing.ClassVar[Qt.Key] = ...
    Key_Exclam: typing.ClassVar[Qt.Key] = ...
    Key_Execute: typing.ClassVar[Qt.Key] = ...
    Key_Exit: typing.ClassVar[Qt.Key] = ...
    Key_Explorer: typing.ClassVar[Qt.Key] = ...
    Key_F: typing.ClassVar[Qt.Key] = ...
    Key_F1: typing.ClassVar[Qt.Key] = ...
    Key_F10: typing.ClassVar[Qt.Key] = ...
    Key_F11: typing.ClassVar[Qt.Key] = ...
    Key_F12: typing.ClassVar[Qt.Key] = ...
    Key_F13: typing.ClassVar[Qt.Key] = ...
    Key_F14: typing.ClassVar[Qt.Key] = ...
    Key_F15: typing.ClassVar[Qt.Key] = ...
    Key_F16: typing.ClassVar[Qt.Key] = ...
    Key_F17: typing.ClassVar[Qt.Key] = ...
    Key_F18: typing.ClassVar[Qt.Key] = ...
    Key_F19: typing.ClassVar[Qt.Key] = ...
    Key_F2: typing.ClassVar[Qt.Key] = ...
    Key_F20: typing.ClassVar[Qt.Key] = ...
    Key_F21: typing.ClassVar[Qt.Key] = ...
    Key_F22: typing.ClassVar[Qt.Key] = ...
    Key_F23: typing.ClassVar[Qt.Key] = ...
    Key_F24: typing.ClassVar[Qt.Key] = ...
    Key_F25: typing.ClassVar[Qt.Key] = ...
    Key_F26: typing.ClassVar[Qt.Key] = ...
    Key_F27: typing.ClassVar[Qt.Key] = ...
    Key_F28: typing.ClassVar[Qt.Key] = ...
    Key_F29: typing.ClassVar[Qt.Key] = ...
    Key_F3: typing.ClassVar[Qt.Key] = ...
    Key_F30: typing.ClassVar[Qt.Key] = ...
    Key_F31: typing.ClassVar[Qt.Key] = ...
    Key_F32: typing.ClassVar[Qt.Key] = ...
    Key_F33: typing.ClassVar[Qt.Key] = ...
    Key_F34: typing.ClassVar[Qt.Key] = ...
    Key_F35: typing.ClassVar[Qt.Key] = ...
    Key_F4: typing.ClassVar[Qt.Key] = ...
    Key_F5: typing.ClassVar[Qt.Key] = ...
    Key_F6: typing.ClassVar[Qt.Key] = ...
    Key_F7: typing.ClassVar[Qt.Key] = ...
    Key_F8: typing.ClassVar[Qt.Key] = ...
    Key_F9: typing.ClassVar[Qt.Key] = ...
    Key_Favorites: typing.ClassVar[Qt.Key] = ...
    Key_Finance: typing.ClassVar[Qt.Key] = ...
    Key_Find: typing.ClassVar[Qt.Key] = ...
    Key_Flip: typing.ClassVar[Qt.Key] = ...
    Key_Forward: typing.ClassVar[Qt.Key] = ...
    Key_G: typing.ClassVar[Qt.Key] = ...
    Key_Game: typing.ClassVar[Qt.Key] = ...
    Key_Go: typing.ClassVar[Qt.Key] = ...
    Key_Greater: typing.ClassVar[Qt.Key] = ...
    Key_Green: typing.ClassVar[Qt.Key] = ...
    Key_Guide: typing.ClassVar[Qt.Key] = ...
    Key_H: typing.ClassVar[Qt.Key] = ...
    Key_Hangul: typing.ClassVar[Qt.Key] = ...
    Key_Hangul_Banja: typing.ClassVar[Qt.Key] = ...
    Key_Hangul_End: typing.ClassVar[Qt.Key] = ...
    Key_Hangul_Hanja: typing.ClassVar[Qt.Key] = ...
    Key_Hangul_Jamo: typing.ClassVar[Qt.Key] = ...
    Key_Hangul_Jeonja: typing.ClassVar[Qt.Key] = ...
    Key_Hangul_PostHanja: typing.ClassVar[Qt.Key] = ...
    Key_Hangul_PreHanja: typing.ClassVar[Qt.Key] = ...
    Key_Hangul_Romaja: typing.ClassVar[Qt.Key] = ...
    Key_Hangul_Special: typing.ClassVar[Qt.Key] = ...
    Key_Hangul_Start: typing.ClassVar[Qt.Key] = ...
    Key_Hangup: typing.ClassVar[Qt.Key] = ...
    Key_Hankaku: typing.ClassVar[Qt.Key] = ...
    Key_Help: typing.ClassVar[Qt.Key] = ...
    Key_Henkan: typing.ClassVar[Qt.Key] = ...
    Key_Hibernate: typing.ClassVar[Qt.Key] = ...
    Key_Hiragana: typing.ClassVar[Qt.Key] = ...
    Key_Hiragana_Katakana: typing.ClassVar[Qt.Key] = ...
    Key_History: typing.ClassVar[Qt.Key] = ...
    Key_Home: typing.ClassVar[Qt.Key] = ...
    Key_HomePage: typing.ClassVar[Qt.Key] = ...
    Key_HotLinks: typing.ClassVar[Qt.Key] = ...
    Key_Hyper_L: typing.ClassVar[Qt.Key] = ...
    Key_Hyper_R: typing.ClassVar[Qt.Key] = ...
    Key_I: typing.ClassVar[Qt.Key] = ...
    Key_Iacute: typing.ClassVar[Qt.Key] = ...
    Key_Icircumflex: typing.ClassVar[Qt.Key] = ...
    Key_Idiaeresis: typing.ClassVar[Qt.Key] = ...
    Key_Igrave: typing.ClassVar[Qt.Key] = ...
    Key_Info: typing.ClassVar[Qt.Key] = ...
    Key_Insert: typing.ClassVar[Qt.Key] = ...
    Key_J: typing.ClassVar[Qt.Key] = ...
    Key_K: typing.ClassVar[Qt.Key] = ...
    Key_Kana_Lock: typing.ClassVar[Qt.Key] = ...
    Key_Kana_Shift: typing.ClassVar[Qt.Key] = ...
    Key_Kanji: typing.ClassVar[Qt.Key] = ...
    Key_Katakana: typing.ClassVar[Qt.Key] = ...
    Key_KeyboardBrightnessDown: typing.ClassVar[Qt.Key] = ...
    Key_KeyboardBrightnessUp: typing.ClassVar[Qt.Key] = ...
    Key_KeyboardLightOnOff: typing.ClassVar[Qt.Key] = ...
    Key_L: typing.ClassVar[Qt.Key] = ...
    Key_LastNumberRedial: typing.ClassVar[Qt.Key] = ...
    Key_Launch0: typing.ClassVar[Qt.Key] = ...
    Key_Launch1: typing.ClassVar[Qt.Key] = ...
    Key_Launch2: typing.ClassVar[Qt.Key] = ...
    Key_Launch3: typing.ClassVar[Qt.Key] = ...
    Key_Launch4: typing.ClassVar[Qt.Key] = ...
    Key_Launch5: typing.ClassVar[Qt.Key] = ...
    Key_Launch6: typing.ClassVar[Qt.Key] = ...
    Key_Launch7: typing.ClassVar[Qt.Key] = ...
    Key_Launch8: typing.ClassVar[Qt.Key] = ...
    Key_Launch9: typing.ClassVar[Qt.Key] = ...
    Key_LaunchA: typing.ClassVar[Qt.Key] = ...
    Key_LaunchB: typing.ClassVar[Qt.Key] = ...
    Key_LaunchC: typing.ClassVar[Qt.Key] = ...
    Key_LaunchD: typing.ClassVar[Qt.Key] = ...
    Key_LaunchE: typing.ClassVar[Qt.Key] = ...
    Key_LaunchF: typing.ClassVar[Qt.Key] = ...
    Key_LaunchG: typing.ClassVar[Qt.Key] = ...
    Key_LaunchH: typing.ClassVar[Qt.Key] = ...
    Key_LaunchMail: typing.ClassVar[Qt.Key] = ...
    Key_LaunchMedia: typing.ClassVar[Qt.Key] = ...
    Key_Left: typing.ClassVar[Qt.Key] = ...
    Key_Less: typing.ClassVar[Qt.Key] = ...
    Key_LightBulb: typing.ClassVar[Qt.Key] = ...
    Key_LogOff: typing.ClassVar[Qt.Key] = ...
    Key_M: typing.ClassVar[Qt.Key] = ...
    Key_MailForward: typing.ClassVar[Qt.Key] = ...
    Key_Market: typing.ClassVar[Qt.Key] = ...
    Key_Massyo: typing.ClassVar[Qt.Key] = ...
    Key_MediaLast: typing.ClassVar[Qt.Key] = ...
    Key_MediaNext: typing.ClassVar[Qt.Key] = ...
    Key_MediaPause: typing.ClassVar[Qt.Key] = ...
    Key_MediaPlay: typing.ClassVar[Qt.Key] = ...
    Key_MediaPrevious: typing.ClassVar[Qt.Key] = ...
    Key_MediaRecord: typing.ClassVar[Qt.Key] = ...
    Key_MediaStop: typing.ClassVar[Qt.Key] = ...
    Key_MediaTogglePlayPause: typing.ClassVar[Qt.Key] = ...
    Key_Meeting: typing.ClassVar[Qt.Key] = ...
    Key_Memo: typing.ClassVar[Qt.Key] = ...
    Key_Menu: typing.ClassVar[Qt.Key] = ...
    Key_MenuKB: typing.ClassVar[Qt.Key] = ...
    Key_MenuPB: typing.ClassVar[Qt.Key] = ...
    Key_Messenger: typing.ClassVar[Qt.Key] = ...
    Key_Meta: typing.ClassVar[Qt.Key] = ...
    Key_MicMute: typing.ClassVar[Qt.Key] = ...
    Key_MicVolumeDown: typing.ClassVar[Qt.Key] = ...
    Key_MicVolumeUp: typing.ClassVar[Qt.Key] = ...
    Key_Minus: typing.ClassVar[Qt.Key] = ...
    Key_Mode_switch: typing.ClassVar[Qt.Key] = ...
    Key_MonBrightnessDown: typing.ClassVar[Qt.Key] = ...
    Key_MonBrightnessUp: typing.ClassVar[Qt.Key] = ...
    Key_Muhenkan: typing.ClassVar[Qt.Key] = ...
    Key_Multi_key: typing.ClassVar[Qt.Key] = ...
    Key_MultipleCandidate: typing.ClassVar[Qt.Key] = ...
    Key_Music: typing.ClassVar[Qt.Key] = ...
    Key_MySites: typing.ClassVar[Qt.Key] = ...
    Key_N: typing.ClassVar[Qt.Key] = ...
    Key_New: typing.ClassVar[Qt.Key] = ...
    Key_News: typing.ClassVar[Qt.Key] = ...
    Key_No: typing.ClassVar[Qt.Key] = ...
    Key_Ntilde: typing.ClassVar[Qt.Key] = ...
    Key_NumLock: typing.ClassVar[Qt.Key] = ...
    Key_NumberSign: typing.ClassVar[Qt.Key] = ...
    Key_O: typing.ClassVar[Qt.Key] = ...
    Key_Oacute: typing.ClassVar[Qt.Key] = ...
    Key_Ocircumflex: typing.ClassVar[Qt.Key] = ...
    Key_Odiaeresis: typing.ClassVar[Qt.Key] = ...
    Key_OfficeHome: typing.ClassVar[Qt.Key] = ...
    Key_Ograve: typing.ClassVar[Qt.Key] = ...
    Key_Ooblique: typing.ClassVar[Qt.Key] = ...
    Key_Open: typing.ClassVar[Qt.Key] = ...
    Key_OpenUrl: typing.ClassVar[Qt.Key] = ...
    Key_Option: typing.ClassVar[Qt.Key] = ...
    Key_Otilde: typing.ClassVar[Qt.Key] = ...
    Key_P: typing.ClassVar[Qt.Key] = ...
    Key_PageDown: typing.ClassVar[Qt.Key] = ...
    Key_PageUp: typing.ClassVar[Qt.Key] = ...
    Key_ParenLeft: typing.ClassVar[Qt.Key] = ...
    Key_ParenRight: typing.ClassVar[Qt.Key] = ...
    Key_Paste: typing.ClassVar[Qt.Key] = ...
    Key_Pause: typing.ClassVar[Qt.Key] = ...
    Key_Percent: typing.ClassVar[Qt.Key] = ...
    Key_Period: typing.ClassVar[Qt.Key] = ...
    Key_Phone: typing.ClassVar[Qt.Key] = ...
    Key_Pictures: typing.ClassVar[Qt.Key] = ...
    Key_Play: typing.ClassVar[Qt.Key] = ...
    Key_Plus: typing.ClassVar[Qt.Key] = ...
    Key_PowerDown: typing.ClassVar[Qt.Key] = ...
    Key_PowerOff: typing.ClassVar[Qt.Key] = ...
    Key_PreviousCandidate: typing.ClassVar[Qt.Key] = ...
    Key_Print: typing.ClassVar[Qt.Key] = ...
    Key_Printer: typing.ClassVar[Qt.Key] = ...
    Key_Q: typing.ClassVar[Qt.Key] = ...
    Key_Question: typing.ClassVar[Qt.Key] = ...
    Key_QuoteDbl: typing.ClassVar[Qt.Key] = ...
    Key_QuoteLeft: typing.ClassVar[Qt.Key] = ...
    Key_R: typing.ClassVar[Qt.Key] = ...
    Key_Red: typing.ClassVar[Qt.Key] = ...
    Key_Redo: typing.ClassVar[Qt.Key] = ...
    Key_Refresh: typing.ClassVar[Qt.Key] = ...
    Key_Reload: typing.ClassVar[Qt.Key] = ...
    Key_Reply: typing.ClassVar[Qt.Key] = ...
    Key_Return: typing.ClassVar[Qt.Key] = ...
    Key_Right: typing.ClassVar[Qt.Key] = ...
    Key_Romaji: typing.ClassVar[Qt.Key] = ...
    Key_RotateWindows: typing.ClassVar[Qt.Key] = ...
    Key_RotationKB: typing.ClassVar[Qt.Key] = ...
    Key_RotationPB: typing.ClassVar[Qt.Key] = ...
    Key_S: typing.ClassVar[Qt.Key] = ...
    Key_Save: typing.ClassVar[Qt.Key] = ...
    Key_ScreenSaver: typing.ClassVar[Qt.Key] = ...
    Key_ScrollLock: typing.ClassVar[Qt.Key] = ...
    Key_Search: typing.ClassVar[Qt.Key] = ...
    Key_Select: typing.ClassVar[Qt.Key] = ...
    Key_Semicolon: typing.ClassVar[Qt.Key] = ...
    Key_Send: typing.ClassVar[Qt.Key] = ...
    Key_Settings: typing.ClassVar[Qt.Key] = ...
    Key_Shift: typing.ClassVar[Qt.Key] = ...
    Key_Shop: typing.ClassVar[Qt.Key] = ...
    Key_SingleCandidate: typing.ClassVar[Qt.Key] = ...
    Key_Slash: typing.ClassVar[Qt.Key] = ...
    Key_Sleep: typing.ClassVar[Qt.Key] = ...
    Key_Space: typing.ClassVar[Qt.Key] = ...
    Key_Spell: typing.ClassVar[Qt.Key] = ...
    Key_SplitScreen: typing.ClassVar[Qt.Key] = ...
    Key_Standby: typing.ClassVar[Qt.Key] = ...
    Key_Stop: typing.ClassVar[Qt.Key] = ...
    Key_Subtitle: typing.ClassVar[Qt.Key] = ...
    Key_Super_L: typing.ClassVar[Qt.Key] = ...
    Key_Super_R: typing.ClassVar[Qt.Key] = ...
    Key_Support: typing.ClassVar[Qt.Key] = ...
    Key_Suspend: typing.ClassVar[Qt.Key] = ...
    Key_SysReq: typing.ClassVar[Qt.Key] = ...
    Key_T: typing.ClassVar[Qt.Key] = ...
    Key_THORN: typing.ClassVar[Qt.Key] = ...
    Key_Tab: typing.ClassVar[Qt.Key] = ...
    Key_TaskPane: typing.ClassVar[Qt.Key] = ...
    Key_Terminal: typing.ClassVar[Qt.Key] = ...
    Key_Time: typing.ClassVar[Qt.Key] = ...
    Key_ToDoList: typing.ClassVar[Qt.Key] = ...
    Key_ToggleCallHangup: typing.ClassVar[Qt.Key] = ...
    Key_Tools: typing.ClassVar[Qt.Key] = ...
    Key_TopMenu: typing.ClassVar[Qt.Key] = ...
    Key_TouchpadOff: typing.ClassVar[Qt.Key] = ...
    Key_TouchpadOn: typing.ClassVar[Qt.Key] = ...
    Key_TouchpadToggle: typing.ClassVar[Qt.Key] = ...
    Key_Touroku: typing.ClassVar[Qt.Key] = ...
    Key_Travel: typing.ClassVar[Qt.Key] = ...
    Key_TrebleDown: typing.ClassVar[Qt.Key] = ...
    Key_TrebleUp: typing.ClassVar[Qt.Key] = ...
    Key_U: typing.ClassVar[Qt.Key] = ...
    Key_UWB: typing.ClassVar[Qt.Key] = ...
    Key_Uacute: typing.ClassVar[Qt.Key] = ...
    Key_Ucircumflex: typing.ClassVar[Qt.Key] = ...
    Key_Udiaeresis: typing.ClassVar[Qt.Key] = ...
    Key_Ugrave: typing.ClassVar[Qt.Key] = ...
    Key_Underscore: typing.ClassVar[Qt.Key] = ...
    Key_Undo: typing.ClassVar[Qt.Key] = ...
    Key_Up: typing.ClassVar[Qt.Key] = ...
    Key_V: typing.ClassVar[Qt.Key] = ...
    Key_Video: typing.ClassVar[Qt.Key] = ...
    Key_View: typing.ClassVar[Qt.Key] = ...
    Key_VoiceDial: typing.ClassVar[Qt.Key] = ...
    Key_VolumeDown: typing.ClassVar[Qt.Key] = ...
    Key_VolumeMute: typing.ClassVar[Qt.Key] = ...
    Key_VolumeUp: typing.ClassVar[Qt.Key] = ...
    Key_W: typing.ClassVar[Qt.Key] = ...
    Key_WLAN: typing.ClassVar[Qt.Key] = ...
    Key_WWW: typing.ClassVar[Qt.Key] = ...
    Key_WakeUp: typing.ClassVar[Qt.Key] = ...
    Key_WebCam: typing.ClassVar[Qt.Key] = ...
    Key_Word: typing.ClassVar[Qt.Key] = ...
    Key_X: typing.ClassVar[Qt.Key] = ...
    Key_Xfer: typing.ClassVar[Qt.Key] = ...
    Key_Y: typing.ClassVar[Qt.Key] = ...
    Key_Yacute: typing.ClassVar[Qt.Key] = ...
    Key_Yellow: typing.ClassVar[Qt.Key] = ...
    Key_Yes: typing.ClassVar[Qt.Key] = ...
    Key_Z: typing.ClassVar[Qt.Key] = ...
    Key_Zenkaku: typing.ClassVar[Qt.Key] = ...
    Key_Zenkaku_Hankaku: typing.ClassVar[Qt.Key] = ...
    Key_Zoom: typing.ClassVar[Qt.Key] = ...
    Key_ZoomIn: typing.ClassVar[Qt.Key] = ...
    Key_ZoomOut: typing.ClassVar[Qt.Key] = ...
    Key_acute: typing.ClassVar[Qt.Key] = ...
    Key_brokenbar: typing.ClassVar[Qt.Key] = ...
    Key_cedilla: typing.ClassVar[Qt.Key] = ...
    Key_cent: typing.ClassVar[Qt.Key] = ...
    Key_copyright: typing.ClassVar[Qt.Key] = ...
    Key_currency: typing.ClassVar[Qt.Key] = ...
    Key_degree: typing.ClassVar[Qt.Key] = ...
    Key_diaeresis: typing.ClassVar[Qt.Key] = ...
    Key_division: typing.ClassVar[Qt.Key] = ...
    Key_exclamdown: typing.ClassVar[Qt.Key] = ...
    Key_guillemotleft: typing.ClassVar[Qt.Key] = ...
    Key_guillemotright: typing.ClassVar[Qt.Key] = ...
    Key_hyphen: typing.ClassVar[Qt.Key] = ...
    Key_iTouch: typing.ClassVar[Qt.Key] = ...
    Key_macron: typing.ClassVar[Qt.Key] = ...
    Key_masculine: typing.ClassVar[Qt.Key] = ...
    Key_mu: typing.ClassVar[Qt.Key] = ...
    Key_multiply: typing.ClassVar[Qt.Key] = ...
    Key_nobreakspace: typing.ClassVar[Qt.Key] = ...
    Key_notsign: typing.ClassVar[Qt.Key] = ...
    Key_onehalf: typing.ClassVar[Qt.Key] = ...
    Key_onequarter: typing.ClassVar[Qt.Key] = ...
    Key_onesuperior: typing.ClassVar[Qt.Key] = ...
    Key_ordfeminine: typing.ClassVar[Qt.Key] = ...
    Key_paragraph: typing.ClassVar[Qt.Key] = ...
    Key_periodcentered: typing.ClassVar[Qt.Key] = ...
    Key_plusminus: typing.ClassVar[Qt.Key] = ...
    Key_questiondown: typing.ClassVar[Qt.Key] = ...
    Key_registered: typing.ClassVar[Qt.Key] = ...
    Key_section: typing.ClassVar[Qt.Key] = ...
    Key_ssharp: typing.ClassVar[Qt.Key] = ...
    Key_sterling: typing.ClassVar[Qt.Key] = ...
    Key_threequarters: typing.ClassVar[Qt.Key] = ...
    Key_threesuperior: typing.ClassVar[Qt.Key] = ...
    Key_twosuperior: typing.ClassVar[Qt.Key] = ...
    Key_unknown: typing.ClassVar[Qt.Key] = ...
    Key_ydiaeresis: typing.ClassVar[Qt.Key] = ...
    Key_yen: typing.ClassVar[Qt.Key] = ...
    KeyboardModifierMask: typing.ClassVar[Qt.KeyboardModifier] = ...
    KeypadModifier: typing.ClassVar[Qt.KeyboardModifier] = ...
    LandscapeOrientation: typing.ClassVar[Qt.ScreenOrientation] = ...
    LastCursor: typing.ClassVar[Qt.CursorShape] = ...
    LastGestureType: typing.ClassVar[Qt.GestureType] = ...
    LayoutDirectionAuto: typing.ClassVar[Qt.LayoutDirection] = ...
    LeftArrow: typing.ClassVar[Qt.ArrowType] = ...
    LeftButton: typing.ClassVar[Qt.MouseButton] = ...
    LeftDockWidgetArea: typing.ClassVar[Qt.DockWidgetArea] = ...
    LeftEdge: typing.ClassVar[Qt.Edge] = ...
    LeftSection: typing.ClassVar[Qt.WindowFrameSection] = ...
    LeftToRight: typing.ClassVar[Qt.LayoutDirection] = ...
    LeftToolBarArea: typing.ClassVar[Qt.ToolBarArea] = ...
    LinearGradientPattern: typing.ClassVar[Qt.BrushStyle] = ...
    LinkAction: typing.ClassVar[Qt.DropAction] = ...
    LinksAccessibleByKeyboard: typing.ClassVar[Qt.TextInteractionFlag] = ...
    LinksAccessibleByMouse: typing.ClassVar[Qt.TextInteractionFlag] = ...
    LocalDate: typing.ClassVar[Qt.DateFormat] = ...
    LocalTime: typing.ClassVar[Qt.TimeSpec] = ...
    LocaleDate: typing.ClassVar[Qt.DateFormat] = ...
    LogicalCoordinates: typing.ClassVar[Qt.CoordinateSystem] = ...
    LogicalMoveStyle: typing.ClassVar[Qt.CursorMoveStyle] = ...
    LowEventPriority: typing.ClassVar[Qt.EventPriority] = ...
    META: typing.ClassVar[Qt.Modifier] = ...
    MODIFIER_MASK: typing.ClassVar[Qt.Modifier] = ...
    MPenCapStyle: typing.ClassVar[Qt.PenCapStyle] = ...
    MPenJoinStyle: typing.ClassVar[Qt.PenJoinStyle] = ...
    MPenStyle: typing.ClassVar[Qt.PenStyle] = ...
    MSWindowsFixedSizeDialogHint: typing.ClassVar[Qt.WindowType] = ...
    MSWindowsOwnDC: typing.ClassVar[Qt.WindowType] = ...
    MacWindowToolBarButtonHint: typing.ClassVar[Qt.WindowType] = ...
    MarkdownText: typing.ClassVar[Qt.TextFormat] = ...
    MaskInColor: typing.ClassVar[Qt.MaskMode] = ...
    MaskOutColor: typing.ClassVar[Qt.MaskMode] = ...
    MatchCaseSensitive: typing.ClassVar[Qt.MatchFlag] = ...
    MatchContains: typing.ClassVar[Qt.MatchFlag] = ...
    MatchEndsWith: typing.ClassVar[Qt.MatchFlag] = ...
    MatchExactly: typing.ClassVar[Qt.MatchFlag] = ...
    MatchFixedString: typing.ClassVar[Qt.MatchFlag] = ...
    MatchRecursive: typing.ClassVar[Qt.MatchFlag] = ...
    MatchRegExp: typing.ClassVar[Qt.MatchFlag] = ...
    MatchRegularExpression: typing.ClassVar[Qt.MatchFlag] = ...
    MatchStartsWith: typing.ClassVar[Qt.MatchFlag] = ...
    MatchWildcard: typing.ClassVar[Qt.MatchFlag] = ...
    MatchWrap: typing.ClassVar[Qt.MatchFlag] = ...
    MaxMouseButton: typing.ClassVar[Qt.MouseButton] = ...
    MaximizeUsingFullscreenGeometryHint: typing.ClassVar[Qt.WindowType] = ...
    MaximumSize: typing.ClassVar[Qt.SizeHint] = ...
    MenuBarFocusReason: typing.ClassVar[Qt.FocusReason] = ...
    MetaModifier: typing.ClassVar[Qt.KeyboardModifier] = ...
    MidButton: typing.ClassVar[Qt.MouseButton] = ...
    MiddleButton: typing.ClassVar[Qt.MouseButton] = ...
    MinimumDescent: typing.ClassVar[Qt.SizeHint] = ...
    MinimumSize: typing.ClassVar[Qt.SizeHint] = ...
    MiterJoin: typing.ClassVar[Qt.PenJoinStyle] = ...
    Monday: typing.ClassVar[Qt.DayOfWeek] = ...
    MonoOnly: typing.ClassVar[Qt.ImageConversionFlag] = ...
    MouseButtonMask: typing.ClassVar[Qt.MouseButton] = ...
    MouseEventCreatedDoubleClick: typing.ClassVar[Qt.MouseEventFlag] = ...
    MouseEventFlagMask: typing.ClassVar[Qt.MouseEventFlag] = ...
    MouseEventNotSynthesized: typing.ClassVar[Qt.MouseEventSource] = ...
    MouseEventSynthesizedByApplication: typing.ClassVar[Qt.MouseEventSource] = ...
    MouseEventSynthesizedByQt: typing.ClassVar[Qt.MouseEventSource] = ...
    MouseEventSynthesizedBySystem: typing.ClassVar[Qt.MouseEventSource] = ...
    MouseFocusReason: typing.ClassVar[Qt.FocusReason] = ...
    MoveAction: typing.ClassVar[Qt.DropAction] = ...
    NDockWidgetAreas: typing.ClassVar[Qt.DockWidgetAreaSizes] = ...
    NSizeHints: typing.ClassVar[Qt.SizeHint] = ...
    NToolBarAreas: typing.ClassVar[Qt.ToolBarAreaSizes] = ...
    NavigationModeCursorAuto: typing.ClassVar[Qt.NavigationMode] = ...
    NavigationModeCursorForceVisible: typing.ClassVar[Qt.NavigationMode] = ...
    NavigationModeKeypadDirectional: typing.ClassVar[Qt.NavigationMode] = ...
    NavigationModeKeypadTabOrder: typing.ClassVar[Qt.NavigationMode] = ...
    NavigationModeNone: typing.ClassVar[Qt.NavigationMode] = ...
    NoAlpha: typing.ClassVar[Qt.ImageConversionFlag] = ...
    NoArrow: typing.ClassVar[Qt.ArrowType] = ...
    NoBrush: typing.ClassVar[Qt.BrushStyle] = ...
    NoButton: typing.ClassVar[Qt.MouseButton] = ...
    NoClip: typing.ClassVar[Qt.ClipOperation] = ...
    NoContextMenu: typing.ClassVar[Qt.ContextMenuPolicy] = ...
    NoDockWidgetArea: typing.ClassVar[Qt.DockWidgetArea] = ...
    NoDropShadowWindowHint: typing.ClassVar[Qt.WindowType] = ...
    NoFocus: typing.ClassVar[Qt.FocusPolicy] = ...
    NoFocusReason: typing.ClassVar[Qt.FocusReason] = ...
    NoFormatConversion: typing.ClassVar[Qt.ImageConversionFlag] = ...
    NoGesture: typing.ClassVar[Qt.GestureState] = ...
    NoItemFlags: typing.ClassVar[Qt.ItemFlag] = ...
    NoModifier: typing.ClassVar[Qt.KeyboardModifier] = ...
    NoOpaqueDetection: typing.ClassVar[Qt.ImageConversionFlag] = ...
    NoPen: typing.ClassVar[Qt.PenStyle] = ...
    NoScrollPhase: typing.ClassVar[Qt.ScrollPhase] = ...
    NoSection: typing.ClassVar[Qt.WindowFrameSection] = ...
    NoTabFocus: typing.ClassVar[Qt.TabFocusBehavior] = ...
    NoTextInteraction: typing.ClassVar[Qt.TextInteractionFlag] = ...
    NoToolBarArea: typing.ClassVar[Qt.ToolBarArea] = ...
    NonModal: typing.ClassVar[Qt.WindowModality] = ...
    NormalEventPriority: typing.ClassVar[Qt.EventPriority] = ...
    OddEvenFill: typing.ClassVar[Qt.FillRule] = ...
    OffsetFromUTC: typing.ClassVar[Qt.TimeSpec] = ...
    OpaqueMode: typing.ClassVar[Qt.BGMode] = ...
    OpenHandCursor: typing.ClassVar[Qt.CursorShape] = ...
    OrderedAlphaDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
    OrderedDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
    OtherFocusReason: typing.ClassVar[Qt.FocusReason] = ...
    PanGesture: typing.ClassVar[Qt.GestureType] = ...
    PanNativeGesture: typing.ClassVar[Qt.NativeGestureType] = ...
    PartiallyChecked: typing.ClassVar[Qt.CheckState] = ...
    PinchGesture: typing.ClassVar[Qt.GestureType] = ...
    PlainText: typing.ClassVar[Qt.TextFormat] = ...
    PointingHandCursor: typing.ClassVar[Qt.CursorShape] = ...
    Popup: typing.ClassVar[Qt.WindowType] = ...
    PopupFocusReason: typing.ClassVar[Qt.FocusReason] = ...
    PortraitOrientation: typing.ClassVar[Qt.ScreenOrientation] = ...
    PreciseTimer: typing.ClassVar[Qt.TimerType] = ...
    PreferDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
    PreferredSize: typing.ClassVar[Qt.SizeHint] = ...
    PreventContextMenu: typing.ClassVar[Qt.ContextMenuPolicy] = ...
    PrimaryOrientation: typing.ClassVar[Qt.ScreenOrientation] = ...
    QueuedConnection: typing.ClassVar[Qt.ConnectionType] = ...
    RFC2822Date: typing.ClassVar[Qt.DateFormat] = ...
    RadialGradientPattern: typing.ClassVar[Qt.BrushStyle] = ...
    ReceivePartialGestures: typing.ClassVar[Qt.GestureFlag] = ...
    RelativeSize: typing.ClassVar[Qt.SizeMode] = ...
    RepeatTile: typing.ClassVar[Qt.TileRule] = ...
    ReplaceClip: typing.ClassVar[Qt.ClipOperation] = ...
    ReplaceSelection: typing.ClassVar[Qt.ItemSelectionOperation] = ...
    RichText: typing.ClassVar[Qt.TextFormat] = ...
    RightArrow: typing.ClassVar[Qt.ArrowType] = ...
    RightButton: typing.ClassVar[Qt.MouseButton] = ...
    RightDockWidgetArea: typing.ClassVar[Qt.DockWidgetArea] = ...
    RightEdge: typing.ClassVar[Qt.Edge] = ...
    RightSection: typing.ClassVar[Qt.WindowFrameSection] = ...
    RightToLeft: typing.ClassVar[Qt.LayoutDirection] = ...
    RightToolBarArea: typing.ClassVar[Qt.ToolBarArea] = ...
    RotateNativeGesture: typing.ClassVar[Qt.NativeGestureType] = ...
    RoundCap: typing.ClassVar[Qt.PenCapStyle] = ...
    RoundJoin: typing.ClassVar[Qt.PenJoinStyle] = ...
    RoundTile: typing.ClassVar[Qt.TileRule] = ...
    SHIFT: typing.ClassVar[Qt.Modifier] = ...
    Saturday: typing.ClassVar[Qt.DayOfWeek] = ...
    ScrollBarAlwaysOff: typing.ClassVar[Qt.ScrollBarPolicy] = ...
    ScrollBarAlwaysOn: typing.ClassVar[Qt.ScrollBarPolicy] = ...
    ScrollBarAsNeeded: typing.ClassVar[Qt.ScrollBarPolicy] = ...
    ScrollBegin: typing.ClassVar[Qt.ScrollPhase] = ...
    ScrollEnd: typing.ClassVar[Qt.ScrollPhase] = ...
    ScrollMomentum: typing.ClassVar[Qt.ScrollPhase] = ...
    ScrollUpdate: typing.ClassVar[Qt.ScrollPhase] = ...
    Sheet: typing.ClassVar[Qt.WindowType] = ...
    ShiftModifier: typing.ClassVar[Qt.KeyboardModifier] = ...
    ShortcutFocusReason: typing.ClassVar[Qt.FocusReason] = ...
    SizeAllCursor: typing.ClassVar[Qt.CursorShape] = ...
    SizeBDiagCursor: typing.ClassVar[Qt.CursorShape] = ...
    SizeFDiagCursor: typing.ClassVar[Qt.CursorShape] = ...
    SizeHintRole: typing.ClassVar[Qt.ItemDataRole] = ...
    SizeHorCursor: typing.ClassVar[Qt.CursorShape] = ...
    SizeVerCursor: typing.ClassVar[Qt.CursorShape] = ...
    SkipEmptyParts: typing.ClassVar[Qt.SplitBehaviorFlags] = ...
    SmartZoomNativeGesture: typing.ClassVar[Qt.NativeGestureType] = ...
    SmoothTransformation: typing.ClassVar[Qt.TransformationMode] = ...
    SolidLine: typing.ClassVar[Qt.PenStyle] = ...
    SolidPattern: typing.ClassVar[Qt.BrushStyle] = ...
    SplashScreen: typing.ClassVar[Qt.WindowType] = ...
    SplitHCursor: typing.ClassVar[Qt.CursorShape] = ...
    SplitVCursor: typing.ClassVar[Qt.CursorShape] = ...
    SquareCap: typing.ClassVar[Qt.PenCapStyle] = ...
    StatusTipPropertyRole: typing.ClassVar[Qt.ItemDataRole] = ...
    StatusTipRole: typing.ClassVar[Qt.ItemDataRole] = ...
    StretchTile: typing.ClassVar[Qt.TileRule] = ...
    StrongFocus: typing.ClassVar[Qt.FocusPolicy] = ...
    SubWindow: typing.ClassVar[Qt.WindowType] = ...
    Sunday: typing.ClassVar[Qt.DayOfWeek] = ...
    SvgMiterJoin: typing.ClassVar[Qt.PenJoinStyle] = ...
    SwipeGesture: typing.ClassVar[Qt.GestureType] = ...
    SwipeNativeGesture: typing.ClassVar[Qt.NativeGestureType] = ...
    SystemLocaleDate: typing.ClassVar[Qt.DateFormat] = ...
    SystemLocaleLongDate: typing.ClassVar[Qt.DateFormat] = ...
    SystemLocaleShortDate: typing.ClassVar[Qt.DateFormat] = ...
    TabFocus: typing.ClassVar[Qt.FocusPolicy] = ...
    TabFocusAllControls: typing.ClassVar[Qt.TabFocusBehavior] = ...
    TabFocusListControls: typing.ClassVar[Qt.TabFocusBehavior] = ...
    TabFocusReason: typing.ClassVar[Qt.FocusReason] = ...
    TabFocusTextControls: typing.ClassVar[Qt.TabFocusBehavior] = ...
    TapAndHoldGesture: typing.ClassVar[Qt.GestureType] = ...
    TapGesture: typing.ClassVar[Qt.GestureType] = ...
    TargetMoveAction: typing.ClassVar[Qt.DropAction] = ...
    TaskButton: typing.ClassVar[Qt.MouseButton] = ...
    TextAlignmentRole: typing.ClassVar[Qt.ItemDataRole] = ...
    TextBrowserInteraction: typing.ClassVar[Qt.TextInteractionFlag] = ...
    TextBypassShaping: typing.ClassVar[Qt.TextFlag] = ...
    TextColorRole: typing.ClassVar[Qt.ItemDataRole] = ...
    TextDate: typing.ClassVar[Qt.DateFormat] = ...
    TextDontClip: typing.ClassVar[Qt.TextFlag] = ...
    TextDontPrint: typing.ClassVar[Qt.TextFlag] = ...
    TextEditable: typing.ClassVar[Qt.TextInteractionFlag] = ...
    TextEditorInteraction: typing.ClassVar[Qt.TextInteractionFlag] = ...
    TextExpandTabs: typing.ClassVar[Qt.TextFlag] = ...
    TextForceLeftToRight: typing.ClassVar[Qt.TextFlag] = ...
    TextForceRightToLeft: typing.ClassVar[Qt.TextFlag] = ...
    TextHideMnemonic: typing.ClassVar[Qt.TextFlag] = ...
    TextIncludeTrailingSpaces: typing.ClassVar[Qt.TextFlag] = ...
    TextJustificationForced: typing.ClassVar[Qt.TextFlag] = ...
    TextLongestVariant: typing.ClassVar[Qt.TextFlag] = ...
    TextSelectableByKeyboard: typing.ClassVar[Qt.TextInteractionFlag] = ...
    TextSelectableByMouse: typing.ClassVar[Qt.TextInteractionFlag] = ...
    TextShowMnemonic: typing.ClassVar[Qt.TextFlag] = ...
    TextSingleLine: typing.ClassVar[Qt.TextFlag] = ...
    TextWordWrap: typing.ClassVar[Qt.TextFlag] = ...
    TextWrapAnywhere: typing.ClassVar[Qt.TextFlag] = ...
    TexturePattern: typing.ClassVar[Qt.BrushStyle] = ...
    ThresholdAlphaDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
    ThresholdDither: typing.ClassVar[Qt.ImageConversionFlag] = ...
    Thursday: typing.ClassVar[Qt.DayOfWeek] = ...
    TimeZone: typing.ClassVar[Qt.TimeSpec] = ...
    TitleBarArea: typing.ClassVar[Qt.WindowFrameSection] = ...
    Tool: typing.ClassVar[Qt.WindowType] = ...
    ToolBarArea_Mask: typing.ClassVar[Qt.ToolBarArea] = ...
    ToolButtonFollowStyle: typing.ClassVar[Qt.ToolButtonStyle] = ...
    ToolButtonIconOnly: typing.ClassVar[Qt.ToolButtonStyle] = ...
    ToolButtonTextBesideIcon: typing.ClassVar[Qt.ToolButtonStyle] = ...
    ToolButtonTextOnly: typing.ClassVar[Qt.ToolButtonStyle] = ...
    ToolButtonTextUnderIcon: typing.ClassVar[Qt.ToolButtonStyle] = ...
    ToolTip: typing.ClassVar[Qt.WindowType] = ...
    ToolTipPropertyRole: typing.ClassVar[Qt.ItemDataRole] = ...
    ToolTipRole: typing.ClassVar[Qt.ItemDataRole] = ...
    TopDockWidgetArea: typing.ClassVar[Qt.DockWidgetArea] = ...
    TopEdge: typing.ClassVar[Qt.Edge] = ...
    TopLeftCorner: typing.ClassVar[Qt.Corner] = ...
    TopLeftSection: typing.ClassVar[Qt.WindowFrameSection] = ...
    TopRightCorner: typing.ClassVar[Qt.Corner] = ...
    TopRightSection: typing.ClassVar[Qt.WindowFrameSection] = ...
    TopSection: typing.ClassVar[Qt.WindowFrameSection] = ...
    TopToolBarArea: typing.ClassVar[Qt.ToolBarArea] = ...
    TouchPointMoved: typing.ClassVar[Qt.TouchPointState] = ...
    TouchPointPressed: typing.ClassVar[Qt.TouchPointState] = ...
    TouchPointReleased: typing.ClassVar[Qt.TouchPointState] = ...
    TouchPointStationary: typing.ClassVar[Qt.TouchPointState] = ...
    TransparentMode: typing.ClassVar[Qt.BGMode] = ...
    T