#from axipy import Polygon, MultiPolygon, AreaUnit
from axipy import *

def CreatePolygonFromRect(mbr,cs):
    '''
    Rect to Polygon
    :param mbr: Rect
    :param cs:
    :return:
    '''
    points=[]
    points.append((mbr.xmin,mbr.ymin))
    points.append((mbr.xmin,mbr.ymax))
    points.append((mbr.xmax,mbr.ymax))
    points.append((mbr.xmax,mbr.ymin))
    points.append((mbr.xmin,mbr.ymin))
    geo_poly=Polygon(points,cs)
    return geo_poly
def cloneNoholes(geo_poly):

    if geo_poly.type==GeometryType.Polygon:
        if len(geo_poly.holes) == 0:
            ''' жырок нет'''
            return geo_poly.clone()
        return Polygon(geo_poly.points,cs=geo_poly.coordsystem)
    if geo_poly.type==GeometryType.MultiPolygon:
        result_geometry= MultiPolygon()
        for poly in geo_poly:
            result_geometry.append(Polygon( poly.points,cs=geo_poly.coordsystem))
        result_geometry.coordsystem==geo_poly.coordsystem
        return result_geometry
def getHolesPoly(geo_poly,limit_area):
    list_holes = []
    if len(geo_poly.holes) > 0:
        for hole_points in geo_poly.holes:
            hole_poly=Polygon(hole_points,cs=geo_poly.coordsystem)
            if limit_area == 0.0:
                list_holes.append(hole_poly)
            else:
                area_gap_poly = hole_poly.get_area(AreaUnit.sq_km)
                if area_gap_poly <= limit_area:
                    list_holes.append(hole_poly.clone())
    return list_holes
class GapDetection:
    __area_limit=0.0
    __obj_com_poly=None
    def __init__(self,limit_area):
        self.__area_limit=limit_area
        self.__obj_com_no_holes=None
    def addGeo(self,geo_curent):
        if self.__obj_com_poly is None:
            self.__obj_com_poly=geo_curent.clone()
            #self.__obj_com_no_holes=cloneNoholes(geo_curent)
        else:
            try:
                self.__obj_com_poly=self.__obj_com_poly.union(geo_curent)
                #self.__obj_com_no_holes=self.__obj_com_no_holes.union(cloneNoholes(geo_curent))
            except:
                pass
        return
    def postProcessing(self):
        print("Start gapDetection")
        '''
        mbr=self.__obj_com_poly.bounds
        geo_mbr=CreatePolygonFromRect(mbr,self.__obj_com_poly.coordsystem)

        #envelope_obj=Polygon(self.__obj_com_poly.points,self.__obj_com_poly.coordsystem)
        envelope_obj=self.__obj_com_poly.convex_hull()
        '''
        #temp_no_holes=cloneNoholes(self.__obj_com_no_holes)
        #geo_diff = temp_no_holes.difference(self.__obj_com_poly)
        #geo_diff=self.__obj_com_no_holes.difference(self.__obj_com_poly)
        #geo_diff=envelope_obj.difference(self.__obj_com_poly)
        list_holes=[]
        if self.__obj_com_poly.type==GeometryType.Polygon:
            temp_holes=getHolesPoly(self.__obj_com_poly,self.__area_limit)
            if len(temp_holes)>0:
                list_holes.extend(temp_holes)

        else:
            for poly in self.__obj_com_poly:
                if isinstance(poly,Polygon):
                    temp_holes = getHolesPoly(poly, self.__area_limit)
                    if len(temp_holes) > 0:
                        list_holes.extend(temp_holes)
        '''
        if isinstance(geo_diff,Polygon):
            point_center=geo_diff.centroid()
            if envelope_obj.contains(point_center):
                list_holes.append(geo_diff)
        else:
            for poly in geo_diff:
                point_center=poly.centroid()
                if envelope_obj.contains(point_center):
                    area_gap_poly=poly.get_area(AreaUnit.sq_km)
                    if self.__area_limit==0.0:
                        list_holes.append(poly.clone())
                        continue
                    if area_gap_poly<=self.__area_limit:
                        list_holes.append(poly.clone())
        '''

        if len(list_holes)==0:
            return None,None,self.__obj_com_poly
        #return list_holes,None,envelope_obj
        return list_holes,None,None
        #return None,geo_mbr,self.__obj_com_poly
        if len(list_holes)==1:
            return list_holes[0],None,None
        result_polygons=MultiPolygon(self.__obj_com_poly.coordsystem)
        for poly in list_holes:
            result_polygons.append(poly)
        #return result_polygons,geo_diff,envelope_obj
        return None,geo_mbr,self.__obj_com_poly

