from functools import cached_property
from typing import TYPE_CHECKING

from PySide2.QtCore import Qt
from PySide2.QtGui import QMouseEvent
from PySide2.QtWidgets import (QStackedWidget, QDialog)
from axipy import (data_manager)

if TYPE_CHECKING:
    from .register_vector_dialog import RegisterVectorDialog


class StackedWidget(QStackedWidget):

    @cached_property
    def dialog_widget(self) -> 'RegisterVectorDialog':
        widget = self
        while not isinstance(widget, QDialog):
            widget = widget.parentWidget()
        # noinspection PyTypeChecker
        return widget

    def mouseReleaseEvent(self, event: QMouseEvent) -> None:
        if event.button() == Qt.MouseButton.LeftButton and data_manager.selection is None:
            self.add_coordinates()

    def add_coordinates(self) -> None:
        raise NotImplementedError


class StackedWidgetTables(StackedWidget):

    def add_coordinates(self) -> None:
        self.dialog_widget.add_coordinates_tables()


class StackedWidgetMaps(StackedWidget):

    def add_coordinates(self) -> None:
        self.dialog_widget.add_coordinates_maps()
