from __future__ import annotations

from dataclasses import dataclass
from typing import TYPE_CHECKING

import axipy
from PySide2.QtCore import Qt
from PySide2.QtWidgets import QDialog, QListWidget, QPushButton
from .ui import Ui_OpenRasterDialog

if TYPE_CHECKING:
    from .__init__ import OpenPostgreRasterPlugin


class OpenRasterDialog(QDialog, Ui_OpenRasterDialog):
    @dataclass
    class Result:
        chosen_index: int | None = None

    def __init__(self, plugin: 'OpenPostgreRasterPlugin', data_sets: list[str], result: Result) -> None:
        super().__init__(axipy.view_manager.global_parent)
        self.setupUi(self)
        self.setAttribute(Qt.WA_DeleteOnClose, True)

        self._plugin = plugin
        self._result = result

        self.list_widget.addItems(data_sets)
        self.list_widget.setSelectionMode(QListWidget.SelectionMode.SingleSelection)

        self._ok_button.setText(self._plugin.tr("Открыть"))

    @property
    def _ok_button(self) -> QPushButton:
        return self.buttonBox.button(self.buttonBox.Ok)

    def done(self, return_code: int) -> None:
        if return_code == self.Accepted:
            self._result.chosen_index = self.list_widget.currentIndex().row()

        super().done(return_code)
