from __future__ import annotations

from collections.abc import Iterable

import axipy
from PySide2.QtCore import Signal
from axipy._internal._observer_abc import _ObserverABC


class CollectionOrderEditorObserver(_ObserverABC):
    @property
    def name(self) -> str:
        return "ru_axioma_gis_collection_order_editor_CollectionOrderEditorObserver"

    @property
    def signals(self) -> Signal | Iterable[Signal]:
        return (
            axipy.ObserverManager.ActiveMapView.changed,
        )

    def test_value(self) -> bool:
        return (
                axipy.ObserverManager.ActiveMapView.value and
                isinstance(axipy.view_manager.active, axipy.MapView) and  # extra check for axipy.LegendView
                self._test_value()
        )

    @staticmethod
    def active_map_view() -> axipy.MapView:
        """Ensured by observer."""
        return axipy.view_manager.active

    def _test_value(self) -> bool:
        return True
