from lxml import etree
from osgeo import ogr
from osgeo.osr import SpatialReference


def getContourPoints(elem_points,func_call_back):
    list_pnt=[]
    for el in elem_points:
        func_call_back()
        el_children=list(el)
        x=float(el_children[0].text)
        y = float(el_children[1].text)
        list_pnt.append((x,y))
    return list_pnt
def createOgrPolygon(pnts,func_call_back,isReversXY=True):
    poly=ogr.Geometry(ogr.wkbPolygon)
    index_x=0
    index_y=1
    if isReversXY:
        index_x = 1
        index_y = 0
    ring = ogr.Geometry(ogr.wkbLinearRing)
    for pnt in pnts:
        func_call_back()
        ring.AddPoint(pnt[index_x],pnt[index_y])
    poly.AddGeometry(ring)
    ring=None
    return poly
class Contours:
    def __init__(self,elem_contours,call_back_fun,isReversXY=True):
        self.__elem_contours=elem_contours

        self.__isReversXY=isReversXY
        self.__call_back_fun=call_back_fun
        self.__geometry_collection = None
        self.__prepare()

    def __prepare(self):
        self.__geometry_collection=ogr.Geometry(ogr.wkbGeometryCollection)
        count_poly=len(list(self.__elem_contours))
        for i,contour in enumerate(self.__elem_contours):
            print("contour "+str(i+1)+" from "+str(count_poly))
            self.__call_back_fun()
            el_entitySpatial=find_elemens(contour,"*","entitySpatial")
            value_cs=find_elemens(el_entitySpatial[0],"*/*","value")
            name_cs=value_cs[0].text
            el_points=find_elemens(el_entitySpatial[0],"*/*/*","ordinates")
            points=getContourPoints(el_points[0],self.__call_back_fun)
            polygon=createOgrPolygon(points,self.__call_back_fun,self.__isReversXY)
            if polygon is not None:
                self.__geometry_collection.AddGeometry(polygon)
                polygon=None
        return
    @property
    def geometry(self):
        return self.__geometry_collection

class DataAllGlr:
    def __init__(self,node):
        self.__node=node
        self.__prepareNode()
    def __prepareNode(self):
        for elem in self.__node:
            if elem.tag.find('}extract')>0:
                self.__pareseExtract(elem)
                continue
            if elem.tag.find('}registrationNumber') > 0:
                self.__registrationNumber=elem.text
            if elem.tag.find('}documentationNumber') > 0:
                self.__documentationNumber=elem.text
    @property
    def dataRegistration(self):
        return self.__date_reg
    @property
    def number(self):
        return self.__number
    @property
    def registrationNumber(self):
        return self.__registrationNumber
    @property
    def documentationNumber(self):
        return self.__documentationNumber
    def __pareseExtract(self,elem):
        for el in elem:
            if el.tag.find("}date")>0:
                self.__date_reg=el.text
            if el.tag.find("}number") > 0:
                self.__number = el.text
def find_elemens(node,xpath_str,name_elem):
    result=node.xpath(xpath_str)
    elements=[]
    for elem in result:
        if elem.tag.find("}"+name_elem)>=0:
            elements.append(elem)
    if len(elements)==0:
        return None
    return elements