import uuid
from decimal import Decimal
from pathlib import Path

from osgeo import ogr, osr

from rosreestrXml.ui.tools.KPT.kptTools.DbKptDirectory import KptСatalog
from rosreestrXml.ui.tools.KPT.under_construction.under_constraction_v01 import parseString
class RecordUnderCostraction:
    __name_table="object_under_construction"
    __nameProcess = "Импорт информации о объектах незавершенного строительства"
    def __init__(self,obj_record):
        self.__value=[]
        self.prepare(obj_record)
    def prepare(self,obj_recodr):
        self.guid=str(uuid.uuid4())
        self.__value.append({'guid':self.guid})
        try:
            date_reg=obj_recodr.record_info.registration_date
            date_str=date_reg.strftime("%d.%m.%Y")
            self.__value.append({'дата_регистрации':date_str})
        except:
            pass
        try:
            cad_number=obj_recodr.object.common_data.quarter_cad_number
            self.__value.append({'кадастровый_номер':cad_number})
        except:
            pass
        try:
            kvartal_cad_number=obj_recodr.object.common_data.quarter_cad_number
            self.__value.append({'номер_кадастрового_квартала':kvartal_cad_number})
        except:
            pass
        try:
            code=obj_recodr.object.common_data.type_.code
            self.__value.append({'код_справочника_НСИ':code})
        except:
            pass
        try:
            code_value=obj_recodr.object.common_data.type_.value
            self.__value.append({'значение_справочника_НСИ':code_value})
        except:
            pass
        try:
            land_cad_numbers=obj_recodr.cad_links.land_cad_numbers.land_cad_number[0].cad_number
            self.__value.append({'land_cad_numbers':land_cad_numbers})
        except:
            pass
        try:
            area=obj_recodr.params.base_parameters.base_parameter[0].area
            self.__value.append({'площадь':area})
        except:
            pass
        try:
            built_up_area=obj_recodr.params.base_parameters.base_parameter[0].built_up_area
            self.__value.append({'площадь_застройки':built_up_area})
        except:
            pass
        try:
            extension=obj_recodr.params.base_parameters.base_parameter[0].extension
            self.__value.append({'протяженность':extension})
        except:
            pass
        try:
            depth=obj_recodr.params.base_parameters.base_parameter[0].depth
            self.__value.append({'глубина':depth})
        except:
            pass
        try:
            occurence_depth=obj_recodr.params.base_parameters.base_parameter[0].occurence_depth
            self.__value.append({'глубина_залегания':occurence_depth})
        except:
            pass
        try:
            volume=obj_recodr.params.base_parameters.base_parameter[0].volume
            self.__value.append({'объем':volume})
        except:
            pass
        try:
            degree_readiness=obj_recodr.params.degree_readiness
            self.__value.append({'степень_готовности_объекта':degree_readiness})
        except:
            pass
        try:
            purpose=obj_recodr.params.purpose
            self.__value.append({'назначение':purpose})
        except:
            pass
        try:
            address=obj_recodr.address_location.address.readable_address
            self.__value.append({'адрес':address})
        except:
            pass
        try:
            address_note=obj_recodr.address_location.address.note
            self.__value.append({'адрес_note':address_note})
        except:
            pass
        try:
            cost=obj_recodr.cost.value
            self.__value.append({'стоимость':cost})
        except:
            pass
    @property
    def NameProcess(self):
        return self.__nameProcess
    @property
    def NameLayer(self):
        return None
    def Save(self,db):
        existTab=db.existTable(self.__name_table)
        if not existTab:
            path_cur_folder=Path(__file__).parent
            path_script=path_cur_folder.joinpath("create_table.sql")
            isOk=db.runSqlScript(str(path_script))
        sql_name=[]
        sql_value=[]
        vl=[]
        for item in self.__value:
            name=list(item.keys())[0]
            value=item[name]
            sql_name.append(name)
            if isinstance(value,Decimal):
                value=float(value)
            sql_value.append(value)
            vl.append("?")
        name_list= ",".join(sql_name)
        values=tuple(sql_value)
        str_vl=",".join(vl)
        sql_insert="insert into "+self.__name_table+" ("+name_list+") "
        sql_insert=sql_insert+"VALUES("+str_vl+")"
        tp_id=db.insert(sql_insert,values,False)
        db.commit()
    def CreateLayer(self,ds,typeInit):
        return None

    def Write(self,layer,db, mapCatalog):
        self.Save(db)


class SpatialContour:
    __layers = None
    __nameProcess = "Импорт контуров"
    __name = "контура_незавершенного_строительства"
    def __init__(self,contour,property):
        self.__contour=contour
        self.__property=property

    @property
    def NameProcess(self):
        return self.__nameProcess

    @property
    def NameLayer(self):
        return self.__name

    @staticmethod
    def getStruct():
        struct = []
        struct.append({'name': 'parent_guid', 'type': ogr.OFTString, 'width': 40})
        struct.append({'name': 'номер_контура', 'type': ogr.OFTInteger})
        struct.append({'name': 'MI_STYLE', 'type': ogr.OFTString, 'width': 120})

        return struct
    def CreateLayer(self, ds, createNewLayer=True):

        layer = None
        if not createNewLayer:
            layer = ds.GetLayer(self.__name)
            if layer is not None:
                return layer
        srs = osr.SpatialReference()
        srs.ImportFromWkt(self.__property['cs'])
        layer = ds.CreateLayer(self.__name, srs, geom_type=ogr.wkbUnknown)
        for fld in SpatialPoint.getStruct():
            # create fields
            field_cur = ogr.FieldDefn(fld['name'],fld['type'])
            type_field=fld['type']
            if fld['type']==ogr.OFTString:
                field_cur.SetWidth(fld['width'])
            layer.CreateField(field_cur)
        return layer

    def Write(self, layer, dbDictionary: KptСatalog, dbDocuments):
        att = []
        # att.append({'name': 'кадастровый_номер', 'value': self.__cadNumber})
        att.append({'name': 'parent_guid', 'value':self.__contour.parent_guid})

        att.append({'name': 'номер_точки', 'value': self.__contour.number_pp})
        att.append({'name': 'MI_STYLE', 'value': self.__property['style']})
        feature = ogr.Feature(layer.GetLayerDefn())
        for atr_item in att:

            try:
                feature.SetField(atr_item['name'], atr_item['value'])
            except Exception as ex:
                jkl = 0
        geometry=self.getGeometry()
        if geometry is not None:
            feature.SetGeometry(geometry)
        layer.CreateFeature(feature)
        geometry = None
        feature = None
        return

    def getGeometry(self):
        source_points=self.__contour.getPoints_spatial_element()
        poly=[]
        for pts in source_points:
            geometry=pts.getOgrGeometry(self.__property['reverseXY'])
            if geometry is not None:
                poly.append(geometry)
        if len(poly)==0:
            return None
        if len(poly)==1:
            return poly[0]
        return None



class SpatialPoint:
    __layers = None
    __nameProcess = "Импорт точек"
    __name="точки_незавершенного_строительства"
    def __init__(self,points,property):
        self.__propert=property
        self.__simplePoints=points
    def add(self,pt_simple):
        self.__simplePoints.append(pt_simple)
    @property
    def NameProcess(self):
        return self.__nameProcess
    @property
    def NameLayer(self):
        return self.__name
    @staticmethod
    def getStruct():
        struct = []
        struct.append({'name': 'parent_guid', 'type': ogr.OFTString, 'width': 40})
        struct.append({'name': 'номер_контура', 'type': ogr.OFTInteger})
        struct.append({'name': 'номер_точки', 'type': ogr.OFTInteger})
        struct.append({'name': 'id_точки', 'type': ogr.OFTInteger})

        struct.append({'name': 'x', 'type': ogr.OFTReal})
        struct.append({'name': 'y', 'type': ogr.OFTReal})

        struct.append({'name': 'MI_STYLE', 'type': ogr.OFTString, 'width': 120})

        return struct
    def CreateLayer(self, ds, createNewLayer=True):

        layer = None
        if not createNewLayer:
            layer = ds.GetLayer(self.__name)
            if layer is not None:
                return layer
        srs = osr.SpatialReference()
        srs.ImportFromWkt(self.__propert['cs'])
        layer = ds.CreateLayer(self.__name, srs, geom_type=ogr.wkbPoint)
        for fld in SpatialPoint.getStruct():
            # create fields
            field_cur = ogr.FieldDefn(fld['name'],fld['type'])
            type_field=fld['type']
            if fld['type']==ogr.OFTString:
                field_cur.SetWidth(fld['width'])
            layer.CreateField(field_cur)
        return layer
    def Write(self, layer, dbDictionary: KptСatalog, dbDocuments):
        if self.__simplePoints is None:
            return

        layer.StartTransaction()
        for pnt in self.__simplePoints:
            self.__PointWrite(layer, pnt)
        layer.CommitTransaction()
    def __PointWrite(self, layer,pnt):
        #geometry=self.__createGeometry()
        att=[]
        #att.append({'name': 'кадастровый_номер', 'value': self.__cadNumber})
        att.append({'name': 'parent_guid', 'value': pnt.parent_guid})
        att.append({'name': 'id_contour', 'value': pnt.id_contout})
        att.append({'name': 'номер_точки', 'value': pnt.num_geopoint})
        att.append({'name': 'id_точки', 'value': pnt.id_point})
        att.append({'name': 'x', 'value': pnt.x})
        att.append({'name': 'y', 'value': pnt.y})

        att.append({'name': 'MI_STYLE', 'value':self.__propert['style']})
        feature = ogr.Feature(layer.GetLayerDefn())
        for atr_item in att:
            # print(atr_item['name'])
            # print(atr_item['value'])
            try:
                feature.SetField(atr_item['name'], atr_item['value'])
            except Exception as ex:
                jkl=0
        geometry=ogr.Geometry(ogr.wkbPoint)
        if self.__propert['reverseXY']:
            geometry.AddPoint(pnt.y,pnt.x)
        else:
            geometry.AddPoint(pnt.x, pnt.y)
        if geometry is not None:
            feature.SetGeometry(geometry)

        layer.CreateFeature(feature)
        geometry = None
        feature = None
        return
class SimplePoint:
    def __init__(self,parent_guid,id_contour,tag_points):
        self.parent_guid=parent_guid
        self.id_contout=id_contour
        self.__prepare(tag_points)
    def __prepare(self,cls_pt):
        self.num_geopoint = int(cls_pt.num_geopoint)
        self.id_point = cls_pt.ord_nmb
        self.x = float(cls_pt.x)
        self.y = float(cls_pt.y)
class Points:
    def __init__(self,cls_spaial_element,id_contour,parent_guid):
        self.__id_countour=id_contour
        self.__point=[]
        self.__prepare(cls_spaial_element,parent_guid)
    def __prepare(self,cls_spaial_element,parent_guid):
        for cls_pt in cls_spaial_element:
            self.__point.append(SimplePoint(parent_guid,self.__id_countour,cls_pt))
    def getSimolePoints(self):
        if len(self.__point)==0:
            return None
        return self.__point
    def getOgrGeometry(self,reverse_XY):
        jkl=0
        pt1=self.__point[0]
        pt_end=self.__point[-1]

        if pt1.x==pt_end.x and pt1.y==pt_end.y:
            type_geometry=ogr.wkbLinearRing
        else:
            type_geometry = ogr.wkbLineString
        geo_xp=ring = ogr.Geometry(type_geometry)
        for pt in self.__point:
            if reverse_XY:
                geo_xp.AddPoint(pt.y,pt.x)
            else:
                geo_xp.AddPoint(pt.x, pt.y)
        if type_geometry==ogr.wkbLinearRing:
            poly = ogr.Geometry(ogr.wkbPolygon)
            poly.AddGeometry(geo_xp)
            return poly
        return geo_xp



class Countour:
    def __init__(self,csl_countor,parent_guid):
        self.parent_guid=parent_guid
        self.__points_spatial_element=[]
        self.__prepare(csl_countor)
    def __prepare(self,cls_countour):
        self.number_pp=cls_countour.number_pp
        cls_spatial_element=cls_countour.entity_spatial.spatials_elements.spatial_element

        for sp_element in cls_spatial_element:
            points=Points(sp_element.ordinates.ordinate,self.number_pp,self.parent_guid)
            self.__points_spatial_element.append(points)
    def getPoints_spatial_element(self):
        return self.__points_spatial_element
    def getSimplePoints(self):
        if len(self.__points_spatial_element)==0:
            return None
        simpl_points=[]
        for pnt in self.__points_spatial_element:
            points=pnt.getSimolePoints()
            if points is not None:
                simpl_points.extend(points)
        if len(simpl_points)==0:
            return None
        return simpl_points
class UnderCostractionContours:
    def __init__(self,object_under_construction_record,property,parent_guid):
        self.__property=property
        self.parent_guid=parent_guid
        self.__prepare(object_under_construction_record)
    def __prepare(self,object_under_construction_record):
        contours=object_under_construction_record.contours
        self.__countours=[]
        for cls_contour in contours.contour:
            contour=Countour(cls_contour,self.parent_guid)
            self.__countours.append(contour)
    def __buildOutPoints(self,property):
        if len(self.__countours)==0:
            return None
        simp_points=[]
        for contour in self.__countours:
            pnts=contour.getSimplePoints()
            if pnts is not None:
                simp_points.extend(pnts)
        return SpatialPoint(simp_points,property)
    def __buildOutContours(self,property):
        out_contours=[]
        for contour in self.__countours:
            out_contours.append(SpatialContour(contour,property))
        return out_contours
    def getObjToSave(self):
        list_obj_save=[]
        clsSavePoints=None
        clsSaveContours=None
        #if self.__property['point']:
        if self.__property['contours_points']['enable']:
            #self.__property['contours_points']['cs_mi'] = self.__property['cs_mi']
            self.__property['contours_points']['reverseXY'] = self.__property['reverseXY']
            self.__property['contours_points']['cs'] = self.__property['cs']
            clsSavePoints = self.__buildOutPoints(self.__property['contours_points'])
        if self.__property['contours']['enable']:
            #self.__property['contours']['cs_mi']=self.__property['cs_mi']
            self.__property['contours']['reverseXY'] = self.__property['reverseXY']
            self.__property['contours']['cs'] = self.__property['cs']
            clsSaveContours=self.__buildOutContours(self.__property['contours'])

        #out_cls_save=[clsSavePoints]

        out_cls_save =[]
        if clsSavePoints is not None:
            out_cls_save.append(clsSavePoints)
        if clsSaveContours is not None:
            out_cls_save.extend(clsSaveContours)
        #if self.__property['contour']:
        return out_cls_save


def FactoryUnderCostractionFromString(source_xml,property_under_constraction):
    objXml= parseString(source_xml, True)
    objectRecord=RecordUnderCostraction(objXml.object_under_construction_record)
    objectCountors=UnderCostractionContours(objXml.object_under_construction_record,property_under_constraction,objectRecord.guid)
    object_tosave=[objectRecord]
    object_tosave.extend(objectCountors.getObjToSave())
    return object_tosave
