from osgeo import ogr


class ObjAddress:
    __xmlAddress=None
    def __init__(self,xmlTag):
        self.__xmlAddress=xmlTag
    @staticmethod
    def getStruct():
        struct=[]
        struct.append({'name': 'OKATO', 'type': ogr.OFTString, 'width': 12})
        struct.append({'name': 'KLADR', 'type': ogr.OFTString, 'width': 20})
        #struct.append({'name': 'OKTMO', 'type': ogr.OFTString, 'width': 12})
        struct.append({'name': 'ПочтовыйИндекс', 'type': ogr.OFTString, 'width': 6})
        struct.append({'name': 'КодРегиона', 'type': ogr.OFTString, 'width': 2})
        struct.append({'name': 'ГородскойРайон', 'type': ogr.OFTString, 'width': 280})
        struct.append({'name': 'Улица', 'type': ogr.OFTString, 'width': 128})
        struct.append({'name': 'Дом', 'type': ogr.OFTString, 'width': 60})
        return struct
    def getValue(self):
        values=[]
        valOKATO=self.__xmlAddress.OKATO
        values.append({'name': 'OKATO', 'value': valOKATO})
        values.append({'name': 'KLADR', 'value': self.__xmlAddress.KLADR})
        values.append({'name': 'ПочтовыйИндекс', 'value': self.__xmlAddress.PostalCode})
        values.append({'name': 'КодРегиона', 'value': self.__xmlAddress.Region})
        objUrbanDistrict=self.__xmlAddress.UrbanDistrict
        if objUrbanDistrict is None:
            return values
        valName=objUrbanDistrict.Name
        valType=objUrbanDistrict.Type
        valUrbanDistrict=valType+" "+valName
        values.append({'name': 'ГородскойРайон', 'value': valUrbanDistrict})
        objStreet=self.__xmlAddress.Street
        if objStreet is not None:
            valName=objStreet.Name
            valType=objStreet.Type
            valStreet=valType+". "+valName
            values.append({'name': 'Улица', 'value': valStreet})
        objLevel1=self.__xmlAddress.Level1
        if objLevel1 is not None:
            valType=objLevel1.Type
            valValue=objLevel1.Value
            valDom=valType+". "+valValue
            values.append({'name': 'Дом', 'value': valDom})
        return values


