from rosreestrXml.ui.tools.KPT.cadastral_plan_territory.KPTObj_11Xml import FactoryKpt11FromString
from rosreestrXml.ui.tools.KPT.egrn_tool.EgrnObXml import FactoryEgrnFromStringObj
from rosreestrXml.ui.tools.KPT.egrn_tool.egrn_generate_new import EgrnImport
from rosreestrXml.ui.tools.KPT.kptTools.KptObjXml import FactoryKpt10FromString, FactoryObjectKpt10FromString
from rosreestrXml.ui.tools.KPT.under_construction.ObjectUnderConstraction import FactoryUnderCostractionFromString
from rosreestrXml.ui.tools.forest.ForestDeclaration.ForestDeclarationObj import ForestDeclarationObjFromString
from rosreestrXml.ui.tools.forest.GLR.importGlr import GlrObj


def factoryKptObj(source_xml,property):
    if source_xml.find('<KPT xmlns:')>=0:
        ''' KPT10'''
        return FactoryObjectKpt10FromString(source_xml,property)
    if source_xml.find('<extract_cadastral_plan_territory>')>=0:
        ''' KPT11'''
        return FactoryKpt11FromString(source_xml, property)
    if source_xml.find('forestDeclaration xmlns')>=0:
        return ForestDeclarationObjFromString(source_xml,property['forestDeclaration'])
    if source_xml.find('extract_about_property_land')>=0:

        bExist_y=source_xml.find("<_")
        if bExist_y:
            ''' удаляем _'''
            source_xml=source_xml.replace("<_","<")
            source_xml=source_xml.replace("</_","</")
        property_egrn=property['egrn']
        property_egrn['cs'] = property['cs']
        property_egrn['reverseXY'] = property['reverseXY']
        return FactoryEgrnFromStringObj(source_xml,property_egrn)
    if source_xml.find('extract_about_property_under_construction') >= 0:
        property_under_constraction=property['under_construction']
        property_under_constraction['cs'] = property['cs']
        property_under_constraction['reverseXY'] = property['reverseXY']
        return FactoryUnderCostractionFromString(source_xml,property_under_constraction)
    if source_xml.find('extract_base_params_land') >= 0:
        property_egrn = property['egrn']
        property_egrn['cs'] = property['cs']
        property_egrn['reverseXY'] = property['reverseXY']
        return EgrnImport(source_xml,property)
    if source_xml.find('<stateForestRegisterExtractForestry ') >= 0 or source_xml.find('<stateForestRegisterExtractForest') >= 0:
        property_forest = property['forestDeclaration']
        property_forest['cs'] = property['cs']
        property_forest['reverseXY'] = property['reverseXY']
        return GlrObj(source_xml,property)
    return None