from datetime import datetime


def getValue(xml_tag):
    try:
        value_data = xml_tag
    except:
        value_data=None
    return value_data
class InfoEgr:
    def __init__(self,tagXmlLand):
        self.__xmlLand=tagXmlLand
        self.__data=None
        self.__prepare()
        self.__nameProcess="Дополнительная информация"
        self.__name_table = "info_egrn"
    def __prepare(self):
        self.__data=[]
        self.__data.append({"кадастровый_номер": getValue(self._InfoEgr__xmlLand.object.common_data.cad_number)})
        self.__data.append({"дата_регистрации":getValue(self.__xmlLand.record_info.registration_date)})
        self.__data.append({"адрес": getValue(self._InfoEgr__xmlLand.address_location.address.readable_address)})
        self.__data.append({"площадь": getValue(self._InfoEgr__xmlLand.params.area.value)})
        self.__data.append({"стоимость": getValue(self._InfoEgr__xmlLand.cost.value)})
        self.__data.append({"категория земель": getValue(self._InfoEgr__xmlLand.params.category.type_.value)})
        self.__data.append({'виды разрешенного использования': getValue(self._InfoEgr__xmlLand.params.permitted_use.permitted_use_established.by_document)})
        right_value=None

        #self.__data.append({'правообладатели': getValue( self._InfoEgr__xmlLand.parent_object_.right_records.right_record[0].right_holders.right_holder[0].legal_entity.entity.resident.name)})
        try:
            right_value= getValue( self._InfoEgr__xmlLand.parent_object_.right_records.right_record[0].right_holders.right_holder[0].legal_entity.entity.resident.name)
        except:
            pass
        if right_value  is None:
            try:
                right_value=getValue(self._InfoEgr__xmlLand.parent_object_.right_records.right_record[0].right_holders.right_holder[0].individual.name)
            except:
                pass
        if right_value is not None:
            self.__data.append({'правообладатели':right_value})



    def CreateLayer(self,ds,type):
        self.createTable(ds)
        return ds
    @property
    def NameProcess(self):
        return self.__nameProcess
    def createTable(self,ds):

        sql_create_table="create table ["+self.__name_table+"] "
        sql_create_table=sql_create_table+"("
        struc_table=InfoEgr.struct()
        fielf_def=[]
        for field_des in struc_table:
            sql_field = "["+field_des['name']+"] "+field_des["type"]
            fielf_def.append(sql_field)
        sql_create_table=sql_create_table +','.join(fielf_def)
        sql_create_table = sql_create_table+")"
        #db.DataSource.ExecuteSQL(sql_create_table, dialect='SQLITE')
        ds.ExecuteSQL(sql_create_table, dialect='SQLITE')
        return
    def Write(self,ds,db_catalog,mapCatalog):
        '''
        tableExist=mapCatalog.exisTable(self.__name_table)
        if not tableExist:
            return
        '''
        sql_insert="Insert into ["+self.__name_table+"] "
        list_filed=[]
        list_values=[]
        for field_value in self.__data:
            name_field=list(field_value.keys())[0]
            if field_value[name_field] is not None:
                list_filed.append("["+name_field+"]")
                if isinstance(field_value[name_field],str) or isinstance(field_value[name_field],datetime):
                    if isinstance(field_value[name_field],str):
                        list_values.append("'"+field_value[name_field]+"'")
                    else:
                        list_values.append("'" + str(field_value[name_field]) + "'")

                else:
                    list_values.append(str(field_value[name_field]))
        sql_insert=sql_insert+"("+','.join(list_filed)+") "
        sql_insert = sql_insert +" VALUES("+','.join(list_values)+") "
        ds.ExecuteSQL(sql_insert, dialect='SQLITE')
        return
    @property
    def NameLayer(self):
        return None
    @staticmethod
    def struct():
        struct_table=[]
        cad_number={}
        cad_number['name']="кадастровый_номер"
        cad_number['type']="TEXT"
        struct_table.append(cad_number)
        reg_date = {}
        reg_date['name'] = "дата_регистрации"
        reg_date['type'] = "TEXT"
        struct_table.append(reg_date)
        struct_table.append({'name':'адрес','type':'TEXT'})
        struct_table.append({'name':'площадь','type':'REAL'})
        struct_table.append({'name': 'стоимость', 'type': 'REAL'})
        struct_table.append({'name': 'категория земель', 'type': 'TEXT'})
        struct_table.append({'name': 'виды разрешенного использования', 'type': 'TEXT'})
        struct_table.append({'name': 'правообладатели', 'type': 'TEXT'})

        return struct_table