from lxml import etree
from osgeo import ogr
from osgeo.osr import SpatialReference


def getContourPoints(elem_points):
    list_pnt=[]
    for el in elem_points:
        el_children=list(el)
        x=float(el_children[0].text)
        y = float(el_children[1].text)
        list_pnt.append((x,y))
    return list_pnt
def createOgrPolygon(pnts,isReversXY=True):
    poly=ogr.Geometry(ogr.wkbPolygon)
    index_x=0
    index_y=1
    if isReversXY:
        index_x = 1
        index_y = 0
    for pnt in pnts:
       poly.AddPoint(pnt[index_x],pnt[index_y])
    return poly
class Contours:
    def __init__(self,elem_contours,srs_ogr,isReversXY=True):
        self.__elem_contours=elem_contours
        self.__srs=srs_ogr
        self.__isReversXY=isReversXY


        self.__prepare()
        self.__geometry_collection=None
    def __prepare(self):
        self.__geometry_collection=ogr.Geometry(ogr.wkbGeometryCollection)
        for contour in self.__elem_contours:
            el_entitySpatial=find_elemens(contour,"*","entitySpatial")
            value_cs=find_elemens(el_entitySpatial[0],"*/*","value")
            name_cs=value_cs[0].text
            el_points=find_elemens(el_entitySpatial[0],"*/*/*","ordinates")
            points=getContourPoints(el_points[0])
            polygon=createOgrPolygon(points,self.__isReversXY)
            if polygon is not None:
                self.__geometry_collection.AddGeometry(polygon)
                polygon=None
    @property
    def geometry(self):
        return self.__geometry_collection

class DataAllGlr:
    def __init__(self,node):
        self.__node=node
        self.__prepareNode()
    def __prepareNode(self):
        for elem in self.__node:
            if elem.tag.find('}extract')>0:
                self.__pareseExtract(elem)
            if elem.tag.find('}registrationNumber') > 0:
                self.__registrationNumber=elem.text
            if elem.tag.find('}documentationNumber') > 0:
                self.__documentationNumber=elem.text
    @property
    def dataRegistration(self):
        return self.__date_reg
    @property
    def number(self):
        return self.__number
    @property
    def registrationNumber(self):
        return self.__registrationNumber
    @property
    def documentationNumber(self):
        return self.__documentationNumber
    def __pareseExtract(self,elem):
        for el in elem:
            if el.tag.find("}date")>0:
                self.__date_reg=el.text
            if el.tag.find("}number") > 0:
                self.__number = el.text
def find_elemens(node,xpath_str,name_elem):
    result=node.xpath(xpath_str)
    elements=[]
    for elem in result:
        if elem.tag.find("}"+name_elem)>=0:
            elements.append(elem)
    if len(elements)==0:
        return None
    return elements
path_r=r"E:\Download\RossRestr\GLR\Vypiska is glr_2.xml"
root=etree.parse(path_r)
result=root.xpath("*/*/*/*")
countrs_elements=find_elemens(root,"*/*/*/*",'contours')
elem_dataAll=find_elemens(root,"*",'dataAll')
cs_proj="+proj=tmerc +lat_0=0 +lon_0=133.71666666666 +k=1 +x_0=2300000 +y_0=-4416586.44 +ellps=krass +towgs84=24,-123,-94,0.02,-0.25,-0.13,1.1 +units=m +no_defs"
srs_ogr=SpatialReference()
srs_ogr.ImportFromProj4(cs_proj)
jkl=0
cld_dataAll=DataAllGlr(elem_dataAll[0])
for elem in result:
    if elem.tag.find('}contours')>0:
        countrs_elements.append(elem)
cls_cntr=Contours(countrs_elements[0],srs_ogr)
jkl=0