import os
from pathlib import Path

from PkkXml.plugins.XmlPkk.ObjectToSave import TypeGeometryProviderOgr
from rosreestrXml.ui.tools.KPT.egrn_tool.egrn_generate_new import EgrnImport
from rosreestrXml.ui.tools.KPT.factory_kpt import factoryKptObj
from rosreestrXml.ui.tools.KPT.kptTools.DbKptDirectory import KptСatalog
from rosreestrXml.ui.tools.OutDrv.DbDocuments import DocumentsDb
from rosreestrXml.ui.tools.OutDrv.ObjectToSave import DbGeoOgr
from rosreestrXml.ui.tools.utils.fileAdapter import DataSourceXml

path_sorce=r"E:\Download\RossRestr\newEGRN\report-4393f417-5b0d-49f5-938f-1954effeaf84-BC-2024-10-30-590300-86-01[0].xml"
path_out=r"E:\Download\RossRestr\newEGRN\test_import.gpkg"
#path_out=r"E:\Download\RossRestr\newEGRN\test_import__z.sqlite"
if Path(path_out).exists():
    os.remove(path_out)
source_xml=[]
source_xml.append(path_sorce)
properties={}
cs_wkt = 'LOCAL_CS["NonEarth_Meter",UNIT["METER",1]]'
cs_wkt='+proj=tmerc +lat_0=0 +lon_0=78.05 +k=1 +x_0=4500000 +y_0=-5811057.63 +ellps=krass +towgs84=23.57,-140.95,-79.8,0,0.35,0.79,-0.22 +units=m +no_defs'
cs_wkt='PROJCS["unknown",GEOGCS["unknown",DATUM["Unknown based on Krassovsky, 1942 ellipsoid using towgs84=23.57,-140.95,-79.8,0,0.35,0.79,-0.22",SPHEROID["Krassovsky, 1942",6378245,298.3],TOWGS84[23.57,-140.95,-79.8,0,0.35,0.79,-0.22]],PRIMEM["Greenwich",0,AUTHORITY["EPSG","8901"]],UNIT["degree",0.0174532925199433,AUTHORITY["EPSG","9122"]]],PROJECTION["Transverse_Mercator"],PARAMETER["latitude_of_origin",0],PARAMETER["central_meridian",78.05],PARAMETER["scale_factor",1],PARAMETER["false_easting",4500000],PARAMETER["false_northing",-5811057.63],UNIT["metre",1,AUTHORITY["EPSG","9001"]],AXIS["Easting",EAST],AXIS["Northing",NORTH]]'
properties['cs']=cs_wkt
properties['cs_mi']='NonEarth Units "m" '
properties['reverseXY']=True
properties['egrn']= {}
cls_sourceXml=DataSourceXml()
count=cls_sourceXml.build(source_xml)
jkl=0
dbCatalog=KptСatalog()
dbDoc = None

dbDoc = DocumentsDb(path_out)
db = DbGeoOgr(dbCatalog)
db.Create(path_out, TypeGeometryProviderOgr.GPKG)
db.Close()
dbDoc.close()
file_source,value_file=cls_sourceXml.getSource(0)
value_string_no_utf8=value_file.replace('<?xml version="1.0" encoding="utf-8"?>','')
value_string_no_utf8=value_file.replace('<?xml version="1.0" encoding="UTF-8"?>','')
cls_import=factoryKptObj(value_string_no_utf8,properties)
#cls_import=EgrnImport(cls_sourceXml.getSource(0),None)
cls_import.setPathOut(path_out)
cls_import.run()
print("end")