import traceback

import axipy
from axipy import Plugin, local_file, menubar, tr, ObserverManager, data_manager

from deleteDouble.ui.DlgDeleteDouble import DlgDoubleRow


class Plugin(Plugin):
    __nameObserver="EditableTable_Tab"
    def load(self):
        self.__observer=None
        self.__observer=ObserverManager.get(self.__nameObserver)
        if self.__observer is None:
            self.__observer=ObserverManager.create(self.__nameObserver,False)
        data_manager.updated.connect(self.__isEvailabel)
        self.__action = self.create_action('Удаление дублирующихся записей',icon=local_file('ui/icons', 'delete_double_32x32.png'), on_click=self.run_tools,enable_on = self. __nameObserver)
        position = menubar.get_position(tr('Таблица'), tr('Действия'))
        position.add(self.__action, size=2)
        self.__isEvailabel()
        # print("Get catalog")
        self.__catalog = axipy.app.mainwindow.catalog
    def run_tools(self):
        dlgDelete=DlgDoubleRow(axipy.app.mainwindow.qt_object())
        try:
            dlgDelete.show()
        except Exception as ex:
            traceback.print_exc()
            dlgDelete.close()
    def __isEvailabel(self):
        tables=data_manager.tables
        for tab in tables:
            if tab.is_spatial and tab.is_editable and (tab.provider=='TabDataProvider') and tab.count()>0:
                self.__observer.value=True
                return
        self.__observer.value = False
    def unload(self):
        data_manager.updated.disconnect(self.__isEvailabel)
        ObserverManager.remove(self.__nameObserver)
        ()


