import os
import shutil
from pathlib import Path

import axipy
from PySide2 import QtCore
from PySide2.QtCore import QFile, QThread
from PySide2.QtGui import QIcon
from PySide2.QtUiTools import QUiLoader
from PySide2.QtWidgets import QWidget, QFileDialog, QApplication
from axipy import selection_manager, show_dialog, DlgIcon, DlgButtons

from CopyMws.ui.processtool.Observers import factoryObserverSelectPolygons, selectionIsPolygons, \
    factoryObserverSelectPolygonsNew
from .processtool.addTools.helper_file import rmdir, clearFolder
from .processtool.copyMws import ProcessCopyMws


class dlgFormCopyMws(QWidget):
    cancelProcess = QtCore.Signal()
    def __init__(self,parent=None):
        super(dlgFormCopyMws, self).__init__(parent)
        self.__observer=factoryObserverSelectPolygonsNew("SelectPolygon")
        self.__parentWin=parent
        self.load_ui('FormCopyMws.ui')
        self.load_ui('FormCopyMws3.ui')
        curent_path = str(Path(__file__).parent)
        path_icon = os.path.join(curent_path, "icons")
        path_add_png = os.path.join(path_icon, "open-32.png")
        path_save_png = os.path.join(path_icon, "saveas.png")
        self.window.pb_open.setIcon(QIcon(path_add_png))
        self.window.pb_save.setIcon(QIcon(path_save_png))
        self.window.pb_open.clicked.connect(self.__select_source)
        self.window.pb_save.clicked.connect(self.__select_destination)
        self.window.pb_cancel.clicked.connect(self.__cancel)
        self.window.pb_run.clicked.connect(self.__run)

        self.__dlgSelectSourceMws=None
        self.__destinationFolderMws=None
        self.__observer=factoryObserverSelectPolygonsNew("SelectPolygons")
        self.__observer.changed.connect(self.__selectPoly)

        self.setEnabledFilter(selectionIsPolygons())
        #self.__observer.changed.connect(self.__change_value_observer)
    def load_ui(self,name_resource):
        loader = QUiLoader()
        path = os.path.join(os.path.dirname(__file__),name_resource)
        ui_file = QFile(path)
        ui_file.open(QFile.ReadOnly)
        self.window  = loader.load(ui_file,self.__parentWin)
        ui_file.close()
    def show(self):
        self.window.show()
    def __select_source(self):
        if self.__dlgSelectSourceMws is None:
            path_appData = os.path.expanduser('~/Documents')
            self.__dlgSelectSourceMws = QFileDialog(self.window, "Выбрать исходный рабочий набор", path_appData, "Mws (*.mws)")
            self.__dlgSelectSourceMws.setFileMode(QFileDialog.FileMode.ExistingFiles)
        if self.__dlgSelectSourceMws.exec_():
            filenames = self.__dlgSelectSourceMws.selectedFiles()
            file_wor=filenames[0]
            self.window.ln_source_mws.setText(file_wor)
            self.__dlgSelectSourceMws.setDirectory(str(Path(file_wor).parent))
            self. __enableRun()
    def __select_destination(self):

        if self.__destinationFolderMws is None:
            self.__destinationFolderMws = os.path.expanduser('~/Documents')

        #if self.__dlgSelectDestinationeMws.exec_():
        filenames = QFileDialog.getSaveFileName(parent=self.window, caption="Копия рабочего наборa",dir=self.__destinationFolderMws, filter = "Mws (*.mws)")
        if not(filenames[0]==''):

            file_wor=filenames[0]
            path_folder=Path(file_wor).parent
            isOkResult=self.__resultTryResultFolder(str(path_folder))
            if not isOkResult:
                return

            self.window.ln_destination.setText(file_wor)
            self.__destinationFolderMws=str(Path(file_wor).parent)
            self.__enableRun()
    def __enableRun(self):
        if self.window.ln_source_mws.text()=='' or not Path(self.window.ln_source_mws.text()).exists():
            self.window.pb_run.setEnabled(False)
            return
        if self.window.ln_destination.text()=='' or not Path(self.window.ln_destination.text()).parent.exists():
            self.window.pb_run.setEnabled(False)
            return
        self.window.pb_run.setEnabled(True)
    def __cancel(self):
        if self.__process is not None:
            self.__process_status = False
            self.cancelProcess.emit()
            self.__process.setCancel()
    def __update_progress(self, value):
        self.window.progress_process.setValue(value)
        import time
        time.sleep(0.0001)
        QApplication.processEvents()
    def __change_selectPoly(self):
        jkl=0

        # print(value)
        import time
        time.sleep(0.0001)
        QApplication.processEvents()
    def __setFormatprogressBar(self, str_format):
        self.window.progress_process.setFormat(str_format)
        import time
        time.sleep(0.0001)
        QApplication.processEvents()
    def __end_process(self, value):
        self.window.pb_cancel.setEnabled(False)
        self.window.pb_run.setEnabled(True)
        if value == 100:
            pass
        else:
            '''
            if os.path.exists(self.__path_out_raster):
                os.remove(self.__path_out_raster)
            Notifications.push('Объединение растров', 'Было преррвано', Notifications.Information)
            '''
            pass
        self.__process=None
    def __run(self):
        isOkResult=self.__resultTryResultFolder(str(self.__destinationFolderMws))
        if not isOkResult:
            self.window.pb_run.setEnabled(False)
            return
        self.window.pb_run.setEnabled(False)
        self.window.pb_cancel.setEnabled(True)
        geometry_filter=None
        if self.window.ch_sp_filter and  axipy.gui.selection_manager.count==1:
            for ft in selection_manager.get_as_cursor():
                geometry_filter=ft.geometry.clone()

        self.__process = ProcessCopyMws("Загрузка рабочего набора", self)
        self.__process.setParams({'source': self.window.ln_source_mws.text(),'dest':self.window.ln_destination.text(),'geometry_filter':geometry_filter})
        self.__process.updateProcess.connect(self.__update_progress)
        self.__process.finished.connect(self.__end_process)
        self.__process.updateFormatProgressBar.connect(self.__setFormatprogressBar)
        self.thread = QThread()
        self.__process.moveToThread(self.thread)
        self.__process.run()
    def __selectPoly(self):
        if self.__observer.value:
            self.window.ch_sp_filter.setEnabled(True)
        else:
            self.window.ch_sp_filter.setEnabled(False)
    def __change_value_observer(self):
        self.window.ch_sp_filter.setEnabled(self.__observer.value)

    def setEnabledFilter(self,value):
        self.window.ch_sp_filter.setEnabled(value)
    def resizeEvent(self):
        jkl=0
    def __resultTryResultFolder(self,path_folder):
        list_contain_folder = os.listdir(str(path_folder))
        if len(list_contain_folder) > 0:
            res = show_dialog('Результирующая директория не пуста. Очистить?', 'Копирование mws',
                              icon=DlgIcon.QUESTION,
                              default_button=DlgButtons.CANCEL,
                              buttons=DlgButtons.YES_NO_CANCEL)
            if res == DlgButtons.YES:
                try:
                    # shutil.rmtree(str(path_folder))
                    clearFolder(str(path_folder))
                    return True
                except:
                    axipy.Notifications.push("Копирование mws",
                                             "Очистить директорию:" + str(path_folder) + " не удалось",
                                             axipy.Notifications.Critical)
                    return False
            if res == DlgButtons.CANCEL:
                return False
            return True
        return True
    @property
    def widget(self):
        return self.window



