"""
Модуль отрисовки.

Данный модуль содержит инструменты, предназначенные для отрисовки геопространственных и
прочих данных.
"""

from .clip import *
from .context import *
from .label import *
from .layer import *
from .legend import *
from .map_ import *
from .report import *
from .thematic_layer import *


def __getattr__(name: str):
    """Backwards compatibility."""
    old_names = {
        "map": map_,
    }
    if name in old_names:
        return old_names[name]

    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")
