"""
Модуль пользовательского интерфейса.

В данном модуле содержатся классы связанные с пользовательским интерфейсом.
"""

from .action_manager import *
from .active_tool_panel import *
from .deactivation_reason import *
from .dialog import *
from .gui_class import *
from .map_tool import *
from .message import *
from .notifications import *
from .selection_manager_ import *
from .target_manager_ import *
from .view import *
from .view_manager_ import *
from .view_tool import *
from .widgets import *
from .workspace import *

DialogWrapper = dialog
SelectionManagerWrapper = selection_manager_
ToolWrapper = map_tool
view_manager_wrapper = view_manager_
ViewWrapper = view
WidgetWrapper = widgets


def __getattr__(name: str):
    """Backwards compatibility."""
    old_names = {
        "ActiveToolPanel": active_tool_panel,
        "DialogWrapper": dialog,
        "SelectionManagerWrapper": selection_manager_,
        "ToolWrapper": map_tool,
        "view_manager_wrapper": view_manager_,
        "ViewWrapper": view,
        "WidgetWrapper": widgets,
        "Workspace": workspace,
    }
    if name in old_names:
        return old_names[name]

    raise AttributeError(f"module {__name__!r} has no attribute {name!r}")


"""
Attributes:
    view_manager (ViewManager): Экземпляр менеджера содержимого окон.
    selection_manager (SelectionManager): Экземпляр доступа к выделенным объектам.
"""
