from typing import Dict, List

__all__: List[str] = [
    "WebOpenData",
]


class WebOpenData(dict):
    """
    Дополнительные данные, которые используются при открытии WEB источников.

    Пример открытия источника WMS::

        open_data = WebOpenData()
        open_data.header = {"referer": "referer_value"}
        open_data.authenticator = {"user": "nyuser", "password": "mypass"}
        wms_raster = provider_manager.wms.open('http://www.mapinfo.com/miwms', ['World'], prj='EPSG:4326', style='AreaStyleGreen', extra_data=open_data)
    """

    @property
    def header(self) -> Dict[str, str]:
        """
        Устанавливает или возвращает словарь, содержащий заголовки HTTP-запросов.
        К примеру, {'referer': 'referer_value'}.
        """
        return self.get("header", {})

    @header.setter
    def header(self, v: Dict[str, str]) -> None:
        self["header"] = v

    @property
    def authenticator(self) -> Dict[str, str]:
        """
        Устанавливает или возвращает словарь, содержащий данные для аутентификации.
        К примеру, {'user': 'myuser', 'password': 'mypassword'}.
        """
        return self.get("authenticator", {})

    @authenticator.setter
    def authenticator(self, v: Dict[str, str]) -> None:
        self["authenticator"] = v
