from typing import Any, List

import axipy

from .data_provider import DataProvider
from .source import Destination, Source

__all__: List[str] = [
    "GenericSource",
    "GenericDestination",
    "GenericDataProvider",
]


class GenericSource(Source):
    pass


class GenericDestination(Destination):
    pass


class GenericDataProvider(DataProvider):
    def get_source(self, filepath: str, **kwargs: Any) -> Source:
        return GenericSource(Source._provider(self.id), Source._table_file(filepath), kwargs)

    def get_destination(self, **kwargs: Any) -> Destination:
        if "export" not in self.info:
            raise NotImplementedError
        return GenericDestination(axipy.Schema(), Source._provider(self.id), kwargs)
