from typing import ItemsView, KeysView, List, ValuesView

__all__: List[str] = [
    "KeysViewExtended",
    "ValuesViewExtended",
    "ItemsViewExtended",
]


class KeysViewExtended(KeysView):
    def __str__(self) -> str:
        return f"KeysView([{', '.join(repr(elem) for elem in self)}])"


class ValuesViewExtended(ValuesView):
    def __str__(self) -> str:
        return f"ValuesView([{', '.join(repr(elem) for elem in self)}])"


class ItemsViewExtended(ItemsView):
    def __str__(self) -> str:
        return f"ItemsView([{', '.join(repr(elem) for elem in self)}])"
