"""
Основной пакет API для взаимодействия с ГИС Аксиома.

Предоставляет доступ к Аксиоме.ГИС через набор модулей, подмодулей, классов и функций.
"""

from ._internal import _apply_all
from .app import *
from .axioma_plugin import *
from .concurrent import *
from .core import *
from .cs import *
from .da import *
from .gui import *
from .gui.clipboard_manager_ import *
from .gui.target_manager_ import _TargetObjectManager
from .initialization import *
from .interface import *
from .menubar import *
from .mi import *
from .plugin import *
from .plugin_manager_ import *
from .render import *
from .settings import *
from .sql import *
from .utils import *
from .utl import *

data_manager = DataManager()
"""Менеджер объектов данных (:class:`axipy.DataManager`)."""

view_manager = ViewManager()
"""Менеджер содержимого окон (:class:`axipy.ViewManager`)."""

provider_manager = ProviderManager()
"""Менеджер провайдеров данных (Открытие/создание объектов данных)
(:class:`axipy.ProviderManager`)."""

selection_manager = SelectionManager()
"""Менеджер выборки (выделенных объектов) (:class:`axipy.SelectionManager`)."""

task_manager = TaskManager()
"""Менеджер пользовательских задач (:class:`axipy.TaskManager`)."""

action_manager = ActionManager()
"""Менеджер действий Аксиомы (:class:`axipy.ActionManager`)."""

observer_manager = ObserverManager()
"""Менеджер наблюдателей (:class:`axipy.ObserverManager`)."""

plugin_manager = PluginManager()
"""Менеджер плагинов (:class:`axipy.PluginManager`)."""

foreign_key_manager = ForeignKeyManager()
"""Менеджер связей между таблицами (:class:`axipy.ForeignKeyManager`)."""

_target_object_manager = _TargetObjectManager()
"""Экземпляр доступа к отмеченным для изменения объектам (:class:`axipy._TargetObjectManager`)."""

_clipboard_manager = _ClipboardManager()
"""Менеджер работы с буфером обмена (:class:`axipy._ClipboardManager`)."""

mainwindow = mainwindow
"""Готовый экземпляр главного окна ГИС Аксиома. (:class:`axipy.MainWindow`)."""

_apply_all()
