from typing import NamedTuple

from PySide2.QtCore import QLocale
from axipy import PointFontStyle


class Col(NamedTuple):
    x1 = 0
    y1 = 1
    x2 = 2
    y2 = 3
    Error = 4


SOURCE_RANGE = (Col.x1, Col.y1)
TARGET_RANGE = (Col.x2, Col.y2)

FLOAT_FORMAT = {"locale": QLocale.English}

POINT_STYLE_MI = PointFontStyle()
POINT_STYLE_MI.font_name = 'Axioma MI MapSymbols'
POINT_STYLE_MI.has_shadow = False
POINT_STYLE_MI.rotation = 0.0
POINT_STYLE_MI.bold = True
POINT_STYLE_MI.size = 14
POINT_STYLE_MI.symbol = 50
POINT_STYLE_MI.black_border = False
POINT_STYLE_MI.white_border = True
