from typing import Final

import axipy
from PySide2.QtCore import Qt
from PySide2.QtGui import QIcon
from .dialog import Dialog
from .observer import SpatialTablesObserver

ICON_NAME: Final[str] = "find_no_geometry"


class FindFeaturesNoGeom(axipy.Plugin):

    def __init__(self) -> None:
        self.title = self.tr("Записи без объектов")

        self._spatial_tables_observer = SpatialTablesObserver()

        self._button = axipy.ActionButton(
            title=self.title,
            tooltip=self.tr("Поиск записей таблицы, не содержащих геометрические объекты"),
            on_click=self.on_click,
            enable_on=self._spatial_tables_observer,
            icon=QIcon.fromTheme(ICON_NAME),
        )

        position = axipy.Position(self.tr("Таблица"), self.tr("Записи"))
        position.add(self._button)

    def on_click(self) -> None:
        dialog_ = Dialog(self, axipy.view_manager.global_parent)
        dialog_.setAttribute(Qt.WA_DeleteOnClose, True)
        dialog_.setWindowIcon(QIcon.fromTheme(ICON_NAME))
        dialog_.open()

    def unload(self) -> None:
        self._spatial_tables_observer.unload()
        self._button.remove()
