from __future__ import annotations

from typing import Final

import axipy
from PySide2.QtCore import QSize
from PySide2.QtGui import QIcon
from .map_tool import CollectionOrderEditorMapTool
from .observer import CollectionOrderEditorObserver
from .utils import ICON_PATH

ICON_NAME: Final[str] = "sort_collection.png"

ICON_SIZES: Final[tuple[int, ...]] = (16, 24, 32)


class CollectionOrderEditor(axipy.Plugin):

    def __init__(self) -> None:
        self.title: str = self.tr("Упорядочить коллекцию")
        tooltip: str = self.tr("Модуль для изменения порядка элементов в коллекции.")

        self._observer = CollectionOrderEditorObserver()

        self._button = axipy.ToolButton(
            title=self.title,
            tooltip=tooltip,
            on_click=lambda: CollectionOrderEditorMapTool(self),
            enable_on=self._observer,
            icon=self._create_icon()
        )

        position = axipy.Position(self.tr("Основные"), self.tr("Команды"))
        position.add(self._button)

    def _create_icon(self) -> QIcon:
        icon = QIcon()
        for size in ICON_SIZES:
            icon_path: str = str(ICON_PATH / f"{size}px" / ICON_NAME)
            icon.addFile(icon_path, QSize(size, size))
        return icon

    def unload(self) -> None:
        self._observer.unload()
        self._button.remove()
