from typing import Union, Iterable, Any, Generator

import axipy
from PySide2.QtCore import Signal
from axipy._internal._observer_abc import _ObserverABC

__all__ = [
    "get_query_tables",
    "QueryTablesObserver",
]


def get_query_tables() -> Generator[Union[axipy.QueryTable, axipy.SelectionTable], Any, None]:
    objects = axipy.data_manager.objects
    main_selection = axipy.data_manager.selection
    if main_selection is not None and main_selection in objects:
        objects.remove(main_selection)

    for data_object in objects:
        if isinstance(data_object, (axipy.QueryTable, axipy.SelectionTable)):
            yield data_object


class QueryTablesObserver(_ObserverABC):
    @property
    def name(self) -> str:
        return "ru_axioma_gis_close_all_queries_QueryTablesObserver"

    @property
    def signals(self) -> Union[Signal, Iterable[Signal]]:
        return axipy.data_manager.updated

    def test_value(self) -> bool:
        return any(get_query_tables())
