from typing import TYPE_CHECKING

import axipy
from PySide2.QtCore import Slot
from PySide2.QtGui import QIcon

from .map_tool import ChooseStartingPointMapTool
from .observer import ChooseStartingPointObserver

if TYPE_CHECKING:
    from ... import CadTools

__all__ = [
    "ChooseStartingPointToolButton",
]


# noinspection PyMethodMayBeStatic
class ChooseStartingPointToolButton(axipy.ToolButton):

    def __init__(
        self,
        plugin: "CadTools",
    ) -> None:
        self.plugin: "CadTools" = plugin
        self.title: str = self.plugin.tr("Выбрать первую точку контура")
        self.icon: QIcon = QIcon.fromTheme("contour_start")
        self.tooltip: str = self.plugin.tr("")
        self.choose_starting_point_observer: ChooseStartingPointObserver = ChooseStartingPointObserver()
        super().__init__(self.title, self.on_click, self.icon, self.choose_starting_point_observer, self.tooltip)

    def on_click(self) -> ChooseStartingPointMapTool:
        return ChooseStartingPointMapTool(self)

    def remove(self) -> None:
        self.choose_starting_point_observer.unload()
        super().remove()
