#from building_construction import BuildingLandConstruction
from rosreestrXml.ui.tools.KPT.cadastral_plan_territory.building_construction import BuildingLandConstruction
#from spatial_bound import SpatialDataKvartal
#from zones_and_territories_boundaries import Zones, Municipal_boundaries

from rosreestrXml.ui.tools.KPT.cadastral_plan_territory.kpt_11 import parseString
from rosreestrXml.ui.tools.KPT.cadastral_plan_territory.spatial_bound import SpatialDataKvartal
from rosreestrXml.ui.tools.KPT.cadastral_plan_territory.zones_and_territories_boundaries import Zones, \
    Municipal_boundaries


class XmlCadastralBlock:
    __cadastralNumber=None

    def __init__(self,xmlTagCadBlock ,cadastrNumber):
        self.__objCadastrBlock=xmlTagCadBlock
        self.__cadastralNumber = cadastrNumber
        self.__objects= {}
        self.__name_obj=['zones','municipal','spatial','сonstruction_building']
    def builds(self,property_obj):
        for itemObj in self.__name_obj:
            if itemObj =="zones" and ('zones' in property_obj):
                if property_obj["zones"]['enable']:
                    if self.__objCadastrBlock.zones_and_territories_boundaries is None:
                        continue
                    self.__objects['zones']=Zones(self.__objCadastrBlock.zones_and_territories_boundaries,self.__cadastralNumber,property_obj)
            if itemObj =="municipal" and 'municipal' in property_obj:
                if property_obj["municipal"]['enable']:
                    if self.__objCadastrBlock.municipal_boundaries is None:
                        continue
                    objMunicipalBounds=Municipal_boundaries(self.__objCadastrBlock.municipal_boundaries,self.__cadastralNumber,property_obj)
                    #objMunicipalBounds.setName("муниципальные_границы")
                    self.__objects['municipal']=objMunicipalBounds
            if itemObj =="spatial" and 'spatial' in property_obj:
                if property_obj["spatial"]['enable']:
                    objMunicipalBounds=SpatialDataKvartal(self.__objCadastrBlock.spatial_data,self.__cadastralNumber,property_obj)
                    #objMunicipalBounds.setName("муниципальные_границы")
                    self.__objects['spatial']=objMunicipalBounds
            if itemObj =="сonstruction_building" and 'сonstruction_building' in property_obj:
                if property_obj["сonstruction_building"]['enable']:
                    if self.__objCadastrBlock.record_data is None or self.__objCadastrBlock.record_data.base_data is None:
                        continue
                    self.__objects['сonstruction_building'] = BuildingLandConstruction(self.__objCadastrBlock.record_data.base_data,
                                                                      self.__cadastralNumber, property_obj)
        return
        '''
        if 'land':
            if property_obj["land"]['enable']:
                self.__objects['land'] =BuildingLandConstruction(self.__objCadastrBlock.record_data.base_data,self.__cadastralNumber,property_obj)
        '''
    def builds_old(self,property_obj):
        for itemObj in self.__name_obj:
            if "zones" in property_obj:
                if property_obj["zones"]['enable']:
                    if self.__objCadastrBlock.zones_and_territories_boundaries is None:
                        continue
                    self.__objects['zones']=Zones(self.__objCadastrBlock.zones_and_territories_boundaries,self.__cadastralNumber,property_obj)
            if 'municipal' in property_obj:
                if property_obj["municipal"]['enable']:
                    if self.__objCadastrBlock.municipal_boundaries is None:
                        continue
                    objMunicipalBounds=Municipal_boundaries(self.__objCadastrBlock.municipal_boundaries,self.__cadastralNumber,property_obj)
                    #objMunicipalBounds.setName("муниципальные_границы")
                    self.__objects['municipal']=objMunicipalBounds
            if 'spatial' in property_obj:
                if property_obj["spatial"]['enable']:
                    objMunicipalBounds=SpatialDataKvartal(self.__objCadastrBlock.spatial_data,self.__cadastralNumber,property_obj)
                    #objMunicipalBounds.setName("муниципальные_границы")
                    self.__objects['spatial']=objMunicipalBounds
            if "сonstruction_building":
                if property_obj["сonstruction_building"]['enable']:
                    if self.__objCadastrBlock.record_data is None or self.__objCadastrBlock.record_data.base_data is None:
                        continue
                    self.__objects['сonstruction_building'] = BuildingLandConstruction(self.__objCadastrBlock.record_data.base_data,
                                                                      self.__cadastralNumber, property_obj)
        return
        '''
        if 'land':
            if property_obj["land"]['enable']:
                self.__objects['land'] =BuildingLandConstruction(self.__objCadastrBlock.record_data.base_data,self.__cadastralNumber,property_obj)
        '''

    def getObj(self,name):
        try:
            return self.__objects[name]
        except:
            return None
def getObjectToSave(cadBlock,property):
    out_obj=[]
    keysList = list(property.keys())
    for key in keysList:
        try:
            if property[key]['enable']:
                obj=cadBlock.getObj(key)
                if obj is not None:
                    out_obj.append(obj)
        except:
            pass
    if len(out_obj)==0:
        return None
    return out_obj
def FactoryCadastralBlock(tagCadastralBlock,property_style)  :

    cadNumber = tagCadastralBlock.cadastral_number
    objXml=XmlCadastralBlock(tagCadastralBlock,cadNumber)
    objXml.builds(property_style)
    return objXml
def FactoryKpt(objKpt,property_kpt11):
    cadBloks=[]
    for cadBlock in objKpt.cadastral_blocks.cadastral_block:
        cadBlock=FactoryCadastralBlock(cadBlock,property_kpt11)
        if cadBlock is None:
            continue
        cadBloks.append(cadBlock)
    return cadBloks
def FactoryKpt11FromString(source_xml,property):
    property_kpt11 = property['kpt11']
    property_kpt11['cs'] = property['cs']
    property_kpt11['cs_mi'] = property['cs_mi']
    property_kpt11['reverseXY'] = property['reverseXY']
    objKpt=parseString(source_xml,True)
    if objKpt is None:
        return None
    cadBloks=FactoryKpt(objKpt,property_kpt11)
    if cadBloks is None or len(cadBloks)==0:
        return None
    list_objToSave = []
    for cad_block in cadBloks:
        obj_to_save = getObjectToSave(cad_block, property_kpt11)
        if obj_to_save is not None:
            list_objToSave.extend(obj_to_save)
    if len(list_objToSave) > 0:
        return list_objToSave
    return None
