
from rosreestrXml.ui.tools.KPT.egrn_tool.EgrnObXml import FactoryEgrnObj
from rosreestrXml.ui.tools.KPT.egrn_tool.egrn import parse
from rosreestrXml.ui.tools.KPT.kptTools.DbKptDirectory import KptСatalog
from rosreestrXml.ui.tools.OutDrv.DbDocuments import DocumentsDb
from rosreestrXml.ui.tools.OutDrv.ObjectToSave import DbGeoOgr, TypeGeometryProviderOgr

path_kpt=r"E:\Download\RossRestr\Выписки_ЕГРН\report-64e84c11-0f2b-4dab-8fa3-d7b443cd1e8e-PKPVDMFC-2019-06-06-053200-53-01[0]V1.xml"
path_kpt=r"E:\Download\RossRestr\Выписки_ЕГРН\report-bcde620d-e548-4a1c-913d-d3c885a71166-OfSite-2023-03-06-1190978-72-01[0]-1.xml"
path_kpt=r"E:\Download\RossRestr\Выписки_ЕГРН\1_report1.xml"
path_out = r"E:\Download\RossRestr\Выписки_ЕГРН\testGpkgEGRN1_reportX2Z.gpkg"
# path_out="E:\\Support\\AxiomaTesting\\XMLKpt\\testGpkg.gpkg"

cs_proj4 = "+proj=eqc +R=6370997 +units=m +no_defs"
cs_wkt = 'LOCAL_CS["NonEarth_Meter",UNIT["METER",1]]'
propperies={}
propperies['cs']=cs_wkt
propperies['reverseXY']=True
propperies['points_parts']={}
propperies['points_parts']['enable']=False
propperies['points_parts']['style']='Symbol (35,0,9,"MapInfo Symbols",0,0) '
propperies['parts']={}
propperies['parts']['enable']=True
propperies['parts']['style']='Pen (1, 2, 0) Brush (1, 16777215, 16777215) '

propperies['contours']={}
propperies['contours']['enable']=False
propperies['contours']['style']='Pen (1, 2, 0) Brush (1, 16777215, 16777215) '
propperies['contours_points']={}
propperies['contours_points']['enable']=False
propperies['contours_points']['style']='Symbol (35,0,9,"MapInfo Symbols",0,0) '

ObjEgrn=parse(path_kpt,True)
if ObjEgrn is not None:
    dbCatalog = KptСatalog()
    dbDoc = None
    dbDoc = DocumentsDb(path_out)
    db = DbGeoOgr(dbCatalog)
    db.Create(path_out, TypeGeometryProviderOgr.GPKG)
    db.setDbDocuments(dbDoc)
    obkToSave=FactoryEgrnObj(ObjEgrn,propperies)
    for i,objSave in enumerate(obkToSave):
        print(objSave.NameProcess)
        print(i)
        db.Save(objSave)
        print(objSave.NameLayer)
    db.Close()
print("END")