import axipy
from axipy import Rect

from LoadMiWor.ui.processTool.parserWor.ParserMiCommand.addInParsers import getSyleObjects
from LoadMiWor.ui.processTool.parserWor.parse import parse
from LoadMiWor.ui.processTool.utils import tokenPointToPnt, UnitsFromString, calcSizeScreenRect


class BrowseTable:
    def __init__(self,source_tree,index_record_browse,source_line):
        self.style=None
        self.__view_table,self.__rect_view=self.openBrowseTable(source_tree,index_record_browse,source_line)
    @property
    def table_view(self):
        return self.__view_table
    @property
    def rect(self):
        return self.__rect_view
    @property
    def position_object(self):
        return self.__rect_view
    #@staticmethod
    def openBrowseTable(self,source_tree,index_record_browse,source_line):
        item_browse=source_tree[index_record_browse]
        if len(item_browse['words'])==1:
            ''' Явно отображение таблицы списком с перечислением полей'''

            return None,None
        if len(item_browse['words'])==3:
            ''' Простейшее описание'''
            token_position_width=None
            token_position=None
            name_table=item_browse['words'][2]
            tab=axipy.da.data_manager.find(name_table)
            if tab is None:
                ''' Таблица не найдена'''
                return None,name_table
            table_view = axipy.gui.view_manager.create_tableview(tab)
            for item in item_browse['children']:
                if item['key'].lower()=='position':
                    line_position=source_line[item['index']]
                    token_position=parse('Position ({point}) Units "{unit}"',line_position.strip())
                    position_win_map=tokenPointToPnt(token_position.named['point'])
                    unit_pos=UnitsFromString(token_position.named['unit'])
                    continue
                if item['key'].lower()=='width':

                    line__width=source_line[item['index']].strip()
                    token_position_width=parse('Width {width} Units "{w_unit}" Height {height} Units "{h_unit}"',line__width)
                    width_map_obj={"value":float(token_position_width.named['width']),"unit":token_position_width.named['w_unit']}
                    height_obj={"value":float(token_position_width.named['height']),"unit":token_position_width.named['h_unit']}
                    continue
                if item['key'].lower() == 'brush' or item['key'].lower() == 'pen':
                    mi_str = source_line[item['index']].strip()
                    self.style = getSyleObjects(mi_str)
                    continue
            if token_position is None or token_position_width is None:
                return table_view,"Not find size"
            rect=calcSizeScreenRect(position_win_map,unit_pos,width_map_obj,height_obj)
            possition_obj = {'position': position_win_map, 'unit': unit_pos}
            rect_view_table=Rect(possition_obj['position'].x, possition_obj['position'].y,
                 possition_obj['position'].x + width_map_obj['value'],
                 possition_obj['position'].y + height_obj['value'])
            table_view.position=rect
            return table_view,rect_view_table


