from LoadMiWor.ui.processTool.parserWor.parse import search
def parserStyle(pattern,name,mi_str):
    token=search(pattern,mi_str)
    if token is None:
        return None
    return name+" ("+token['value']+")"
def getStyle(mi_str):
    brush_style=parserStyle("Brush ({value})","Brush",mi_str)
    pen_style=parserStyle("Pen ({value})","Pen",mi_str)
    if pen_style is None:
        pen_style = parserStyle("Line ({value})", "Pen", mi_str)
    symbol=parserStyle("Symbol ({value})","Symbol",mi_str)
    result=''
    if brush_style is not None:
        result=result+brush_style
    if pen_style is not None:
        result=result+" "+pen_style
    if symbol is not None:
        result=result+" "+symbol
    return result
def getSyleObjects(mi_str)->dict:
    brush_style=parserStyle("Brush ({value})","Brush",mi_str)
    pen_style=parserStyle("Pen ({value})","Pen",mi_str)
    symbol=parserStyle("Symbol ({value})","Symbol",mi_str)
    font=parserStyle("Font ({value})","Font",mi_str)
    line=parserStyle("Line ({value})","Line",mi_str)
    dict_style={'brush':brush_style,'pen':pen_style,'line':line,'symbol':symbol,'font':font}
    return dict_style
def prepareStringIndvidualValue(mi_str:str):
    value=None
    token_str_value=search('"{value}" ',mi_str)
    if token_str_value is not None:
        value=token_str_value['value']
        out_value=value
    if value is None:
        ''' Возможно зачение число '''

        token=search('{value} ',mi_str)
        if token is None:
            return None,None
        value=token['value']
        if value=='default':
            return None,None
        if value.isnumeric():
            if value.isdigit():
                out_value=int(value)
            else:
                out_value=float(value)
        out_value=value
    mi_style=getStyle(mi_str)
    return out_value,mi_style
def prepareStringRangeValue(mi_str:str):
    token = search('{value_low}:{value_max} ', mi_str)
    str_value_low = token['value_low']
    str_value_high = token['value_max']
    return str_value_low,str_value_high

