from typing import overload
import PySide2.QtCore
import PySide2.QtNetwork
import shiboken2
import typing
T = typing.TypeVar('T')

class QMaskGenerator(PySide2.QtCore.QObject):
    destroyed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    objectNameChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def nextMask(self) -> int: ...
    def seed(self) -> bool: ...

class QWebSocket(PySide2.QtCore.QObject):
    aboutToClose: typing.ClassVar[PySide2.QtCore.Signal] = ...
    binaryFrameReceived: typing.ClassVar[PySide2.QtCore.Signal] = ...
    binaryMessageReceived: typing.ClassVar[PySide2.QtCore.Signal] = ...
    bytesWritten: typing.ClassVar[PySide2.QtCore.Signal] = ...
    connected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    disconnected: typing.ClassVar[PySide2.QtCore.Signal] = ...
    error: typing.ClassVar[PySide2.QtCore.Signal] = ...
    pong: typing.ClassVar[PySide2.QtCore.Signal] = ...
    preSharedKeyAuthenticationRequired: typing.ClassVar[PySide2.QtCore.Signal] = ...
    proxyAuthenticationRequired: typing.ClassVar[PySide2.QtCore.Signal] = ...
    readChannelFinished: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sslErrors: typing.ClassVar[PySide2.QtCore.Signal] = ...
    stateChanged: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    textFrameReceived: typing.ClassVar[PySide2.QtCore.Signal] = ...
    textMessageReceived: typing.ClassVar[PySide2.QtCore.Signal] = ...
    def __init__(self, origin: str = ..., version: QWebSocketProtocol.Version = ..., parent: typing.Union[PySide2.QtCore.QObject,None] = ..., aboutToClose: typing.Callable = ..., binaryFrameReceived: typing.Callable = ..., binaryMessageReceived: typing.Callable = ..., bytesWritten: typing.Callable = ..., connected: typing.Callable = ..., destroyed: typing.Callable = ..., disconnected: typing.Callable = ..., error: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ..., pong: typing.Callable = ..., preSharedKeyAuthenticationRequired: typing.Callable = ..., proxyAuthenticationRequired: typing.Callable = ..., readChannelFinished: typing.Callable = ..., sslErrors: typing.Callable = ..., stateChanged: typing.Callable = ..., textFrameReceived: typing.Callable = ..., textMessageReceived: typing.Callable = ...) -> None: ...
    def abort(self) -> None: ...
    def bytesToWrite(self) -> int: ...
    def close(self, closeCode: QWebSocketProtocol.CloseCode = ..., reason: str = ...) -> None: ...
    def closeCode(self) -> QWebSocketProtocol.CloseCode: ...
    def closeReason(self) -> str: ...
    def errorString(self) -> str: ...
    def flush(self) -> bool: ...
    def isValid(self) -> bool: ...
    def localAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def localPort(self) -> int: ...
    def maskGenerator(self) -> QMaskGenerator: ...
    def maxAllowedIncomingFrameSize(self) -> int: ...
    def maxAllowedIncomingMessageSize(self) -> int: ...
    @classmethod
    def maxIncomingFrameSize(cls) -> int: ...
    @classmethod
    def maxIncomingMessageSize(cls) -> int: ...
    @classmethod
    def maxOutgoingFrameSize(cls) -> int: ...
    @overload
    def open(self, request: PySide2.QtNetwork.QNetworkRequest) -> None: ...
    @overload
    def open(self, url: PySide2.QtCore.QUrl) -> None: ...
    def origin(self) -> str: ...
    def outgoingFrameSize(self) -> int: ...
    def pauseMode(self) -> typing.Union[PySide2.QtNetwork.QAbstractSocket.PauseModes,PySide2.QtNetwork.QAbstractSocket.PauseMode]: ...
    def peerAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def peerName(self) -> str: ...
    def peerPort(self) -> int: ...
    def ping(self, payload: typing.Union[PySide2.QtCore.QByteArray,bytes] = ...) -> None: ...
    def proxy(self) -> PySide2.QtNetwork.QNetworkProxy: ...
    def readBufferSize(self) -> int: ...
    def request(self) -> PySide2.QtNetwork.QNetworkRequest: ...
    def requestUrl(self) -> PySide2.QtCore.QUrl: ...
    def resourceName(self) -> str: ...
    def resume(self) -> None: ...
    def sendBinaryMessage(self, data: typing.Union[PySide2.QtCore.QByteArray,bytes]) -> int: ...
    def sendTextMessage(self, message: str) -> int: ...
    def setMaskGenerator(self, maskGenerator: QMaskGenerator) -> None: ...
    def setMaxAllowedIncomingFrameSize(self, maxAllowedIncomingFrameSize: int) -> None: ...
    def setMaxAllowedIncomingMessageSize(self, maxAllowedIncomingMessageSize: int) -> None: ...
    def setOutgoingFrameSize(self, outgoingFrameSize: int) -> None: ...
    def setPauseMode(self, pauseMode: typing.Union[PySide2.QtNetwork.QAbstractSocket.PauseModes,PySide2.QtNetwork.QAbstractSocket.PauseMode]) -> None: ...
    def setProxy(self, networkProxy: PySide2.QtNetwork.QNetworkProxy) -> None: ...
    def setReadBufferSize(self, size: int) -> None: ...
    def state(self) -> PySide2.QtNetwork.QAbstractSocket.SocketState: ...
    def version(self) -> QWebSocketProtocol.Version: ...

class QWebSocketCorsAuthenticator(shiboken2.Object):
    @overload
    def __init__(self, origin: str) -> None: ...
    @overload
    def __init__(self, other: QWebSocketCorsAuthenticator) -> None: ...
    def allowed(self) -> bool: ...
    def origin(self) -> str: ...
    def setAllowed(self, allowed: bool) -> None: ...
    def swap(self, other: QWebSocketCorsAuthenticator) -> None: ...

class QWebSocketProtocol(shiboken2.Object):
    class CloseCode:
        CloseCodeAbnormalDisconnection: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
        CloseCodeBadOperation: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
        CloseCodeDatatypeNotSupported: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
        CloseCodeGoingAway: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
        CloseCodeMissingExtension: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
        CloseCodeMissingStatusCode: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
        CloseCodeNormal: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
        CloseCodePolicyViolated: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
        CloseCodeProtocolError: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
        CloseCodeReserved1004: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
        CloseCodeTlsHandshakeFailed: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
        CloseCodeTooMuchData: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
        CloseCodeWrongDatatype: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebSocketProtocol.CloseCode: ...
        def __and__(self, other: typing.SupportsInt) -> QWebSocketProtocol.CloseCode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebSocketProtocol.CloseCode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebSocketProtocol.CloseCode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebSocketProtocol.CloseCode: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebSocketProtocol.CloseCode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebSocketProtocol.CloseCode: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebSocketProtocol.CloseCode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebSocketProtocol.CloseCode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebSocketProtocol.CloseCode: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebSocketProtocol.CloseCode: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebSocketProtocol.CloseCode: ...

    class Version:
        Version0: typing.ClassVar[QWebSocketProtocol.Version] = ...
        Version13: typing.ClassVar[QWebSocketProtocol.Version] = ...
        Version4: typing.ClassVar[QWebSocketProtocol.Version] = ...
        Version5: typing.ClassVar[QWebSocketProtocol.Version] = ...
        Version6: typing.ClassVar[QWebSocketProtocol.Version] = ...
        Version7: typing.ClassVar[QWebSocketProtocol.Version] = ...
        Version8: typing.ClassVar[QWebSocketProtocol.Version] = ...
        VersionLatest: typing.ClassVar[QWebSocketProtocol.Version] = ...
        VersionUnknown: typing.ClassVar[QWebSocketProtocol.Version] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebSocketProtocol.Version: ...
        def __and__(self, other: typing.SupportsInt) -> QWebSocketProtocol.Version: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebSocketProtocol.Version: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebSocketProtocol.Version: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebSocketProtocol.Version: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebSocketProtocol.Version: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebSocketProtocol.Version: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebSocketProtocol.Version: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebSocketProtocol.Version: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebSocketProtocol.Version: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebSocketProtocol.Version: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebSocketProtocol.Version: ...
    CloseCodeAbnormalDisconnection: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
    CloseCodeBadOperation: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
    CloseCodeDatatypeNotSupported: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
    CloseCodeGoingAway: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
    CloseCodeMissingExtension: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
    CloseCodeMissingStatusCode: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
    CloseCodeNormal: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
    CloseCodePolicyViolated: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
    CloseCodeProtocolError: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
    CloseCodeReserved1004: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
    CloseCodeTlsHandshakeFailed: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
    CloseCodeTooMuchData: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
    CloseCodeWrongDatatype: typing.ClassVar[QWebSocketProtocol.CloseCode] = ...
    Version0: typing.ClassVar[QWebSocketProtocol.Version] = ...
    Version13: typing.ClassVar[QWebSocketProtocol.Version] = ...
    Version4: typing.ClassVar[QWebSocketProtocol.Version] = ...
    Version5: typing.ClassVar[QWebSocketProtocol.Version] = ...
    Version6: typing.ClassVar[QWebSocketProtocol.Version] = ...
    Version7: typing.ClassVar[QWebSocketProtocol.Version] = ...
    Version8: typing.ClassVar[QWebSocketProtocol.Version] = ...
    VersionLatest: typing.ClassVar[QWebSocketProtocol.Version] = ...
    VersionUnknown: typing.ClassVar[QWebSocketProtocol.Version] = ...
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...

class QWebSocketServer(PySide2.QtCore.QObject):
    class SslMode:
        NonSecureMode: typing.ClassVar[QWebSocketServer.SslMode] = ...
        SecureMode: typing.ClassVar[QWebSocketServer.SslMode] = ...
        values: typing.ClassVar[dict] = ...
        name: typing.Any
        @classmethod
        def __init__(cls, *args, **kwargs) -> None: ...
        def __add__(self, other: typing.SupportsInt) -> QWebSocketServer.SslMode: ...
        def __and__(self, other: typing.SupportsInt) -> QWebSocketServer.SslMode: ...
        def __bool__(self) -> bool: ...
        def __eq__(self, other: object) -> bool: ...
        def __ge__(self, other: object) -> bool: ...
        def __gt__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> typing.Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other: object) -> bool: ...
        def __lt__(self, other: object) -> bool: ...
        def __mul__(self, other: typing.SupportsInt) -> QWebSocketServer.SslMode: ...
        def __ne__(self, other: object) -> bool: ...
        def __or__(self, other: typing.SupportsInt) -> QWebSocketServer.SslMode: ...
        def __pos__(self) -> typing.Any: ...
        def __radd__(self, other: typing.SupportsInt) -> QWebSocketServer.SslMode: ...
        def __rand__(self, other: typing.SupportsInt) -> QWebSocketServer.SslMode: ...
        def __rmul__(self, other: typing.SupportsInt) -> QWebSocketServer.SslMode: ...
        def __ror__(self, other: typing.SupportsInt) -> QWebSocketServer.SslMode: ...
        def __rsub__(self, other: typing.SupportsInt) -> QWebSocketServer.SslMode: ...
        def __rxor__(self, other: typing.SupportsInt) -> QWebSocketServer.SslMode: ...
        def __sub__(self, other: typing.SupportsInt) -> QWebSocketServer.SslMode: ...
        def __xor__(self, other: typing.SupportsInt) -> QWebSocketServer.SslMode: ...
    NonSecureMode: typing.ClassVar[QWebSocketServer.SslMode] = ...
    SecureMode: typing.ClassVar[QWebSocketServer.SslMode] = ...
    acceptError: typing.ClassVar[PySide2.QtCore.Signal] = ...
    closed: typing.ClassVar[PySide2.QtCore.Signal] = ...
    newConnection: typing.ClassVar[PySide2.QtCore.Signal] = ...
    originAuthenticationRequired: typing.ClassVar[PySide2.QtCore.Signal] = ...
    peerVerifyError: typing.ClassVar[PySide2.QtCore.Signal] = ...
    preSharedKeyAuthenticationRequired: typing.ClassVar[PySide2.QtCore.Signal] = ...
    serverError: typing.ClassVar[PySide2.QtCore.Signal] = ...
    sslErrors: typing.ClassVar[PySide2.QtCore.Signal] = ...
    staticMetaObject: typing.ClassVar[PySide2.QtCore.QMetaObject] = ...
    def __init__(self, serverName: str, secureMode: QWebSocketServer.SslMode, parent: typing.Union[PySide2.QtCore.QObject,None] = ..., destroyed: typing.Callable = ..., objectName: str = ..., objectNameChanged: typing.Callable = ...) -> None: ...
    def close(self) -> None: ...
    def error(self) -> QWebSocketProtocol.CloseCode: ...
    def errorString(self) -> str: ...
    def handleConnection(self, socket: PySide2.QtNetwork.QTcpSocket) -> None: ...
    def handshakeTimeoutMS(self) -> int: ...
    def hasPendingConnections(self) -> bool: ...
    def isListening(self) -> bool: ...
    def listen(self, address: PySide2.QtNetwork.QHostAddress = ..., port: int = ...) -> bool: ...
    def maxPendingConnections(self) -> int: ...
    def nativeDescriptor(self) -> int: ...
    def nextPendingConnection(self) -> QWebSocket: ...
    def pauseAccepting(self) -> None: ...
    def proxy(self) -> PySide2.QtNetwork.QNetworkProxy: ...
    def resumeAccepting(self) -> None: ...
    def secureMode(self) -> QWebSocketServer.SslMode: ...
    def serverAddress(self) -> PySide2.QtNetwork.QHostAddress: ...
    def serverName(self) -> str: ...
    def serverPort(self) -> int: ...
    def serverUrl(self) -> PySide2.QtCore.QUrl: ...
    def setHandshakeTimeout(self, msec: int) -> None: ...
    def setMaxPendingConnections(self, numConnections: int) -> None: ...
    def setNativeDescriptor(self, descriptor: int) -> bool: ...
    def setProxy(self, networkProxy: PySide2.QtNetwork.QNetworkProxy) -> None: ...
    def setServerName(self, serverName: str) -> None: ...
    def setSocketDescriptor(self, socketDescriptor: int) -> bool: ...
    def socketDescriptor(self) -> int: ...
    def supportedVersions(self) -> typing.List[QWebSocketProtocol.Version]: ...
