from PySide2.QtCore import Qt
from PySide2.QtWidgets import QDialog, QMessageBox, QWidget
from axipy import tr, CoordSystem

from .ui.bounding_rect_dialog import Ui_Dialog

precision = 6


class BoundingRectDialog(QDialog):

    def __init__(self, cs: CoordSystem, parent: QWidget = None) -> None:
        super().__init__(parent)

        self._ui = Ui_Dialog()
        self._ui.setupUi(self)

        self.setWindowFlags(self.windowFlags() & ~Qt.WindowContextHelpButtonHint)  # Выключение значка "?"

        self._cs = cs
        self._rect = cs.rect.to_qt()

        self._spin_boxes = (
            self._ui.xValueStart,
            self._ui.yValueStart,
            self._ui.xValueEnd,
            self._ui.yValueEnd,
        )

        for elem in self._spin_boxes:
            elem.setDecimals(precision)

        for elem, func in zip(self._spin_boxes, (
                self._rect.left,
                self._rect.bottom,
                self._rect.right,
                self._rect.top,
        )):
            elem.setValue(func())

    def read_rect_values(self) -> None:
        for elem, func in zip(self._spin_boxes, (
                self._rect.setLeft,
                self._rect.setBottom,
                self._rect.setRight,
                self._rect.setTop,
        )):
            func(elem.value())

    def accept(self) -> None:
        try:
            self.read_rect_values()
            self._cs.rect = self._rect
        except Exception as e:
            mbox = QMessageBox(
                QMessageBox.Critical,  # icon
                tr("Ошибка"),  # title
                str(e),  # text
                parent=self,
            )
            mbox.open()
        else:
            super().accept()
