import abc
from abc import ABC, abstractmethod
from typing import Tuple, Union

class CoordFormatter:
    def __init__(self) -> None: ...
    def as_float(self, value: str) -> Tuple[float, bool]: ...
    def as_string(self, value: float, precision: int = ..., suppress_trailing_zeros: bool = ...) -> str: ...
    def as_string_with_delimeter(self, value: float, delimeter: str, precision: int = ..., suppress_trailing_zeros: bool = ...) -> str: ...
    def double_to_rumb(self, value: float, precision: int = ..., suppress_trailing_zeros: bool = ...) -> str: ...
    def split_degree(self, value: float) -> Tuple[int, int, float]: ...

class _Coord(ABC, metaclass=abc.ABCMeta):
    def __init__(self, value: Union[float, int, str]) -> None: ...
    @property
    def value(self) -> float: ...
    def __int__(self) -> int: ...
    def __float__(self) -> float: ...
    @abstractmethod
    def as_string(self) -> str: ...
    def __bool__(self) -> bool: ...
    def __neg__(self) -> _Coord: ...
    def __pos__(self) -> _Coord: ...
    def __add__(self, other) -> _Coord: ...
    def __radd__(self, other) -> _Coord: ...
    def __sub__(self, other) -> _Coord: ...
    def __rsub__(self, other) -> _Coord: ...
    def __mul__(self, other) -> _Coord: ...
    def __rmul__(self, other) -> _Coord: ...
    def __truediv__(self, other) -> _Coord: ...
    def __rtruediv__(self, other) -> _Coord: ...
    def __floordiv__(self, other) -> _Coord: ...
    def __mod__(self, other) -> _Coord: ...
    def __lt__(self, other) -> bool: ...
    def __le__(self, other) -> bool: ...
    def __eq__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __ge__(self, other) -> bool: ...
