from _typeshed import Incomplete
from axipy._internal._metaclass import _MappingMetaDocumentation, _MappingMetaExtended
from axipy._internal._utils import _NoInitReadOnlyMeta
from typing import Any, Iterator, List, Optional, Tuple, Union

class _UnitBase(_NoInitReadOnlyMeta):
    class _DeprecDesc:
        def __set_name__(self, owner, name) -> None: ...
        def __init__(self) -> None: ...
        def __get__(self, obj, obj_type): ...
    km: Incomplete
    m: Incomplete
    mm: Incomplete
    cm: Incomplete
    mi: Incomplete
    nmi: Incomplete
    inch: Incomplete
    ft: Incomplete
    yd: Incomplete
    survey_ft: Incomplete
    li: Incomplete
    ch: Incomplete
    rd: Incomplete
    degree: Incomplete
    sq_mm: Incomplete
    sq_cm: Incomplete
    sq_m: Incomplete
    sq_km: Incomplete
    sq_mi: Incomplete
    sq_nmi: Incomplete
    sq_inch: Incomplete
    sq_ft: Incomplete
    sq_yd: Incomplete
    sq_survey_ft: Incomplete
    acre: Incomplete
    hectare: Incomplete
    sq_li: Incomplete
    sq_ch: Incomplete
    sq_rd: Incomplete
    perch: Incomplete
    rood: Incomplete
    class _DescAll:
        def __set_name__(self, owner, name) -> None: ...
        def __init__(self) -> None: ...
        def __get__(self, obj, objtype: Incomplete | None = ...): ...
    all_linear: Incomplete
    all_area: Incomplete

class Unit(_UnitBase):
    @property
    def name(self) -> str: ...
    @property
    def localized_name(self) -> str: ...
    @property
    def description(self) -> str: ...
    @property
    def conversion(self) -> float: ...
    def to_unit(self, unit: Union['LinearUnit', 'AreaUnit'], value: float = ...) -> float: ...

class LinearUnit(Unit):
    def __eq__(self, other): ...
    @classmethod
    def list_all(cls) -> List[LinearUnit]: ...
    @classmethod
    def by_name(cls, name: str) -> Optional['LinearUnit']: ...
    @staticmethod
    def from_area_unit(area_unit: AreaUnit): ...

class AreaUnit(Unit):
    def __eq__(self, other): ...
    @classmethod
    def list_all(cls) -> List[AreaUnit]: ...
    @classmethod
    def by_name(cls, name: str) -> Optional['AreaUnit']: ...
    @staticmethod
    def from_linear_unit(linear_unit: LinearUnit): ...

class _LinearUnitsMappingMetaExtended(_MappingMetaExtended):
    def __iter__(cls) -> Iterator: ...
    def __len__(cls) -> int: ...
    def __getitem__(cls, key): ...

class LinearUnits(_MappingMetaDocumentation, metaclass=_LinearUnitsMappingMetaExtended):
    class _KeysDesc:
        def __init__(self) -> None: ...
        def __get__(self, instance, owner): ...
    class _LinearDesc:
        def __set_name__(self, owner, name) -> None: ...
        def __init__(self) -> None: ...
        def __get__(self, obj, obj_type): ...
    km: LinearUnit
    m: LinearUnit
    mm: LinearUnit
    cm: LinearUnit
    mi: LinearUnit
    nmi: LinearUnit
    inch: LinearUnit
    ft: LinearUnit
    yd: LinearUnit
    survey_ft: LinearUnit
    li: LinearUnit
    ch: LinearUnit
    rd: LinearUnit
    degree: LinearUnit
    @classmethod
    def items(cls) -> List[Tuple[str, Any]]: ...
    @classmethod
    def keys(cls) -> List[str]: ...
    @classmethod
    def values(cls) -> List[Any]: ...
    @classmethod
    def get(cls, key: str, default_value: Any = ...): ...

class _AreaUnitsMappingMetaExtended(_MappingMetaExtended):
    def __iter__(cls) -> Iterator: ...
    def __len__(cls) -> int: ...
    def __getitem__(cls, key): ...

class AreaUnits(_MappingMetaDocumentation, metaclass=_AreaUnitsMappingMetaExtended):
    class _KeysDesc:
        def __init__(self) -> None: ...
        def __get__(self, instance, owner): ...
    class _AreaDesc:
        def __set_name__(self, owner, name) -> None: ...
        def __init__(self) -> None: ...
        def __get__(self, obj, obj_type): ...
    sq_mm: AreaUnit
    sq_cm: AreaUnit
    sq_m: AreaUnit
    sq_km: AreaUnit
    sq_mi: AreaUnit
    sq_nmi: AreaUnit
    sq_inch: AreaUnit
    sq_ft: AreaUnit
    sq_yd: AreaUnit
    sq_survey_ft: AreaUnit
    acre: AreaUnit
    hectare: AreaUnit
    sq_li: AreaUnit
    sq_ch: AreaUnit
    sq_rd: AreaUnit
    perch: AreaUnit
    rood: AreaUnit
    @classmethod
    def items(cls) -> List[Tuple[str, Any]]: ...
    @classmethod
    def keys(cls) -> List[str]: ...
    @classmethod
    def values(cls) -> List[Any]: ...
    @classmethod
    def get(cls, key: str, default_value: Any = ...): ...

class UnitValue:
    def __init__(self, value: float = ..., unit: Optional[Unit] = ...) -> None: ...
    @property
    def unit(self) -> Unit: ...
    @unit.setter
    def unit(self, unit: Unit): ...
    @property
    def value(self) -> float: ...
    @value.setter
    def value(self, value: float): ...
    def to_unit(self, unit) -> UnitValue: ...
    def __neg__(self): ...
    def __pos__(self): ...
    def __add__(self, other): ...
    def __radd__(self, other): ...
    def __sub__(self, other): ...
    def __rsub__(self, other): ...
    def __mul__(self, other): ...
    def __rmul__(self, other): ...
    def __truediv__(self, other): ...
    def __rtruediv__(self, other): ...
    def __eq__(self, other): ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...
